var DynaDate = {};
(function(){
	DynaDate = function(userConfig){
		var that = this;
		
		//Input ayant la date qui est modifiable par le dynadate
		that.baseElement = wasDeclared(userConfig.elem) ? typeof userConfig.elem === "string" ? $("#"+userConfig.elem) : userConfig.elem : null ;
		//Format de date à afficher dans le input.
		that.format = wasDeclared(userConfig.format) ? userConfig.format  : 'YYYY-MM-DD' ;
		//Langue à utiliser.
		that.locale =  wasDeclared(userConfig.locale) ? userConfig.locale  : 'fr' ;
		//Boolean si vrai l'input permet les dates dans le future. par defaut les dates dans le futures ne sont pas accépté.
		that.acceptFutureDate = wasDeclared(userConfig.acceptFutureDate) ? userConfig.acceptFutureDate  : false ;
		that.acceptPastDate = wasDeclared(userConfig.acceptPastDate) ? userConfig.acceptPastDate  : true ;
		//
		that.useCurrent = wasDeclared(userConfig.useCurrent) ? userConfig.useCurrent  : false ;
		that.hasCalendar = wasDeclared(userConfig.hasCalendar) ? userConfig.hasCalendar  : true ;
		that.defaultDate = wasDeclared(userConfig.defaultDate) ? userConfig.defaultDate  : null ;
		that.minDateElm = wasDeclared(userConfig.minDateElm) ? $("#"+userConfig.minDateElm)  : null ;
		that.maxDateElm = wasDeclared(userConfig.maxDateElm) ? $("#"+userConfig.maxDateElm)  : null ;
		that.dateDefault = wasDeclared(userConfig.maxDateElm) ? $("#"+userConfig.maxDateElm)  : null ;
		that.angularRefresh = wasDeclared(userConfig.angularRefresh) ?  userConfig.angularRefresh : null ;
		wasDeclared(userConfig.onDateBlur) ? this.onDateBlur = userConfig.onDateBlur :"" ;

		that.onDateInvalid = function(){if (!window.console) console.error = "Invalid date: either the date is in the future or the format is invalid."};
			new Error("An input id must be declared to bind with Dynamic date widget, no element was declared") ;
//		this.keyHandlers = wasDeclared(userConfig.keyHandlers) ? userConfig.keyHandlers  : [{keys: [], handle: function(){}}]; //Extra key functionality (onhold)
		that.currDate = new Date();
		that.isDate = wasDeclared(userConfig.isDate)? userConfig.isDate : (that.format!="HH:mm");
		that.getDefault = wasDeclared(userConfig.getDefault)? userConfig.getDefault : function(){};
		that.widgetPositioning = wasDeclared(userConfig.widgetPositioning)? userConfig.widgetPositioning : { horizontal: 'auto', vertical: 'auto'};
		that.onDateSelected = wasDeclared(userConfig.onDateSelected)? userConfig.onDateSelected : function(selectedDate){};
		that.setEditMode = wasDeclared(userConfig.setEditMode)? userConfig.setEditMode : function(v){};

		// prévoir une manière de switcher la langue... éventuellement
		var tooltips = [{
		    today: 'Go to today',
		    clear: 'Clear selection',
		    close: 'Close the picker',
		    selectMonth: 'Select Month',
		    prevMonth: 'Previous Month',
		    nextMonth: 'Next Month',
		    selectYear: 'Select Year',
		    prevYear: 'Previous Year',
		    nextYear: 'Next Year',
		    selectDecade: 'Select Decade',
		    prevDecade: 'Previous Decade',
		    nextDecade: 'Next Decade',
		    prevCentury: 'Previous Century',
		    nextCentury: 'Next Century'
		}, {
       	    today: "Aujourd'hui",
       	    clear: "Effacer",
       	    close: 'Fermer',
       	    selectMonth: 'Sélection du mois',
       	    prevMonth: 'Mois précédent',
       	    nextMonth: 'Mois suivant',
       	    selectYear: "Sélection de l'année",
       	    prevYear: 'Année précédente',
       	    nextYear: 'Année suivante',
       	    selectDecade: 'Sélection de la décade',
       	    prevDecade: 'Décade précédente',
       	    nextDecade: 'Décade suivante',
       	    prevCentury: 'Siècle précédent',
       	    nextCentury: 'Siècle suivant'
       	}];
		
		if(that.hasCalendar){
			that.baseElement.datetimepicker({
				format: that.format, locale:that.locale, useCurrent: that.useCurrent,
				showTodayButton: true, showClear: true,
				maxDate: (that.acceptFutureDate ? false : moment().endOf("day").toDate()),
				minDate: (that.acceptPastDate ? '0001-01-02T00:00:00Z' : moment().endOf("day").add(-1, 'days').toDate()),
				focusOnShow:true,
				widgetPositioning:that.widgetPositioning,
				keepOpen:true,
				tooltips: tooltips[1],
				stepping: (wasDeclared(userConfig.stepping)?userConfig.stepping:1),
			});
			
			that.baseElement.on('dp.change', function (ev) {
				dateSelected(ev.date);
			});
		}
		that.baseElement.on('show', function (ev) {
			that.setEditMode(true);
		});
		that.baseElement.on('hide', function (ev) {
			that.setEditMode(false);
		});
		
		if(wasDeclared(userConfig.onDateBlur)){
			that.baseElement.on('blur', function (ev) {
				console.log(that.currDate);
				that.onDateBlur(that.currDate);
			});
		}
		if (that.maxDateElm) {
			that.maxDateElm.on("dp.change", function (e) {
	            that.baseElement.data("DateTimePicker").maxDate(e.date);
	        });
		}
		if (that.minDateElm) {
			that.minDateElm.on("dp.change", function (e) {
				that.baseElement.data("DateTimePicker").minDate(e.date);
			});
		}
		that.setDefaultDate = function(dd) {
			that.baseElement.data("DateTimePicker").defaultDate(dd);
		};
		
		function wasDeclared(configEntry){
			return typeof configEntry !== 'undefined';
		}
		
		that.today = function(){
			return new Date();
		};
		
		that.plusDay = function(day){
			return moment(that.currDate).add(moment.duration(day, 'days'));
		};
		that.plusHour = function(day){
			return moment(that.currDate).add(moment.duration(day, 'days'));
		};
		
		that.plusWeek = function(week){
			return moment(that.currDate).add(moment.duration(week, 'weeks'));
		};
		
		that.plusMonth = function(months){
			return moment(that.currDate).add(moment.duration(months, 'months'));
		};
		
		that.plusYear = function(years){
			return moment(that.currDate).add(moment.duration(years, 'years'));
		};
		
		that.startMonth = function(){
			return moment(that.currDate).startOf('months');
		};
		
		that.endMonth = function(){
			return moment(that.currDate).endOf('months');
		};
		
		$(that.baseElement).keydown(function(e){handleKeyEvent(e)});
		$(that.baseElement).keypress(function(e){handleKeyEvent(e)});
		
		function handleKeyEvent(e){
			if (e.altKey || e.ctrlKey) {
				return;
			}
			var partDate = updateCurrIfNecessary();	// to set value if tab out
			var newDate = {};
			if(e.which >= 65 && e.which <= 90 ){
				if (e.which == 84 ) {//(t)today
					newDate = that.today();
				}else if(e.which == 68){//(d) default day
					newDate = that.getDefault();
				}else if(e.which == 88){//(x) plus one day
					newDate = that.plusDay(1);
				}else if(e.which == 90){//(z) minus one day
					newDate = that.plusDay(-1);
				}else if(e.which == 83){//(s) plus one week
					newDate = that.plusWeek(1);
				}else if(e.which == 65){//(a) minus one week
					newDate = that.plusWeek(-1);
				}else if(e.which == 87){//(w) plus one month
					newDate = that.plusMonth(1);
				}else if(e.which == 81){//(q) minus one month
					newDate = that.plusMonth(-1);
				}else if(e.which == 77){//(m) start of Month
					newDate = that.startMonth();
				}else if(e.which == 72){//(h) end of montH
					newDate = that.endMonth();
				}else if(e.which == 82){//(r) plus one year
					newDate = that.plusYear(1);
				}else if(e.which == 69){//(e) minus one year
					newDate = that.plusYear(-1);
				}else if(e.which == 73){//(i) idem date liée
					if(that.minDateElm){
						newDate = $(that.minDateElm.selector).val();
					}
				}else{
//					print = false;
					eventHandled(e);
					return;	// sinon, toutes les lettres mettent today!
				}
				if(newDateValid(newDate)){
					eventHandled(e);
					that.currDate = newDate;
					that.printDate();
//					dateSelected(that.currDate);	// mis dans le dp.change ci-haut - ligne 63
				}else{
					eventHandled(e);
					that.onDateInvalid();
				}
			}else if(e.which == 9 && that.isDate){//Complete partial dates if they are entered
				$(that.baseElement).val(partDate);
				var nDate = partialDate(partDate);
				if(!$.isEmptyObject(nDate) && newDateValid(nDate)) {
					that.currDate = nDate;
					that.printDate();
					dateSelected(that.currDate);
				}
			}
		}
		
		function dateSelected(dateSelected){
			that.onDateSelected(dateSelected, that);
			if(that.angularRefresh){
				that.angularRefresh();
			}
		}
		
		//Get full date from a partial date: Works only with numbers with a length of less than 7
		//If user enters 12 the output date will be 12th date of the current month and year
		//If the user enters 4 chiffres the output date will be the year
		//If the user enters 5 ou 6 chiffes the output date will be the year and the month
		function partialDate(input){
			input = input.trim();
			if($.isEmptyObject(input) || input.length > 7)return;
			
			if(input.length < 3){
				var mDate = parseInt(input);
				if(mDate < 32){
					return moment().date(mDate);
				}
			}else if(input.length <= 7){
				var year = parseInt(input.substring(0, 4));
				var yMonth = 0;
				if (input.length>=5) {
					yMonth = Math.abs(parseInt(input.substring(4, input.length)));
				}
				yMonth = yMonth>12?12:yMonth;
				var inputField = $(that.baseElement);
				if (yMonth<1) {
					inputField.val(year);
				} else {
					inputField.val(year+"-"+ (yMonth<10?'0':'')+yMonth);
				}
				inputField.trigger('input'); // Use for Chrome/Firefox/Edge
				inputField.trigger('change'); // Use for Chrome/Firefox/Edge + IE11					
			}
		}
		
		function updateCurrIfNecessary(){
			var temp = $(that.baseElement).val().replace(/\D/g,'');
			var format = "YYYY-MM-DD";
			var iLen = temp.length;
			var inputString = temp;
			if (iLen>=6) {
				inputString = temp.substr(0,4) + '-' + temp.substr(4,2);
				if (iLen>=8) {
					inputString += '-' + temp.substr(6,2);
					if (iLen>8) {
						temp = temp.substr(8);
						iLen = temp.length;
						if (iLen<4) {
							temp = temp + '0000'.substr(4-iLen);
						}
						inputString += 'T' + temp.substr(0, 2) +":" + temp.substr(2,2);
						format = "YYYY-MM-DD hh:mm";
					}
 				}
				if (inputString.length>=10) {
					var inputDate = moment(inputString, format);
					if(inputDate.isValid() && moment(that.currDate).isValid() && moment(inputDate).diff(that.currDate, 'days') != 0){
						that.currDate = inputDate;
					}
				}
			}else if(iLen === 0){
				//reset the date to default if a default is declared or to today.
				var def = that.getDefault();
				that.currDate = moment(def).isValid() ? def: new Date();
			}
			return inputString;
		}
		
		function newDateValid(newdate){
			var newDateValue = moment(newdate);
			if(!newDateValue.isValid()){
				return false;
			}else if(!that.acceptFutureDate && newDateValue.isAfter(moment(), 'day')){
				return false;
			}
			var minmax = true;
			if(that.maxDateElm ){
				var afterDate = $(that.maxDateElm.selector).val();
				if(!$.isEmptyObject(afterDate)){
					if(moment(afterDate, that.format).isBefore(newDateValue, 'minute'))return false;
				}
			}
			if(that.minDateElm){
				var beforeDate = $(that.minDateElm.selector).val();
				if(!$.isEmptyObject(beforeDate)){
					if(moment(beforeDate, that.format).isAfter(newDateValue, 'minute')) return false;
				}
			}
			return true;
		}
		
//		function handleExtraKeyEvent(e){ //Extra key functionnality (onhold)
//			for (var i = 0; i < this.keyHandlers; i++) {
//				var valid
//			   
//			}
//		}
		
		that.printDate = function(){
			if(that.hasCalendar){
				that.baseElement.data("DateTimePicker").date(moment(that.currDate));
			}
			var input = $(that.baseElement);
			input.val(moment(that.currDate).format(that.format));
			//Pour supporter angular activer le changement
			input.trigger('input'); // Use for Chrome/Firefox/Edge
		    input.trigger('change'); // Use for Chrome/Firefox/Edge + IE11
		}
		
		function eventHandled(e){
			e.preventDefault();
			e.stopPropagation();
			e.stopImmediatePropagation();
		}
	};
})();