/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.prevalidator;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XMeasurement;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;

public class MeasurementPreValidator
implements IPreValidator {
    private StringBuilder error = new StringBuilder();

    @Override
    public boolean validForDelete(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    @Override
    public boolean validForEdition(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    @Override
    public boolean validForSave(EditableDataObject dataObject, EditableDataObject editorInput) {
        XMeasurement measurement = (XMeasurement)dataObject;
        boolean valid = true;
        this.error = new StringBuilder();
        if (measurement.getWeight() != null && measurement.getWeight().intValue() < 0) {
            this.error = this.error.append(Messages.getString("ENTREZ_POIDS", new String[0])).append("\r\n");
            valid = false;
        }
        if (measurement.getHeight() != null && measurement.getHeight().intValue() < 0) {
            this.error = this.error.append(Messages.getString("ENTREZ_TAILLE", new String[0])).append("\r\n");
            valid = false;
        }
        if (measurement.getWaistMeasurement() != null && measurement.getWaistMeasurement().intValue() < 0) {
            this.error = this.error.append(Messages.getString("ENTREZ_TOUR_TAILLE", new String[0])).append("\r\n");
            valid = false;
        }
        if (this.error.length() > 0) {
            this.error = this.error.insert(0, Messages.getString("EXAMINATION_MENSURATION", new String[0]) + "\r\n");
        }
        return valid;
    }

    @Override
    public String getError() {
        return this.error == null ? "" : this.error.toString();
    }
}

