/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.pdf;

import ca.infodata.util1.StringUtils;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;

class TablePdfNumeration
extends PdfPageEventHelper {
    PdfTemplate total;
    private Font normal;
    private Font normalSmall;
    private String footerText;

    public TablePdfNumeration() {
        try {
            this.normal = new Font(2, 8.0f, 0, Color.black);
            this.normalSmall = new Font(2, 8.0f, 0, Color.black);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(30.0f, 12.0f);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfPTable table = new PdfPTable(3);
        try {
            table.setWidths(new int[]{24, 24, 1});
            table.getDefaultCell().setFixedHeight(10.0f);
            table.getDefaultCell().setBorder(1);
            PdfPCell cell = new PdfPCell();
            cell.setBorder(0);
            cell.setBorderWidthTop(1.0f);
            cell.setHorizontalAlignment(0);
            cell.setPhrase(new Phrase(StringUtils.defaultString((String)this.footerText), this.normalSmall));
            table.addCell(cell);
            cell = new PdfPCell();
            cell.setBorder(0);
            cell.setBorderWidthTop(1.0f);
            cell.setHorizontalAlignment(2);
            cell.setPhrase(new Phrase(String.format("Page %d de", writer.getPageNumber()), this.normal));
            table.addCell(cell);
            cell = new PdfPCell(Image.getInstance((PdfTemplate)this.total));
            cell.setBorder(0);
            cell.setBorderWidthTop(1.0f);
            table.addCell(cell);
            table.setTotalWidth(document.getPageSize().getWidth() - document.leftMargin() - document.rightMargin());
            table.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin() - 15.0f, writer.getDirectContent());
        }
        catch (DocumentException de) {
            throw new ExceptionConverter((Exception)((Object)de));
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        ColumnText.showTextAligned((PdfContentByte)this.total, (int)0, (Phrase)new Phrase(String.valueOf(writer.getPageNumber() - 1), this.normal), (float)2.0f, (float)2.0f, (float)0.0f);
    }

    public String getFooterText() {
        return this.footerText;
    }

    public void setFooterText(String footerText) {
        this.footerText = footerText;
    }
}

