/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.patient;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextSearchCriteria {
    private static final Logger logger = Logger.getLogger(TextSearchCriteria.class.getName());
    private LocalDate birthdate;
    private String phone;
    private String[] recordNumber;
    private String nam;
    private String identifier;
    private List<String[]> names;
    private final int systemRecordNumberLength;

    public TextSearchCriteria(int systemRecordNumberLength) {
        this.systemRecordNumberLength = systemRecordNumberLength;
    }

    public void reset() {
        this.birthdate = null;
        this.phone = null;
        this.recordNumber = null;
        this.nam = null;
        this.identifier = null;
        this.names = null;
    }

    public void parse(String ptext) {
        try {
            this.parse2(ptext);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to parse " + ptext, e);
        }
    }

    private void parse2(String ptext) throws Exception {
    }

    private void setNamesCriteria(List<String> pnames) {
        this.names = new ArrayList<String[]>();
        if (pnames != null == pnames.size() > 0) {
            String[][] permutations;
            switch (pnames.size()) {
                case 1: {
                    permutations = new String[][]{{pnames.get(0)}};
                    break;
                }
                case 2: {
                    permutations = new String[][]{{pnames.get(0), pnames.get(1)}, {pnames.get(0) + " " + pnames.get(1)}};
                    break;
                }
                case 3: {
                    permutations = new String[][]{{pnames.get(0) + " " + pnames.get(1), pnames.get(2)}, {pnames.get(0) + " " + pnames.get(1) + " " + pnames.get(2)}, {pnames.get(0), pnames.get(1) + " " + pnames.get(2)}};
                    break;
                }
                case 4: {
                    permutations = new String[][]{{pnames.get(0) + " " + pnames.get(1), pnames.get(2) + " " + pnames.get(3)}, {pnames.get(0) + " " + pnames.get(1) + " " + pnames.get(2), pnames.get(3)}, {pnames.get(0), pnames.get(1) + " " + pnames.get(2) + " " + pnames.get(3)}};
                    break;
                }
                default: {
                    permutations = null;
                }
            }
            if (permutations != null && permutations.length > 0) {
                for (String[] permutation : permutations) {
                    String addPourcentage0;
                    String[] p = permutation;
                    int plen = p.length;
                    if (plen == 1) {
                        addPourcentage0 = "%";
                        if (p[0].endsWith(".")) {
                            addPourcentage0 = "";
                            p[0] = p[0].substring(0, p[0].length() - 1);
                        }
                        String value = StringUtils.convertNonAscii((String)p[0]).replaceAll("[^\\p{ASCII}]", "") + addPourcentage0;
                        this.names.add(new String[]{value});
                        continue;
                    }
                    if (plen == 2) {
                        addPourcentage0 = "%";
                        if (p[0].endsWith(".")) {
                            addPourcentage0 = "";
                            p[0] = p[0].substring(0, p[0].length() - 1);
                        }
                        String value0 = StringUtils.convertNonAscii((String)p[0]).replaceAll("[^\\p{ASCII}]", "") + addPourcentage0;
                        String addPourcentage1 = "%";
                        if (p[1].endsWith(".")) {
                            addPourcentage1 = "";
                            p[1] = p[1].substring(0, p[1].length() - 1);
                        }
                        String value1 = StringUtils.convertNonAscii((String)p[1]).replaceAll("[^\\p{ASCII}]", "") + addPourcentage1;
                        this.names.add(new String[]{value0, value1});
                        this.names.add(new String[]{value1, value0});
                        continue;
                    }
                    throw new RuntimeException("name permutations of more than 2 items is not supported");
                }
            }
        }
    }

    private void setOtherIdentifier(String text) {
        this.identifier = text.toUpperCase();
    }

    private void setNAMCriteria(String part) {
        String text = StringUtils.convertNonAscii((String)part).replaceAll("[^\\p{ASCII}]", "");
        this.nam = text + "%";
    }

    private void setRecordNumberCriteria(String part) {
        if (part.length() < this.systemRecordNumberLength && !part.startsWith("#") && !part.startsWith("*")) {
            this.recordNumber = new String[2];
            this.recordNumber[0] = part;
            this.recordNumber[1] = StringUtils.leftPad((String)part, (int)this.systemRecordNumberLength, (char)'0');
        } else {
            this.recordNumber = new String[1];
            this.recordNumber[0] = part;
        }
    }

    private void setPhoneCriteria(String part) {
        this.phone = part.length() == 7 ? "%" + part : (part.length() == 10 ? part : "%" + part + "%");
    }

    public LocalDate getBirthdate() {
        return this.birthdate;
    }

    public String getPhone() {
        return this.phone;
    }

    public String[] getRecordNumber() {
        return this.recordNumber;
    }

    public String getNam() {
        return this.nam;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<String[]> getNames() {
        return this.names;
    }

    public String toString() {
        return String.format("TextSearchCriteria [birthdate=%s, phone=%s, recordNumber=%s, nam=%s, identifier=%s, names=%s]", this.birthdate, this.phone, this.recordNumber, this.nam, this.identifier, this.names);
    }
}

