/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.medication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MedCalc {
    public static String msg = "";
    public static HashMap<String, List<String>> units = new HashMap();

    public static Double Round(Number value, int digits) {
        Double d = null;
        if (value == null) {
            return null;
        }
        if (digits == 0) {
            d = new Double((double)Math.round(value.floatValue() * 1.0f) / 1.0);
        }
        if (digits == 1) {
            d = new Double((double)Math.round(value.floatValue() * 10.0f) / 10.0);
        }
        if (digits == 2) {
            d = new Double((double)Math.round(value.floatValue() * 100.0f) / 100.0);
        }
        if (digits == 3) {
            d = new Double((double)Math.round(value.floatValue() * 1000.0f) / 1000.0);
        }
        return d;
    }

    public static List<String> getListForTest(String test) {
        return units.get(test);
    }

    public static Double HypoCaAlb(double ca, double alb1, double alb2) {
        double ca_conv = 4.0;
        double alb_conv = 0.1;
        double a = ca * 4.0;
        double b = alb1 * 0.1;
        double c = alb2 * 0.1;
        double value = (0.8 * (b - c) + a) / 4.0;
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double BMI(double wt, double ht) {
        double wt_conv = 1.0;
        double ht_conv = 0.01;
        double a = wt * 1.0;
        double b = ht * 0.01;
        double value = a / Math.pow(b, 2.0);
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double IMC(Float weight, Float height) {
        Double result = null;
        if (weight != null && height != null && weight.floatValue() > 5.0f && height.floatValue() > 75.0f) {
            result = (double)weight.floatValue() / Math.pow(height.floatValue() / 100.0f, 2.0);
        }
        return result;
    }

    public static Double BodySurfArea(double wt, double ht) {
        double value = 0.007184 * Math.pow(ht, 0.725) * Math.pow(wt, 0.425);
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double poidsMaigre(int sex, int age, double wt, int ht) {
        double[] dArray;
        if (age < 14) {
            double value = 3.8 * (0.0215 * Math.pow(wt, 0.6469) * Math.pow(ht, 0.7236));
            return MedCalc.Round(new Double(value), 1);
        }
        if (sex == 0) {
            double[] dArray2 = new double[2];
            dArray2[0] = 1.1;
            dArray = dArray2;
            dArray2[1] = 128.0;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 1.07;
            dArray = dArray3;
            dArray3[1] = 148.0;
        }
        double[] s = dArray;
        double value = s[0] * wt - s[1] * Math.pow(wt / (double)ht, 2.0);
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double AnionGap(double na, double cl, double hco3) {
        Double value = new Double(na - cl - hco3);
        value = MedCalc.Round(value, 1);
        double nl = 12.0;
        value = value - 12.0 <= 0.0 ? new Double(12.0) : MedCalc.Round(new Double(value - 12.0), 1);
        return value;
    }

    public static Double FENA(double na_s, double na_u, double cr_s, double cr_u) {
        double value = 100.0 * na_u * cr_s / (na_s * cr_u);
        return MedCalc.Round(new Double(value), 2);
    }

    public static Double AaGrad(double pa02, double pac02, double fi02, double atm) {
        double h20 = 6.27;
        double value = fi02 / 100.0 * (atm - 6.27) - pac02 / 0.8 - pa02;
        return MedCalc.Round(new Double(value), 2);
    }

    public static Double SerumOsm(double na, double k, double bun, double glu) {
        double bun_conv = 2.801120448179272;
        double glu_conv = 18.01801801801802;
        double value = 2.0 * (na + k) + (bun *= 2.801120448179272) / 2.8 + (glu *= 18.01801801801802) / 18.0;
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double BasalEnergy(int sexe, double wt, double ht, double age) {
        double ht_conv = 1.0;
        double wt_conv = 1.0;
        double value = 0.0;
        value = sexe == 0 ? 66.5 + 13.75 * wt + 5.003 * ht - 6.775 * age : 655.1 + 9.563 * (wt *= 1.0) + 1.85 * (ht *= 1.0) - 4.676 * age;
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double MDRD(int sexe, int ageInt, boolean isBlack, int crInt) {
        double age = Math.pow(ageInt, -0.203);
        double cr = Math.pow((double)crInt / 88.4, -1.154);
        double race = 1.0;
        double sex = 1.0;
        if (isBlack) {
            race = 1.21;
        }
        if (sexe == 1) {
            sex = 0.742;
        }
        double value = 3.1 * cr * age * sex * race * 60.0;
        return MedCalc.Round(new Double(value), 0);
    }

    public static Double MAP(int sbp, int dbp) {
        double value = 0 * dbp + 0 * sbp;
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double BicarbDeficit(double wt, double hco3) {
        double wt_conv = 1.0;
        double value = 0.4 * (wt *= 1.0) * (24.0 - hco3);
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double CorrectedNa(int na, double glu) {
        boolean na_conv = true;
        double glu_conv = 18.01801801801802;
        double value = (double)(na *= 1) + 0.016 * ((glu *= 18.01801801801802) - 100.0);
        return MedCalc.Round(new Double(value), 0);
    }

    public static Double LDL(double tc, double hdl, double trig) {
        double chol_conv = 1.0;
        double trig_conv = 1.0;
        double value = (tc *= 1.0) - (hdl *= 1.0) - (trig *= 1.0) / 5.0;
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double SodiumDeficit(int sexe, double wt, double na_s, double na_nl) {
        double wt_conv = 1.0;
        double tbw = sexe == 1 ? 0.5 : 0.6;
        double value = tbw * (wt *= 1.0) * (na_s - na_nl);
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double WaterDeficit(int sexe, double wt, double na, double na_pt) {
        double wt_conv = 1.0;
        double tbw = sexe == 1 ? 0.5 : 0.6;
        double value = tbw * (wt *= 1.0) * (na - na_pt) / na_pt;
        return MedCalc.Round(new Double(value), 1);
    }

    public static Double StoolOsm(double na, double k, double osm) {
        double value = osm - 2.0 * (na + k);
        return MedCalc.Round(new Double(value), 1);
    }

    public static String[] StrepProbability(int age, boolean exudate, boolean tender, boolean fever, boolean cough) {
        String[] rep = new String[]{"", ""};
        double score = 0.0;
        if (exudate) {
            score += 1.0;
        }
        if (tender) {
            score += 1.0;
        }
        if (fever) {
            score += 1.0;
        }
        if (cough) {
            score += 1.0;
        }
        if (score == -1.0) {
            rep = new String[]{"1% - 2.5%", ": No further testing or antibiotics."};
        }
        if (score == 0.0) {
            rep = new String[]{"1% - 2.5%", ": No further testing or antibiotics."};
        }
        if (score == 1.0) {
            rep = new String[]{"5% - 10%", ": No further testing or antibiotics."};
        }
        if (score == 2.0) {
            rep = new String[]{"11% - 17%", ": Culture all, antibiotics only for positive culture results."};
        }
        if (score == 3.0) {
            rep = new String[]{"28% - 35%", ": Culture all, antibiotics only for positive culture results."};
        }
        if (score > 3.0) {
            rep = new String[]{"51% - 53%", ": Treat empirically with antibioitics and/or culture."};
        }
        return rep;
    }

    public static Double MELD(double bili, double inr, double cr, boolean hdChecked) {
        double cr_conv = 0.011312217194570135;
        double bili_conv = 0.05847953216374269;
        bili *= 0.05847953216374269;
        cr *= 0.011312217194570135;
        double hd = 12.0;
        if (hdChecked) {
            hd = 1.0;
        }
        double value = 10.0 * (0.378 * Math.log(bili) + 1.12 * Math.log(inr) + 0.957 * Math.log(4.0) + 0.643);
        value = MedCalc.Round(new Double(value), 0);
        if (hd == 12.0) {
            value = 10.0 * (0.378 * Math.log(bili) + 1.12 * Math.log(inr) + 0.957 * Math.log(cr) + 0.643);
            value = MedCalc.Round(new Double(value), 0);
        }
        return new Double(value);
    }

    public static Double CockcroftGault(int sexe, int age, double wt, double cr) {
        double sex = 1.0;
        if (sexe == 1) {
            sex = 0.85;
        }
        double value = 0.0205 * sex * (double)(140 - age) * wt / cr * 60.0;
        return MedCalc.Round(new Double(value), 0);
    }

    public static Double[] Parkland(double wt, double percent) {
        Double[] ret = new Double[2];
        double wt_conv = 1.0;
        double value = (wt *= 1.0) * percent * 4.0 / 1000.0;
        double value2 = value / 2.0;
        ret[0] = MedCalc.Round(new Double(value), 0);
        ret[1] = MedCalc.Round(new Double(value2), 0);
        return ret;
    }

    public static String Winters(double hco3) {
        double value = 1.5 * hco3 + 8.0;
        value = Math.round(value * 1.0) / 1L;
        double high = value + 2.0;
        double low = value - 2.0;
        String range = low + "-" + high;
        return range;
    }

    public static String TIMIScoreUA(int age, boolean rfs, boolean cad, boolean asa, boolean angina, boolean st, boolean poz) {
        double score = 0.0;
        if (age > 70) {
            score += 1.0;
        }
        if (rfs) {
            score += 1.0;
        }
        if (cad) {
            score += 1.0;
        }
        if (asa) {
            score += 1.0;
        }
        if (angina) {
            score += 1.0;
        }
        if (st) {
            score += 1.0;
        }
        if (poz) {
            score += 1.0;
        }
        if (score <= 1.0) {
            msg = "5% risk at 14 days of: all-cause mortality, new or recurrent MI, or severe recurrent ischemia requiring urgent revascularization.";
        }
        if (score == 2.0) {
            msg = "8% risk at 14 days of: all-cause mortality, new or recurrent MI, or severe recurrent ischemia requiring urgent revascularization.";
        }
        if (score == 3.0) {
            msg = "13% risk at 14 days of: all-cause mortality, new or recurrent MI, or severe recurrent ischemia requiring urgent revascularization.";
        }
        if (score == 4.0) {
            msg = "20% risk at 14 days of: all-cause mortality, new or recurrent MI, or severe recurrent ischemia requiring urgent revascularization.";
        }
        if (score == 5.0) {
            msg = "26% risk at 14 days of: all-cause mortality, new or recurrent MI, or severe recurrent ischemia requiring urgent revascularization.";
        }
        if (score > 5.0) {
            msg = "41% risk at 14 days of: all-cause mortality, new or recurrent MI, or severe recurrent ischemia requiring urgent revascularization.";
        }
        return msg;
    }

    public static String TIMIScoreSTEMI(int age, boolean rfs, boolean bp, boolean hr, boolean killip, double wt, double ste, double time) {
        String msg = "";
        if (age > 50) {
            double score = age;
            if (rfs) {
                score += 1.0;
            }
            if (bp) {
                score += 3.0;
            }
            if (hr) {
                score += 2.0;
            }
            if (killip) {
                score += 2.0;
            }
            if (wt > 90.0) {
                score += 1.0;
            }
            if (ste > 10.0) {
                score += 1.0;
            }
            if (time > 120.0) {
                score += 1.0;
            }
            double value = score;
            value = MedCalc.Round(new Double(value), 1);
            if (score == 0.0) {
                msg = "0.8% risk of all-cause mortality at 30 days.";
            }
            if (score == 1.0) {
                msg = "1.6% risk of all-cause mortality at 30 days.";
            }
            if (score == 2.0) {
                msg = "2.2% risk of all-cause mortality at 30 days.";
            }
            if (score == 3.0) {
                msg = "4.4% risk of all-cause mortality at 30 days.";
            }
            if (score == 4.0) {
                msg = "7.3% risk of all-cause mortality at 30 days.";
            }
            if (score == 5.0) {
                msg = "12.4% risk of all-cause mortality at 30 days.";
            }
            if (score == 6.0) {
                msg = "16.1% risk of all-cause mortality at 30 days.";
            }
            if (score == 7.0) {
                msg = "23.4% risk of all-cause mortality at 30 days.";
            }
            if (score == 8.0) {
                msg = "26.8% risk of all-cause mortality at 30 days.";
            }
            if (score > 8.0) {
                msg = "35.9% risk of all-cause mortality at 30 days.";
            }
        }
        return msg;
    }

    public static String CHADS2(int age, boolean chf, boolean htn, boolean dm, boolean stroke) {
        String msg = "";
        int score = 0;
        if (age > 70) {
            ++score;
        }
        if (chf) {
            ++score;
        }
        if (htn) {
            ++score;
        }
        if (dm) {
            ++score;
        }
        if (stroke) {
            score += 5;
        }
        if (score == 0) {
            msg = "Low risk of thromboembolic event. 0.49% risk of event per year if no coumadin.";
        }
        if (score == 1) {
            msg = "Intermediate risk of thromboembolic event. 1.5% risk of event per year if no coumadin.";
        }
        if (score == 2) {
            msg = "Intermediate risk of thromboembolic event. 2.5% risk of event per year if no coumadin.";
        }
        if (score == 3) {
            msg = "High risk of thromboembolic event. 5.3% risk of event per year if no coumadin.";
        }
        if (score == 4) {
            msg = "High risk of thromboembolic event. 6.0% risk of event per year if no coumadin.";
        }
        if (score > 4) {
            msg = "High risk of thromboembolic event. 6.9% risk of event per year if no coumadin.";
        }
        return msg;
    }

    static {
        ArrayList<String> ca = new ArrayList<String>();
        ca.add("Calcium");
        ca.add("99.99");
        ca.add("mmol/L");
        units.put("ca", ca);
        ArrayList<String> alb = new ArrayList<String>();
        alb.add("Albumine");
        alb.add("99");
        alb.add("g/L");
        units.put("alb", alb);
        ArrayList<String> chol = new ArrayList<String>();
        chol.add("Cholesterol");
        chol.add("99.99");
        chol.add("mmol/L");
        units.put("chol", chol);
        ArrayList<String> trig = new ArrayList<String>();
        trig.add("Triglyceride");
        trig.add("99.9");
        trig.add("mmol/L");
        units.put("trig", trig);
        ArrayList<String> glu = new ArrayList<String>();
        glu.add("Glycemie");
        glu.add("99.9");
        glu.add("mmol/L");
        units.put("glu", glu);
        ArrayList<String> hct = new ArrayList<String>();
        hct.add("Hematocrite");
        hct.add("99");
        hct.add("fraction de GR");
        units.put("hct", hct);
        ArrayList<String> hgb = new ArrayList<String>();
        hgb.add("Hemoglobine");
        hgb.add("999");
        hgb.add("mmol/L");
        units.put("hgb", hgb);
        ArrayList<String> na = new ArrayList<String>();
        na.add("Sodium");
        na.add("999");
        na.add("mmol/L");
        units.put("na", na);
        ArrayList<String> k = new ArrayList<String>();
        k.add("Potassium");
        k.add("9.9");
        k.add("mmol/L");
        units.put("k", k);
        ArrayList<String> cl = new ArrayList<String>();
        cl.add("Chlore");
        cl.add("999");
        cl.add("mmol/L");
        units.put("cl", cl);
        ArrayList<String> hco3 = new ArrayList<String>();
        hco3.add("Bicarbonate");
        hco3.add("99.9");
        hco3.add("mmol/L");
        units.put("hco3", hco3);
        ArrayList<String> bun = new ArrayList<String>();
        bun.add("Uree");
        bun.add("999.9");
        bun.add("mmol/L");
        units.put("bun", bun);
        ArrayList<String> cr = new ArrayList<String>();
        cr.add("Creatinine");
        cr.add("99");
        cr.add("\u00b5mol/L");
        units.put("cr", cr);
        ArrayList<String> wt = new ArrayList<String>();
        wt.add("Poids (kg)");
        wt.add("999");
        wt.add("kg");
        units.put("wt", wt);
        ArrayList<String> ht = new ArrayList<String>();
        ht.add("Taille (cm)");
        ht.add("999");
        ht.add("cm");
        units.put("ht", ht);
        ArrayList<String> crcl = new ArrayList<String>();
        crcl.add("Clearance de la creatinine");
        crcl.add("99.9");
        crcl.add("mL/m");
        units.put("crclearance", crcl);
        ArrayList<String> bili = new ArrayList<String>();
        bili.add("Bilirubine");
        bili.add("999.9");
        bili.add("\u00b5mol/L");
        units.put("bili", bili);
        ArrayList<String> nadef = new ArrayList<String>();
        nadef.add("Deficit en Na");
        nadef.add("999");
        nadef.add("mmol/L");
        units.put("na-deficit", nadef);
        ArrayList<String> osm = new ArrayList<String>();
        osm.add("Osmolalite");
        osm.add("999.9");
        osm.add("mmoI/kg");
        units.put("osm", osm);
        ArrayList<String> pa02 = new ArrayList<String>();
        pa02.add("PA-O2");
        pa02.add("999");
        pa02.add("kPa");
        units.put("pa02", pa02);
        ArrayList<String> bsa = new ArrayList<String>();
        bsa.add("bsa");
        bsa.add("9.99");
        bsa.add("m2");
        units.put("bsa", bsa);
        ArrayList<String> bmi = new ArrayList<String>();
        bmi.add("bmi");
        bmi.add("99");
        bmi.add("");
        units.put("bmi", bmi);
    }
}

