/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.text.ParseException;

public class Age
implements Comparable<Age> {
    private static final String MOIS = " " + Messages.getString("MOIS", new String[0]).toLowerCase();
    private static final String JOURS = " " + Messages.getString("JOURS", new String[0]).toLowerCase();
    private static final String JOUR = " " + Messages.getString("JOUR", new String[0]).replace(":", "").toLowerCase();
    private static final String ANS = " " + Messages.getString("Client.AGE_ANS", new String[0]).toLowerCase();
    private static final String AN = " " + Messages.getString("Client.AGE_ANS", new String[0]).replace("s", "").toLowerCase();
    public int years;
    public int months;
    public int days;
    public int totalMonths;
    public int totalDays;

    public static String formatMonthDay(LocalDate birthdate, LocalDate date) {
        StringBuilder s = new StringBuilder();
        int m = date.getMonthDiff(birthdate);
        if (m != 0) {
            s.append(m).append(MOIS);
        }
        if (date.day != birthdate.day) {
            int d = 0;
            if (date.day > birthdate.day) {
                d = date.day - birthdate.day;
            } else if (date.day < birthdate.day) {
                d = date.day + date.plusMonth(-1).getMonthEnd() - birthdate.day;
            }
            s.append(" ").append(d).append(d == 1 || d == -1 ? JOUR : JOURS);
        }
        return s.toString();
    }

    public static String formatYearMonth(LocalDate birthdate, LocalDate date) {
        StringBuilder s = new StringBuilder();
        int m = date.getMonthDiff(birthdate);
        if (m > 12) {
            int y = m / 12;
            s.append(y).append(y == 1 || y == -1 ? AN : ANS);
        }
        if ((m %= 12) != 0) {
            s.append(" ").append(m).append(MOIS);
        }
        return s.toString();
    }

    protected static LocalDate parse(String s) {
        try {
            return LocalDateFormat.parseWithFixedFormats((String)s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Age(int years, int months, int days, int totalMonths, int totalDays) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.totalMonths = this.years * 12 + months;
    }

    public String formatMonthDay() {
        return this.format(true, false);
    }

    public String formatYearMonth() {
        return this.format(false, true);
    }

    public String format(boolean convertYearToMonth, boolean roundDayToMonth) {
        String s = "";
        int y = this.years;
        int m = this.months;
        int d = this.days;
        if (convertYearToMonth) {
            m += y * 12;
            y = 0;
        }
        if (roundDayToMonth) {
            if (d > 20) {
                ++m;
            }
            if (d < -20) {
                --m;
            }
            d = 0;
        }
        if (y != 0) {
            s = y > 1 || y < -1 ? s + y + ANS : s + y + AN;
        }
        if (m != 0) {
            s = s + " " + m + MOIS;
        }
        if (d != 0) {
            s = d > 1 || d < -1 ? s + " " + d + JOURS : s + " " + d + JOUR;
        }
        return s;
    }

    public String toString() {
        return "Age [" + this.years + "y, " + this.months + "m, " + this.days + "d]";
    }

    @Override
    public int compareTo(Age o2) {
        int i = this.years - o2.years;
        if (i == 0 && (i = this.months - o2.months) == 0) {
            i = this.days - o2.days;
        }
        return i;
    }
}

