/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumer;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.dataaccess.util.notification.NotificationHandler;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.BasicConsumeTask;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.BasicPublishTask;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.LocalConsumeTask;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqConnection;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqThreadFactory;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.chat.XCourrielTexte;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.notification.PresenceNotification;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.ConcurrentHashSet;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mb.listeners.GenListenerManager;

public class RabbitMqConsumer2
implements IConsumer {
    private static final Logger logger = Logger.getLogger(RabbitMqConsumer2.class.getName());
    private final GenListenerManager<IConsumerListener> listenerManager;
    private final IConsumerListener listenerProxy;
    private final GenListenerManager<DataObjectNotificationHandler> dataObjectNotificationManager;
    private final DataObjectNotificationHandler dataObjectNotificationProxy;
    private final GenListenerManager<NotificationHandler> notificationManager;
    private final NotificationHandler notificationProxy;
    private ArrayDeque<IPair<Long, Notification>> last10Notifications;
    private final Set<Integer> setProfIdForApptNotification = new ConcurrentHashSet();
    private final Set<Integer> setUserIdForChatAndTaskNotification = new ConcurrentHashSet();
    private final Set<String> bindings = new ConcurrentHashSet();
    private ExecutorService executorService;
    private RabbitMqConnection connection;
    private XSession session;
    private String clientCode;
    private boolean enabled = true;

    public RabbitMqConsumer2() {
        this.listenerManager = new GenListenerManager(IConsumerListener.class);
        this.listenerProxy = (IConsumerListener)this.listenerManager.getProxy();
        this.dataObjectNotificationManager = new GenListenerManager(DataObjectNotificationHandler.class);
        this.dataObjectNotificationProxy = (DataObjectNotificationHandler)this.dataObjectNotificationManager.getProxy();
        this.notificationManager = new GenListenerManager(NotificationHandler.class);
        this.notificationProxy = (NotificationHandler)this.notificationManager.getProxy();
        this.last10Notifications = new ArrayDeque(10);
    }

    public void startIfNeeded(XSession session) {
        this.start(session);
    }

    public synchronized void start(XSession session) {
        if (this.session != null && this.session.equals((Object)session)) {
            this.session = session;
            if (this.isActive()) {
                return;
            }
            this.configureSafe(false);
        } else {
            this.session = session;
            this.clearBindings();
            this.configureSafe(true);
        }
    }

    private void configureSafe(boolean newSession) {
        try {
            this.configure(newSession);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to configure RabbitMqConsumer2. newSession " + newSession, e);
        }
    }

    private void configure(boolean newSession) throws Exception {
        if (this.session == null) {
            this.close();
        } else {
            if (this.executorService != null) {
                try {
                    this.executorService.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.executorService = Executors.newCachedThreadPool(new RabbitMqThreadFactory("rabbitmq-executor"));
            if (this.connection != null) {
                boolean deleteQueue = newSession;
                this.connection.close(deleteQueue);
            }
            this.connection = new RabbitMqConnection(this.session, this.executorService){

                @Override
                public void handleDelivery(ExecutorService executorService, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    executorService.submit(new BasicConsumeTask(RabbitMqConsumer2.this, envelope, properties, body));
                }

                @Override
                protected void onFailure() {
                    RabbitMqConsumer2.this.onConnectionFail();
                }
            };
            if (newSession) {
                int sessionId = this.session.id;
                int userId = this.session.user.id;
                this.clientCode = this.session.getClient().getClientCode();
                this.addBinding("*.*.*." + sessionId + ".*.*.*." + this.clientCode, true);
                this.addBinding("all.*.*.*.*.*.*." + this.clientCode, true);
                this.addBinding("lc.#", true);
                this.addUserIdRoutingKey(userId, true);
            } else {
                for (String binding : this.bindings) {
                    this.addBinding(binding, true);
                }
                this.forceRefresh();
            }
        }
    }

    protected void onConnectionFail() {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("RabbitMqConsumer2.onConnectionFail - start");
                    RabbitMqConsumer2.this.listenerProxy.forceRefresh();
                    logger.info("RabbitMqConsumer2.onConnectionFail - end");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error", e);
                }
            }
        });
    }

    public void forceRefresh() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = Executors.newCachedThreadPool(new RabbitMqThreadFactory("rabbitmq-executor"));
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    RabbitMqConsumer2.this.listenerProxy.forceRefresh();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error", e);
                }
            }
        });
    }

    private void addBinding(String key, boolean force) {
        boolean added = this.bindings.add(key);
        if (force && this.connection != null) {
            if (this.connection.isActive()) {
                this.connection.queueBindAsync(key);
            }
        } else if (added && this.isActive()) {
            this.connection.queueBindAsync(key);
        }
    }

    private void removeBinding(String key) {
        boolean removed = this.bindings.remove(key);
        if (removed && this.isActive()) {
            this.connection.queueUnbindAsync(key);
        }
    }

    public void addPatientEformRessRoutingKey(Integer patientId) {
        if (patientId != null) {
            String key = "*.*.*.*.*." + patientId + ".*." + this.clientCode;
            this.addBinding(key, false);
        }
    }

    public void removePatientEformRessRoutingKey(Integer patientId) {
        if (patientId != null) {
            String key = "*.*.*.*.*." + patientId + ".*." + this.clientCode;
            this.removeBinding(key);
        }
    }

    public void addEformIdAnchorRoutingKey(Integer idAnchor) {
        String key = "*.*.*.*.*.*." + idAnchor + "." + this.clientCode;
        this.addBinding(key, false);
    }

    public void removeEformIdAnchorRoutingKey(Integer idAnchor) {
        String key = "*.*.*.*.*.*." + idAnchor + "." + this.clientCode;
        this.removeBinding(key);
    }

    public void addPatientEncounterRoutingKey(Integer patientId) {
        if (this.session != null) {
            this.addBinding("*.*.*.*." + patientId + ".*.*." + this.clientCode, false);
            this.addBinding("*." + this.session.user.id + ".*.*." + patientId + ".*.*." + this.clientCode, false);
            PresenceNotification pn = new PresenceNotification(1, patientId.intValue(), this.session.user.id.intValue(), this.session.user.name, System.currentTimeMillis());
            BasicPublishTask task = new BasicPublishTask(this, this.session);
            task.setNotification((Notification)new DataObjectUpdatedNotification((IDataObject)pn, null, this.session.id));
            this.executorService.submit(task);
        }
    }

    public void removePatientEncounterRoutingKey(Integer patientId) {
        if (this.session != null) {
            this.removeBinding("*.*.*.*." + patientId + ".*.*." + this.clientCode);
            this.removeBinding("*." + this.session.user.id + ".*.*." + patientId + ".*.*." + this.clientCode);
            PresenceNotification pn = new PresenceNotification(0, patientId.intValue(), this.session.user.id.intValue(), this.session.user.name, System.currentTimeMillis());
            BasicPublishTask task = new BasicPublishTask(this, this.session);
            task.setNotification((Notification)new DataObjectUpdatedNotification((IDataObject)pn, null, this.session.id));
            this.executorService.submit(task);
        }
    }

    public void sendPatientEncounterPresenceNotificationForUserRoutingKey(PresenceNotification pn, Integer toUserId) {
        if (this.session != null) {
            pn.setUserId(this.session.user.id.intValue());
            pn.setName(this.session.user.name);
            PresenceNotification pn2 = new PresenceNotification(1, pn.getIdPatient(), this.session.user.id.intValue(), this.session.user.name, pn.getSince());
            BasicPublishTask task = new BasicPublishTask(this, this.session);
            task.setNotification((Notification)new DataObjectUpdatedNotification((IDataObject)pn2, null, this.session.id));
            task.setToUserId(toUserId);
            this.executorService.submit(task);
        }
    }

    public void addProfIdForApptNotification(Set<Integer> profIds) {
        for (Integer profId : profIds) {
            this.addProfIdForApptNotification(profId);
        }
    }

    public void addProfIdForApptNotification(Integer profId) {
        this.setProfIdForApptNotification.add(profId);
        String key = "*.*." + profId + ".*.*.*.*." + this.clientCode;
        this.addBinding(key, false);
    }

    public void addUserIdForChatAndTaskNotification(Set<Integer> userIds) {
        for (Integer userId : userIds) {
            this.addUserIdRoutingKey(userId, false);
        }
    }

    private void addUserIdRoutingKey(Integer userId, boolean force) {
        this.setUserIdForChatAndTaskNotification.add(userId);
        String key = "*." + userId + ".*.*.*.*.*." + this.clientCode;
        this.addBinding(key, force);
    }

    public void addListener(IConsumerListener listener) {
        this.listenerManager.addListener((Object)listener);
    }

    public void removeListener(IConsumerListener listener) {
        this.listenerManager.removeListener((Object)listener);
    }

    public void addNotificationHandler(NotificationHandler handler) {
        this.notificationManager.addListener((Object)handler);
    }

    public void removeNotificationHandler(NotificationHandler handler) {
        this.notificationManager.removeListener((Object)handler);
    }

    public void addDataObjectNotificationHandler(DataObjectNotificationHandler handler) {
        this.dataObjectNotificationManager.addListener((Object)handler);
    }

    public void removeDataObjectNotificationHandler(DataObjectNotificationHandler handler) {
        this.dataObjectNotificationManager.removeListener((Object)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPair<Long, Notification>> getLastNotifications() {
        ArrayDeque<IPair<Long, Notification>> arrayDeque = this.last10Notifications;
        synchronized (arrayDeque) {
            return new ArrayList<IPair<Long, Notification>>(this.last10Notifications);
        }
    }

    public boolean isSham() {
        return false;
    }

    public boolean isActive() {
        return this.connection != null && this.connection.isActive();
    }

    RabbitMqConnection getConnection() {
        return this.connection;
    }

    public synchronized void close() {
        logger.log(Level.INFO, "RabbitMqConsumer.close");
        if (this.connection != null) {
            boolean deleteQueue = true;
            this.connection.close(deleteQueue);
            this.connection = null;
        }
        try {
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService = null;
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqConsumer.executorOnMessageService.shutdown", e1);
        }
        this.clearBindings();
    }

    public void applicationShutdown() {
        logger.log(Level.INFO, "RabbitMqConsumer.forceShutdown");
        try {
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService = null;
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqConsumer.executorOnMessageService.shutdown", e1);
        }
        this.clearBindings();
        if (this.connection != null) {
            this.connection.applicationShudown();
            this.connection = null;
        }
    }

    private void clearBindings() {
        this.bindings.clear();
        this.setProfIdForApptNotification.clear();
        this.setUserIdForChatAndTaskNotification.clear();
    }

    public void sendDataObjectUpdatedNotification(IDataObject dataObject, XSession session) {
        if (dataObject != null && session != null) {
            this.submit(new DataObjectUpdatedNotification(dataObject, null, session.getId(), session.getClient().getId()));
        }
    }

    public void sendDataObjectUpdatedNotification(IDataObject dataObject) {
        this.sendDataObjectUpdatedNotification(dataObject, Application.get().getGlobalInstances().getSession());
    }

    private void submit(DataObjectUpdatedNotification notification) {
        if (notification == null) {
            throw new NullPointerException("notification");
        }
        if (notification.getSessionId() == null) {
            throw new NullPointerException("notification.sessionId");
        }
        this.executorService.submit(new LocalConsumeTask(this, notification));
    }

    public void process(Notification[] notifications) {
        if (notifications == null) {
            return;
        }
        Notification[] notificationArray = notifications;
        int n = notifications.length;
        int n2 = 0;
        while (n2 < n) {
            Notification notification = notificationArray[n2];
            this.process(notification);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Notification notification) {
        block20: {
            if (notification == null) {
                return;
            }
            XSession session2 = Application.get().getGlobalInstances().getSession();
            if (session2 == null) {
                return;
            }
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Processing notification " + StringUtils.safeToString((Logger)logger, (Object)notification));
                }
                this.notificationProxy.handle(notification);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in notification processing", e);
            }
            if (notification instanceof DataObjectUpdatedNotification) {
                try {
                    DataObjectUpdatedNotification n;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Processing dataObjectNotification " + StringUtils.safeToString((Logger)logger, (Object)notification));
                    }
                    if ((n = (DataObjectUpdatedNotification)notification).getObject() instanceof XCourrielTexte) {
                        Integer sessionId = session2.getId();
                        XCourrielTexte chat = (XCourrielTexte)n.getObject();
                        if (!(chat.getId() != null || sessionId != null && sessionId.equals(n.getSessionId()))) {
                            MessageUtil.warningMsg(UI.getWorkbenchShell(), "MESSAGE DU SUPER-ADMINISTRATEUR / SUPER-ADMINISTRATOR MESSAGE\n\n" + chat.getDataText());
                        } else {
                            this.dataObjectNotificationProxy.handle(n);
                            this.listenerProxy.handle(n);
                        }
                        break block20;
                    }
                    this.dataObjectNotificationProxy.handle(n);
                    this.listenerProxy.handle(n);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in dataobjectNotification processing", e);
                }
            } else {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Processing notification " + StringUtils.safeToString((Logger)logger, (Object)notification));
                    }
                    this.listenerProxy.handleOther(notification);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in notification processing", e);
                }
            }
        }
        ArrayDeque<IPair<Long, Notification>> arrayDeque = this.last10Notifications;
        synchronized (arrayDeque) {
            Pair n = Pair.newPair((Object)System.currentTimeMillis(), (Object)notification);
            if (this.last10Notifications.size() == 10) {
                this.last10Notifications.poll();
            }
            this.last10Notifications.add((IPair<Long, Notification>)n);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabledFalse() {
        this.enabled = false;
    }

    public void closeTemp() {
    }

    public void stop(XSession xsession) {
        throw new UnsupportedOperationException();
    }

    public void removeProfIdForApptNotification(Set<Integer> profIds) {
    }

    public void removeProfIdForApptNotification(Integer patientId) {
    }
}

