/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumer;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.IConsumeTask;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MqttConsumeTask
implements IConsumeTask {
    private static final Logger logger = Logger.getLogger(MqttConsumeTask.class.getName());
    private final IConsumer consumer;
    private final Mqtt3Publish message;

    public MqttConsumeTask(IConsumer c, Mqtt3Publish m) {
        this.consumer = c;
        this.message = m;
    }

    @Override
    public void run() {
        try {
            Object object;
            XSession session;
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "MqttConsumeTask run on message " + this.message.toString());
            }
            if ((session = Application.get().getGlobalInstances().getSession()) != null && this.shouldProcess(session, object = LZMAClientSerialiser.deserialize((byte[])this.message.getPayloadAsBytes()))) {
                this.onMessage(object);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "consumer handleDelivery", e);
        }
    }

    private boolean shouldProcess(XSession session, Object object) {
        boolean doitAnyway = true;
        Integer sessionId = this.parseMessageSessionId();
        if (sessionId != null && sessionId.equals(session.getId()) && object instanceof DataObjectUpdatedNotification) {
            DataObjectUpdatedNotification don = (DataObjectUpdatedNotification)object;
            if (don.getObject() instanceof DataObject) {
                DataObject dto = (DataObject)((DataObjectUpdatedNotification)object).getObject();
                doitAnyway = !XEncounterModificationRequest.class.getName().equals(dto.getClazz());
            } else if (don.getObject() instanceof XReservedAppointment) {
                doitAnyway = false;
            }
        }
        return doitAnyway;
    }

    private Integer parseMessageSessionId() {
        Integer sessionId = null;
        return sessionId;
    }

    private void onMessage(Object object) {
        try {
            if (object instanceof Notification) {
                Notification notification = (Notification)object;
                this.consumer.process(notification);
            } else if (object instanceof Notification[]) {
                Notification[] notifications = (Notification[])object;
                this.consumer.process(notifications);
            } else {
                logger.log(Level.SEVERE, "Unsupported message object received " + object);
            }
        }
        catch (Exception e) {
            String smessage;
            try {
                smessage = String.valueOf(object);
            }
            catch (Exception e2) {
                smessage = e2.getMessage();
            }
            logger.log(Level.SEVERE, "Unexpected exception for message " + smessage, e);
        }
    }
}

