/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.IPublishTask;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqConsumer2;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.notification.PresenceNotification;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import com.rabbitmq.client.AMQP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicPublishTask
implements IPublishTask {
    private static final Logger logger = Logger.getLogger(BasicPublishTask.class.getName());
    private Notification notification;
    private Integer toUserId;
    private final RabbitMqConsumer2 consumer;
    private final XSession withSession;
    private final String clientCode;
    private final Integer clientId;

    public BasicPublishTask(RabbitMqConsumer2 consumer, XSession withSession) {
        this.consumer = consumer;
        this.withSession = withSession;
        this.clientCode = this.withSession.getClient().getClientCode();
        this.clientId = this.withSession.getClient().getId();
    }

    @Override
    public void run() {
        try {
            String expiration = "" + TimeUnit.HOURS.toMillis(1L);
            int priority = 2;
            int deliverMode = 1;
            HashSet<String> lstRoutingKeys = new HashSet<String>();
            Integer sessionId = this.notification.getSessionId();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sessionId", sessionId);
            params.put("clientId", this.clientId);
            params.put("uID", this.withSession.user.id);
            params.put("uName", this.withSession.user.name);
            StringBuilder routingKey = new StringBuilder();
            if (this.notification instanceof DataObjectUpdatedNotification) {
                DataObjectUpdatedNotification dataObjectN = (DataObjectUpdatedNotification)this.notification;
                params.put("obj", dataObjectN.getObject().getClass().getSimpleName());
                if (dataObjectN.getObject() instanceof PresenceNotification) {
                    PresenceNotification pn = (PresenceNotification)dataObjectN.getObject();
                    if (this.toUserId != null) {
                        routingKey.append("x.").append(this.toUserId).append(".x.x.").append(pn.getIdPatient()).append(".x.x.").append(this.clientCode);
                    } else {
                        routingKey.append("x.x.x.x.").append(pn.getIdPatient()).append(".x.x.").append(this.clientCode);
                    }
                    lstRoutingKeys.add(routingKey.toString());
                }
            }
            AMQP.BasicProperties properties = new AMQP.BasicProperties.Builder().deliveryMode(Integer.valueOf(deliverMode)).contentType("application/octet-stream").expiration(expiration).priority(Integer.valueOf(priority)).headers(params).build();
            byte[] body = LZMAClientSerialiser.serialize((Object)this.notification);
            for (String rk : lstRoutingKeys) {
                this.consumer.getConnection().basicPublish(rk, properties, body);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to send notification(s) " + this.notification + " from client" + this.clientCode, e);
        }
    }

    @Override
    public Notification getNotification() {
        return this.notification;
    }

    @Override
    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    @Override
    public Integer getToUserId() {
        return this.toUserId;
    }

    @Override
    public void setToUserId(Integer toUserId) {
        this.toUserId = toUserId;
    }
}

