/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util;

import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MyMessageDialog;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.library.UI;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class MessageUtil {
    private static final Logger logger = Logger.getLogger(MessageUtil.class.getName());
    public static final String CONFIRMER = Messages.getString((String)"CONFIRMER", (String[])new String[0]);
    public static final String ANNULER = Messages.getString((String)"ANNULER", (String[])new String[0]);
    public static final String YES = Messages.getString((String)"YES", (String[])new String[0]);
    public static final String NO = Messages.getString((String)"NO", (String[])new String[0]);
    public static final String OK = Messages.getString((String)"OK", (String[])new String[0]);
    public static final String CANCEL = Messages.getString((String)"CANCEL", (String[])new String[0]);
    public static final String CANNOT_CONNECT_TO_SERVER_MESSAGE = Messages.getString((String)"IMPOSSIBLE_DACCEDER_AU_SERVEUR_DE_LOGICIELS_INFODATA", (String[])new String[0]);
    public static final String UNEXPECTED_ERROR_MESSAGE = Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]);
    private static final Pattern patternStringToExtract = Pattern.compile("~(.*?)~");

    public static void cannotConnectToServerExceptionMsg() {
        MessageUtil.errorMsg(UI.getWorkbenchShell(), CANNOT_CONNECT_TO_SERVER_MESSAGE);
    }

    public static void cannotConnectToServerExceptionMsg(Shell shell) {
        MessageUtil.errorMsg(shell, Messages.getString((String)"IMPOSSIBLE_DACCEDER_AU_SERVEUR_DE_LOGICIELS_INFODATA", (String[])new String[0]));
    }

    public static void unexpectedExceptionMsg(Shell parent) {
        MessageUtil.bugMsg(parent, UNEXPECTED_ERROR_MESSAGE);
    }

    @Deprecated
    public static void unexpectedExceptionMsg() {
        MessageUtil.bugMsg(UNEXPECTED_ERROR_MESSAGE);
    }

    @Deprecated
    public static void unexpectedExceptionMsg(Exception e) {
        MessageUtil.unexpectedExceptionMsg(UI.getWorkbenchShell(), e);
    }

    public static void unexpectedExceptionMsg(Shell shell, Exception e) {
        if (e != null) {
            if (e.getMessage() != null && e.getMessage().contains("java.net.UnknownHostException")) {
                MessageUtil.cannotConnectToServerExceptionMsg(shell);
            } else {
                MessageUtil.bugMsg(shell, String.valueOf(UNEXPECTED_ERROR_MESSAGE) + "\n\n" + e.getMessage());
            }
        } else {
            MessageUtil.unexpectedExceptionMsg(shell);
        }
    }

    public static void show(final Shell shell, final Exception e) {
        if (UI.isCurrentThreadIsUIThread()) {
            MessageUtil.intern_show(shell, e);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageUtil.intern_show(shell, e);
                }
            });
        }
    }

    @Deprecated
    public static void show(Exception e) {
        MessageUtil.show(UI.getWorkbenchShell(), e);
    }

    private static void intern_show(Shell shell, Exception e) {
        if (e == null) {
            MessageUtil.unexpectedExceptionMsg(shell);
        } else if (e instanceof CannotConnectToServerException || e.getCause() instanceof ConnectException) {
            MessageUtil.cannotConnectToServerExceptionMsg(shell);
        } else if (e instanceof StatusException) {
            MessageUtil.show(shell, ((StatusException)e).getStatus());
        } else if (e.getMessage() != null && e.getMessage().contains("java.net.UnknownHostException")) {
            MessageUtil.cannotConnectToServerExceptionMsg();
        } else {
            MessageUtil.bugMsg(shell, String.valueOf(UNEXPECTED_ERROR_MESSAGE) + "\n\n" + e.getMessage());
        }
    }

    @Deprecated
    public static void warningMsg(String msg) {
        MessageUtil.openWarning(UI.getWorkbenchShell(), Messages.getString((String)"AVERTISSEMENT", (String[])new String[0]), msg);
    }

    public static void warningMsg(Shell shell, String msg) {
        MessageUtil.openWarning(shell, Messages.getString((String)"AVERTISSEMENT", (String[])new String[0]), msg);
    }

    public static void errorMsg(Shell shell, String msg) {
        MessageUtil.openWarning(shell, Messages.getString((String)"AVERTISSEMENT", (String[])new String[0]), msg);
    }

    public static void bugMsg(Shell parent, String msg) {
        MessageUtil.openError(parent, Messages.getString((String)"ERREUR", (String[])new String[0]), msg);
    }

    @Deprecated
    public static void bugMsg(String msg) {
        MessageUtil.openError(UI.getWorkbenchShell(), Messages.getString((String)"ERREUR", (String[])new String[0]), msg);
    }

    public static void infoMsg(Shell parent, String msg) {
        MessageUtil.openInformation(parent, Messages.getString((String)"INFORMATION", (String[])new String[0]), msg);
    }

    public static IStatusHandler.State show(IStatus status) {
        Shell shell = UI.getWorkbenchShell();
        if (shell == null || shell.isDisposed()) {
            logger.log(Level.INFO, "Could not show status " + status + ".  No main shell available");
            return IStatusHandler.State.NOT_HANDLED;
        }
        return MessageUtil.show(shell, status);
    }

    public static IStatusHandler.State show(Shell shell, IStatus status) {
        if (shell == null) {
            throw new NullPointerException("shell");
        }
        if (shell.isDisposed()) {
            throw new IllegalArgumentException("shell is disposed");
        }
        if (status == null) {
            return IStatusHandler.State.NOT_HANDLED;
        }
        if (status instanceof MultiStatus) {
            IStatusHandler.State finalState = IStatusHandler.State.HANDLED;
            List childrens = ((MultiStatus)status).getChildrens();
            final List<IStatus.Severity> order = Arrays.asList(IStatus.Severity.BUG, IStatus.Severity.ERROR, IStatus.Severity.WARNING, IStatus.Severity.NEED_MORE_INFO, IStatus.Severity.INFO, IStatus.Severity.OK);
            Collections.sort(childrens, new Comparator<IStatus>(){

                @Override
                public int compare(IStatus o1, IStatus o2) {
                    return order.indexOf(o1.getSeverity()) - order.indexOf(o2.getSeverity());
                }
            });
            for (IStatus c : childrens) {
                IStatusHandler.State state = MessageUtil.show(shell, c);
                if (state == IStatusHandler.State.HANDLED_POSITIVE) {
                    finalState = state;
                    continue;
                }
                if (state != IStatusHandler.State.HANDLED_NEGATIVE) continue;
                finalState = state;
                break;
            }
            return finalState;
        }
        String message = status.getMessage();
        message = MessageUtil.getTranslation(message);
        switch (status.getSeverity()) {
            case OK: {
                break;
            }
            case INFO: {
                MessageUtil.openInformation(shell, Messages.getString((String)"INFORMATION", (String[])new String[0]), message);
                break;
            }
            case NEED_MORE_INFO: {
                return MessageUtil.openQuestion(shell, Messages.getString((String)"QUESTION", (String[])new String[0]), message, true) ? IStatusHandler.State.HANDLED_POSITIVE : IStatusHandler.State.HANDLED_NEGATIVE;
            }
            case WARNING: 
            case ERROR: {
                MessageUtil.openWarning(shell, Messages.getString((String)"AVERTISSEMENT", (String[])new String[0]), message);
                break;
            }
            case BUG: {
                if (status.getException() != null) {
                    MessageUtil.openError(shell, Messages.getString((String)"ERREUR", (String[])new String[0]), String.valueOf(message) + "\r\n\r\n" + status.getException());
                    break;
                }
                MessageUtil.openError(shell, Messages.getString((String)"ERREUR", (String[])new String[0]), message);
            }
        }
        return IStatusHandler.State.HANDLED;
    }

    public static String getTranslation(String message) {
        Matcher matcher = patternStringToExtract.matcher(message);
        while (matcher.find()) {
            String extractedStringKey = matcher.group(1);
            message = StringUtils.replace((String)message, (String)("~" + extractedStringKey + "~"), (String)Messages.getString((String)extractedStringKey, (String[])new String[0]));
        }
        return message;
    }

    public static boolean askAreYouSure(Shell shell) {
        return MessageUtil.askAreYouSure(shell, true);
    }

    public static boolean askAreYouSure(Shell shell, boolean defaultValue) {
        return MessageUtil.openQuestion(shell, Messages.getString((String)"QUESTION", (String[])new String[0]), Messages.getString((String)"ETES_VOUS_CERTAINS", (String[])new String[0]), defaultValue);
    }

    public static boolean askQuestion(Shell shell, String msg) {
        return MessageUtil.openQuestion(shell, Messages.getString((String)"QUESTION", (String[])new String[0]), msg, true);
    }

    public static boolean askQuestion(Shell shell, String msg, boolean defaultChoice) {
        return MessageUtil.openQuestion(shell, Messages.getString((String)"QUESTION", (String[])new String[0]), msg, defaultChoice);
    }

    public static boolean askQuestion(Shell shell, String title, String msg, boolean defaultChoice) {
        return MessageUtil.openQuestion(shell, title, msg, defaultChoice);
    }

    private static boolean openConfirm(Shell parent, String title, String message) {
        MyMessageDialog dialog = new MyMessageDialog(parent, title, null, message, 3, new String[]{OK, CANCEL}, 0);
        return UI.openDialogInUIThread((MessageDialog)dialog) == 0;
    }

    private static void openError(Shell parent, String title, String message) {
        MyMessageDialog dialog = new MyMessageDialog(parent, title, null, message, 1, new String[]{OK}, 0);
        UI.openDialogInUIThread((MessageDialog)dialog);
    }

    private static void openInformation(Shell parent, String title, String message) {
        MyMessageDialog dialog = new MyMessageDialog(parent, title, null, message, 2, new String[]{OK}, 0);
        UI.openDialogInUIThread((MessageDialog)dialog);
    }

    private static boolean openQuestion(Shell parent, String title, String message, boolean defaultChoice) {
        MyMessageDialog dialog = new MyMessageDialog(parent, title, null, message, 3, new String[]{YES, NO}, defaultChoice ? 0 : 1);
        return UI.openDialogInUIThread((MessageDialog)dialog) == 0;
    }

    private static void openWarning(Shell parent, String title, String message) {
        MyMessageDialog dialog = new MyMessageDialog(parent, title, null, message, 4, new String[]{OK}, 0);
        UI.openDialogInUIThread((MessageDialog)dialog);
    }
}

