/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IEmployeeAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XEmployeeCriteria;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.library.log.Log;
import java.util.logging.Level;

public class EmployeeAccessorClient
extends BaseAccessorClient {
    private static EmployeeAccessorClient instance;
    private final IEmployeeAccessor accessor;

    public static EmployeeAccessorClient getInstance() throws CannotConnectToServerException {
        return EmployeeAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static EmployeeAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new EmployeeAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private EmployeeAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getEmployeeAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void find(final XSession session, final ICallback callback, final XEmployeeCriteria criteria) {
        if (this.isOkToCallFunction("EmployeeAccessorClient.find", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.find(criteria));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, criteria=%s}", "EmployeeAccessorClient.find", session, callback, criteria), e);
                            EmployeeAccessorClient.this.functionCallEnded("EmployeeAccessorClient.find", callback);
                        }
                    }
                    finally {
                        EmployeeAccessorClient.this.functionCallEnded("EmployeeAccessorClient.find", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getEmployee(int uniqueKey, final XSession session, final ICallback callback, final int employeeId) {
        final String function = "EmployeeAccessorClient.getEmployee" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getEmployee(employeeId, false));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, employeeId=%s}", function, session, callback, employeeId), e);
                            EmployeeAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EmployeeAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public Object getEmployeeSync(XSession session, int employeeId, boolean xbase) throws Exception {
        if (this.isOkToCallFunction("EmployeeAccessorClient.getEmployeeSync")) {
            try {
                ReturnObject returnObject;
                ReturnObject ret = returnObject = EmployeeAccessorClient.instance.accessor.getEmployee(employeeId, xbase);
                Object object = ret == null ? null : ret.getObj();
                return object;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, employeeId=%s}", "EmployeeAccessorClient.getEmployeeSync", session, employeeId), e);
                throw e;
            }
            finally {
                this.functionCallEnded("EmployeeAccessorClient.getEmployeeSync");
            }
        }
        return null;
    }

    public Object getEmployeeByIdPersonSync(XSession session, int personId, boolean xbase) throws Exception {
        if (this.isOkToCallFunction("EmployeeAccessorClient.getEmployeeByIdPersonSync")) {
            try {
                ReturnObject returnObject;
                ReturnObject ret = returnObject = EmployeeAccessorClient.instance.accessor.getEmployeeByIdPerson(personId, xbase);
                Object object = ret == null ? null : ret.getObj();
                return object;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, personId=%s}", "EmployeeAccessorClient.getEmployeeByIdPersonSync", session, personId), e);
                throw e;
            }
            finally {
                this.functionCallEnded("EmployeeAccessorClient.getEmployeeByIdPersonSync");
            }
        }
        return null;
    }

    public void findEmployeeTypeInUse(int uniqueKey, XSession session, final ICallback callback) {
        final String function = "EmployeeAccessorClient.findEmployeeTypeInUse" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findEmployeeTypeInUse());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            EmployeeAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EmployeeAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    protected IEmployeeAccessor getAccessor() {
        return this.accessor;
    }
}

