/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signature;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class Pkcs7SignatureFactory {
    private static final Logger logger = Logger.getLogger(Pkcs7SignatureFactory.class.getName());
    private static Pkcs7SignatureFactory instance = new Pkcs7SignatureFactory();
    private String oldAlias;
    private CMSSignedDataGenerator signedDateGenerator;

    public static Pkcs7SignatureFactory getInstance() {
        return instance;
    }

    public static void setInstance(Pkcs7SignatureFactory instance) {
        Pkcs7SignatureFactory.instance = instance;
    }

    public String sign(String alias, String password, byte[] data, boolean forceResetCache) throws Exception {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Signing with alias %s and password %s following data : \n%s", alias, password, new String(data)));
        }
        if (forceResetCache || this.oldAlias == null || !this.oldAlias.equals(alias)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("using new CMSSignedDataGenerator");
            }
            if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            KeyStore keyStore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
            keyStore.load(null, null);
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(password == null ? "nopassword".toCharArray() : password.toCharArray()));
            if (entry == null) {
                throw new KeyStoreException("alias " + alias + " cannot be found in keyStore Windows-MY");
            }
            PrivateKey privateKey = entry.getPrivateKey();
            Certificate[] chain = keyStore.getCertificateChain(alias);
            CertStore certsAndCRLs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(chain[0])), "BC");
            X509Certificate cert = (X509Certificate)chain[0];
            this.signedDateGenerator = new CMSSignedDataGenerator();
            this.signedDateGenerator.addSigner(privateKey, cert, CMSSignedDataGenerator.DIGEST_SHA1);
            this.signedDateGenerator.addCertificatesAndCRLs(certsAndCRLs);
            this.oldAlias = alias;
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("using cached CMSSignedDataGenerator");
        }
        CMSProcessableByteArray data2 = new CMSProcessableByteArray(data);
        CMSSignedData signed2 = this.signedDateGenerator.generate((CMSProcessable)data2, true, "SunMSCAPI");
        byte[] signature2 = signed2.getEncoded();
        signature2 = Base64.encode((byte[])signature2);
        return new String(signature2, "UTF-8");
    }

    public static String dumpAsStringBase64(String signature) throws Exception {
        byte[] decoded = Base64.decode((byte[])signature.getBytes("UTF-8"));
        ASN1StreamParser parser = new ASN1StreamParser(decoded);
        String dumpAsString = ASN1Dump.dumpAsString((Object)parser.readObject(), (boolean)true);
        return dumpAsString;
    }

    public static void main(String[] args) throws Exception {
        String s = new Pkcs7SignatureFactory().sign("Patrice Drolet", "", new byte[0], true);
        System.out.println(s);
    }
}

