/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.ru;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.Gender;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.domain.NAS;
import ca.infodata.dsq.domain.NIU_U;
import ca.infodata.dsq.service.ru.FindCandidateCriteriaBuilder;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;

public final class FindCandidateCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String firstName;
    private String lastName;
    private Long birthdate;
    private Gender gender;
    private NIU_U niu;
    private NAM nam;
    private NAS nas;
    private Address address;
    private String motherMaidenFirstName;
    private String motherMaidenLastName;
    private String fatherFirstName;
    private String fatherLastName;

    public static FindCandidateCriteriaBuilder builder() {
        return new FindCandidateCriteriaBuilder();
    }

    public FindCandidateCriteria(NAM nam) {
        if (nam == null) {
            throw new NullPointerException("nam");
        }
        this.nam = nam;
    }

    public FindCandidateCriteria(String firstName, String lastName, Long birthdate, Gender gender) {
        if (firstName == null) {
            throw new NullPointerException("firstName");
        }
        if (lastName == null) {
            throw new NullPointerException("lasttName");
        }
        if (birthdate == null) {
            throw new NullPointerException("birthdate");
        }
        if (gender == null) {
            throw new NullPointerException("gender");
        }
        this.firstName = firstName;
        this.lastName = lastName;
        this.birthdate = birthdate;
        this.gender = gender;
    }

    public FindCandidateCriteria(NIU_U niu) {
        if (niu == null) {
            throw new NullPointerException("niu");
        }
        this.niu = niu;
    }

    public FindCandidateCriteria(String firstName, String lastName, Long birthdate, Gender gender, NIU_U niu, NAM nam, NAS nas, Address address, String motherMaidenFirstName, String motherMaidenLastName, String fatherFirstName, String fatherLastName) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.birthdate = birthdate;
        this.gender = gender;
        this.niu = niu;
        this.nam = nam;
        this.nas = nas;
        this.address = address;
        this.motherMaidenFirstName = motherMaidenFirstName;
        this.motherMaidenLastName = motherMaidenLastName;
        this.fatherFirstName = fatherFirstName;
        this.fatherLastName = fatherLastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Long getBirthdate() {
        return this.birthdate;
    }

    public Gender getGender() {
        return this.gender;
    }

    public NIU_U getNiu() {
        return this.niu;
    }

    public NAM getNam() {
        return this.nam;
    }

    public NAS getNas() {
        return this.nas;
    }

    public void setNas(NAS nas) {
        this.nas = nas;
    }

    public String getMotherMaidenFirstName() {
        return this.motherMaidenFirstName;
    }

    public void setMotherMaidenName(String motherFirstName, String motherLastName) {
        if (this.motherMaidenFirstName == null && this.motherMaidenLastName != null || this.motherMaidenFirstName != null && this.motherMaidenLastName == null) {
            throw new IllegalArgumentException("both must be either null or not null");
        }
        this.motherMaidenFirstName = motherFirstName;
        this.motherMaidenLastName = motherLastName;
    }

    public String getMotherMaidenLastName() {
        return this.motherMaidenLastName;
    }

    public String getFatherFirstName() {
        return this.fatherFirstName;
    }

    public void setFatherName(String fatherFirstName, String fatherLastName) {
        if (fatherFirstName == null && fatherLastName != null || fatherFirstName != null && fatherLastName == null) {
            throw new IllegalArgumentException("both must be either null or not null");
        }
        this.fatherFirstName = fatherFirstName;
        this.fatherLastName = fatherLastName;
    }

    public String getFatherLastName() {
        return this.fatherLastName;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String toString() {
        return String.format("CandidateCriteria [address=%s, birthdate=%s(%s), fatherFirstName=%s, fatherLastName=%s, firstName=%s, gender=%s, lastName=%s, motherMaidenFirstName=%s, motherMaidenLastName=%s, nam=%s, nas=%s, niu=%s]", new Object[]{this.address, Helper.formatFULLDATE(this.birthdate), this.birthdate, this.fatherFirstName, this.fatherLastName, this.firstName, this.gender, this.lastName, this.motherMaidenFirstName, this.motherMaidenLastName, this.nam, this.nas, this.niu});
    }
}

