/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain.labo.getreport.pdf;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.VIEW_MODE;
import ca.infodata.dsq.domain.labo.getreport.LaboReport;
import ca.infodata.dsq.domain.labo.getreport.LaboReportDocument;
import ca.infodata.dsq.domain.labo.getreport.pdf.DsqFormatter;
import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportHeaderFlat;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class LaboReportPdf {
    private Candidate candidate;
    private LaboReport report;
    private LaboReportHeaderFlat reportHeader;
    private VIEW_MODE viewMode;
    private String printedBy;

    public LaboReportPdf(Candidate candidate, LaboReport laboReport, LaboReportHeaderFlat reportHeader) {
        this.reportHeader = reportHeader;
        if (candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (laboReport == null) {
            throw new NullPointerException("laboReport");
        }
        this.candidate = candidate;
        this.report = laboReport;
        this.viewMode = VIEW_MODE.VIEW;
    }

    public String getPrintedBy() {
        return this.printedBy;
    }

    public void setPrintedBy(String printedBy) {
        this.printedBy = printedBy;
    }

    public VIEW_MODE getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(VIEW_MODE viewMode) {
        this.viewMode = viewMode;
    }

    public void getPicture(OutputStream outputStream) throws Exception {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        ArrayList<byte[]> parts = new ArrayList<byte[]>();
        for (LaboReportDocument document : this.report.documents) {
            if ("application/PDF".equalsIgnoreCase(document.mediaType)) {
                byte[] pdf = DatatypeConverter.parseBase64Binary((String)document.text);
                parts.add(pdf);
                continue;
            }
            if ("image/png".equalsIgnoreCase(document.mediaType) || "image/gif".equalsIgnoreCase(document.mediaType) || "image/jpeg".equalsIgnoreCase(document.mediaType) || "image/tiff".equalsIgnoreCase(document.mediaType) || "image/png".equalsIgnoreCase(document.mediaType)) {
                byte[] image = DatatypeConverter.parseBase64Binary((String)document.text);
                byte[] pdf = LaboReportPdf.newPdfFromImage(image);
                parts.add(pdf);
                continue;
            }
            if ("text/rtf".equalsIgnoreCase(document.mediaType)) {
                String text = document.text;
                parts.add(LaboReportPdf.newPdfFromText("", text, true));
                continue;
            }
            if ("text/plain".equalsIgnoreCase(document.mediaType)) {
                String decodedText = document.text;
                parts.add(LaboReportPdf.newPdfFromText("", decodedText, true));
                continue;
            }
            parts.add(LaboReportPdf.newPdfFromText(null, "Unsupported mediaType " + document.mediaType, false));
        }
        int pageCount = LaboReportPdf.computePageCount(parts) + 1;
        if (this.viewMode == VIEW_MODE.PRINT) {
            parts.add(0, this.getCoverPageForPrint(pageCount));
        } else {
            parts.add(0, this.getCoverPageForViewer());
        }
        if (parts.size() > 0) {
            byte[] picture = this.joinPdfs((byte[][])parts.toArray((T[])new byte[0][]), pageCount);
            if (this.viewMode != VIEW_MODE.PRINT) {
                PdfReader reader = new PdfReader(picture);
                PdfStamper stamper = new PdfStamper(reader, outputStream);
                stamper.setEncryption(null, null, 0, 1);
                outputStream.flush();
                stamper.close();
                reader.close();
            } else {
                outputStream.write(picture);
                outputStream.flush();
            }
        }
    }

    private static int computePageCount(List<byte[]> parts) throws IOException {
        int pageCount = 0;
        for (byte[] pdf : parts) {
            if (pdf == null) continue;
            PdfReader pdfReader = new PdfReader(pdf);
            pageCount += pdfReader.getNumberOfPages();
            pdfReader.close();
        }
        return pageCount;
    }

    private static byte[] newPdfFromImage(byte[] data) throws Exception {
        Image image = Image.getInstance((byte[])data);
        boolean landscape = image.getWidth() > image.getHeight();
        Rectangle pageSize = landscape ? PageSize.LETTER.rotate() : PageSize.LETTER;
        int margin = 40;
        float width = pageSize.getRight((float)margin) - pageSize.getLeft((float)margin);
        float height = pageSize.getTop((float)margin) - pageSize.getBottom((float)margin);
        image.scaleToFit(width, height);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        document.add((Element)image);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private byte[] getCoverPageForViewer() throws Exception {
        Rectangle rect = new Rectangle(PageSize.LETTER);
        rect.setBottom(500.0f);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(rect);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        String title = null;
        title = this.report.type.text;
        if (StringUtils.isBlank((CharSequence)title)) {
            title = this.report.title;
        }
        if (title != null) {
            document.addTitle(title);
            Paragraph paragraph = new Paragraph(title + "\n\n", new Font(0, 12.0f, 1));
            paragraph.setAlignment(1);
            document.add((Element)paragraph);
        }
        PdfPTable table = new PdfPTable(new float[]{30.0f, 70.0f});
        table.setWidthPercentage(100.0f);
        table.getDefaultCell().setPadding(5.0f);
        PdfPCell cell = new PdfPCell(new Phrase("Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)"));
        cell.setColspan(2);
        cell.setBorder(0);
        cell.setPaddingBottom(10.0f);
        table.addCell(cell);
        String name = this.candidate.getFirstName() + " " + this.candidate.getLastName() + " (" + (Object)((Object)this.candidate.getGender()) + ") " + DateUtil.format((Long)this.candidate.getBirthDate(), (String)"yyyy/MM/dd");
        String nam = this.candidate.getNam() == null ? "" : this.candidate.getNam().value();
        table.addCell("Usager");
        table.addCell(StringUtils.join((String)", ", (Object[])new Object[]{name, nam}));
        table.addCell("# de la requ\u00eate");
        table.addCell(this.reportHeader.laboRequest.id.extension);
        String status = "";
        status = "SURGP".equals(this.report.type.code) ? "S/O" : ("completed".equals(this.report.requestStatus.code) ? "Final" : ("active".equals(this.report.requestStatus.code) ? "Partiel" : "S/O"));
        table.addCell("Statut de la requ\u00eate");
        table.addCell(status);
        table.addCell("Nom du laboratoire");
        String location = "";
        if (this.report.laboratoryEmitter != null) {
            JoinList list = new JoinList(", ");
            list.setTrim(true);
            list.add((CharSequence)DsqFormatter.nvl(this.report.laboratoryEmitter.getCode()));
            list.add((CharSequence)DsqFormatter.nvl(this.report.laboratoryEmitter.getName()));
            location = list.toString();
        }
        table.addCell(location);
        table.addCell("Prescripteur");
        if (this.report.prescriber != null) {
            table.addCell(this.report.prescriber.getFirstName() + ", " + this.report.prescriber.getLastName());
        } else if (this.reportHeader.laboRequest.author != null) {
            table.addCell(this.reportHeader.laboRequest.author.getFirstName() + ", " + this.reportHeader.laboRequest.author.getLastName());
        } else {
            table.addCell("Non-sp\u00e9cifi\u00e9");
        }
        table.addCell("Date/heure du pr\u00e9l\u00e8vement");
        if (this.report.specimenStartTime != null) {
            table.addCell(DateUtil.nonThreadSafeFormat((Long)this.report.specimenStartTime, (String)"yyyy-MM-dd HH:mm"));
        } else if (this.report.specimenEndTime != null) {
            table.addCell(DateUtil.nonThreadSafeFormat((Long)this.report.specimenEndTime, (String)"yyyy-MM-dd HH:mm"));
        } else if (this.report.specimenMedianTime != null) {
            table.addCell(DateUtil.nonThreadSafeFormat((Long)this.report.specimenMedianTime, (String)"yyyy-MM-dd HH:mm"));
        } else {
            table.addCell("Non-sp\u00e9cifi\u00e9e");
        }
        document.add((Element)table);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private byte[] getCoverPageForPrint(int pageCount) throws Exception {
        Rectangle rect = new Rectangle(PageSize.LETTER);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(rect);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        Font font = new Font(2, 14.0f, 0, Color.black);
        Font italic = new Font(2, 14.0f, 2, Color.black);
        String name = this.candidate.getFirstName() + " " + this.candidate.getLastName() + " (" + (Object)((Object)this.candidate.getGender()) + ") " + DateUtil.format((Long)this.candidate.getBirthDate(), (String)"yyyy/MM/dd");
        String nam = this.candidate.getNam() == null ? "" : this.candidate.getNam().value();
        String patientInformation = StringUtils.join((String)", ", (Object[])new Object[]{name, nam});
        String prescriber = "Non-sp\u00e9cifi\u00e9";
        if (this.report.prescriber != null) {
            prescriber = this.report.prescriber.getFirstName() + ", " + this.report.prescriber.getLastName();
        } else if (this.reportHeader.laboRequest.author != null) {
            prescriber = this.reportHeader.laboRequest.author.getFirstName() + ", " + this.reportHeader.laboRequest.author.getLastName();
        }
        String location = "";
        if (this.report.laboratoryEmitter != null) {
            JoinList list = new JoinList(", ");
            list.setTrim(true);
            list.add((CharSequence)DsqFormatter.nvl(this.report.laboratoryEmitter.getCode()));
            list.add((CharSequence)DsqFormatter.nvl(this.report.laboratoryEmitter.getName()));
            location = list.toString();
        }
        Paragraph p = new Paragraph("Confidentiel");
        p.setFont(new Font(2, 20.0f, 0, Color.black));
        p.setAlignment(1);
        document.add((Element)p);
        p = new Paragraph("\n\n" + patientInformation);
        p.setFont(new Font(2, 16.0f, 1, Color.black));
        p.setAlignment(1);
        document.add((Element)p);
        p = new Paragraph("\n\nPrescripteur\n\n" + prescriber + "\n\nNom du laboratoire\n\n" + location);
        p.setFont(font);
        p.setAlignment(1);
        document.add((Element)p);
        p = this.printedBy != null ? new Paragraph("\n\n\n\n\n\n\n\n\n\n\n\n\nCes donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)\n\n" + this.printedBy) : new Paragraph("\n\n\n\n\n\n\n\n\n\n\n\n\nCes donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)");
        p.setFont(italic);
        p.setAlignment(1);
        document.add((Element)p);
        String pageInfo = String.format("Page %d de %d", 1, pageCount);
        PdfContentByte directContent = writer.getDirectContent();
        directContent.moveTo(document.left(), document.bottom(15.0f));
        directContent.lineTo(document.right(), document.bottom(15.0f));
        directContent.stroke();
        ColumnText.showTextAligned((PdfContentByte)directContent, (int)2, (Phrase)new Phrase(pageInfo, new Font(2, 12.0f, 0, Color.black)), (float)(document.right() - 2.0f), (float)document.bottom(), (float)0.0f);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private byte[] joinPdfs(byte[][] pdfs, int pageCount) throws Exception {
        String name = this.candidate.getFirstName() + " " + this.candidate.getLastName() + " (" + (Object)((Object)this.candidate.getGender()) + ") " + DateUtil.format((Long)this.candidate.getBirthDate(), (String)"yyyy/MM/dd");
        String nam = this.candidate.getNam() == null ? "" : this.candidate.getNam().value();
        String patientInformation = StringUtils.join((String)", ", (Object[])new Object[]{name, nam});
        Font font = new Font(2, 12.0f, 0, Color.black);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document();
        PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)outputStream);
        document.open();
        int pageNumber = 1;
        for (byte[] pdf : pdfs) {
            if (pdf == null) continue;
            PdfReader pdfReader = new PdfReader(pdf);
            int n = pdfReader.getNumberOfPages();
            for (int page = 1; page <= n; ++page) {
                PdfImportedPage importedPage = pdfCopy.getImportedPage(pdfReader, page);
                Rectangle boundingBox = pdfReader.getPageSizeWithRotation(page);
                PdfCopy.PageStamp pageStamp = pdfCopy.createPageStamp(importedPage);
                PdfContentByte overContent = pageStamp.getOverContent();
                if (this.viewMode == VIEW_MODE.PRINT && pageNumber > 1) {
                    float footerBottom;
                    float headerRight;
                    float headerLeft;
                    float headerTop;
                    String pageInfo = String.format("Page %d de %d", pageNumber, pageCount);
                    String disclaimer = "Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)";
                    if (pdfReader.getPageRotation(page) == PdfPage.PORTRAIT.intValue()) {
                        headerTop = boundingBox.getTop() - 25.0f;
                        headerLeft = boundingBox.getLeft() + 25.0f;
                        headerRight = boundingBox.getRight() - 25.0f;
                        footerBottom = boundingBox.getBottom() + 25.0f;
                    } else {
                        headerTop = boundingBox.getTop() - 25.0f;
                        headerLeft = boundingBox.getLeft() + 25.0f;
                        headerRight = boundingBox.getRight() - 25.0f;
                        footerBottom = boundingBox.getBottom() + 25.0f;
                    }
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)0, (Phrase)new Phrase(patientInformation, font), (float)headerLeft, (float)headerTop, (float)0.0f);
                    overContent.moveTo(headerLeft, headerTop - 5.0f);
                    overContent.lineTo(headerRight, headerTop - 5.0f);
                    overContent.stroke();
                    overContent.moveTo(headerLeft, footerBottom + 15.0f);
                    overContent.lineTo(headerRight, footerBottom + 15.0f);
                    overContent.stroke();
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)2, (Phrase)new Phrase(pageInfo, font), (float)headerRight, (float)footerBottom, (float)0.0f);
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)0, (Phrase)new Phrase(disclaimer, font), (float)headerLeft, (float)footerBottom, (float)0.0f);
                    pageStamp.alterContents();
                }
                pdfCopy.addPage(importedPage);
                ++pageNumber;
            }
            pdfCopy.freeReader(pdfReader);
            pdfReader.close();
        }
        document.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private static byte[] newPdfFromText(String title, String text, boolean landscape) throws Exception {
        return LaboReportPdf.newPdfFromText(title, text, landscape ? PageSize.LETTER.rotate() : PageSize.LETTER);
    }

    private static byte[] newPdfFromText(String title, String text, Rectangle pageSize) throws Exception {
        Paragraph paragraph;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        if (title != null && title.trim().length() > 0) {
            document.addTitle(title);
            paragraph = new Paragraph(title + "\n\n", new Font(0, 12.0f, 1));
            paragraph.setAlignment(1);
            document.add((Element)paragraph);
        }
        paragraph = new Paragraph(text, new Font(0, 12.0f, 0));
        paragraph.setKeepTogether(true);
        document.add((Element)paragraph);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }
}

