/*
 * Decompiled with CFR 0.152.
 */
package boofcv.generate;

public enum Unit {
    MILLIMETER(0.001, "mm"),
    CENTIMETER(0.01, "cm"),
    METER(1.0, "m"),
    KILOMETER(1000.0, "km"),
    INCH(0.0254, "in"),
    FOOT(0.3048, "ft"),
    YARD(0.9144, "yd"),
    MILE(1852.0, "ml");

    public double unitToMeter;
    public String abbreviation;

    private Unit(double unitToMeter, String abbreviation) {
        this.unitToMeter = unitToMeter;
        this.abbreviation = abbreviation;
    }

    public static Unit lookup(String word) {
        for (Unit unit : Unit.values()) {
            if (unit.toString().compareToIgnoreCase(word) == 0) {
                return unit;
            }
            if (unit.getAbbreviation().compareToIgnoreCase(word) != 0) continue;
            return unit;
        }
        return null;
    }

    public double convert(double value, Unit to) {
        return value * Unit.conversion(this, to);
    }

    public double conversion(Unit to) {
        return Unit.conversion(this, to);
    }

    public static double conversion(Unit from, Unit to) {
        return from.unitToMeter / to.unitToMeter;
    }

    public double getUnitToMeter() {
        return this.unitToMeter;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }
}

