/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.sgm.cost;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.disparity.sgm.SgmDisparityCost;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.Planar;

public abstract class SgmCostBase<T extends ImageBase<T>>
implements SgmDisparityCost<T> {
    protected T left;
    protected T right;
    protected GrayU16 costXD;
    protected int disparityMin;
    protected int disparityRange;

    @Override
    public void configure(int disparityMin, int disparityRange) {
        this.disparityMin = disparityMin;
        this.disparityRange = disparityRange;
    }

    @Override
    public void process(T left, T right, Planar<GrayU16> costYXD) {
        InputSanityCheck.checkSameShape(left, right);
        if (this.disparityRange == 0) {
            throw new IllegalArgumentException("disparityRange is 0. Did you call configure()?");
        }
        this.left = left;
        this.right = right;
        costYXD.reshape(this.disparityRange, ((ImageBase)left).width, ((ImageBase)left).height);
        for (int y = 0; y < ((ImageBase)left).height; ++y) {
            this.costXD = costYXD.getBand(y);
            int idxLeft = ((ImageBase)left).startIndex + y * ((ImageBase)left).stride + this.disparityMin;
            int x = this.disparityMin;
            while (x < ((ImageBase)left).width) {
                int idxOut = this.costXD.startIndex + (x - this.disparityMin) * costYXD.stride;
                int localRange = Math.min(this.disparityRange, x - this.disparityMin + 1);
                int idxRight = ((ImageBase)right).startIndex + y * ((ImageBase)right).stride + x - this.disparityMin;
                this.computeDisparityErrors(idxLeft, idxRight, idxOut, localRange);
                for (int d = localRange; d < this.disparityRange; ++d) {
                    this.costXD.data[idxOut + d] = 2047;
                }
                ++x;
                ++idxLeft;
            }
        }
    }

    protected abstract void computeDisparityErrors(int var1, int var2, int var3, int var4);
}

