/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.tracker;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.klt.KltConfig;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.KltTracker;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidDiscrete;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;

public class PointTrackerKltPyramid<I extends ImageGray<I>, D extends ImageGray<D>>
implements PointTracker<I> {
    protected I input;
    protected ImageGradient<I, D> gradient;
    protected PyramidDiscrete<I> basePyramid;
    protected D[] derivX;
    protected D[] derivY;
    protected Class<D> derivType;
    protected KltConfig config;
    protected int templateRadius;
    protected List<PyramidKltFeature> active = new ArrayList<PyramidKltFeature>();
    protected List<PyramidKltFeature> spawned = new ArrayList<PyramidKltFeature>();
    protected List<PyramidKltFeature> dropped = new ArrayList<PyramidKltFeature>();
    protected List<PyramidKltFeature> unused = new ArrayList<PyramidKltFeature>();
    protected PyramidKltTracker<I, D> tracker;
    private GeneralFeatureDetector<I, D> detector;
    private QueueCorner excludeList = new QueueCorner(10);
    private long totalFeatures = 0L;

    public PointTrackerKltPyramid(KltConfig config, int templateRadius, PyramidDiscrete<I> pyramid, GeneralFeatureDetector<I, D> detector, ImageGradient<I, D> gradient, InterpolateRectangle<I> interpInput, InterpolateRectangle<D> interpDeriv, Class<D> derivType) {
        this.config = config;
        this.templateRadius = templateRadius;
        this.gradient = gradient;
        this.basePyramid = pyramid;
        this.derivType = derivType;
        KltTracker<I, D> klt = new KltTracker<I, D>(interpInput, interpDeriv, config);
        this.tracker = new PyramidKltTracker<I, D>(klt);
        if (detector != null) {
            if (detector.getRequiresHessian()) {
                throw new IllegalArgumentException("Hessian based feature detectors not yet supported");
            }
            this.detector = detector;
        }
    }

    private void addTrackToUnused() {
        int numLayers = this.basePyramid.getNumLayers();
        PyramidKltFeature t = new PyramidKltFeature(numLayers, this.templateRadius);
        PointTrack p = new PointTrack();
        p.setDescription(t);
        t.cookie = p;
        this.unused.add(t);
    }

    public PointTrack addTrack(double x, double y) {
        if (!((ImageBase)this.input).isInBounds((int)x, (int)y)) {
            return null;
        }
        if (this.unused.isEmpty()) {
            this.addTrackToUnused();
        }
        PyramidKltFeature t = this.unused.remove(this.unused.size() - 1);
        t.setPosition((float)x, (float)y);
        this.tracker.setDescription(t);
        PointTrack p = (PointTrack)t.cookie;
        p.set(x, y);
        if (this.checkValidSpawn(p)) {
            this.active.add(t);
            return p;
        }
        return null;
    }

    @Override
    public void spawnTracks() {
        this.spawned.clear();
        float scaleBottom = (float)this.basePyramid.getScale(0);
        this.excludeList.reset();
        for (int i = 0; i < this.active.size(); ++i) {
            PyramidKltFeature f = this.active.get(i);
            this.excludeList.add((int)(f.x / scaleBottom), (int)(f.y / scaleBottom));
        }
        this.detector.setExcludeMaximum(this.excludeList);
        this.detector.process((ImageGray)this.basePyramid.getLayer(0), this.derivX[0], this.derivY[0], null, null, null);
        QueueCorner found = this.detector.getMaximums();
        while (this.unused.size() < found.size()) {
            this.addTrackToUnused();
        }
        for (int i = 0; i < found.size() && !this.unused.isEmpty(); ++i) {
            Point2D_I16 pt = (Point2D_I16)found.get(i);
            PyramidKltFeature t = this.unused.remove(this.unused.size() - 1);
            t.x = (float)pt.x * scaleBottom;
            t.y = (float)pt.y * scaleBottom;
            this.tracker.setDescription(t);
            PointTrack p = (PointTrack)t.getCookie();
            p.set(t.x, t.y);
            if (this.checkValidSpawn(p)) {
                ++this.totalFeatures;
                p.featureId = p.featureId;
                this.active.add(t);
                this.spawned.add(t);
                continue;
            }
            this.unused.add(t);
        }
    }

    protected boolean checkValidSpawn(PointTrack p) {
        return true;
    }

    @Override
    public void dropAllTracks() {
        this.unused.addAll(this.active);
        this.active.clear();
        this.dropped.clear();
    }

    @Override
    public void process(I image) {
        this.input = image;
        this.spawned.clear();
        this.dropped.clear();
        this.basePyramid.process(image);
        this.declareOutput();
        PyramidOps.gradient(this.basePyramid, this.gradient, this.derivX, this.derivY);
        this.tracker.setImage(this.basePyramid, (ImageGray[])this.derivX, (ImageGray[])this.derivY);
        int i = 0;
        while (i < this.active.size()) {
            PyramidKltFeature t = this.active.get(i);
            KltTrackFault ret = this.tracker.track(t);
            boolean success = false;
            if (ret == KltTrackFault.SUCCESS && ((ImageBase)image).isInBounds((int)t.x, (int)t.y) && this.tracker.setDescription(t)) {
                PointTrack p = (PointTrack)t.getCookie();
                p.set(t.x, t.y);
                ++i;
                success = true;
            }
            if (success) continue;
            this.active.remove(i);
            this.dropped.add(t);
            this.unused.add(t);
        }
    }

    protected void declareOutput() {
        if (this.derivX == null) {
            this.derivX = PyramidOps.declareOutput(this.basePyramid, this.derivType);
            this.derivY = PyramidOps.declareOutput(this.basePyramid, this.derivType);
        } else if (((ImageGray)this.derivX[0]).width != ((ImageGray)this.basePyramid.getLayer((int)0)).width || ((ImageGray)this.derivX[0]).height != ((ImageGray)this.basePyramid.getLayer((int)0)).height) {
            PyramidOps.reshapeOutput(this.basePyramid, this.derivX);
            PyramidOps.reshapeOutput(this.basePyramid, this.derivY);
        }
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        if (this.active.remove((PyramidKltFeature)track.getDescription())) {
            this.unused.add((PyramidKltFeature)track.getDescription());
            return true;
        }
        return false;
    }

    @Override
    public List<PointTrack> getActiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.active, list);
        return list;
    }

    @Override
    public List<PointTrack> getInactiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        return list;
    }

    @Override
    public List<PointTrack> getDroppedTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.dropped, list);
        return list;
    }

    @Override
    public List<PointTrack> getNewTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.spawned, list);
        return list;
    }

    @Override
    public List<PointTrack> getAllTracks(List<PointTrack> list) {
        return this.getActiveTracks(list);
    }

    protected void addToList(List<PyramidKltFeature> in, List<PointTrack> out) {
        for (PyramidKltFeature t : in) {
            out.add((PointTrack)t.cookie);
        }
    }

    @Override
    public void reset() {
        this.dropAllTracks();
        this.totalFeatures = 0L;
    }
}

