/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.extract;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.FastQueue;

public class NonMaxLimiter {
    NonMaxSuppression nonmax;
    int maxTotalFeatures;
    QueueCorner originalMin = new QueueCorner();
    QueueCorner originalMax = new QueueCorner();
    FastQueue<LocalExtreme> localExtreme = new FastQueue<LocalExtreme>(LocalExtreme.class, true);

    public NonMaxLimiter(NonMaxSuppression nonmax, int maxTotalFeatures) {
        this.nonmax = nonmax;
        this.maxTotalFeatures = maxTotalFeatures <= 0 ? Integer.MAX_VALUE : maxTotalFeatures;
    }

    public void process(GrayF32 intensity) {
        float val;
        Point2D_I16 p;
        int i;
        this.originalMin.reset();
        this.originalMax.reset();
        this.nonmax.process(intensity, null, null, this.originalMin, this.originalMax);
        this.localExtreme.reset();
        for (i = 0; i < this.originalMin.size; ++i) {
            p = (Point2D_I16)this.originalMin.get(i);
            val = intensity.unsafe_get(p.x, p.y);
            this.localExtreme.grow().set(-val, false, p);
        }
        for (i = 0; i < this.originalMax.size; ++i) {
            p = (Point2D_I16)this.originalMax.get(i);
            val = intensity.unsafe_get(p.x, p.y);
            this.localExtreme.grow().set(val, true, p);
        }
        if (this.localExtreme.size > this.maxTotalFeatures) {
            QuickSelect.select((Comparable[])this.localExtreme.data, this.maxTotalFeatures, this.localExtreme.size);
            this.localExtreme.size = this.maxTotalFeatures;
        }
    }

    public FastQueue<LocalExtreme> getLocalExtreme() {
        return this.localExtreme;
    }

    public int getMaxTotalFeatures() {
        return this.maxTotalFeatures;
    }

    public void setMaxTotalFeatures(int maxTotalFeatures) {
        this.maxTotalFeatures = maxTotalFeatures;
    }

    public NonMaxSuppression getNonmax() {
        return this.nonmax;
    }

    public static class LocalExtreme
    implements Comparable<LocalExtreme> {
        public float intensity;
        public boolean max;
        public Point2D_I16 location;

        public LocalExtreme set(float intensity, boolean max, Point2D_I16 location) {
            this.intensity = intensity;
            this.max = max;
            this.location = location;
            return this;
        }

        public float getValue() {
            if (this.max) {
                return this.intensity;
            }
            return -this.intensity;
        }

        @Override
        public int compareTo(LocalExtreme o) {
            if (this.intensity < o.intensity) {
                return 1;
            }
            if (this.intensity > o.intensity) {
                return -1;
            }
            return 0;
        }
    }
}

