/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.interest.UnrollSiftScaleSpaceGradient;
import boofcv.core.image.GConvertImage;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class DescribeRegionPoint_SIFT<T extends ImageGray<T>>
implements DescribeRegionPoint<T, TupleDesc_F64> {
    ImageType<T> imageType;
    UnrollSiftScaleSpaceGradient scaleSpace;
    DescribePointSift<GrayF32> describe;
    GrayF32 imageFloat = new GrayF32(1, 1);

    public DescribeRegionPoint_SIFT(SiftScaleSpace scaleSpace, DescribePointSift<GrayF32> describe, Class<T> imageType) {
        this.scaleSpace = new UnrollSiftScaleSpaceGradient(scaleSpace);
        this.describe = describe;
        this.imageType = ImageType.single(imageType);
    }

    @Override
    public void setImage(T image) {
        GrayF32 input;
        if (image instanceof GrayF32) {
            input = (GrayF32)image;
        } else {
            this.imageFloat.reshape(((ImageGray)image).width, ((ImageGray)image).height);
            GConvertImage.convert(image, this.imageFloat);
            input = this.imageFloat;
        }
        this.scaleSpace.setImage(input);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, TupleDesc_F64 description) {
        double sigma = radius / 6.0;
        UnrollSiftScaleSpaceGradient.ImageScale image = this.scaleSpace.lookup(sigma);
        this.describe.setImageGradient(image.derivX, image.derivY);
        this.describe.process(x / image.imageToInput, y / image.imageToInput, sigma / image.imageToInput, orientation, description);
        return true;
    }

    @Override
    public boolean requiresRadius() {
        return true;
    }

    @Override
    public boolean requiresOrientation() {
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.describe.getCanonicalRadius() * 2;
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.describe.getDescriptorLength());
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }
}

