/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.download;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class UrlUtil {
    private static final Logger logger = Logger.getLogger(UrlUtil.class.getName());

    public static void configureHttpsTrustStore() {
        System.setProperty("jsse.enableSNIExtension", "false");
        try {
            InputStream fis = UrlUtil.class.getClassLoader().getResourceAsStream("ca/infodata/launcher/download/certificates/truststore.jks");
            KeyStore trustStore = KeyStore.getInstance("JKS", "SUN");
            trustStore.load(fis, "infodata".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, tmf.getTrustManagers(), new SecureRandom());
            SSLSocketFactory factory = context.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(factory);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to trustAllHttpsServerCertificate", ex);
        }
    }
}

