/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.util;

import ca.infodata.launcher.util.SyncProgressMonitor;

public abstract class RelaxSyncProgressMonitor
extends SyncProgressMonitor {
    private long mininumUpdateDelay = 500L;
    private long lastUpdateTime = System.currentTimeMillis();
    private boolean needUpdate = false;

    @Override
    public final void update() {
        if (this.needUpdate) {
            this.updateOverride();
            this.sleep();
        } else {
            long now = System.currentTimeMillis();
            if (now - this.lastUpdateTime >= this.mininumUpdateDelay) {
                this.lastUpdateTime = now;
                this.updateOverride();
                this.sleep();
            }
        }
        this.needUpdate = false;
    }

    private void sleep() {
    }

    public abstract void updateOverride();

    @Override
    public void setTotalFiles(Integer totalFiles) {
        this.needUpdate = true;
        super.setTotalFiles(totalFiles);
    }

    @Override
    public void workedFiles(int n) {
        this.needUpdate = true;
        super.workedFiles(n);
    }

    @Override
    public void workedBytes(long n) {
        super.workedBytes(n);
    }

    @Override
    public void setWorkedFiles(Integer workedFiles) {
        this.needUpdate = true;
        super.setWorkedFiles(workedFiles);
    }

    @Override
    public void setTotalBytes(Long totalBytes) {
        this.needUpdate = true;
        super.setTotalBytes(totalBytes);
    }

    @Override
    public void setWorkedBytes(Long workedBytes) {
        super.setWorkedBytes(workedBytes);
    }

    @Override
    public void setCurrentFile(String currentFile) {
        this.needUpdate = true;
        super.setCurrentFile(currentFile);
    }

    @Override
    public void setCurrentFileTotalBytes(Long currentFileTotalBytes) {
        super.setCurrentFileTotalBytes(currentFileTotalBytes);
    }

    @Override
    public void setCurrentFileWorkedBytes(Long currentFileWorkedBytes) {
        super.setCurrentFileWorkedBytes(currentFileWorkedBytes);
    }

    @Override
    public void setCanceled() {
        this.needUpdate = true;
        super.setCanceled();
    }

    @Override
    public void setDone() {
        this.needUpdate = true;
        super.setDone();
    }

    @Override
    public void setCurrentTask(String currentTask) {
        this.needUpdate = true;
        super.setCurrentTask(currentTask);
    }

    @Override
    public void setMessage(String message) {
        this.needUpdate = true;
        super.setMessage(message);
    }

    @Override
    public void setDownloadSpeed(Long downloadSpeed) {
        super.setDownloadSpeed(downloadSpeed);
    }

    @Override
    public void setPaused(boolean paused) {
        this.needUpdate = true;
        super.setPaused(paused);
    }

    @Override
    public void setCancelable(boolean cancelable) {
        this.needUpdate = true;
        super.setCancelable(cancelable);
    }
}

