/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.medoffice;

import ca.infodata.launcher.core.AbstractLauncher;
import ca.infodata.launcher.core.config.IConfig;
import ca.infodata.launcher.exception.QuietException;
import ca.infodata.launcher.medoffice.config.MedofficeConfig;
import ca.infodata.launcher.util.LauncherLogger;
import ca.infodata.launcher.util.StreamGobbler;
import ca.infodata.launcher.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class MedoLauncher
extends AbstractLauncher {
    public static void main(String[] args) {
        MedoLauncher launcher = new MedoLauncher(args);
        launcher.main();
    }

    public MedoLauncher(String[] args) {
        super(args);
    }

    @Override
    protected String __initGetLauncherVersion() {
        return "4.0.0";
    }

    @Override
    protected void findCommandsAndExecute() throws Exception {
        super.findCommandsAndExecute();
        this.findCommandAndExcute("-flush-bin");
    }

    @Override
    protected ImageIcon __initGetApplicationLogo() {
        try {
            return new ImageIcon(ClassLoader.getSystemResource("ca/infodata/launcher/medoffice/ressources/logo.png"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected IConfig __initNewConfig(String[] args) throws Exception {
        return new MedofficeConfig(args);
    }

    @Override
    protected void launchApplication() throws Exception {
        this.preLaunchSetup();
        IConfig config = this.getConfig();
        LauncherLogger log = this.getLogger();
        config.saveLangageFile();
        File rootFolder = config.getRootFolder();
        File appIconIcns = new File(config.getApplicationFolder(), "appIcons.icns");
        log.log("Lancement de Med-Office");
        this.checkJavaVersion();
        String options = "";
        boolean isMac64Only = false;
        if (Util.isWindows()) {
            options = options + "-Xms256m -Xmx896m";
        } else if (Util.isMac()) {
            log.log(Level.INFO, "IT'S A MAC");
            options = options + " -XstartOnFirstThread -Xms256m -Xmx896m -XX:MaxPermSize=256m -Xdock:icon=\"" + appIconIcns + "\" -Dorg.eclipse.swt.internal.carbon.smallFonts";
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("osgi.instance.area", new File(rootFolder, "instance").getAbsolutePath());
        env.put("osgi.configuration.area", config.getConfigFileManager().getConfigFile().getAbsolutePath());
        env.put("osgi.user.area", new File(rootFolder, "user").getAbsolutePath());
        env.put("osgi.sharedConfiguration.area", new File(rootFolder, "shared").getAbsolutePath());
        env.put("eclipse.ee.install.verify", "true");
        env.put("osgi.clean", "true");
        env.put("osgi.bundles", "org.eclipse.equinox.common@2:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start");
        env.put("eclipse.product", "ca.infodata.intro.product");
        env.put("osgi.splashPath", "platform:/base/plugins/ca.infodata.intro");
        env.put("eclipse.application", "ca.infodata.intro.IntroApplication");
        config.getProperties().putAll((Map<?, ?>)env);
        ArrayList<String> classpath = new ArrayList<String>();
        String launcherJar = Util.findFileRecursive2(rootFolder, "org.eclipse.equinox.launcher_1.2.0.v20110502.jar");
        classpath.add(launcherJar);
        StringBuilder commandBuilder = new StringBuilder(1000);
        if (!isMac64Only) {
            commandBuilder.append("java");
        }
        commandBuilder.append(" ").append(options);
        for (Map.Entry<Object, Object> e : config.getProperties().entrySet()) {
            commandBuilder.append(" -D").append(e.getKey()).append("=\"").append(e.getValue()).append("\"");
        }
        commandBuilder.append(" -classpath \"");
        for (String cp : classpath) {
            commandBuilder.append(cp).append(";");
        }
        commandBuilder.deleteCharAt(commandBuilder.length() - 1);
        commandBuilder.append("\" ");
        String launcherClass = "org.eclipse.equinox.launcher.Main";
        commandBuilder.append(" ").append(launcherClass).append(" ");
        commandBuilder.append(" -showsplash ");
        String command = commandBuilder.toString();
        log.log(Level.INFO, "----- > LAUNCH MEDOFFICE WITH < ---------");
        log.log(Level.INFO, "applicationDir=" + rootFolder.getAbsolutePath());
        log.log(Level.INFO, "command=" + command);
        if (Util.isMac()) {
            if (this.haveCommand("-build-bat")) {
                File bat = new File(rootFolder, "/medoffice.sh");
                Util.saveToFile(bat, command);
            }
            File file = File.createTempFile("launch", "sh");
            String script = "cd \"" + rootFolder.getAbsolutePath() + "\"\n" + command.toString() + "\n";
            Util.saveToFile(file, script);
            file.setExecutable(true);
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", file.getAbsolutePath()});
            if (this.haveCommand("-build-bat")) {
                File fSh = new File(rootFolder, "launch.sh");
                Util.saveToFile(fSh, script);
            }
        } else {
            if (this.haveCommand("-build-bat")) {
                File bat = new File(rootFolder, "/medoffice.bat");
                Util.saveToFile(bat, command);
            }
            File file = File.createTempFile("launch", ".bat");
            String script = "cd \"" + rootFolder.getAbsolutePath() + "\"\n" + command.toString() + "\nEXIT\n";
            Util.saveToFile(file, script);
            file.setExecutable(true);
            Process proc = Runtime.getRuntime().exec("cmd /c start /min " + file.getAbsolutePath());
        }
        log.log(Level.INFO, "----- > LAUNCH MEDOFFICE WITH < ---------");
    }

    private void preLaunchSetup() {
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File(this.getConfig().getRootFolder(), "plugins"));
        files.add(new File(this.getConfig().getRootFolder(), "appIcon.icns"));
        files.add(new File(this.getConfig().getRootFolder(), "appIcon.ico"));
        files.add(new File(this.getConfig().getRootFolder(), "MedofficeApp.zip"));
        for (File file : files) {
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    Util.deleteDirectory(file);
                    continue;
                }
                Util.deleteFile(file);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error trying to delete old architecture plugins folder", e);
            }
        }
        files.clear();
        files.add(new File(this.getConfig().getRootFolder(), "databaseInfo.xml"));
        files.add(new File(this.getConfig().getRootFolder(), "databaseInfos.xml"));
        files.add(new File(this.getConfig().getRootFolder(), "DatabaseInfo.xml"));
        files.add(new File(this.getConfig().getRootFolder(), "DatabaseInfos.xml"));
        files.add(new File(this.getConfig().getRootFolder(), "ofys.lang"));
        files.add(new File(this.getConfig().getRootFolder(), "medoffice.lang"));
        files.add(new File(this.getConfig().getRootFolder(), "urlserver.info"));
        for (File file : files) {
            if (!file.exists()) continue;
            try {
                Util.copyFile(file, new File(this.getConfig().getApplicationFolder(), file.getName()));
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Failed to copy file to application folder " + file.getName(), e);
            }
        }
    }

    private void checkJavaVersion() throws Exception {
        LauncherLogger log = this.getLogger();
        if (Util.isMac()) {
            Process vCheck = Runtime.getRuntime().exec("java -version");
            StreamGobbler sg = new StreamGobbler(vCheck.getInputStream(), vCheck.getErrorStream());
            sg.run();
            vCheck.waitFor();
            String versionOutput = sg.streamInString;
            log.log(Level.INFO, "cmd line : java -version: \n" + versionOutput);
            if (versionOutput.contains("\"1.6")) {
                log.log(Level.INFO, "User have a bad version of java and must install java 1.7");
                JOptionPane.showMessageDialog(null, "Vous avez pr\u00e9sentement Java 1.6 qui est utilis\u00e9 pour lancer MED-Office. \nVous devez installer Java 1.7 ( http://www.medoffice.ca/download.html ).\n\nApr\u00e8s l'installation de de Java 1.7, relancer MED-Office.");
                throw new QuietException("This user have to update his Java");
            }
            log.log(Level.INFO, "User have a good version of java.");
        }
    }
}

