/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.download;

import ca.infodata.launcher.download.DownloadSite;
import ca.infodata.launcher.download.Resource;
import ca.infodata.launcher.download.STATUS;
import ca.infodata.launcher.download.ValidatedFileDownload;
import ca.infodata.launcher.download.ValidatedStringDownload;
import ca.infodata.launcher.util.LauncherLogger;
import ca.infodata.launcher.util.SyncProgressMonitor;
import java.net.URL;
import java.util.logging.Level;

public class ResourceDownload {
    private SyncProgressMonitor monitor = new SyncProgressMonitor();

    public Object downloadString(DownloadSite site, Resource resource) throws Exception {
        LauncherLogger logger = LauncherLogger.getInstance();
        try {
            logger.log("Downloading to String : " + resource);
            URL url = new URL(site.url, resource.getPath());
            ValidatedStringDownload download = new ValidatedStringDownload(url, resource.getPath());
            download.setMonitor(this.monitor);
            download.setMd5(resource.getMd5());
            download.run();
            if (download.getStatus() == STATUS.COMPLETE) {
                return download.getString();
            }
            return download.getStatus();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to download " + resource);
            throw e;
        }
    }

    public Object downloadFile(DownloadSite site, Resource resource) throws Exception {
        LauncherLogger logger = LauncherLogger.getInstance();
        try {
            logger.log("Downloading to File : " + resource);
            URL url = new URL(site.url, resource.getPath());
            ValidatedFileDownload download = new ValidatedFileDownload(url, resource.getFile());
            download.setMonitor(this.monitor);
            download.setMd5(resource.getMd5());
            download.run();
            if (download.getStatus() == STATUS.COMPLETE) {
                return resource.getFile();
            }
            return download.getStatus();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to download " + resource);
            throw e;
        }
    }

    public SyncProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(SyncProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

