/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.download;

import ca.infodata.launcher.download.MyReadableByteChannel;
import ca.infodata.launcher.download.STATUS;
import ca.infodata.launcher.util.LauncherLogger;
import ca.infodata.launcher.util.SyncProgressMonitor;
import ca.infodata.launcher.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Observable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class FileDownload
extends Observable
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 1024;
    private static final int MAX_RETRY = 3;
    private static final int CON_TIMEOUT = 30000;
    private static final int TIME_BEFORE_RETRY = 1000;
    private File target;
    private URL from;
    private int numberOfRetry;
    private STATUS status;
    private long downloaded;
    private long size;
    private SyncProgressMonitor monitor;

    public FileDownload(URL from, File target) {
        if (from == null) {
            throw new NullPointerException("no from url");
        }
        if (target == null) {
            throw new NullPointerException("no target file");
        }
        this.from = from;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setStatus(STATUS.UNDEFINED);
        RandomAccessFile file = null;
        InputStream stream = null;
        SyncProgressMonitor monitor = this.getMonitor();
        try {
            monitor.setCurrentFile(this.target.getName());
            monitor.setCurrentFileTotalBytes(null);
            monitor.setCurrentFileWorkedBytes(null);
            monitor.setDownloadSpeed(null);
            if (this.target.exists()) {
                LauncherLogger.getInstance().log(Level.INFO, "target file already exist.");
                this.downloaded = this.size = this.target.length();
                monitor.setCurrentFileTotalBytes(this.size);
                monitor.setCurrentFileWorkedBytes(this.downloaded);
                this.setStatus(STATUS.COMPLETE);
                return;
            }
            File tempFile = new File(this.target.getAbsolutePath() + ".download");
            LauncherLogger.getInstance().log(Level.INFO, "will download from " + this.from + " to " + this.target + " using temp file " + tempFile);
            this.downloaded = 0L;
            if (tempFile.exists()) {
                this.downloaded = tempFile.length();
                LauncherLogger.getInstance().log(Level.INFO, "temp file already exists. will restore download at " + this.downloaded);
            }
            this.setStatus(STATUS.CONNECTING);
            HttpURLConnection connection = (HttpURLConnection)this.from.openConnection();
            connection.setDefaultUseCaches(false);
            connection.setUseCaches(false);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode / 100 != 2) {
                LauncherLogger.getInstance().log(Level.WARNING, responseCode + " connection.getResponseCode() / 100 != 2");
                this.setStatus(STATUS.ERROR);
                if (this.numberOfRetry < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    ++this.numberOfRetry;
                    monitor.setMessage("Erreur " + responseCode + ". Essai " + this.numberOfRetry);
                    this.run();
                } else {
                    monitor.setMessage("Erreur " + responseCode + ". Abandon");
                }
            }
            this.size = connection.getContentLength();
            if (this.size < 1L) {
                LauncherLogger.getInstance().log(Level.WARNING, "size < 1");
                this.setStatus(STATUS.ERROR);
                if (this.numberOfRetry < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    ++this.numberOfRetry;
                    monitor.setMessage("Erreur size < 1. Essai " + this.numberOfRetry);
                    this.run();
                } else {
                    monitor.setMessage("Erreur size < 1. Abandon");
                }
            }
            monitor.setCurrentFileTotalBytes(this.size);
            monitor.setCurrentFileWorkedBytes(this.downloaded);
            LauncherLogger.getInstance().log(Level.INFO, "content length to download=" + this.size);
            if (!tempFile.exists() && !tempFile.getParentFile().exists()) {
                tempFile.getParentFile().mkdirs();
            }
            file = new RandomAccessFile(tempFile, "rw");
            file.seek(this.downloaded);
            stream = connection.getInputStream();
            LauncherLogger.getInstance().log(Level.INFO, "downloading");
            this.setStatus(STATUS.DOWNLOADING);
            long start = System.nanoTime();
            while (this.getStatus() == STATUS.DOWNLOADING) {
                if (monitor.isCanceled()) {
                    this.setStatus(STATUS.CANCEL);
                    break;
                }
                byte[] buffer = this.size - this.downloaded > 1024L ? new byte[1024] : new byte[(int)(this.size - this.downloaded)];
                int read = stream.read(buffer);
                int readTry = -1;
                while (read == -1) {
                    if (monitor.isCanceled()) {
                        this.setStatus(STATUS.CANCEL);
                        break;
                    }
                    if (this.downloaded < this.size && readTry < 3) {
                        Thread.sleep(500L);
                        monitor.setMessage("Erreur -1. Essai " + ++readTry);
                        read = stream.read(buffer);
                        continue;
                    }
                    read = -100;
                    monitor.setMessage("Erreur -100. Abandon");
                    break;
                }
                if (read == -100) {
                    LauncherLogger.getInstance().log(Level.WARNING, "read == -1 ; buffer.length = " + buffer.length);
                    this.setStatus(STATUS.ERROR);
                    break;
                }
                file.write(buffer, 0, read);
                this.downloaded += (long)read;
                monitor.setCurrentFileWorkedBytes(this.downloaded);
                long end = System.nanoTime();
                long speed = TimeUnit.SECONDS.toNanos(1L) * this.downloaded / (end - start);
                monitor.setDownloadSpeed(speed);
                this.stateChanged();
                if (this.downloaded < this.size) continue;
                monitor.setCurrentFileWorkedBytes(this.size);
                this.setStatus(STATUS.COMPLETE);
                break;
            }
            try {
                file.close();
            }
            catch (Exception e) {
                monitor.setMessage("Erreur. Fermeture de fichier");
                this.setStatus(STATUS.ERROR);
                LauncherLogger.getInstance().log(Level.WARNING, "Failed to close temp file " + tempFile, e);
            }
            if (this.getStatus() == STATUS.COMPLETE) {
                try {
                    tempFile.renameTo(this.target);
                }
                catch (Exception e) {
                    monitor.setMessage("Erreur. Renommer le fichier");
                    this.setStatus(STATUS.ERROR);
                    LauncherLogger.getInstance().log(Level.WARNING, "Failed to rename temp file " + tempFile + " to target file " + this.target, e);
                }
            }
        }
        catch (SocketTimeoutException e) {
            monitor.setMessage("La connection n'a pas pu s'\u00e9tablir dans un d\u00e9lai de 10 secondes ou moins");
            LauncherLogger.getInstance().log(Level.SEVERE, "Failed to download file from url " + this.from, e);
        }
        catch (Exception e) {
            monitor.setMessage(Util.formatException(e));
            LauncherLogger.getInstance().log(Level.SEVERE, "Failed to download file from url " + this.from, e);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNio() {
        this.setStatus(STATUS.UNDEFINED);
        InputStream stream = null;
        FileOutputStream fos = null;
        final SyncProgressMonitor monitor = this.getMonitor();
        try {
            monitor.setCurrentFile(this.target.getName());
            monitor.setCurrentFileTotalBytes(null);
            monitor.setCurrentFileWorkedBytes(null);
            monitor.setDownloadSpeed(null);
            if (this.target.exists()) {
                LauncherLogger.getInstance().log(Level.INFO, "target file already exist.");
                this.downloaded = this.size = this.target.length();
                monitor.setCurrentFileTotalBytes(this.size);
                monitor.setCurrentFileWorkedBytes(this.downloaded);
                this.setStatus(STATUS.COMPLETE);
                return;
            }
            File tempFile = new File(this.target.getAbsolutePath() + ".download");
            LauncherLogger.getInstance().log(Level.INFO, "will download from " + this.from + " to " + this.target + " using temp file " + tempFile);
            this.downloaded = 0L;
            if (tempFile.exists()) {
                this.downloaded = tempFile.length();
                LauncherLogger.getInstance().log(Level.INFO, "temp file already exists. will restore download at " + this.downloaded);
            }
            this.setStatus(STATUS.CONNECTING);
            HttpURLConnection connection = (HttpURLConnection)this.from.openConnection();
            connection.setDefaultUseCaches(false);
            connection.setUseCaches(false);
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode / 100 != 2) {
                LauncherLogger.getInstance().log(Level.WARNING, responseCode + " connection.getResponseCode() / 100 != 2");
                this.setStatus(STATUS.ERROR);
                if (this.numberOfRetry < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    ++this.numberOfRetry;
                    monitor.setMessage("Erreur " + responseCode + ". Essai " + this.numberOfRetry);
                    this.runNio();
                } else {
                    monitor.setMessage("Erreur " + responseCode + ". Abandon");
                }
            }
            this.size = connection.getContentLength();
            if (this.size < 1L) {
                LauncherLogger.getInstance().log(Level.WARNING, "size < 1");
                this.setStatus(STATUS.ERROR);
                if (this.numberOfRetry < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    ++this.numberOfRetry;
                    monitor.setMessage("Erreur size < 1. Essai " + this.numberOfRetry);
                    this.runNio();
                } else {
                    monitor.setMessage("Erreur size < 1. Abandon");
                }
            }
            monitor.setCurrentFileTotalBytes(this.size);
            monitor.setCurrentFileWorkedBytes(this.downloaded);
            LauncherLogger.getInstance().log(Level.INFO, "content length to download=" + this.size);
            if (!tempFile.exists() && !tempFile.getParentFile().exists()) {
                tempFile.getParentFile().mkdirs();
            }
            stream = connection.getInputStream();
            ReadableByteChannel rbc = Channels.newChannel(stream);
            final long start = System.nanoTime();
            rbc = new MyReadableByteChannel(rbc){
                private long count;
                {
                    super(x0);
                    this.count = 0L;
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    if (monitor.isCanceled()) {
                        FileDownload.this.setStatus(STATUS.CANCEL);
                        return -1;
                    }
                    while (monitor.isPaused()) {
                        Util.sleep(1000L);
                        if (!monitor.isCanceled()) continue;
                        FileDownload.this.setStatus(STATUS.CANCEL);
                        return -1;
                    }
                    int i = super.read(dst);
                    this.count += (long)i;
                    monitor.setCurrentFileWorkedBytes(this.count);
                    long end = System.nanoTime();
                    long speed = TimeUnit.SECONDS.toNanos(1L) * this.count / (end - start);
                    monitor.setDownloadSpeed(speed);
                    if (this.count >= FileDownload.this.size) {
                        FileDownload.this.setStatus(STATUS.COMPLETE);
                    }
                    return i;
                }
            };
            LauncherLogger.getInstance().log(Level.INFO, "downloading");
            this.setStatus(STATUS.DOWNLOADING);
            fos = new FileOutputStream(tempFile);
            fos.getChannel().transferFrom(rbc, this.downloaded, this.size);
            fos.flush();
            try {
                fos.close();
            }
            catch (Exception e) {
                monitor.setMessage("Erreur. Fermeture de fichier");
                this.setStatus(STATUS.ERROR);
                LauncherLogger.getInstance().log(Level.WARNING, "Failed to close temp file " + tempFile, e);
            }
            if (this.getStatus() == STATUS.COMPLETE) {
                try {
                    tempFile.renameTo(this.target);
                }
                catch (Exception e) {
                    monitor.setMessage("Erreur. Renommer le fichier");
                    this.setStatus(STATUS.ERROR);
                    LauncherLogger.getInstance().log(Level.WARNING, "Failed to rename temp file " + tempFile + " to target file " + this.target, e);
                }
            }
        }
        catch (SocketTimeoutException e) {
            monitor.setMessage("La connection n'a pas pu s'\u00e9tablir dans un d\u00e9lai de 30 secondes ou moins");
            LauncherLogger.getInstance().log(Level.SEVERE, "Failed to download file from url " + this.from, e);
        }
        catch (Exception e) {
            monitor.setMessage(Util.formatException(e));
            LauncherLogger.getInstance().log(Level.SEVERE, "Failed to download file from url " + this.from, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public File getTarget() {
        return this.target;
    }

    public URL getFrom() {
        return this.from;
    }

    public STATUS getStatus() {
        return this.status;
    }

    protected void setStatus(STATUS status) {
        this.status = status;
        this.stateChanged();
    }

    public void setMonitor(SyncProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public SyncProgressMonitor getMonitor() {
        return this.monitor;
    }
}

