/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.core.config.command;

import ca.infodata.launcher.core.config.IConfig;
import ca.infodata.launcher.core.config.command.AbstractCommand;
import ca.infodata.launcher.util.LauncherLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ChangeLanguageCommand
extends AbstractCommand {
    public static final String LANG_PROP_KEY = "osgi.nl";

    public ChangeLanguageCommand(IConfig config) {
        super(config);
    }

    @Override
    public String getCommandName() {
        return "-change-langage";
    }

    @Override
    public int getMaxParameter() {
        return 0;
    }

    @Override
    public boolean isValidParameter(String value) {
        return false;
    }

    @Override
    public void execute() throws Exception {
        LauncherLogger.getInstance().log("  --  CHANGE LANGAGE  --");
        Properties properties = this.getConfig().getProperties();
        if ("fr_ca".equals(properties.get(LANG_PROP_KEY))) {
            LauncherLogger.getInstance().log("        Francais to English");
            properties.put(LANG_PROP_KEY, "en_ca");
        } else {
            LauncherLogger.getInstance().log("        English to Francais");
            properties.put(LANG_PROP_KEY, "fr_ca");
        }
    }

    @Override
    public String getHelpDescription() {
        return "Change the langage (en_ca, fr_ca).";
    }

    @Override
    public Map<String, String> getHelpParameters() {
        return new HashMap<String, String>();
    }
}

