/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.core.config;

import ca.infodata.launcher.core.config.VersionDiff;
import ca.infodata.launcher.download.CancelException;
import ca.infodata.launcher.download.DownloadSite;
import ca.infodata.launcher.download.MultiSiteResourceDownload;
import ca.infodata.launcher.download.Resource;
import ca.infodata.launcher.download.SiteProvider;
import ca.infodata.launcher.exception.PopupInformationException;
import ca.infodata.launcher.util.JoinList;
import ca.infodata.launcher.util.SyncProgressMonitor;
import ca.infodata.launcher.util.Util;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VersionSynchronizer {
    private List<File> localFilesNotToSync;
    private VersionDiff diff;
    private SyncProgressMonitor monitor;
    private SiteProvider siteProvider;

    public VersionSynchronizer(VersionDiff diff) {
        if (diff == null) {
            throw new NullPointerException("diff");
        }
        this.diff = diff;
        this.localFilesNotToSync = Collections.emptyList();
    }

    public void sync() throws Exception {
        if (this.monitor == null) {
            throw new NullPointerException("monitor");
        }
        if (this.siteProvider == null) {
            throw new NullPointerException("siteProvider");
        }
        this.monitor.setCurrentTask("Initialisation...");
        if (!this.diff.local.root.exists()) {
            this.diff.local.root.mkdirs();
        }
        this.monitor.setCurrentTask("Pr\u00e9paration du dossier d'installation...");
        System.gc();
        ArrayList<Resource> problematicResource = new ArrayList<Resource>();
        for (Resource resource : this.diff.toDelete) {
            boolean deleted;
            if (this.localFilesNotToSync.contains(resource.getFile()) || (deleted = Util.deleteFile(resource.getFile()))) continue;
            problematicResource.add(resource);
        }
        if (problematicResource.size() > 0) {
            int limit = 5;
            JoinList list = new JoinList("\n");
            for (int i = 0; i < problematicResource.size() && i < limit; ++i) {
                list.add(((Resource)problematicResource.get(i)).getPath());
            }
            if (problematicResource.size() > limit) {
                list.add("..." + (problematicResource.size() - limit) + " de plus");
            }
            list.add("Veuillez vous assurer d'avoir ferm\u00d9 toutes les applications Ofys ouvertes et relancez Ofys");
            throw new PopupInformationException("Les fichiers suivants n'ont pus \u00eatre supprim\u00e9s : \n " + list.toString());
        }
        this.monitor.setCurrentTask("T\u00e9l\u00e9chargement de la version " + this.diff.remote.name);
        this.monitor.setTotalFiles(this.diff.toDownload.size());
        long totalBytes = 0L;
        for (Resource f : this.diff.toDownload) {
            totalBytes += f.getLength().longValue();
        }
        this.monitor.setTotalBytes(totalBytes);
        ArrayList<DownloadSite> sites = new ArrayList<DownloadSite>();
        for (DownloadSite site : this.siteProvider.getSites()) {
            DownloadSite c = site.clone();
            String url2 = c.url.toURI().toString();
            url2 = url2.endsWith("/") ? url2 + this.diff.remote.name + "/" : url2 + "/" + this.diff.remote.name + "/";
            c.url = new URL(url2);
            sites.add(c);
        }
        MultiSiteResourceDownload download = new MultiSiteResourceDownload(sites);
        download.setMonitor(this.monitor);
        for (Resource resource : this.diff.toDownload) {
            resource.setFile(new File(this.diff.local.root, resource.getPath()));
            if (resource.getFile().exists() && this.localFilesNotToSync.contains(resource.getFile())) continue;
            download.downloadFile(resource);
            this.monitor.workedFiles(1);
            this.monitor.workedBytes(resource.getLength());
            this.checkCanceledOrPaused(this.monitor);
        }
        this.monitor.setCurrentFile(null);
        this.monitor.setCurrentFileTotalBytes(null);
        this.monitor.setCurrentFileWorkedBytes(null);
        this.monitor.setCurrentTask("Finalisation...");
        this.monitor.setCancelable(false);
        this.monitor.setDone();
    }

    private void checkCanceledOrPaused(SyncProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            this.doCancel();
        }
        while (monitor.isPaused()) {
            Util.sleep(1000L);
            if (!monitor.isCanceled()) continue;
            this.doCancel();
        }
    }

    private void doCancel() throws Exception {
        throw new CancelException();
    }

    public SiteProvider getSiteProvider() {
        return this.siteProvider;
    }

    public void setSiteProvider(SiteProvider siteProvider) {
        this.siteProvider = siteProvider;
    }

    public SyncProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(SyncProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public List<File> getLocalFilesNotToSync() {
        return this.localFilesNotToSync;
    }

    public void setLocalFilesNotToSync(List<File> localFilesNotToSync) {
        this.localFilesNotToSync = localFilesNotToSync == null ? new ArrayList() : localFilesNotToSync;
    }
}

