/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.core.config;

import ca.infodata.launcher.core.config.ConfigFileManager;
import ca.infodata.launcher.core.config.IConfig;
import ca.infodata.launcher.core.config.Version;
import ca.infodata.launcher.core.config.VersionDiff;
import ca.infodata.launcher.core.config.VersionSynchronizer;
import ca.infodata.launcher.core.config.command.AbstractCommand;
import ca.infodata.launcher.core.config.command.BuildBatCommand;
import ca.infodata.launcher.core.config.command.BuildProxyCommand;
import ca.infodata.launcher.core.config.command.ChangeLanguageCommand;
import ca.infodata.launcher.core.config.command.CheckVersionCommand;
import ca.infodata.launcher.core.config.command.CheckVersionCommand2;
import ca.infodata.launcher.core.config.command.CreateShortCutCommand;
import ca.infodata.launcher.core.config.command.HelpCommand;
import ca.infodata.launcher.core.config.command.HelpCommand2;
import ca.infodata.launcher.core.config.command.KnowInstallCommand;
import ca.infodata.launcher.core.config.command.NeedNormalStreamCommand;
import ca.infodata.launcher.core.config.command.NoFlushCommand;
import ca.infodata.launcher.core.config.command.NoShortCutCommand;
import ca.infodata.launcher.core.config.command.SkipValidationCommand;
import ca.infodata.launcher.core.config.command.UpdateCommand;
import ca.infodata.launcher.core.config.command.UpdateLauncherCommand;
import ca.infodata.launcher.core.config.command.UpdateLauncherRetroCommand;
import ca.infodata.launcher.core.config.command.WaitCommand;
import ca.infodata.launcher.download.DownloadSite;
import ca.infodata.launcher.download.MultiSiteResourceDownload;
import ca.infodata.launcher.download.Resource;
import ca.infodata.launcher.download.SiteProvider;
import ca.infodata.launcher.download.StringDownload;
import ca.infodata.launcher.download.UrlUtil;
import ca.infodata.launcher.exception.NoMoreDownloadProdiderException;
import ca.infodata.launcher.exception.NotToSendException;
import ca.infodata.launcher.exception.PopupInformationException;
import ca.infodata.launcher.exception.PopupInformationWithQuestionException;
import ca.infodata.launcher.util.LauncherLogger;
import ca.infodata.launcher.util.SyncProgressMonitor;
import ca.infodata.launcher.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JOptionPane;

public abstract class AbstractConfig
implements IConfig {
    private List<AbstractCommand> commands;
    private List<AbstractCommand> commandsRegister = new ArrayList<AbstractCommand>();
    private Properties applicationProperties;
    private Properties proxyProperties;
    private File installFolder;
    private File rootFolder;
    private File applicationFolder;
    private File launcherFolder;
    private File updateFolder;
    private File oldUpdateFolder;
    private SiteProvider applicationSiteProvider;
    private SiteProvider launcherSiteProvider;
    private ConfigFileManager configFileManager;
    private boolean updateCommand;
    private Version applicationInstalledVersion;
    private List<Version> applicationRemoteVersions;
    private Version launcherRemoteVersion;

    public AbstractConfig(String[] args) throws Exception {
        this.commandsRegister.add(new HelpCommand(this));
        this.commandsRegister.add(new HelpCommand2(this));
        this.commandsRegister.add(new ChangeLanguageCommand(this));
        this.commandsRegister.add(new BuildBatCommand(this));
        this.commandsRegister.add(new BuildProxyCommand(this));
        this.commandsRegister.add(new CreateShortCutCommand(this));
        this.commandsRegister.add(new KnowInstallCommand(this));
        this.commandsRegister.add(new CheckVersionCommand(this));
        this.commandsRegister.add(new CheckVersionCommand2(this));
        this.commandsRegister.add(new WaitCommand(this));
        this.commandsRegister.add(new UpdateLauncherCommand(this));
        this.commandsRegister.add(new UpdateLauncherRetroCommand(this));
        this.commandsRegister.add(new NoFlushCommand(this));
        this.commandsRegister.add(new NeedNormalStreamCommand(this));
        this.commandsRegister.add(new SkipValidationCommand(this));
        this.commandsRegister.add(new NoShortCutCommand(this));
        this.commandsRegister.add(new UpdateCommand(this));
        this.__initSetCommandRegister(this.commandsRegister);
        this.commands = new ArrayList<AbstractCommand>();
        this.applicationProperties = new Properties();
        this.listCommands(args);
        this.finishInit();
    }

    protected abstract String __initGetApplicationName();

    protected abstract String __initGetRootFolderName();

    protected abstract String __initGetApplicationFolderName();

    protected abstract String __initGetApplicationLanguageFileName();

    protected abstract String __initGetConfigFileClassPath();

    protected abstract String __initGetApplicationVersionFileName();

    protected abstract String __initGetLauncherJarName();

    protected abstract String __initGetApplicationMacAppZipFile();

    protected abstract String __initGetApplicationMacApp();

    protected abstract List<File> __initGetVersionSynchronizerExceptions();

    protected void __initSetCommandRegister(List<AbstractCommand> commandsRegister2) {
    }

    private void finishInit() throws Exception {
        LauncherLogger.getInstance().init();
        LauncherLogger.getInstance().log("---- Parameter used for the launcher ----");
        for (AbstractCommand ac : this.commands) {
            LauncherLogger.getInstance().log(ac.toString());
        }
        this.initGeneralConfig();
        this.initInstallFolder();
        this.rootFolder = new File(this.installFolder, this.__initGetRootFolderName());
        this.applicationFolder = new File(this.rootFolder, this.__initGetApplicationFolderName());
        this.launcherFolder = new File(this.rootFolder, "launcher");
        this.updateFolder = new File(this.rootFolder, "temp");
        this.oldUpdateFolder = new File(this.rootFolder, "update");
        this.initProxyInfo();
        UrlUtil.configureHttpsTrustStore();
        this.initLanguage();
        this.initGeneralConfigWithDistantURL();
        this.initProvider();
        this.configFileManager = new ConfigFileManager(this.rootFolder);
        this.configFileManager.setConfigPropFromFoundFiles();
        this.configFileManager.logConfigFiles();
    }

    private void initProvider() throws Exception {
        LauncherLogger.getInstance().log("Init download site providers...");
        String[] ops = this.applicationProperties.getProperty("application.download").split(";");
        this.applicationProperties.remove("application.download");
        ArrayList<DownloadSite> ds = new ArrayList<DownloadSite>();
        for (String op : ops) {
            ds.add(new DownloadSite(op));
            LauncherLogger.getInstance().log("  application site: " + op);
        }
        this.applicationSiteProvider = new SiteProvider(ds);
        ops = this.applicationProperties.getProperty("launcher.download").split(";");
        this.applicationProperties.remove("launcher.download");
        ds = new ArrayList();
        for (String op : ops) {
            ds.add(new DownloadSite(op));
            LauncherLogger.getInstance().log("  Launcher site: " + op);
        }
        this.launcherSiteProvider = new SiteProvider(ds);
    }

    private void initLanguage() {
        File lgFile = new File(this.rootFolder, this.__initGetApplicationLanguageFileName());
        String lg = "fr_ca";
        if (lgFile.exists()) {
            lg = Util.readFile(lgFile);
        }
        this.applicationProperties.put("osgi.nl", lg);
        LauncherLogger.getInstance().log("->Choosen langage: " + lg);
    }

    private void initProxyInfo() throws Exception {
        File lgFile = new File(this.rootFolder, "proxy.prop");
        LauncherLogger.getInstance().log("->Check for proxy... (" + lgFile.getAbsolutePath() + ")");
        if (lgFile.exists()) {
            this.proxyProperties = new Properties();
            LauncherLogger.getInstance().log("\tProxy exist : loading applicationProperties.  If nothing happen after, remove the proxy file.");
            Properties p = new Properties();
            FileInputStream sras = new FileInputStream(lgFile);
            p.load(sras);
            this.proxyProperties.putAll((Map<?, ?>)p);
            for (Map.Entry<Object, Object> set : p.entrySet()) {
                if (set.getValue() == null || ((String)set.getValue()).trim().length() <= 0) continue;
                System.setProperty((String)set.getKey(), (String)set.getValue());
            }
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                LauncherLogger.getInstance().log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initInstallFolder() throws Exception {
        block25: {
            String applicationName;
            block24: {
                applicationName = this.__initGetApplicationName();
                LauncherLogger.getInstance().log("Init Install Folder");
                if (!this.applicationProperties.containsKey("gmf-install")) break block24;
                LauncherLogger.getInstance().log("It's a gmf install.");
                File f = new File("C://infodata/");
                if (!this.isApplicationInstallThere(f)) {
                    LauncherLogger.getInstance().log(applicationName + " is not install gmf in : " + f + ".");
                    LauncherLogger.getInstance().log("Is " + f + " base folder exist?");
                    if (!f.exists()) {
                        LauncherLogger.getInstance().log("No he don't: ask user if he want to create the folder:");
                        int response = JOptionPane.showConfirmDialog(null, applicationName + " n'est pr\u00e9sentement pas install\u00e9 et d\u00e9sire cr\u00e9er le dossier C://Infodata/ pour poursuivre.\n\nVoulez-vous permettre \u00e0 " + applicationName + " de cr\u00e9er le dossier?");
                        System.out.println("REPONSE: " + response);
                        if (response == 0) {
                            LauncherLogger.getInstance().log("User want launcher to create the folder.");
                            f.mkdir();
                            if (!f.exists()) {
                                LauncherLogger.getInstance().log(Level.SEVERE, "failed to create folder " + f);
                                throw new PopupInformationException("Vous avez lanc\u00e9 " + applicationName + " en mode 'GMF' et demand\u00e9 \u00e0 " + this.__initGetApplicationName() + " de cr\u00e9er le dossier " + f + ".  Cette op\u00e9ration a \u00e9chou\u00e9.  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur le dossier 'C://infodata/' .  Veuillez contacter votre CSA.");
                            }
                            LauncherLogger.getInstance().log("Launcher has created " + f + " successful!");
                        } else {
                            LauncherLogger.getInstance().log(Level.WARNING, "User don't want to create the folder. It will throw an error.");
                        }
                    } else {
                        LauncherLogger.getInstance().log("Yes, he exist!");
                    }
                    if (!this.isFolderHasRight(f)) {
                        throw new PopupInformationException("Vous avez lanc\u00e9 " + applicationName + "en mode 'GMF'.  Cette op\u00e9ration a \u00e9chou\u00e9.  Vous devez avoir les droits d'\u00e9criture/lecture/modification sur le dossier 'C://infodata/' .  Veuillez contacter votre CSA.");
                    }
                    this.installFolder = f;
                    break block25;
                } else {
                    LauncherLogger.getInstance().log(applicationName + " is install.");
                    if (!this.isFolderHasRight(f)) throw new PopupInformationException(applicationName + " est install\u00e9 dans " + f + " mais ne poss\u00e8de pas les droits suffisants pour se lancer correctement. Corrigez ce probl\u00e8me et relancez " + applicationName + ".");
                    this.installFolder = f;
                }
                break block25;
            }
            LauncherLogger.getInstance().log("It's a normal (user profile) install.");
            String homePath = System.getProperty("user.home");
            boolean canBeJH = false;
            File homeApplicationFile = new File(homePath);
            if (this.isApplicationInstallThere(homeApplicationFile)) {
                LauncherLogger.getInstance().log(applicationName + " is install.");
                if (!this.isFolderHasRight(homeApplicationFile)) throw new PopupInformationException(applicationName + " est install\u00e9 dans " + homeApplicationFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez " + applicationName + ".");
                this.installFolder = homeApplicationFile;
            } else {
                LauncherLogger.getInstance().log(applicationName + " is not install.");
                if (this.isFolderHasRight(homeApplicationFile)) {
                    LauncherLogger.getInstance().log("K");
                    canBeJH = true;
                }
            }
            boolean canBeWH = false;
            File wApplicationFile = null;
            if (this.installFolder == null && Util.isWindows()) {
                LauncherLogger.getInstance().log("On windows, check for the other home file.");
                wApplicationFile = new File(System.getenv().get("USERPROFILE"));
                if (this.isApplicationInstallThere(wApplicationFile)) {
                    LauncherLogger.getInstance().log(applicationName + " is install.");
                    if (!wApplicationFile.exists()) throw new PopupInformationException(applicationName + " est install\u00e9 dans " + wApplicationFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez " + applicationName + ".");
                    if (!this.isFolderHasRight(wApplicationFile)) throw new PopupInformationException(applicationName + " est install\u00e9 dans " + wApplicationFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez " + applicationName + ".");
                    this.installFolder = wApplicationFile;
                } else if (!canBeJH) {
                    LauncherLogger.getInstance().log(applicationName + " is not install.");
                    if (wApplicationFile.exists() && this.isFolderHasRight(wApplicationFile)) {
                        canBeWH = true;
                    }
                }
            }
            if (this.installFolder == null) {
                LauncherLogger.getInstance().log(applicationName + " is definitively not install, so we gonna look what is the best way to install.");
                if (canBeJH) {
                    this.installFolder = homeApplicationFile;
                } else if (canBeWH) {
                    this.installFolder = wApplicationFile;
                } else {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder().append("Vous avez tentez de lancer ").append(applicationName).append(" dans votre r\u00e9pertoire utilisateur (").append(homeApplicationFile.getAbsolutePath());
                    if (wApplicationFile == null) {
                        string = "";
                        throw new PopupInformationException(stringBuilder.append(string).append(").  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur votre dossier.  Veuillez contacter votre CSA. ").toString());
                    }
                    string = ", " + wApplicationFile.getAbsolutePath();
                    throw new PopupInformationException(stringBuilder.append(string).append(").  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur votre dossier.  Veuillez contacter votre CSA. ").toString());
                }
            }
        }
        if (!this.installFolder.exists()) {
            LauncherLogger.getInstance().log("Install folder '" + this.installFolder.getAbsolutePath() + "' doesn't exist. We gonna create it.");
            this.installFolder.mkdirs();
        }
        LauncherLogger.getInstance().log("Dossier d'installation : " + this.installFolder.getAbsolutePath() + " : " + this.installFolder.isDirectory());
    }

    @Override
    public boolean isFolderHasRight(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            String tt;
            File fTest = new File(folder, "accesTestFile");
            Util.saveToFile(fTest, "test", Charset.defaultCharset());
            if (fTest.exists() && "test".equals(tt = Util.readFile(fTest))) {
                fTest.delete();
                if (!fTest.exists()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isApplicationInstallThere(File pInstallFolder) {
        File root = new File(pInstallFolder, this.__initGetRootFolderName());
        File application = new File(root, this.__initGetApplicationFolderName());
        File version = new File(application, this.__initGetApplicationVersionFileName());
        LauncherLogger.getInstance().log("Is " + this.__initGetApplicationName() + " installed here? " + version.exists() + " : " + version.getAbsolutePath());
        return version.exists();
    }

    @Override
    public AbstractCommand getCommand(String command) {
        for (AbstractCommand ac : this.commands) {
            if (!ac.getCommandName().equals(command)) continue;
            return ac;
        }
        return null;
    }

    private void initGeneralConfig() throws Exception {
        LauncherLogger.getInstance().log("---- Init application launch config ----");
        Properties p = new Properties();
        InputStream sras = this.getClass().getClassLoader().getResourceAsStream(this.__initGetConfigFileClassPath());
        p.load(sras);
        this.applicationProperties.putAll((Map<?, ?>)p);
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            LauncherLogger.getInstance().log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
        }
    }

    private void initGeneralConfigWithDistantURL() throws Exception {
        LauncherLogger.getInstance().log("---- Init application launch config with distanct URL----");
        String relais = this.applicationProperties.getProperty("relais");
        LauncherLogger.getInstance().log("*** relais = " + relais);
        if (Util.isNotBlank(relais)) {
            String[] rels;
            for (String r : rels = relais.split(";")) {
                URL url = new URL(r);
                Properties props = this.readPropertiesFromUrl(url);
                if (props != null) {
                    LauncherLogger.getInstance().log("Relais file found to " + url);
                    String isActive = props.getProperty("active");
                    LauncherLogger.getInstance().log("  *isActive?" + isActive);
                    if (!"true".equalsIgnoreCase(isActive)) break;
                    this.applicationProperties.putAll((Map<?, ?>)props);
                    LauncherLogger.getInstance().log(Level.WARNING, "Server is down or Relais config simply activated to launch application at :" + url);
                    LauncherLogger.getInstance().log("  Properties overridden:");
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        LauncherLogger.getInstance().log("    -" + entry.getKey() + "\t:\t" + entry.getValue());
                    }
                    break;
                }
                LauncherLogger.getInstance().log("Relais file NOT found (" + url + ")");
            }
        }
        LauncherLogger.getInstance().log("FINAL RESULT: ");
        for (Map.Entry<Object, Object> entry : this.applicationProperties.entrySet()) {
            LauncherLogger.getInstance().log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
        }
    }

    private void listCommands(String[] args) throws NotToSendException {
        ArrayList<String> params;
        for (int index = 0; index < args.length; index += params.size() + 1) {
            String param;
            String sA = args[index];
            AbstractCommand ac = null;
            for (AbstractCommand act : this.commandsRegister) {
                if (!act.getCommandName().equals(sA)) continue;
                ac = act;
                break;
            }
            if (ac == null) {
                throw new NotToSendException("No commands exist for '" + sA + "'.  User -h or -help.");
            }
            params = new ArrayList<String>();
            while (index + 1 + params.size() < args.length && ac.isValidParameter(param = args[index + 1 + params.size()])) {
                params.add(param);
            }
            ac.setParameters(params);
            this.commands.add(ac);
        }
    }

    public Properties readPropertiesFromUrl(URL url) throws Exception {
        Properties prop = null;
        try {
            LauncherLogger.getInstance().log("Read index of : " + url);
            StringDownload download = new StringDownload(url, "propertiesFromUrl");
            download.setMonitor(new SyncProgressMonitor());
            download.run();
            String text = download.getString();
            Properties propTemp = new Properties();
            propTemp.load(new StringReader(text));
            if (propTemp.size() > 0) {
                prop = propTemp;
            }
        }
        catch (Exception e) {
            LauncherLogger.getInstance().log("Exception readPropertiesFromUrl: " + e.getMessage());
        }
        return prop;
    }

    @Override
    public String readInstalledDotVersion() {
        try {
            File file = Util.findFileRecursive(this.applicationFolder, this.__initGetApplicationVersionFileName());
            if (file != null) {
                return Util.readFile(file);
            }
        }
        catch (Exception e) {
            LauncherLogger.getInstance().log(Level.INFO, "Failed to read installed " + this.__initGetApplicationVersionFileName() + " cause of " + e.getMessage());
        }
        return null;
    }

    @Override
    public Version getInstalledVersion() throws Exception {
        if (this.applicationInstalledVersion == null) {
            this.applicationInstalledVersion = this.getInstalledVersion(this.applicationFolder);
        }
        return this.applicationInstalledVersion;
    }

    private Version getInstalledVersion(File root) throws Exception {
        List<File> localFiles = Util.listFilesFromDirectoryRecursive(root);
        Version version = new Version();
        version.name = "installed";
        version.root = root;
        version.index = new ArrayList<Resource>();
        for (File file : localFiles) {
            Resource resource = new Resource();
            resource.setPath(file.getAbsolutePath().substring(version.root.getAbsolutePath().length() + 1).replace("\\", "/"));
            resource.setMd5(Util.computeMd5(file));
            resource.setLength(file.length());
            resource.setFile(file);
            version.index.add(resource);
        }
        return version;
    }

    @Override
    public List<Version> getRemoteVersions() throws NoMoreDownloadProdiderException, PopupInformationWithQuestionException {
        if (this.applicationRemoteVersions == null) {
            this.applicationRemoteVersions = this.getRemoteVersions(this.applicationSiteProvider);
            if (this.applicationRemoteVersions.isEmpty()) {
                throw new PopupInformationWithQuestionException("Aucune version de " + this.__initGetApplicationName() + " n'est disponible");
            }
        }
        return this.applicationRemoteVersions;
    }

    private List<Version> getRemoteVersions(SiteProvider siteProvider) throws NoMoreDownloadProdiderException {
        MultiSiteResourceDownload download = new MultiSiteResourceDownload(siteProvider.getSites());
        String versionsTextPlain = download.downloadString(new Resource("versions.txt"));
        String[] versionNames = Util.splitByLine(versionsTextPlain);
        ArrayList<Version> versions = new ArrayList<Version>();
        for (String name : versionNames) {
            if (!Util.isNotBlank(name) || name.startsWith("#")) continue;
            try {
                versions.add(this.readVersion(siteProvider, name));
            }
            catch (Exception e) {
                LauncherLogger.getInstance().log(Level.WARNING, "Failed to get version " + name + ". Version will be ignored.");
            }
        }
        LauncherLogger.getInstance().log("Retrieved versions : ");
        for (Version version : versions) {
            LauncherLogger.getInstance().log(version.name);
        }
        return versions;
    }

    private Version readVersion(SiteProvider siteProvider, String name) throws Exception {
        Version version = new Version();
        try {
            version.name = name;
            version.index = new ArrayList<Resource>();
            MultiSiteResourceDownload download = new MultiSiteResourceDownload(siteProvider.getSites());
            String indexTextPlain = download.downloadString(new Resource(name + "/index.txt"));
            String[] lines = Util.splitByLine(indexTextPlain);
            for (int i = 0; i < lines.length; ++i) {
                Resource e = new Resource();
                e.setPath(lines[i].trim());
                e.setMd5(lines[++i].trim());
                e.setLength(Long.valueOf(lines[++i].trim()));
                version.index.add(e);
            }
        }
        catch (Exception e) {
            LauncherLogger.getInstance().log(Level.WARNING, "Failed to read index.txt of version " + name);
            throw e;
        }
        return version;
    }

    @Override
    public Version getLauncherInstalledVersion() throws Exception {
        return this.getInstalledVersion(this.launcherFolder);
    }

    @Override
    public Version getLauncherTempInstalledVersion() throws Exception {
        return this.getInstalledVersion(this.updateFolder);
    }

    @Override
    public Version getLauncherRemoteVersion() throws NoMoreDownloadProdiderException, PopupInformationWithQuestionException {
        if (this.launcherRemoteVersion == null) {
            List<Version> versions = this.getRemoteVersions(this.launcherSiteProvider);
            if (versions.isEmpty()) {
                throw new PopupInformationWithQuestionException("Aucune version du lanceur n'est disponible");
            }
            this.launcherRemoteVersion = versions.get(versions.size() - 1);
        }
        return this.launcherRemoteVersion;
    }

    @Override
    public void installApplication(SyncProgressMonitor monitor, Version versionToInstall) throws Exception {
        VersionDiff diff = new VersionDiff(this.getInstalledVersion(), versionToInstall);
        this.applicationInstalledVersion = null;
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setLocalFilesNotToSync(this.__initGetVersionSynchronizerExceptions());
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(this.applicationSiteProvider);
        synchronizer.sync();
        this.createShortCut();
        this.configFileManager.tryToFlushAllConfigs();
    }

    @Override
    public void installLauncher(SyncProgressMonitor monitor) throws Exception {
        Version remote = this.getLauncherRemoteVersion();
        VersionDiff diff = new VersionDiff(this.getLauncherInstalledVersion(), remote);
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(this.launcherSiteProvider);
        synchronizer.sync();
    }

    @Override
    public void sync(VersionDiff diff, SiteProvider siteProvider, SyncProgressMonitor monitor) throws Exception {
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setLocalFilesNotToSync(this.__initGetVersionSynchronizerExceptions());
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(siteProvider);
        synchronizer.sync();
    }

    @Override
    public void saveLangageFile() {
        File lgFile = new File(this.rootFolder, this.__initGetApplicationLanguageFileName());
        boolean mustSave = false;
        if (lgFile.exists()) {
            String lg = Util.readFile(lgFile);
            if (!lg.equals(this.applicationProperties.get("osgi.nl"))) {
                mustSave = true;
                lgFile.delete();
            }
        } else {
            mustSave = true;
        }
        if (mustSave) {
            Util.saveToFile(lgFile, (String)this.applicationProperties.get("osgi.nl"), Charset.forName("US-ASCII"));
        }
        LauncherLogger.getInstance().log("->Save new choosen langage: " + this.applicationProperties.get("osgi.nl"));
    }

    @Override
    public void createShortCut() throws Exception {
        this.deleteShortcut();
        LauncherLogger.getInstance().log(Level.INFO, "####################");
        LauncherLogger.getInstance().log(Level.INFO, "---->create shortcut");
        LauncherLogger.getInstance().log(Level.INFO, "####################");
        File avoidShortcutFile = new File(this.rootFolder, "no-shortcut.flag");
        if (avoidShortcutFile.exists()) {
            LauncherLogger.getInstance().log(Level.INFO, "\tNo shortcut flag found : wont create the shortcut.");
        } else if (Util.isWindows()) {
            String vbs = " Dim WSHShell\n Set WSHShell = _\n    WScript.CreateObject(\"WScript.Shell\")\n Dim MyShortcut, MyDesktop, DesktopPath\n ' Read desktop path using WshSpecialFolders object\n DesktopPath = _\n    WSHShell.SpecialFolders(\"Desktop\")\n ' Create a shortcut object on the desktop\n Set MyShortcut = _\n    WSHShell.CreateShortcut( _\n    DesktopPath & \"\\" + this.__initGetApplicationName() + ".lnk\")\n" + " ' Set shortcut object applicationProperties and save it\n" + " MyShortcut.TargetPath = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"\"\"" + this.launcherFolder.getAbsolutePath() + "\\" + this.__initGetLauncherJarName() + "\"\"\")\n" + " MyShortcut.WorkingDirectory = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"" + this.applicationFolder.getAbsolutePath() + "\")\n" + " MyShortcut.WindowStyle = 4\n" + " MyShortcut.IconLocation = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"" + this.applicationFolder.getAbsolutePath() + "\\appIcon.ico\")\n" + " MyShortcut.Save\n";
            File f = new File(this.rootFolder, "shortcut.vbs");
            Util.saveToFile(f, vbs, Charset.defaultCharset());
            LauncherLogger.getInstance().log(Level.INFO, "---->createShortCut Windows");
            try {
                String cmd = "wscript \"" + f.getAbsolutePath() + "\"";
                LauncherLogger.getInstance().log("CMD :" + cmd);
                Process proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
                f.deleteOnExit();
            }
            catch (Exception e) {
                LauncherLogger.getInstance().log(Level.SEVERE, e);
            }
        } else {
            LauncherLogger.getInstance().log(Level.INFO, "---->createShortCut Mac");
            File fAppZip = new File(this.applicationFolder, this.__initGetApplicationMacAppZipFile());
            if (fAppZip.exists()) {
                Util.unzip(fAppZip, this.rootFolder);
            }
            File fApp = new File(this.rootFolder, this.__initGetApplicationMacApp());
            File desktopFile = new File(System.getProperty("user.home", ""), "Desktop");
            LauncherLogger.getInstance().log(Level.INFO, "From " + fApp + " to " + desktopFile);
            if (fApp.exists() && desktopFile.exists()) {
                try {
                    File macosxFolder;
                    LauncherLogger.getInstance().log(Level.INFO, "COPY");
                    File shortcut = new File(desktopFile, this.__initGetApplicationName() + ".app");
                    Util.copyDirectory(fApp, shortcut);
                    LauncherLogger.getInstance().log(Level.INFO, "AJUST RIGHTS");
                    String[] cmd1 = new String[]{"chmod", "-R", "777", fApp.getAbsolutePath()};
                    String[] cmd2 = new String[]{"chmod", "-R", "777", shortcut.getAbsolutePath()};
                    LauncherLogger.getInstance().log(Level.INFO, "CMD1 :" + AbstractConfig.getStringOfTableCmd(cmd1));
                    Process proc = Runtime.getRuntime().exec(cmd1);
                    proc.waitFor();
                    LauncherLogger.getInstance().log(Level.INFO, "CMD2 :" + AbstractConfig.getStringOfTableCmd(cmd2));
                    Process proc2 = Runtime.getRuntime().exec(cmd2);
                    proc2.waitFor();
                    File olPathFile = new File(shortcut, "Contents/Resources/script");
                    if (olPathFile.exists()) {
                        String contains = Util.readFile(olPathFile);
                        contains = contains.replace("PATH_OFYS_LAUNCHER", new File(this.launcherFolder, this.__initGetLauncherJarName()).getAbsolutePath());
                        Util.saveToFile(olPathFile, contains, Charset.defaultCharset());
                    }
                    if ((macosxFolder = new File(this.rootFolder, "__MACOSX")).exists()) {
                        String[] cmd3 = new String[]{"chmod", "-R", "777", macosxFolder.getAbsolutePath()};
                        LauncherLogger.getInstance().log(Level.INFO, "CMD3 :" + AbstractConfig.getStringOfTableCmd(cmd3));
                        Process proc3 = Runtime.getRuntime().exec(cmd3);
                        proc3.waitFor();
                        Util.deleteDirectory(macosxFolder);
                    }
                    LauncherLogger.getInstance().log(Level.INFO, "DELETE");
                    Util.deleteFile(fApp);
                }
                catch (Exception e) {
                    LauncherLogger.getInstance().log(Level.INFO, e);
                }
            } else {
                LauncherLogger.getInstance().log(Level.SEVERE, "Impossible de d\u00e9compresser " + fAppZip.getAbsolutePath() + ":" + fAppZip.exists() + "/" + fApp.exists() + "/" + desktopFile.exists());
                throw new Exception("Impossible de d\u00e9compresser " + fAppZip.getAbsolutePath() + ".");
            }
        }
    }

    private void deleteShortcut() throws Exception {
        LauncherLogger logger = LauncherLogger.getInstance();
        logger.log("-- deleteShortcut --");
        File userHome = new File(System.getProperty("user.home"));
        File desktop = new File(userHome, "Desktop");
        if (Util.isWindows()) {
            logger.log("JAVA.HOME DIR TO CHECKED: " + userHome.getAbsolutePath() + " : " + userHome.exists());
            if (desktop.exists()) {
                Util.deleteFile(new File(desktop, this.__initGetApplicationName() + ".lnk"));
                Util.deleteFile(new File(desktop, this.__initGetApplicationName()));
                Util.deleteFile(new File(desktop, "MED\u00adOffice.lnk"));
            }
        }
        if (Util.isMac()) {
            File oldLink = new File(desktop, this.__initGetApplicationMacApp());
            Util.deleteDirectory(oldLink);
            File link = new File(desktop, this.__initGetApplicationName() + ".app");
            Util.deleteDirectory(link);
        }
    }

    private void deleteShortcutOld() throws Exception {
        LauncherLogger logger = LauncherLogger.getInstance();
        logger.log("-- deleteShortcut --");
        File userHome = new File(System.getProperty("user.home"));
        File desktop = new File("Desktop");
        if (Util.isWindows()) {
            userHome = new File(desktop, this.__initGetApplicationName() + ".lnk");
            logger.log("JAVA.HOME DIR TO CHECKED: " + userHome.getAbsolutePath() + " : " + userHome.exists());
            if (!userHome.exists() && Util.isWindows()) {
                userHome = new File(System.getenv().get("USERPROFILE"));
                userHome = new File(desktop, this.__initGetApplicationName() + ".lnk");
                logger.log("Not in java.home, we are in windows: try with: " + userHome.getAbsolutePath() + " : " + userHome.exists());
            }
            if (!userHome.exists()) {
                logger.log(Level.WARNING, "Dossier 'Desktop/" + this.__initGetApplicationName() + ".lnk' introuvable.");
            } else if (userHome.delete()) {
                logger.log(userHome.getAbsolutePath() + " have been deleted...");
            } else {
                logger.log(Level.WARNING, "Unable to delete " + userHome.getAbsolutePath() + ". Gonna try to delete on exist.");
                userHome.deleteOnExit();
            }
        } else if (Util.isMac()) {
            userHome = new File(desktop, this.__initGetApplicationMacApp());
            if (userHome.exists()) {
                if (userHome.delete()) {
                    logger.log(userHome.getAbsolutePath() + " have been deleted...");
                } else if (Util.deleteDirectory(userHome) && userHome.isDirectory()) {
                    logger.log(userHome.getAbsolutePath() + " have been deleted...");
                } else {
                    logger.log(Level.WARNING, "Unable to delete " + userHome.getAbsolutePath() + ". Gonna try to delete on exist.");
                }
            } else {
                logger.log(Level.WARNING, "Can't find the " + userHome.getAbsolutePath() + "!!!!");
            }
        }
    }

    private static String getStringOfTableCmd(String[] t) {
        String s = "";
        for (String ss : t) {
            s = s + " " + ss;
        }
        return s;
    }

    @Override
    public File getInstallFolder() {
        return this.installFolder;
    }

    @Override
    public File getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public File getApplicationFolder() {
        return this.applicationFolder;
    }

    @Override
    public File getLauncherFolder() {
        return this.launcherFolder;
    }

    @Override
    public File getUpdateFolder() {
        return this.updateFolder;
    }

    @Override
    public File getOldUpdateFolder() {
        return this.oldUpdateFolder;
    }

    @Override
    public Properties getProperties() {
        return this.applicationProperties;
    }

    @Override
    public List<AbstractCommand> getCommandsRegister() {
        return this.commandsRegister;
    }

    @Override
    public boolean isUpdateCommand() {
        return this.updateCommand;
    }

    @Override
    public void setUpdateCommand(boolean updateCommand) {
        this.updateCommand = updateCommand;
    }

    @Override
    public SiteProvider getApplicationSiteProvider() {
        return this.applicationSiteProvider;
    }

    @Override
    public SiteProvider getLauncherSiteProvider() {
        return this.launcherSiteProvider;
    }

    @Override
    public ConfigFileManager getConfigFileManager() {
        return this.configFileManager;
    }
}

