/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.core.config.command;

import ca.infodata.launcher.core.config.IConfig;
import ca.infodata.launcher.core.config.command.AbstractCommand;
import ca.infodata.launcher.exception.NotToSendException;
import ca.infodata.launcher.util.LauncherLogger;
import java.util.HashMap;
import java.util.Map;

public class HelpCommand
extends AbstractCommand {
    public HelpCommand(IConfig config) {
        super(config);
    }

    @Override
    public String getCommandName() {
        return "-help";
    }

    @Override
    public int getMaxParameter() {
        return 0;
    }

    @Override
    public boolean isValidParameter(String value) {
        return false;
    }

    @Override
    public void execute() throws Exception {
        int maxCmdLength = 0;
        int maxParamLenth = 0;
        int spacingCmd = 8;
        int spacingParam = 12;
        int maxChar = 64;
        for (AbstractCommand ac : this.getConfig().getCommandsRegister()) {
            maxCmdLength = Math.max(maxCmdLength, ac.getCommandName().length());
            for (Map.Entry<String, String> e : ac.getHelpParameters().entrySet()) {
                maxParamLenth = Math.max(maxParamLenth, e.getKey().length());
            }
        }
        LauncherLogger log = LauncherLogger.getInstance();
        log.log("Voici les commandes disponibles :");
        for (AbstractCommand ac : this.getConfig().getCommandsRegister()) {
            String line = "  " + ac.getCommandName() + " : ";
            while (line.length() < maxCmdLength + spacingCmd) {
                line = line + " ";
            }
            String desc = ac.getHelpDescription();
            while (desc != null) {
                if (desc.length() > maxChar - maxCmdLength - spacingCmd) {
                    line = line + desc.substring(0, maxChar - maxCmdLength - spacingCmd);
                    desc = desc.substring(maxChar - maxCmdLength - spacingCmd);
                    log.log(line);
                    line = "";
                    while (line.length() < maxCmdLength + spacingCmd) {
                        line = line + " ";
                    }
                    continue;
                }
                line = line + desc;
                desc = null;
            }
            log.log(line);
            for (Map.Entry<String, String> e : ac.getHelpParameters().entrySet()) {
                line = "    " + e.getKey();
                while (line.length() < maxParamLenth + spacingParam) {
                    line = line + " ";
                }
                desc = e.getValue();
                while (desc != null) {
                    if (desc.length() > maxChar - maxParamLenth - spacingParam) {
                        line = line + desc.substring(0, maxChar - maxParamLenth - spacingParam);
                        desc = desc.substring(maxChar - maxParamLenth - spacingParam);
                        log.log(line);
                        line = "";
                        while (line.length() < maxParamLenth + spacingParam) {
                            line = line + " ";
                        }
                        continue;
                    }
                    line = line + desc;
                    desc = null;
                }
                log.log(line);
            }
        }
        log.log("\n");
        throw new NotToSendException("Help occur!");
    }

    @Override
    public String getHelpDescription() {
        return "Give help";
    }

    @Override
    public Map<String, String> getHelpParameters() {
        return new HashMap<String, String>();
    }
}

