/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.medoffice.config.command;

import ca.infodata.launcher.core.config.IConfig;
import ca.infodata.launcher.core.config.command.AbstractCommand;
import ca.infodata.launcher.exception.PopupInformationException;
import ca.infodata.launcher.util.LauncherLogger;
import ca.infodata.launcher.util.Util;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class FlushBinCommand
extends AbstractCommand {
    public FlushBinCommand(IConfig config) {
        super(config);
    }

    @Override
    public String getCommandName() {
        return "-flush-bin";
    }

    @Override
    public int getMaxParameter() {
        return 0;
    }

    @Override
    public boolean isValidParameter(String value) {
        return false;
    }

    @Override
    public void execute() throws Exception {
        LauncherLogger.getInstance().log("  --  FLUSH BIN  --");
        this.tryToFlushBinFiles();
    }

    @Override
    public String getHelpDescription() {
        return "Clean '.bin' file of the '.medoffice' directory.";
    }

    @Override
    public Map<String, String> getHelpParameters() {
        return new HashMap<String, String>();
    }

    private void tryToFlushBinFiles() throws PopupInformationException {
        LauncherLogger logger = LauncherLogger.getInstance();
        logger.log("-- tryToFlushBinFiles --");
        File medHome = new File(System.getProperty("user.home"));
        medHome = new File(medHome, ".medoffice");
        logger.log("JAVA.HOME DIR TO CHECKED: " + medHome.getAbsolutePath() + " : " + medHome.exists());
        if (!medHome.exists() && Util.isWindows()) {
            medHome = new File(System.getenv().get("USERPROFILE"));
            medHome = new File(medHome, ".medoffice");
            logger.log("Not in java.home, we are in windows: try with: " + medHome.getAbsolutePath() + " : " + medHome.exists());
        }
        if (!medHome.exists()) {
            logger.log(Level.WARNING, "Dossier '.medoffice' introuvable.");
        } else {
            File[] files;
            boolean haveBeenDelete = true;
            for (File f : files = medHome.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.endsWith(".bin");
                }
            })) {
                boolean del = f.delete();
                logger.log("Try to delete " + f.getAbsolutePath() + " : " + del);
                haveBeenDelete = haveBeenDelete && del;
            }
            if (!haveBeenDelete) {
                throw new PopupInformationException("L'installateur n'est pas parvenu \u00e0 supprimer les fichier '*.bin' du dossier '.medoffice' pour compl\u00e9ter la mise-\u00e0-jour.  Il se pourrait que vous rencontriez des probl\u00e8mes en utilisant Med-Office.  Contactez-nous pour tout probl\u00e8me.\n\nVous pouvez relancer Med-Office.");
            }
        }
    }
}

