/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.download;

import ca.infodata.launcher.util.LauncherLogger;
import ca.infodata.launcher.util.RelaxSyncProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class DownloadProgressDialog
extends RelaxSyncProgressMonitor {
    private JDialog dialog;
    private JLabel label;
    private JProgressBar bar;
    private JButton btnCancel;
    private JButton btnClose;
    private boolean needClosedButton;

    public DownloadProgressDialog() {
        this.setNeedClosedButton(false);
        this.dialog = new JDialog(null, "Mise-\u00e0-jour en cours...", Dialog.ModalityType.MODELESS);
        this.label = new JLabel();
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.btnCancel = new JButton("Annuler");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadProgressDialog.this.setPaused(true);
                int r = JOptionPane.showOptionDialog(DownloadProgressDialog.this.dialog, "\u00cates-vous certains de vouloir annuler le t\u00e9l\u00e9chargement de Ofys.  Celui-ci est n\u00e9cessaire au bon fonctionnement de Ofys.", "Question", 0, 3, null, new Object[]{"Oui", "Non"}, "Non");
                if (r == 0) {
                    DownloadProgressDialog.this.setMessage("L'utilisateur \u00e0 annul\u00e9");
                    DownloadProgressDialog.this.setCanceled();
                } else {
                    DownloadProgressDialog.this.setPaused(false);
                }
            }
        });
        this.btnClose = new JButton("Terminer");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadProgressDialog.this.needClosedButton = false;
            }
        });
        this.btnClose.setVisible(false);
        JPanel panel = new JPanel();
        this.dialog.setContentPane(panel);
        BorderLayout layout = new BorderLayout();
        layout.setVgap(2);
        this.dialog.setLayout(layout);
        panel.add((Component)this.label, "North");
        panel.add((Component)this.bar, "Center");
        panel.add((Component)this.btnCancel, "South");
        panel.add((Component)this.btnClose, "East");
        this.dialog.setSize(500, 150);
        this.dialog.setDefaultCloseOperation(0);
    }

    public void setDialogTitleUpdate() {
        this.dialog.setTitle("Mise-\u00e0-jour en cours...");
    }

    public void setDialogTitleInstall() {
        this.dialog.setTitle("Installation en cours...");
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    private void updateLabel() {
        String text = "<html>";
        if (this.getCurrentTask() != null) {
            text = text + this.getCurrentTask();
        }
        text = this.getCurrentFile() != null ? text + "<br>" + this.getCurrentFile() : text + "<br>";
        text = this.getMessage() != null ? text + "<br><font color='red'>" + this.getMessage() + "</font>" : text + "<br>";
        final String text2 = text = text + "<html>";
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.label.setText(text2);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DownloadProgressDialog.this.label.setText(text2);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateOverride() {
        String barText;
        int worked;
        int total;
        if (this.getTotalBytes() != null) {
            int currentWorked = 0;
            if (this.getCurrentFileWorkedBytes() != null) {
                currentWorked = (int)(this.getCurrentFileWorkedBytes() / 1024L);
            }
            total = this.getTotalBytes().intValue() / 1024;
            int worked2 = (this.getWorkedBytes() == null ? 0 : this.getWorkedBytes().intValue()) / 1024;
            worked = worked2 += currentWorked;
            int percent = total == 0 ? 100 : worked * 100 / total;
            barText = percent + "%";
        } else {
            total = 0;
            worked = 0;
            barText = "";
        }
        final String barText2 = barText;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.bar.setMinimum(0);
                this.bar.setMaximum(total);
                this.bar.setValue(worked);
                this.bar.setString(barText);
                this.btnCancel.setEnabled(this.isCancelable());
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DownloadProgressDialog.this.bar.setMinimum(0);
                        DownloadProgressDialog.this.bar.setMaximum(total);
                        DownloadProgressDialog.this.bar.setValue(worked);
                        DownloadProgressDialog.this.bar.setString(barText2);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDone() {
        super.setDone();
        try {
            this.dialog.remove(this.btnCancel);
            this.btnCancel.setVisible(false);
            this.dialog.remove(this.bar);
            this.dialog.add((Component)this.btnClose, "South");
            this.btnClose.setVisible(true);
            String text = "<html>Pour finaliser la mise-\u00e0-jour, fermez toutes les instances d'Ofys et r\u00e9ouvrez Ofys.";
            text = text + "<br/>T\u00e9l\u00e9chargement termin\u00e9!</html>";
            this.label.setText(text);
            this.dialog.setSize(500, 100);
            this.dialog.toFront();
            this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.dialog.setAlwaysOnTop(true);
            while (this.needClosedButton) {
                Thread.sleep(1000L);
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialog.this.dialog.setVisible(false);
                }
            });
        }
        catch (Exception e) {
            LauncherLogger.getInstance().log(Level.SEVERE, e);
        }
    }

    @Override
    public void setCanceled() {
        super.setCanceled();
        this.getDialog().setVisible(false);
    }

    @Override
    public void setPaused(boolean b) {
        super.setPaused(b);
    }

    public boolean isNeedClosedButton() {
        return this.needClosedButton;
    }

    public void setNeedClosedButton(boolean needClosedButton) {
        this.needClosedButton = needClosedButton;
    }

    @Override
    public void setCurrentFile(String currentFile) {
        this.currentFile = currentFile;
        this.updateLabel();
    }

    @Override
    public void setCurrentTask(String currentTask) {
        this.currentTask = currentTask;
        this.updateLabel();
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
        this.updateLabel();
    }
}

