/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.core.config.command;

import ca.infodata.launcher.core.config.IConfig;
import ca.infodata.launcher.exception.NotToSendException;
import java.util.List;
import java.util.Map;

public abstract class AbstractCommand {
    private List<String> parameters;
    private final IConfig config;

    public AbstractCommand(IConfig config) {
        this.config = config;
    }

    public IConfig getConfig() {
        return this.config;
    }

    public abstract String getCommandName();

    public abstract int getMaxParameter();

    public abstract boolean isValidParameter(String var1);

    public abstract void execute() throws Exception;

    public abstract String getHelpDescription();

    public abstract Map<String, String> getHelpParameters();

    public void setParameters(List<String> parameters) throws NotToSendException {
        if (this.parameters != null) {
            throw new NotToSendException("This parameter already exist!");
        }
        if (parameters.size() > this.getMaxParameter()) {
            throw new NotToSendException("Too much paramater for command " + this.getCommandName());
        }
        this.parameters = parameters;
    }

    public boolean haveParameter(String key) {
        for (String k : this.parameters) {
            if (!key.equals(k)) continue;
            return true;
        }
        return false;
    }

    public String getParameter(int index) {
        if (index < this.parameters.size()) {
            return this.parameters.get(index);
        }
        return null;
    }

    public String toString() {
        String st = "  " + this.getCommandName();
        if (this.parameters.size() > 0) {
            st = st + " (";
        }
        boolean isFirst = true;
        for (String p : this.parameters) {
            if (isFirst) {
                isFirst = false;
            } else {
                st = st + ", ";
            }
            st = st + p;
        }
        if (this.parameters.size() > 0) {
            st = st + " )";
        }
        return st;
    }
}

