/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.core.config;

import ca.infodata.launcher.core.config.Version;
import ca.infodata.launcher.download.Resource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VersionDiff {
    public final Version local;
    public final Version remote;
    public final List<Resource> toDelete;
    public final List<Resource> toDownload;

    public VersionDiff(Version local, Version remote, List<File> fileNotToSync) {
        this.local = local;
        this.remote = remote;
        this.toDelete = new ArrayList<Resource>();
        this.toDownload = new ArrayList<Resource>();
        if (fileNotToSync != null) {
            ArrayList<Resource> lstToRemove = new ArrayList<Resource>();
            for (Resource resource : this.local.index) {
                if (!fileNotToSync.contains(resource.getFile())) continue;
                lstToRemove.add(resource);
            }
            if (!lstToRemove.isEmpty()) {
                this.local.index.removeAll(lstToRemove);
            }
        }
        this.compare();
    }

    public boolean noDiff() {
        return this.toDelete.size() == 0 && this.toDownload.size() == 0;
    }

    public boolean hasDiff() {
        return !this.noDiff();
    }

    public void setDeleteAllDownloadAll() {
        this.toDelete.clear();
        this.toDelete.addAll(this.local.index);
        this.toDownload.clear();
        this.toDownload.addAll(this.remote.index);
    }

    private void compare() {
        Collections.sort(this.local.index);
        Collections.sort(this.remote.index);
        this.toDelete.clear();
        this.toDelete.addAll(this.local.index);
        this.toDelete.removeAll(this.remote.index);
        this.toDownload.clear();
        this.toDownload.addAll(this.remote.index);
        this.toDownload.removeAll(this.local.index);
    }

    public Object getToDeleteFiles() {
        return this.toDelete;
    }

    public String toString() {
        return "VersionDiff [local=" + this.local + ", remote=" + this.remote + ", hasDiff()=" + this.hasDiff() + ", toDeleteCount=" + this.toDelete.size() + ", toDownloadCount=" + this.toDownload.size() + "]";
    }
}

