/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.core;

import ca.infodata.launcher.core.config.IConfig;
import ca.infodata.launcher.core.config.Version;
import ca.infodata.launcher.core.config.VersionDiff;
import ca.infodata.launcher.core.config.command.AbstractCommand;
import ca.infodata.launcher.download.CancelException;
import ca.infodata.launcher.download.DownloadProgressDialog;
import ca.infodata.launcher.download.Resource;
import ca.infodata.launcher.exception.NoMoreDownloadProdiderException;
import ca.infodata.launcher.exception.NotToSendException;
import ca.infodata.launcher.exception.PopupInformationException;
import ca.infodata.launcher.exception.PopupInformationWithQuestionException;
import ca.infodata.launcher.exception.QuietException;
import ca.infodata.launcher.util.LauncherLogger;
import ca.infodata.launcher.util.Util;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractLauncher {
    private final DownloadProgressDialog[] monitor = new DownloadProgressDialog[1];
    private JFrame frame;
    private IConfig config;
    private LauncherLogger logger;
    private String[] args;
    private Exception errToDiffer;
    private String applicationName;

    public AbstractLauncher(String[] args) {
        this.args = args;
        this.logger = new LauncherLogger(this.__initGetLauncherVersion());
        LauncherLogger.setInstance(this.logger);
        this.errToDiffer = null;
        try {
            this.config = this.__initNewConfig(args);
            this.applicationName = this.config.getApplicationName();
            this.logger.setConfig(this.config);
        }
        catch (Exception e) {
            try {
                this.errToDiffer = e;
                this.logger.init();
                this.logger.log(Level.SEVERE, e);
            }
            catch (Exception e1) {
                this.errToDiffer = e1;
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main() {
        try {
            if (this.errToDiffer != null) {
                throw this.errToDiffer;
            }
            this.logger.log("List arguments: ");
            for (String s : this.args) {
                this.logger.log("  " + s);
            }
            this.findCommandsAndExecute();
            if (this.haveCommand("-check-version") || this.haveCommand("-versioninfo")) {
                this.checkVersion();
            } else if (this.haveCommand("-skip-validation") || this.haveCommand("-launch-direct")) {
                this.startFrame();
                this.launchApplication();
            } else {
                this.startFrame();
                if (this.haveCommand("-update-launcher") || this.haveCommand("-updatelaunchercopy")) {
                    this.updateLauncher();
                } else {
                    this.cleanUpdateFolder();
                }
                this.checkLauncher();
                if (!this.isInstallValid()) {
                    this.logger.log("Installation is not valid.  Update/install application.");
                    this.installApplication();
                    this.isInstallValid(true);
                    this.launchApplication();
                } else {
                    this.launchApplication();
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof NotToSendException) {
                this.logger.log(Level.INFO, "Something gone wrong... but it's not so important:", ex);
            } else if (ex instanceof PopupInformationWithQuestionException) {
                this.logger.log(Level.SEVERE, ex);
                Object[] choices = new String[]{"Lancer " + this.config.getApplicationName(), "Annuler"};
                int response = JOptionPane.showOptionDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement " + this.config.getApplicationName(), 1, -1, null, choices, "Annuler");
                if (response == 0) {
                    try {
                        this.logger.log(Level.WARNING, "Va quand meme tenter de lancer " + this.config.getApplicationName());
                        this.launchApplication();
                    }
                    catch (Exception exception) {}
                }
            } else if (ex instanceof PopupInformationException) {
                this.logger.log(Level.SEVERE, ex);
                JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement " + this.config.getApplicationName(), 0);
            } else if (ex instanceof QuietException) {
                this.logger.log(Level.SEVERE, ex);
            } else if (ex instanceof CancelException) {
                this.logger.log(Level.WARNING, "CANCEL THE DONWLOAD", ex);
            } else {
                this.logger.log(Level.SEVERE, ex);
                JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement " + this.config.getApplicationName(), 0);
            }
        }
        finally {
            if (this.haveCommand("-no-flush")) {
                this.logger.log("Log are in " + this.logger.logFolder.getAbsolutePath());
            } else {
                this.logger.flush();
            }
            if (this.frame != null) {
                this.frame.dispose();
            }
        }
    }

    protected abstract String __initGetLauncherVersion();

    protected abstract ImageIcon __initGetApplicationLogo();

    protected abstract IConfig __initNewConfig(String[] var1) throws Exception;

    protected void findCommandsAndExecute() throws Exception {
        this.findCommandAndExcute("-wait");
        this.findCommandAndExcute("-create-shortcut");
        this.findCommandAndExcute("-build-proxy");
        this.findCommandAndExcute("-know-install");
        this.findCommandAndExcute("-help");
        this.findCommandAndExcute("-h");
        this.findCommandAndExcute("-change-langage");
        this.findCommandAndExcute("-launch-direc");
        this.findCommandAndExcute("-no-shortcut");
    }

    protected void findCommandAndExcute(String command) throws Exception {
        AbstractCommand c = this.config.getCommand(command);
        if (c != null) {
            this.logger.log("Execute command '" + c + "'");
            c.execute();
        }
    }

    protected boolean haveCommand(String command) {
        return this.config == null ? false : this.config.getCommand(command) != null;
    }

    private void cleanUpdateFolder() throws Exception {
        File f2;
        File f = this.config.getUpdateFolder();
        if (f.exists() && !Util.deleteDirectory(f)) {
            this.logger.log(Level.WARNING, "Unable to remove temporary launcher in " + f.getAbsolutePath());
        }
        if ((f2 = this.config.getOldUpdateFolder()).exists() && !Util.deleteDirectory(f2)) {
            this.logger.log(Level.WARNING, "Unable to remove temporary launcher in " + f2.getAbsolutePath());
        }
    }

    private void updateLauncher() throws Exception {
        String sPath = System.getProperty("java.class.path");
        File oFile = new File(sPath);
        File dFile = this.config.getLauncherJarFile();
        if (dFile.exists() && !dFile.delete() || !oFile.exists()) {
            this.logger.log(Level.WARNING, "Failed to delete at first attemp " + dFile.getAbsolutePath() + " (" + dFile.exists() + ") or does not exist (" + oFile.exists() + ") " + oFile.getAbsolutePath());
            Thread.sleep(3000L);
            if (dFile.exists() && !dFile.delete() || !oFile.exists()) {
                this.logger.log(Level.SEVERE, "Failed to delete " + dFile.getAbsolutePath() + " (" + dFile.exists() + ") or does not exist (" + oFile.exists() + ") " + oFile.getAbsolutePath());
                throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur " + this.config.getApplicationName() + ".");
            }
        }
        oFile.deleteOnExit();
        if (!Util.copyFile(oFile, dFile)) {
            this.logger.log(Level.SEVERE, "Failed to copy " + oFile.getAbsolutePath() + " to " + dFile.getAbsolutePath());
            throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur " + this.config.getApplicationName() + ".");
        }
        if (!dFile.exists()) {
            this.logger.log(Level.SEVERE, "Failed to copy somehow " + oFile.getAbsolutePath() + " to " + dFile.getAbsolutePath());
            throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur " + this.config.getApplicationName() + ".");
        }
        this.logger.log(dFile.getAbsolutePath() + " is now existing!");
    }

    private void checkLauncher() throws Exception {
        boolean isOki = false;
        boolean hasCheckValid = false;
        File launcher = this.config.getLauncherJarFile();
        this.logger.log("--> Check if launcher is valid (" + launcher.getAbsolutePath() + ")");
        if (launcher.exists()) {
            hasCheckValid = true;
            if (this.isLauncherValid()) {
                isOki = true;
            }
        }
        this.logger.log("launcher is oki? " + isOki);
        this.logger.log("launcher is checked? " + hasCheckValid);
        if (!isOki) {
            if (!hasCheckValid) {
                this.isLauncherValid();
            }
            if (launcher.exists() && !launcher.delete()) {
                this.downloadAndRelaunchLauncher();
            }
            this.installLauncher();
        }
    }

    protected abstract void launchApplication() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installApplication() throws Exception {
        final boolean isInstall = this.config.isApplicationInstallThere(this.config.getInstallFolder());
        this.checkAndFlagDownloading();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DownloadProgressDialog d = new DownloadProgressDialog();
                if (!isInstall) {
                    d.setDialogTitleInstall();
                }
                ((AbstractLauncher)AbstractLauncher.this).monitor[0] = d;
                d.getDialog().setLocationRelativeTo(null);
                d.getDialog().setAlwaysOnTop(true);
                d.getDialog().setVisible(true);
            }
        });
        Exception ex = null;
        try {
            List<Version> versions = this.config.getRemoteApplicationVersions();
            Version version = null;
            if (this.config.isUpdateCommand()) {
                version = versions.get(versions.size() - 1);
            } else {
                String installedVersionName = this.config.readInstalledApplicationDotVersion();
                if (installedVersionName != null) {
                    for (Version version2 : versions) {
                        if (!installedVersionName.equals(version2.name)) continue;
                        version = version2;
                        break;
                    }
                }
                if (version == null) {
                    version = versions.get(versions.size() - 1);
                }
            }
            this.config.installApplication(this.monitor[0], version);
        }
        catch (Exception e) {
            try {
                ex = e;
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AbstractLauncher.this.monitor[0].getDialog().dispose();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        if (ex != null) {
            throw ex;
        }
    }

    private void checkAndFlagDownloading() throws Exception {
        File flagFile = new File(this.config.getRootFolder(), "install.flag");
        if (flagFile.exists()) {
            String contain = Util.readFile(flagFile);
            long flagTime = Long.parseLong(contain);
            long diff = System.currentTimeMillis() - flagTime;
            if (diff < 120000L) {
                this.logger.log(Level.SEVERE, "Try to launch twice the install!");
                throw new PopupInformationException("Une autre instance du lanceur est d\u00e9j\u00e0 en train d'installer ou de mettre \u00e0 jour " + this.config.getApplicationName() + ".");
            }
            Util.saveToFile(flagFile, "" + System.currentTimeMillis(), Charset.forName("US-ASCII"));
            flagFile.deleteOnExit();
        } else {
            Util.saveToFile(flagFile, "" + System.currentTimeMillis(), Charset.forName("US-ASCII"));
            flagFile.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installLauncher() throws Exception {
        boolean isInstall = this.config.isLauncherInstallThere(this.config.getInstallFolder());
        this.logger.log("-->Install launcher");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DownloadProgressDialog d = new DownloadProgressDialog();
                d.setDialogTitleInstall();
                ((AbstractLauncher)AbstractLauncher.this).monitor[0] = d;
                d.getDialog().setLocationRelativeTo(null);
                d.getDialog().setAlwaysOnTop(true);
                d.getDialog().setVisible(true);
            }
        });
        Exception ex = null;
        try {
            List<Version> versions = this.config.getRemoteLauncherVersions();
            Version version = null;
            if (this.config.isUpdateCommand()) {
                version = versions.get(versions.size() - 1);
            } else {
                String installedVersionName = this.config.readInstalledLauncherDotVersion();
                if (installedVersionName != null) {
                    for (Version version2 : versions) {
                        if (!installedVersionName.equals(version2.name)) continue;
                        version = version2;
                        break;
                    }
                }
                if (version == null) {
                    version = versions.get(versions.size() - 1);
                }
            }
            this.config.installLauncher(this.monitor[0], version);
        }
        catch (Exception e) {
            try {
                ex = e;
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AbstractLauncher.this.monitor[0].getDialog().dispose();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAndRelaunchLauncher() throws Exception {
        this.logger.log("-- Will relauncher from somewhere else to be able to install launcher.");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DownloadProgressDialog d;
                ((AbstractLauncher)AbstractLauncher.this).monitor[0] = d = new DownloadProgressDialog();
                d.getDialog().setLocationRelativeTo(null);
                d.getDialog().setAlwaysOnTop(true);
                d.getDialog().setVisible(true);
            }
        });
        Exception ex = null;
        try {
            try {
                Version local = this.config.getLauncherInstalledVersion();
                Version localTemp = this.config.getLauncherTempInstalledVersion();
                Version remote = this.config.getLauncherRemoteVersion();
                if (new VersionDiff(local, remote, null).noDiff()) {
                    throw new QuietException("We are in process to download launcher for update and there is no file in launcherDiff.. Something gone wrong!");
                }
                this.logger.log("Will relaunch from " + localTemp.root.getAbsolutePath());
                VersionDiff diff = new VersionDiff(localTemp, remote, null);
                diff.setDeleteAllDownloadAll();
                this.config.sync(diff, this.config.getLauncherSiteProvider(), this.monitor[0]);
                File jar = Util.findFileRecursive(localTemp.root, this.config.getLauncherJarFile().getName());
                if (jar == null) {
                    throw new QuietException("Unable to find " + this.config.getLauncherJarFile().getName() + " file in root " + localTemp.root);
                }
                String cmd = "java -jar " + jar.getName() + " -wait -update-launcher";
                Runtime.getRuntime().exec(cmd, null, jar.getParentFile());
                throw new NotToSendException("Relaunching to update...");
            }
            catch (Exception e) {
                ex = e;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AbstractLauncher.this.monitor[0].getDialog().dispose();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        if (ex != null) {
            throw ex;
        }
    }

    private boolean isInstallValid() throws Exception {
        return this.isInstallValid(false);
    }

    private boolean isInstallValid(boolean throwErrorOnFalse) throws Exception {
        try {
            Version installedVersion = this.config.getApplicationInstalledVersion();
            List<Version> versions = this.config.getRemoteApplicationVersions();
            ArrayList<VersionDiff> diffs = new ArrayList<VersionDiff>();
            boolean valid = false;
            if (this.config.isUpdateCommand()) {
                Version version = versions.get(versions.size() - 1);
                VersionDiff diff = new VersionDiff(installedVersion, version, this.config.getVersionSynchronizerExceptions());
                diffs.add(diff);
                valid = diff.noDiff();
                if (valid) {
                    this.logger.log("installed version found valid with " + version);
                } else {
                    this.logger.log("installed version diff with " + diff);
                }
            } else {
                Iterator<Version> iterator = versions.iterator();
                while (!valid && iterator.hasNext()) {
                    Version version = iterator.next();
                    VersionDiff diff = new VersionDiff(installedVersion, version, this.config.getVersionSynchronizerExceptions());
                    diffs.add(diff);
                    if (diff.noDiff()) {
                        valid = true;
                        this.logger.log("installed version found valid with " + version);
                        continue;
                    }
                    this.logger.log("installed version diff with " + diff);
                }
            }
            if (valid) {
                return true;
            }
            if (throwErrorOnFalse) {
                VersionDiff versionComparator = (VersionDiff)diffs.get(0);
                String files = "L'installation ou la mise-\u00e0-jour de " + this.config.getApplicationName() + " a \u00e9chou\u00e9.\n\n" + "\u00c0 supprimer (" + versionComparator.toDelete.size() + ":\n";
                for (Resource f : versionComparator.toDelete) {
                    files = files + "\t" + (f.getPath() == null ? "" : f.getPath()) + "\n";
                }
                files = files + "\u00c0 mettre \u00e0 t\u00e9l\u00e9charger (" + versionComparator.toDownload.size() + "):\n";
                for (Resource f : versionComparator.toDownload) {
                    files = files + "\t" + (f.getPath() == null ? "" : f.getPath()) + "\n";
                }
                this.logger.log(Level.SEVERE, "Installation is still not valid after update/install " + this.config.getApplicationName() + ".\n" + files);
                throw new PopupInformationException(files);
            }
        }
        catch (NoMoreDownloadProdiderException e) {
            boolean mustContinue;
            boolean bl = mustContinue = JOptionPane.showOptionDialog(null, "Il est impossible de valider votre installation de " + this.config.getApplicationName() + ".  Il se pourrait que vous ne soyez pas \u00e0 jour et que vous ayez rencontriez des erreurs.\nD\u00e9sirez vous quand m\u00eame lancer votre application?", "Probl\u00e8me de connectivit\u00e9", 0, 3, null, new Object[]{"Oui", "Non"}, "Non") == 0;
            if (mustContinue) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return false;
    }

    private boolean isLauncherValid() throws Exception {
        try {
            Version local = this.config.getLauncherInstalledVersion();
            Version remote = this.config.getLauncherRemoteVersion();
            VersionDiff diff = new VersionDiff(local, remote, null);
            this.logger.log("Diff is : " + diff);
            return diff.noDiff();
        }
        catch (NoMoreDownloadProdiderException e) {
            boolean mustContinue = true;
            if (mustContinue) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void startFrame() {
        this.frame = new JFrame("D\u00e9marrage de " + this.applicationName + "...");
        this.frame.setUndecorated(true);
        final ImageIcon icon = this.__initGetApplicationLogo();
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                if (icon != null) {
                    g.drawImage(icon.getImage(), 0, 0, null);
                }
                super.paintComponent(g);
            }
        };
        panel.setOpaque(false);
        Dimension sDm = Toolkit.getDefaultToolkit().getScreenSize();
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        Dimension dDm = new Dimension(width, height);
        int x = sDm.width / 2 - dDm.width / 2;
        int y = sDm.height / 2 - dDm.height / 2;
        this.frame.add(panel);
        this.frame.setBounds(x, y, dDm.width, dDm.height);
        this.frame.setVisible(true);
    }

    private void checkVersion() throws Exception {
        boolean mustUpdateNow;
        try {
            mustUpdateNow = !this.isInstallValid();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in checkVersion.mustUpdateNow check", e);
            mustUpdateNow = true;
        }
        boolean newVersionAvailable = false;
        System.out.println("VERSION_CHECK_START");
        System.out.println("newVersionAvailable=" + newVersionAvailable);
        System.out.println("mustUpdateNow=" + mustUpdateNow);
        System.out.println("VERSION_CHECK_END");
        throw new NotToSendException("Checked-Version");
    }

    public DownloadProgressDialog[] getMonitor() {
        return this.monitor;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public IConfig getConfig() {
        return this.config;
    }

    public LauncherLogger getLogger() {
        return this.logger;
    }

    public String[] getArgs() {
        return this.args;
    }

    public Exception getErrToDiffer() {
        return this.errToDiffer;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

