/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.afm.FontMetric;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.encoding.AFMEncoding;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.encoding.Type1Encoding;
import org.apache.pdfbox.encoding.WinAnsiEncoding;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;

public class PDType1Font
extends PDSimpleFont {
    private static final Log log = LogFactory.getLog(PDType1Font.class);
    private PDType1CFont type1CFont = null;
    public static final PDType1Font TIMES_ROMAN = new PDType1Font("Times-Roman");
    public static final PDType1Font TIMES_BOLD = new PDType1Font("Times-Bold");
    public static final PDType1Font TIMES_ITALIC = new PDType1Font("Times-Italic");
    public static final PDType1Font TIMES_BOLD_ITALIC = new PDType1Font("Times-BoldItalic");
    public static final PDType1Font HELVETICA = new PDType1Font("Helvetica");
    public static final PDType1Font HELVETICA_BOLD = new PDType1Font("Helvetica-Bold");
    public static final PDType1Font HELVETICA_OBLIQUE = new PDType1Font("Helvetica-Oblique");
    public static final PDType1Font HELVETICA_BOLD_OBLIQUE = new PDType1Font("Helvetica-BoldOblique");
    public static final PDType1Font COURIER = new PDType1Font("Courier");
    public static final PDType1Font COURIER_BOLD = new PDType1Font("Courier-Bold");
    public static final PDType1Font COURIER_OBLIQUE = new PDType1Font("Courier-Oblique");
    public static final PDType1Font COURIER_BOLD_OBLIQUE = new PDType1Font("Courier-BoldOblique");
    public static final PDType1Font SYMBOL = new PDType1Font("Symbol");
    public static final PDType1Font ZAPF_DINGBATS = new PDType1Font("ZapfDingbats");
    private static final Map<String, PDType1Font> STANDARD_14 = new HashMap<String, PDType1Font>();
    private Font awtFont = null;

    public PDType1Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE1);
    }

    public PDType1Font(COSDictionary fontDictionary) {
        super(fontDictionary);
        PDStream fontFile3;
        PDFontDescriptor fd = this.getFontDescriptor();
        if (fd != null && fd instanceof PDFontDescriptorDictionary && (fontFile3 = ((PDFontDescriptorDictionary)fd).getFontFile3()) != null) {
            try {
                this.type1CFont = new PDType1CFont(this.font);
            }
            catch (IOException exception) {
                log.info((Object)("Can't read the embedded type1C font " + fd.getFontName()));
            }
        }
    }

    public PDType1Font(String baseFont) {
        this();
        this.setBaseFont(baseFont);
        this.setFontEncoding(new WinAnsiEncoding());
        this.setEncoding(COSName.WIN_ANSI_ENCODING);
    }

    public static PDType1Font getStandardFont(String name) {
        return STANDARD_14.get(name);
    }

    public static String[] getStandard14Names() {
        return STANDARD_14.keySet().toArray(new String[14]);
    }

    public Font getawtFont() throws IOException {
        if (this.awtFont == null) {
            if (this.type1CFont != null) {
                this.awtFont = this.type1CFont.getawtFont();
            } else {
                String baseFont = this.getBaseFont();
                PDFontDescriptor fd = this.getFontDescriptor();
                if (fd != null && fd instanceof PDFontDescriptorDictionary) {
                    PDFontDescriptorDictionary fdDictionary = (PDFontDescriptorDictionary)fd;
                    if (fdDictionary.getFontFile() != null) {
                        try {
                            this.awtFont = Font.createFont(1, fdDictionary.getFontFile().createInputStream());
                        }
                        catch (FontFormatException e) {
                            log.info((Object)("Can't read the embedded type1 font " + fd.getFontName()));
                        }
                    }
                    if (this.awtFont == null) {
                        if (fd.getFontName() != null) {
                            this.awtFont = FontManager.getAwtFont(fd.getFontName());
                        }
                        if (this.awtFont == null) {
                            log.info((Object)("Can't find the specified font " + fd.getFontName()));
                        }
                    }
                } else {
                    this.awtFont = FontManager.getAwtFont(baseFont);
                    if (this.awtFont == null) {
                        log.info((Object)("Can't find the specified basefont " + baseFont));
                    }
                }
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
                log.info((Object)("Using font " + this.awtFont.getName() + " instead"));
            }
        }
        return this.awtFont;
    }

    protected void determineEncoding() {
        super.determineEncoding();
        Encoding fontEncoding = this.getFontEncoding();
        if (fontEncoding == null) {
            FontMetric metric = this.getAFM();
            if (metric != null) {
                fontEncoding = new AFMEncoding(metric);
            }
            this.setFontEncoding(fontEncoding);
        }
        this.getEncodingFromFont(this.getFontEncoding() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getEncodingFromFont(boolean extractEncoding) {
        PDStream fontFile;
        PDFontDescriptor fontDescriptor = this.getFontDescriptor();
        if (fontDescriptor == null || !(fontDescriptor instanceof PDFontDescriptorDictionary) || (fontFile = ((PDFontDescriptorDictionary)fontDescriptor).getFontFile()) == null) return;
        BufferedReader in = null;
        in = new BufferedReader(new InputStreamReader(fontFile.createInputStream(), "ISO-8859-1"));
        String line = "";
        Type1Encoding encoding = null;
        while ((line = in.readLine()) != null) {
            if (extractEncoding) {
                StringTokenizer st;
                if (line.startsWith("currentdict end")) {
                    if (encoding == null) break;
                    this.setFontEncoding(encoding);
                    break;
                }
                if (line.startsWith("/Encoding")) {
                    if (line.contains("array")) {
                        st = new StringTokenizer(line);
                        st.nextElement();
                        int arraySize = Integer.parseInt(st.nextToken());
                        encoding = new Type1Encoding(arraySize);
                    } else if (this.getFontEncoding() == null) {
                        st = new StringTokenizer(line);
                        st.nextElement();
                        String type1Encoding = st.nextToken();
                        this.setFontEncoding(EncodingManager.INSTANCE.getEncoding(COSName.getPDFName(type1Encoding)));
                        break;
                    }
                } else if (line.startsWith("dup")) {
                    st = new StringTokenizer(line.replaceAll("/", " /"));
                    st.nextElement();
                    try {
                        int index = Integer.parseInt(st.nextToken());
                        String name = st.nextToken();
                        if (encoding == null) {
                            log.warn((Object)"Unable to get character encoding. Encoding definition found without /Encoding line.");
                            continue;
                        }
                        encoding.addCharacterEncoding(index, name.replace("/", ""));
                    }
                    catch (NumberFormatException exception) {
                        log.debug((Object)("Malformed encoding definition ignored (line=" + line + ")"));
                    }
                    continue;
                }
            }
            if (!line.startsWith("/FontMatrix")) continue;
            if (line.indexOf("[") > -1) {
                String matrixValues = line.substring(line.indexOf("[") + 1, line.lastIndexOf("]"));
                StringTokenizer st = new StringTokenizer(matrixValues);
                COSArray array = new COSArray();
                if (st.countTokens() < 6) continue;
                try {
                    for (int i = 0; i < 6; ++i) {
                        COSFloat floatValue = new COSFloat(Float.parseFloat(st.nextToken()));
                        array.add(floatValue);
                    }
                }
                catch (NumberFormatException exception) {
                    log.error((Object)"Can't read the fontmatrix from embedded font file!");
                }
                this.fontMatrix = new PDMatrix(array);
                continue;
            }
            COSArray array = new COSArray();
            while ((line = in.readLine()) != null) {
                if (line.startsWith("[")) continue;
                if (line.endsWith("]")) break;
                try {
                    COSFloat floatValue = new COSFloat(Float.parseFloat(line));
                    array.add(floatValue);
                }
                catch (NumberFormatException exception) {
                    log.error((Object)"Can't read the fontmatrix from embedded font file!");
                }
            }
            if (array.size() == 6) {
                this.fontMatrix = new PDMatrix(array);
                continue;
            }
            log.error((Object)"Can't read the fontmatrix from embedded font file, not enough values!");
        }
        Object var13_20 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException exception2) {
            log.error((Object)"An error occurs while closing the stream used to read the embedded type1 font.");
        }
        return;
        {
            catch (IOException exception) {
                log.error((Object)"Error: Could not extract the encoding from the embedded type1 font.");
                Object var13_21 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException exception2) {
                    log.error((Object)"An error occurs while closing the stream used to read the embedded type1 font.");
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_22 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException exception2) {
                log.error((Object)"An error occurs while closing the stream used to read the embedded type1 font.");
            }
            throw throwable;
        }
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        String character;
        if (this.type1CFont != null && this.getFontEncoding() == null && (character = this.type1CFont.encode(c, offset, length)) != null) {
            return character;
        }
        return super.encode(c, offset, length);
    }

    public int encodeToCID(byte[] c, int offset, int length) throws IOException {
        if (this.type1CFont != null && this.getFontEncoding() == null) {
            return this.type1CFont.encodeToCID(c, offset, length);
        }
        return super.encodeToCID(c, offset, length);
    }

    public PDMatrix getFontMatrix() {
        if (this.type1CFont != null) {
            return this.type1CFont.getFontMatrix();
        }
        return super.getFontMatrix();
    }

    public void clear() {
        super.clear();
        if (this.type1CFont != null) {
            this.type1CFont.clear();
            this.type1CFont = null;
        }
    }

    static {
        STANDARD_14.put(TIMES_ROMAN.getBaseFont(), TIMES_ROMAN);
        STANDARD_14.put(TIMES_BOLD.getBaseFont(), TIMES_BOLD);
        STANDARD_14.put(TIMES_ITALIC.getBaseFont(), TIMES_ITALIC);
        STANDARD_14.put(TIMES_BOLD_ITALIC.getBaseFont(), TIMES_BOLD_ITALIC);
        STANDARD_14.put(HELVETICA.getBaseFont(), HELVETICA);
        STANDARD_14.put(HELVETICA_BOLD.getBaseFont(), HELVETICA_BOLD);
        STANDARD_14.put(HELVETICA_OBLIQUE.getBaseFont(), HELVETICA_OBLIQUE);
        STANDARD_14.put(HELVETICA_BOLD_OBLIQUE.getBaseFont(), HELVETICA_BOLD_OBLIQUE);
        STANDARD_14.put(COURIER.getBaseFont(), COURIER);
        STANDARD_14.put(COURIER_BOLD.getBaseFont(), COURIER_BOLD);
        STANDARD_14.put(COURIER_OBLIQUE.getBaseFont(), COURIER_OBLIQUE);
        STANDARD_14.put(COURIER_BOLD_OBLIQUE.getBaseFont(), COURIER_BOLD_OBLIQUE);
        STANDARD_14.put(SYMBOL.getBaseFont(), SYMBOL);
        STANDARD_14.put(ZAPF_DINGBATS.getBaseFont(), ZAPF_DINGBATS);
    }
}

