/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.SignatureException;
import org.apache.pdfbox.pdfparser.PDFXRefStream;
import org.apache.pdfbox.pdfwriter.COSFilterInputStream;
import org.apache.pdfbox.pdfwriter.COSStandardOutputStream;
import org.apache.pdfbox.pdfwriter.COSWriterXRefEntry;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.persistence.util.COSObjectKey;
import org.apache.pdfbox.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSWriter
implements ICOSVisitor,
Closeable {
    public static final byte[] DICT_OPEN = StringUtil.getBytes("<<");
    public static final byte[] DICT_CLOSE = StringUtil.getBytes(">>");
    public static final byte[] SPACE = StringUtil.getBytes(" ");
    public static final byte[] COMMENT = StringUtil.getBytes("%");
    public static final byte[] VERSION = StringUtil.getBytes("PDF-1.4");
    public static final byte[] GARBAGE = new byte[]{-10, -28, -4, -33};
    public static final byte[] EOF = StringUtil.getBytes("%%EOF");
    public static final byte[] REFERENCE = StringUtil.getBytes("R");
    public static final byte[] XREF = StringUtil.getBytes("xref");
    public static final byte[] XREF_FREE = StringUtil.getBytes("f");
    public static final byte[] XREF_USED = StringUtil.getBytes("n");
    public static final byte[] TRAILER = StringUtil.getBytes("trailer");
    public static final byte[] STARTXREF = StringUtil.getBytes("startxref");
    public static final byte[] OBJ = StringUtil.getBytes("obj");
    public static final byte[] ENDOBJ = StringUtil.getBytes("endobj");
    public static final byte[] ARRAY_OPEN = StringUtil.getBytes("[");
    public static final byte[] ARRAY_CLOSE = StringUtil.getBytes("]");
    public static final byte[] STREAM = StringUtil.getBytes("stream");
    public static final byte[] ENDSTREAM = StringUtil.getBytes("endstream");
    private NumberFormat formatXrefOffset = new DecimalFormat("0000000000");
    private NumberFormat formatXrefGeneration = new DecimalFormat("00000");
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private OutputStream output;
    private COSStandardOutputStream standardOutput;
    private long startxref = 0L;
    private long number = 0L;
    private Map<COSBase, COSObjectKey> objectKeys = new Hashtable<COSBase, COSObjectKey>();
    private Map<COSObjectKey, COSBase> keyObject = new Hashtable<COSObjectKey, COSBase>();
    private List<COSWriterXRefEntry> xRefEntries = new ArrayList<COSWriterXRefEntry>();
    private HashSet<COSBase> objectsToWriteSet = new HashSet();
    private LinkedList<COSBase> objectsToWrite = new LinkedList();
    private Set<COSBase> writtenObjects = new HashSet<COSBase>();
    private Set<COSBase> actualsAdded = new HashSet<COSBase>();
    private COSObjectKey currentObjectKey = null;
    private PDDocument document = null;
    private boolean willEncrypt = false;
    private boolean incrementalUpdate = false;
    private boolean reachedSignature = false;
    private int[] signaturePosition = new int[2];
    private int[] byterangePosition = new int[2];
    private InputStream in;

    public COSWriter(OutputStream os) {
        this.setOutput(os);
        this.setStandardOutput(new COSStandardOutputStream(this.output));
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    public COSWriter(OutputStream os, InputStream is) {
        this(os);
        this.in = is;
        this.incrementalUpdate = true;
    }

    private void prepareIncrement(PDDocument doc) {
        try {
            if (doc != null) {
                COSDocument cosDoc = doc.getDocument();
                Map<COSObjectKey, Long> xrefTable = cosDoc.getXrefTable();
                Set<COSObjectKey> keySet = xrefTable.keySet();
                long highestNumber = 0L;
                for (COSObjectKey cosObjectKey : keySet) {
                    long num;
                    COSBase object = cosDoc.getObjectFromPool(cosObjectKey).getObject();
                    if (object != null && cosObjectKey != null && !(object instanceof COSNumber)) {
                        this.objectKeys.put(object, cosObjectKey);
                        this.keyObject.put(cosObjectKey, object);
                    }
                    if ((num = cosObjectKey.getNumber()) <= highestNumber) continue;
                    highestNumber = num;
                }
                this.setNumber(highestNumber);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void addXRefEntry(COSWriterXRefEntry entry) {
        this.getXRefEntries().add(entry);
    }

    @Override
    public void close() throws IOException {
        if (this.getStandardOutput() != null) {
            this.getStandardOutput().close();
        }
        if (this.getOutput() != null) {
            this.getOutput().close();
        }
    }

    protected long getNumber() {
        return this.number;
    }

    public Map<COSBase, COSObjectKey> getObjectKeys() {
        return this.objectKeys;
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected COSStandardOutputStream getStandardOutput() {
        return this.standardOutput;
    }

    protected long getStartxref() {
        return this.startxref;
    }

    protected List<COSWriterXRefEntry> getXRefEntries() {
        return this.xRefEntries;
    }

    protected void setNumber(long newNumber) {
        this.number = newNumber;
    }

    private void setOutput(OutputStream newOutput) {
        this.output = newOutput;
    }

    private void setStandardOutput(COSStandardOutputStream newStandardOutput) {
        this.standardOutput = newStandardOutput;
    }

    protected void setStartxref(long newStartxref) {
        this.startxref = newStartxref;
    }

    protected void doWriteBody(COSDocument doc) throws IOException, COSVisitorException {
        COSBase nextObject;
        COSDictionary trailer = doc.getTrailer();
        COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
        COSDictionary info = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
        COSDictionary encrypt = (COSDictionary)trailer.getDictionaryObject(COSName.ENCRYPT);
        if (root != null) {
            this.addObjectToWrite(root);
        }
        if (info != null) {
            this.addObjectToWrite(info);
        }
        while (this.objectsToWrite.size() > 0) {
            nextObject = this.objectsToWrite.removeFirst();
            this.objectsToWriteSet.remove(nextObject);
            this.doWriteObject(nextObject);
        }
        this.willEncrypt = false;
        if (encrypt != null) {
            this.addObjectToWrite(encrypt);
        }
        while (this.objectsToWrite.size() > 0) {
            nextObject = this.objectsToWrite.removeFirst();
            this.objectsToWriteSet.remove(nextObject);
            this.doWriteObject(nextObject);
        }
    }

    private void addObjectToWrite(COSBase object) {
        COSBase actual = object;
        if (actual instanceof COSObject) {
            actual = ((COSObject)actual).getObject();
        }
        if (!(this.writtenObjects.contains(object) || this.objectsToWriteSet.contains(object) || this.actualsAdded.contains(actual))) {
            COSBase cosBase = null;
            COSObjectKey cosObjectKey = null;
            if (actual != null) {
                cosObjectKey = this.objectKeys.get(actual);
            }
            if (cosObjectKey != null) {
                cosBase = this.keyObject.get(cosObjectKey);
            }
            if (actual != null && this.objectKeys.containsKey(actual) && !object.isNeedToBeUpdate() && cosBase != null && !cosBase.isNeedToBeUpdate()) {
                return;
            }
            this.objectsToWrite.add(object);
            this.objectsToWriteSet.add(object);
            if (actual != null) {
                this.actualsAdded.add(actual);
            }
        }
    }

    public void doWriteObject(COSBase obj) throws COSVisitorException {
        try {
            COSName item;
            COSDictionary dict;
            COSBase itemType;
            this.writtenObjects.add(obj);
            if (obj instanceof COSDictionary && (itemType = (dict = (COSDictionary)obj).getItem(COSName.TYPE)) instanceof COSName && (COSName.SIG.equals(item = (COSName)itemType) || COSName.DOC_TIME_STAMP.equals(item))) {
                this.reachedSignature = true;
            }
            this.currentObjectKey = this.getObjectKey(obj);
            this.addXRefEntry(new COSWriterXRefEntry(this.getStandardOutput().getPos(), obj, this.currentObjectKey));
            this.getStandardOutput().write(String.valueOf(this.currentObjectKey.getNumber()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(String.valueOf(this.currentObjectKey.getGeneration()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(OBJ);
            this.getStandardOutput().writeEOL();
            obj.accept(this);
            this.getStandardOutput().writeEOL();
            this.getStandardOutput().write(ENDOBJ);
            this.getStandardOutput().writeEOL();
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    protected void doWriteHeader(COSDocument doc) throws IOException {
        this.getStandardOutput().write(doc.getHeaderString().getBytes("ISO-8859-1"));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(COMMENT);
        this.getStandardOutput().write(GARBAGE);
        this.getStandardOutput().writeEOL();
    }

    protected void doWriteTrailer(COSDocument doc) throws IOException, COSVisitorException {
        this.getStandardOutput().write(TRAILER);
        this.getStandardOutput().writeEOL();
        COSDictionary trailer = doc.getTrailer();
        Collections.sort(this.getXRefEntries());
        COSWriterXRefEntry lastEntry = this.getXRefEntries().get(this.getXRefEntries().size() - 1);
        trailer.setInt(COSName.SIZE, (int)lastEntry.getKey().getNumber() + 1);
        if (!this.incrementalUpdate) {
            trailer.removeItem(COSName.PREV);
        }
        if (!doc.isXRefStream()) {
            trailer.removeItem(COSName.XREF_STM);
        }
        trailer.removeItem(COSName.DOC_CHECKSUM);
        trailer.accept(this);
    }

    protected void doWriteXRef(COSDocument doc) throws IOException {
        if (doc.isXRefStream()) {
            Collections.sort(this.getXRefEntries());
            COSWriterXRefEntry lastEntry = this.getXRefEntries().get(this.getXRefEntries().size() - 1);
            this.setStartxref(this.getStandardOutput().getPos());
            this.getStandardOutput().write(XREF);
            this.getStandardOutput().writeEOL();
            this.writeXrefRange(0L, lastEntry.getKey().getNumber() + 1L);
            this.writeXrefEntry(COSWriterXRefEntry.getNullEntry());
            long lastObjectNumber = 0L;
            for (COSWriterXRefEntry entry : this.getXRefEntries()) {
                while (lastObjectNumber < entry.getKey().getNumber() - 1L) {
                    this.writeXrefEntry(COSWriterXRefEntry.getNullEntry());
                }
                lastObjectNumber = entry.getKey().getNumber();
                this.writeXrefEntry(entry);
            }
        } else {
            COSDictionary trailer = doc.getTrailer();
            trailer.setLong(COSName.PREV, doc.getStartXref());
            this.addXRefEntry(COSWriterXRefEntry.getNullEntry());
            Collections.sort(this.getXRefEntries());
            this.setStartxref(this.getStandardOutput().getPos());
            this.getStandardOutput().write(XREF);
            this.getStandardOutput().writeEOL();
            Integer[] xRefRanges = this.getXRefRanges(this.getXRefEntries());
            int xRefLength = xRefRanges.length;
            int j = 0;
            for (int x = 0; x < xRefLength && xRefLength % 2 == 0; x += 2) {
                this.writeXrefRange(xRefRanges[x].intValue(), xRefRanges[x + 1].intValue());
                for (int i = 0; i < xRefRanges[x + 1]; ++i) {
                    this.writeXrefEntry(this.xRefEntries.get(j++));
                }
            }
        }
    }

    private void doWriteXRefInc(COSDocument doc, long hybridPrev) throws IOException, COSVisitorException {
        if (doc.isXRefStream() || hybridPrev != -1L) {
            PDFXRefStream pdfxRefStream = new PDFXRefStream();
            List<COSWriterXRefEntry> xRefEntries2 = this.getXRefEntries();
            for (COSWriterXRefEntry cosWriterXRefEntry : xRefEntries2) {
                pdfxRefStream.addEntry(cosWriterXRefEntry);
            }
            COSDictionary trailer = doc.getTrailer();
            trailer.setLong(COSName.PREV, doc.getStartXref());
            pdfxRefStream.addTrailerInfo(trailer);
            pdfxRefStream.setSize(this.getNumber() + 2L);
            this.setStartxref(this.getStandardOutput().getPos());
            COSStream stream2 = pdfxRefStream.getStream();
            this.doWriteObject(stream2);
        }
        if (!doc.isXRefStream() || hybridPrev != -1L) {
            COSDictionary trailer = doc.getTrailer();
            trailer.setLong(COSName.PREV, doc.getStartXref());
            if (hybridPrev != -1L) {
                COSName xrefStm = COSName.XREF_STM;
                trailer.removeItem(xrefStm);
                trailer.setLong(xrefStm, this.getStartxref());
            }
            this.addXRefEntry(COSWriterXRefEntry.getNullEntry());
            Collections.sort(this.getXRefEntries());
            this.setStartxref(this.getStandardOutput().getPos());
            this.getStandardOutput().write(XREF);
            this.getStandardOutput().writeEOL();
            Integer[] xRefRanges = this.getXRefRanges(this.getXRefEntries());
            int xRefLength = xRefRanges.length;
            int j = 0;
            for (int x = 0; x < xRefLength && xRefLength % 2 == 0; x += 2) {
                this.writeXrefRange(xRefRanges[x].intValue(), xRefRanges[x + 1].intValue());
                for (int i = 0; i < xRefRanges[x + 1]; ++i) {
                    this.writeXrefEntry(this.xRefEntries.get(j++));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doWriteSignature(COSDocument doc) throws IOException, SignatureException {
        if (this.signaturePosition[0] <= 0 || this.byterangePosition[1] <= 0) return;
        int left = (int)this.getStandardOutput().getPos() - this.signaturePosition[1];
        String newByteRange = "0 " + this.signaturePosition[0] + " " + this.signaturePosition[1] + " " + left + "]";
        int leftByterange = this.byterangePosition[1] - this.byterangePosition[0] - newByteRange.length();
        if (leftByterange < 0) {
            throw new IOException("Can't write new ByteRange, not enough space");
        }
        this.getStandardOutput().setPos(this.byterangePosition[0]);
        this.getStandardOutput().write(newByteRange.getBytes("ISO-8859-1"));
        for (int i = 0; i < leftByterange; ++i) {
            this.getStandardOutput().write(32);
        }
        this.getStandardOutput().setPos(0L);
        InputStream filterInputStream = null;
        try {
            filterInputStream = new COSFilterInputStream(new BufferedInputStream(this.in), new int[]{0, this.signaturePosition[0], this.signaturePosition[1], left});
            SignatureInterface signatureInterface = doc.getSignatureInterface();
            byte[] sign = signatureInterface.sign(filterInputStream);
            String signature = new COSString(sign).getHexString();
            int startPos = this.signaturePosition[0] + 1;
            int endPos = this.signaturePosition[1] - 1;
            if (startPos + signature.length() > endPos) {
                throw new IOException("Can't write signature, not enough space");
            }
            this.getStandardOutput().setPos(startPos);
            this.getStandardOutput().write(signature.getBytes("ISO-8859-1"));
            Object var12_12 = null;
            if (filterInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (filterInputStream == null) throw throwable;
            filterInputStream.close();
            throw throwable;
        }
        filterInputStream.close();
    }

    private void writeXrefRange(long x, long y) throws IOException {
        this.getStandardOutput().write(String.valueOf(x).getBytes("ISO-8859-1"));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(y).getBytes("ISO-8859-1"));
        this.getStandardOutput().writeEOL();
    }

    private void writeXrefEntry(COSWriterXRefEntry entry) throws IOException {
        String offset = this.formatXrefOffset.format(entry.getOffset());
        String generation = this.formatXrefGeneration.format(entry.getKey().getGeneration());
        this.getStandardOutput().write(offset.getBytes("ISO-8859-1"));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(generation.getBytes("ISO-8859-1"));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(entry.isFree() ? XREF_FREE : XREF_USED);
        this.getStandardOutput().writeCRLF();
    }

    protected Integer[] getXRefRanges(List<COSWriterXRefEntry> xRefEntriesList) {
        int nr = 0;
        int last = -2;
        int count = 1;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (COSWriterXRefEntry object : xRefEntriesList) {
            nr = (int)object.getKey().getNumber();
            if (nr == last + 1) {
                ++count;
                last = nr;
                continue;
            }
            if (last == -2) {
                last = nr;
                continue;
            }
            list.add(last - count + 1);
            list.add(count);
            last = nr;
            count = 1;
        }
        if (xRefEntriesList.size() > 0) {
            list.add(last - count + 1);
            list.add(count);
        }
        return list.toArray(new Integer[list.size()]);
    }

    private COSObjectKey getObjectKey(COSBase obj) {
        COSBase actual = obj;
        if (actual instanceof COSObject) {
            actual = ((COSObject)obj).getObject();
        }
        COSObjectKey key = null;
        if (actual != null) {
            key = this.objectKeys.get(actual);
        }
        if (key == null) {
            key = this.objectKeys.get(obj);
        }
        if (key == null) {
            this.setNumber(this.getNumber() + 1L);
            key = new COSObjectKey(this.getNumber(), 0L);
            this.objectKeys.put(obj, key);
            if (actual != null) {
                this.objectKeys.put(actual, key);
            }
        }
        return key;
    }

    @Override
    public Object visitFromArray(COSArray obj) throws COSVisitorException {
        try {
            int count = 0;
            this.getStandardOutput().write(ARRAY_OPEN);
            Iterator<COSBase> i = obj.iterator();
            while (i.hasNext()) {
                COSBase current = i.next();
                if (current instanceof COSDictionary) {
                    if (current.isDirect()) {
                        this.visitFromDictionary((COSDictionary)current);
                    } else {
                        this.addObjectToWrite(current);
                        this.writeReference(current);
                    }
                } else if (current instanceof COSObject) {
                    COSBase subValue = ((COSObject)current).getObject();
                    if (this.incrementalUpdate || subValue instanceof COSDictionary || subValue == null) {
                        this.addObjectToWrite(current);
                        this.writeReference(current);
                    } else {
                        subValue.accept(this);
                    }
                } else if (current == null) {
                    COSNull.NULL.accept(this);
                } else if (current instanceof COSString) {
                    COSString copy = new COSString();
                    copy.append(((COSString)current).getBytes());
                    copy.accept(this);
                } else {
                    current.accept(this);
                }
                ++count;
                if (!i.hasNext()) continue;
                if (count % 10 == 0) {
                    this.getStandardOutput().writeEOL();
                    continue;
                }
                this.getStandardOutput().write(SPACE);
            }
            this.getStandardOutput().write(ARRAY_CLOSE);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromBoolean(COSBoolean obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromDictionary(COSDictionary obj) throws COSVisitorException {
        try {
            this.getStandardOutput().write(DICT_OPEN);
            this.getStandardOutput().writeEOL();
            for (Map.Entry<COSName, COSBase> entry : obj.entrySet()) {
                COSBase value = entry.getValue();
                if (value == null) continue;
                entry.getKey().accept(this);
                this.getStandardOutput().write(SPACE);
                if (value instanceof COSDictionary) {
                    COSDictionary dict = (COSDictionary)value;
                    if (!this.incrementalUpdate) {
                        COSBase item = dict.getItem(COSName.XOBJECT);
                        if (item != null) {
                            item.setDirect(true);
                        }
                        if ((item = dict.getItem(COSName.RESOURCES)) != null) {
                            item.setDirect(true);
                        }
                    }
                    if (dict.isDirect()) {
                        this.visitFromDictionary(dict);
                    } else {
                        this.addObjectToWrite(dict);
                        this.writeReference(dict);
                    }
                } else if (value instanceof COSObject) {
                    COSBase subValue = ((COSObject)value).getObject();
                    if (this.incrementalUpdate || subValue instanceof COSDictionary || subValue == null) {
                        this.addObjectToWrite(value);
                        this.writeReference(value);
                    } else {
                        subValue.accept(this);
                    }
                } else if (this.reachedSignature && COSName.CONTENTS.equals(entry.getKey())) {
                    this.signaturePosition = new int[2];
                    this.signaturePosition[0] = (int)this.getStandardOutput().getPos();
                    value.accept(this);
                    this.signaturePosition[1] = (int)this.getStandardOutput().getPos();
                } else if (this.reachedSignature && COSName.BYTERANGE.equals(entry.getKey())) {
                    this.byterangePosition = new int[2];
                    this.byterangePosition[0] = (int)this.getStandardOutput().getPos() + 1;
                    value.accept(this);
                    this.byterangePosition[1] = (int)this.getStandardOutput().getPos() - 1;
                    this.reachedSignature = false;
                } else {
                    value.accept(this);
                }
                this.getStandardOutput().writeEOL();
            }
            this.getStandardOutput().write(DICT_CLOSE);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromDocument(COSDocument doc) throws COSVisitorException {
        try {
            if (!this.incrementalUpdate) {
                this.doWriteHeader(doc);
            }
            this.doWriteBody(doc);
            COSDictionary trailer = doc.getTrailer();
            long hybridPrev = -1L;
            if (trailer != null) {
                hybridPrev = trailer.getLong(COSName.XREF_STM);
            }
            if (this.incrementalUpdate) {
                this.doWriteXRefInc(doc, hybridPrev);
            } else {
                this.doWriteXRef(doc);
            }
            if (!this.incrementalUpdate || !doc.isXRefStream() || hybridPrev != -1L) {
                this.doWriteTrailer(doc);
            }
            this.getStandardOutput().write(STARTXREF);
            this.getStandardOutput().writeEOL();
            this.getStandardOutput().write(String.valueOf(this.getStartxref()).getBytes("ISO-8859-1"));
            this.getStandardOutput().writeEOL();
            this.getStandardOutput().write(EOF);
            this.getStandardOutput().writeEOL();
            if (this.incrementalUpdate) {
                this.doWriteSignature(doc);
            }
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        catch (SignatureException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromFloat(COSFloat obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromInt(COSInteger obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromName(COSName obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromNull(COSNull obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public void writeReference(COSBase obj) throws COSVisitorException {
        try {
            COSObjectKey key = this.getObjectKey(obj);
            this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(REFERENCE);
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object visitFromStream(COSStream obj) throws COSVisitorException {
        Object var9_10;
        InputStream input = null;
        try {
            try {
                if (this.willEncrypt) {
                    this.document.getSecurityHandler().encryptStream(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
                }
                COSObject lengthObject = null;
                COSBase lengthEntry = obj.getDictionaryObject(COSName.LENGTH);
                String type = obj.getNameAsString(COSName.TYPE);
                if (lengthEntry != null && lengthEntry.isDirect() || "XRef".equals(type)) {
                    COSInteger cosInteger = COSInteger.get(obj.getFilteredLength());
                    cosInteger.setDirect(true);
                    obj.setItem(COSName.LENGTH, (COSBase)cosInteger);
                } else {
                    lengthObject = new COSObject(null);
                    obj.setItem(COSName.LENGTH, (COSBase)lengthObject);
                }
                input = obj.getFilteredStream();
                this.visitFromDictionary(obj);
                this.getStandardOutput().write(STREAM);
                this.getStandardOutput().writeCRLF();
                byte[] buffer = new byte[1024];
                int amountRead = 0;
                int totalAmountWritten = 0;
                while ((amountRead = input.read(buffer, 0, 1024)) != -1) {
                    this.getStandardOutput().write(buffer, 0, amountRead);
                    totalAmountWritten += amountRead;
                }
                if (lengthObject != null) {
                    lengthObject.setObject(COSInteger.get(totalAmountWritten));
                }
                this.getStandardOutput().writeCRLF();
                this.getStandardOutput().write(ENDSTREAM);
                this.getStandardOutput().writeEOL();
                var9_10 = null;
                Object var11_11 = null;
                if (input == null) return var9_10;
            }
            catch (Exception e) {
                throw new COSVisitorException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (input == null) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new COSVisitorException(e2);
            }
        }
        try {}
        catch (IOException e2) {
            throw new COSVisitorException(e2);
        }
        input.close();
        return var9_10;
    }

    @Override
    public Object visitFromString(COSString obj) throws COSVisitorException {
        try {
            if (this.willEncrypt) {
                this.document.getSecurityHandler().encryptString(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
            }
            obj.writePDF(this.getStandardOutput());
        }
        catch (Exception e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    public void write(COSDocument doc) throws COSVisitorException {
        PDDocument pdDoc = new PDDocument(doc);
        this.write(pdDoc);
    }

    public void write(PDDocument doc) throws COSVisitorException {
        COSDictionary trailer;
        COSDocument cosDoc;
        Long idTime = doc.getDocumentId() == null ? System.currentTimeMillis() : doc.getDocumentId();
        this.document = doc;
        if (this.incrementalUpdate) {
            this.prepareIncrement(doc);
        }
        if (doc.isAllSecurityToBeRemoved()) {
            this.willEncrypt = false;
            cosDoc = doc.getDocument();
            trailer = cosDoc.getTrailer();
            trailer.removeItem(COSName.ENCRYPT);
        } else {
            SecurityHandler securityHandler = this.document.getSecurityHandler();
            if (securityHandler != null) {
                try {
                    if (!securityHandler.hasProtectionPolicy()) {
                        throw new IllegalStateException("PDF contains an encryption dictionary, please remove it with setAllSecurityToBeRemoved() or set a protection policy with protect()");
                    }
                    securityHandler.prepareDocumentForEncryption(this.document);
                    this.willEncrypt = true;
                }
                catch (IOException e) {
                    throw new COSVisitorException(e);
                }
                catch (CryptographyException e) {
                    throw new COSVisitorException(e);
                }
            } else {
                this.willEncrypt = false;
            }
        }
        cosDoc = this.document.getDocument();
        trailer = cosDoc.getTrailer();
        COSArray idArray = (COSArray)trailer.getDictionaryObject(COSName.ID);
        boolean missingID = true;
        if (idArray != null && idArray.size() == 2) {
            missingID = false;
        }
        if (missingID || this.incrementalUpdate) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(Long.toString(idTime).getBytes("ISO-8859-1"));
                COSDictionary info = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
                if (info != null) {
                    Iterator<COSBase> values = info.getValues().iterator();
                    while (values.hasNext()) {
                        md.update(values.next().toString().getBytes("ISO-8859-1"));
                    }
                }
                COSString firstID = missingID ? new COSString(md.digest()) : (COSString)idArray.get(0);
                COSString secondID = missingID ? firstID : new COSString(md.digest());
                idArray = new COSArray();
                idArray.add(firstID);
                idArray.add(secondID);
                trailer.setItem(COSName.ID, (COSBase)idArray);
            }
            catch (NoSuchAlgorithmException e) {
                throw new COSVisitorException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new COSVisitorException(e);
            }
        }
        cosDoc.accept(this);
    }
}

