//******************************	DSQ B2B Function START Angular
(function(){
	var app = angular.module("b2b", ['angular-confirm']);

	app.directive('b2bProfValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.b2bProfValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isDefined(scope.patientData.prof.lastName) && scope.patientData.prof.noProf==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length>4) {
						if (angular.isDefined(scope.patientData.prof.id)) {
							delete scope.patientData.prof.id;
							delete scope.patientData.prof.lastName;
							delete scope.patientData.prof.firstName;
						}
						$http({
							method : "GET",
							url : "/syra/professionals/get?c=" + viewValue +"&u=" + clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.noProf)) {
									scope.patientData.prof = res;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						if (angular.isDefined(scope.patientData.prof.id)) {
							delete scope.patientData.prof.id;
							delete scope.patientData.prof.lastName;
							delete scope.patientData.prof.firstName;
						}
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});

	app.directive('b2bLocalValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.b2bLocalValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(scope.patientData.b2bPatientData.lieuSuiv) || angular.isUndefined(scope.patientData.b2bPatientData.lieuSuiv.local) || angular.isUndefined(scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal)) {
						deferred.resolve();
					} else if (angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal) && angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.nomLocal) && scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.codLocal==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length==5) {
						if (angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.nomLocal)) {
							delete scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.nomLocal;
						}
						$http({
							method : "GET",
							url : "/syra/local/get?c="+viewValue+"&u="+clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.nomLocal) && res.nomLocal!='') {
									if (angular.isUndefined(scope.patientData.b2bPatientData.lieuSuiv.local)) {
										scope.patientData.b2bPatientData.lieuSuiv.local={};
									}
									scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal = res;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
						});
					} else {
						if (angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.nomLocal)) {
							delete scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.nomLocal;
						}
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	
	app.directive('b2bEtabValid', function($q, $http, clientUid) {
		  return {
			  restrict: 'A',
		    require: 'ngModel',
		    link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.b2bEtabValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.etab) && scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]{5}$/) != null) {
						if (angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.etab.valEtab) && angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.etab.valEtab.nomEtab)) {
							delete scope.patientData.b2bPatientData.lieuSuiv.etab.valEtab.nomEtab;
						}
						$http({
							method : "GET",
							url : "/syra/etabl/get?c=" + viewValue +"&u=" + clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.valEtab.nomEtab) && res.valEtab.nomEtab!='') {
									scope.setDirtyLieu();
									delete res.valSect;	// on ne le veut pas.
									scope.patientData.b2bPatientData.lieuSuiv.etab = res;
									var elem = {};
									elem.c = viewValue;
									elem.d = res.valEtab.nomEtab+ " (" + res.valEtab.typEtab + '-' + res.valEtab.catgEtab +")";
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						if (angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.etab.valEtab) && angular.isDefined(scope.patientData.b2bPatientData.lieuSuiv.etab.valEtab.nomEtab)) {
							delete scope.patientData.b2bPatientData.lieuSuiv.etab.valEtab.nomEtab;
						}
						deferred.reject();
					}
				    return deferred.promise;
		      };
		    }
		  };
		});
			
	app.controller('AnswerQuestions', ['$scope', function($scope){
		var that = this;
		$scope.questions = $scope.mObject.modalData.questions;
		$scope.warnings = $scope.mObject.modalData.warnings;
		$scope.infos = $scope.mObject.modalData.infos;
		$scope.oks = $scope.mObject.modalData.oks;
		$scope.errs = $scope.mObject.modalData.errs;
	}]);
	
	app.controller('B2BController', ['$scope','$timeout', '$http', '$log', 'hotkeys', 'clientUid','model','$uibModal', '$confirm', 'Codifies',
	                                 function ($scope,$timeout, $http, $log, hotkeys, clientUid, model,$uibModal, $confirm, Codifies) {
		var helpers = MyNamespace.helpers;
		var that = this;
		that.model = model;
		$scope.model = model;
		$scope.generLoading = 0;
		$scope.codifies = Codifies.list();
		$scope.procStatus = 'Idle';
//		$scope.codifies = [{'id': 'C', 'label': 'Physique'}];	// quand on désactivera le mode géographique
				
		// TODO à changer quand module sera prêt
		var onlyModLocal = false;	// true... = false lorsque module prêt
		$scope.onlyModLocal = function(v) {
			if (arguments.length==1) {
				onlyModLocal = v;	// true...  = v lorsque module prêt
			}
			return onlyModLocal;
		};
		var mustCheckDirty;	// mis true quand change data
		var mustCheckDirtyProf;	// mis true quand change data
		var mustCheckDirtyRep;	// mis true quand change data
		var mustCheckDirtyRes;
		var mustCheckDirtyLieu;
		var mustCheckDirtyVuln;
		var mustCheckDirtyInscr;
		var mustCheckDirtyInscrDateDeb;
		var mustCheckDirtyInscrDateFin;
		var dirty = false;
		$scope.dirtyProf = false;
		$scope.dirtyRep = false;
		$scope.dirtyRes = false;
		$scope.dirtyLieu = false;
		$scope.dirtyVuln = false;
		$scope.dirtyInscr = false;
		$scope.dirtyInscrDateDeb = false;
		$scope.dirtyInscrDateFin = false;
		var situSant;
		setValuesFromCurrentPatientData();
		
	    $scope.typIdLieuxGeo = [
	                             // {'id': '2', 'label': "Code postal"},
             {'id': '3', 'label': "Code localité"}// seul choix possible
	                             ];

		this.stopInscriptionReason = '0';
		$scope.stopInscriptionReasons = [
	         {c:0,d:"-"}, 
	         {c:1,d:"Déménagement de la personne assurée"}, 
	         {c:2,d:"À la demande du professionnel"}, 
	         {c:3,d:"Départ volontaire de la personne assurée"},
	         {c:4,d:"Formulaire transmis par erreur"},
	         {c:5,d:"Dissolution du GMF"},
	         {c:6,d:"Fin d'adhésion du médecin au GMF"},
	         {c:7,d:"Changement de médecin de famille"},
	         {c:8,d:"Changement de médecin dans le même GMF"},
	         {c:9,d:"Personne assurée décédée"},
	         {c:10,d:"Décès du médecin de famille"},
	         {c:11,d:"N'est plus inscrit car âgé de plus de 63 mois"},
	         {c:12,d:"Rétablissement d'une inscription"},
	         {c:13,d:"Modification de la date de naissance"},
	         {c:14,d:"Fusion de fiches de personnes assurées"},
	         {c:15,d:"Changement significatif du lieu de pratique (cessation de prise en charge)"},
	         {c:16,d:"Modification volontaire de pratique (cessation de prise en charge)"},
	         {c:17,d:"À la demande du coordonnateur du CSSS"},
	         {c:18,d:"À la demande du comité paritaire (avec récupération forfait)"},
	         {c:19,d:"À la demande du comité paritaire (sans récupération forfait)"},
	         {c:20,d:"Non-participation au régime d'assurance maladie"},
	         {c:21,d:"Désengagement du régime d'assurance maladie"},
	         {c:22,d:"À la demande de la personne assurée"},
	         {c:23,d:"Raison prévue à l'entente particulière de prise en charge et de suivi de la clientèle"},
	         {c:99,d:"Autre"}
	         ];
		$scope.statusInscrits = [
             {c:0,d:"Non inscrit"}, 
             {c:2,d:"Inscrit"},
             {c:1,d:"Ne jamais inscrire"}
                                 ];
		$scope.categories = [
			{c:0,d:"MD Fam."},
			{c:1,d:"Sans vis."}
			];
		
		$scope.repTypes = [
           {c:0,d:"S/O"}, 
           {c:1,d:"Titulaire de l'autorit\u00E9 parentale"}, 
           {c:2,d:"Tuteur"}, 
           {c:3,d:"Mandataire"}, 
           {c:4,d:"Curateur"} 
		                   ];
		this.vCodes = [
           {c:"00",d:"Nil"}, 
           {c:"01",d:"PROBLÈMES DE SANTÉ MENTALE CHRONIQUES ET RÉCIDIVANTS (DSM-V): TROUBLES D'ANXIÉTÉ GÉNÉRALISÉE, TROUBLES DU COMPORTEMENT ALIMENTAIRE (ANOREXIE, BOULIMIE)"},
           {c:"02",d:"MPOC - ASTHME - PNEUMOPATHIES PROFESSIONNELLES"},
           {c:"03",d:"MALADIE CARDIAQUE ARTÉRIO-SCLÉROTIQUE, INS CARD, HTA (gr 3)"},
           {c:"04",d:"CANCER EN TX ACTIF OU PROJETÉ OU EN PHASE PALLIATIVE"},
           {c:"05",d:"DIABÈTE AVEC HÉMOGLOBINE A1C À 6,5 OU PLUS AU MOMENT DU DIAGNOSTIC EXCLUANT LE DIABÈTE DE GROSSESSE"},
           {c:"06",d:"TOXICOMANIE OU ALCOOLISME EN COURS DE SEVRAGE OU AYANT DONNÉ LIEU À UNE CURE DE DÉSINTOXICATION DE DROGUES DURES OU D'ALCOOL AU COURS DES CINQ DERNIÈRES ANNÉES, TOXICOMANIE SOUS TRAITEMENT DE MÉTHADONE OU DE BUPRÉNORPHINE"},
           {c:"07",d:"VIH/SIDA, Hépatite C"},
           {c:"08",d:"MMALADIES DÉGÉNÉRATIVES DU SYSTÈME NERVEUX, DÉMENCE AVEC MMSE DE 26 ET MOINS, BLESSÉS MÉDULLAIRES AVEC SÉQUELLES PERMANENTES ENTRAÎNANT UNE INVALIDITÉ ET DES TRAUMATISMES CRÂNIENS AVEC SÉQUELLES PERMANENTES ENTRAÎNANT UNE INVALIDITÉ"},
           {c:"09",d:"MALADIES INFLAMMATOIRES CHRONIQUES: PAR,PSORIASIS SYST, LUPUS, SCLÉRODERMIE, COL ULC, CROHN"},
           {c:"10",d:"TROUBLES DÉPRESSIFS MAJEURS AIGUS, PREMIER ÉPISODE OU TROUBLES ANXIEUX AIGUS, PREMIER ÉPISODE"},
           {c:"11",d:"TROUBLES DEPRESSIFS MAJEURS RECIDIVANTS"},
           {c:"12",d:"INSUFFISANCE RÉNALE CHRONIQUE AVEC UNE CLAIRANCE DE LA CRÉATINE, INFÉRIEURE À 30 ML PAR MINUTE, INSUFFISANCE HÉPATIQUE"},
           {c:"13",d:"MALADIES THROMBOGÈNES NÉCESSITANT UNE ANTICOAGULATION À VIE, FIBRILLATION AURICULAIRE AVEC CHADS À 2 ET PLUS"},
           {c:"14",d:"FIBRILLATION AURICULAIRE SOUS ACO A VIE AVEC INR"},
           {c:"15",d:"TROUBLES DE DÉFICIT DE L'ATTENTION AVEC OU SANS HYPERACTIVITÉ POUR LES PATIENTS < 18 ANS"},
           {c:"16",d:"DEFICIENCE INTELLECTUELLE PATIENTS AVEC TR IMPORTANTS D'EXPRESSION ET DE COMPREHENSION"},
           {c:"17",d:"DEFICIENCE AUDITIVE: COMMUNICATION GESTUELLE OU PAR ECRIT. DEFICIENCE VISUELLE: BESOIN D'UN ACCOMPAGNATEUR"},
           {c:"18",d:"DOULEUR CHRONIQUE > 6 MOIS A/A CONDITION CHRON ET INCAPACITE FONCT OU BESOIN RX EN CONTINUE POUR ETRE FONCTIONNEL"},
           {c:"19",d:"AVC ENTRAINANT DES TROUBLES GRAVES DE MOBILITE, DE COMPORTEMENT, D'EXPRESSION OU DE COMPREHENSION"},
           {c:"20",d:"PROBLÈMES DE SANTÉ (DSM-IV) : TROUBLES PSYCHOTIQUES, TROUBLES BIPOLAIRES, TROUBLES ENVAHISSANTS DU DÉVELOPPEMENT (TROUBLES DU SPECTRE DE L'AUTISME, ASPERGER)"}
		               ];
		
		var prevhotkey = [hotkeys.get('alt+e'), hotkeys.get('alt+c')];
		
		hotkeys.add({
			combo: 'alt+e',
			description: "Enregistrer",
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				$scope.save();
			}
		});
		hotkeys.add({
			combo: 'alt+c',
			description: "Fermer",
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				$scope.close();
			}
		});
				
		function clearHotKeys(){
			hotkeys.del('alt+c');
			hotkeys.del('alt+e');
			for (var i = 0; i<prevhotkey.length; i++) {
				if (prevhotkey[i]) {
					hotkeys.add(prevhotkey[i]);					
				}
			}
		}
		
		$scope.lieu = {
			typLocEtab: function(newVal) {
				if (arguments.length) {
					$scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.codLocal = '';
					$scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab='';
					$scope.patientData.b2bPatientData.lieuSuiv.typLocEtab = newVal;
					return;
				}
				return $scope.patientData.b2bPatientData.lieuSuiv.typLocEtab;
			},
			typIdLieuGeo: function(newVal) {
				if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.local)) {
					$scope.patientData.b2bPatientData.lieuSuiv.local = {};
				}
				if (arguments.length) {
					$scope.patientData.b2bPatientData.lieuSuiv.local.typIdLieuGeo = newVal;
					return;
				}
				if(helpers.isEmpty($scope.patientData.b2bPatientData.lieuSuiv.local.typIdLieuGeo)) {
					$scope.patientData.b2bPatientData.lieuSuiv.local.typIdLieuGeo = '3';
				}
				return $scope.patientData.b2bPatientData.lieuSuiv.local.typIdLieuGeo;
			},
			local: function(newVal) {
				if (arguments.length) {
					$scope.patientData.b2bPatientData.lieuSuiv.local = newVal;
					return;
				}
				if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.local)) {
					$scope.patientData.b2bPatientData.lieuSuiv.local = {};
				}
				return $scope.patientData.b2bPatientData.lieuSuiv.local;				
			},
			codLocal: function(newVal) {
				// si >=60000 -> est un code géographique
				if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.local)) {
					$scope.patientData.b2bPatientData.lieuSuiv.local = {};
				}
				if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal)) {
					$scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal = {};
				}
				if (arguments.length) {
					$scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.codLocal = newVal;
					return;
				}
				if (helpers.isNotEmpty($scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.codLocal)) {
					if ($scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.codLocal>=60000) {
						$scope.patientData.b2bPatientData.lieuSuiv.typLocEtab = 'N';
					} else {
						$scope.patientData.b2bPatientData.lieuSuiv.typLocEtab = 'C';
					}
				}
				return $scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.codLocal;
			},
			etab: function(newVal) {
				if (arguments.length) {
					$scope.patientData.b2bPatientData.lieuSuiv.etab = newVal;
					return;
				}
				if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.etab)) {
					$scope.patientData.b2bPatientData.lieuSuiv.etab = {};
				}
				return $scope.patientData.b2bPatientData.lieuSuiv.etab;
			},
			noSelectedEtab: function(newVal) {
				if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.etab)) {
					$scope.patientData.b2bPatientData.lieuSuiv.etab = {};
				}
				if (arguments.length) {
					$scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab = newVal;
					return;
				}
				if (helpers.isNotEmpty($scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab)) {
					if ($scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab>='60000' && $scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab<'70000') {
						if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.local)) {
							$scope.patientData.b2bPatientData.lieuSuiv.local = {};
						}
						if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal)) {
							$scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal = {};
						}
						$scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.codLocal = $scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab;
						$scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab='';
						$scope.patientData.b2bPatientData.lieuSuiv.typLocEtab = 'N';
					} else {
						$scope.patientData.b2bPatientData.lieuSuiv.typLocEtab = 'C';
					}
				}
				return $scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab;
			}
		};
		
		function setValuesFromCurrentPatientData() {
			mustCheckDirty = true;	// mis true quand change data
			mustCheckDirtyProf = true;	// mis true quand change data
			mustCheckDirtyRep = true;	// mis true quand change data
			mustCheckDirtyRes = true;
			mustCheckDirtyLieu = true;
			mustCheckDirtyVuln = true;
			mustCheckDirtyInscr = true;
			mustCheckDirtyInscrDateDeb = true;
			mustCheckDirtyInscrDateFin = true;
			if (angular.isUndefined(that.model.currentPatientData().representant)) {
				that.model.currentPatientData().representant = {};
			}
			if (angular.isUndefined(that.model.currentPatientData().resident)) {
				that.model.currentPatientData().resident = {};
			}
			if (angular.isUndefined(that.model.currentPatientData().b2bPatientData.lieuSuiv.local)) {
				that.model.currentPatientData().b2bPatientData.lieuSuiv.local = {};
			}
			if (angular.isUndefined(that.model.currentPatientData().b2bPatientData.lieuSuiv.local.typIdLieuGeo)) {
				that.model.currentPatientData().b2bPatientData.lieuSuiv.local.typIdLieuGeo = '3';
			}
			if (angular.isUndefined(that.model.currentPatientData().b2bPatientData.lieuSuiv.local.valCodLocal)) {
				that.model.currentPatientData().b2bPatientData.lieuSuiv.local.valCodLocal = {};
			}
			if (angular.isUndefined(that.model.currentPatientData().b2bPatientData.lieuSuiv.local.valCodLocal.codLocal)) {
				that.model.currentPatientData().b2bPatientData.lieuSuiv.local.valCodLocal.codLocal = "";
			}
			if (angular.isUndefined(that.model.currentPatientData().b2bPatientData.lieuSuiv.etab)) {
				that.model.currentPatientData().b2bPatientData.lieuSuiv.etab = {};
			}
			$scope.patientData = _.cloneDeep(that.model.currentPatientData());
			situSant = $scope.patientData.b2bPatientData.situSant;
			if (situSant.length>0) {
				that.patVCodes=[{id: 0, t:"Code 1", patVCode: situSant[0].c, patVDate:situSant[0].dd},{id: 1, t:"Code 2", patVCode: situSant[1].c, patVDate:situSant[1].dd},{id: 2, t:"Code 3", patVCode: situSant[2].c, patVDate:situSant[2].dd}];
			}
		}
		
		$scope.reload = function() {
			$scope.patientData = that.model.currentPatientData();
			setValuesFromCurrentPatientData();
		};
		
		$scope.save = function() {
			if ($scope.isDirty()) {
				var _patientData = _.cloneDeep($scope.patientData);
				cleanPatientDataFromLieuSuivi(_patientData);
				that.model.httpPost("/syra/save_patient_data/post", JSON.stringify(_patientData), null, function(response) {
//					$log.log(response);
					if (response.data) {
						if (response.data.severity=='OK') {
							closeAnyways = true;
							// il faut mettre à jour le currentPatient (4 var, soit inscrit, noProf et all
							that.model.currentPatient().isInsc = _patientData.b2bPatientData.status;
							that.model.currentPatient().patientRepresentantType = _patientData.representantType;
							if (angular.isDefined(_patientData.prof)) {
								that.model.currentPatient().txProfN = _patientData.prof.noProf;
							} else {
								delete that.model.currentPatient().txProfN;
							}
							var ss = _patientData.b2bPatientData.situSant;
							that.model.currentPatient().allDisCodes = ss[0].c+'-'+ss[1].c+'-'+ss[2].c;
							$scope.modal.cancel();				
						} else  if (response.data.message!='') {
							that.model.message(response.data.message, 'red');
						}
					} else  {
						$log.log("pas de response.data!!!");
					}
				});
			}
		};
		$scope.close = function() {
			$scope.modal.cancel();
		};
		
		//Flag for closing mechanism.
		var closeAnyways = false;
		
		$scope.modal.closing = function(event){
			// Your code when the modal is closed.
			if ($scope.isDirty(true) && !closeAnyways) {
				event.preventDefault();
				var type = "transmise à la RAMQ";
					if (onlyModLocal) {
						type = "enregistrée";
					}
				$confirm({
					text: "Cette fiche d'inscription a été modifiée mais non " + type +
					". Veuillez confirmer l'abandon de ces modifications.",
					title:"Demande de confirmation",
					ok: "Je confirme l'abandon",
					cancel : "Oups! Je veux corriger mon oubli."
				})
				.then(function(res) {
					closeAnyways = true;
					$scope.modal.cancel();
				});
			}else{
				clearHotKeys();
			}
		};
		
		$scope.setDirtyInscr = function() {
			mustCheckDirty = true;
			mustCheckDirtyInscr = true;
		};
		$scope.setDirtyInscrDateDeb = function() {
			mustCheckDirty = true;
			mustCheckDirtyInscrDateDeb = true;
		};
		$scope.setDirtyInscrDateFin = function() {
			mustCheckDirty = true;
			mustCheckDirtyInscrDateFin = true;
		};
		$scope.setDirtyProf = function() {
			mustCheckDirty = true;
			mustCheckDirtyProf = true;
		};
		$scope.setDirtyRep = function() {
			mustCheckDirty = true;
			mustCheckDirtyRep = true;
		};
		$scope.setDirtyRes = function() {
			mustCheckDirty = true;
			mustCheckDirtyRes = true;
		};
		$scope.setDirtyLieu = function() {
			mustCheckDirty = true;
			mustCheckDirtyLieu = true;
		};
		$scope.setDirtyVC = function(id) {
			mustCheckDirty = true;
			mustCheckDirtyVuln = true;
			$scope.patientData.b2bPatientData.situSant[id].c = that.patVCodes[id].patVCode;
			if (angular.isUndefined(that.patVCodes[id].patVDate) || that.patVCodes[id].patVDate=='') {
				delete $scope.patientData.b2bPatientData.situSant[id].dd;
			} else {
				$scope.patientData.b2bPatientData.situSant[id].dd = that.patVCodes[id].patVDate;
			}
		};
		$scope.setDirty = function() {
			mustCheckDirty = true;
		};
		$scope.isDirtyInscr = function() {
			if (mustCheckDirtyInscr) {
				$scope.dirtyInscr = $scope.patientData.b2bPatientData.status!=that.model.currentPatientData().b2bPatientData.status;
				$scope.dirtyInscr = $scope.dirtyInscr || $scope.patientData.b2bPatientData.category!=that.model.currentPatientData().b2bPatientData.category;
				mustCheckDirtyInscr = false;
			}
			return $scope.dirtyInscr;				
		};
		$scope.isDirtyInscrDateDeb = function() {
			if (mustCheckDirtyInscrDateDeb) {
				$scope.dirtyInscrDateDeb = !helpers.compare($scope.patientData.b2bPatientData.ddi, that.model.currentPatientData().b2bPatientData.ddi);
				mustCheckDirtyInscrDateDeb = false;
			}
			return $scope.dirtyInscrDateDeb;				
		};
		$scope.isDirtyInscrDateFin = function() {
			if (mustCheckDirtyInscrDateFin) {
				$scope.dirtyInscrDateFin = !helpers.compare($scope.patientData.b2bPatientData.dfi, that.model.currentPatientData().b2bPatientData.dfi);
				mustCheckDirtyInscrDateFin = false;
			}
			return $scope.dirtyInscrDateFin;
		};
		$scope.isDirtyProf = function() {
			if (mustCheckDirtyProf) {
				if ($scope.patientData.prof.noProf==='') {
					delete $scope.patientData.prof.noProf;
				}
				$scope.dirtyProf = !helpers.compare($scope.patientData.prof, that.model.currentPatientData().prof);
				mustCheckDirtyProf = false;
			}
			return $scope.dirtyProf;				
		};
		$scope.isDirtyRep = function() {
			if (mustCheckDirtyRep) {
				var repType = $scope.patientData.representantType===0 ? undefined : $scope.patientData.representantType;
				var repTypeCurr = that.model.currentPatientData().representantType===0 ? undefined : that.model.currentPatientData().representantType;
				$scope.dirtyRep = repType !== repTypeCurr;
				if (!$scope.dirtyRep) {
					var repHin = $scope.patientData.representant.hin==='' ? undefined : $scope.patientData.representant.hin;
					var repHinCurr = that.model.currentPatientData().representant.hin==='' ? undefined : that.model.currentPatientData().representant.hin;
					var repLn = $scope.patientData.representant.ln==='' ? undefined : $scope.patientData.representant.ln;
					var repLnCurr = that.model.currentPatientData().representant.ln==='' ? undefined : that.model.currentPatientData().representant.ln;
					var repFn = $scope.patientData.representant.fn==='' ? undefined : $scope.patientData.representant.fn;
					var repFnCurr = that.model.currentPatientData().representant.fn==='' ? undefined : that.model.currentPatientData().representant.fn;
					$scope.dirtyRep = repHin!==repHinCurr || repLn!==repLnCurr || repFn!==repFnCurr;
				}
				mustCheckDirtyRep = false;
			}
			return $scope.dirtyRep;				
		};
		$scope.isDirtyRes = function() {
			if (mustCheckDirtyRes) {
				if ($scope.patientData.resident.noProf==='') {
					delete $scope.patientData.resident.noProf;
				}
				$scope.dirtyRes = !helpers.compare($scope.patientData.resident, that.model.currentPatientData().resident);
				mustCheckDirtyRes = false;
			}
			return $scope.dirtyRes;				
		};
		$scope.isDirtyLieu = function() {
			if (mustCheckDirtyLieu) {
				$scope.dirtyLieu = !helpers.compare($scope.patientData.b2bPatientData.fld, that.model.currentPatientData().b2bPatientData.fld);
				if (!$scope.dirtyLieu) {
					if ($scope.patientData.b2bPatientData.lieuSuiv.etab) {
						if (!that.model.currentPatientData().b2bPatientData.lieuSuiv.etab) {
							$scope.dirtyLieu = true;
						} else {
							$scope.dirtyLieu = $scope.patientData.b2bPatientData.lieuSuiv.etab.noSelectedEtab!=that.model.currentPatientData().b2bPatientData.lieuSuiv.etab.noSelectedEtab;						
						}
					} else if ($scope.patientData.b2bPatientData.lieuSuiv.local && $scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal) {
						if (that.model.currentPatientData().b2bPatientData.lieuSuiv.local && that.model.currentPatientData().b2bPatientData.lieuSuiv.local.valCodLocal) {
							$scope.dirtyLieu = true;
						} else {
							$scope.dirtyLieu = $scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.codLocal!=that.model.currentPatientData().b2bPatientData.lieuSuiv.local.valCodLocal.codLocal;												
						}
					}
				}
				mustCheckDirtyLieu = false;
			}
			return $scope.dirtyLieu;		
		};
		$scope.isDirtyVuln = function() {
			if (mustCheckDirtyVuln) {
				$scope.dirtyVuln = !helpers.compare($scope.patientData.b2bPatientData.situSant, that.model.currentPatientData().b2bPatientData.situSant);
				mustCheckDirtyVuln = false;
			}
			return $scope.dirtyVuln;				
		};
		// passer true si on veut s'assurer que pas eu de modif
		$scope.isModified = function() {
			if (mustCheckDirty) {
				dirty = $scope.isDirtyVuln() || $scope.isDirtyLieu() || $scope.isDirtyRes() || $scope.isDirtyRep() || $scope.isDirtyInscr() || $scope.isDirtyInscrDateDeb() || $scope.isDirtyInscrDateFin();
				mustCheckDirty = false;
			}
			return dirty;				
		};
		$scope.isDirty = function(v) {
			if (v || onlyModLocal) {
				// le save ne doit être possible que si on modifie slm localement
				// sinon, on procède par le transmit à la RAMQ et le retour update les données
				// si on ne transmet pas après une modification (param true ici), il valide que modifié.
				if (mustCheckDirty) {
					// compare clone with origin 
					//dirty = !helpers.compare($scope.patientData, that.model.currentPatientData());
					dirty = $scope.isDirtyVuln() || $scope.isDirtyLieu() || $scope.isDirtyRes() || $scope.isDirtyRep() || $scope.isDirtyInscr() || $scope.isDirtyInscrDateDeb() || $scope.isDirtyInscrDateFin();
					mustCheckDirty = false;
				}
				return dirty;				
			}
			return false;
		};
		
		$scope.$watch(
			function(scope) {
				return scope.model.inscrB2bUpdated().val;
			},
			function(newVal, oldVal, scope) {
				if (newVal>0) {
					// got a response following a submit modif or inscr.
					// update values of patientData to reflect the changes
				}
		});
		
		var dateAssist0 = new DynaDate({elem:"insCodeVDate0", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, 
			useCurrent: false, getDefault: function(){	return moment(that.model.currentDefault()['dateDefault']);}
		});
		var dateAssist1 = new DynaDate({elem:"insCodeVDate1", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, 
			useCurrent: false, getDefault: function(){	return moment(that.model.currentDefault()['dateDefault']);}
			});
		var dateAssist2 = new DynaDate({elem:"insCodeVDate2", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, 
			useCurrent: false, getDefault: function(){	return moment(that.model.currentDefault()['dateDefault']);}
		});
		
		$scope.b2bLocalAssist = {assistId: "autocomplete_b2bLocal", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.patientData.b2bPatientData.lieuSuiv.local) && angular.isDefined($scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal) ) {
						delete $scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal.nomLocal;	// ça permet de savoir que nouveau
					}
					return { url:"/syra/local/search",
						data: { k: query, u: clientUid }};
				},
				listWidth: 300,
				nextTabOnEnter: false,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
				selection: function(elem) {
					this.lockEntry();
					$http({
						method : "GET",
						url : "/syra/local/get?c=" + elem.c +"&u=" + clientUid
					}).then(function mySucces(response) {
						var res = response.data;
						if (angular.isUndefined(res.length)) {
							if (angular.isUndefined($scope.patientData.b2bPatientData.lieuSuiv.local)) {
								$scope.patientData.b2bPatientData.lieuSuiv.local = {};
							}
							$scope.patientData.b2bPatientData.lieuSuiv.local.valCodLocal = res;
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					return elem.c;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			};
		
		$scope.b2bEtabAssist = {assistId: "autocomplete_b2bEtab", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.patientData.b2bPatientData.lieuSuiv.etab) && angular.isDefined($scope.patientData.b2bPatientData.lieuSuiv.etab.valEtab)) {
						delete $scope.patientData.b2bPatientData.lieuSuiv.etab.valEtab.nomEtab;	// ça permet de savoir que nouveau
					}
					return { url:"/syra/etabl/search",
						data: { k: query, u:clientUid }};
				},
				listWidth: 300,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
				selection: function(elem) {
					this.lockEntry();
					//that.setCurrNoEtab(elem.c);
					$http({
						method : "GET",
						url : "/syra/etabl/get?c=" + elem.c +"&u=" + clientUid
					}).then(function mySucces(response) {
						var res = response.data;
						if (angular.isUndefined(res.length)) {
							delete res.valSect;	// on ne le veut pas.
							$scope.patientData.b2bPatientData.lieuSuiv.etab = res;	//un CEtab
							$scope.setDirtyLieu();
			    			var elem = {};
			    			elem.c = res.noSelectedEtab;
							elem.d = res.valEtab.nomEtab+ " (" + res.valEtab.typEtab + '-' + res.valEtab.catgEtab +")";
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					return elem.c;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			};
		
		var inscLocationDate = new DynaDate({elem:"inscLocationDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, getDefault: function(){	return moment(that.model.currentDefault()['dateDefault']);}});
		var startInscB2BDate = new DynaDate({elem:"startInscB2BDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, getDefault: function(){	return moment(that.model.currentDefault()['dateDefault']);}, maxDateElm:'endInscB2BDate'});
		var endInscB2BDate = new DynaDate({elem:"endInscB2BDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, getDefault: function(){	return moment(that.model.currentDefault()['dateDefault']);}, minDateElm:'startInscB2BDate'});
		var changeStartInscB2BDate = new DynaDate({elem:"changeStartInscB2BDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, getDefault: function(){	return moment(that.model.currentDefault()['dateDefault']);}, maxDateElm:'endInscB2BDate'});

		function clearInscription(){
			$scope.b2bData.inscription = {};
			$scope.b2bData.inscription.status = 0;
			for(var i = 0 ; i > that.patVCodes.length; i++ ){
				that.patVCodes[i].patVCode = "00";
			}
		}

		$scope.canModRep = function() {
			return angular.isDefined($scope.patientData.representant.ln);
		};
		$scope.canDelRep = function() {
			return that.model.currentPatientData().representant.ln!==undefined && that.model.currentPatientData().representant.ln!='' && (angular.isUndefined($scope.patientData.representant.ln) || $scope.patientData.representant.ln==='');
		};
		$scope.canModRes = function() {
			return angular.isDefined($scope.patientData.resident.noProf);
		};
		$scope.canDelRes = function() {
			return that.model.currentPatientData().resident.noProf!==undefined && that.model.currentPatientData().resident.noProf!='' && (angular.isUndefined($scope.patientData.resident.noProf) || $scope.patientData.resident.noProf==='');
		};
		
		$scope.getPersonneName = function(v) {
			var name = "";
			if (angular.isUndefined(v)) {
				return name;
			}
			if (angular.isDefined(v.lastName)) {
				name += v.lastName;
			} else if (angular.isDefined(v.ln)) {
					name += v.ln;
			}
			if (angular.isDefined(v.firstName)) {
				name += " " + v.firstName;
			} else if (angular.isDefined(v.fn)) {
				name += " " + v.fn;
			}
			return name;
		};
		$scope.deleteRepresentant = function(){
			$scope.setDirtyRep();
			$scope.patientData.representant = {};
			$scope.patientData.representantType = 0;
		}
		
//		b2b_cancelPreInscription/post
//		b2b_supprimerInscription/post
//		b2b_changeDate/post
//		b2b_sendModVuln/post
//		b2b_ajouterLieuSuivi/post
//		b2b_modifRepres/post
//		b2b_modifierLieuSuivi/post
//		b2b_modifierResident/post
//		b2b_supprimerLieuSuivi/post
//		b2b_supprimerRepres/post
//		b2b_supprimerResident/post

		$scope.answerQuestions = function (methodCalled, questions, childrens){
			$scope.answerQuestionsOpened = true;
			var warnings = [];
			var infos = [];
			var oks = [];
			var errs = [];
			for ( var qt in childrens) {
				var st = childrens[qt];
				if ("Questions"!=st.message) {
					if (st.severity=='WARNING') {
						warnings.push(st.message);
					} else if (st.severity=='OK') {
						oks.push(st.message);
					} else if (st.severity=='ERROR') {
						errs.push(st.message);
					} else if (st.severity=='INFO') {
						infos.push(st.message);
					}  
				}
			}
			var titre = "Message(s)";
			var datas = {
					questions: questions,
					warnings: warnings,
					infos: infos,
					errs: errs,
					oks: oks
			};
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "md",
				resolve: {
					mObject: function () {
						return {
							title: titre,
							templateUrl:"/syra/Resources/views/answerQuestions.html",
							modalData: datas
						};
					}
				}
			});
			$scope.modalInstance.result.then(function (questions) {
				$scope.answerQuestionsOpened = false;
				for ( var qt in questions) {
					var quest = questions[qt];
					if (angular.isDefined(quest.check)) {
						quest.rep = (quest.check ? 'O' : 'N');
						delete quest.check;
					} else {
						quest.rep = 'N';
					}
				}
				if (methodCalled!=null) {
					methodCalled();					
				}
			}, function () {
				$log.info('Modal dismissed for answerQuestions');
				$scope.answerQuestionsOpened = false;
			});
		};
		
//		var childrens = [
//		                 {severity:'OK', message:"Succès de la procédure!"},
//		                 {severity:'INFO', message:"Un message info 1 comme ça."},
//		                 {severity:'WARNING', message:"un avertissement sérieux."},
//		                 {severity:'INFO', message:"un message info 2 comme ça."},
//		                 {severity:'INFO', message:"un message info 3 comme ça."}
//		                 ];
//		var questions = [
//		                 { msg:"Une question comme ça."},
//		                 { msg:"Une autre question."}
//		                 ];

		$scope.b2bInscription = function() {  // d=1 pour pre inscrire
			delete $scope.patientData.b2bPatientData.questions;
			delete $scope.patientData.b2bPatientData.dfi;
			b2bInscription();
		};
		function b2bInscription() {  // 2 = inscrire
//			$scope.answerQuestions(b2bInscription, questions, childrens);
//			return
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_transmettreInscription/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						$scope.patientData.b2bPatientData.status = 2;
						 _.cloneDeep($scope.patientData);
						
						that.model.currentPatient().isInsc = $scope.patientData.b2bPatientData.status;
						var ptData = _.cloneDeep($scope.patientData);
						that.model.currentPatientData().b2bPatientData = ptData.b2bPatientData;
						that.model.currentPatientData().representant = ptData.representant;
						that.model.currentPatientData().representantType = ptData.representantType;
						that.model.currentPatientData().resident = ptData.resident;
						var ss = ptData.b2bPatientData.situSant;
						that.model.currentPatient().allDisCodes = ss[0].c+'-'+ss[1].c+'-'+ss[2].c;
						mustCheckDirtyInscr=true;
						mustCheckDirtyLieu=true;
						mustCheckDirtyProf=true;
						mustCheckDirtyRep=true;
						mustCheckDirtyRes=true;
						mustCheckDirtyLieu=true;
						mustCheckDirtyVuln=true;
						mustCheckDirtyInscr=true;
						mustCheckDirtyInscrDateDeb=true;
						mustCheckDirtyInscrDateFin=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bInscription, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
		
		$scope.b2bCesserInscription = function() {
			$log.log("b2bCesserInscription");
			delete $scope.patientData.b2bPatientData.questions;
			b2bCesserInscription();
		};
		function b2bCesserInscription() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_cesserInscription/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						// il faut mettre à jour le currentPatient (4 var, soit inscrit, noProf et all
						$scope.patientData.b2bPatientData.status = 0;
						var ptData = _.cloneDeep($scope.patientData.b2bPatientData);
						that.model.currentPatient().isInsc = ptData.status;
						that.model.currentPatientData().b2bPatientData = ptData;
 						mustCheckDirtyInscr=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bCesserInscription, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
		
		$scope.b2bDelInscription = function() {
			$log.log("b2bDelInscription");
			delete $scope.patientData.b2bPatientData.questions;
			b2bDelInscription();
		};
		function b2bDelInscription() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_supprimerInscription/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						// il faut mettre à jour le currentPatient (4 var, soit inscrit, noProf et all
						$scope.patientData.b2bPatientData.status = 0;
						var ptData = _.cloneDeep($scope.patientData.b2bPatientData);
						that.model.currentPatient().isInsc = ptData.status;
						that.model.currentPatientData().b2bPatientData = ptData;
						mustCheckDirtyInscr=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bDelInscription, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
		
		$scope.b2bChangeInscDate = function() {
			$log.log("b2bChangeStartInscDate");
			delete $scope.patientData.b2bPatientData.questions;
			b2bChangeInscDate();
		};
		function b2bChangeInscDate() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_changeDate/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						that.model.currentPatientData().b2bPatientData.ddi = $scope.patientData.b2bPatientData.ddi;
						mustCheckDirtyInscrDateDeb=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bChangeInscDate, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
		
		$scope.b2bModRepresentant = function() {
			$log.log("b2bModRepresentant");
			delete $scope.patientData.b2bPatientData.questions;
			b2bModRepresentant();
		};
		function b2bModRepresentant() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_modifRepres/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						var repr = _.cloneDeep($scope.patientData.representant);
						that.model.currentPatientData().representant = repr;
						that.model.currentPatientData().representantType = $scope.patientData.representantType;
						mustCheckDirtyRep=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bModRepresentant, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
		
		$scope.b2bDelRepresentant = function() {
			$log.log("b2bDelRepresentant");
			delete $scope.patientData.b2bPatientData.questions;
			b2bDelRepresentant();
		};
		function b2bDelRepresentant() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_supprimerRepres/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						that.model.currentPatientData().representant = {};
						that.model.currentPatientData().representantType = 0;
						mustCheckDirtyRep=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bDelRepresentant, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
		
		$scope.b2bModResident = function() {
			$log.log("b2bModResident");
			delete $scope.patientData.b2bPatientData.questions;
			b2bModResident();
		};
		function b2bModResident() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_modifResident/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						that.model.currentPatientData().resident = _.cloneDeep($scope.patientData.resident);
						mustCheckDirtyRes=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bModResident, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
		
		$scope.b2bDelResident = function() {
			$log.log("b2bDelResident");
			delete $scope.patientData.b2bPatientData.questions;
			b2bDelResident();
		};
		function b2bDelResident() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_supprimerResident/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						that.model.currentPatientData().resident = {};
						mustCheckDirtyRes=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bDelResident, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});			
		}
		
		$scope.b2bModLieu = function() {
			$log.log("b2bModLieu");
			delete $scope.patientData.b2bPatientData.questions;
			b2bModLieu();
		};
		function b2bModLieu() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_modifierLieuSuivi/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					if (response.data.severity=='OK') {
						that.model.currentPatientData().b2bPatientData.lieuSuiv = _.cloneDeep($scope.patientData.b2bPatientData.lieuSuiv);
						that.model.currentPatientData().b2bPatientData.fld = $scope.patientData.b2bPatientData.fld;
						mustCheckDirtyLieu=true;
						mustCheckDirty=true;
						$scope.answerQuestions(null, [], response.data.childrens);
					} else  if (response.data.message=='Questions' && response.data.data) {
						$scope.patientData.b2bPatientData.questions = response.data.data;
						$scope.answerQuestions(b2bModLieu, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
		
		$scope.b2bModVuln = function() {
			$log.log("b2b_sendModVuln");
			delete $scope.patientData.b2bPatientData.questions;
			b2bModVuln();
		};
		function b2bModVuln() {
			$scope.generLoading=1;
			var _patientData = _.cloneDeep($scope.patientData);
			cleanPatientDataFromLieuSuivi(_patientData);
			that.model.httpPost("/syra/b2b_sendModVuln/post", JSON.stringify(_patientData), null, function(response) {
				if (response.data) {
					var questions = [];
					for ( var qt in response.data.childrens) {
						var st = response.data.childrens[qt];
						if ("Questions"==st.message && st.data) {
							questions = st.data;
						} else if (st.severity=='WARNING') {
						} else if (st.severity=='OK') {
							// donc on a un succès, data = Object[]{key,sant2}
							if (st.data && st.data.length==2) {	// si on a remplacé un code, le delete initial n'a pas de data.
								var k = st.data[0];
								var sant = st.data[1];
								that.model.currentPatientData().b2bPatientData.situSant[k].c = sant.c;
								if (sant.dd) {
									that.model.currentPatientData().b2bPatientData.situSant[k].dd = sant.dd;
								} else {
									delete that.model.currentPatientData().b2bPatientData.situSant[k].dd;
								}
								var ss = $scope.patientData.b2bPatientData.situSant;
								that.model.currentPatient().allDisCodes = ss[0].c+'-'+ss[1].c+'-'+ss[2].c;
								mustCheckDirtyVuln = true;
								mustCheckDirty=true;								
							}
						} else if (st.severity=='ERROR') {
						} else if (st.severity=='INFO') {
						}  
					}
					if (questions.length>0) {
						$scope.patientData.b2bPatientData.questions = questions;
						$scope.answerQuestions(b2bModVuln, $scope.patientData.b2bPatientData.questions, response.data.childrens);
					} else {
						$scope.answerQuestions(null, [], response.data.childrens);
					}
				} else  {
					$log.log("pas de response.data!!!");
				}
				$scope.generLoading=0;
			});
		}
				
		$scope.deleteResident = function(){
			$scope.setDirtyRes();
			$scope.patientData.resident = {}; 
		}
		$scope.residentAssist = {
				headerHtml: '<button class="btn sm primary" type="button" ng-click="newResident()"><i class="glyphicon glyphicon-user"></i> Nouveau résident</button>', 
				assistId: "autocomplete_resprof", 
				hasDetails: false,
				trigger: 'focus',
				getAjaxData: function(query){
					delete that.model.currentProf().id;
					return { url:"/syra/professionals/search",
						data: { k: query, e:12, u:clientUid }}; },	// e:12 = resident
				getKey: function(elem) {
					return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.noProf + "</div><div class='divCellCol2'>" + elem.lastName + ", " + elem.firstName + "</div></div></div>";
				},
				selection: function(elem) {
					this.lockEntry();
					$scope.setDirtyRes();
					$scope.patientData.resident = elem;
					this.close();
					return elem.noProf;
				},
		};
		$scope.repAssist = {
			headerHtml: '<button class="btn sm primary" type="button" ng-click="newRep()"><i class="glyphicon glyphicon-user"></i> Nouveau représentant</button>', 
			assistId: "autocomplete_rep",
			trigger: 'focus',
			hasDetails: true,
			getAjaxData: function(query){
				delete that.model.currentProf().id;
				return { url:"/syra/patient/search",
					data: { k: query, m:1, u:clientUid }}; 
			},
			getKey: function(pat) {
				return pat.ln + ", " +pat.fn + ' (' + pat.gender + ':' + pat.bds + ") " + pat.dos;
			},
			getDescription: function(pat) {
				var description = "<ul style='list-style-type:disc;-webkit-padding-start:12px;margin-bottom:0px;line-height:1.5'>";
				var adrss = "";
				if (angular.isDefined(pat.adr)) {
					var cyn;
					if (angular.isDefined(pat.adr.cy)) {
						cyn = pat.adr.cy.n;
					}
					adrss = helpers.cleanArray([pat.adr.a1,cyn, pat.adr.cp]).join(', ');
				}
				var adresse = adrss.length==0 ? "" : adrss + "; ";
				var vuln = pat.allDisCodes ? pat.allDisCodes : "";
				var hin = pat.hin ? pat.hin : "";
				var dos = (pat.dos && pat.dos.charAt(0)!='#') ? (' [' + pat.dos + ']') : '';
				var mdfam = (angular.isDefined(pat.txProfN) && pat.txProfN!=null && pat.txProfN!='') ? ' MD Fam: ' + pat.txProfN : '';
				description += "<li style='margin-bottom:3px'>" + hin + dos  + mdfam + "</li>"+ 
				(adrss.length==0 ? "" : "<li style='margin-bottom:3px'>" + adrss + "</li>") +
				"<li style='margin-bottom:3px'>" + (typeof pat.isInsc=='undefined' || pat.isInsc=='0' ? 'NON inscrit':'INSCRIT') + '; ' + vuln + "</li>" +
				"</ul>";
				description += "</ul>";
				return description;
			},
			selection: function(pat) {
				this.lockEntry();
				$scope.setDirtyRep();
				$scope.patientData.representant = pat;
				this.close();
				return pat.hin;
			}
		};
		function hasHin(p) {
			return angular.isDefined(p.hin)  && p.hin!=null && p.hin!='';
		}
		function cleanPatientDataFromLieuSuivi(d) {
			if (d.b2bPatientData.lieuSuiv.typLocEtab=='C') {
				delete d.b2bPatientData.lieuSuiv.local;				
			} else if (d.b2bPatientData.lieuSuiv.typLocEtab=='N') {
				delete d.b2bPatientData.lieuSuiv.etab;				
			}
			if (angular.isDefined(d.b2bPatientData.lieuSuiv.etab) && angular.isDefined(d.b2bPatientData.lieuSuiv.etab.valEtab)) {
				delete d.b2bPatientData.lieuSuiv.etab.valEtab;
			}
			if (angular.isDefined(d.b2bPatientData.lieuSuiv.local) && angular.isDefined(d.b2bPatientData.lieuSuiv.local.valCodLocal)) {
				delete d.b2bPatientData.lieuSuiv.local.valCodLocal.nomLocal;
				delete d.b2bPatientData.lieuSuiv.local.valCodLocal.listeMunic;
				delete d.b2bPatientData.lieuSuiv.local.valCodLocal.ddEffecCodLocal;
				delete d.b2bPatientData.lieuSuiv.local.valCodLocal.dfEffecCodLocal;
				delete d.b2bPatientData.lieuSuiv.local.valCodLocal.codLocalNouv;
			}
		}
				
		$scope.newResident = function (){
			$scope.newResidentOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "md",
				resolve: {
					mObject: function () {
						return {
							title: "Nouveau Résident",
							templateUrl:"/syra/Resources/views/editProfessional.html",
							modalData: {type: "12", isProfTx:'1'}
						};
					}
				}
			});

			$scope.modalInstance.result.then(function (prof) {
				$scope.newResidentOpened = false;
				$scope.setDirtyRes();
				$scope.patientData.resident = prof;
			}, function () {
				$log.info('Modal dismissed for newResident');
				$scope.newResidentOpened = false;
			});
		};

		$scope.newRep = function (){
			$scope.inscriptionOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "md",
				resolve: {
					mObject: function () {
						return {
							title: "Nouveau Représentant",
							templateUrl:'/syra/editRepresentant?u=' + clientUid,
							modalData : {}
						};
					}				
				}
			});

			$scope.modalInstance.result.then(function (rep) {
				$scope.inscriptionOpened = false;
				$scope.setDirtyRep();
				$scope.patientData.representant = rep;
			}, function () {
				$log.info('Modal dismissed for newRep');
				$scope.inscriptionOpened = false;
			});
		};
		
		$scope.delDisability = function(v) {
			v.patVCode = '00';
			delete v.patVDate;
			$scope.setDirtyVC(v.id);
			return;
		};
				
	}]);
})();

