(function(){
	var widget = angular.module('widget', []);
	
	widget.controller('EditCityController', function ($scope, $http) {
		var that = this;
		that.city = {};
		$scope.add = function(valid, city){
			if(valid){
				$http({
					method : "POST",
					url : "/syra/city/add",
					data:  city,
					headers: {'Content-Type': 'application/json; charset=utf-8'}
				}).then(function mySucces(response) {
					new jBox('Notice', {
						color : 'green',
						content: "La ville a été ajouté avec succès",
						attributes: {
							x: 'right',
							y: 'bottom'
						}
					});
				}, function myError(response) {
					new jBox('Notice', {
						color : 'red',
						content: "Erreur d'ajout de la ville",
						attributes: {
							x: 'right',
							y: 'bottom'
						}
					});
				});
			}else{
				new jBox('Notice', {
					color : 'red',
					content: "Veuillez saisir le nom de la ville.",
					attributes: {
						x: 'right',
						y: 'bottom'
					}
				});
			}
		}
	});
	
	widget.controller('ModalInstanceCtrl', function ($scope,$uibModal,$uibModalInstance,mObject) {
		$scope.modal ={};
		$scope.mObject = mObject;
		
		//Pour fermer le modal et retourner un objet
		$scope.modal.ok = function (res) {
			$uibModalInstance.close(res);
		};
		
		//Pour fermer le modal
		$scope.modal.cancel = function () {
			$uibModalInstance.dismiss('cancel');
		};
		
		//Pour faire un action avant le close du widget redefinir la fonction $scope.modal.closing()
		//event.preventDefault() pour annuler la fermeture
		$scope.$on('modal.closing', function(event, reason, closed) {
			if (angular.isDefined($scope.modal.closing)) {
				$scope.modal.closing(event, reason, closed);
			}
		});
	});
	
	widget.service('jBox', function() {
		this.create = function(type, config) {
			var jbox = new jBox(type, config);
			return jbox;
		}
	});
	
	widget.directive('openModal', function(){
	    return {
	        restrict: 'A',
	        link: function(scope, elem, attr, ctrl) {
	            var dialogId = '#' + attr.openDialog;
	            elem.bind('click', function(e) {
	                $(dialogId).dialog('open');
	            });
	        }
	    };
	});
	widget.directive('myHeight', function(){
		return {
			restrict: 'A',
			link: function(scope, elem, attr, ctrl) {
				var actions = scope.$eval(attr.myHeight);
				scope.myHeight = $(elem).height();
			}
		};
	});
	
	widget.directive('dynaDateW', function(){
		
		return {
			restrict : 'EA',
			compile: function(element, attrs){
				if(!attrs.placeholder){attrs.placeholder = "AAAA-MM-JJ";}
				if(!attrs.dynaDefault){attrs.dynaDefault = function(){};}
			},
			scope:{
				id:'@',
				wdate : '=model',
				placeholder: '@',
				dtpoptions: '=',
				'getDefault': '&dynaDefault'
			},
			templateUrl : '/syra/Resources/views/datewidget.html'
				
		};
	});
	widget.directive('actionKey', function($timeout){
		
		return {
			restrict : 'EA',
			link: function(scope, element, attrs){
				var actions = scope.$eval(attrs.actionKey);
				var actionMap = new Map();
				
				function addAction(actionItems){
					var key;
					if(actionItems instanceof Array){
						for(i = 0; i < actionItems.length; i++){
							if(angular.isDefined(actionItems[i].key) && angular.isDefined(actionItems[i].callback)){
								key = actionItems[i].altKey ? 'alt' + actionItems[i].key : actionItems[i].key;
								actionMap.set(key, actionItems[i].callback);
							}else{
								console.log("Error: A key and a callback is required.");
							}
						}
					}else if (angular.isDefined(actionItems)){
						if(angular.isDefined(actionItems.key) && angular.isDefined(actionItems.callback)){
							key = actionItems.altKey ? 'alt' + actionItems.key : actionItems.key;
							actionMap.set(key, actionItems.callback);
						}else{
							console.log("Error: A key and a callback is required.");
						}
					}
				}
				addAction(actions);
				function eventHandled(e){
					e.preventDefault();
					e.stopPropagation();
				}
				$(element).keypress(function(e) {
					var key = e.altKey ? 'alt' + e.which : e.key == undefined ? String.fromCharCode(e.which) : e.key;
					if(actionMap.has(key)){
						$timeout(function() {
							actionMap.get(key)();
						},0);
						eventHandled(e);
						return false;
					}
				});
			}
				
		};
	});
	
	widget.directive('dynaDate', ['$timeout', function($timeout) {
		
		return {
			restrict : 'A',
			scope : {
				
			},
			link :  function(scope, element, attrs){
//				var defaults;
//				defaults = attrs.datetimepickerOptions ? JSON.parse(attrs.datetimepickerOptions): {};
				$timeout(function() {
					scope.dynaDate.elem = element;
					var dateAssist = new DynaDate(scope.dynaDate);
					dateAssist.getDefault = scope.getDefault;
				}, 0);
			}
				
		};
	}]);
	
//	
//	widget.directive('addInput', function(){
//		return {
//			restrict : 'EA',
//			compile: function(element, attrs){
//				if(!attrs.assistModel){attrs.assistModel = "{}";}
//			},
//			scope: {
//				'commit': '&commit',
//				id : '@',
//				placeholder: '@',
//				assistModel: '=',
//				assistAttrTitle: '@',
//				assistInputFocusFunction: '@',
//				assistOptions: '='
//			},
//			link: function(scope, element, attrs){
//				var test = "test";
//			},
//			templateUrl : '/syra/Resources/views/addInput.html'
//			
//		};
//	});
	
	widget.directive('highlightTime', function($timeout, $templateRequest){
		function hightlightTime(input){
			var startPos = 11;
			var endPos = 16;
			//input.focus();
			if(input.value.length >= 16){
				if (typeof input.selectionStart != "undefined") {
					input.selectionStart = startPos;
					input.selectionEnd = endPos;
				} else if (document.selection && document.selection.createRange) {
					// IE branch
					input.select();
					var range = document.selection.createRange();
					range.collapse(true);
					range.moveEnd("character", endPos);
					range.moveStart("character", startPos);
					range.select();
				}
			}
		}
		return {
			restrict : 'A',
			link: function(scope, element, attrs) {
				$timeout(function() {
					$(element).on("dp.change", function (e) {
						hightlightTime(element[0]);
					});
					$(element).keyup( function(){
						hightlightTime(element[0]);
					});
	              }, 0);
			}
		};
	});
	
	widget.directive('assistOptions', function($timeout, $templateRequest, $compile){
		return {
			restrict : 'EA',
			scope: {
				id : '@',
				placeholder: '@',
				assistModel: '=',
				assistAttrTitle: '@',
				assistInputFocusFunction: '@',
				assistOptions: '='
			},
			link: function(scope, element, attrs) {
		        var isField = (typeof attrs.addInput === 'undefined');

		        if(isField) {
		        	$timeout(function() {
		        		 // Load the html through $templateRequest
			            $templateRequest('/syra/Resources/views/assistwidget.html').then(function(html){
			                // Convert the html to an actual DOM node
			                var template = angular.element(html);
			                // Append it to the directive element
			                element.append(template);
			                // And let Angular $compile it
			                $compile(template)(scope);
			            });
		              }, 0);
		           
		        }
		    }
		};
	});
	
	widget.directive('dynaAssist', ['$timeout', function( $timeout){
		return {
			restrict : 'EA',
			transclude:true,
			scope: {
				id: '@',
				assistId: '@',
				dynaAssist: '='
			},
			link: function(scope, element, attrs){
				if(typeof scope.assistOptions === "undefined" && scope.dynaAssist != "undefined"){
					scope.assistOptions = scope.dynaAssist;
				}
				  $timeout(function() {
					  if(typeof scope.assistOptions != "undefined"){
						  scope.assistOptions.elem = element.get(0);
						  scope.assistOptions.angular = true;
						  if($.isEmptyObject(scope.assistOptions.assistId)) scope.assistOptions.assistId = 
							  typeof scope.assistId !== 'undefined'? scope.assistId : scope.id +"_assist";
						  var assist = new AssistDynaText(scope.assistOptions);
						  scope.$on('$destroy', function() {
							  assist.destroy();
						  })
					  }
	              }, 0);
				}
			}
		}]);
	
	widget.directive('convertToNumber', function() {
	  return {
		    require: 'ngModel',
	    link: function(scope, element, attrs, ngModel) {
	      ngModel.$parsers.push(function(val) {
	        return parseInt(val, 10);
	      });
	      ngModel.$formatters.push(function(val) {
	        return '' + val;
	      });
	    }
	  };
	});
	
	widget.factory('dialogService', [function() {
	    return {
	        open: function(elementId) {
	            $(elementId).dialog('open');
	        }
	    };
	}]);
})();