(function(){
	var app = angular.module("settings", ['widget','ngTouch','ui.grid','ui.grid.resizeColumns','ui.grid.grouping', 'ui.grid.cellNav', 'ui.grid.autoResize']);

	app.controller('ResultatInscrB2b', ['$scope', '$filter', '$timeout', 'uiGridConstants', 'uiGridGroupingConstants', '$uibModal', function($scope, $filter, $timeout, uiGridConstants, uiGridGroupingConstants, $uibModal){
		var that = this;
		$scope.warnings = $scope.mObject.modalData.warnings;
		$scope.infos = $scope.mObject.modalData.infos;
		$scope.oks = $scope.mObject.modalData.oks;
		$scope.errs = $scope.mObject.modalData.errs;
		$scope.clientData = $scope.mObject.modalData.clientData;
		
		that.dataLoading = true;

		var vthresh = 50;
		var scrollt = 80
		var wheelst = 150;
		var exRows = 100;
		
		$scope.gridB2bResultatOptions = { data: $scope.clientData,
			virtualizationThreshold: vthresh,
			scrollThreshold:scrollt,
			wheelScrollThrottle:wheelst,
			excessRows:exRows,
			enableColumnResizing: false,
			enableFiltering: true,
			enableSorting: true,
			saveScroll: false,
			enableHiding: false,
			enableGridMenu: true,
			exporterMenuCsv: false,
			exporterCsvFilename: function(){ return "b2bResultat.csv";},
			exporterPdfDefaultStyle: {fontSize: 9},
			exporterPdfTableStyle: {margin: [0,0,0,0]},
			exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
			exporterPdfHeader: function () { return {text: "Résultats 'Obtention clients inscrits'", style: 'headerStyle' };},
			exporterPdfFooter: function ( currentPage, pageCount ) {
				return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
			},
			exporterPdfCustomFormatter: function ( docDefinition ) {
				docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
				docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
				return docDefinition;
			},
			exporterPdfOrientation: 'portrait',
			exportPdfIf: function(gdata){
				if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
				else {
					model.warning(MSG_TEXT['TROP_DATA']);
					return false;
				}
			},
			onPdfExport:function(doc, binarydoc){ 
				$scope.inscriptionOpened = true;
				that.dataLoading = false;
				$scope.modalInstance = $uibModal.open({
					animation: $scope.animationsEnabled,
					templateUrl: "/syra/Resources/views/modal.html",
					controller: 'ModalInstanceCtrl',
					size: "lg",
					resolve: {
						mObject: function () {
							return {
								title: "Sommaire",
								templateUrl:"/syra/Resources/views/pdfviewer.html",
								doc: binarydoc
							};
						}
					}
				});

				$scope.modalInstance.result.then(function () {
					$scope.inscriptionOpened = false;
		        }, function () {
		            $scope.inscriptionOpened = false;
		        });
			},
			exporterPdfPageSize: 'LETTER',
			exporterPdfMaxGridWidth:480,
			appScopeProvider: this,
			columnDefs: [
			             { field: 'np', displayName: 'Prof.', grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "10%"},
			             { field: 't', displayName: 'T', grouping: { groupPriority: 1 }, sort: { priority: 1, direction: 'asc' }, cellTooltip: function(row, col){return getDescType(row.entity.a)}, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "8%"},
			             { field: 'nam', displayName: 'NAM', sort: { priority: 2, direction: 'asc' }, width: "13%"},
			             { field: 'ln', displayName: 'Nom', width: "10%"},
			             { field: 'fn', displayName: 'Prénom', width: "10%"},
			             { field: 'ddn', displayName: 'DDN', width: "10%"},
			             { field: 'sex', displayName: 'Sex', width: "4%"},
			             { field: 'txMod', displayName: 'Modifications', width: "35%"}
			             ],
             exporterFieldCallback: function( grid, row, col, input ) {
            	  if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
            	    var filters = col.cellFilter.split('|');
            	    for(i=0; i<filters.length;i++) {
            	      var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
            	      var filterName=pars[0].trim();
            	      var filterPar = null;
            	      if (pars.length==2) {
            	        filterPar = pars[1].slice(1, -1);
            	        input = $filter(filterName)( input,filterPar);
            	      } else {
            	        input = $filter(filterName)( input );
            	      }
            	    }
            	  }
            	  return input;
             },
             onRegisterApi: function(gridApi){
            	 $scope.gridB2bResultatApi = gridApi;
 				gridApi.core.on.rowsRendered($scope, function() {
					if (that.dataLoading) {
						$scope.gridB2bResultatApi.core.on.sortChanged($scope, $scope.sortChanged);
						var tree = $scope.gridB2bResultatApi.grid.treeBase.tree;
						for (var i = tree.length-1; i >= 0; i--) {
							$scope.gridB2bResultatApi.treeBase.expandRow(tree[i].row);
							var tree2 = tree[i].children;
//							for (var j = tree2.length-1; j >= 0; j--) {
//								$scope.gridB2bResultatApi.treeBase.expandRow(tree2[j].row);
//							}
						}
						that.dataLoading = false;				
					}
				});				
             }
			};
		
		function getDescType(input) {
			if (angular.isUndefined(input) || input=='' || input==null) {
				return '';
			} else if (input===1){
				return "Inscription non modifiée";
			} else if (input===2){
				return "Inscription ajoutée";
			} else if (input===4){
				return "Retrait de l'inscription";
			} else if (input>4){
				return "Inscription modifiée";
			} else {
				return '';
			}
		}
	}]);
	
	
	app.controller('SettingsController', ['$scope', '$http', '$interval', '$timeout', '$log', 'clientUid','model', 'AuthService', 'uiGridConstants','$uibModal',
	                                      function ($scope, $http, $interval, $timeout, $log, clientUid, model, AuthService, uiGridConstants, $uibModal) {
		$scope.isLocal = AuthService.isLocal;
		$scope.section = $scope.isLocal ? 0 : 1 ;
		var helpers = MyNamespace.helpers;

		var vthresh = 50;
		var scrollt = 80
		var wheelst = 150;
		var exRows = 100;
		
		this.prof = model.currentProf();
		var that = this;
		that.model = model;
		$scope.model = model;
		var fichiersVersions = [];
		var hidePswd = "Cacher le mot de passe";
		var showPswd = "Afficher le mot de passe";
		$scope.seeUserIdPswdTitle = showPswd;
		$scope.typeUserIdPswd = 'password';
		$scope.seeIdMachPswdTitle = showPswd;
		$scope.typeIdMachPswd = 'password';
		
		$scope.hasNewVersion = false;
		$scope.dataLoading = 1;	// data loading
		var getInfoMsg = "Obtention des informations concernant les fichiers en cours..."
		$scope.loadingTitle = "";
		$scope.hasUpdateFichierStatus = that.model.getUpdateFichierAideDone().val;
		$scope.hasGenerIdMachStatus = that.model.getGenerIdMachDone().val;
		$scope.generLoading = 0;	// génération id mach, 1 = en cours, 2 = done succès
		$scope.hasRenewIdMachPswdStatus = that.model.getRenewIdMachPswdDone().val;
		$scope.activLoading = 0;	// génération id mach en cours, 1 = en cours, 2 = done succès
		$scope.port = "";
		
		$scope.profData = [];
		$scope.profGmfAutoCtxData = [];
		$scope.profAutoCxData = [];
		$scope.idInscrData = [];
		$scope.profEtabInscrData = [];
		
		$scope.fichDejaObtenu = {};
		var fichNewObtenu = {};
		
		$scope.inscrits = [
			{'id': '1', 'label': 'Sans objet'},
			{'id': '2', 'label': 'Moins de 500 patients'},
			{'id': '3', 'label': '500 patients ou plus'}
		                 ];
		
		$scope.def = {
				share_shareConn: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('share_shareConn', newVal);
						that.model.saveCurrGlobalDefaultValues('share_shareConn');
						return;
					}
					return that.model.currentGlobalDefault()['share_shareConn'];
				},
				share_staticPort: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('share_staticPort', newVal);
						that.model.saveCurrGlobalDefaultValues('share_staticPort');
						that.model.setCurrGlobalDefaultValues('share_port', $scope.port);
						that.model.saveCurrGlobalDefaultValues('share_port');
						return;
					}
					return that.model.currentGlobalDefault()['share_staticPort'];
				},
				share_needsPswd: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('share_needsPswd', newVal);
						that.model.saveCurrGlobalDefaultValues('share_needsPswd');
						return;
					}
					return that.model.currentGlobalDefault()['share_needsPswd'];
				},
				share_motDePasse: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('share_motDePasse', newVal);
						that.model.saveCurrGlobalDefaultValues('share_motDePasse');
						return;
					}
					return that.model.currentGlobalDefault()['share_motDePasse'];
				},
				syra_noAgence: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('syra_noAgence', newVal);
						that.model.saveCurrGlobalDefaultValues('syra_noAgence');
						return;
					}
					return that.model.currentGlobalDefault()['syra_noAgence'];
				},
				syra_userId: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('syra_userId', newVal);
						that.model.saveCurrGlobalDefaultValues('syra_userId');
						return;
					}
					return that.model.currentGlobalDefault()['syra_userId'];
				},
				syra_userIdPswd: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('syra_userIdPswd', newVal);
						that.model.saveCurrGlobalDefaultValues('syra_userIdPswd');
						return;
					}
					return that.model.currentGlobalDefault()['syra_userIdPswd'];
				},
				syra_userIdPswdDate: function(newVal) {
					if (arguments.length) {
						var addTime = "";
						if (newVal.length==10) {
							addTime = "T12:00:00";
						}
						that.model.setCurrGlobalDefaultValues('syra_userIdPswdDate', newVal + addTime);
						that.model.saveCurrGlobalDefaultValues('syra_userIdPswdDate');
						return;
					}
					return that.model.currentGlobalDefault()['syra_userIdPswdDate'];
				},
				syra_idMach: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('syra_idMach', newVal);
						that.model.saveCurrGlobalDefaultValues('syra_idMach');
						return;
					}
					return that.model.currentGlobalDefault()['syra_idMach'];
				},
				syra_idMachPswd: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('syra_idMachPswd', newVal);
						that.model.saveCurrGlobalDefaultValues('syra_idMachPswd');
						return;
					}
					return that.model.currentGlobalDefault()['syra_idMachPswd'];
				},
				syra_idMachPswdDate: function(newVal) {
					if (arguments.length) {
						var addTime = "";
						if (newVal.length==10) {
							addTime = "T12:00:00";
						}
						that.model.setCurrGlobalDefaultValues('syra_idMachPswdDate', newVal + addTime);
						that.model.saveCurrGlobalDefaultValues('syra_idMachPswdDate');
						return;
					}
					return that.model.currentGlobalDefault()['syra_idMachPswdDate'];
				},
				is_infodata: function(newVal) {
					if (arguments.length) {
						// on ne permet pas de changer cette valeur qui correspond à Platform.inDebugMode() ? 1:0
						return;
					}
					return that.model.currentGlobalDefault()['INFODATA']===1;
				},
				envoi_tps_reel: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('envoi_tps_reel', newVal);
						that.model.saveCurrGlobalDefaultValues('envoi_tps_reel');
						return;
					}
					return that.model.currentGlobalDefault()['envoi_tps_reel'];
				},
				share_dme: function(newVal) {
					if (arguments.length) {
						that.model.setCurrGlobalDefaultValues('share_dme', newVal);
						that.model.saveCurrGlobalDefaultValues('share_dme');
						return;
					}
					return that.model.currentGlobalDefault()['share_dme'];
				}
		};
		
		$scope.seeUserIdPswd = function() {
			if ('text'==$scope.typeUserIdPswd) {
				$scope.seeUserIdPswdTitle = showPswd;
				$scope.typeUserIdPswd = 'password';
			} else {
				$scope.seeUserIdPswdTitle = hidePswd;
				$scope.typeUserIdPswd = 'text';
			}
		};
		$scope.seeIdMachPswd = function() {
			if ('text'==$scope.typeIdMachPswd) {
				$scope.seeIdMachPswdTitle = showPswd;
				$scope.typeIdMachPswd = 'password';
			} else {
				$scope.seeIdMachPswdTitle = hidePswd;
				$scope.typeIdMachPswd = 'text';
			}
		};
		$scope.hasIncompleteSyraId = function() {
			var def = $scope.def;
			return angular.isUndefined(def.syra_noAgence()) || angular.isUndefined(def.syra_userId()) || angular.isUndefined(def.syra_userIdPswd()) || def.syra_noAgence()=='' || def.syra_userId()=='' || def.syra_userIdPswd()=='';
		};
		$scope.hasIncompleteSyraIdMach = function() {
			var def = $scope.def;
			return angular.isUndefined(def.syra_idMach()) || angular.isUndefined(def.syra_idMachPswd()) || def.syra_idMach()=='' || def.syra_idMachPswd()=='';
		};
		$scope.hasDataSyraIdMach = function() {
			var def = $scope.def;
			return (angular.isDefined(def.syra_idMach()) && def.syra_idMach()!='') || (angular.isDefined(def.syra_idMachPswd()) &&def.syra_idMachPswd()!='') || (angular.isDefined(def.syra_idMachPswdDate()) && def.syra_idMachPswdDate()!='');
		};
		
		$scope.generIdMach = function() {
			var identB2b = {};
			identB2b.syra_noAgence = $scope.def.syra_noAgence();
			identB2b.syra_userId = $scope.def.syra_userId();
			identB2b.syra_userIdPswd = $scope.def.syra_userIdPswd();
			var sObj = JSON.stringify(identB2b);
			var cUidObject = {'o': sObj, 'u': clientUid};
			$scope.generLoading = 1;
			if (angular.isDefined($scope.hasGenerIdMachStatus.message)) {
				delete $scope.hasGenerIdMachStatus.message;
			}
			startInterval(120);
			$http({method : "POST",
				url : "/syra/generidmach/post",
				data:  JSON.stringify(cUidObject),
				headers: {'Content-Type': 'application/json; charset=utf-8'}
			}).then(function mySucces(response) {
			}, function myError(response) {
				warning(response.statusText);
			});
		};
		$scope.deleteIdMach = function() {
			$scope.def.syra_idMach('');
			$scope.def.syra_idMachPswd('');
			$scope.def.syra_idMachPswdDate('');
			$scope.generLoading = 0;
			$scope.activLoading = 0;
		};
		$scope.renewIdMachswd = function() {
			var identB2b = {};
			identB2b.syra_noAgence = $scope.def.syra_noAgence();
			identB2b.syra_idMach = $scope.def.syra_idMach();
			identB2b.syra_idMachPswd = $scope.def.syra_idMachPswd();
			var sObj = JSON.stringify(identB2b);
			var cUidObject = {'o': sObj, 'u': clientUid};
			$scope.activLoading = 1;
			if (angular.isDefined($scope.hasRenewIdMachPswdStatus.message)) {
				delete $scope.hasRenewIdMachPswdStatus.message;
			}
			startInterval(120);
			$http({method : "POST",
				url : "/syra/actividmach/post",
				data:  JSON.stringify(cUidObject),
				headers: {'Content-Type': 'application/json; charset=utf-8'}
			}).then(function mySucces(response) {
			}, function myError(response) {
				warning(response.statusText);
			});
		};
		
		var prefProfAutresLoaded = false;
		$scope.loadPrefProfLoadAutres = function() {
			if (!prefProfAutresLoaded) {
				prefProfAutresLoaded = true;
				$http.get("/syra/pref/autre?u=" + that.clientUid)
				.success(function(data) {
					$scope.profEtabInscrData.length = 0
					$scope.profData.length = 0;	// permet de garder la référence à $scope.gridProfOptions.data
					$scope.profGmfAutoCtxData.length = 0;	// permet de garder la référence à $scope.gridProfOptions.data
					for (var prof in data) {
						if (data.hasOwnProperty(prof)) {
							var p = prof.split('~');
							if (p[2]==1) {	// uniquement pour omni
								var pp = {
										id: p[0],
										name:p[1] + " (" + p[3] + ")",
										type:p[2],
										gmf: (angular.isUndefined(data[prof].gmf) ? '' : data[prof].gmf),
										inscrit: (angular.isUndefined(data[prof].inscrit) ? '1' : data[prof].inscrit) 
								};
								$scope.profData.push(pp);
								var pEtabInscr = {
										id: p[0],
										name:p[1] + " (" + p[3] + ")",
										type:p[2],
										no:p[3],
										etab: (angular.isUndefined(data[prof].etab) ? '' : data[prof].etab)
								};
								$scope.profEtabInscrData.push(pEtabInscr);								
							}
							var cx = [];
							if (angular.isDefined(data[prof].autoCx)) {
								// autoCx format: groupe de etab+cx séparés par ~. Etab-cx: codeEtab-codeSect:cx cx cx
								// ex de 2 etab avec un auto ctx pour un, sans secteur, et 3 pour l'autre avec sect 41
								// autoCx~55509:85~55509-41:70 75 150
								var cxs = data[prof].autoCx.split(';');
								for (var acxId in cxs) {
									var acx = cxs[acxId];
									var etabSectCx = acx.split(':');
									var es = etabSectCx[0].split('-');
									var ctx = {
											etab:es[0],
											sect: (es.length==1 ? '':es[1]),
											cx: etabSectCx[0].length==1 ? '':etabSectCx[1]
									};
									cx.push(ctx);
								}
							}
							var pAutoCx = {
									id: p[0],
									name:p[1] + " (" + p[3] + ")",
									type:p[2],
									autoCx: (angular.isUndefined(data[prof].autoCx) ? '' : data[prof].autoCx),
									cx: cx
							};
							$scope.profGmfAutoCtxData.push(pAutoCx);
						}
					}
					$scope.profData.sort(function(a,b) {return a.name.localeCompare(b.name)});
					$scope.profGmfAutoCtxData.sort(function(a,b) {return a.name.localeCompare(b.name)});
					$scope.profEtabInscrData.sort(function(a,b) {return a.name.localeCompare(b.name)});
					$timeout(function(){
						if (angular.isDefined($scope.gridProfApi)) {
							$scope.gridProfApi.grid.modifyRows($scope.gridProfOptions.data);						
						}
						if (angular.isDefined($scope.gridProfGmfAutoCxApi)) {
							$scope.gridProfGmfAutoCxApi.grid.modifyRows($scope.gridProfGmfAutoCxOptions.data);						
						}
						if (angular.isDefined($scope.gridProfEtabInscrApi)) {
							$scope.gridProfEtabInscrApi.grid.modifyRows($scope.gridProfEtabInscrOptions.data);						
						}
					},250);
				});
			}
		}
				
		$scope.resultatB2b = function (methodCalled, data){
			$scope.resultatB2bOpened = true;
			var warnings = [];
			var infos = [];
			var oks = [];
			var errs = [];
			var clientData = []
			for ( var qt in data.childrens) {
				var st = data.childrens[qt];
				if (st.severity=='WARNING') {
					warnings.push(st.message);
				} else if (st.severity=='OK') {
					oks.push(st.message);
					clientData = st.data;
				} else if (st.severity=='ERROR') {
					errs.push(st.message);
				} else if (st.severity=='INFO') {
					infos.push(st.message);
				}  
			}
			var titre = "Résultat de 'Obtenir inscriptions'";
			var datas = {
					warnings: warnings,
					infos: infos,
					errs: errs,
					oks: oks,
					clientData: clientData
			};
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "lg",
				resolve: {
					mObject: function () {
						return {
							title: titre,
							templateUrl:"/syra/Resources/views/inscr_b2b_resultat.html",
							modalData: datas
						};
					}
				}
			});
			$scope.modalInstance.result.then(function (questions) {
				$scope.resultatB2bOpened = false;
			}, function () {
				$log.info('Modal dismissed for resultatB2b');
				$scope.resultatB2bOpened = false;
			});
		};
		
		// $scope.resultatB2b(null, data);
		
		$scope.getInscr = function() {
			if ($scope.getInscrLoading!==1) {
//				$scope.getInscrLoading = 1;
//				return;
				var getInscr = {};
				getInscr.profs = [];
				var selectedRow = $scope.gridIdInscrApi.selection.getSelectedRows();
				if (selectedRow && selectedRow.length==1) {
					getInscr.noGmf = selectedRow[0].gmf;
					getInscr.noEtab = selectedRow[0].noEtabl;
					var profs = $scope.gridProfEtabInscrOptions.data;
					var len = profs.length;
					for (var i = 0; i < len; i++) {
					    if (profs[i].etab && profs[i].etab.indexOf(getInscr.noEtab)>-1) {
					    	getInscr.profs.push(profs[i].no);
					    }
					}
					if (getInscr.profs.length>0) {
						$scope.getInscrLoading = 1;
						that.model.httpPost("/syra/b2b_getInscr/post", JSON.stringify(getInscr), null, function(response) {
							if (response.data) {
								var st = response.data;
								$scope.resultatB2b(null, response.data);
							} else  {
								$log.log("pas de response.data!!!");
							}
							$scope.getInscrLoading = 2;
						});
					}
				}
//			} else if ($scope.getInscrLoading===1) {
//				$scope.getInscrLoading = 2;
//			} else if ($scope.getInscrLoading===2) {
//				$scope.getInscrLoading = 0;				
			}
		};
		
		function formatElemFichSynchro(elem) {
			return elem.substr(0,5) + ':' + elem.substr(6,4) + '-' + elem.substr(10,2) + '-'  + elem.substr(12,2) + " " + elem.substr(14,2) + 'H'  + elem.substr(16,2);
		}
		
		$scope.fichSynchroAntAssist = {assistId: "autocomplete_fichSynchroAnt", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.fichDejaObtenu.dateFile)) {
						delete $scope.fichDejaObtenu.dateFile;
					}
					return { url:"/syra/b2b_inscrClient/search",
						data: { k: query, u: clientUid }};
				},
				listWidth: 150,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {
					if (angular.isDefined(elem) && elem!=null && elem.length>11) {
						return "<div class='divTable'><div class='divRow'><div class='divCellCol2' style='padding:0.5em;'>" + formatElemFichSynchro(elem) + "</div></div></div>";
					}
					return "";
				},
				selection: function(elem) {
					$http({
						method : "GET",
						url : "/syra/b2b_inscrClient/get?c=" + elem +"&u=" + clientUid + "&f=" + (that.model.currentDefault()['force_update_mnt_paye'] ?'1':'0')
					}).then(function mySucces(response) {
						if (angular.isDefined(response.status)) {
							if (200===response.status) {// équivalent à 'OK'
								var status = response.data;
								if ('ERROR'===status.severity) {
								} else if ('OK'==status.severity && status.data) {
									$scope.resultatB2b(null, JSON.parse(status.data));
								} else {
								}
							} else {
							}
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					$scope.fichDejaObtenu.dateFile = formatElemFichSynchro(elem);
				}
		};
		
		$scope.canGetInscr = function() {
			if (angular.isUndefined($scope.gridIdInscrApi) || $scope.getInscrLoading===1) {
				return false;
			}
			var selectedRow = $scope.gridIdInscrApi.selection.getSelectedRows();
			if (selectedRow && selectedRow.length==1) {
				var no = selectedRow[0].noEtabl;
				var idMach = selectedRow[0].idMach;
				var pswd = selectedRow[0].pswd;
				if (helpers.isEmpty(idMach) || helpers.isEmpty(pswd) || helpers.isEmpty(no)) {
					return false;
				}
				var profs = $scope.gridProfEtabInscrOptions.data;
				var len = profs.length;
				for (var i = 0; i < len; i++) {
				    if (profs[i].etab && profs[i].etab.indexOf(no)>-1) {
				    	return true;
				    }
				}
			}
			return false;
		};
		
		$scope.profPref = {
				inscrit: function(newVal) {
					if (angular.isDefined(that.prof.id)) {
						if (arguments.length) {
							that.model.setProfPrefPropValue(that.prof.id, 'inscrit', newVal);
							return;
						}
						return that.model.profPrefPropValue(that.prof.id, 'inscrit', '1');
					}
				},
				gmf: function(newVal) {
					if (angular.isDefined(that.prof.id)) {
						if (arguments.length) {
							that.model.setProfPrefPropValue(that.prof.id, 'gmf', newVal);
							return;
						}
						return that.model.profPrefPropValue(that.prof.id, 'gmf', '');
					}
				},
				autoCx: function(newVal) {
					if (angular.isDefined(that.prof.id)) {
						if (arguments.length) {
							that.model.setProfPrefPropValue(that.prof.id, 'autoCx', newVal);
							return;
						}
						return that.model.profPrefPropValue(that.prof.id, 'autoCx', '');
					}
				}
		};

		$scope.changeProfAutres = function(id, t, val) {
 		   $http({url: "/syra/pref/autre/mod",
		   		method: "GET",
		   		async:   true,
		   		params: {id : id, k: t, v : val, u: clientUid}
		   });
		};
		
		that.hasProf = function() {
			return angular.isDefined(that.prof.noProf);
		};
		
		$scope.settingsProfAssist = {
				getAjaxData: function(query){
					return { url:"/syra/professionals/search",
						data: { k: query, u:clientUid }};
				},
				listWidth: 300,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.noProf + "</div><div class='divCellCol2'>" + elem.lastName + ", " + elem.firstName + "</div></div></div>";},
				selection: function(elem) {
					this.lockEntry();
					that.prof=elem;
					$scope.loadPrefProfInscrits();
					return elem.noProf;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			};
			
			this.searchProfessional = function(queryString){
				$http({
					method : "GET",
					url : "/syra/professionals/search?k=" + queryString  + "&u=" + clientUid
				}).then(function mySucces(response) {
					if(response.data.length == 1){
						that.prof=response.data[0];
					}
					that.listProf = response.data;
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
			};
		
		$scope.restartJetty = function() {
			$http({
				method : "GET",
				url : "/syra/jetty/restart?u=" + clientUid
			}).then(function mySucces(response) {
			}, function myError(response) {
			});			
		}
		
		$scope.openLocal = function(type){
			$http({
				method : "GET",
				url : "/syra/launch_local?k="+ type
			}).then(function mySucces(response) {
				$scope.url_local = response.data[0];
				$scope.port = response.data[1];	// J'ai besoin du port si on active share avec port static
			}, function myError(response) {
			});
		}
				
		$scope.openExternal = function(type){
			$http({
				method : "GET",
				url : "/syra/launch?k="+ type
			}).then(function mySucces(response) {
				$scope.url = response.data[0];
				$scope.port = response.data[1];	// J'ai besoin du port si on active share avec port static
			}, function myError(response) {
			});
		}
		
		$scope.getFichiersVersions = function(){
			if (angular.isDefined($scope.hasUpdateFichierStatus.code)) {
				delete $scope.hasUpdateFichierStatus.severity;
				delete $scope.hasUpdateFichierStatus.message;
			}
			$scope.loadingTitle = getInfoMsg;			
			$http({
				method : "GET",
				url : "/syra/fichiersversions/get?u="+ clientUid
			}).then(function mySucces(response) {
				that.fichiersVersions = response.data;
				hasNewFichiers();
			}, function myError(response) {
			});
		}
		
		function hasNewFichiers(){
			$http({
				method : "GET",
				url : "/syra/fichiersversions/newavailversion?u="+ clientUid
			}).then(function mySucces(response) {
				$scope.hasNewVersion = response.data==1;
				if ($scope.dataLoading==2) {
					$scope.dataLoading = 3;	// pour montrer l'icone OK
				} else {
					$scope.dataLoading = 0;
				}
			}, function myError(response) {
			});
		}
		
		$scope.updateFichiers = function(){
			$scope.dataLoading = 1;
			$scope.loadingTitle = "Validation des données d'identification...";
			if (angular.isDefined($scope.hasUpdateFichierStatus.message)) {
				delete $scope.hasUpdateFichierStatus.message;
			}
			$http({
				method : "GET",
				url : "/syra/fichiersversions/update?u="+ clientUid
			}).then(function mySucces(response) {
				var res = response.data;
				if (angular.isDefined(res.severity)) {
					// donc un status.
					if ("ERROR"==res.severity) {
						$scope.hasUpdateFichierStatus.code = res.code;
						$scope.hasUpdateFichierStatus.severity = res.severity;
						$scope.hasUpdateFichierStatus.message = res.message;
						jNotice(res.message, 'red');
					} else if ("INFO"==res.severity) {
						$scope.dataLoading=2;
						$scope.loadingTitle = "Mise à jour des fichiers d'aide à la saisie en cours... Veuillez patienter.";
						// il faut un timer sinon digest ne semble jamais être lancé durant l'attente...
						startInterval(240);
					}
				}
			}, function myError(response) {
			});
		}

		$scope.loadGmfs = function(){
			$http({
				method : "GET",
				url : "/syra/gmfs/get?u="+ clientUid
			}).then(function mySucces(response) {
				var res = response.data;
				if (angular.isDefined(res.severity)) {
					// donc un status.
					if ("OK"==res.severity) {
						helpers.clearAndAddToArray($scope.idInscrData, res.data);
						$scope.loadPrefProfLoadAutres();
					} else if ("ERROR"==res.severity) {
						jNotice(res.message, 'red');
					} else if ("INFO"==res.severity) {
						jNotice("info", 'green');
					}
				}
			}, function myError(response) {
			});
		}
		
		// .val est un Status (.code, .severity et .message)
		$scope.$watch(
			function (scope) {
                return scope.hasGenerIdMachStatus.code;
            },
            function(newVal, oldVal, scope) {
            	if (angular.isDefined(scope.hasGenerIdMachStatus.severity) && $scope.generLoading==1) {
					if (scope.hasGenerIdMachStatus.severity=='OK') {
						scope.generLoading = 2;
						var data = scope.hasGenerIdMachStatus.data;
						scope.model.setCurrGlobalDefaultValues('syra_idMach', data.syra_idMach);
						scope.model.setCurrGlobalDefaultValues('syra_idMachPswd', data.syra_idMachPswd);
						scope.model.setCurrGlobalDefaultValues('syra_idMachPswdDate', data.syra_idMachPswdDate);
					} else {
						scope.generLoading = 0;	// le contenu message de hasGenericIdMachStatus sera affiché. 
					}
					if (angular.isDefined(scope.Timer)) {
	                    $interval.cancel(scope.Timer);
	                }
				}
            });
		
		// .val est un Status (.code, .severity et .message)
		$scope.$watch(
				function (scope) {
					return scope.hasRenewIdMachPswdStatus.code;
				},
				function(newVal, oldVal, scope) {
					if (angular.isDefined(scope.hasRenewIdMachPswdStatus.severity) && scope.activLoading==1) {
						if (scope.hasRenewIdMachPswdStatus.severity=='OK') {
							scope.activLoading = 2;
							var data = scope.hasRenewIdMachPswdStatus.data;
							scope.model.setCurrGlobalDefaultValues('syra_idMachPswd', data.syra_idMachPswd);
							scope.model.setCurrGlobalDefaultValues('syra_idMachPswdDate', data.syra_idMachPswdDate);
						} else {
							scope.activLoading = 0;	// le contenu message de hasGenericIdMachStatus sera affiché. 
						}
						if (angular.isDefined(scope.Timer)) {
							$interval.cancel(scope.Timer);
						}
					}
				});
		
		$scope.$watch(
				function (scope) {
					return scope.hasUpdateFichierStatus.code;
				},
				function(newVal, oldVal, scope) {
					if (angular.isDefined(scope.hasUpdateFichierStatus.severity) && scope.dataLoading==2) {	// ce watch est slm pour la réponse à update
						if (scope.hasUpdateFichierStatus.severity=='OK') {
							scope.getFichiersVersions();
						} else {
							scope.dataLoading = 0;
						}
						if (angular.isDefined(scope.Timer)) {
							$interval.cancel(scope.Timer);
						}
					}
				});

		$scope.$watch(
				function(scope) {
					return scope.model.b2bGetInscrUpdated().val;
				},
				function(newVal, oldVal, scope) {
					if (newVal>oldVal) {
						scope.getInscrLoading = 1;
					}
				}
			);
		$scope.$watch(
				function(scope) {
					return scope.model.b2bGetInscrEndUpdated().val;
				},
				function(newVal, oldVal, scope) {
					if (newVal>oldVal) {
						scope.getInscrLoading = 2;
					}
				}
		);
		
		$scope.gridProfOptions = {
				data:$scope.profData,
				virtualizationThreshold: 50,	// defaut 20
				excessRows: 20,
				multiSelect: false,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				enableColumnResizing: false,
				enableCellEditOnFocus: true,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: false,
				appScopeProvider: that,
				columnDefs: [
					{field: 'name', displayName: 'Professionnel', enableCellEdit: false, width: '40%', cellTooltip: false},
					{field: 'gmf', displayName: "Établ.", enableHiding: false, cellClass:$scope.etablStatus, enableCellEdit: true, width: '30%', cellTooltip:true, 
						editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=17 pattern=\"(^$)|([0-9]{5}(?:[, ][0-9]{5}){0,2})\" />"},
					{field: 'inscrit', displayName: "Nombre d'inscriptions", enableCellEdit: true, width: '30%', cellTooltip:false,
						editableCellTemplate: 'ui-grid/dropdownEditor',
					      cellFilter: 'mapInscrits', editDropdownValueLabel: 'label', editDropdownOptionsArray: $scope.inscrits}
			 ],
			 onRegisterApi: function(gridApi){
				 $scope.gridProfApi = gridApi;
				gridApi.cellNav.on.navigate($scope,function(newRowCol, oldRowCol){
					$scope.gridProfApi.selection.selectRow(newRowCol.row.entity);
				});	        
			     gridApi.edit.on.afterCellEdit($scope, function(rowEntity, colDef, newValue, oldValue) {
		    	   $timeout(function() {
	            	   if(colDef.field=='inscrit' && oldValue != rowEntity.inscrit){
	            		   $scope.changeProfAutres(rowEntity.id, 'inscrit', rowEntity.inscrit);
	            	   }
	            	   if(colDef.field=='gmf' && oldValue != rowEntity.gmf){
		            	   $scope.changeProfAutres(rowEntity.id, 'gmf', rowEntity.gmf);
		            	}
	               }, 500);
		       });
			}
		};
		
		$scope.gridProfGmfAutoCxOptions = {
			data:$scope.profGmfAutoCtxData,
			virtualizationThreshold: vthresh,
			scrollThreshold:scrollt,
			wheelScrollThrottle:wheelst,
			excessRows:exRows,
			multiSelect: false,
			enableRowSelection: true,
			enableRowHeaderSelection: false,
			enableColumnResizing: false,
			enableFiltering: true,
			enableSorting: true,
			saveScroll: false,
			enableHiding: false,
			enableGridMenu: false,
			appScopeProvider: that,
			columnDefs: [
				{field: 'name', displayName: 'Professionnel', enableCellEdit: false, width: '50%', cellTooltip: true},
				{field: 'autoCx', displayName: "Auto Contexte(s)", enableCellEdit: false, width: '50%', cellTooltip:true}
			 ],
			 onRegisterApi: function(gridApi){
				if (!$scope.gridProfGmfAutoCxApi) {
					 $scope.gridProfGmfAutoCxApi = gridApi;
					gridApi.cellNav.on.navigate($scope,function(newRowCol, oldRowCol){
						$scope.gridProfGmfAutoCxApi.selection.selectRow(newRowCol.row.entity);
					});	        
				     gridApi.edit.on.afterCellEdit($scope, function(rowEntity, colDef, newValue, oldValue) {
			    	 $timeout(function() {
			    		 //$log.log("colDef=" + colDef +"oldValue=" + oldValue + ", newValue=" + rowEntity.gmf)
		            	 if(colDef.field=='gmf' && oldValue != rowEntity.gmf){
		            	   $scope.changeProfAutres(rowEntity.id, 'gmf', rowEntity.gmf);
		            	 }
		               }, 500);
			       });
			       gridApi.selection.on.rowSelectionChanged($scope,function(row){
			    	   $scope.profAutoCxData = row.entity.cx;
			    	   $scope.gridProfAutoCxOptions.data = $scope.profAutoCxData;
			    	   $scope.gridProfAutoCxApi.grid.modifyRows($scope.gridProfAutoCxOptions.data);
				   });
				}
			}
		};
		
		
		$scope.gridProfAutoCxOptions = {
				data:$scope.profAutoCxData,
				virtualizationThreshold: 200,	// defaut 20
				excessRows: 20,
				multiSelect: false,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				enableColumnResizing: false,
				enableCellEditOnFocus: true,
				enableFiltering: false,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: false,
				appScopeProvider: that,
				columnDefs: [
					{field: 'etab', displayName: 'Établ.', enableCellEdit: true, width: '30%', cellTooltip: false,
						editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=5 pattern=\"(^$)|([0-9]{5})\" />"},
					{field: 'sect', displayName: "Sect.", enableCellEdit: true, width: '20%', cellTooltip:false,
						editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=2 pattern=\"(^$)|([0-9]{2})\" />"},
					{field: 'cx', displayName: "Contexte(s)", enableCellEdit: true, width: '40%',  cellTooltip:true, placeholder:'ex. 70 150', 
							editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=20 pattern=\"(^$)|([0-9\ \,\-]{2,20})\" />"},
					 { name: 'index', enableCellEdit: false, cellTemplate: '<div class="grid-action-cell">'+
						 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteProfAutoCx(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', enableHiding: false, enableFiltering:false, enableColumnMenu:false, width: "24"}
			 ],
			 onRegisterApi: function(gridApi){
				if (!$scope.gridProfAutoCxApi) {
					 $scope.gridProfAutoCxApi = gridApi;
					 gridApi.cellNav.on.navigate($scope,function(newRowCol, oldRowCol){
						$scope.gridProfAutoCxApi.selection.selectRow(newRowCol.row.entity);
					 });	        
				     gridApi.edit.on.afterCellEdit($scope, function(rowEntity, colDef, newValue, oldValue) {
			    	   $timeout(function() {
//		            	   $log.log("colDef=" + colDef +"oldValue=" + oldValue + ", newValue=" + rowEntity.gmf)
		            	   // 3 colonnes: code lieu, code secteur, contextes (liste)
		            	   // vérifier si valeur de colonne a changé. Si oui, appeler changeAutoCx
		            	   var hasChanged = (colDef.field=='etab' &&  oldValue != rowEntity.etab) || (colDef.field=='sect' &&  oldValue != rowEntity.sect) || (colDef.field=='cx' &&  oldValue != rowEntity.cx);
		            	   if(hasChanged){
		            		   var selectedRow = $scope.gridProfGmfAutoCxApi.selection.getSelectedRows()[0];	// only one selected row
		            		   var newVal = '';	// il faut concaténer tout ça.
		            		   for (var d in $scope.profAutoCxData) {
		            			   var actAutoCx = $scope.profAutoCxData[d];
		            			   newVal += actAutoCx.etab + (helpers.isNotEmpty(actAutoCx.sect) ? '-' + actAutoCx.sect : '') +":" + actAutoCx.cx.replace(',',' ').replace('-',' ').replace('  ',' ') + ';';
		            		   }
		            		   newVal = newVal.slice(0, -1);
		            		   selectedRow.autoCx = newVal;
		            		   $scope.changeProfAutres(selectedRow.id, 'autoCx', newVal);
		            	   }
		               }, 500);
			       });
				}
			}
		};
		
		$scope.addNewProfAutoCx = function() {
			var cx = { etab: '', sect: '', cx:' ' };
			$scope.profAutoCxData.push(cx);
			//$scope.gridProfGmfAutoCxApi.selection.getSelectedRows()[0].cx.push(cx);
		};
		
		that.deleteProfAutoCx = function(row) {
			$scope.gridProfAutoCxApi.core.setRowInvisible(row);
			helpers.remove(row.entity, $scope.profAutoCxData);
 		   var selectedRow = $scope.gridProfGmfAutoCxApi.selection.getSelectedRows()[0];	// only one selected row
		   var newVal = '';	// il faut concaténer tout ça.
		   for (var d in $scope.profAutoCxData) {
			   var actAutoCx = $scope.profAutoCxData[d];
			   newVal += actAutoCx.etab + (helpers.isNotEmpty(actAutoCx.sect) ? '-' + actAutoCx.sect : '') +":" + actAutoCx.cx + ';';
		   }
		   newVal = newVal.slice(0, -1);
		   selectedRow.autoCx = newVal;
		   $scope.changeProfAutres(selectedRow.id, 'autoCx', newVal);
		};
		
		$scope.activeNoEtabl = '____';
		
		$scope.gridIdInscrOptions = {
				data:$scope.idInscrData,
				excessRows: 20,
				multiSelect: false,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				enableColumnResizing: false,
				enableCellEditOnFocus: true,
				enableFiltering: false,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: false,
				appScopeProvider: that,
				columnDefs: [
					{field: 'noEtabl', displayName: 'Établ', enableHiding: false, enableCellEdit: true, width: '11%', cellTooltip: true,
						editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=5 pattern=\"(^$)|([0-9]{5})\" />"},
					{field: 'noGmf', displayName: "GMF", enableHiding: false, enableCellEdit: true, width: '11%', cellTooltip:true,
						editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=5 pattern=\"(^$)|([0-9]{4,5})\" />"},
					{field: 'idUser', displayName: "ID util.", enableHiding: false, enableCellEdit: true, width: '15%',  cellTooltip:true, placeholder:'IP99999', 
						editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=10 />"},
					{field: 'idMach', displayName: "ID machine", enableHiding: false, enableCellEdit: true, width: '15%',  cellTooltip:true, placeholder:'IP99999', 
							editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=10 />"},
					{field: 'pswd', displayName: "Mot passe", enableHiding: false, enableCellEdit: true, width: '17%', cellTooltip:true,
						editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=12 />"},
					{field: 'dateModPswd', displayName: "Date mod. MP", enableHiding: false, enableCellEdit: true, width: '15%', cellTooltip:true,
							editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=10 pattern=\"^(20[1-2][0-9])\-(0?[1-9]|1[012])\-(0?[1-9]|[12][0-9]|3[01])$\" />"},
					{ name: 'index2', enableCellEdit: false, cellTooltip:true, 
						cellTemplate: '<div class="ui-grid-cell-contents" ng-switch="row.entity.prg"> ' +
						'<div ng-switch-when="1" style="color: black;" class="fa fa-circle-o-notch fa-spin-infodata fa-fw"></div> '+
						'<div ng-switch-when="2" style="color: green;" class="fa fa-check-circle fa-fw" aria-hidden="true"></div>' +
						'<div ng-switch-when="3" style="color: red;" class="fa fa-exclamation-triangle fa-fw" aria-hidden="true" title={{row.entity.msg}}></div></div>',
						displayName: '', enableHiding: false, enableFiltering:false, enableColumnMenu:false, width: "30"},
					{ name: 'index3', enableCellEdit: false,
						 cellTemplate: '<div data-ng-if="grid.appScope.canRenewPswd(row.entity)"><button class="glyphicon glyphicon-cloud-download" title="Demander un nouveau mot de passe" ng-click="grid.appScope.askNewPswdIdInscr(row);" ></button></div>', displayName: '', enableHiding: false, enableFiltering:false, enableColumnMenu:false, width: "35"},
					{ name: 'index1', enableCellEdit: false, cellTemplate: '<div class="grid-action-cell">'+
					 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteIdInscr(row);' data-confirm=\"Veuillez confirmer l'effacement de cette ligne. Notez que cette action est irréversible.\" data-confirm-title='Demande de confirmation' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', enableHiding: false, enableFiltering:false, enableColumnMenu:false, width: "24"}
			 ],
			 onRegisterApi: function(gridApi){
				if (!$scope.gridIdInscrApi) {
					 $scope.gridIdInscrApi = gridApi;
					gridApi.cellNav.on.navigate($scope,function(newRowCol, oldRowCol){
						$scope.gridIdInscrApi.selection.selectRow(newRowCol.row.entity);
					});	        
				     gridApi.selection.on.rowSelectionChanged($scope,function(row){
				    	 if ($scope.activeNoEtabl != row.entity.noEtabl) {
				    		 $scope.activeNoEtabl = row.entity.noEtabl;
				    		 $scope.gridProfEtabInscrApi.grid.notifyDataChange(uiGridConstants.dataChange.ALL);				    		 
				    	 }
					 });
				     gridApi.edit.on.afterCellEdit($scope, function(rowEntity, colDef, newValue, oldValue) {
			    	   $timeout(function() {
		            	   // 3 colonnes: code lieu, code secteur, contextes (liste)
		            	   // vérifier si valeur de colonne a changé. Si oui, appeler changeGmf
		            	   var hasChanged = (colDef.field=='noEtabl' &&  oldValue != rowEntity.noEtabl) || 
		            	   					(colDef.field=='noGmf' &&  oldValue != rowEntity.noGmf) || 
		            	   					(colDef.field=='idUser' &&  oldValue != rowEntity.idUser) ||
		            	   					(colDef.field=='idMach' &&  oldValue != rowEntity.idMach) ||
		            	   					(colDef.field=='dateModPswd' &&  oldValue != rowEntity.dateModPswd) ||
		            	   					(colDef.field=='pswd' &&  oldValue != rowEntity.pswd)
		            	   					;
		            	   if(hasChanged){
//		            		   $log.log("colDef=" + colDef.field +", oldValue=" + oldValue + ", newValue=" + newValue);
			           			that.model.httpPost("/syra/gmfs/post", JSON.stringify(rowEntity), null, function(v) {
//			        				that.model.currentDemForListe().prg = 0;
//			        				that.model.currentDemForListe().sr = 0;
//			        				that.model.currentDemForListe().dt = 3;
//			        				that.model.currentDemForListe().ready = true;
//			        				delete that.model.currentDemForListe().em;
//			        				$timeout(function(){that.model.demListeItemUpdated().val++;},1);
			        			});		            		   
		            	   }
		               }, 500);
			       });
				}
			}
		};

		$scope.etablStatus = function(grid, row, col, rowRenderIndex, colRenderIndex) {
			if (angular.isUndefined(row.entity)) return "";
			if (row.entity.etab && row.entity.etab.indexOf($scope.activeNoEtabl)>-1) {
				return 'hasEtabl';
			}
			return '';
		};
				
		$scope.gridProfEtabInscrOptions = {
				data:$scope.profEtabInscrData,
				virtualizationThreshold: vthresh,
				scrollThreshold:scrollt,
				wheelScrollThrottle:wheelst,
				excessRows:exRows,
				multiSelect: false,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				enableColumnResizing: false,
				enableCellEditOnFocus: true,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableGridMenu: false,
				appScopeProvider: that,
				columnDefs: [
					{field: 'name', displayName: 'Professionnel', enableHiding: false, cellClass:$scope.etablStatus, enableCellEdit: false, width: '65%', cellTooltip: true},
					{field: 'etab', displayName: "Établ.", enableHiding: false, cellClass:$scope.etablStatus, enableCellEdit: true, width: '35%', cellTooltip:true, 
						editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=17 pattern=\"(^$)|([0-9]{5}(?:[, ][0-9]{5}){0,2})\" />"}
				 ],
				 onRegisterApi: function(gridApi){
					if (!$scope.gridProfEtabInscrApi) {
						 $scope.gridProfEtabInscrApi = gridApi;
						 gridApi.cellNav.on.navigate($scope,function(newRowCol, oldRowCol){
								$scope.gridProfEtabInscrApi.selection.selectRow(newRowCol.row.entity);
							 });	        
					     gridApi.edit.on.afterCellEdit($scope, function(rowEntity, colDef, newValue, oldValue) {
				    	 $timeout(function() {
				    		 //$log.log("colDef=" + colDef +"oldValue=" + oldValue + ", newValue=" + rowEntity.gmf)
			            	 if(colDef.field=='etab' && oldValue != rowEntity.etab){
			            	   $scope.changeProfAutres(rowEntity.id, 'etab', rowEntity.etab);
			            	 }
			               }, 500);
				       });
					}
				}
			};
					
		$scope.addNewIdInscr = function() {
			$http({
				method : "GET",
				url : "/syra/gmfs/getNew?u="+ clientUid
			}).then(function mySucces(response) {
				var res = response.data;
				if (angular.isDefined(res.severity)) {
					// donc un status.
					if ("OK"==res.severity) {
						$scope.idInscrData.push(res.data);
					} else if ("ERROR"==res.severity) {
						jNotice(res.message, 'red');
					} else if ("INFO"==res.severity) {
						jNotice("info", 'green');
					}
				}
			}, function myError(response) {
			});
		};
		that.askNewPswdIdInscr = function(row) {
			if (that.canRenewPswd(row.entity)) {
				that.model.httpPost("/syra/b2b_updatePassword/post", JSON.stringify(row.entity), null, function(response) {
					var res = response.data;
					if (res && angular.isDefined(res.severity)) {
						if (res.severity=='ERROR') {
							jNotice(res.message, 'red');
						}
					}
    			});
			} else {
				jNotice("Données incomplètes. Le renouvellement du mot de passe n'est pas possible dans ces circonstances.", "yellow");
			}
		};
		that.deleteIdInscr = function(row) {
			$scope.gridIdInscrApi.core.setRowInvisible(row);
			helpers.remove(row.entity, $scope.idInscrData);
   			that.model.httpPost("/syra/gmfs_del/post", JSON.stringify(row.entity), null, null);
		};
		that.canRenewPswd = function(entity) {
			return helpers.isNotEmpty(entity.id) && helpers.isNotEmpty(entity.idMach) && helpers.isNotEmpty(entity.pswd);
		};
		$scope.$watch(
				function(scope) {
					return scope.model.idInscrUpdated().val;
				},
				function(newVal, oldVal, scope) {
					if (newVal>oldVal && scope.model.idInscrUpdated().rec && scope.model.idInscrUpdated().rec.length===3) {
						var rec = scope.model.idInscrUpdated().rec;
						if (rec[0]) {
							for (var i=0; i<$scope.idInscrData.length; i++) {
								if ($scope.idInscrData[i].tag==rec[0]) {
									$scope.idInscrData[i][rec[1]]=rec[2];
									break;
								}
							}			
						}
						// delete scope.model.idInscrUpdated().rec;
					}
				}
			);
		
		$scope.openLocal("false");
		$scope.openExternal("false");
	
		function startInterval(timeSec) {
			if (angular.isDefined($scope.Timer)) {
	            $interval.cancel($scope.Timer);
	        }
			$scope.Timer = $interval(function () {
				//juste ça force un digest toutes les 2 sec., max 4 min
	        }, 2000, timeSec/2);
		}
		
		function jNotice(msg, color){
			new jBox('Notice', {
				color : color,
			    content: msg
			});
		}		
	}]);
	
	app.filter('mapInscrits', function() {
		  var genderHash = {
				    1: 'Sans objet',
				    2: 'Moins de 500 patients',
				    3: '500 patients ou plus'
				  };
				 
				  return function(input) {
				    if (!input){
				      return '';
				    } else {
				      return genderHash[input];
				    }
				  };
				});		

	app.filter('typModif', function() {
		return function(input, scope) {
			if (angular.isUndefined(input) || input=='' || input==null) {
				return ':';
			} else if (input===1){
				return "|";
			} else if (input===2){
				return "+";
			} else if (input===4){
				return "-";
			} else if (input>4){
				return 'M';
			} else {
				return '.';
			}
		};
	});

	
})();