var DynaDate = {};
(function(){
	DynaDate = function(userConfig){
		var that = this;
		this.baseElement = wasDeclared(userConfig.elem) ? typeof userConfig.elem === "string" ? $("#"+userConfig.elem) : userConfig.elem : null ;
		this.format = wasDeclared(userConfig.format) ? userConfig.format  : 'YYYY-MM-DD' ;
		this.locale =  wasDeclared(userConfig.locale) ? userConfig.locale  : 'fr' ;
		this.acceptFutureDate = wasDeclared(userConfig.acceptFutureDate) ? userConfig.acceptFutureDate  : false ;
		this.useCurrent = wasDeclared(userConfig.useCurrent) ? userConfig.useCurrent  : true ;
		this.defaultDate = wasDeclared(userConfig.defaultDate) ? userConfig.defaultDate  : null ;
		this.minDateElm = wasDeclared(userConfig.minDateElm) ? $("#"+userConfig.minDateElm)  : null ;
		this.maxDateElm = wasDeclared(userConfig.maxDateElm) ? $("#"+userConfig.maxDateElm)  : null ;
		this.dateDefault = wasDeclared(userConfig.maxDateElm) ? $("#"+userConfig.maxDateElm)  : null ;
		wasDeclared(userConfig.onDateBlur) ? this.onDateBlur = userConfig.onDateBlur :"" ;

		this.onDateInvalid = function(){if (!window.console) console.error = "Invalid date: either the date is in the future or the format is invalid."};
			new Error("An input id must be declared to bind with Dynamic date widget, no element was declared") ;
//		this.keyHandlers = wasDeclared(userConfig.keyHandlers) ? userConfig.keyHandlers  : [{keys: [], handle: function(){}}]; //Extra key functionality (onhold)
		this.currDate = new Date();
		this.getDefault = wasDeclared(userConfig.getDefault)? userConfig.getDefault : function(){};
		this.onDateSelected = function(selectedDate){};
		this.setEditMode = wasDeclared(userConfig.setEditMode)? userConfig.setEditMode : function(v){};

		// prévoir une manière de switcher la langue... éventuellement
		var tooltips = [{
		    today: 'Go to today',
		    clear: 'Clear selection',
		    close: 'Close the picker',
		    selectMonth: 'Select Month',
		    prevMonth: 'Previous Month',
		    nextMonth: 'Next Month',
		    selectYear: 'Select Year',
		    prevYear: 'Previous Year',
		    nextYear: 'Next Year',
		    selectDecade: 'Select Decade',
		    prevDecade: 'Previous Decade',
		    nextDecade: 'Next Decade',
		    prevCentury: 'Previous Century',
		    nextCentury: 'Next Century'
		}, {
       	    today: "Aujourd'hui",
       	    clear: "Effacer",
       	    close: 'Fermer',
       	    selectMonth: 'Sélection du mois',
       	    prevMonth: 'Mois précédent',
       	    nextMonth: 'Mois suivant',
       	    selectYear: "Sélection de l'année",
       	    prevYear: 'Année précédente',
       	    nextYear: 'Année suivante',
       	    selectDecade: 'Sélection de la décade',
       	    prevDecade: 'Décade précédente',
       	    nextDecade: 'Décade suivante',
       	    prevCentury: 'Siècle précédent',
       	    nextCentury: 'Siècle suivant'
       	}];
		
		that.baseElement.datetimepicker({
           	format: that.format, locale:that.locale, useCurrent: that.useCurrent,
           	showTodayButton: true, showClear: true,
           	maxDate: (that.acceptFutureDate ? false : moment().endOf("day").toDate()),
           	focusOnShow:true,
           	tooltips: tooltips[1]
        });
		that.baseElement.on('dp.change', function (ev) {
			that.onDateSelected(ev.date);
		});
		that.baseElement.on('show', function (ev) {
			that.setEditMode(true);
		});
		that.baseElement.on('hide', function (ev) {
			that.setEditMode(false);
		});
		if(wasDeclared(userConfig.onDateBlur)){
			that.baseElement.on('blur', function (ev) {
				that.onDateBlur(that.currDate);
			});
		}
		if (that.maxDateElm) {
			that.maxDateElm.on("dp.change", function (e) {
	            that.baseElement.data("DateTimePicker").maxDate(e.date);
	        });
		}
		if (that.minDateElm) {
			that.minDateElm.on("dp.change", function (e) {
				that.baseElement.data("DateTimePicker").minDate(e.date);
			});
		}
		this.setDefaultDate = function(dd) {
			that.baseElement.data("DateTimePicker").defaultDate(dd);
		};
		
		function wasDeclared(configEntry){
			return typeof configEntry !== 'undefined';
		}
		
		this.today = function(){
			return new Date();
		};
		
		this.plusDay = function(day){
			return moment(that.currDate).add(moment.duration(day, 'days'));
		};
		this.plusHour = function(day){
			return moment(that.currDate).add(moment.duration(day, 'days'));
		};
		
		this.plusWeek = function(week){
			return moment(that.currDate).add(moment.duration(week, 'weeks'));
		};
		
		this.plusMonth = function(months){
			return moment(that.currDate).add(moment.duration(months, 'months'));
		};
		
		this.startMonth = function(){
			return moment(that.currDate).startOf('months');
		};
		
		this.endMonth = function(){
			return moment(that.currDate).endOf('months');
		};
		
		$(this.baseElement).keydown(function(e){handleKeyEvent(e)});
		$(this.baseElement).keypress(function(e){handleKeyEvent(e)});
		
		function handleKeyEvent(e){
			if (e.altKey || e.ctrlKey) {
				return;
			}
			updateCurrIfNecessary();
			var newDate = {};
			if(e.which >= 65 && e.which <= 90 ){
				if (e.which == 84 ) {//(t)today
					newDate = that.today();
				}else if(e.which == 68){//(d) default day
					newDate = that.getDefault();
				}else if(e.which == 88){//(x) plus one day
					newDate = that.plusDay(1);
				}else if(e.which == 90){//(z) minus one day
					newDate = that.plusDay(-1);
				}else if(e.which == 83){//(s) plus one week
					newDate = that.plusWeek(1);
				}else if(e.which == 65){//(a) minus one week
					newDate = that.plusWeek(-1);
				}else if(e.which == 87){//(w) plus one month
					newDate = that.plusMonth(1);
				}else if(e.which == 81){//(q) minus one month
					newDate = that.plusMonth(-1);
				}else if(e.which == 77){//(m) start of Month
					newDate = that.startMonth();
				}else if(e.which == 72){//(h) end of montH
					newDate = that.endMonth();
				}else if(e.which == 73){//(i) idem date liée
					if(that.minDateElm){
						newDate = $(that.minDateElm.selector).val();
					}
				}else{
//					print = false;
					eventHandled(e);
					return;	// sinon, toutes les lettres mettent today!
				}
				if(newDateValid(newDate)){
					eventHandled(e);
					that.currDate = newDate;
					that.printDate();
//					that.onDateSelected(that.currDate);	// mis dans le dp.change ci-haut - ligne 63
				}else{
					eventHandled(e);
					that.onDateInvalid();
				}
			}else if(e.which == 9){//Complete partial dates if they are entered
				var partDate = $(that.baseElement).val();
				var nDate = partialDate(partDate);
				if(!$.isEmptyObject(nDate) && newDateValid(nDate)){
					that.currDate = nDate;
					that.printDate();
					that.onDateSelected(that.currDate);
				}
			}
		}
		
		//Get full date from a partial date: Works only with numbers with a length of less than 7
		//If user enters 12 the output date will be 12th date of the current month and year
		//If the user enters 814 the output date will be the August 14 of the current year
		//If the user enters 120812 the output date will be 2012-08-12
		function partialDate(input){
			input = input.trim();
			if($.isEmptyObject(input) || input.length > 7)return;
			
			if(input.length < 3){
				var mDate = parseInt(input);
				if(mDate < 32){
					return moment().date(mDate);
				}
			}else if(input.length < 5){
				var mDate = parseInt(input.substring(input.length-2,input.length))
				var yMonth = parseInt(input.substring(input.length-2, 0));
				var nD = moment();
				nD.date(mDate);
				nD.month(yMonth-1);
				return nD;
			}else if(input.length < 7){
				var mDate = parseInt(input.substring(input.length-2,input.length))
				var yMonth = parseInt(input.substring(input.length-2, input.length-4));
				var year = parseInt(input.substring(input.length-4, 0));
				var nD = moment();
				nD.date(mDate);
				var cHYear = nD.year() % 100;
				var centYear = Math.floor(nD.year() / 100) * 100;
				if(year > cHYear) year = (centYear - 100) + year;
				else year = centYear + year;
				nD.month(yMonth - 1);
				nD.year(year);
				return nD;
			}
		}
		
		function updateCurrIfNecessary(){
			var temp = $(that.baseElement).val().replace(/\D/g,'');
			var format = "YYYY-MM-DD";
			var iLen = temp.length;
			var inputString;
			if (iLen>=8) {
				inputString = temp.substr(0,4) + '-' + temp.substr(4,2) + '-' + temp.substr(6,2);
				if (iLen>8) {
					temp = temp.substr(8);
					iLen = temp.length;
					if (iLen<4) {
						temp = temp + '0000'.substr(4-iLen);
					}
					inputString = inputString + 'T' + temp.substr(0, 2) +":" + temp.substr(2,2);
					format = "YYYY-MM-DD hh:mm";
 				}
				if (angular.isDefined(inputString)) {
					var inputDate = moment(inputString, format);
					if(inputDate.isValid() && moment(that.currDate).isValid() && moment(inputDate).diff(that.currDate, 'days') != 0){
						that.currDate = inputDate;
					}
				}
			}else if(iLen === 0){
				//reset the date to default if a default is declared or to today.
				var def = that.getDefault();
				that.currDate = moment(def).isValid() ? def: new Date();
			}
		}
		
		function newDateValid(newdate){
			var newDateValue = moment(newdate);
			if(!newDateValue.isValid()){
				return false;
			}else if(!that.acceptFutureDate && newDateValue.isAfter(moment(), 'day')){
				return false;
			}
			var minmax = true;
			if(that.maxDateElm ){
				var afterDate = $(that.maxDateElm.selector).val();
				if(!$.isEmptyObject(afterDate)){
					if(moment(afterDate, that.format).isBefore(newDateValue, 'minute'))return false;
				}
			}
			if(that.minDateElm){
				var beforeDate = $(that.minDateElm.selector).val();
				if(!$.isEmptyObject(beforeDate)){
					if(moment(beforeDate, that.format).isAfter(newDateValue, 'minute')) return false;
				}
			}
			return true;
		}
		
//		function handleExtraKeyEvent(e){ //Extra key functionnality (onhold)
//			for (var i = 0; i < this.keyHandlers; i++) {
//				var valid
//			   
//			}
//		}
		
		this.printDate = function(){
			that.baseElement.data("DateTimePicker").date(moment(that.currDate));
			$(that.baseElement).val(moment(that.currDate).format(that.format));			
		}
		
		function eventHandled(e){
			e.preventDefault();
			e.stopPropagation();
			e.stopImmediatePropagation();
		}
	};
})();