//Dynamic assistant widget
var AssistDynaText = {};

(function(){
	var isCtrl = false;
	var listAssist = new Array();
	
	var currentAssist = null;
	
	AssistDynaText = function AssistDynaText(userConfig) {
		var dxA = this;
		//Default Configs
		this.config = {};
		this.config.asyncLoading = wasDeclared(userConfig.asyncLoading) ? userConfig.asyncLoading  : true ;
		this.config.angular = wasDeclared(userConfig.angular) ? userConfig.angular : false;
		this.config.minChar =  wasDeclared(userConfig.minChar) ? userConfig.minChar  : 1 ;
		this.config.nextTabOnTab =  wasDeclared(userConfig.nextTabOnTab) ? userConfig.nextTabOnTab  : false ;
		this.config.nextTabOnEnter =  wasDeclared(userConfig.nextTabOnEnter) ? userConfig.nextTabOnEnter  : false ;
		this.config.hasHeader =  wasDeclared(userConfig.hasHeader) ? userConfig.hasHeader  : true ;
		this.config.alwaysShowHeader =  wasDeclared(userConfig.alwaysShowHeader) ? userConfig.alwaysShowHeader  : false ;
		this.config.actions =  wasDeclared(userConfig.actions) ? userConfig.actions  : [] ;
		this.config.hasDetails =  wasDeclared(userConfig.hasDetails) ? userConfig.hasDetails : true ;
		this.config.listWidth =  wasDeclared(userConfig.listWidth) ? userConfig.listWidth  : 350 ;
		this.config.descWidth =  wasDeclared(userConfig.descWidth) ? userConfig.descWidth  : 300 ;
		this.config.helpText =  wasDeclared(userConfig.headerText) ? userConfig.headerText  : 
			"'ESC' pour fermer, \u2191 et \u2193 pour déplacer, 'ENTRER' pour sélectionner." ;
		this.config.helpHtml =  wasDeclared(userConfig.headerHtml) ? userConfig.headerHtml  : 
			null ;
		this.config.assistId =  wasDeclared(userConfig.assistId) ? userConfig.assistId  : "";
		//Triggers the show of the assistant. Possible options are : 
		//'res' => Default value to only show if there are results to show.
		//'focus' => Show assistant ass soon as the user enters the control
		this.trigger = wasDeclared(userConfig.trigger) ? userConfig.trigger  : 'res' ;

		dxA.selectionMade = false;
		this.onItemSelected = wasDeclared(userConfig.onItemSelected) ? userConfig.onItemSelected  : function(itemSelected){};
		this.updateDataSourceWithValues = wasDeclared(userConfig.updateDataSourceWithValues) ? userConfig.updateDataSourceWithValues  : function(v){};
		
		function wasDeclared(configEntry){
			return typeof configEntry !== 'undefined';
		}
		this.baseElement = wasDeclared(userConfig.elem) ? typeof userConfig.elem === "string" ? $("#"+userConfig.elem).get(0) : userConfig.elem : 
			new Error("An input id must be declared to bind with Dynamic assist widget, no element was declared");
		if (!$(this.baseElement)[0]) return;
//		this.baseElement = wasDeclared(userConfig.elem) ? $("#"+userConfig.elem).get(0)  : 
//			new Error("An input id must be declared to bind with Dynamic assist widget, no element was declared") ;
		
		var attr = $(this.baseElement).attr('assistId');
		
		if ((typeof attr === typeof undefined || attr === false) && this.config.assistId) {
			$(this.baseElement).attr("assistId",this.config.assistId);
			$(this.baseElement).attr("autocomplete","off");
			$(this.baseElement)[0].dxA = dxA;
		}
		this.assistElement = null
		this.search = null;
//		this.isOver = false;
		this.isOpen = false;
		var actionMap = new Map();
//		var multiKeyMap = new Map();
		/*
		Must be defined on the fly :
		var elem : element that we want the description
		return : $ element that can be append to an other element
		 */
		this.getText = wasDeclared(userConfig.getText) ? userConfig.getText  : function(elem){};
		this.getKey = wasDeclared(userConfig.getKey) ? userConfig.getKey  : function(elem){};
		this.getDescription = wasDeclared(userConfig.getDescription) ? userConfig.getDescription  : function(elem){};
		this.getAjaxData = wasDeclared(userConfig.getAjaxData) ? userConfig.getAjaxData  : function(query){};
		
		//Return true to stop default assistant behaviour
		//Allows action after server response. pre-selection or ordering data before display
		this.suggestOnDataLoaded =  wasDeclared(userConfig.suggestOnDataLoaded) ? 
				userConfig.suggestOnDataLoaded  : function(data, query){return true;};
		this.selection = wasDeclared(userConfig.selection) ? 
				userConfig.selection  : function(elem){return this.getKey(elem);};
		
		//getList is a hook to get and return list of items before render (used for sorting, filters or user defined actions) 
		this.getList = wasDeclared(userConfig.getList) ? 
				userConfig.getList  : function(data){	return data;};
		
		this.addAction = function(actionItems){
			var key;
			if(actionItems instanceof Array){
				for(i = 0; i < actionItems.length; i++){
					if(!($.isEmptyObject(actionItems[i].key) && $.isEmptyObject(actionItems[i].callback))){
//#multiKeyMap						key = actionItems[i].altKey ? 'alt+' + actionItems[i].key : actionItems[i].key.charAt(0);
						key = actionItems[i].altKey ? 'alt' + actionItems[i].key : actionItems[i].key.charAt(0);
						actionMap.set(key, actionItems[i].callback);
					}else{
						console.log("A key and a callback is required.");
					}
				}
			}else if (angular.isDefined(actionItems)){
				if(!($.isEmptyObject(actionItems.key) && $.isEmptyObject(actionItems.callback))){
					key = actionItems.altKey ? 'alt' + actionItems.key : actionItems.key.charAt(0);
					actionMap.set(key, actionItems.callback);
				}else{
					console.log("A key and a callback is required.");
				}
			}
		};
		
		dxA.addAction(dxA.config.actions);
		
		dxA.focusIn = function() {
			dxA.resetSearch();
			var v = dxA.updateDataSourceWithValues();
			if (v!=='undefined' && v!=null && v!='') {
				dxA.showHist = true;
				dxA.updateDataSource(v);
			} else {
				dxA.showHist = false;
			}			
		};
		
		$(dxA.baseElement).blur(function() {
			dxA.select();
			if(dxA.isOpen){
				dxA.close();
			}
			dxA.selectionMade = false;
		});
		
		this.entryLocked = false;
		
		this.unlockEntry = function(){
			$(dxA.baseElement).unbind( "keypress.tempLock" );
			$(dxA.baseElement).unbind( "keyup.tempLock" );
			$(dxA.baseElement).unbind( "blur.tempLock" );
			dxA.entryLocked = false;
			dxA.showHist = false;
		};
		
		this.lockEntry = function(){
			dxA.entryLocked = true;
			
			$(dxA.baseElement).bind("blur.tempLock", function(envent){
				dxA.unlockEntry();
			});
			$(dxA.baseElement).bind( "keyup.tempLock", function(event){
				var v = $(dxA.baseElement).val();
				//deactivate lock on 'backspace' '=' '+' 'Enter' 'tab'
				//Check to see if input is empty (means unlock on blur failed)
				if(event.keyCode == 8 || event.keyCode == 172 
					||event.keyCode == 190 ||  event.keyCode == 187 ||
					event.keyCode == 9 || event.keyCode == 13 || v == ""){
					dxA.unlockEntry();
				}
			});
			$(dxA.baseElement).bind( "keypress.tempLock", function(event){
				var v = $(dxA.baseElement).val();
				if(event.keyCode == 8 || event.keycode == 172
						||event.keyCode == 190 ||  event.keyCode == 187  ){
				}else if (v == "") {
					dxA.unlockEntry();
				}else{
					event.preventDefault();
					return;
				}
			} );
		};
		
		function ajaxCall(value){
			if (value.trim().length>0) {
				var ajaxObject = dxA.getAjaxData(value);
				if(ajaxObject){
					if(dxA.config.asyncLoading)dxA.buildInner(true);
					ajaxObject.success = function(data) {
						if(typeof data === "string"){//Prevent undefined when string is received try parsing to json
							try { data = JSON.parse(data); }
							catch(err) { data = []} //Close quietly assume error never happened
						}
						dxA.search.elems = dxA.getList(data);
						if(dxA.suggestOnDataLoaded(data, value)){
							dxA.buildInner();
						}
					}
					
					ajaxObject.error = function(query, status, error) {
					}
					$.ajax(ajaxObject);
				}
			}
		};
		
		function open() {
			dxA.selectionMade = false;
			if (dxA.assistElement == null && dxA.trigger != 'focus') return;
			if(!dxA.isOpen){
				dxA.assistPlacement = 'bottom';
				dxA.isOpen = true;
				setSide();
			}
			dxA.assistElement.children(".assist-main-div").fadeIn(100);
			var ul = dxA.assistElement.children(".assist-main-div").children(".assist-content-div").children(".assist-list-div").children(".assist-list-ul");
			ul.css("overflow","auto");
			ul.css("max-height", 300 + "px");
//			dxA.assistElement[0].scrollIntoView(false);
			
		};
		function setSide(){
			var assistHeight = $(dxA.assistElement.children(".assist-main-div")).outerHeight();
			var bottom = $(dxA.baseElement).offset().top + 335;
			if(bottom > window.innerHeight){
				dxA.assistPlacement = 'top';
				$(dxA.assistElement.children(".assist-main-div")).css("display", "flex");
				$(dxA.assistElement.children(".assist-main-div").children(".assist-content-div")).css("display", "flex").css("float", "right");
				$(dxA.assistElement.children(".assist-main-div")).css("flex-direction", "column-reverse");
			}else{
				dxA.assistPlacement = 'bottom';
				$(dxA.assistElement.children(".assist-main-div")).css("display", "block");
			}
		}
		function placeOnScreen(elem){
			var rect = $(dxA.assistElement.children(".assist-main-div"))[0].getBoundingClientRect();
			var assistHeight = $(dxA.assistElement.children(".assist-main-div")).outerHeight();
			if(dxA.assistPlacement === "top"){
				var nTop = $(dxA.baseElement).offset().top - assistHeight;
				$(elem).offset({top: nTop});
			}else if(dxA.assistPlacement === "bottom"){
				var baseHeight = $(dxA.baseElement).outerHeight();
				var nTop = $(dxA.baseElement).offset().top +baseHeight ;
				$(elem).offset({top: nTop});
			}else if(rect.top > window.innerHeight){
			}
		}
		function getScrollingParent(elem, includeHidden){
			var position = elem.css( "position" ),
				excludeStaticParent = position === "absolute",
				overflowRegex = includeHidden ? /(auto|scroll|hidden)/ : /(auto|scroll)/,
				scrollParent = elem.parents().filter( function() {
					var parent = $( elem );
					if ( excludeStaticParent && parent.css( "position" ) === "static" ) {
						return false;
					}
					return overflowRegex.test( parent.css( "overflow" ) + parent.css( "overflow-y" ) +
						parent.css( "overflow-x" ) );
				} ).eq( 0 );

			return position === "fixed" || !scrollParent.length ?
				$( elem[ 0 ].ownerDocument || document ) :
				scrollParent;
		}
		function isOffScreen(elem){
			var rect = elem.getBoundingClientRect();
		  return (rect.left + rect.width) > window.innerWidth 
		             || (rect.top + 300) > window.innerHeight
		             || (rect.left > window.innerWidth || rect.top > window.innerHeight);
		}
		this.close = function(dontReset) {
			//Make reset as default
			var reset = !(dontReset || false);
			if (dxA.assistElement == null) return;
			dxA.assistElement.children(".assist-main-div").fadeOut(100);
			if (reset) {
				// probleme car reset si on utilise la souri pr le select
				dxA.resetOriginalText();
			}
			this.isOpen = false;
		};
		
		this.closeifpossible = function(dontReset, type){
			if(type === dxA.trigger){
				dxA.close(dontReset);
			}
		}
		
		function getHeader(){
			var helpDiv = $("<div></div>");
			helpDiv.addClass("assist-help-div");
			var divWidth = dxA.config.hasDetails ? dxA.config.listWidth + dxA.config.descWidth
					: dxA.config.listWidth;
			helpDiv.css("width",(divWidth)+"px");
			if(dxA.config.helpHtml){
				helpDiv.html(dxA.config.helpHtml);
			}else{
				helpDiv.text(dxA.config.helpText);
			}
			return helpDiv;
		}
		
		function getListContentBody(){
			var assistListDiv = $("<div></div>");
			var assistListUL = $("<ul></ul>");
			assistListUL.addClass("assist-list-ul");
			assistListDiv.addClass("assist-list-div");
			assistListDiv.css("width",(dxA.config.listWidth-2)+"px");
			assistListDiv.append(assistListUL);
			
			return assistListDiv;
		}
		
		function getDetailsBody(){
			var assistDescDiv = $("<div></div>");
			assistDescDiv.addClass("assist-desc-div");
			assistDescDiv.css("width",(dxA.config.descWidth-2)+"px");
			return assistDescDiv;
		}
		
		var angularCompilation = function() {
            angular.element('body').injector().invoke(function($compile) {
            	var domspace = getassistElement();
                var scope = angular.element(domspace).scope();
                $compile(domspace)(scope);
                scope.$digest();
            });
            return true;
        };
        
        function getassistElement(){
        	//Check if usable
			var e = $(dxA.baseElement);
			if (e.length != 1 || typeof e.attr("assistId") === 'undefined' || e.attr("assistId").length < 1) {
				new Error("An assist id must be declared to bind with Dynamic assist widget, no id was declared");
			}
			return $("#"+e.attr("assistId"));
        }
		this.buildBase = function() {
			this.assistElement = getassistElement();
			if (this.assistElement.length != 1) {
				this.assistElement = null;
				return;
			}
			//On va construire les prémisse asteur
			var assistMainDiv = $("<div></div>");
			var assistContentDiv = $("<div></div>");
			
			//On va rendre l'assistElement comme positionneur
			this.assistElement.children().remove();
			this.assistElement.css("position","relative");
			this.assistElement.css("top","0px");
			this.assistElement.css("left","0px");
			
			//On va ajuster les div
			assistMainDiv.addClass("assist-main-div");
			assistContentDiv.addClass("assist-content-div");
			var detailsLength = this.config.hasDetails ?this.config.descWidth+6: 0;
			assistMainDiv.css("width",(this.config.listWidth+detailsLength)+"px");
			
			//Bind event
			var that = this;
			
			$(this.baseElement).keydown(function(e) {
				var key = e.altKey ? 'alt' + e.which : e.key == undefined ? String.fromCharCode(e.which) : e.key;
				if(actionMap.has(key)){
					actionMap.get(key)();
					eventHandled(e);
					return false;
				} else if (that.isOpen) {
					if (e.which == 40) {
						that.selectNext();
						eventHandled(e);
					} else if (e.which == 38) {
						that.selectPrev();
						eventHandled(e);
					} else if (e.which == 9) {
						// il ne faut pas que le Enter ait d'autres effets (comme activation d'une directive) que celui prévu dans le keyup.
						eventHandled(e);
						if(!dxA.entryLocked){
							that.select();
							dxA.close();
							if (that.config.nextTabOnTab) {
								selectTab.forwardTab(this);
							}								
						}
					} else if (e.which == 13) {
						// il ne faut pas que le Enter ait d'autres effets (comme activation d'une directive) que celui prévu dans le keyup.
						eventHandled(e);
						if(!dxA.entryLocked){
							that.select();
							dxA.close();
							if (that.config.nextTabOnEnter) {
								selectTab.forwardTab(this);
							}								
						}
					}
				}
			});
			
			function eventHandled(e){
				e.preventDefault();
				e.stopPropagation();
			}
			
			$(this.baseElement).focusin(function(e) {
				dxA.focusIn();
			});
			
			$(this.baseElement).keyup(function(e) {
				eventHandled(e)
				if(!dxA.entryLocked){
					var hasVal = MyNamespace.helpers.isNotEmpty(that.baseElement.value);
					if (that.isOpen) {
						if ((e.which == 40 || e.which == 38)) {
							//Ignore up(40) and down ( 38) arrow keys event already handled on keydown
						} else if (e.which == 27) {
							closeAllAssist();
						} else if (hasVal && that.baseElement.value.length >= that.config.minChar && !isHelperKey(e.which)) {
							dxA.updateDataSource();
						} else if (hasVal && that.baseElement.value.length < that.config.minChar) {
							if (!dxA.showHist) {
								closeAllAssist();
							}
						}
					} else {
						if (e.which == 32 && isCtrl) {
							closeAllAssist();
							dxA.updateDataSource();
						}else if (hasVal && that.baseElement.value.length >= that.config.minChar && !isHelperKey(e.which)) {
							dxA.updateDataSource();
						}
					}
				}
			});
			
			var tabbable = ":input[tabindex='0']:not(button):not(select)";	// pour être fonctionnel, il faut tabindex='-1' aux controles qui peuvent avoir le focus (en fait le tab)
//			nextOnEnter: true, dans la definition de l'assistant			
	        var lastFocusedElement = null;
	        dxA.internal = {
	            escapeSelectorName: function(str) {
	                // Based on http://api.jquery.com/category/selectors/
	                // Still untested
	                return str.replace(/(!"#$%&'\(\)\*\+,\.\/:;<=>\?@\[\]^`\{\|\}~)/g, "\\\\$1");
	            },
	            findNextTabbable: function($from, offset) {
	                var $tabbable = $(tabbable)
	                    .not(":disabled")
	                    .not(":hidden")
	                    .not("a[href]:empty");
	                var currentIndex = $tabbable.index($from);
	                var nextIndex = (currentIndex + offset) % $tabbable.length;
	                if (nextIndex <= -1) {
	                    nextIndex = $tabbable.length + nextIndex;
	                }
	                var $next = $tabbable.eq(nextIndex);
	                return $next;
	            },
	            focusInElement: function(event) {
	                lastFocusedElement = event.target;
	            },
	            tryGetElementAsNonEmptyJQueryObject: function(selector) {
	                try {
	                    var $element = $(selector);
	                    if ( !! $element && $element.length !== 0) {
	                        return $element;
	                    }
	                } catch (e) {
	                    // Could not use element. Do nothing.
	                }
	                return null;
	            },
	            getFocusedElement: function() {
	                var $focused = dxA.internal.tryGetElementAsNonEmptyJQueryObject(":focus") || dxA.internal.tryGetElementAsNonEmptyJQueryObject(document.activeElement) || dxA.internal.tryGetElementAsNonEmptyJQueryObject(lastFocusedElement) || $();
	                return $focused;
	            },
	            emulateTabbing: function($from, offset) {
	                var $next = dxA.internal.findNextTabbable($from, offset);
	                $next.focus();
	            },
	            initializeAtLoad: function() {
	                $(document).on("focusin" + eventNamespace, dxA.internal.focusInElement);
	            }
	        };
	        
	        var selectTab = {
	                tab: function($from, offset) {
	                    // Tab from focused element with offset, .tab(-1)
	                    if ($.isNumeric($from)) {
	                        offset = $from;
	                        $from = undefined;
	                    }
	                    $from = $from || selectTab.getFocused();
	                    offset = offset || +1;
	                    dxA.internal.emulateTabbing($from, offset);
	                },
	                forwardTab: function($from) {
	                    return selectTab.tab($from, +1);
	                },
	                reverseTab: function($from) {
	                    return selectTab.tab($from, -1);
	                },
	                getFocused: function() {
	                    return dxA.internal.getFocusedElement();
	                }
	            };
			
// Code causant un bug dans certain champs pour le lock. vu le double appelle de 'select()'
//Commenter pour l'instant peut être enlever eventuellement. 2016-11-11
			
//			$(that.baseElement).blur(function() {
//				if (!that.isOver) {
//					that.select();
//					that.close();
//				}
//			});
//			
//			$(that.assistElement).mouseover(function() {
//				that.isOver = true;
//			}).mouseout(function() {
//				that.isOver = false;
//			});
			
			//finir d'initaliser
			this.resetSearch();
			
			//On va les assembler
			if(this.config.hasHeader)
				assistMainDiv.append(getHeader());
			assistContentDiv.append(getListContentBody());
			if(this.config.hasDetails)
				assistContentDiv.append(getDetailsBody());
			assistMainDiv.append(assistContentDiv);
			
			this.assistElement.append(assistMainDiv);
			if(dxA.config.angular){
				angularCompilation();
			}
			
			//S'enregistrer
			listAssist.push(this);
		};
		
		this.buildInner = function(loading) {
			
			//On va aller voir si on doit faire un ajaxCall
			//console.log(this.search.originalText+"/"+val.indexOf(this.search.originalText)
			var hasElems = !(this.search.elems == null || this.search.elems.length < 1) ;
			if (!hasElems && !loading && dxA.trigger === 'res' && !dxA.config.alwaysShowHeader) {
				this.close();
				return false;
			}
			
			//Gonna creates elements : first : remove all old
			var ul = this.assistElement.children(".assist-main-div").children(".assist-content-div").children(".assist-list-div").children(".assist-list-ul");
			ul.children().remove();
			if(hasElems){
				var count = 0;
				
				for (var i = 0; i < this.search.elems.length; i++) {
					var key = this.getKey(this.search.elems[i]);
					//On construit!
					var li = $("<li></li>");
					if (typeof key == "string") {
						li.html(key);
					} else {
						li.append(key);
					}
					li.attr("ref",i);
					li.addClass("assist-item-"+i);
					li.addClass("assist-item");
					
					//bind event
					var that = this;
					li.mouseover(function() {
						var ind = $(this).attr("ref");
						if (typeof ind != 'undefined' && ind != null) {
							that.assistElement.find(".item-selected").removeClass("item-selected");
							that.selectThisOne(ind);
						}
					});
					li.click(function() {
						that.select();
						if (that.config.nextTabOnEnter) {
							dxA.internal.emulateTabbing(dxA.baseElement, 1);
						}								
					});
					
					ul.append(li);
					count++;
				}
				
				if (count == 0) {
					this.closeifpossible(true, 'res');
					return false;
				} else {
					ul.css("overflow","auto");
					ul.css("max-height",300+"px"); 
				}
				
				this.selectNext();
			}else if(loading){
				var li = $("<div><img src='/syra/Resources/images/icons/loading47.gif' style='height: 2.5em;' alt='Chargement des données'></div>");
				ul.append(li);
			}else{
				var li = $("<div><p>Aucun élément trouvé</p></div>");
				ul.append(li);
			}
			open();
			placeOnScreen(dxA.assistElement[0]);
			return true;
		};
		
		this.updateDataSource = function(v){
			if (arguments.length) {
				dxA.resetSearch();
				ajaxCall(v);
			} else {
				//On va aller chercher la valeur a rechercher
				var val = dxA.baseElement.value;
				if (val.length >= dxA.config.minChar && dxA.search.originalText != val) {
					dxA.resetSearch();
					dxA.search.originalText = val;
					ajaxCall(val);
				}
			}
		};
		
		if(dxA.trigger === 'focus'){
			$(this.baseElement).focus(open);
		}
		
		this.select = function(arg) {
			if(!dxA.selectionMade){
				var elem = null;
				if (typeof arg != 'undefined' && arg != null){
					elem = arg;
				}else{
					var i = this.assistElement.find(".item-selected").attr("ref");
					if (typeof i != 'undefined' && i != null) {
						var e = this.search.elems[i];
						if (typeof e != 'undefined' && e != null) 
							elem = e;
					}
				}
				
				this.closeifpossible(false, 'res');
				if (elem != null) {
					var selectedElem = this.selection(elem);
					dxA.selectionMade = true;
					$(dxA.baseElement).val(selectedElem);
					this.onItemSelected(selectedElem);
				}
			}
		};
		
		function scrollIfNecessary(s){
			var helpDiv = dxA.assistElement.find(".assist-help-div");
			var ul = dxA.assistElement.children(".assist-main-div").children(".assist-content-div").children(".assist-list-div").children(".assist-list-ul");
			var offset = s.position();
			var outerHeight = helpDiv.outerHeight(true);
			var baseHeight =(dxA.assistPlacement === 'top'? 0 :(outerHeight?outerHeight:0));
			if(offset.top < 0 + baseHeight){
				$(ul).scrollTop($(ul).scrollTop() -baseHeight +offset.top)
			}else if(offset.top + s.height()> $(ul)[0]['clientHeight'] + baseHeight){
				var remaining = (offset.top + s.height()) - $(ul)[0]['clientHeight'];
				$(ul).scrollTop( $(ul).scrollTop() - baseHeight+ remaining);
			}
		}
		
		this.selectThisOne = function(index) {
			var s = this.assistElement.find(".assist-item-"+index);
			
//			$("#log").text($(ul)[0]['clientHeight'] + " : " + $(ul).height() + " : " + s.height() + " : " + this.search.elems.length + " : " + offset.top + " : " + ul[0].scrollHeight + " : " + ($(ul).scrollTop()- helpDiv.outerHeight(true)));
			scrollIfNecessary(s);
			
			s.addClass("item-selected");
			var e = this.search.elems[index];
			var desc = null;
			if (typeof e != 'undefined' && e != null) {
				desc = this.getDescription(e);
			}
			this.assistElement.find(".assist-desc-div").children().remove();
			if (typeof desc != 'undefined' && desc != null) {
				if( typeof desc == "string"){
					var pres = $("<div></div>");
					pres.addClass("pres-name");
					pres.html(desc)
					desc = pres;
				}
				this.assistElement.find(".assist-desc-div").append(desc).show();
			} else {
				this.assistElement.find(".assist-desc-div").text("").hide();
			}
		};
		this.elementHeight;
		this.selectNext = function() {
			var s = this.assistElement.find(".item-selected").removeClass("item-selected");
			var i = 0;
			if (s.length > 0) {
				var next = s.next("li");
				if (next.length > 0) {
					var index = next.attr("ref");
					if (typeof index != 'undefined' && index != null) {
						i = index;
					}
				} else {
					var index = this.assistElement.find(".assist-item").first().attr("ref");
					if (typeof index != 'undefined' && index != null) {
						i = index;
					}
				}
			} else {
				var index = this.assistElement.find(".assist-item").first().attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			}
			
			this.selectThisOne(i);
		};
		this.selectPrev = function() {
			var s = this.assistElement.find(".item-selected").removeClass("item-selected");
			var i = 0;
			if (s.length > 0) {
				var prev = s.prev("li");
				if (prev.length > 0) {
					var index = prev.attr("ref");
					if (typeof index != 'undefined' && index != null) {
						i = index;
					}
				} else {
					var index = this.assistElement.find(".assist-item").last().attr("ref");
					if (typeof index != 'undefined' && index != null) {
						i = index;
					}
				}
			}
			
			this.selectThisOne(i);
		};
		
		this.resetOriginalText = function() {
			this.search.originalText= null;
		};
		
		this.resetSearch = function() {
			this.search = {originalText: null, elems: new Array()};
		};
		
		this.buildBase();
		
		this.destroy = function(){
			this.baseElement.remove();
			this.baseElement = null;
			listAssist.splice(listAssist.indexOf(dxA), 1);
			dxA = null;
		}
	}
	
	function closeAllAssist() {
		for(var i = 0; i < listAssist.length; i++) {
			listAssist[i].close();
		}
	}
	
	
	function isHelperKey(value) {
		if
		(value == 17
				|| value == 27
				|| value == 16
				|| value == 20
				|| value == 18
				|| value == 144
				|| value == 45
				|| value == 145
				|| value == 44
				|| value == 8
				|| value == 9
				|| value == 46
				|| value == 35
				|| value == 36
				|| value == 33
				|| value == 34
				|| (value >= 112 && value <= 123)) {
			return true;
		}
		return false;
	}
	
	function getJavaAssist(val) {
		return [
		        {key:val+"a"+Math.floor((Math.random()*10)+1), desc: "a-desc"},
		        {key:val+"b"+Math.floor((Math.random()*10)+1), desc: "b-desc"},
		        {key:val+"c"+Math.floor((Math.random()*10)+1), desc: "c-desc"},
		        {key:val+"aa"+Math.floor((Math.random()*10)+1), desc: "aa-desc"},
		        {key:val+"bb"+Math.floor((Math.random()*10)+1), desc: "bb-desc"},
		        {key:val+"cc"+Math.floor((Math.random()*10)+1), desc: "cc-desc"}
		        ];
	}

})();


