var filters = angular.module('syraFilters', []);
filters.filter('checkmarkint', function() {
	return function(i) {
		return (typeof i == 'undefined') ? "" : (i=='0' ? '\u2718' : (i===1 ? '\u20e0' : '\u2714'));
	}
});
filters.filter('theking', function() {
	return function(i) {
		return (typeof i == 'undefined') ? "" : (i=='0' ? '\u2657' : i=='1' ? '\u2654' : '?');
	}
});
filters.filter('checkmark', function() {
	return function(i) {
		return (typeof i == 'undefined') ? "" : (i ? '\u2714' : '\u2718');
	}
});
filters.filter('exposeEmoji', function($sce) {
    return function(val) {
    		val = "&#x"+ val + ";";
        return $sce.trustAsHtml(val);
    };
});
filters.filter('codPreciSectActiv', function() {
	return function(t) {
		if (0===t) {
			return "S/O";
		} else if (1===t) {
			return "Salle d'op.";
		} else if (2===t) {
			return "Chevet du pt";
		} else {
			return ' ';
		}
	};
});
filters.filter('codPreciLieu', function() {
	return function(t) {
		if ('A'==t) {
			return "Sant pub";
		} else if ('B'==t) {
			return "Ex dom - gér.c.d.";
		} else if ('C'==t) {
			return "Vis dom - cl insc";
		} else if ('D'==t) {
			return "Témoig trib";
		} else if ('E'==t) {
			return "Méd comm";
		} else if ('F'==t) {
			return "Sant pub - méd pré/trav";
		} else if ('G'==t) {
			return "Vis/consult gér. (diff.)";
		} else if ('L'==t) {
			return "Local gouv.";
		} else {
			return ' ';
		}
	};
});
filters.filter('codPreciLieuTitle', function() {
	return function(t) {
		if ('A'==t) {
			return "Santé publique (Annexe XXIII)";
		} else if ('B'==t) {
			return "Examen à domicile - programme de gériatrie de courte durée";
		} else if ('C'==t) {
			return "Visite à domicile - clientèle inscrite";
		} else if ('D'==t) {
			return "Témoignage au tribunal";
		} else if ('E'==t) {
			return "Médecine communautaire (LE 160)";
		} else if ('F'==t) {
			return "Santé publique et médecine préventive ou médecine du travail";
		} else if ('G'==t) {
			return "Visite ou consultation en gériatrie effectuée dans un établissement différent du lieu habituel de pratique";
		} else if ('L'==t) {
			return "Local sous gestion du gouvernement ou d'un organisme qu'il subventionne";
		} else {
			return ' ';
		}
	};
});

