(function(){
	var patient = angular.module("editpatient", ['widget', 'syraFilters','cfp.hotkeys', 'angular-confirm']);

	patient.directive('editptProfValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.editptproftxValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(viewValue) || viewValue==null || viewValue=='') {
						deferred.resolve();
					} else if (angular.isDefined(scope.patCtrl.proftx.lastName) && scope.patCtrl.proftx.noProf==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length>4) {
						$http({
							method : "GET",
							url : "/syra/professionals/get?c=" + viewValue +"&u=" + clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.noProf)) {
									scope.patCtrl.proftx.noProf = res.noProf;
									scope.patCtrl.proftx.lastName = res.lastName;
									scope.patCtrl.proftx.firstName = res.firstName;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
		

	patient.directive('editNamValid', function($q, $http, clientUid) {
		  return {
			  restrict: 'A',
		    require: 'ngModel',
		    link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.editNamValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(viewValue) || viewValue==null) {
						deferred.resolve();
					} else if (viewValue.trim().length!=12) {
						deferred.reject();
					} else if (viewValue.toUpperCase().match(/^[A-Z][A-Z][A-Z][A-Z|*][0-9][0-9][0156][0-9][0-3][0-9]([A-Z]|[0-9])[0-9]$/) != null) {
						$http({
					        method : "GET",
					        url : "/syra/validNam/get?c="+viewValue.toUpperCase()+"&u="+clientUid
					    }).then(function mySucces(response) {
					    	var res = response.data;
					    	if (res==0) {
					    		deferred.reject();
					    	} else if (res==1) {
					    		deferred.resolve();
					    	} else if (res.bds) {  
					    		// donc on a valider le nam et mis une ddn en string.
					    		scope.patient.hin = res.hin;
					    		scope.patient.bds = res.bds;
					    		scope.patient.gender = res.gender;
					    		deferred.resolve();
					    	} else {
					    		deferred.reject();
					    	}
					    }, function myError(response) {
					    });
					} else {
						deferred.reject();
					}
				    return deferred.promise;
		      };
		    }
		  };
		});
	
	patient.controller('EditPatientController', ['$scope', '$http', '$log', '$timeout', 'hotkeys', 'clientUid', 'model', '$uibModal', '$confirm',
	                                             function($scope, $http, $log, $timeout, hotkeys, clientUid, model, $uibModal,$confirm){
		var helpers = MyNamespace.helpers;
		var that = this;
		var patParm = $scope.mObject.modalData ? $scope.mObject.modalData : {};
		if (angular.isUndefined(patParm.adr)) {
			patParm.adr = {};
		}
		if (angular.isUndefined(patParm.adr.cy)) {
			patParm.adr.cy = {};
		}
		$scope.patient = _.cloneDeep(patParm);
		that.proftx = {};
		that.proftx.noProf = $scope.patient.txProfN;
		that.model = model;
		var mustCheckDirty = true;	// mis true quand change data
		var dirty = false;

		var prevhotkey = [hotkeys.get('alt+e'), hotkeys.get('alt+c')];
		
		hotkeys.add({
			combo: 'alt+e',
			description: "Enregistrer Patient dans l'index",
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				if ($scope.patient.ln && $scope.patient.fn && $scope.patient.bds) {
					that.savePatient($scope.editPatient.$valid);
				}
			}
		});
		hotkeys.add({
			combo: 'alt+c',
			description: "Fermer",
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				$scope.modal.cancel();
			}
		});
		
		function clearHotKeys(){
			hotkeys.del('alt+c');
			hotkeys.del('alt+e');
			for (var i = 0; i<prevhotkey.length; i++) {
				if (prevhotkey[i]) {
					hotkeys.add(prevhotkey[i]);					
				}
			}
		}
		//Flag for closing mechanism.
		var closeAnyways = false;
		
		$scope.modal.closing = function(event){
			// Your code when the modal is closed.
			if ($scope.isDirty(true) && !closeAnyways) {
				event.preventDefault();
				$confirm({
					text: "Cette fiche du patient a été modifiée mais non enregistrée. " +
					"Veuillez confirmer l'abandon de ces modifications. ",
					title:"Demande de confirmation",
					ok: "Je confirme l'abandon",
					cancel : "Oups! Je veux corriger mon oubli."
				})
				.then(function(res) {
					closeAnyways = true;
					$scope.modal.cancel();
				});
			}else{
				clearHotKeys();
			}
		};
		
		$scope.setDirty = function() {
			mustCheckDirty = true;
		};
		
		// passer true si on veut s'assurer que pas eu de modif
		$scope.isDirty = function(v) {
			if (v) {
				// le save ne doit être possible que si on modifie slm localement
				// sinon, on procède par le transmit à la RAMQ et le retour update les données
				// si on ne transmet pas après une modification (param true ici), il valide que modifié.
				if (mustCheckDirty) {
					// compare clone with origin 
					dirty = !(helpers.compare($scope.patient, $scope.mObject.modalData) && $scope.mObject.modalData.txProfN === that.proftx.noProf);
					mustCheckDirty = false;
				}
				return dirty;				
			}
			return false;
		};
		
		$scope.changeProf = function() {
			if (angular.isUndefined(that.proftx.noProf) || that.proftx.noProf==null || that.proftx.noProf=='') {
				that.proftx = {};
				delete $scope.patient.txProfN;
			} else {
				$scope.patient.txProfN = that.proftx.noProf;
			}
			mustCheckDirty = true;
		};
		
		var dateAssist = new DynaDate({elem:"sDdnEditPatient", acceptFutureDate:false});
		dateAssist.onDateSelected = function(selectedDate) {
			$scope.patient.bds = moment(selectedDate).format('YYYY-MM-DD');
//			$scope.$apply();
		};
		
		$scope.patientProfAssist = {
				assistId: "autocomplete_editPatientProf", 
				hasHeader: false, hasDetails: false,
				trigger: 'focus',
				getAjaxData: function(query){
					delete that.model.currentProf().id;
					return { url:"/syra/professionals/search",
						data: { k: query, u:clientUid }}; },
				getKey: function(elem) {
					return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.noProf + "</div><div class='divCellCol2'>" + elem.lastName + ", " + elem.firstName + "</div></div></div>";
				},
				selection: function(elem) {
					this.lockEntry();
					that.proftx = elem;
					$scope.patient.txProfN = elem.noProf;
					mustCheckDirty = true;
					return elem.noProf;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
		};
	
				
		this.removeProftx = function() {
			mustCheckDirty = true;
			that.proftx = {};
			delete $scope.patient.txProfN;
		};
		
		
		//Patient assist input
		$scope.cityAssist = {
			headerHtml: '<button class="btn sm primary" type="button" ng-click="newCity()"><i class="glyphicon glyphicon-user"></i> Nouvelle ville</button>',
			nextTabOnTab: true,
			nextTabOnEnter: true,			
			trigger:'focus',
			elem :"cityInputEditPatient",
			assistId: "autocomplete_city_edit_patient",
			hasDetails: false,
			getAjaxData: function(query){
				return { url:"/syra/city/search",
					data: { k: query, u: clientUid }};
			},
			getKey: function(c) {
				return c.d;
			},
			getDescription : function(c) {
				return c.d;
			},
			selection : function(c) {
				$scope.patient.adr.cy.i = c.i;
				$scope.patient.adr.cy.n = c.d;
				return c.d;
			},
			onItemSelected : function(itemSelected) {
				$scope.patient.adr.cy.n = itemSelected;
//				$scope.$apply();
			}
		};
		
		
		$scope.newCity = function(){
			$scope.newCityOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "md",
				resolve: {
					mObject: function () {
						return {
							title: "Nouvelle Ville",
							templateUrl:"/syra/Resources/views/editCity.html"
						};
					}
				}
			});
			
			$scope.modalInstance.result.then(function () {
				$scope.newCityOpened = false;
	        }, function () {
	            $scope.newCityOpened = false;
	        });
		};
		
		that.savePatient = function(valid) {
			if (valid) {
				//{"tag":-3,"typIdPerson":1,"bds":"2013-08-13T04:00:00.000Z","typSituConsi":1,"typePerson":1,"dirtyStatus":{},"lstDx":{"properties":{"replaceDuplicateKey":true,"equals":null}},"$$hashKey":"uiGrid-0053","ident":"...","valid":false,"hin":"COTL13081315","ln":"Coté","fn":"Logan","gender":"M"}
				var p = _.cloneDeep($scope.patient);
				delete p.typSituConsi;
				delete p.dirtyStatus;
				delete p.lstDx;
				delete p.$$hashKey;
				delete p.ident;
				delete p.codeDx;
				var sObj = JSON.stringify(p);
				var cUidObject = {'o': sObj, 'u': clientUid};			
				$http({
					method : "POST",
					url : "/syra/editpatient/post",
					data:  JSON.stringify(cUidObject),
					headers: {'Content-Type': 'application/json; charset=utf-8'}
				}).then(function mySucces(response) {
					$scope.patient.id=response.data;
//					that.model.setCurrPatient($scope.patient, false);	// on ne met pas modified car pas besoin de faire un post (currentPatient au backend deja setté)
					closeAnyways = true;
					$scope.modal.ok($scope.patient);
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});				
			}
		};
		
		that.hello = function(m) {
			new jBox('Notice', {
				color : 'green',
				content: m,
				attributes: {
					x: 'right',
					y: 'bottom'
				}
			});
		};

		if (angular.isDefined(that.proftx.noProf)) {
			$http({
				method : "GET",
				url : "/syra/professionals/get?c=" + that.proftx.noProf +"&u=" + clientUid
			}).then(function mySucces(response) {
				var res = response.data;
				if (angular.isUndefined(res.length)) {
					if (angular.isDefined(res.lastName)) {
						that.proftx.lastName = res.lastName;
						that.proftx.firstName = res.firstName;
					}
				}
			}, function myError(response) {
				$scope.myWelcome = response.statusText;
			});
		}
//		if (angular.isDefined($scope.patient.hin)) {
//			$timeout(function(){$scope.focusOnWhenHin();}, 100);
//		}
		
	}]);
})();