(function(){
	var billEntry = angular.module('billEntry', ['widget', 'ngTouch', 'ui.grid', 'ui.grid.cellNav', 'ui.grid.resizeColumns', 'ui.grid.selection', 'angular-confirm']);
	billEntry.service('EntryService', function(){
		this.types = [{id: 1, label: 'Services Médicaux', url: '/syra/Resources/views/medical_service.html'}, 
		              {id: 2, label: 'Frais de déplacement', url:'/syra/Resources/views/transport_fee.html'}];
		this.type = this.types[0];
	});

	billEntry.filter('reverse', function() {
		  return function(items) {
		    return items.slice().reverse();
		  };
		});	
	
	billEntry.directive('profValidAnnul', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.profValidAnnul = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isDefined(scope.model.currentProf().lastName) && scope.model.currentProf().noProf==viewValue) {
						deferred.resolve();
					} else if (viewValue.match(/^[0-9]+$/) != null && viewValue.length>2) {
						delete scope.model.currentProf().id;
						$http({
							method : "GET",
							url : "/syra/professionals/search?c=" + viewValue +"&u=" + clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							var prof;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.noProf)) {
									scope.model.setCurrProf(res, false);	// pour ne pas mettre dirty car saved auto
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else if (res.length==1 && angular.isDefined(res[0].noProf)) {
								scope.model.setCurrProf(res[0], false);	// pour ne pas mettre dirty car saved auto
								deferred.resolve();								
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	billEntry.directive('billTrspEtabValid', function($q, $http, clientUid) {
		  return {
			  restrict: 'A',
		    require: 'ngModel',
		    link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.billTrspEtabValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(scope.activeLieuEtab) || angular.isUndefined(scope.activeLieuEtab.valEtab)) {
						deferred.resolve();
					} else if (angular.isDefined(scope.activeLieuEtab.valEtab.nomEtab) && scope.activeLieuEtab.noSelectedEtab==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length==5) {
						if (angular.isDefined(scope.activeLieuEtab.valEtab.nomEtab)) {
							delete scope.activeLieuEtab.valEtab.nomEtab;
						}
						$http({
							method : "GET",
							url : "/syra/etabl/get?c=" + viewValue +"&u=" + clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.valEtab.nomEtab) && res.valEtab.nomEtab!='') {
					    			scope.model.setDirtyStatus(scope.model.currentDemPaimt(), true);
									scope.activeLieuEtab = res;
									var elem = {};
									elem.c = viewValue;
									elem.d = res.valEtab.nomEtab+ " (" + res.valEtab.typEtab + '-' + res.valEtab.catgEtab +")";
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						if (angular.isDefined(scope.activeLieuEtab.valEtab.nomEtab)) {
							delete scope.activeLieuEtab.valEtab.nomEtab;
						}
						deferred.reject();
					}
				    return deferred.promise;
		      };
		    }
		  };
		});
			
	billEntry.directive('billTrspLocalValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.billTrspLocalValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(scope.activeLieuEtab) || angular.isUndefined(scope.activeLieuLocal.valCodLocal)) {
						deferred.resolve();
					} else if (angular.isDefined(scope.activeLieuLocal.valCodLocal.nomLocal) && scope.activeLieuLocal.valCodLocal.codLocal==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length==5) {
						if (angular.isDefined(scope.activeLieuLocal.valCodLocal.nomLocal)) {
							delete scope.activeLieuLocal.valCodLocal.nomLocal;
						}
						$http({
							method : "GET",
							url : "/syra/local/get?c="+viewValue+"&u="+clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.nomLocal) && res.nomLocal!='') {
					    			scope.model.setDirtyStatus(scope.model.currentDemPaimt(), true);
									scope.activeLieuLocal.valCodLocal = res;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
						});
					} else {
						if (angular.isDefined(scope.activeLieuLocal.valCodLocal.nomLocal)) {
							delete scope.activeLieuLocal.valCodLocal.nomLocal;
						}
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
		
	billEntry.directive('billEtabValid', function($q, $http, clientUid) {
		  return {
			  restrict: 'A',
		    require: 'ngModel',
		    link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.billEtabValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(scope.activeLieuEnRef.etab)) {
						deferred.resolve();
					} else if (angular.isDefined(scope.activeLieuEnRef.etab.valEtab) && angular.isDefined(scope.activeLieuEnRef.etab.valEtab.nomEtab) && scope.activeLieuEnRef.etab.noSelectedEtab==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue)) {
						if (viewValue.match(/^[0-9]+$/) != null && viewValue.length==5) {
							if (angular.isDefined(scope.activeLieuEnRef.etab) && angular.isDefined(scope.activeLieuEnRef.etab.valEtab) && angular.isDefined(scope.activeLieuEnRef.etab.valEtab.nomEtab)) {
								delete scope.activeLieuEnRef.etab.valEtab.nomEtab;
							}
							$http({
								method : "GET",
								url : "/syra/etabl/get?c=" + viewValue +"&u=" + clientUid
							}).then(function mySucces(response) {
								var res = response.data;
								if (angular.isUndefined(res.length)) {
									if (angular.isDefined(res.valEtab.nomEtab) && res.valEtab.nomEtab!='') {
						    			scope.model.setDirtyStatus(scope.model.currentDemPaimt().serv.lstLigneFact, true);
										scope.activeLieuEnRef.etab = res;
										var elem = {};
										elem.c = viewValue;
										elem.d = res.valEtab.nomEtab+ " (" + res.valEtab.typEtab + '-' + res.valEtab.catgEtab +")";
										deferred.resolve();
									} else {
										deferred.reject();
									}
								} else {
									deferred.reject();
								}
							}, function myError(response) {
								$scope.myWelcome = response.statusText;
							});
						} else if (MyNamespace.helpers.isEmpty(viewValue)){
							deferred.resolve();
						} else {
							deferred.reject();
						}
					} else {
						if (angular.isDefined(scope.activeLieuEnRef.etab.valEtab) && angular.isDefined(scope.activeLieuEnRef.etab.valEtab.nomEtab)) {
							delete scope.activeLieuEnRef.etab.valEtab.nomEtab;
						}
						deferred.reject();
					}
				    return deferred.promise;
		      };
		    }
		  };
		});
			
	billEntry.directive('billSectValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.billSectValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(scope.activeLieuEnRef.etab.valSect)) {
						deferred.resolve();
					} else if (angular.isDefined(scope.activeLieuEnRef.etab.valSect.desSectActiv) && scope.activeLieuEnRef.etab.valSect.noSectActiv==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue)) {
						if (viewValue.match(/^[0-9]+$/) != null && viewValue.length===2) {
							if (angular.isDefined(scope.activeLieuEnRef.etab.valSect.desSectActiv)) {
								delete scope.activeLieuEnRef.etab.valSect.desSectActiv;
							}
							$http({
								method : "GET",
								url : "/syra/secteur/get?c=" + viewValue +"&u=" + clientUid
							}).then(function mySucces(response) {
								var res = response.data;
								if (angular.isUndefined(res.length)) {
									if (angular.isDefined(res.desSectActiv) && res.desSectActiv!='') {
						    			scope.model.setDirtyStatus(scope.model.currentDemPaimt().serv.lstLigneFact, true);
										scope.activeLieuEnRef.etab.valSect = response.data;
										deferred.resolve();
									} else {
										deferred.reject();
									}
								} else {
									deferred.reject();
								}
							}, function myError(response) {
								$scope.myWelcome = response.statusText;
							});
						} else if (viewValue.length===0){
							deferred.resolve();
						} else {
							deferred.reject();
						}
					} else {
						deferred.resolve();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	billEntry.directive('billLocalValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.billLocalValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(scope.activeLieuEnRef) || angular.isUndefined(scope.activeLieuEnRef.local) || angular.isUndefined(scope.activeLieuEnRef.local.valCodLocal)) {
						deferred.resolve();
					} else if (angular.isDefined(scope.activeLieuEnRef.local.valCodLocal) && angular.isDefined(scope.activeLieuEnRef.local.valCodLocal.nomLocal) && scope.activeLieuEnRef.local.valCodLocal.codLocal==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length==5) {
						if (angular.isDefined(scope.activeLieuEnRef.local.valCodLocal.nomLocal)) {
							delete scope.activeLieuEnRef.local.valCodLocal.nomLocal;
						}
						$http({
							method : "GET",
							url : "/syra/local/get?c="+viewValue+"&u="+clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.nomLocal) && res.nomLocal!='') {
					    			scope.model.setDirtyStatus(scope.model.currentDemPaimt().serv.lstLigneFact, true);
									scope.activeLieuEnRef.local.valCodLocal = res;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
						});
					} else {
						if (angular.isDefined(scope.activeLieuEnRef.local.valCodLocal.nomLocal)) {
							delete scope.activeLieuEnRef.local.valCodLocal.nomLocal;
						}
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	billEntry.controller('BillEntryController', ['$scope', '$timeout', 'EntryService', 'TransportFeeEntryService', 'model', 'clientUid',  
	                                             function($scope, $timeout, EntryService,TransportFeeEntryService, model, clientUid){
		this.model = model;
		$scope.model = model;
		$scope.helpers = MyNamespace.helpers;
		var that = this;
		this.tfEntryServ = TransportFeeEntryService;

		$scope.showLastDemModif = function() {
			var ok = angular.isDefined(that.model.currentDemPaimt().demModif);
			ok = ok && angular.isDefined(that.model.currentDemPaimt().demModif.recev);
			ok = ok && that.model.currentDemPaimt().demModif.recev.staRecev===2;
			return ok;
		};
		
		$scope.dpAnnul = {
				ii: function(v) {
					if (arguments.length) {
						if (angular.isDefined(v)) {
							that.model.currentDemForListe().ii = v;
							that.model.saveCurrDemForListValue("ii", v, true);
						}
						return;
					}
					return that.model.currentDemForListe().ii;
				}
		};
		
		$scope.keys = function(obj){
			return obj? Object.keys(obj) : [];
		}
		
		$scope.profAnnulAssist = {
				assistId: "autocomplete_profAnnul",
				getAjaxData: function(query){
					delete that.model.currentProf().id;
					return { url:"/syra/professionals/search",
						data: { k: query, u:clientUid }};
				},
				listWidth: 300,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.noProf + "</div><div class='divCellCol2'>" + elem.lastName + ", " + elem.firstName + "</div></div></div>";},
				selection: function(elem) {
					this.lockEntry();
					that.model.setCurrProf(elem, false);	// pour ne pas mettre dirty car saved auto
					$scope.dpAnnul.ii(elem.noProf);
//					that.model.currentDemForListe().ii = elem.noProf;
					return elem.noProf;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			};
			
		$scope.$watch(
			function(scope) {
				return scope.model.currentDemPaimt().type;
			},
			function(newVal, oldVal, scope) {
			if (angular.isDefined(newVal)) {
				$timeout(function(){EntryService.type = EntryService.types[newVal-1];}, 1);
			}
		});
		
		this.type = function(newType){
			if (arguments.length) {
				if (angular.isDefined(newType)) {
					EntryService.type = newType;
					that.model.setDemPaimtType(newType.id);
				}
			} else {
				return EntryService.type;
			}
		};
		
		this.types = function(){
			return EntryService.types;
		};
		
		// permis slm si err de comm ou si sr=2 (donc comme non reçue par ramq)
		that.resetPrgComm = function() {
			that.model.currentDemForListe().prg = 0;
			that.model.currentDemForListe().sr = 0;
			if (that.model.currentDemForListe().dt>3) {
				that.model.currentDemForListe().dt = that.model.currentDemForListe().dt-3;
			}
			delete that.model.currentDemForListe().em;
			// faire idem au backend
			that.model.saveCurrDemForListValue("prg", 0, true);
		};
		
		that.resetStatutAccepte = function() {
			that.model.currentDemForListe().sr = 1;
			that.model.saveCurrDemForListValue("sr", 1, true);
			that.model.setCurrDemForListe({}, true);
			that.model.setCurrDemPaimt({}, true);
		};
		
		that.deleteBill = function() {
			that.model.deleteBill(that.model.currentDemForListe().tag);	// s'occupe de tout si succès via websocket
		};

		that.modifBill = function() {
			var type = that.model.currentDemPaimt().type;
			delete that.model.currentDemPaimt().type;	// pour bypasser temporairement le isDirty()
			that.model.demRecev().staRecev = 0;
			that.model.currentDemPaimt().demModif = {};
			that.model.currentDemPaimt().demModif.cNoDemExt = that.model.currentDemPaimt().cNoDemExt;
			that.model.currentDemPaimt().demModif.cDemdr = that.model.currentDemPaimt().cDemdr;
			if (angular.isDefined(that.model.currentDemPaimt().recev) && angular.isDefined(that.model.currentDemPaimt().recev.listeFactRecev) && that.model.currentDemPaimt().recev.listeFactRecev.length>0) {
				that.model.currentDemPaimt().demModif.idFact = that.model.currentDemPaimt().recev.listeFactRecev[0].idFactRamqRecev;
			}
			if (type==1) {
				delete that.model.currentDemPaimt().depl;
				// il faut s'assurer de retourner toutes les lignes dans le save.
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstElmCx, true);
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstPatients, true);
			} else if (type==2) {
				delete that.model.currentDemPaimt().serv;
			}
			$timeout(function() {
				that.type(EntryService.types[type-1]);	// remet le type
				that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
				if (type==2) {
					that.model.lstElmCxFactFTUpdated(true);
					that.model.lstlstFraisTranpUpdated(true);
					that.model.lstTempsDeplaUpdated(true);
					that.model.lstForfaDeplaUpdated(true);
					that.model.lstFraisSejUpdated(true);
				}
			}, 1);
		};
		
		that.annulBill = function() {
			var demAnnu = {};
			demAnnu.id = that.model.currentDemForListe().id;
			//demAnnu.idFact = that.model.currentDemPaimt().recev.listeFactRecev[0].idFactRamqRecev;
			demAnnu.idFact = that.model.demRecev().listeFactRecev[0].idFactRamqRecev;
			demAnnu.cDemdr = {};
			demAnnu.cDemdr.idIntvn = that.model.currentDemForListe().ii;
			demAnnu.cDemdr.typIdIntvn = '1';
			demAnnu.cNoDemExt = that.model.currentDemForListe().noExt;
			that.model.httpPost("/syra/annu_bill/post", JSON.stringify(demAnnu), null, function() {
				that.model.currentDemForListe().prg = 0;
				that.model.currentDemForListe().sr = 0;
				that.model.currentDemForListe().dt = 3;
				that.model.currentDemForListe().ready = true;
				delete that.model.currentDemForListe().em;
				$timeout(function(){that.model.demListeItemUpdated().val++;},1);
			});
		};
		
		$scope.range = function(n){
			var res = [];
			for (var i = 0; i < n; i++) {
		        res.push(i);
		      }
			return res;
		};
		
	}]);
	
	var DOUBLE_REGEXP = /^\d{1,9}(\.\d{1,2}){0,1}$/;
	billEntry.directive('doubleMesure', function() {
	  return {
		  restrict: 'A',
	    require: 'ngModel',
	    link: function(scope, elm, attrs, ctrl) {
	      ctrl.$validators.doubleMesure = function(modelValue, viewValue) {
	    	  if (angular.isUndefined(viewValue) || modelValue==0) {return true;}
	    	  if (ctrl.$isEmpty(modelValue)) {return false;}
	    	  if (DOUBLE_REGEXP.test(viewValue)) {return true;}
	    	  return false; // invalid
	      };
	    }
	  };
	});

	var HOUR_MIN_REGEXP = /^\d{1,9}(\.\d{1,2}){0,1}[hH]{0,1}$/;
	billEntry.directive('hourOrMinuteMesure', function() {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$validators.hourOrMinuteMesure = function(modelValue, viewValue) {
					if (angular.isUndefined(viewValue) || modelValue==0) {return true;}
					if (ctrl.$isEmpty(modelValue)) {return false;}
					if (HOUR_MIN_REGEXP.test(viewValue)) {return true;}
					return false; // invalid
				};
			}
		};
	});
	
	var INTEGER_REGEXP = /^\-?\d+$/;
	billEntry.directive('integer', function() {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$validators.chiffre = function(modelValue, viewValue) {
					if (ctrl.$isEmpty(modelValue)) {return false;}
					if (INTEGER_REGEXP.test(viewValue)) {return true;}
					return false; // invalid
				};
			}
		};
	});
	billEntry.directive('length5', function() {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$validators.length5 = function(modelValue, viewValue) {
					if (modelValue.length!=5) {return false;}
					return true;
				};
			}
		};
	});
	
	billEntry.directive('codFactValid', function($q, $http, clientUid) {
	  return {
		  restrict: 'A',
	    require: 'ngModel',
	    link: function(scope, elm, attrs, ctrl) {
			ctrl.$asyncValidators.codFactValid = function(modelValue, viewValue) {
				var deferred = $q.defer();
				if (angular.isDefined(scope.model.currentLigneServMdcal().codFact.d)) {
					deferred.resolve();
				} else  if (viewValue.match(/^[0-9]+$/) != null) {
					$http({
				        method : "GET",
				        url : "/syra/codefacturation/get?c="+viewValue+"&u="+clientUid
				    }).then(function mySucces(response) {
				    	var res = response.data;
				    	if (angular.isUndefined(res.length)) {
				    		if (angular.isDefined(res.d) && res.d!='') {
				    			scope.model.setDirtyStatus(scope.model.currentDemPaimt().serv.lstLigneFact, true);
				    			scope.setServActiveCodFact(res, true);
				    			deferred.resolve();
				    		} else {
				    			deferred.reject();
				    		}
				    	} else {
				    		deferred.reject();
				    	}
				    }, function myError(response) {
				    });
				} else {
					deferred.reject();
				}
			    return deferred.promise;
	      };
	    }
	  };
	});
		
	billEntry.directive('ctxValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.ctxValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(viewValue) || ''==viewValue || viewValue==null) {
						deferred.resolve();
					} else if (angular.isDefined(scope.activeElmCx.d) && scope.activeElmCx.d!=='') {
						deferred.resolve();
					} else  if (viewValue.match(/^[0-9]+$/) != null) {
						$http({
							method : "GET",
							url : "/syra/contx/get?c="+viewValue+"&u="+clientUid
//							url : "/syra/contx/get?c="+viewValue+"&n=L"+"&u="+clientUid
						}).then(function mySucces(response) {
							var res = response.data;
					    	if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.d) && res.d!='') {
					    			// scope.model.setDirtyStatus(scope.model.currentDemPaimt(), true);	// utilisé aussi dans transport. dirty set dans le ng-change de chacun
									scope.activeElmCx.c = res.c;
									scope.activeElmCx.d = res.d;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
						});
					} else {
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	billEntry.directive('ctxFactValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.ctxFactValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(viewValue) || ''==viewValue || viewValue==null) {
						deferred.resolve();
					} else if (angular.isUndefined(scope.activeElmCxFact) || (angular.isDefined(scope.activeElmCxFact.codeCtx.d) && scope.activeElmCxFact.codeCtx.d!=='')) {
						deferred.resolve();
					} else  if (viewValue.match(/^[0-9]+$/) != null) {
						$http({
							method : "GET",
							url : "/syra/contx/get?c="+viewValue+"&n=F"+"&u="+clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.d) && res.d!='') {
					    			scope.model.setDirtyStatus(scope.model.currentDemPaimt(), true);
									scope.activeElmCxFact.codeCtx.c = res.c;
									scope.activeElmCxFact.codeCtx.d = res.d;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
						});
					} else {
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	billEntry.controller('MedicalEntryController', ['$scope', '$http', '$log', '$timeout', 'uiGridConstants', 'clientUid', 'model','$uibModal', 'ProfTypes', '$confirm','Codifies',
	                                                function($scope, $http, $log, $timeout, uiGridConstants, clientUid, model, $uibModal, ProfTypes, $confirm,Codifies){
		var that = this;
		var isAddingAutoCode = false;
		that.model = model;
		$scope.model = model;
		$scope.mustTabInTypPrfsnProfRefre = false;
				
		that.refProf = {typProfRef : 1};

		function setLieuEnRefValues() {
			$scope.activeLieuEnRef = {};
			$scope.activeLieuEnRef.typLocEtab = 'C';
			$scope.activeLieuEnRef.local = {};
			$scope.activeLieuEnRef.local.typIdLieuGeo = '3';
			$scope.activeLieuEnRef.local.typLieuGeo = '0';
			$scope.activeLieuEnRef.local.codPreciLieu = '0';
			$scope.activeLieuEnRef.etab = {};
			$scope.activeLieuEnRef.etab.codPreciLieu = '0';
			$scope.activeLieuEnRef.etab.codPreciSectActiv = 0;
			$scope.activeLieuEnRef.etab.valSect = {};
			$scope.activeLieuEnRef.tag = that.model.atomicInt();
		}
		function setControllerDefaultValues() {
			that.prevRole = -1;
			$scope.activeElmCx = {};
			$scope.servActiveMesur = {};
			$scope.activeElmCxFact = {}; // contient codeLie et codeCtx
			$scope.activeElmCxFact.codeCtx = {};	// contient c et d
			setLieuEnRefValues();
		}
		setControllerDefaultValues();
		
		that.roles =['123478','12347'];// omni spec
		that.roleDesc = {
				'1': "Médecin responsable de l'acte ou médecin qui effectue une consultation en radiologie",
				'2': "Anesthésiste",
				'3': "Anesthésiste collaborateur",
				'4': "Médecin assistant",
				'7': "Médecin responsable des composantes techniques et professionnelles pour radiologie, audiométrie et les épreuves de fonction respiratoire",
				'8': "Médecin responsable de l'interprétation seulement, pour audiométrie; pneumologue responsable de l'interprétation des épreuves de fonction respiratoire"
				};

		that.codifies = Codifies.list();
		that.typRefAutreProfs = [
			                      {'id':1, 'label': 'Connu'},
			                      {'id':2, 'label': 'Non-Connu'}
		                         ];
		that.typRefAutreProfTitles = {
				'1': "Professionnel (reconnu et codifié) à la Régie.", 
				'2': "Professionnel qui n'est pas connu et qui n'est pas codifié à la Régie."
		};
		that.typRefreAutreProfs = [];
		that.typRefreAutreProfs[1] = [
		                           {'id':1, 'label':'Professionnel référant'},
		                           {'id':2, 'label':'Médecin a qui les soins post-opératoires sont confiés'},
		                           {'id':3, 'label':'Résident qui a vu le patient'},
		                           {'id':4, 'label':'Mentoré'},
		                           {'id':5, 'label':'Mentor'}	                      
		                           ];
		that.typRefreAutreProfs[2] = [
		                              {'id':1, 'label':'Professionnel référant'},
		                              {'id':2, 'label':'Médecin a qui les soins post-opératoires sont confiés'}
		                              ];
	    that.getTypRefreAutreProfs=function() {
	    	return that.typRefreAutreProfs[(that.model.currentProf().type)];
	    };

		that.typRefreLieux = [];
		that.typRefreLieux[1] = [
//		                      {'id': 1, 'label': 'Cabinet, CLSC, UMF-CH ou UMF-CLSC pour le compte duquel la visite à domicile a été effectuée (Non supporté)'},
//		                      {'id': 2, 'label': 'Établissement pour le compte duquel le service a été effectué (Non supporté)'},
//		                      {'id': 3, 'label': 'Lieu pour lequel la garde à distance est effectuée (Non supporté)'},
//		                      {'id': 4, 'label': 'Lieu duquel origine la consultation à distance (Non supporté)'},
//		                      {'id': 6, 'label': 'Lieu où se trouve le patient (télémédecine) (Non supporté)'},
//		                      {'id': 8, 'label': 'Lieu où la technique a été réalisée (Non supporté)'},
//		                      {'id': 9, 'label': 'Autre lieu pour lequel des activités, sur place, ont été effectuées (Non supporté)'},
//		                      {'id': 10, 'label': "Établissement pris en charge lors d'une garde multi-établissements (Non supporté)"},
		                      {'id': 12, 'label': 'Lieu de départ pour service rendu à domicile'},
		                      {'id': 13, 'label': 'Lieu de transfert du patient'},
		                      {'id': 99, 'label': 'Lieu où le service est rendu par le professionnel'},
		                      ];
		that.typRefreLieux[2] = [
//			                      {'id': 2, 'label': 'Établissement pour le compte duquel le service a été effectué (Non supporté)'},
			                      {'id': 3, 'label': 'Lieu pour lequel la garde à distance est effectuée (LE 128)'},
			                      {'id': 4, 'label': 'Lieu duquel origine la consultation à distance'},
		                          {'id': 5, 'label': 'Université affiliée'},
			                      {'id': 6, 'label': 'Lieu où se trouve le patient (télémédecine)'},
		                          {'id': 7, 'label': 'Territoire pour garde en disponibilité pour les autopsies à la demande du coroner (LE 171)'},
			                      {'id': 8, 'label': 'Lieu où la technique a été effectuée (radiologie)'},
			                      {'id': 9, 'label': 'Autre lieu pour lequel des activités de soutien sur place, ont été effectuées (Annexe 42)'},
			                      {'id': 10, 'label': "Établissements pris en charge lors d'une garde multi-établissements (Annexe 25)"},
			                      {'id': 11, 'label': "Territoire suprarégional pris en charge lors d'une garde en disponibilité en téléthrombolyse"},
		                    	  {'id': 12, 'label': 'Lieu de départ pour service rendu à domicile'},
			                      {'id': 99, 'label': 'Lieu où le service est rendu par le professionnel'}
		                         ];
	    that.getTypRefreLieux=function() {
	    	return that.typRefreLieux[(that.model.currentProf().type)];
	    };
	    that.typIdLieuxGeo = [];
	    that.typIdLieuxGeo[1] = [
	                             {'id': '2', 'label': "Code postal"},
	                             {'id': '3', 'label': "Code localité"}
	                             ];
	    that.typIdLieuxGeo[2] = [
	                             {'id': '2', 'label': "Code postal"},
	                             {'id': '3', 'label': "Code localité"},
	                             {'id': '4', 'label': "Territoire LE 171"},
	                             {'id': '5', 'label': "Territoire suprarégional"}
	                             ];
	    that.getTypIdLieuxGeo = function() {
	    	return that.typIdLieuxGeo[(that.model.currentProf().type)];
	    };
	    
		that.typLieuGeos = [
		                    {'id': '0', 'label': 'S/O'},
		                      {'id': 'C', 'label': 'Cabinet'},
		                      {'id': 'D', 'label': 'Domicile'},
		                      {'id': 'A', 'label': 'Autre'},
		                      {'id': 'I', 'label': 'Inconnu'}
		                      ];
		
		that.territoiresLE171 = [
		                        {'id': '0', 'label': 'Sans objet'},
		                        {'id': '1', 'label': '1. Bas-St-Laurent, Côte-Nord, Gaspésie-Îles-de-la-Madeleine'},
		                        {'id': '2', 'label': '2. Saguenay-Lac-St-Jean, Nord-du-Québec'},
		                        {'id': '3', 'label': '3. Capitale-Nationale, Estrie, Chaudière-Appalaches'},
		                        {'id': '4', 'label': '4. Mauricie et Centre-du-Québec'},
		                        {'id': '5', 'label': '5. Montréal incluant le Nunavik, Terres-Cries-de-la-Baie-James'},
		                        {'id': '6', 'label': '6. Montréal, Outaouais'},
		                        {'id': '7', 'label': '7. Abitibi-Témiscamingue'},
		                        {'id': '8', 'label': '8. Laval, Lanaudière, Laurentides'},
		                        {'id': '9', 'label': '9. Montérégie'},
		                        {'id': '10', 'label': "10. L'ensemble des territoires du Québec pour couvrir de façon exclusive les autopsies de nature pédiatrique-Montréal"}
		                        ];
		
		that.codTerriProfRefres = [
		                        {'id': 1, 'label': 'Québec'},
		                        {'id': 2, 'label': 'Hors Québec'}
			                   ];
		
		that.codPreciSectActivs = [];
		that.codPreciSectActivs[1] = [
                              {'id': 0, 'label': "S/O"},
		                      {'id': 1, 'label': "Salle d'opération"}
		                      ];
		that.codPreciSectActivs[2] = [
		                           {'id': 0, 'label': "S/O"},
		                           {'id': 1, 'label': "Salle d'opération"},
		                           {'id': 2, 'label': "Au chevet du patient"}
		                           ];
		that.getCodPreciSectActivs=function() {
			return that.codPreciSectActivs[(that.model.currentProf().type)];
		};
		
		that.codPreciLieux = [];
		that.codPreciLieux[1] = [
	                         	  {'id': '0', 'label': "S/O"}
	                              ];
		that.codPreciLieux[2] = [
	                              {'id': '0', 'label': "S/O"},
	                              {'id': 'L', 'label': "Local sous gestion du gouvernement ou d'un organisme qu'il subventionne"}
	                              ];
		that.getCodPreciLieux=function() {
			return that.codPreciLieux[(that.model.currentProf().type)];
		};
		
		that.typeDeProfessions = ProfTypes;
		that.jourFeries = {				
				1:"Jour de l'an",
				2:"Lendemain du jour de l'an",
				3:"Vendredi saint",
				4:"Lundi de Pâques",
				5:"Fête de Dollard et de la Reine",
				6:"Fête Nationnale",
				7:"Fête du Canada",
				8:"Fête du travail",
				9:"Fête de l'action de grâce",
				10:"Veille de Noel",
				11:"Noel",
				12:"Lendemain de Noel",
				13:"Veille du jour de l'an.",
				100:"Samedi",
				200:"Dimanche"
		};
//		that.typeDeProfessions = [
//		            {'id':1, 'label': 'Médecin'},
//					{'id':2, 'label': 'Optométriste'},
//					{'id':3, 'label': 'Infirmière praticienne spécialisée'},
//					{'id':4, 'label': 'Travailleur social'},
//					{'id':5, 'label': 'Ergothérapeute'},
//					{'id':6, 'label': 'Sage-femme'},
//					{'id':7, 'label': 'Physiothérapeute'},
//					{'id':8, 'label': 'Psychologue'},
//					{'id':9, 'label': 'Audiologiste'},
//					{'id':10, 'label': 'Audioprothésiste'},
//					{'id':11, 'label': 'Coroner'},
//					{'id':12, 'label': 'Médecin de la commission'},
//					{'id':13, 'label': 'Orthophoniste'},
//					{'id':14, 'label': 'Pharmacien'},
//					{'id':15, 'label': 'Médecin omnipraticien'},
//					{'id':16, 'label': 'Médecin spécialiste '},
//					{'id':17, 'label': 'Résident'},
//					{'id':18, 'label': 'Dentiste'},
//					{'id':99, 'label': 'Autres'}
//		                          ];
		
		that.codFacts = function() {
			var codFacts = [];
			var entries = angular.isDefined(that.model.currentDemPaimt().serv) && angular.isDefined(that.model.currentDemPaimt().serv.lstLigneFact) ? that.model.currentDemPaimt().serv.lstLigneFact.values() : [];
			var arrayLength = entries.length;
			for (var i = 0; i < entries.length; i++) {
			    var ligne = entries[i];
			    if (MyNamespace.helpers.isObject(ligne.codFact) && angular.isDefined(ligne.codFact.c)) {
			    	codFacts.push(ligne.codFact.c);
			    }
			}
	    	codFacts.push("");
			return codFacts;
		};
		$scope.needLieuEnRef = function() {
			var servActiveCodFact = that.model.currentLigneServMdcal().codFact;
			if ((typeof servActiveCodFact==='undefined')) return false;
			return $scope.model.currentDefault()['see_lieuRef'] || servActiveCodFact.needLieuRef==true || 
				(angular.isDefined($scope.activeLieuEnRef) && 
				(
					($scope.activeLieuEnRef.typLocEtab === 'C' && angular.isDefined($scope.activeLieuEnRef.etab) && angular.isDefined($scope.activeLieuEnRef.etab.noSelectedEtab)) ||
					($scope.activeLieuEnRef.typLocEtab === 'N' && angular.isDefined($scope.activeLieuEnRef.local) && angular.isDefined($scope.activeLieuEnRef.local.valCodLocal) && angular.isDefined($scope.activeLieuEnRef.local.valCodLocal.codLocal)) 
				 ));
		};
		var hasMdRef = function() {
			return (that.model.currentLigneServMdcal().typProfRef===1 && MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().idProfRefConnu)) || 
			(that.model.currentLigneServMdcal().typProfRef===2 && MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().nomProfRefre));
		};
		$scope.needRef = function() {
			var servActiveCodFact = that.model.currentLigneServMdcal().codFact;
			if (MyNamespace.helpers.isEmpty(servActiveCodFact)) return false;
			return $scope.model.currentDefault()['see_refreAutreProf'] || servActiveCodFact.needRefMd==true || 
			servActiveCodFact.needRefInf==true || servActiveCodFact.needRefSagF==true || 
			servActiveCodFact.needRefPharm==true || servActiveCodFact.needRefInt==true || servActiveCodFact.needRefAudio==true || 
			hasMdRef();
		};
		$scope.changeTypEtabRef = function() {
			if (angular.isDefined(that.model.currentDemPaimt().serv)) {
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
				if ($scope.activeLieuEnRef.typLocEtab === 'N') {
					$scope.activeLieuEnRef.etab= {};
					if (angular.isUndefined($scope.activeLieuEnRef.local.typIdLieuGeo)) {
						$scope.activeLieuEnRef.local.typIdLieuGeo = '3';
					}
					if (angular.isUndefined($scope.activeLieuEnRef.local.typLieuGeo)) {
						$scope.activeLieuEnRef.local.typLieuGeo = '0';
					}
					if (angular.isUndefined($scope.activeLieuEnRef.local.codPreciLieu)) {
						$scope.activeLieuEnRef.local.codPreciLieu = '0';
					}
					if ($scope.activeLieuEnRef.local.typIdLieuGeo=='3') {
						$timeout(function(){$scope.focusOnLocalInputEnRef();},200,1);
					} else {
						$timeout(function(){$scope.focusOnLocalAutreInputEnRef();},200,1);
					}
				} else if ($scope.activeLieuEnRef.typLocEtab === 'C') {
					$scope.activeLieuEnRef.local = {};
					if (angular.isUndefined($scope.activeLieuEnRef.etab.codPreciSectActiv)) {
						$scope.activeLieuEnRef.etab.codPreciSectActiv = 0;
					}
					if (angular.isUndefined($scope.activeLieuEnRef.etab.codPreciLieu)) {
						$scope.activeLieuEnRef.etab.codPreciLieu = '0';
					}
					$timeout(function(){$scope.focusOnInfoEtabEnRef();},200,1);
				}
			}
		};
		$scope.changetypProfRef = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
			if (that.model.currentLigneServMdcal().typProfRef == 1) {
				$timeout(function(){$scope.focusOnProfRefInput();},200,1);
			} else {
				$timeout(function(){$scope.focusOnProfRefNomInput();},200,1);
			}
		};
		$scope.showCodFactErr = function() {
			return $scope.serviceForm.sCodeFact.$error.codFactValid && $scope.serviceForm.sCodeFact.$viewValue.match(/^[0-9]+$/) != null;
		};
		$scope.showCodCtxErr = function() {
			return $scope.serviceForm.sContext.$error.ctxValid && $scope.serviceForm.sContext.$viewValue.match(/^[0-9]+$/) != null;
		};
		// pas utile car en fait, on affiche slm ceux reliés à un code de fact. 
		// On a besoin d'un code de mesure en plus des unités, donc slm unit ne sert à rien
//		that.typUnitMes = {
//				'CM': 'Centimètre',
//				'CM2': 'Centimètre carré',
//				'DH': 'Demi-heure',
//				'H': 'Heure',
//				'MIN': 'Minute',
//				'QH': "Quart d'heure",
//				'UN': 'Unité'
//		};
		var dhInterv = new DynaDate({elem:"dhInterv", format: 'YYYY-MM-DD HH:mm', locale:'fr', acceptFutureDate:false, useCurrent: false});
		dhInterv.getDefault = function(){
			return moment(that.model.currentDefault()['dateDefault']).hour(8).minute(00);
		};
		dhInterv.onDateSelected = function(selectedDate){
			showJourFerie(that.model.currentLieu(), selectedDate, dhInterv.baseElement);
		}
		var dhPerTrav = new DynaDate({elem:"dhPerTrav", format: 'YYYY-MM-DD HH:mm', locale:'fr', acceptFutureDate:false, useCurrent: false});
		dhPerTrav.getDefault = function(){
			return moment(that.model.currentDefault()['dateDefault']).hour(8).minute(00);
		};
		dhPerTrav.onDateSelected = function(selectedDate){
			showJourFerie(that.model.currentLieu(), selectedDate, dhPerTrav.baseElement);
		}
		
		that.showDtStartEnd = function() {
			return that.model.currentLigneServMdcal().codRole==2 || that.model.currentLigneServMdcal().codRole==3;
		};
		var dhDebut = new DynaDate({elem:"dhDebut", format: 'YYYY-MM-DD HH:mm', locale:'fr', acceptFutureDate:false, useCurrent: false, maxDateElm:'dhFin'});
		dhDebut.getDefault = function(){
			var defaut = moment(that.model.currentLigneServMdcal().dateServ).hour(8).minute(00);
			return defaut;
		};
		dhDebut.onDateSelected = function(selectedDate){
			showJourFerie(that.model.currentLieu(), selectedDate, dhDebut.baseElement);
		}
		var dhFin = new DynaDate({elem:"dhFin", format: 'YYYY-MM-DD HH:mm', locale:'fr', viewMode:'hours', acceptFutureDate:false, useCurrent: false, minDateElm:'dhDebut'});
		dhFin.getDefault = function(){
			var defaut = moment(that.model.currentLigneServMdcal().dhdElmFact);
			return defaut;
		};
		dhFin.onDateSelected = function(selectedDate){
			showJourFerie(that.model.currentLieu(), selectedDate, dhFin.baseElement);
		}
		
		this.needsDateHeureService = function() {
			var showThem = that.model.currentDefault()['is_soir_nuit'] || that.model.currentDefault()['see_dhdElmFact'];
			showThem = showThem || that.model.currentProf().modeRemu==1 || that.model.currentLigneServMdcal().codRole==2 || that.model.currentLigneServMdcal().codRole==3 || that.model.currentLigneServMdcal().dhdElmFact;
			showThem = showThem || that.model.isJourFerie(that.model.currentLieu(), that.model.currentLigneServMdcal().dateServ);
			return showThem;
		};
		
		function showJourFerie(l, d, o) {
			var type = that.model.isJourFerie(l, d);
			if (type>0) {
				o.addClass("date-ferie");
				o.attr('title',that.jourFeries[type]);		
			} else {
				o.removeClass("date-ferie");				
				o.attr('title',"");		
			}
		}
		function tagHash(a) {
			return a.tag;
		}
		
		// si m==true -> copy, false = new sans copy.
		that.pushLigneServMdcal = function(m){
			var dateServ;
			var dateServPlus;
			var codRole;
			var codFact;
			
			var typProfRef
			var typRefreAutreProf
			var typIdProfRefreConnu;
			var idProfRefConnu;
			var codTerriProfRefre;
			var typPrfsnProfRefre;
			var nomProfRefre;
			var preProfRefre;

			var lstElmCx;
			var dhdElmFact;
			var dhfElmFact;
			var dhdElmFactPlus;
			var dhfElmFactPlus;
			if (m) {
				if (that.model.currentDefault()['copyDateServNewLineServ']===true) {
					dateServ = that.model.currentLigneServMdcal().dateServ;
				}
				if (that.model.currentDefault()['copyDateServPlusNewLineServ']===true) {
					if (that.model.currentLigneServMdcal().dateServ<moment().format('YYYY-MM-DD')) {
						dateServPlus = moment(that.model.currentLigneServMdcal().dateServ, 'YYYY-MM-DD').add(moment.duration(1, 'days')).format('YYYY-MM-DD');
						if (that.model.currentDefault()['copyDHreNewLineServ']===true && MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().dhdElmFact)) {
							dhdElmFactPlus = moment(that.model.currentLigneServMdcal().dhdElmFact, 'YYYY-MM-DD HH:mm').add(moment.duration(1, 'days')).format('YYYY-MM-DD HH:mm');
							if (MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().dhfElmFact)) {
								dhfElmFactPlus = moment(that.model.currentLigneServMdcal().dhfElmFact, 'YYYY-MM-DD HH:mm').add(moment.duration(1, 'days')).format('YYYY-MM-DD HH:mm');
							}
						}
					} else {
						dateServPlus = that.model.currentLigneServMdcal().dateServ;
						if (that.model.currentDefault()['copyDHreNewLineServ']===true && MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().dhdElmFact)) {
							dhdElmFactPlus = that.model.currentLigneServMdcal().dhdElmFact;
							if (MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().dhfElmFact)) {
								dhfElmFactPlus = that.model.currentLigneServMdcal().dhfElmFact;
							}
						}
					}
				} else {
					if (that.model.currentDefault()['copyDHreNewLineServ']===true && MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().dhdElmFact)) {
						dhdElmFact = that.model.currentLigneServMdcal().dhdElmFact;
						if (MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().dhfElmFact)) {
							dhfElmFact = that.model.currentLigneServMdcal().dhfElmFact;
						}
					}
				}
				if (that.model.currentDefault()['copyRoleNewLineServ']===true) {
					codRole = that.model.currentLigneServMdcal().codRole;
				}
				if (that.model.currentDefault()['copyCodeNewLineServ']===true) {
					codFact = _.cloneDeep(that.model.currentLigneServMdcal().codFact);
				}
				if (that.model.currentDefault()['copyElCxNewLineServ']===true) {
					lstElmCx = [];// _.cloneDeep(that.model.currentLigneServMdcal().lstElmCx);
					var arrElmCx = that.model.currentLigneServMdcal().lstElmCx.values();
					for (var l = 0; l < arrElmCx.length; l++) {
						var cx = {};
						cx.c = arrElmCx[l].c;
						cx.d = arrElmCx[l].d;
						cx.dirtyStatus = {};
						cx.tag = that.model.atomicInt();
						lstElmCx.push(cx);
					}
				}
				if (that.model.currentDefault()['copyMdRefNewLineServ']===true) {
					typProfRef = that.model.currentLigneServMdcal().typProfRef;
					typRefreAutreProf = that.model.currentLigneServMdcal().typRefreAutreProf;
					typIdProfRefreConnu = that.model.currentLigneServMdcal().typIdProfRefreConnu;
					idProfRefConnu = that.model.currentLigneServMdcal().idProfRefConnu;
					codTerriProfRefre = that.model.currentLigneServMdcal().codTerriProfRefre;
					typPrfsnProfRefre = that.model.currentLigneServMdcal().typPrfsnProfRefre;
					nomProfRefre = that.model.currentLigneServMdcal().nomProfRefre;
					preProfRefre = that.model.currentLigneServMdcal().preProfRefre;
				}
			}
			var idClientUid = {'u': clientUid};
			$http({method : "GET",
				url : "/syra/ligneServMdcal/getNew?u=" + clientUid
			}).then(function mySucces(response) {
				var line = that.model.validateLigneServMdcal(response.data);
				line.dirtyStatus = {};
				if (typeof dateServ!=='undefined') {
					line.dateServ = dateServ;
				}
				if (typeof dateServPlus!=='undefined') {
					line.dateServ = dateServPlus;
				}
				if (typeof codRole!=='undefined') {
					line.codRole = codRole;
				}
				if (typeof codFact!=='undefined') {
					line.codFact = codFact;
				}
				if (typeof dhdElmFact!=='undefined') {
					line.dhdElmFact = dhdElmFact;
				}
				if (typeof dhfElmFact!=='undefined') {
					line.dhfElmFact = dhfElmFact;	
				}
				if (typeof dhdElmFactPlus!=='undefined') {
					line.dhdElmFact = dhdElmFactPlus;
				}
				if (typeof dhfElmFactPlus!=='undefined') {
					line.dhfElmFact = dhfElmFactPlus;
				}
				if (typeof lstElmCx!=='undefined') {
					var lineCtx = line.lstElmCx.values();
					for (var l = 0; l < lstElmCx.length; l++) {
						if (_.indexOf(lineCtx, lstElmCx[l])<0) {
							line.lstElmCx.put(lstElmCx[l].tag, lstElmCx[l]);							
						}
					}
				} else if (angular.isDefined(line.lstTempElmCx)) {
					var elmCxSet = false;
					line.lstElmCx = new Hashtable({ hashCode: tagHash });
					for (var l = 0; l < line.lstTempElmCx.length; l++) {
						var cx = line.lstTempElmCx[l];
						cx.dirtyStatus = {};
						cx.tag = that.model.atomicInt();
						line.lstElmCx.put(cx.tag, cx);
					}
				}
				if (angular.isDefined(line.lstTempElmCx)) {
					delete line.lstTempElmCx;
				}

				if (angular.isDefined(line.lstTempLieuEnRef)) {
					for (var l = 0; l < line.lstTempLieuEnRef.length; l++) {
						var cx = line.lstTempLieuEnRef[l];
						cx.dirtyStatus = {};
						cx.tag = that.model.atomicInt();
						line.lstLieuEnRef.put(cx.tag, cx);
					}
				}
				if (angular.isDefined(line.lstTempLieuEnRef)) {
					delete line.lstTempLieuEnRef;
				}
				if (that.model.currentDefault()['copyMdRefNewLineServ']===true) {
					line.typProfRef = typProfRef;
					line.typRefreAutreProf = typRefreAutreProf;
					line.typIdProfRefreConnu = typIdProfRefreConnu;
					line.idProfRefConnu  = idProfRefConnu;
					line.codTerriProfRefre = codTerriProfRefre;
					line.typPrfsnProfRefre = typPrfsnProfRefre;
					line.nomProfRefre = nomProfRefre;
					line.preProfRefre = preProfRefre;
				}
				that.model.addLigneServMdcalToLst(line, true);	// set curr too
				$scope.serviceBillGridOptions.data.push(line);
				$scope.serviceBillGridApi.grid.modifyRows($scope.serviceBillGridOptions.data);
				$scope.serviceBillGridApi.selection.selectRow(line);
				if (typeof codFact!=='undefined') {
					$scope.setServActiveCodFact(codFact, true);	// appelé sans le code reset les valeurs du controleur				
				}
			}, function myError(response) {
				$scope.myWelcome = response.statusText;
			});
		};

		that.pushCtx = function() {
			$scope.activeElmCx = {};
			$scope.activeElmCx.tag = that.model.atomicInt();
			that.model.currentLigneServMdcal().lstElmCx.put($scope.activeElmCx.tag, $scope.activeElmCx);
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
			$scope.servElmCxGridOptions.data.push($scope.activeElmCx);
			$scope.servElmCxGridApi.grid.modifyRows($scope.servElmCxGridOptions.data);
			$scope.servElmCxGridApi.selection.selectRow($scope.activeElmCx);
		};
		that.pushLieuEnRef = function() {
			setLieuEnRefValues();
			that.model.currentLigneServMdcal().lstLieuEnRef.put($scope.activeLieuEnRef.tag, $scope.activeLieuEnRef);
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
			$scope.servLieuEnRefGridOptions.data.push($scope.activeLieuEnRef);
			$scope.servLieuEnRefGridApi.grid.modifyRows($scope.servLieuEnRefGridOptions.data);
			$scope.servLieuEnRefGridApi.selection.selectRow($scope.activeLieuEnRef);
		};
		
		that.getRoleDesc = function() {
			return that.roleDesc[that.model.currentLigneServMdcal().codRole+''];
		};
		
		that.setRole = function(r) {
			that.model.currentLigneServMdcal().codRole = r;
			that.prevRole = r;
		};
		
		that.validRole = function(){
			var up = that.model.currentLigneServMdcal().codRole>that.prevRole;
			if (angular.isUndefined(that.model.currentLigneServMdcal().codRole) || that.model.currentLigneServMdcal().codRole==null) {
				that.model.currentLigneServMdcal().codRole= that.prevRole ? that.prevRole : 1;
			}
		    var txt = that.model.currentLigneServMdcal().codRole + '';
		    if (txt.length>1) {
		    	that.model.currentLigneServMdcal().codRole = txt.charAt(0);
		    	txt = that.model.currentLigneServMdcal().codRole;
		    }
		    var found = false;
		    var validChars = that.roles[(that.model.currentProf().type==1 ? 0 : 1)]; //List of valid characters
		    var maxVal = that.model.currentProf().type==1 ? 8 : 7; //List of valid characters

		    for(j=0;j<txt.length;j++){ //Will look through the value of text
		        var c = txt.charAt(j);
		        found = false;
		        for(x=0;x<validChars.length;x++){
		            if(c==validChars.charAt(x)){
		            	that.prevRole = that.model.currentLigneServMdcal().codRole;
		                found=true;
		                break;
		            }
		        }
		        if(!found) { 
		        	if (up) {
		        		if (txt<maxVal) {
		        			that.model.currentLigneServMdcal().codRole++;
		        		} else if (txt>maxVal){
		        			that.model.currentLigneServMdcal().codRole--;
		        		}
		        	} else {
		        		if (txt>0) {
		        			that.model.currentLigneServMdcal().codRole--;
		        		}
		        	}
		            //If invalid character is found remove it and return the valid character(s).
		        	that.validRole();
		            break;
		        }
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
		        that.model.saveCurrLigneServMdcalRole();
		    }
		};
		/*
		 * appelé seulement quand on sélectionne un nouveau code. 
		 */
		$scope.setServActiveCodFact = function(c, setCurrentLigne) {
			if (angular.isDefined(c)) {
				//{'id': '1', 'label': 'C.S.S.T.'},{'id': '2', 'label': 'D.D.M.'},{'id': '3', 'label': 'D.P.A.'}
				if (c.csst) {
					if ('0'==$scope.model.currentPatient().typEvenePers || MyNamespace.helpers.isEmpty($scope.model.currentPatient().datEvenePers)) {
						$timeout(function() {
							$scope.model.currentPatient().typEvenePers = '1';
							if ($scope.model.currentPatient().eveAcc) {
								$scope.model.currentPatient().datEvenePers = $scope.model.currentPatient().eveAcc[0];
							}
							$scope.model.typEvenePersUpdated(true);
						}, 1);
					}
				} else if (c.needDDM) {
					if ('2'!=$scope.model.currentPatient().typEvenePers || MyNamespace.helpers.isEmpty($scope.model.currentPatient().datEvenePers)) {
						$timeout(function() {
							$scope.model.currentPatient().typEvenePers = '2';
							if ($scope.model.currentPatient().eveDDM) {
								$scope.model.currentPatient().datEvenePers = $scope.model.currentPatient().eveDDM[0];
							}
							$scope.model.typEvenePersUpdated(true);	// un watch permet de caller un setfocus sur la dateEve
						}, 1);
					}
				} else if (c.needDPA) {
					if ('3'!=$scope.model.currentPatient().typEvenePers || MyNamespace.helpers.isEmpty($scope.model.currentPatient().datEvenePers)) {
						$timeout(function() {
							$scope.model.currentPatient().typEvenePers = '3';
							if ($scope.model.currentPatient().eveDPA) {
								$scope.model.currentPatient().datEvenePers = $scope.model.currentPatient().eveDPA[0];
							}
							$scope.model.typEvenePersUpdated(true);	// un watch permet de caller un setfocus sur la dateEve
						}, 1);
					}					
				}
				
				if (setCurrentLigne) {
					$scope.mustTabInTypPrfsnProfRefre = false;
					var needRef = c.needRefMd||c.needRefInf||c.needRefSagF||c.needRefPharm||c.needRefInt||c.needRefAudio;
					if (c.needRefMd) {
						that.model.currentLigneServMdcal().typPrfsnProfRefre = 1;
					} else if (c.needRefInf) {
						that.model.currentLigneServMdcal().typPrfsnProfRefre = 3;
					} else if (c.needRefSagF) {
						that.model.currentLigneServMdcal().typPrfsnProfRefre = 6;
					} else if (c.needRefAudio) {
						that.model.currentLigneServMdcal().typPrfsnProfRefre = 9;
					} else if (c.needRefPharm) {
						that.model.currentLigneServMdcal().typPrfsnProfRefre = 14;
					} else if (c.needRefInt) {
						$scope.mustTabInTypPrfsnProfRefre = true;
						that.model.currentLigneServMdcal().typPrfsnProfRefre = 14;	// pharmacien le plus fréquent? autres choix possibles...
					}
					if (needRef) {
						that.model.currentLigneServMdcal().typRefreAutreProf = 1;
						that.model.currentLigneServMdcal().typProfRef = 1;
						that.model.currentLigneServMdcal().codTerriProfRefre = 1;
					}
					// en anesthésie, role 2 par défaut, mais parfois le code fact. est slm pour role 1. 
					// j'ai dans le code fact. les roles permis. Vérifiez si role actif est permis, sinon, mettre le 1
					if (that.model.currentLigneServMdcal().codRole!=1 && c.roles.length>0) {
					   var idx = $.inArray(that.model.currentLigneServMdcal().codRole, c.roles);
					   if (idx==-1) {
						   var idx1 = $.inArray(1, c.roles);
						   if (idx1!=-1) {
							   that.model.currentLigneServMdcal().codRole=1;
						   }
					   }
					}
					that.model.currentLigneServMdcal().codFact = c;
					// il faut maintenant afficher les mesur si présent
					var line = that.model.currentLigneServMdcal();
					if (angular.isDefined(line.lstMesur)) {
						line.lstMesur.clear();
					}
				}
				$scope.servActiveMesur = {};
				if (angular.isDefined(c.mapElmMesur)) {
					Object.keys(c.mapElmMesur).forEach(function(key) {
						var elmMesur = c.mapElmMesur[key];
						// codElmMesur, ddEffecElmMesur, nomElmMesur, typUnitMes
						// vérifier si cette mesure est dans currentLigne, si ne l'est pas, l'ajouter.
						var mesure = {};
						mesure.code = elmMesur.codElmMesur;
						mesure.nom = elmMesur.nomElmMesur;
						mesure.unit = elmMesur.typUnitMes;
						mesure.val = 0;
						if (setCurrentLigne) {
							that.model.currentLigneServMdcal().lstMesur.put(mesure.code, mesure);
						}
						if ($.isEmptyObject($scope.servActiveMesur)) {
							// il faut activer une valeur active
							$scope.servActiveMesur = mesure;
						}
					});
			          $scope.servMesurGridOptions.data =  that.model.currentLigneServMdcal().lstMesur.values();
			          $scope.servMesurGridApi.grid.modifyRows($scope.servMesurGridOptions.data);
			          if ($scope.servMesurGridOptions.data.length>0) {
			        	  $scope.servActiveMesur = $scope.servMesurGridOptions.data[0];
			        	  $scope.servMesurGridApi.selection.selectRow($scope.servActiveMesur);
			          } else {
			        	  $scope.servActiveMesur = {};
			          }					
				}
				that.model.saveCurrLigneServMdcalCode();

				var addedCodeChoix = [];	// TODO comment afficher les codes optionnels?
				if (c.addedCodes && c.addedCodes.length>0 && !isAddingAutoCode) {
					isAddingAutoCode=true;
					for (var int = 0; int < c.addedCodes.length; int++) {
						var addedCod = c.addedCodes[int];
						var idClientUid = {'u': clientUid};
						// il faudrait ne pas setter ligne active ici. -a = addedCode
						$http({method : "GET",
							url : "/syra/ligneServMdcal/getNew?u=" + clientUid + "&r=" + addedCod.r + "&c=" + addedCod.c  + "&a=1"
						}).then(function mySucces(response) {
							var line = that.model.validateLigneServMdcal(response.data);
							if (angular.isDefined(line.codFact.c)) {
								// si non defini, cela signifie que le code a ajouter n'était pas permis
								if (angular.isDefined(line.lstTempElmCx)) {
									var elmCxSet = false;
									for (var l = 0; l < line.lstTempElmCx.length; l++) {
										var cx = line.lstTempElmCx[l];
										cx.dirtyStatus = {};
										cx.tag = that.model.atomicInt();
										line.lstElmCx.put(cx.tag, cx);
									}
								}
								line.dirtyStatus = {};
								that.model.currentDemPaimt().serv.lstLigneFact.put(line.noLigne, line);
								that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
								$scope.serviceBillGridOptions.data.push(line);
							}
							isAddingAutoCode=false;
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
							isAddingAutoCode=false;
						});
					}
				}
				
			} else {
				setControllerDefaultValues();
				that.model.currentLigneServMdcal().codFact = {};
			}
		}
		
		that.saveServActiveMesur = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
		}
		that.saveActiveElmCxFact = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstElmCx, true);
		};
		that.saveActiveElmCx = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
		};
		$scope.changeLigneFact = function() {
			if (angular.isDefined(that.model.currentDemPaimt().serv)) {
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
			}
		};
		$scope.changeProfRefConnu = function() {
			if (MyNamespace.helpers.isNotEmpty(that.model.currentLigneServMdcal().idProfRefConnu) && that.model.currentLigneServMdcal().typProfRef===1) {
				delete that.model.currentLigneServMdcal().nomProfRefre;
				delete that.model.currentLigneServMdcal().preProfRefre;
			}
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
		};
		$scope.saveCurrPatientPrn = function() {
			if (that.model.currentPatient().dirtyStatus.val) {
				that.model.postCurrentPatient();
				delete that.model.currentPatient().dirtyStatus.val;
			}
		};
		
		var dateAssist = new DynaDate({elem:"serviceDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, 
			useCurrent: false
			});
		dateAssist.setEditMode = function(v) {
			$scope.serviceDateEditMode = v;
		};
		dateAssist.getDefault = function(){
			return moment(that.model.currentDefault()['dateDefault']);
		};
		dateAssist.onDateSelected = function(selectedDate){
			showJourFerie(that.model.currentLieu(), selectedDate, dateAssist.baseElement);
			updateServiceDate(selectedDate);
		}
		function updateServiceDate(selectedDate){
			if (MyNamespace.helpers.isNotEmpty(selectedDate) && that.model.currentLigneServMdcal().dhdElmFact) {
				var momDeb = moment(that.model.currentLigneServMdcal().dhdElmFact, dhDebut.format);
				if (selectedDate.isAfter(momDeb)) {
					// il faut augmenter dhf avant
					if (that.model.currentLigneServMdcal().dhfElmFact) {
						var momFin = moment(that.model.currentLigneServMdcal().dhfElmFact, dhFin.format);
						var ddFin = dhFin.baseElement.data("DateTimePicker");
						momFin.set('year', selectedDate.get('year'));
						momFin.set('month', selectedDate.get('month'));
						momFin.set('date', selectedDate.get('date'));
						ddFin.date(momFin.toDate());
					}
				}
				var ddDeb = dhDebut.baseElement.data("DateTimePicker");
				momDeb.set('year', selectedDate.get('year'));
				momDeb.set('month', selectedDate.get('month'));
				momDeb.set('date', selectedDate.get('date'));
				ddDeb.date(momDeb.toDate());
				if (selectedDate.isBefore(momDeb)) {
					if (that.model.currentLigneServMdcal().dhfElmFact) {
						var momFin = moment(that.model.currentLigneServMdcal().dhfElmFact, dhFin.format);
						var ddFin = dhFin.baseElement.data("DateTimePicker");
						momFin.set('year', selectedDate.get('year'));
						momFin.set('month', selectedDate.get('month'));
						momFin.set('date', selectedDate.get('date'));
						ddFin.date(momFin.toDate());
					}					
				}
			}
		}
		
		var dhDemConsult = new DynaDate({elem:"dhDemConsult", format: 'YYYY-MM-DD HH:mm', locale:'fr', acceptFutureDate:false, useCurrent: false,
			getDefault: function(){
				return moment(that.model.currentLigneServMdcal().dateServ).hour(8).minute(00);
			}
		});
		$scope.dhDemConsult = function(v) {
			if (arguments.length) {
				that.model.currentLigneServMdcal().dhDemConsult = v;
			} else {
				return that.model.currentLigneServMdcal().dhDemConsult;
			}
		};
		
		that.showCurrentElmCtx = function() {
			if (angular.isDefined(that.model.currentLigneServMdcal()) && angular.isDefined(that.model.currentLigneServMdcal().lstElmCx)) {
				var lineCtx = that.model.currentLigneServMdcal().lstElmCx.values();
				var ctxs = "";
				for (var l = 0; l < lineCtx.length; l++) {
					if (MyNamespace.helpers.isNotEmpty(lineCtx[l]) && MyNamespace.helpers.isNotEmpty(lineCtx[l].c) ) {
						ctxs += lineCtx[l].c+ " ";					
					}
				}
				return ctxs;
			}
			return "";
		};
		that.showCurrentElmCtxTT = function() {
			if (angular.isDefined(that.model.currentLigneServMdcal()) && angular.isDefined(that.model.currentLigneServMdcal().lstElmCx)) {
				var lineCtx = that.model.currentLigneServMdcal().lstElmCx.values();
				var ctxs = "";
				for (var l = 0; l < lineCtx.length; l++) {
					ctxs += (l+1) + ": " + lineCtx[l].d+ "\n";
				}
				return ctxs.length>2 ? ctxs.slice(0, -1) : ctxs;				
			}
			return "";
		};
		
		$scope.$watch(function(scope) {return scope.model.currentDefault()['dateDefault'];},
			function(newVal, oldVal, scope) {
				if (angular.isDefined(newVal) && newVal!==null) {
					$('#serviceDate').data("DateTimePicker").defaultDate(newVal);
				}
				if (angular.isUndefined(scope.model.currentLigneServMdcal().codFact) || angular.isUndefined(scope.model.currentLigneServMdcal().codFact.c)) {
					scope.model.currentLigneServMdcal().dateServ = new moment(newVal).format('YYYY-MM-DD');
					scope.model.saveCurrLigneServMdcalDate();
				}
		});
		
		$scope.billEtabAssist = {assistId: "autocomplete_billEtab", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.activeLieuEnRef.etab) && angular.isDefined($scope.activeLieuEnRef.etab.valEtab)) {
						delete $scope.activeLieuEnRef.etab.valEtab.nomEtab;	// ça permet de savoir que nouveau
					}
					return { url:"/syra/etabl/search",
						data: { k: query, u:clientUid }};
				},
				listWidth: 300,
				nextTabOnEnter: true,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
				selection: function(elem) {
					this.lockEntry();
					//that.setCurrNoEtab(elem.c);
					$http({
						method : "GET",
						url : "/syra/etabl/get?c=" + elem.c +"&u=" + clientUid
					}).then(function mySucces(response) {
						var res = response.data;
						if (angular.isUndefined(res.length)) {
							that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
							$scope.activeLieuEnRef.etab = res;	//un CEtab
			    			var elem = {};
			    			elem.c = res.noSelectedEtab;
							elem.d = res.valEtab.nomEtab+ " (" + res.valEtab.typEtab + '-' + res.valEtab.catgEtab +")";
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					return elem.c;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				},
				updateDataSourceWithValues: function() {
					if ((angular.isUndefined($scope.activeLieuEnRef.etab) || angular.isUndefined($scope.activeLieuEnRef.etab.noSelectedEtab) || ''==$scope.activeLieuEnRef.etab.noSelectedEtab) && that.model.currentLigneServMdcal().codFact.needLieuRef==true) {
						return "50013,50023,50033,50043";
//						[16-09-28 11:39:13] GUYLAINE LAROCHELLE: 50013 ULaval
//						[16-09-28 11:39:30] GUYLAINE LAROCHELLE: 50023 UMontréal
//						[16-09-28 11:39:37] GUYLAINE LAROCHELLE: 50033 McGill
//						[16-09-28 11:39:46] GUYLAINE LAROCHELLE: 50043 USherbrooke
					}
				}
			};
			
		$scope.billSectAssist = {assistId: "autocomplete_billSect", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.activeLieuEnRef.etab) && angular.isDefined($scope.activeLieuEnRef.etab.valSect) && angular.isDefined($scope.activeLieuEnRef.etab.valSect.desSectActiv)) {
						if (query==$scope.activeLieuEnRef.etab.valSect.noSectActiv) return;
						delete $scope.activeLieuEnRef.etab.valSect.desSectActiv;
					}
					return { url:"/syra/secteur/search",
						data: { k: query, u: clientUid }};
				},
				listWidth: 230,
				nextTabOnEnter: false,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:25px;'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
				selection: function(elem) {
					$http({
						method : "GET",
						url : "/syra/secteur/get?c=" + elem.c +"&u=" + clientUid
					}).then(function mySucces(response) {
						if (angular.isUndefined(response.data.length)) {
							$scope.activeLieuEnRef.etab.valSect = response.data;
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					return elem.c;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						this.lockEntry();
						return false;
					}
					return true;
				}
			};
		
		$scope.billLocalAssist = {assistId: "autocomplete_billLocal", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.activeLieuEnRef.local) && angular.isDefined($scope.activeLieuEnRef.local.valCodLocal) && angular.isDefined($scope.activeLieuEnRef.local.valCodLocal.nomLocal)) {
						delete $scope.activeLieuEnRef.local.valCodLocal.nomLocal;
					}
					return { url:"/syra/local/search",
						data: { k: query, u: clientUid }};
				},
				listWidth: 300,
				nextTabOnEnter: false,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
				selection: function(elem) {
					$http({
						method : "GET",
						url : "/syra/local/get?c=" + elem.c +"&u=" + clientUid
					}).then(function mySucces(response) {
						var res = response.data;
						if (angular.isUndefined(res.length)) {
							that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
							if (angular.isUndefined($scope.activeLieuEnRef.local)) {
								$scope.activeLieuEnRef.local = {};
							}
							$scope.activeLieuEnRef.local.valCodLocal = res;
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					return elem.c;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			};
			
		$scope.profAssistOptions = {
			headerHtml: '<button class="btn sm primary" type="button" ng-click="newResident()"><i class="glyphicon glyphicon-user"></i> Nouveau référant</button>', 
			assistId: "autocomplete_profRef",
			alwaysShowHeader: true,
//			trigger: 'Notfocus',
			getAjaxData: function(query){
				if (that.model.currentLigneServMdcal().typProfRef == 1 && 
						that.model.currentLigneServMdcal().codTerriProfRefre==1) {
					return { url:"/syra/referant/search",
						data: { k: query, u: clientUid }};
				} else {
					return {};
				}
			},
			listWidth: 300, descWidth:0,
			nextTabOnTab: true,
			hasHeader: true, hasDetails: false,
			getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.noProf + "</div><div class='divCellCol2'>" + elem.lastName + ", " + elem.firstName + "</div></div></div>";},
			selection: function(elem) {
				this.lockEntry();
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
				that.model.currentLigneServMdcal().preProfRefre = elem.firstName;
				that.model.currentLigneServMdcal().nomProfRefre = elem.lastName;
				that.model.currentLigneServMdcal().idProfRefConnu = elem.noProf;
//				$scope.$apply();
				this.close();
				return elem.noProf;
			}
		}
		
		$scope.newResident = function (){
			$scope.newCityOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "md",
				resolve: {
					mObject: function () {
						return {
							title: "Nouveau Référant",
							templateUrl:"/syra/Resources/views/editProfessional.html",
							modalData: {type : getProfType(model.currentLigneServMdcal().typPrfsnProfRefre).c, isProfTx:'0'}
						};
					}
				}
			});
			
			$scope.modalInstance.result.then(
			function (prof) {
				$scope.newCityOpened = false;
				model.currentLigneServMdcal().idProfRefConnu = prof.noProf;
				that.model.currentLigneServMdcal().nomProfRefre = prof.lastName;
				that.model.currentLigneServMdcal().preProfRefre = prof.firstName;
				that.model.currentLigneServMdcal().typPrfsnProfRefre = parseInt(rof.type);
	        }, function () {
	            $scope.newCityOpened = false;
	        }
	        );
		}
		function getProfType(val){
			for(var i = 0; i < that.typeDeProfessions.list().length; i++){
				if(that.typeDeProfessions.list()[i].r == val)
					return that.typeDeProfessions.list()[i];
			}
		}
		function getAllCodes() {
			var data = that.model.currentDemPaimt().serv.lstLigneFact.values();
			var len = data.length;
			var codes = [];
			for (var i=0;i<len;i++) {
				var line = data[i];
				if (angular.isDefined(line.codFact)) {
					codes.push(line.codFact.c*1);// pour être sur qu'il s'agit bien d'un nombre
				}
			}
			return codes;
		}
		
		$scope.contxtAssist = {assistId: "autocomplete_contxt", 
			listWidth: 400,
			nextTabOnTab: true,
			hasHeader: false, hasDetails: false,
			getAjaxData: function(query){
				if (MyNamespace.helpers.isNotEmpty(query)) {
					if (query==$scope.activeElmCx.c) return;
					delete $scope.activeElmCx.d;	// ça permet de savoir que nouveau code - .d sera undefined si code non trouvé.
					return { url:"/syra/contx/search",
						data: { n: 'L', k: query, u:clientUid }};	// si au niveau de facture, mettre n: 'F'. Voir CodNiveau pour les autres lettres quand déplac.				
				}
				return [];
			},
			getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
			actions: [
                      {key: '=', callback: function(){that.commitServMdcal1(true);} },
                      {key: '+', callback: function(){that.commitServMdcal1(true);} },
                      {key: '-', callback: function(){that.commitServMdcal1(false);} },
                      {key: '_', callback: function(){that.commitServMdcal1(false);} },
			          {key: '187', altKey:true, callback: function(){that.commitServMdcal2();} },//alt+
			          {key: '189', altKey:true, callback: function(){that.commitServMdcal2();} }//alt-
			          // avec altKey true, pour simplifier il vaut mieux avoir la valeur de keycode/which que le charAt(0) 172 pour =
			          ],
			selection : function(elem) {
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
				$scope.activeElmCx.c = elem.c;
				$scope.activeElmCx.d = elem.d;
				return elem.c;
			}
		};
		
		$scope.billCodeAssist = {
			assistId: "autocomplete_code", 
			nextTabOnTab: true,
			nextTabOnEnter: true,
			getAjaxData: function(query){
				if (angular.isDefined(that.model.currentLigneServMdcal().codFact) && MyNamespace.helpers.isNotEmpty(query)) {
					if (query==that.model.currentLigneServMdcal().codFact.c) return;
					delete that.model.currentLigneServMdcal().codFact.d;	// ça permet de savoir que nouveau code - .d sera undefined si code non trouvé.
					return { url:"/syra/codefacturation/search", data: { k: query, u:clientUid }};
				}
				return [];
			},
			listWidth: 500,
			hasHeader: false, hasDetails: false,
			getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
			actions: [
                      {key: '=', callback: function(){that.commitServMdcal1(true);} },
                      {key: '+', callback: function(){that.commitServMdcal1(true);} },
                      {key: '-', callback: function(){that.commitServMdcal1(false);} },
                      {key: '_', callback: function(){that.commitServMdcal1(false);} }
			          ],
			selection: function(elem) {
				var servActiveCodFact = that.model.currentLigneServMdcal().codFact;
				if(!((typeof servActiveCodFact!=='undefined') && (!$.isEmptyObject(servActiveCodFact) && angular.isDefined(servActiveCodFact.c)) )){
					$http({
						method : "GET",
						url : "/syra/codefacturation/get?c=" + elem.c +"&u=" + clientUid
					}).then(function mySucces(response) {
				    	var res = response.data;
				    	if (angular.isUndefined(res.length)) {
							that.model.currentLigneServMdcal().codFact = res;
							that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstLigneFact, true);
				    		$scope.setServActiveCodFact(res, true);
				    	}
					}, function myError(response) {
					});
				}
				return elem.c;
			}
		};

		$scope.contxtFactAssist = {assistId: "autocomplete_contxtFact", 
				hasHeader: false, hasDetails: false,
				getAjaxData: function(query){
				if (angular.isDefined(query) && query!==null && query!=="") {
					delete $scope.activeElmCxFact.codeCtx.d;	// ça permet de savoir que nouveau code
					return { url:"/syra/contx/search",
						data: { n: 'F', k: query, u:clientUid }};	// si au niveau de facture, mettre n: 'F'. Voir CodNiveau pour les autres lettres quand déplac.				
				}
					return [];
				},
				listWidth: 400,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
				selection : function(elem) {
					that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
					$scope.activeElmCxFact.codeCtx.c = elem.c;
					$scope.activeElmCxFact.codeCtx.d = elem.d;
					return elem.c;
				}
			};
			
		that.pushElmCxFact = function() {
			$scope.activeElmCxFact = {};
			$scope.activeElmCxFact.codeCtx = {};
			$scope.activeElmCxFact.tag = that.model.atomicInt();
			that.model.currentDemPaimt().serv.lstElmCx.put($scope.activeElmCxFact, $scope.activeElmCxFact);
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstElmCx, true);
			$scope.elmCxFactGridOptions.data.push($scope.activeElmCxFact);
			$timeout(function () {
				$scope.elmCxFactGridApi.selection.selectRowByVisibleIndex($scope.elmCxFactGridOptions.data.length-1);
				}
			, 50);
		};
				
		// ajoute une ligne de facture.
		that.commitServMdcal1 = function(m){
			var servActiveCodFact = that.model.currentLigneServMdcal().codFact;
			if((typeof servActiveCodFact!=='undefined') && (!$.isEmptyObject(servActiveCodFact) && angular.isDefined(servActiveCodFact.c)) ||
					$scope.model.currentDemPaimt().serv.lstLigneFact.size()==0 ){
				if ($scope.model.currentDemPaimt().serv.lstLigneFact.size()>9) {
					$scope.model.warning("Le maximum de 10 lignes de service a été atteint.");
				} else {
					$scope.focusRoleOnAddInput(true);
					that.pushLigneServMdcal(m);
					$scope.focusCodeOnAddInput();
				}
			}
		}
		
		that.commitServMdcal2 = function(){
			$scope.focusRoleOnAddInput(true);
			that.pushCtx();
			$scope.focusOnElmCtxLineAddInput();
		}
		
		that.commitLieuEnRef = function(){
			$scope.focusRoleOnAddInput(true);
			that.pushLieuEnRef();
			$scope.focusOnLieuEnRefTypLoc();
		}
		
		$scope.servActiveMesurVal = function(v) {
			if (arguments.length) {
				if (typeof v==='undefined') {
					$scope.servActiveMesur.val = newVal;					
				} else {
					var len = v.length;
					var newVal = v;
					if (len>1) {
						var hour =  v.charAt(len - 1);
						if (hour==='H' || hour==='h') {
							newVal = v.substr(0,len-1) * 60;
						}
					} 
					$scope.servActiveMesur.val = newVal;					
				}
			} else {
				return $scope.servActiveMesur.val;
			}
		};
		$scope.dhdElmFact = function(v) {
			if (arguments.length) {
				that.model.currentLigneServMdcal().dhdElmFact = v;
			} else {
				return that.model.currentLigneServMdcal().dhdElmFact;
			}
		};
		$scope.dhfElmFact = function(v) {
			if (arguments.length) {
				that.model.currentLigneServMdcal().dhfElmFact = v;
				if (angular.isDefined($scope.servActiveMesur) && MyNamespace.helpers.isNotEmpty($scope.servActiveMesur.unit) && $scope.servActiveMesur.unit==="MIN") {
					if (that.model.currentLigneServMdcal().dhfElmFact.length==16) {
						var dhDeb = moment(that.model.currentLigneServMdcal().dhdElmFact, 'YYYY-MM-DD HH:mm');
						var dhFin = moment(that.model.currentLigneServMdcal().dhfElmFact, 'YYYY-MM-DD HH:mm');
						var diffMin = dhFin.diff(dhDeb, "minutes");
						if ($scope.servActiveMesur.val==0 && diffMin>0) {
							$scope.servActiveMesur.val = diffMin;
						}
					}
				}
			} else {
				return that.model.currentLigneServMdcal().dhfElmFact;
			}
		};

		$scope.lieuEnRef = {
			typRefreLieu: function(newVal) {
				if (arguments.length) {
					that.model.currentLigneServMdcal().typRefreLieu = newVal;
				} else {
					return that.model.currentLigneServMdcal().typRefreLieu;
				}
			},
			typLocEtab: function(newVal) {
				if (arguments.length) {
					$scope.activeLieuEnRef.typLocEtab = newVal;
				} else {
					return $scope.activeLieuEnRef.typLocEtab;
				}
			},
			// local
			local: function(newVal) {
				if (arguments.length) {
					$scope.activeLieuEnRef.local = newVal;
				} else {
					return $scope.activeLieuEnRef.local;
				}
			},
			typLieuGeo: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.local)) {
					$scope.activeLieuEnRef.local = {};
					$scope.activeLieuEnRef.local.valCodLocal = {};
					}
				if (arguments.length) {
					$scope.activeLieuEnRef.local.typLieuGeo = newVal;
				} else {
					return $scope.activeLieuEnRef.local.typLieuGeo;
				}
			},
			typIdLieuGeo: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.local)) {
					$scope.activeLieuEnRef.local = {};
					$scope.activeLieuEnRef.local.valCodLocal = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.local.typIdLieuGeo = newVal;
				} else {
					return $scope.activeLieuEnRef.local.typIdLieuGeo;
				}
			},
			codLocal: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.local)) {
					$scope.activeLieuEnRef.local = {};
				}
				if (angular.isUndefined($scope.activeLieuEnRef.local.valCodLocal)) {
					$scope.activeLieuEnRef.local.valCodLocal = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.local.valCodLocal.codLocal = newVal;
				} else {
					return $scope.activeLieuEnRef.local.valCodLocal.codLocal;
				}
			},
			codPreciLieuGeo: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.local)) {
					$scope.activeLieuEnRef.local = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.local.codPreciLieu = newVal;
				} else {
					return $scope.activeLieuEnRef.local.codPreciLieu;
				}
			},
			// etab
			etab: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.etab)) {
					$scope.activeLieuEnRef.etab = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.etab = newVal;
				} else {
					return $scope.activeLieuEnRef.etab;
				}
			},
			noSelectedEtab: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.etab)) {
					$scope.activeLieuEnRef.etab = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.etab.noSelectedEtab = newVal;
				} else {
					return $scope.activeLieuEnRef.etab.noSelectedEtab;
				}
			},
			noSectActiv: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.etab)) {
					$scope.activeLieuEnRef.etab = {};
				}
				if (angular.isUndefined($scope.activeLieuEnRef.etab.valSect)) {
					$scope.activeLieuEnRef.etab.valSect = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.etab.valSect.noSectActiv = newVal;
				} else {
					return $scope.activeLieuEnRef.etab.valSect.noSectActiv;
				}
			},
			valSect: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.etab)) {
					$scope.activeLieuEnRef.etab = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.etab.valSect = newVal;
				} else {
					return $scope.activeLieuEnRef.etab.valSect;
				}
			},
			codPreciSectActiv: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.etab)) {
					$scope.activeLieuEnRef.etab = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.etab.codPreciSectActiv = newVal;
				} else {
					return $scope.activeLieuEnRef.etab.codPreciSectActiv;
				}
			},
			codPreciLieuPhys: function(newVal) {
				if (angular.isUndefined($scope.activeLieuEnRef.etab)) {
					$scope.activeLieuEnRef.etab = {};
				}
				if (arguments.length) {
					$scope.activeLieuEnRef.etab.codPreciLieu = newVal;
				} else {
					return $scope.activeLieuEnRef.etab.codPreciLieu;
				}
			}
		};
		//  data-action-key="mesureActions" 
		// nécessaire pour les dh car les minutes sont souvent sans les : avec le mesureActions.
		$scope.dhKeyUp = function(ev) {
			if (ev.keyCode===187 || ev.keyCode===107) {	// =
				$scope.focusRoleOnAddInput(true);
				$timeout(function() {that.commitServMdcal1(true);}, 50);
			} else if (ev.keyCode===189 || ev.keyCode===109) {	// -
				$scope.focusRoleOnAddInput(true);
				$timeout(function() {that.commitServMdcal1(false);}, 50);
			}
		};
		// fonctionne slm ds le dhFin! Ilfaut le keyUp pour le dh Debut.
		$scope.dhKeyPresss = function(ev) {	// data-ng-keypress="dhKeyPresss($event)"
			if (ev.charCode===61 || ev.charCode===43) {
				$scope.focusRoleOnAddInput(true);
				$timeout(function() {that.commitServMdcal1(true);}, 50);
			}
		};
        $scope.mesureActions = [
                              {key: '=', callback: function(){that.commitServMdcal1(true);}},
		                      {key: '+', callback: function(){that.commitServMdcal1(true);}},
		                      {key: '-', callback: function(){that.commitServMdcal1(false);}},
		                      {key: '_', callback: function(){that.commitServMdcal1(false);}},
		  			          {key: '187', altKey:true, callback: function(){that.commitServMdcal1(true);}},//alt+
					          {key: '189', altKey:true, callback: function(){that.commitServMdcal1(false);}}//alt-
		                       ];

        that.commitElmCxFact = function(){
			$scope.focusRoleOnAddInput(true);
			that.pushElmCxFact();
			$scope.focusOnElmElmCxFactAddInput();
        };

	    var cellTemplateNoLigne = '<div class="ui-grid-cell-contents" ng-hide="row.entity.noLigne>10">{{row.entity.noLigne}}</div>';
		
		$scope.serviceBillGridOptions = {
				data: [],
				enableHorizontalScrollbar : 0,
				enableMinHeightCheck:false,
				multiSelect: false,
				enableSorting:false,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				saveScroll: false,
				enableColumnMenus:false,
				enableHiding: false,
				headerTooltip: true,
				modifierKeysToMultiSelect: false,
				noUnselect: false,
				appScopeProvider: that,
				columnDefs: [
				             { name: 'noLigne', displayName: 'L', sort: {
				            	    direction: uiGridConstants.ASC,
				            	    ignoreSort: false,
				            	    priority: 0
				            	   }, cellTemplate: cellTemplateNoLigne, width: "24"},
							 { name: 'dateServ', displayName: 'Date', width: "14%"},
							 { name: 'codRole', displayName: 'R', width: "2%"},
							 { name: 'codFact.c', displayName: 'Code', cellTooltip: function(row, col){return row.entity.codFact.d}, width: "9%"},
							 { name: 'dhdElmFact', displayName: 'Debut', width: "21%"},
							 { name: 'dhfElmFact', displayName: 'Fin', width: "21%"},
							 { name: 'indexProf', cellClass: 'ui-grid-vcenter',  cellTemplate: '<div>{{grid.appScope.showMdRef(row)}}</div>', displayName: 'Med. Réf.'},
							 { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
								 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteMedService(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
							]
		};

		$scope.serviceBillGridOptions.onRegisterApi = function(gridApi){
	        //set gridApi on scope
			if (!$scope.serviceBillGridApi) {
		        $scope.serviceBillGridApi = gridApi;
		        gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.serviceBillGridApi.selection.selectRow(that.model.currentLigneServMdcal());
                }, [uiGridConstants.dataChange.ROW]);
		        
		        gridApi.selection.on.rowSelectionChanged($scope,function(row){
		          that.model.setCurrLigneServMdcal(row.entity, false);
		          that.prevRole = that.model.currentLigneServMdcal().codRole;
		          
		          $scope.servElmCxGridOptions.data =  that.model.currentLigneServMdcal().lstElmCx.values();
		          $scope.servElmCxGridApi.grid.modifyRows($scope.servElmCxGridOptions.data);
		          if ($scope.servElmCxGridOptions.data.length>0) {
		        	  $scope.activeElmCx = $scope.servElmCxGridOptions.data[0];
		        	  $scope.servElmCxGridApi.selection.selectRow($scope.activeElmCx);
		          } else {
		        	  $scope.activeElmCx = {};
		          }
		          
		          $scope.servLieuEnRefGridOptions.data =  that.model.currentLigneServMdcal().lstLieuEnRef.values();
		          $scope.servLieuEnRefGridApi.grid.modifyRows($scope.servLieuEnRefGridOptions.data);
		          if ($scope.servLieuEnRefGridOptions.data.length>0) {
		        	  $scope.activeLieuEnRef = $scope.servLieuEnRefGridOptions.data[0];
		        	  $scope.servLieuEnRefGridApi.selection.selectRow($scope.activeLieuEnRef);
		          } else {
		        	  setLieuEnRefValues();
		          }
		          
		          $scope.servMesurGridOptions.data =  that.model.currentLigneServMdcal().lstMesur.values();
		          $scope.servMesurGridApi.grid.modifyRows($scope.servMesurGridOptions.data);
		          if ($scope.servMesurGridOptions.data.length>0) {
		        	  $scope.servActiveMesur = $scope.servMesurGridOptions.data[0];
		        	  $scope.servMesurGridApi.selection.selectRow($scope.servActiveMesur);
		          } else {
		        	  $scope.servActiveMesur = {};
		          }
		        });
				gridApi.cellNav.on.navigate($scope,function(newRowCol, oldRowCol){
					$scope.serviceBillGridApi.selection.selectRow(newRowCol.row.entity);
				});	        
			}
	     };
		that.deleteMedService = function(row) {
			$scope.serviceBillGridApi.core.setRowInvisible(row);
			that.model.removeLigneServMdcalFromLst(row.entity, false);
			// that.model.currentDemPaimt().serv.lstLigneFact.remove(row.entity.noLigne);
			that.model.setDirtyStatus(model.currentDemPaimt().serv.lstLigneFact, true);
			var noLigne = row.entity.noLigne;
			// timeout nécessaire car le ui doit avoir le temps de faire un refresh avant de caller selectRowByVisibleIndex
			$timeout(function () {
				$scope.serviceBillGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.serviceBillGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || noLigne==selectedRows[0].noLigne) {
					that.model.setCurrLigneServMdcalNull();
					$scope.setServActiveCodFact();// sans paramètre, ça reset les valeurs
				}
            }, 10);
		};
		that.showMdRef = function(row) {
			if (row.entity.typProfRef===1 && MyNamespace.helpers.isNotEmpty(row.entity.idProfRefConnu)) {
				return row.entity.idProfRefConnu;
			} else if (row.entity.typProfRef===2 && MyNamespace.helpers.isNotEmpty(row.entity.nomProfRefre)) {
				return row.entity.nomProfRefre + ' ' + row.entity.preProfRefre;
			}
			return '';
		};
		
		var addingAutoCodeArray = [];
		// quand pt selected is inscrit and md is md de famille
		$scope.$watch(
			function (scope) {return scope.model.ptInscritAndMdFamUpdated().val;},
			function(newVal, oldVal, scope) {
//			$log.log("newVal et oldVal... devrait ajouter 8875? ->" + newVal + "," + oldVal);
			var code = 8875;
			if (newVal>oldVal && $.inArray(code,addingAutoCodeArray)==-1) {
				if (!MyNamespace.helpers.isObject(scope.model.currentLigneServMdcal().codFact) || MyNamespace.helpers.isEmpty(scope.model.currentLigneServMdcal().codFact.c)) {
					// ne se fait pas si a deja un code ici - équivaut à une nouvelle facture
					addingAutoCodeArray.push(code);
//					$log.log("devrait ajouter 8875");
					var allCode = getAllCodes();
					if ($.inArray(code,allCode)==-1) {
//						$log.log("il ajoute le 8875");
						var codFact = {};
						codFact.c = code;
						scope.setServActiveCodFact(codFact, true);
						// timeout nécessaire sinon il garde le code dans la nouvelle ligne.
						$timeout(function() {
							that.pushLigneServMdcal(false);
//							_.without(addingAutoCodeArray, code);
							var idx = $.inArray(code, addingAutoCodeArray);
							if (idx!=-1) {addingAutoCodeArray.splice(idx,1);}
//							addingAutoCodeArray = $.grep(addingAutoCodeArray, function (val) { return val != code ; });
						},250);
					} else {
						var idx = $.inArray(code, addingAutoCodeArray);
						if (idx!=-1) {addingAutoCodeArray.splice(idx,1);}
//						_.without(addingAutoCodeArray, code);
					}
				}				
			}
		});
		// watch nécessaire pour updater quand on change de facture
		$scope.$watch(function (scope) {return scope.model.currDemPaimtUpdated().val;},
	      function(newVal, oldVal, scope) {
			if (angular.isDefined(that.model.currentDemPaimt().serv)) {
				if (angular.isDefined(that.model.currentDemPaimt().serv.lstLigneFact) && (typeof that.model.currentDemPaimt().serv.lstLigneFact.values == 'function')) {
					scope.serviceBillGridOptions.data =  that.model.currentDemPaimt().serv.lstLigneFact.values();
					scope.serviceBillGridApi.grid.modifyRows(scope.serviceBillGridOptions.data);
					if (scope.serviceBillGridOptions.data.length>0) {
						scope.serviceBillGridApi.selection.selectRow(that.model.currentLigneServMdcal());
					}
				 	that.model.focusOnCode(function() {
				 		$scope.focusCodeOnAddInput();
				 	});					
				}
				if (angular.isDefined(that.model.currentDemPaimt().serv.lstElmCx) && (typeof that.model.currentDemPaimt().serv.lstElmCx.values == 'function')) {
					scope.elmCxFactGridOptions.data =  that.model.currentDemPaimt().serv.lstElmCx.values();
					scope.elmCxFactGridApi.grid.modifyRows(scope.elmCxFactGridOptions.data);
					if (scope.elmCxFactGridOptions.data.length>0) {
						scope.elmCxFactGridApi.selection.selectRowByVisibleIndex(0);
					}
				}
			}
		});
		// watch nécessaire pour updater quand on efface une ligne
		$scope.$watch(function (scope) {return scope.model.lstLigneFactServMdcalDelUpdated().val;},
				function(newVal, oldVal, scope) {
			if (newVal>0 && angular.isDefined(that.model.currentDemPaimt().serv)) {
				if (angular.isDefined(that.model.currentDemPaimt().serv.lstLigneFact) && (typeof that.model.currentDemPaimt().serv.lstLigneFact.values == 'function')) {
					MyNamespace.helpers.removeWithNoLigne(newVal, scope.serviceBillGridOptions.data);
					scope.serviceBillGridApi.grid.modifyRows(scope.serviceBillGridOptions.data);
				}
				scope.model.lstLigneFactServMdcalDelUpdated(0);
			}
		});
		
		// watch nécessaire pour retour règle de plaf.
		$scope.$watch(function (scope) {return scope.model.reglePlafValid().val;},
				function(newVal, oldVal, scope) {
			if (newVal>0 && angular.isDefined(that.model.currentDemPaimt().reglePlaf)) {
				that.model.currentDemPaimt().validRP = {};	// si on doit re-valider
				that.model.currentDemPaimt().validCR = {};	// le code de rech (code: cr)
				that.model.currentDemPaimt().validEC = {};	// l'elm ctx (code:ec)
				// pour dire au backend si on doit valider ou non.
				for (var code in that.model.currentDemPaimt().reglePlaf) {
				    if (that.model.currentDemPaimt().reglePlaf.hasOwnProperty(code)) {
				    	that.model.currentDemPaimt().validRP[code] = 1;
				    }
				}
				scope.modalInstance = $uibModal.open({
					animation: $scope.animationsEnabled,
					templateUrl: "/syra/Resources/views/modal.html",
					controller: 'ModalInstanceCtrl',
					size: "lg",
					resolve: {
						mObject: function () {
							return {
								title: "RÈGLES D'APPLICATION ET PLAFONNEMENTS",
								templateUrl:"/syra/Resources/views/showReglePlaf.html",
								message: that.model.currentDemPaimt().reglePlafMsg, // message avec le(s) code(s) plaf.
								reglePlaf: that.model.currentDemPaimt().reglePlaf,	// les règles de plaf.
								validRP: that.model.currentDemPaimt().validRP,
								validCR: that.model.currentDemPaimt().validCR,
								validEC: that.model.currentDemPaimt().validEC,
								changeIG: function(c) {
									if (that.model.currentDemPaimt().validRP[c]==0) {
										that.model.currentDemPaimt().validCR[c]='';
										that.model.currentDemPaimt().validEC[c]='';
									}
								},
								changeCR: function(c) {
									if (that.model.currentDemPaimt().validCR[c]!='') {
										that.model.currentDemPaimt().validEC[c]='';
										that.model.currentDemPaimt().validRP[c]=1;
									}
								},
								changeEC: function(c) {
									if (that.model.currentDemPaimt().validEC[c]!='') {
										that.model.currentDemPaimt().validCR[c]='';
										that.model.currentDemPaimt().validRP[c]=1;
									}
								},
								cancel: function () {
									$scope.modalInstance.close();
								},
								saveBill: function () {
									applyChangesReglePlaf(that.model.currentDemPaimt().reglePlaf, that.model.currentDemPaimt().validRP, that.model.currentDemPaimt().validCR, that.model.currentDemPaimt().validEC);
									$scope.modalInstance.close();
									if (that.model.canSaveBill()) {
										that.model.saveBill();
									}
								},
								saveAndAddBill: function () {
									applyChangesReglePlaf(that.model.currentDemPaimt().reglePlaf, that.model.currentDemPaimt().validRP, that.model.currentDemPaimt().validCR, that.model.currentDemPaimt().validEC);
									$scope.modalInstance.close();
									if (that.model.canSaveBill()) {
										that.model.calledAddBill(true);
										that.model.saveBill();
									}
								}
							};
						}
					}
				});

				scope.modalInstance.result.then(function () {
					for (var valid in that.model.currentDemPaimt().validRP) {
						//$log.log(valid + ":" + that.model.currentDemPaimt().validRP[valid]);
					}
				}, function () {
					//$log.log("result next then... ");
					for (var valid in that.model.currentDemPaimt().validRP) {
						//$log.log(valid + ":" + that.model.currentDemPaimt().validRP[valid]);
					}
				});
			}
		});
		
		$scope.$watch(function (scope) {return scope.model.lstLigneFactServMdcalModUpdated().val;},
				function(newVal, oldVal, scope) {
			if (MyNamespace.helpers.isNotEmpty(newVal.noLigne) &&  angular.isDefined(that.model.currentDemPaimt().serv)) {
				if (angular.isDefined(that.model.currentDemPaimt().serv.lstLigneFact) && (typeof that.model.currentDemPaimt().serv.lstLigneFact.values == 'function')) {
					modifyLigneServMdcalModCtx(newVal, scope.serviceBillGridOptions.data);
					scope.serviceBillGridApi.grid.modifyRows(scope.serviceBillGridOptions.data);
					scope.model.lstLigneFactServMdcalModUpdated({});
				}
			}
		});
		
		function applyChangesReglePlaf(reglePlaf, validRP, validCR, validEC) {
			for (var code in reglePlaf) {
			    if (reglePlaf.hasOwnProperty(code)) {
			    	var codeData = that.model.currentDemPaimt().reglePlaf[code];
					for (var i = 0; i < codeData.length; i++) {
						var lf = codeData[i].lf;
						var codePlaf = lf.c;
						var rp = codeData[i].rp;
						var codPlafRech = rp.crObj;
						var cr = validCR[codePlaf];
						var ec = validEC[codePlaf];
						if (MyNamespace.helpers.isNotEmpty(cr)) {
							// $log.log("would change " + codePlaf + " with " + cr);
							for (var l in $scope.serviceBillGridOptions.data) {
								var line = $scope.serviceBillGridOptions.data[l];
								//$log.log(line);
								if (line.codFact.c==codePlaf) {
									line.codFact = codPlafRech;
								}
							}
							$scope.serviceBillGridApi.grid.modifyRows($scope.serviceBillGridOptions.data);
						} else if (MyNamespace.helpers.isNotEmpty(ec)) {
							//$log.log("would add EC " + ec + " to the code " + codePlaf);
							$scope.serviceBillGridApi.selection.clearSelectedRows();	// je dois delectionner pour refresh de la liste elmctx
							that.model.setCurrLigneServMdcalNull();
							$scope.setServActiveCodFact();// sans paramètre, ça reset les valeurs
							for (var l in $scope.serviceBillGridOptions.data) {
								var line = $scope.serviceBillGridOptions.data[l];
								//$log.log(line);
								if (line.codFact.c==codePlaf) {									
								   if (angular.isUndefined(line.lstElmCx)) {
									   line.lstElmCx = new Hashtable({ hashCode: tagHash });
								   }
									var alreadyThere = false;
									var lstElmCtx = line.lstElmCx.values();
									for (var cc in lstElmCtx) {
										if (lstElmCtx[cc].c==ec) {
											alreadyThere = true;
											break;
										}
									}
									if (!alreadyThere) {
										var ctx = rp.mapEC[ec];								   
										ctx.tag = model.atomicInt();
										line.lstElmCx.put(ctx.tag, ctx);
									}	
								}
							}
						}
					}
			    }
			}
		}
	
		function modifyLigneServMdcalModCtx(l, arr) {
		   for (var o in arr) {
			   if (arr[o].noLigne==l.noLigne) {
				   if (angular.isUndefined(arr[o].lstElmCx)) {
					   arr[o].lstElmCx = new Hashtable({ hashCode: tagHash });
				   }
					if (angular.isDefined(l.lstTempElmCx)) {
						for (var j = 0; j < l.lstTempElmCx.length; j++) {
							var ctx = l.lstTempElmCx[j];
							if (angular.isDefined(ctx.c) && ctx.c!='') {
								ctx.dirtyStatus = {};
								var alreadyThere = false;
								var lstElmCtx = arr[o].lstElmCx.values();
								for (var cc in lstElmCtx) {
									if (lstElmCtx[cc].c==ctx.c) {
										alreadyThere = true;
										break;
									}
								}
								if (!alreadyThere) {
									ctx.tag = model.atomicInt();
									arr[o].lstElmCx.put(ctx.tag, ctx);
								}
							}
						}
					}
			   }
		   }
	   }
		
		$scope.servElmCxGridOptions = {
				data: [],
				enableHorizontalScrollbar : 0,
//			    enableVerticalScrollbar : 0,
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
							 { name: 'c', displayName: 'Cx', cellTooltip: function(row, col){return row.entity.d}},
							 { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
								 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteContx(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
							]
		};
		
		$scope.servElmCxGridOptions.onRegisterApi = function(gridApi){
	        //set gridApi on scope
			if (!$scope.servElmCxGridApi) {
		        $scope.servElmCxGridApi = gridApi;
		        gridApi.grid.registerDataChangeCallback(function(data) {
		        	$scope.servElmCxGridApi.selection.selectRow($scope.activeElmCx);
		        }, [uiGridConstants.dataChange.ROW]);
		        
		        gridApi.selection.on.rowSelectionChanged($scope,function(row){
		        	$scope.activeElmCx = row.entity;
		        });
			}
	     };
		
		that.deleteContx = function(row) {
			$scope.servElmCxGridApi.core.setRowInvisible(row);
			var removed = that.model.currentLigneServMdcal().lstElmCx.remove(row.entity.tag);
			that.model.setDirtyStatus(model.currentDemPaimt().serv.lstLigneFact, true);
			var tag = row.entity.tag;
			// timeout nécessaire car le ui doit avoir le temps de faire un refresh avant de caller selectRowByVisibleIndex
			$timeout(function () {
				$scope.servElmCxGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.servElmCxGridApi.selection.getSelectedRows();
					if (angular.isUndefined(selectedRows) || selectedRows.length==0 || tag==selectedRows[0].tag) {
						$scope.activeElmCx = {};
				}
            }, 0,1);			
		};

		$scope.servLieuEnRefGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableHorizontalScrollbar : 0,
			    enableVerticalScrollbar : 0,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'local.valCodLocal.codLocal', displayName: 'Loc', width: "42%"},
				             { name: 'etab.noSelectedEtab', displayName: 'Eta', width: "42%"},
				             { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteLieuEnRef(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
				            	 ]
		};
		$scope.servLieuEnRefGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.servLieuEnRefGridApi) {
				$scope.servLieuEnRefGridApi = gridApi;
				gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.servLieuEnRefGridApi.selection.selectRow($scope.activeLieuEnRef);
				}, [uiGridConstants.dataChange.ROW]);
				
				gridApi.selection.on.rowSelectionChanged($scope,function(row){
					$scope.activeLieuEnRef = row.entity;
				});
			}
		};
		that.deleteLieuEnRef = function(row) {
			$scope.servLieuEnRefGridApi.core.setRowInvisible(row);
			var removed = that.model.currentLigneServMdcal().lstLieuEnRef.remove(row.entity.tag);
			that.model.setDirtyStatus(model.currentDemPaimt().serv.lstLigneFact, true);
			var tag = row.entity.tag;
			$timeout(function () {
				$scope.servLieuEnRefGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.servLieuEnRefGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || tag==selectedRows[0].tag) {
					setLieuEnRefValues();
				}
			}, 10);			
		};
		
		$scope.servMesurGridOptions = {
				data: [],
				enableHorizontalScrollbar : 0,
			    enableVerticalScrollbar : 0,
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: false,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'unit', displayName: 'Unité', cellTooltip: function(row, col){return row.entity.nom}, width: "50%"},
				             { name: 'val', displayName: 'Valeur', width: "50%"},
			            	]
		};
		$scope.servMesurGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.servMesurGridApi) {
				$scope.servMesurGridApi = gridApi;
				gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.servMesurGridApi.selection.selectRow($scope.servActiveMesur);
				}, [uiGridConstants.dataChange.ROW]);
				
				gridApi.selection.on.rowSelectionChanged($scope,function(row){
					$scope.servActiveMesur = row.entity;
				});
			}
	     };
		$scope.elmCxFactGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableHorizontalScrollbar : 0,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
							 { name: 'codeCtx.c', displayName: 'Contexte', cellTooltip: function(row, col){return row.entity.codeCtx.d}, width: "40%"},
							 { name: 'codeLie', displayName: 'Code lié'},
							 { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
								 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteContxFact(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
							]
		};
		
		$scope.elmCxFactGridOptions.onRegisterApi = function(gridApi){
	        //set gridApi on scope
			if (!$scope.elmCxFactGridApi) {
		        $scope.elmCxFactGridApi = gridApi;
		        $scope.elmCxFactGridApi.grid.registerDataChangeCallback(function(data) {
					$scope.elmCxFactGridApi.selection.selectRow($scope.activeElmCxFact);
		        }, [uiGridConstants.dataChange.ROW]);
		        
		        $scope.elmCxFactGridApi.selection.on.rowSelectionChanged($scope, function(row){
		        	$scope.activeElmCxFact = row.entity;
		        });
			}
	     };
		
		that.deleteContxFact = function(row) {
			$scope.elmCxFactGridApi.core.setRowInvisible(row);
			that.model.currentDemPaimt().serv.lstElmCx.remove(row.entity);
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstElmCx, true);
			var tag = row.entity.tag;
			// timeout nécessaire car le ui doit avoir le temps de faire un refresh avant de caller selectRowByVisibleIndex
			$timeout(function () {
				$scope.elmCxFactGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.elmCxFactGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || tag==selectedRows[0].tag) {
					$scope.activeElmCxFact = {};
					$scope.activeElmCxFact.codeCtx = {};	// contient c et d
				}
            }, 10);			
		};
	     
	 	this.hello = function(m) {
			new jBox('Notice', {
				color : 'green',
				content: m,
				attributes: {
					x: 'right',
					y: 'bottom'
				}
			});
		}	
			     
	}]);
		
	// ------------------------------------------------------
	// ------------------- FRAIS DE TRANSPORT ---------------
	// ------------------------------------------------------
	billEntry.service('TransportFeeEntryService', function(){
		this.feeType = 1;
		this.feeTypes = [{id: 1, label: 'Frais de transport'}, {id: 2, label: 'Temps de déplacement'},
		                 {id: 3, label: 'Forfait de déplacement'}, {id: 4, label: 'Frais de séjour'}];
		this.codifies = [
	                      {'id': 'C', 'label': 'Physique'},
	                      {'id': 'N', 'label': 'Géographique'}
		                ]; // pref 'TYP_LOC_ETAB':'typ_loc_etab'
	    this.typIdLieuxGeo = [
	                             {'id': '2', 'label': "Code postal"},
	                             {'id': '3', 'label': "Code localité"}
	                             ];
		this.fraisSejs = [
		                 {'id': '5', 'label': 'Hôtel'}
		                 ];
		
		this.fraisTrsps = [
		                      {'id': 1, 'label': 'Autobus'},
		                      {'id': 2, 'label': 'Covoiturage'},
		                      {'id': 3, 'label': 'Taxi'},
		                      {'id': 4, 'label': 'Train'},
		                      {'id': 5, 'label': 'Traversier'},
		                      {'id': 6, 'label': 'Véhicule loué'},
		                      {'id': 7, 'label': 'Véhicule personnel'},
		                      {'id': 8, 'label': 'Vol commercial'},
		                      {'id': 9, 'label': 'Vol personnel'},
		                      {'id': 10, 'label': 'Vol nolisé'},
		                      {'id': 99, 'label': 'Autre'}
	                      ];

		this.fraisTrspTypes = [
		                 {'id': '1', 'label': 'Frais de location de véhicule'},
		                 {'id': '2', 'label': "Frais d'essence"},
		                 {'id': '3', 'label': 'Frais de stationnement'},
		                 {'id': '4', 'label': 'Frais général'},
		                 {'id': '99', 'label': 'Autre'}
		                 ];
	});
	billEntry.filter('transportMeansById', function(TransportFeeEntryService) {
		return function(input, list) {
			switch(list){
				case 'fraisSejs':
					for(var i = 0; i < TransportFeeEntryService.fraisSejs.length; i++){
						if(TransportFeeEntryService.fraisSejs[i].id === input)
							return TransportFeeEntryService.fraisSejs[i].label;
					}
					return input;
				case 'fraisTrsps':
					if(input == 99)input = TransportFeeEntryService.fraisTrsps.length;
					var r = TransportFeeEntryService.fraisTrsps[input-1];
					if (r) return r.label;
					return input
				case 'fraisTrspTypes': 
					if(input == '99')input = TransportFeeEntryService.fraisTrspTypes.length;
					var r = TransportFeeEntryService.fraisTrspTypes[input-1];				
					if (r) return r.label;
					return input
				case 'typEvenePers': 
					if(input == 1)return 'CSST';
					if(input == 2)return 'DDM';
					if(input == 3)return 'DPA';
					return '';				
			}
		};
	});

	billEntry.filter('codTerriProfRefres', function() {
		return function(input) {
			var items = [
	            {'id': 1, 'label': 'Québec'},
	            {'id': 2, 'label': 'Hors Québec'}
			];
			for(var i = 0; i < items.length; i++){
				if(items[i].id === input)
					return items[i].label;
			}
			return input;
		};
	});
	billEntry.filter('territoiresLE171', function() {
		return function(input) {
			var items = [
	            {'id': '0', 'label': 'Sans objet'},
	            {'id': '1', 'label': '1. Bas-St-Laurent, Côte-Nord, Gaspésie-Îles-de-la-Madeleine'},
	            {'id': '2', 'label': '2. Saguenay-Lac-St-Jean, Nord-du-Québec'},
	            {'id': '3', 'label': '3. Capitale-Nationale, Estrie, Chaudière-Appalaches'},
	            {'id': '4', 'label': '4. Mauricie et Centre-du-Québec'},
	            {'id': '5', 'label': '5. Montréal incluant le Nunavik, Terres-Cries-de-la-Baie-James'},
	            {'id': '6', 'label': '6. Montréal, Outaouais'},
	            {'id': '7', 'label': '7. Abitibi-Témiscamingue'},
	            {'id': '8', 'label': '8. Laval, Lanaudière, Laurentides'},
	            {'id': '9', 'label': '9. Montérégie'},
	            {'id': '10', 'label': "10. L'ensemble des territoires du Québec pour couvrir de façon exclusive les autopsies de nature pédiatrique-Montréal"}
	         ];
			for(var i = 0; i < items.length; i++){
				if(items[i].id === input)
					return items[i].label;
			}
			return input;
		};
	});
	billEntry.filter('typIdLieuxGeo', function() {
		return function(input) {
			var items = [
	         {'id': '2', 'label': "Code postal"},
	         {'id': '3', 'label': "Code localité"},
	         {'id': '4', 'label': "Territoire LE 171"},
	         {'id': '5', 'label': "Territoire suprarégional"}
	         ];
			for(var i = 0; i < items.length; i++){
				if(items[i].id === input)
					return items[i].label;
			}
			return input;
		};
	});
	
	billEntry.filter('codPreciLieux', function() {
		return function(input) {
			var items = [
             {'id': '0', 'label': "S/O"},
             {'id': 'L', 'label': "Local sous gestion du gouvernement ou d'un organisme qu'il subventionne"}
			];
			for(var i = 0; i < items.length; i++){
				if(items[i].id === input)
					return items[i].label;
			}
			return input;
		};
	});
	billEntry.filter('codPreciSectActivs', function() {
		return function(input) {
			var items = [
			             {'id': 0, 'label': "S/O"},
			             {'id': 1, 'label': "Salle d'opération"},
			             {'id': 2, 'label': "Au chevet du patient"}
			             ];
			for(var i = 0; i < items.length; i++){
				if(items[i].id === input)
					return items[i].label;
			}
			return input;
		};
	});
	billEntry.filter('typRefreLieux', function() {
		return function(input) {
			var typRefreLieux = [
			                     {'id': 3, 'label': 'Lieu pour lequel la garde à distance est effectuée (LE 128)'},
			                     {'id': 4, 'label': 'Lieu duquel origine la consultation à distance'},
			                     {'id': 5, 'label': 'Université affiliée'},
			                     {'id': 6, 'label': 'Lieu où se trouve le patient (télémédecine)'},
			                     {'id': 7, 'label': 'Territoire pour garde en disponibilité pour les autopsies à la demande du coroner (LE 171)'},
			                     {'id': 8, 'label': 'Lieu où la technique a été effectuée (radiologie)'},
			                     {'id': 9, 'label': 'Autre lieu pour lequel des activités de soutien sur place, ont été effectuées (Annexe 42)'},
			                     {'id': 10, 'label': "Établissements pris en charge lors d'une garde multi-établissements (Annexe 25)"},
			                     {'id': 11, 'label': "Territoire suprarégional pris en charge lors d'une garde en disponibilité en téléthrombolyse"},
			                     {'id': 12, 'label': 'Lieu de départ pour service rendu à domicile'},
			                     {'id': 13, 'label': 'Lieu de transfert du patient'},
			                     {'id': 99, 'label': 'Lieu où le service est rendu par le professionnel'},
			                     ];
			for(var i = 0; i < typRefreLieux.length; i++){
				if(typRefreLieux[i].id === input)
					return typRefreLieux[i].label;
			}
			return input;
		};
	});
	billEntry.filter('prefixsufix', function() {
		return function(input, pref, before) {
			if(!angular.isDefined(input))return '';
			if(angular.isDefined(before)&& before)return pref +' '+ input;
			return input +' '+ pref;
		};
	});
	
	billEntry.controller('TransportFeeEntryController', ['$scope', '$http', '$log', '$timeout', 'uiGridConstants', 'TransportFeeEntryService', 'clientUid','model', '$confirm', 
	                                                     function($scope, $http, $log, $timeout, uiGridConstants, TransportFeeEntryService, clientUid, model, $confirm){
		this.entry = {};
		this.model = model;
		var that = this;
		function tagHash(a) {
			return a.tag;
		}
		
		that.codifies = TransportFeeEntryService.codifies; // pref 'TYP_LOC_ETAB':'typ_loc_etab'
		that.typIdLieuxGeo = TransportFeeEntryService.typIdLieuxGeo;
		
		that.fraisSejs = TransportFeeEntryService.fraisSejs;
		
		that.fraisTrsps = TransportFeeEntryService.fraisTrsps;

		that.fraisTrspTypes = TransportFeeEntryService.fraisTrspTypes;
		
		// pour n'Avoir qu'une directive pour etab et local pour lieuEnRef, lieuArr et LieuDep
		$scope.activeLieuEtab = {};
		$scope.activeLieuLocal = {};
		$scope.setActiveLieuEtab = function(l) {
			$scope.activeLieuEtab = l;			
		};
		$scope.setActiveLieuLocal = function(l) {
			$scope.activeLieuLocal = l;
		};
		
		$scope.fraisTrsp = {};
		$scope.tpsDepl = {};
		$scope.fraisSej = {};
		$scope.frfDepl = {};
//		$scope.fraisTrsp = that.model.currentLigneFraisTrsp();
//		$scope.tpsDepl = that.model.currentLigneTempsDepla()
//		$scope.fraisSej = that.model.currentLigneFraisSej()
//		$scope.frfDepl = that.model.currentLigneForfDepla();
		
		$scope.fraisTrspType = {};
		$scope.activeElmCx = {};
		$scope.elmCx = {};
		$scope.fraisTrsp.dirtyStatus = {};
		$scope.fraisTrsp.lstFrais = new Hashtable({ hashCode: tagHash });
		$scope.fraisTrsp.elmCx = {};
		$scope.fraisTrsp.lstElmCx = new Hashtable({ hashCode: tagHash });
		$scope.tpsDepl.dirtyStatus = {};
		$scope.tpsDepl.elmCx = {};
		$scope.tpsDepl.lstElmCx = new Hashtable({ hashCode: tagHash });
		$scope.fraisSej.frais = {};
		$scope.fraisSej.dirtyStatus = {};
		$scope.fraisSej.elmCx = {};
		$scope.fraisSej.lstElmCx = new Hashtable({ hashCode: tagHash });
		$scope.frfDepl.dirtyStatus = {};
		$scope.frfDepl.elmCx = {};
		$scope.frfDepl.lstElmCx = new Hashtable({ hashCode: tagHash });
		that.commitActiveElmCx = function(){};
		that.setActiveElmCx = function(l, f) {
			$scope.activeElmCx = l;
			that.commitActiveElmCx = f;
		};
		that.commitElmCx = function() {
			$scope.btnElmCx(true);
			$timeout(function(){that.pushCtx();},10,1);
			$timeout(function(){$scope.focusOnElmCtxAddInput();},200,1);
		};
		that.commitElmCxFt = function() {
			$scope.btnElmCxFt(true);
			$timeout(function(){that.pushCtxFt();},10,1);
			$timeout(function(){$scope.focusOnElmCtxFtAddInput();},200,1);
		};
		that.commitElmCxTd = function() {
			$scope.btnElmCxTd(true);
			$timeout(function(){that.pushCtxTd();},10,1);
			$timeout(function(){$scope.focusOnElmCtxTdAddInput();},200,1);
		};
		that.commitElmCxFs = function() {
			$scope.btnElmCxFs(true);
			$timeout(function(){that.pushCtxFs();},10,1);
			$timeout(function(){$scope.focusOnElmCtxFsAddInput();},200,1);
		};
		that.commitElmCxFd = function() {
			$scope.btnElmCxFd(true);
			$timeout(function(){that.pushCtxFd();},10,1);
			$timeout(function(){$scope.focusOnElmCtxFdAddInput();},200,1);
		};
		that.pushCtx = function() {
			$scope.ElmCtx = {};
			$scope.ElmCtx.tag = that.model.atomicInt();
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstElmCx, true);
			that.model.currentDemPaimt().depl.lstElmCx.put($scope.ElmCtx, $scope.ElmCtx);
			$scope.elmCxGridOptions.data.push($scope.ElmCtx);
			$scope.elmCxGridApi.grid.modifyRows($scope.elmCxGridOptions.data);
			if ($scope.elmCxGridOptions.data.length>0) {
				$scope.elmCxGridApi.selection.selectRow($scope.ElmCtx);
			}
		};
		that.pushCtxFt = function() {
			$scope.fraisTrsp.elmCx = {};
			$scope.fraisTrsp.elmCx.tag = that.model.atomicInt();
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstFraisTranp, true);
			$scope.fraisTrsp.lstElmCx.put($scope.fraisTrsp.elmCx, $scope.fraisTrsp.elmCx);
			$scope.elmCxFtGridOptions.data.push($scope.fraisTrsp.elmCx);
			$scope.elmCxFtGridApi.grid.modifyRows($scope.elmCxFtGridOptions.data);
			if ($scope.elmCxFtGridOptions.data.length>0) {
				$scope.elmCxFtGridApi.selection.selectRow($scope.fraisTrsp.elmCx);
			}
		};
		that.pushCtxTd = function() {
			$scope.tpsDepl.elmCx = {};
			$scope.tpsDepl.elmCx.tag = that.model.atomicInt();
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstTempsDepla, true);
			$scope.tpsDepl.lstElmCx.put($scope.tpsDepl.elmCx, $scope.tpsDepl.elmCx);
			$scope.elmCxTdGridOptions.data.push($scope.tpsDepl.elmCx);
			$scope.elmCxTdGridApi.grid.modifyRows($scope.elmCxTdGridOptions.data);
			if ($scope.elmCxTdGridOptions.data.length>0) {
				$scope.elmCxTdGridApi.selection.selectRow($scope.tpsDepl.elmCx);
			}
		};
		that.pushCtxFs = function() {
			$scope.fraisSej.elmCx = {};
			$scope.fraisSej.elmCx.tag = that.model.atomicInt();
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstFraisSej, true);
			$scope.fraisSej.lstElmCx.put($scope.fraisSej.elmCx, $scope.fraisSej.elmCx);
			$scope.elmCxFsGridOptions.data.push($scope.fraisSej.elmCx);
			$scope.elmCxFsGridApi.grid.modifyRows($scope.elmCxFsGridOptions.data);
			if ($scope.elmCxFsGridOptions.data.length>0) {
				$scope.elmCxFsGridApi.selection.selectRow($scope.fraisSej.elmCx);
			}
		};
		that.pushCtxFd = function() {
			$scope.frfDepl.elmCx = {};
			$scope.frfDepl.elmCx.tag = that.model.atomicInt();
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstForfaDepla, true);
			$scope.frfDepl.lstElmCx.put($scope.frfDepl.elmCx, $scope.frfDepl.elmCx);
			$scope.elmCxFdGridOptions.data.push($scope.frfDepl.elmCx);
			$scope.elmCxFdGridApi.grid.modifyRows($scope.elmCxFdGridOptions.data);
			if ($scope.elmCxFdGridOptions.data.length>0) {
				$scope.elmCxFdGridApi.selection.selectRow($scope.frfDepl.elmCx);
			}
		};
		
		that.commitFraisTrsp = function() {
			if (nbLigne()>9) {
				$scope.model.warning("Le maximum de 10 lignes facturées a été atteint.");
			} else {
				$scope.btnFraisTrsp(true);
				$timeout(function(){that.pushFraisTrsp();},10,1);
			}
		};
		that.commitFrais = function() {
			if (nbLigne()>9) {
				$scope.model.warning("Le maximum de 10 lignes facturées a été atteint.");
			} else {
				$scope.btnFrais(true);
				$timeout(function(){that.pushFrais();},10,1);
			}
		};
		that.commitTempsDepla = function() {
			if (nbLigne()>9) {
				$scope.model.warning("Le maximum de 10 lignes facturées a été atteint.");
			} else {
				$scope.btnTempsDepla(true);
				$timeout(function(){that.pushTpsDepl();},10,1);
			}			
		};
		that.commitForfaDepla = function() {
			if (nbLigne()>9) {
				$scope.model.warning("Le maximum de 10 lignes facturées a été atteint.");
			} else {
				$scope.btnForfDepla(true);
				$timeout(function(){that.pushFrfDepl();},10,1);
			}
		};
		that.commitFraisSej = function() {
			if (nbLigne()>9) {
				$scope.model.warning("Le maximum de 10 lignes facturées a été atteint.");
			} else {
				$scope.btnFraisSej(true);
				$timeout(function(){that.pushFraisSej();},10,1);
			}
		};
		that.pushFraisTrsp = function(){
			$scope.fraisTrsp = {};
			$scope.fraisTrsp.noLigne = that.model.atomicInt();
			$scope.fraisTrsp.elmCx = {};
			$scope.fraisTrsp.dirtyStatus = {};
			$scope.fraisTrsp.lstElmCx = new Hashtable({ hashCode: tagHash });
			$scope.fraisTrsp.lstFrais = new Hashtable({ hashCode: tagHash });
			$scope.fraisTrsp.frais = {};
			var dateServ = model.currentDefault()['dateDefault'];
			if (angular.isDefined(that.model.currentDemPaimt().depl.dhDepDeplaDT) && that.model.currentDemPaimt().depl.dhDepDeplaDT!=null && that.model.currentDemPaimt().depl.dhDepDeplaDT!='') {
				dateServ = that.model.currentDemPaimt().depl.dhDepDeplaDT.substring(0,10);
			}
			$scope.fraisTrsp.dateServ = dateServ;
			var codFact = 9991;
			$scope.fraisTrsp.idElmFact = codFact;		// TODO mettre un codFact à la place ?
			$scope.fraisTrsp.codMoyen = 6;
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstFraisTranp, true);
			that.model.currentDemPaimt().depl.lstFraisTranp.put($scope.fraisTrsp.noLigne, $scope.fraisTrsp);
			$scope.fraisTrspGridOptions.data.push($scope.fraisTrsp);
			$scope.fraisTrspGridApi.grid.modifyRows($scope.fraisTrspGridOptions.data);
			$scope.fraisTrspGridApi.selection.selectRow($scope.fraisTrsp);
		};
		that.pushFrais = function() {
			$scope.fraisTrsp = that.model.currentDemPaimt().depl.lstFraisTranp.get($scope.fraisTrsp.noLigne);
			$scope.fraisTrsp.frais = {};
			$scope.fraisTrsp.frais.type = '4';
			$scope.fraisTrsp.frais.tag = that.model.atomicInt();
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstFraisTranp, true);
			$scope.fraisTrsp.lstFrais.put($scope.fraisTrsp.frais, $scope.fraisTrsp.frais);
			$scope.fraisGridOptions.data.push($scope.fraisTrsp.frais);
			$scope.fraisGridApi.grid.modifyRows($scope.fraisGridOptions.data);
			$scope.fraisGridApi.selection.selectRow($scope.fraisTrsp.frais);
		};
		that.pushTpsDepl = function(){
			$scope.tpsDepl = {};
			$scope.tpsDepl.noLigne = that.model.atomicInt();
			$scope.tpsDepl.elmCx = {};
			$scope.tpsDepl.dirtyStatus = {};
			$scope.tpsDepl.lstElmCx = new Hashtable({ hashCode: tagHash });
			var dateServ = that.model.currentDemPaimt().depl.dhDepDeplaDT.substring(0,10);
			var codMoyen = 6;
			if (angular.isDefined($scope.fraisTrsp)) {
				if (angular.isDefined($scope.fraisTrsp.datServ)) {
					dateServ = $scope.fraisTrsp.dateServ;
				}
				if (angular.isDefined($scope.fraisTrsp.codMoyen)) {
					codMoyen = $scope.fraisTrsp.codMoyen;
				}
			}
			$scope.tpsDepl.codMoyen = codMoyen;
			$scope.tpsDepl.dateServ = dateServ;
			var codFact = 9992;
//			if (that.model.currentProf().entente=='OMNI') {
//				codFact = 9991;
//			} else {
//				codFact = 9992
//			}
			$scope.tpsDepl.idElmFact = codFact;		// TODO mettre un codFact à la place ?
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstTempsDepla, true);
			that.model.currentDemPaimt().depl.lstTempsDepla.put($scope.tpsDepl.noLigne, $scope.tpsDepl);
			$scope.tpsDeplGridOptions.data.push($scope.tpsDepl);
			$scope.tpsDeplGridApi.grid.modifyRows($scope.tpsDeplGridOptions.data);
			$scope.tpsDeplGridApi.selection.selectRow($scope.tpsDepl);
		};
		that.pushFrfDepl = function(){
			$scope.frfDepl = {};
			$scope.frfDepl.noLigne = that.model.atomicInt();
			$scope.frfDepl.elmCx = {};
			$scope.frfDepl.dirtyStatus = {};
			$scope.frfDepl.lstElmCx = new Hashtable({ hashCode: tagHash });
			var dateServ = that.model.currentDemPaimt().depl.dhDepDeplaDT.substring(0,10);
			if (angular.isDefined($scope.fraisTrsp)) {
				if (angular.isDefined($scope.fraisTrsp.datServ)) {
					dateServ = $scope.fraisTrsp.dateServ;
				}
			}
			$scope.frfDepl.dateServ = dateServ;
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstForfaDepla, true);
			that.model.currentDemPaimt().depl.lstForfaDepla.put($scope.frfDepl.noLigne, $scope.frfDepl);
			$scope.frfDeplGridOptions.data.push($scope.frfDepl);
			$scope.frfDeplGridApi.grid.modifyRows($scope.frfDeplGridOptions.data);
			$scope.frfDeplGridApi.selection.selectRow($scope.frfDepl);
		};
		that.pushFraisSej = function(){
			$scope.fraisSej = {};
			$scope.fraisSej.noLigne = that.model.atomicInt();
			$scope.fraisSej.frais = {};
			$scope.fraisSej.frais.type='5';
			$scope.fraisSej.elmCx = {};
			$scope.fraisSej.dirtyStatus = {};
			$scope.fraisSej.lstElmCx = new Hashtable({ hashCode: tagHash });
			var dateServ = that.model.currentDemPaimt().depl.dhDepDeplaDT.substring(0,10);
			if (angular.isDefined($scope.fraisTrsp)) {
				if (angular.isDefined($scope.fraisTrsp.datServ)) {
					dateServ = $scope.fraisTrsp.dateServ;
				}
			}
			$scope.fraisSej.dateServ = dateServ;
			that.model.setDirtyStatus(that.model.currentDemPaimt().depl.lstFraisSej, true);
			that.model.currentDemPaimt().depl.lstFraisSej.put($scope.fraisSej.noLigne, $scope.fraisSej);
			$scope.fraisSejGridOptions.data.push($scope.fraisSej);
			$scope.fraisSejGridApi.grid.modifyRows($scope.fraisSejGridOptions.data);
			$scope.fraisSejGridApi.selection.selectRow($scope.fraisSej);
		};
				
		$scope.changeTypEtabDep = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
			if (that.model.currentDemPaimt().depl.lieuDep.typLocEtab === 'N') {
				that.model.currentDemPaimt().depl.lieuDep.local.typIdLieuGeo='3';
				$timeout(function(){$scope.focusOnLocalInputDep3();},200,1);
			} else {
				if (angular.isDefined(that.model.currentDemPaimt().depl.lieuDep.local.typIdLieuGeo)) {
					delete that.model.currentDemPaimt().depl.lieuDep.local.typIdLieuGeo;
				}
				$timeout(function(){$scope.focusOnInfoEtabDep();},200,1);
			}
		};
		$scope.changeTypEtabArr = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
			if (that.model.currentDemPaimt().depl.lieuArr.typLocEtab === 'N') {
				that.model.currentDemPaimt().depl.lieuArr.local.typIdLieuGeo='3';
				$timeout(function(){$scope.focusOnLocalInputArr3();},200,1);
			} else {
				if (angular.isDefined(that.model.currentDemPaimt().depl.lieuArr.local.typIdLieuGeo)) {
					delete that.model.currentDemPaimt().depl.lieuArr.local.typIdLieuGeo;
				}
				$timeout(function(){$scope.focusOnInfoEtabArr();},200,1);
			}
		};
		$scope.changeTypLocalDep = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
			if (that.model.currentDemPaimt().depl.lieuDep.local.typIdLieuGeo==='3') {
				$timeout(function(){$scope.focusOnLocalInputDep3();},200,1);
			} else {
				$timeout(function(){$scope.focusOnLocalInputDep();},200,1);
			}
		};
		$scope.changeTypLocalArr = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
			if (that.model.currentDemPaimt().depl.lieuArr.local.typIdLieuGeo==='3') {
				$timeout(function(){$scope.focusOnLocalInputArr3();},200,1);
			} else {
				$timeout(function(){$scope.focusOnLocalInputArr();},200,1);
			}
		};
		
		this.feeType = function(newType){
			return arguments.length? (TransportFeeEntryService.feeType = newType) : TransportFeeEntryService.feeType;
		};
		
		this.feeTypes = function(){
			return TransportFeeEntryService.feeTypes;
		};
		$scope.setDirty = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
		};
		this.defaultDate = function(){
			return moment(model.currentDefault()['dateDefault']);
		};
		
		var depDateDy = new DynaDate({elem:"depDateInput", format: 'YYYY-MM-DD HH:mm', locale:'fr', acceptFutureDate:false, useCurrent: false, maxDateElm:'arrDateInput'});
//		depDateDy.onDateSelected = function(selectedDate){
//			$("#arrDateInput").data("DateTimePicker").viewDate(selectedDate);
//		}
		depDateDy.getDefault = function(){
			return moment(that.model.currentDefault()['dateDefault']).hour(8).minute(00);
		};
		var arrDateDy = new DynaDate({elem:"arrDateInput", format: 'YYYY-MM-DD HH:mm', locale:'fr', acceptFutureDate:false, useCurrent: false, minDateElm:'depDateInput'});
		arrDateDy.getDefault = function(){
			return that.model.currentDemPaimt().depl.dhDepDeplaDT;
		};

		var fraisTrspDate = new DynaDate({elem:"fraisTrspDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false});
		fraisTrspDate.getDefault = function(){return depDateDy.currDate;};

		var tpsDeplDate = new DynaDate({elem:"tpsDeplDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false});
		tpsDeplDate.getDefault = function(){return depDateDy.currDate;};
		
		var frfDeplDate = new DynaDate({elem:"frfDeplDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false});
		frfDeplDate.getDefault = function(){return depDateDy.currDate;};
		
		var fraisSejDate = new DynaDate({elem:"fraisSejDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false});
		fraisSejDate.getDefault = function(){return depDateDy.currDate;};
		
		
//		$scope.fraisTrspGridApi $scope.fraisTrspGridOptions
//		$scope.tpsDeplGridApi $scope.tpsDeplGridOptions
//		$scope.frfDeplGridApi $scope.frfDeplGridOptions
//		$scope.fraisSejGridApi $scope.fraisSejGridOptions
		function nbLigne() {
			var dp = that.model.currentDemPaimt().depl;
			return dp.lstFraisTranp.size() + dp.lstTempsDepla.size() + dp.lstForfaDepla.size() + dp.lstFraisSej.size();
		}
		
		/*
		 * LES ASSISTANTS POUR TRANSPORT_FEE
		 * */
		$scope.etabDepAssist = {assistId: "autocomplete_etabDep", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.activeLieuEtab.valEtab.nomEtab)) {
						delete $scope.activeLieuEtab.valEtab.nomEtab;	// ça permet de savoir que nouveau
					}
					return { url:"/syra/etabl/search",
						data: { k: query, u:clientUid }};
				},
				listWidth: 300,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
				selection: function(elem) {
					$http({
						method : "GET",
						url : "/syra/etabl/get?c=" + elem.c +"&u=" + clientUid
					}).then(function mySucces(response) {
						var res = response.data;
						if (angular.isUndefined(res.length)) {
							that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
							$scope.activeLieuEtab = response.data;	//un CEtab
			    			var elem = {};
			    			elem.c = res.noSelectedEtab;
							elem.d = res.valEtab.nomEtab+ " (" + res.valEtab.typEtab + '-' + res.valEtab.catgEtab +")";
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					return elem.c;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			};

		$scope.etabArrAssist = {};
		$.extend($scope.etabArrAssist, $scope.etabDepAssist);
		$scope.etabArrAssist.assistId = "autocomplete_etabArr";
		
		$scope.localDepAssist = {assistId: "autocomplete_localDep", 
			getAjaxData: function(query){
				if (angular.isDefined($scope.activeLieuLocal.valCodLocal.nomLocal)) {
					delete $scope.activeLieuLocal.valCodLocal.nomLocal;
				}
				return { url:"/syra/local/search",
					data: { k: query, u: clientUid }};
			},
			listWidth: 300,
			hasHeader: false, hasDetails: false,
			getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
			selection: function(elem) {
				$http({
					method : "GET",
					url : "/syra/local/get?c=" + elem.c +"&u=" + clientUid
				}).then(function mySucces(response) {
					var res = response.data;
					if (angular.isUndefined(res.length)) {
						that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
						$scope.activeLieuLocal.valCodLocal = res;
					}
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
				return elem.c;
			},
			suggestOnDataLoaded: function(data) {
				if(data.length === 1){
					this.select(data[0]);
					return false;
				}
				return true;
			}
		};
		$scope.localArrAssist={};
		$.extend($scope.localArrAssist, $scope.localDepAssist);
		$scope.localArrAssist.assistId = "autocomplete_localArr";	
		
		$scope.contxtFtAssist = {assistId: "autocomplete_contxtFt", 
				getAjaxData: function(query){
				if (angular.isDefined(query) && query!==null && query!=="") {
					delete $scope.activeElmCx.d;	// ça permet de savoir que nouveau code - .d sera undefined si code non trouvé.
					return { url:"/syra/contx/search",
						data: { k: query, u:clientUid }};	// si au niveau de facture, mettre n: 'F'. Voir CodNiveau pour les autres lettres quand déplac.				
				}
					return [];
				},
				listWidth: 400,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
//				actions: [{key: '=', callback: function(){that.commitActiveElmCx();} },{key: '+', callback: function(){that.commitActiveElmCx();} }],
				selection : function(elem) {
					that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
					$scope.activeElmCx.c = elem.c;
					$scope.activeElmCx.d = elem.d;
					return elem.c;
				}
		};
		
		$scope.contxtAssist={};
		$.extend($scope.contxtAssist, $scope.contxtFtAssist);
		$scope.contxtAssist.assistId = "autocomplete_contxt";
		
		$scope.contxtTdAssist={};
		$.extend($scope.contxtTdAssist, $scope.contxtFtAssist);
		$scope.contxtTdAssist.assistId = "autocomplete_contxtTd";		
		
		$scope.contxtFdAssist={};
		$.extend($scope.contxtFdAssist, $scope.contxtFtAssist);
		$scope.contxtFdAssist.assistId = "autocomplete_contxtFd";		
		
		$scope.contxtFsAssist={};
		$.extend($scope.contxtFsAssist, $scope.contxtFtAssist);
		$scope.contxtFsAssist.assistId = "autocomplete_contxtFs";		
		
		/*
		 * LES GRID OPTIONS POUR TRANSPORT_FEE
		 * */
		var sortAbs = function(aa,bb){
			var a = Math.abs(aa);
			var b = Math.abs(bb);
	        if (a == b) return 0;
	        if (a < b) return -1;
	        return 1;
	    };
	    var cellTemplateNoLigne = '<div class="ui-grid-cell-contents" ng-hide="row.entity.noLigne<1">{{row.entity.noLigne}}</div>';
	    
		$scope.fraisTrspGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: that,
				columnDefs: [
				             { name: 'noLigne', displayName: 'L', sort: {
				            	    direction: uiGridConstants.ASC,
				            	    ignoreSort: false,
				            	    priority: 0
				            	   }, width: "24", sortingAlgorithm: sortAbs, cellTemplate: cellTemplateNoLigne},
							 { name: 'dateServ', displayName: 'Date', width: "26%"},
							 { name: 'idElmFact', displayName: 'Code', width: "16%"},
				             { name: 'codMoyen', displayName: 'Moyen', cellFilter: "transportMeansById:'fraisTrsps'", width:'*'},
				             { name: 'km', displayName: 'KM', cellFilter:"prefixsufix:'km'", width: "15%"},
				             { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteFraisTrsp(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
				            	 ]
		};
		$scope.fraisTrspGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.fraisTrspGridApi) {
				$scope.fraisTrspGridApi = gridApi;
				$scope.fraisTrspGridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.fraisTrsp);
				}, [uiGridConstants.dataChange.ROW]);
				
				$scope.fraisTrspGridApi.selection.on.rowSelectionChanged($scope,function(row){
					$scope.fraisTrsp = row.entity;
			        $scope.fraisGridOptions.data =  row.entity.lstFrais.values();
			        $scope.fraisGridApi.grid.modifyRows($scope.fraisGridOptions.data);
			        if ($scope.fraisGridOptions.data.length>0) {
			        	$scope.fraisTrsp.frais = $scope.fraisGridOptions.data[0];
			        	$scope.fraisGridApi.selection.selectRow($scope.fraisTrsp.frais);
			        } else {
			        	$scope.fraisTrsp.frais = {};
			        }
			        $scope.elmCxFtGridOptions.data =  row.entity.lstElmCx.values();
			        $scope.elmCxFtGridApi.grid.modifyRows($scope.elmCxFtGridOptions.data);
			        if ($scope.elmCxFtGridOptions.data.length>0) {
			        	$scope.fraisTrsp.elmCx = $scope.elmCxFtGridOptions.data[0];
			        	$scope.elmCxFtGridApi.selection.selectRow($scope.fraisTrsp.elmCx);
			        } else {
			        	$scope.fraisTrsp.elmCx = {};
			        }
				});
			}
		};
		that.deleteFraisTrsp = function(row) {
			var idx = $scope.fraisTrspGridApi.selection.getSelectedGridRows();
			$scope.fraisTrspGridApi.core.setRowInvisible(row);
			that.model.currentDemPaimt().depl.lstFraisTranp.remove(row.entity.noLigne);
			$scope.setDirty();
			var noLigne = row.entity.noLigne;
			$timeout(function () {
				$scope.fraisTrspGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.fraisTrspGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].noLigne===noLigne) {
					setFraisTrspEmpty();
			        $scope.elmCxFtGridOptions.data=[];
			        $scope.fraisGridOptions.data= [];
				}
			}, 10,1);
		};
		
		$scope.fraisGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
							 { name: 'type', displayName: 'Type', cellFilter: "transportMeansById:'fraisTrspTypes'", width: "65%"},
							 { name: 'mnt', displayName: 'Montant', cellFilter: 'currency', cellClass: 'text-right'},
							 { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
								 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteFrais(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
							]
		};
		$scope.fraisGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.fraisGridApi) {
		        $scope.fraisGridApi = gridApi;
		        gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.fraisTrsp.frais);
		        }, [uiGridConstants.dataChange.ROW]);
		        gridApi.selection.on.rowSelectionChanged($scope,function(row){
		        	$scope.fraisTrsp.frais = row.entity;		        	
		        });
			}
	     };
		that.deleteFrais = function(row) {
			$scope.fraisGridApi.core.setRowInvisible(row);
			$scope.fraisTrsp.lstFrais.remove(row.entity);
			$scope.setDirty();
			var tag = row.entity.tag;
			$timeout(function () {
				$scope.fraisGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.fraisGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].tag===tag) {
					$scope.fraisTrsp.frais = {};
				}
            }, 10,1);
		};
		
		$scope.tpsDeplGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'noLigne', displayName: 'L', sort: {
				            	    direction: uiGridConstants.ASC,
				            	    ignoreSort: false,
				            	    priority: 0
				            	   }, width: "24", sortingAlgorithm: sortAbs, cellTemplate: cellTemplateNoLigne},
							 { name: 'dateServ', displayName: 'Date', width:"14%"},
							 { name: 'idElmFact', displayName: 'Code', width: "8%"},
							 { name: 'codMoyen', displayName: 'Moyen', cellFilter: "transportMeansById:'fraisTrsps'", width: "*"},
							 { name: 'kmAller', displayName: 'Km Aller', cellFilter:"prefixsufix:'km'", width: "12%"},
							 { name: 'kmRetou', displayName: 'Km Ret.', cellFilter:"prefixsufix:'km'", width: "12%"},
							 { name: 'hreAtten', displayName: 'H. Att.', cellFilter:"prefixsufix:'h'", width: "11%"},
							 { name: 'hreDepla', displayName: 'H. Dépl.', cellFilter:"prefixsufix:'h'", width: "11%"},
							 { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
								 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteTpsDepl(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
							]
			};
		$scope.tpsDeplGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.tpsDeplGridApi) {
		        $scope.tpsDeplGridApi = gridApi;
		        gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.tpsDepl);
		        }, [uiGridConstants.dataChange.ROW]);
		        gridApi.selection.on.rowSelectionChanged($scope,function(row){
		        	$scope.tpsDepl = row.entity;
			        $scope.elmCxTdGridOptions.data =  row.entity.lstElmCx.values();
			        $scope.elmCxTdGridApi.grid.modifyRows($scope.elmCxTdGridOptions.data);
			        if ($scope.elmCxTdGridOptions.data.length>0) {
			        	$scope.tpsDepl.elmCx = $scope.elmCxTdGridOptions.data[0];
			        	$scope.elmCxTdGridApi.selection.selectRow($scope.tpsDepl.elmCx);
			        } else {
			        	$scope.tpsDepl.elmCx = {};
			        }
		        });
			}
	     };
		that.deleteTpsDepl = function(row) {
			$scope.tpsDeplGridApi.core.setRowInvisible(row);
			that.model.currentDemPaimt().depl.lstTempsDepla.remove(row.entity.noLigne);
			$scope.setDirty();
			var noLigne = row.entity.noLigne;
			$timeout(function () {
				$scope.tpsDeplGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.tpsDeplGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].noLigne===noLigne) {
					setTempsDeplaEmpty();
			        $scope.elmCxTdGridOptions.data=[];
				}
            }, 10,1);
		};
		
		$scope.frfDeplGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'noLigne', displayName: 'L', sort: {
				            	    direction: uiGridConstants.ASC,
				            	    ignoreSort: false,
				            	    priority: 0
				            	   }, width: "24", sortingAlgorithm: sortAbs, cellTemplate: cellTemplateNoLigne},
							 { name: 'dateServ', displayName: 'Date', width: "50%"},
							 { name: 'idElmFact', displayName: 'Code', width: "30%"},
							 { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
								 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteForfDepl(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
							]
		};
		$scope.frfDeplGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.frfDeplGridApi) {
		        $scope.frfDeplGridApi = gridApi;
		        gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.frfDepl);
		        }, [uiGridConstants.dataChange.ROW]);
		        gridApi.selection.on.rowSelectionChanged($scope,function(row){
		        	$scope.frfDepl = row.entity;
			        $scope.elmCxFdGridOptions.data =  row.entity.lstElmCx.values();
			        $scope.elmCxFdGridApi.grid.modifyRows($scope.elmCxFdGridOptions.data);
			        if ($scope.elmCxFdGridOptions.data.length>0) {
			        	$scope.frfDepl.elmCx = $scope.elmCxFdGridOptions.data[0];
			        	$scope.elmCxFdGridApi.selection.selectRow($scope.frfDepl.elmCx);
			        } else {
			        	$scope.frfDepl.elmCx = {};
			        }
		        });
			}
	     };	     
		that.deleteForfDepl = function(row) {
			$scope.frfDeplGridApi.core.setRowInvisible(row);
			that.model.currentDemPaimt().depl.lstForfaDepla.remove(row.entity.noLigne);
			$scope.setDirty();
			var noLigne = row.entity.noLigne;
			$timeout(function () {
				$scope.frfDeplGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.frfDeplGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].noLigne===noLigne) {
					setForfaDeplaEmpty();
			        $scope.frfDeplGridOptions.data=[];
			        $scope.elmCxFdGridOptions.data=[];
				}
            }, 10,1);
		};
		
		$scope.fraisSejGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'noLigne', displayName: 'L', sort: {
				            	    direction: uiGridConstants.ASC,
				            	    ignoreSort: false,
				            	    priority: 0
				            	   }, width: "24", sortingAlgorithm: sortAbs, cellTemplate: cellTemplateNoLigne},
							 { name: 'dateServ', displayName: 'Date', width: "20%"},
							 { name: 'idElmFact', displayName: 'Code', width: "15%"},
							 { name: 'frais.type', displayName: 'Type', cellFilter: "transportMeansById:'fraisSejs'", width: "*"},
							 { name: 'frais.mnt', displayName: 'Montant', cellFilter: 'currency', cellClass: 'text-right', width:'20%'},
							 { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
								 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteFraisSej(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
							]
		};
		$scope.fraisSejGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.fraisSejGridApi) {
		        $scope.fraisSejGridApi = gridApi;
		        gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.fraisSej);
		        }, [uiGridConstants.dataChange.ROW]);
		        gridApi.selection.on.rowSelectionChanged($scope,function(row){
		        	$scope.fraisSej = row.entity;
			        $scope.elmCxFsGridOptions.data =  row.entity.lstElmCx.values();
			        $scope.elmCxFsGridApi.grid.modifyRows($scope.elmCxFsGridOptions.data);
			        if ($scope.elmCxFsGridOptions.data.length>0) {
			        	$scope.fraisSej.elmCx = $scope.elmCxFsGridOptions.data[0];
			        	$scope.elmCxFsGridApi.selection.selectRow($scope.fraisSej.elmCx);
			        } else {
			        	$scope.fraisSej.elmCx = {};
			        }
		        });
			}
	     };
		that.deleteFraisSej = function(row) {
			$scope.fraisSejGridApi.core.setRowInvisible(row);
			that.model.currentDemPaimt().depl.lstFraisSej.remove(row.entity.noLigne);
			$scope.setDirty();
			var noLigne = row.entity.noLigne;
			$timeout(function () {
				$scope.fraisSejGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.fraisSejGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].noLigne===noLigne) {
					setFraisSejEmpty();
			        $scope.elmCxFsGridOptions.data=[];
				}
            }, 10,1);
		};

/** les grids options pour tous les elements de contexte */
		
		/* trspType.elmCx */
		$scope.elmCxFtGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'tag', displayName: 'L', sort:{direction:uiGridConstants.ASC,ignoreSort:false,priority:0}, visible:false, sortingAlgorithm: sortAbs},
				             { name: 'c', displayName: 'Contexte', cellTooltip: function(row, col){return row.entity.d}},
				             { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteContxFt(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
				            	 ]
		};
		$scope.elmCxFtGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.elmCxFtGridApi) {
				$scope.elmCxFtGridApi = gridApi;
				gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.fraisTrsp.elmCx);
				}, [uiGridConstants.dataChange.ROW]);
				gridApi.selection.on.rowSelectionChanged($scope,function(row){
					$scope.fraisTrsp.elmCx = row.entity;
				});
			}
		};
		that.deleteContxFt = function(row) {
			$scope.elmCxFtGridApi.core.setRowInvisible(row);
			$scope.fraisTrsp.lstElmCx.remove(row.entity);
			$scope.setDirty();
			var tag = row.entity.tag;
			$timeout(function () {
				$scope.elmCxFtGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.elmCxFtGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].tag===tag) {
					$scope.fraisTrsp.elmCx = {};
				}
			}, 10,1);
		};
		
		/* elmCxTd */
		$scope.elmCxTdGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'tag', displayName: 'L', sort:{direction:uiGridConstants.ASC,ignoreSort:false,priority:0}, visible:false, sortingAlgorithm: sortAbs},
				             { name: 'c', displayName: 'Contexte', cellTooltip: function(row, col){return row.entity.d}},
				             { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteContxTd(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
				            	 ]
		};
		$scope.elmCxTdGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.elmCxTdGridApi) {
				$scope.elmCxTdGridApi = gridApi;
				gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.tpsDepl.elmCx);
				}, [uiGridConstants.dataChange.ROW]);
				gridApi.selection.on.rowSelectionChanged($scope,function(row){
					$scope.tpsDepl.elmCx = row.entity;
				});
			}
		};
		that.deleteContxTd = function(row) {
			$scope.elmCxTdGridApi.core.setRowInvisible(row);
			$scope.tpsDepl.lstElmCx.remove(row.entity);
			$scope.setDirty();
			var tag = row.entity.tag;
			$timeout(function () {
				$scope.elmCxTdGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.elmCxTdGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].tag===tag) {
					$scope.tpsDepl.elmCx = {};
				}
			}, 10,1);
		};
		
		/* elmCxFs */
		$scope.elmCxFsGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'tag', displayName: 'L', sort:{direction:uiGridConstants.ASC,ignoreSort:false,priority:0}, visible:false, sortingAlgorithm: sortAbs},
				             { name: 'c', displayName: 'Contexte', cellTooltip: function(row, col){return row.entity.d}},
				             { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteContxFs(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
				            	 ]
		};
		$scope.elmCxFsGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.elmCxFsGridApi) {
				$scope.elmCxFsGridApi = gridApi;
				gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.fraisSej.elmCx);
				}, [uiGridConstants.dataChange.ROW]);
				gridApi.selection.on.rowSelectionChanged($scope,function(row){
					$scope.fraisSej.elmCx = row.entity;
				});
			}
		};
		that.deleteContxFs = function(row) {
			$scope.elmCxFsGridApi.core.setRowInvisible(row);
			$scope.fraisSej.lstElmCx.remove(row.entity);
			$scope.setDirty();
			var tag = row.entity.tag;
			$timeout(function () {
				$scope.elmCxFsGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.elmCxFsGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].tag===tag) {
					$scope.fraisSej.elmCx = {};
				}
			}, 10,1);
		};
		
		/* elmCxFd */
		$scope.elmCxFdGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'tag', displayName: 'L', sort:{direction:uiGridConstants.ASC,ignoreSort:false,priority:0}, visible:false, sortingAlgorithm: sortAbs},
				             { name: 'c', displayName: 'Contexte', cellTooltip: function(row, col){return row.entity.d}},
				             { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteContxFd(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
				            	 ]
		};
		$scope.elmCxFdGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.elmCxFdGridApi) {
				$scope.elmCxFdGridApi = gridApi;
				gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.frfDepl.elmCx);
				}, [uiGridConstants.dataChange.ROW]);
				gridApi.selection.on.rowSelectionChanged($scope,function(row){
					$scope.frfDepl.elmCx = row.entity;
				});
			}
		};
		that.deleteContxFd = function(row) {
			$scope.elmCxFdGridApi.core.setRowInvisible(row);
			$scope.frfDepl.lstElmCx.remove(row.entity);
			$scope.setDirty();
			var tag = row.entity.tag;
			$timeout(function () {
				$scope.elmCxFdGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.elmCxFdGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].tag===tag) {
					$scope.frfDepl.elmCx = {};
				}
			}, 10,1);
		};
		
		/* elmCx */
		$scope.elmCxGridOptions = {
				data: [],
				enableMinHeightCheck:false,
				enableSorting:false, enableColumnMenus:false,
				multiSelect: false,	enableRowSelection: true, enableRowHeaderSelection: false,
				saveScroll: false,	enableHiding: false,cellTooltip: false,	headerTooltip: true,
				modifierKeysToMultiSelect: false, noUnselect: true,	appScopeProvider: this,
				columnDefs: [
				             { name: 'tag', displayName: 'L', sort:{direction:uiGridConstants.ASC,ignoreSort:false,priority:0}, visible:false, sortingAlgorithm: sortAbs},
				             { name: 'c', displayName: 'Contexte', cellTooltip: function(row, col){return row.entity.d}},
				             { name: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	 "<button class='btn-emoji dxDelBtn' title='Retirer' ng-click='grid.appScope.deleteContx(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"},
				            	 ]
		};
		$scope.elmCxGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.elmCxGridApi) {
				$scope.elmCxGridApi = gridApi;
				gridApi.grid.registerDataChangeCallback(function(data) {
					$scope.fraisTrspGridApi.selection.selectRow($scope.elmCx);
				}, [uiGridConstants.dataChange.ROW]);
				gridApi.selection.on.rowSelectionChanged($scope,function(row){
					$scope.elmCx = row.entity;
				});
			}
		};
		that.deleteContx = function(row) {
			$scope.elmCxGridApi.core.setRowInvisible(row);
			that.model.currentDemPaimt().depl.lstElmCx.remove(row.entity);
			$scope.setDirty();
			var tag = row.entity.tag;
			$timeout(function () {
				$scope.elmCxGridApi.selection.selectRowByVisibleIndex(0);
				var selectedRows = $scope.elmCxGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || selectedRows[0].tag===tag) {
					$scope.elmCx = {};
				}
			}, 10,1);
		};
		$scope.$watch(
				function(scope) {return that.model.lstElmCxFactFTUpdated().val;},
				function(newVal, oldVal, scope) {
			if (newVal>0 && newVal!=oldVal && angular.isDefined(that.model.currentDemPaimt().depl)) {
				if (angular.isDefined(that.model.currentDemPaimt().depl.lstElmCx) && (typeof that.model.currentDemPaimt().depl.lstElmCx.values == 'function')) {
					scope.elmCxGridOptions.data =  that.model.currentDemPaimt().depl.lstElmCx.values();
					scope.elmCxGridApi.grid.modifyRows(scope.elmCxGridOptions.data);
					if (scope.elmCxGridOptions.data.length>0) {
						$timeout(function() {
							scope.elmCxGridApi.selection.selectRowByVisibleIndex(0);
						}, 50);
					}
				}
			}
		});
		$scope.$watch(function(scope) {return that.model.lstlstFraisTranpUpdated().val;},
				function(newVal, oldVal, scope) {
			if (newVal>0 && newVal!=oldVal && angular.isDefined(that.model.currentDemPaimt().depl)) {
				if (angular.isDefined(that.model.currentDemPaimt().depl.lstFraisTranp) && (typeof that.model.currentDemPaimt().depl.lstFraisTranp.values == 'function')) {
					setFraisTrspEmpty();
					scope.fraisTrspGridOptions.data =  that.model.currentDemPaimt().depl.lstFraisTranp.values();
					scope.fraisTrspGridApi.grid.modifyRows(scope.fraisTrspGridOptions.data);
					if (scope.fraisTrspGridOptions.data.length>0) {
						$timeout(function() {
							scope.fraisTrspGridApi.selection.selectRowByVisibleIndex(0);
						}, 50);
					}
				}
			}
		});
		$scope.$watch(function(scope) {return that.model.lstTempsDeplaUpdated().val;},
				function(newVal, oldVal, scope) {
			if (newVal>0 && newVal!=oldVal && angular.isDefined(that.model.currentDemPaimt().depl)) {
				if (angular.isDefined(that.model.currentDemPaimt().depl.lstTempsDepla) && (typeof that.model.currentDemPaimt().depl.lstTempsDepla.values == 'function')) {
					setTempsDeplaEmpty();
					scope.tpsDeplGridOptions.data =  that.model.currentDemPaimt().depl.lstTempsDepla.values();
					scope.tpsDeplGridApi.grid.modifyRows(scope.tpsDeplGridOptions.data);
					if (scope.tpsDeplGridOptions.data.length>0) {
						$timeout(function() {
							scope.tpsDeplGridApi.selection.selectRowByVisibleIndex(0);
						}, 50);
					}
				}
			}
		});
		$scope.$watch(function(scope) {return that.model.lstForfaDeplaUpdated().val;},
				function(newVal, oldVal, scope) {
			if (newVal>0 && newVal!=oldVal && angular.isDefined(that.model.currentDemPaimt().depl)) {
				if (angular.isDefined(that.model.currentDemPaimt().depl.lstForfaDepla) && (typeof that.model.currentDemPaimt().depl.lstForfaDepla.values == 'function')) {
					setForfaDeplaEmpty();
					scope.frfDeplGridOptions.data =  that.model.currentDemPaimt().depl.lstForfaDepla.values();
					scope.frfDeplGridApi.grid.modifyRows(scope.frfDeplGridOptions.data);
					if (scope.frfDeplGridOptions.data.length>0) {
						$timeout(function() {
							scope.frfDeplGridApi.selection.selectRowByVisibleIndex(0);
						}, 50);
					}
				}
			}
		});
		$scope.$watch(function(scope) {return that.model.lstFraisSejUpdated().val;},
				function(newVal, oldVal, scope) {
			if (newVal>0 && newVal!=oldVal && angular.isDefined(that.model.currentDemPaimt().depl)) {
				if (angular.isDefined(that.model.currentDemPaimt().depl.lstFraisSej) && (typeof that.model.currentDemPaimt().depl.lstFraisSej.values == 'function')) {
					setFraisSejEmpty();
					scope.fraisSejGridOptions.data =  that.model.currentDemPaimt().depl.lstFraisSej.values();
					scope.fraisSejGridApi.grid.modifyRows(scope.fraisSejGridOptions.data);
					if (scope.fraisSejGridOptions.data.length>0) {
						$timeout(function() {
							scope.fraisSejGridApi.selection.selectRowByVisibleIndex(0);
						}, 50);
					}
				}
			}
		});
		
		function setFraisTrspEmpty() {
			$scope.fraisTrsp = {};
			$scope.fraisTrsp.dirtyStatus = {};
			$scope.fraisTrsp.elmCx = {};
			$scope.fraisTrsp.frais = {};
			$scope.fraisTrsp.lstElmCx = new Hashtable({ hashCode: tagHash });
			$scope.fraisTrsp.lstFrais = new Hashtable({ hashCode: tagHash });
		}
		function setTempsDeplaEmpty() {
			$scope.tpsDepl = {};
			$scope.tpsDepl.dirtyStatus = {};
			$scope.tpsDepl.elmCx = {};
			$scope.tpsDepl.lstElmCx = new Hashtable({ hashCode: tagHash });
		}
		function setForfaDeplaEmpty() {
			$scope.frfDepl = {};
			$scope.frfDepl.dirtyStatus = {};
			$scope.frfDepl.elmCx ={};
			$scope.frfDepl.lstElmCx = new Hashtable({ hashCode: tagHash });
		}
		function setFraisSejEmpty() {
			$scope.fraisSej = {};
			$scope.fraisSej.dirtyStatus = {};
			$scope.fraisSej.frais = {};
			$scope.fraisSej.elmCx = {};
			$scope.fraisSej.lstElmCx = new Hashtable({ hashCode: tagHash });
		}
		
	}]);
	
	this.hello = function(m) {
		new jBox('Notice', {
			color : 'green',
			content: m,
			attributes: {
				x: 'right',
				y: 'bottom'
			}
		});
	}
	
})();