(function(){
	var bill = angular.module("billing", ['cfp.hotkeys', 'ngTouch', 'ui.grid', 'ui.grid.infiniteScroll', 'ui.grid.cellNav', 'ui.grid.resizeColumns', 'ui.grid.selection', 'ui.grid.pinning', 'ngWebSocket', 'ngSanitize', 'angular-confirm']);

	bill.directive('selectOnFocus', function ($timeout) {
	    return {
	        restrict: 'A',
	        link: function (scope, element, attrs) {
	            var focusedElement = null;
	            element.on('focus', function () {
	                var self = this;
	                if (focusedElement != self) {
	                    focusedElement = self;
	                    self.select();
	                }
	            });
	            element.on('blur', function () {
	                focusedElement = null;
	            });
	    }

	  }
	});
	
	bill.controller('BillController', ['ResponsiveDetection','$scope', '$http', '$filter', '$log', '$timeout', 'hotkeys', 'uiGridConstants', 'SyraWebSocket', 'clientUid','model', '$uibModal', '$sanitize', '$confirm',
	                                   function(ResponsiveDetection, $scope, $http, $filter, $log, $timeout, hotkeys, uiGridConstants, SyraWebSocket, clientUid, model ,$uibModal, $sanitize, $confirm){
		this.dataLoading = false;
		var that = this;
		this.model = model;
		$scope.model = model;

		this.plus1 = 0;
		this.moins1 = 0;
		this.reset0 = 0;
		var colDefDone = false;
		this.advised = false;
		
		$scope.range = function(n){
			var res = [];
			for (var i = 0; i < n; i++) {
		        res.push(i);
		      }
			return res;
		};
		
		this.status = [
		               {'id': 0, 'label': 'Non Transmises'},
		               {'id': 2, 'label': 'Refusées/En erreur'},
		               {'id': 3, 'label': 'Non Tr./Ref./En err.'}
		               ];

		/*
		 * iu integer iduser de celui qui a fait cette version de la demPaimt.
		 * id integer noDemExt
		 * ii string idIntvn
		 * -> 1 devient un 4 si reception, 2 devient un 5, et 3 devient un 6
		 * cdt String created datetime format yyyy-mm-dd HH:mm:ss
		 * mdt string lastModified datetime format yyyy-mm-dd HH:mm:ss
		 * pt stringpatient nam ou all data (joinlist of ln, fn, ddn, s, adrs1, adrs2, adrs3, cp)
		 * hon BigDecimal hon;
		 * dt enum demType one of DEM_PAIMT(1),DEM_MODIF(2),DEM_ANNU(3), DEM_PAIM_RECEV(4),DEM_MDIF_RECEV(5),DEM_ANNU_RECEV(6)
		 * sr Intger sta_recev 1 ou 2 - fait partie de FactRecev (différent selon le type de fact paimt, modif ou annu)
		 */

		this.disableBillGrid = function() {
			var tpsReel = that.model.currentGlobalDefault()['envoi_tps_reel'];
			return that.model.isDirty() || (tpsReel && that.model.currentDemForListe().prg===1);
		};
		
		this.setCurrBill = function(b) {
			that.model.setCurrDemForListe(b, false);
		};

		this.isBillSelectDisabled = function() {
			return that.model.isDirty() || that.model.criteriaActive();
		};
		this.setBillListStatus = function() {
			var criteria = {};
			criteria.statusRep = that.model.activeCriteriaStatusRep();
			criteria.user = that.model.currentDefault()['billsUser'];
			that.refreshDemListe(criteria);
		};

		var timeOutRefresDemList = {};

		$scope.hasFactAbs = function() {
			var noRfps = that.model.noRfpsFromConcil().length;
			var noBill =  $scope.billGridOptions.data ? $scope.billGridOptions.data.length : 0;
			// true if total des fact<nombre de noRfp de la conciliation
			return noRfps > noBill;
		};
		$scope.seeNoRqsFacturesAbsente = function() {
			// show message avec la liste des no séparés par des , 
			var ns = that.model.noRfpsFromConcil();
			var bs =  $scope.billGridOptions.data;
			// bs.noRfp
			var noAbs = [];
			var nsL = ns.length; var bsL = bs.length;
			for (var i = 0; i < nsL; i++) {
				var isThere = false;
				for (var j = 0; j < bsL; j++) {
					if (bs[j].noRfp == ns[i]) {
						isThere = true;
						break;
					}
				}
				if (!isThere) {
					noAbs.push(ns[i]);
				}
			}
			var sNoAbs = "";
			var first = true;
			for (var i = 0; i < noAbs.length; i++) {
				if (first) {
					sNoAbs = noAbs[i] ;
					first = false;
				} else {
					sNoAbs += ", " + noAbs[i] ;
				}
			}
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modalContent.html",
				controller: 'ModalInstanceCtrl',
				size: "lg",
				resolve: {
					mObject: function () {
						return {
							title: "Numéros des factures absentes de la liste active",
							content: sNoAbs
						};
					}
				}
			});
		};
		this.refreshDemListe = function(c) {
			if (angular.isDefined(timeOutRefresDemList.promise)) {
				$timeout.cancel(timeOutRefresDemList.promise);
			}
			var criteria = c;
			timeOutRefresDemList.promise = $timeout(function(){
				that.model.getDemListe(criteria);
			},500);
		};

		var minStatus;
		
		$scope.full = 'O';
		$scope.toggleMenu = function(){
			var f = $scope.full;
			if(f === 'O'){
				$scope.full =  $scope.isMiniList()?'F':'M';
			}
			if(f === 'F')$scope.full = 'M';
			if(f === 'M')$scope.full = 'F';
			if ($scope.full=='F') {
				setMinMenu(false);
			} else {
				setMinMenu(true);
			}
		};
		$scope.isMiniList = function(wSize){
			if($scope.full === 'F'){
				return false;
			}else if($scope.full === 'M'){
				return true;
			}else{
				if(wSize == undefined) 
					wSize = ResponsiveDetection.getBreakpoint();
				return wSize === 'sm' || wSize === 'xs';
			}
		};
		$scope.isScreenLarge = function(wSize){
			wSize = ResponsiveDetection.getBreakpoint();
			return wSize === 'lg';
		};
		
		
		// pour forcer un refresh complet du controle - voir ng-if du grid ds html
		function refreshGrid() {
		    $scope.refresh = false;
		    $timeout(function() {
		      $scope.refresh = true;
		      $scope.model.demListeShowSelected(true);
		    });
		  }
		  
		$scope.toggleMiniList = function(wSize){
//			delete $scope.full;
			if($scope.isMiniList(wSize)){
				setMinMenu(true);
			}else{
				setMinMenu(false);
			}
		};
		
		function setMinMenu(v) {
			if (minStatus===v) {return};
			minStatus = v;
			if (v) {
				$scope.billGridOptions.showHeader = false;
				$scope.billGridOptions.enableGridMenu = false;
				for(var i = 1; i < $scope.billGridOptions.columnDefs.length; i++){
					$scope.billGridOptions.columnDefs[i].visible = false;
				}
				refreshGrid();
			} else {
				$scope.billGridOptions.showHeader = true;
				$scope.billGridOptions.enableGridMenu = true;
				for(var i = 1; i < $scope.billGridOptions.columnDefs.length; i++){
					$scope.billGridOptions.columnDefs[i].visible = true;
				}
				refreshGrid();				
			}
		}
		
		function getHeaderName() {
			return new moment().format("YYYY-MM-DD HH:MM");
		}
		
		$scope.billGridOptions = {
//				flatEntityAccess: true,	// ne fonctionne pas en raison des cellFilters. Si prob de performance, on pourrait setter les valeurs dans le tableau directement
				enableMinHeightCheck:false,
				multiSelect: false,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				enableFiltering: true,
				enableSorting: true,
				infiniteScrollRowsFromEnd:20,
			    infiniteScrollUp: true,
			    infiniteScrollDown: true,
				virtualizationThreshold: myAppGrid.vthresh,	// 50
				scrollThreshold:myAppGrid.scrollt,
				wheelScrollThrottle:myAppGrid.wheelst,
				excessRows:myAppGrid.exRows,
				showHeader: !$scope.isMiniList(),
				cellTooltip: false,
				headerTooltip: true,
				modifierKeysToMultiSelect: false,
				noUnselect: false,
				excessColumns:2,	// 12
				appScopeProvider: that,
				enableHiding: true,
				enableGridMenu: true,
				disableCancelFilterButton: true,
				exporterMenuCsv: false,
//				exporterCsvFilename: function(){ return getHeaderName().replace('[ -:] ','_') + ".csv";},
			    exporterPdfDefaultStyle: {fontSize: 9},
			    exporterPdfTableStyle: {margin: [0, 0, 0, 0]},
			    exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
			    exporterPdfHeader: function () { return {text: getHeaderName(), style: 'headerStyle' };},
			    exporterPdfFooter: function ( currentPage, pageCount ) {
			      return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
			    },
			    exporterPdfCustomFormatter: function ( docDefinition ) {
			      docDefinition.styles.headerStyle = { fontSize: 14, bold: true };
			      docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
			      return docDefinition;
			    },
			    exporterPdfOrientation: 'landscape',
			    exporterPdfPageSize: 'LETTER',
			    exporterPdfMaxGridWidth: 650,
	             exporterFieldCallback: function( grid, row, col, input ) {
	            	 if (col.field=='prg') {
	            		 if (input==2) {
	            			 return 'Succès';
	            		 } else if (input==3) {
	            			 return 'Échec';
	            		 } else {
	            			 return '';
	            		 }
	            	 } else if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
	              	    var filters = col.cellFilter.split('|');
	              	    for(i=0; i<filters.length;i++) {
	              	      var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
	              	      var filterName=pars[0].trim();
	              	      var filterPar = null;
	              	      if (pars.length==2) {
//	              	        filterPar = pars[1].slice(1, -1);
	               	        filterPar = eval(pars[1]);
	              	        input = $filter(filterName)( input,filterPar);
	              	      } else {
	              	        input = $filter(filterName)( input );
	              	      }
	              	    }
	              	  }
	              	  return input;
	               },
	            exportPdfIf: function(gdata){
	            	if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
	            	else {
	            		model.warning(MSG_TEXT['TROP_DATA']);
	            		return false;
	            	}
	            },
			    onPdfExport:function(doc, binarydoc){ 
						$scope.inscriptionOpened = true;
						that.dataLoading = false;
						$scope.modalInstance = $uibModal.open({
							animation: $scope.animationsEnabled,
							templateUrl: "/syra/Resources/views/modal.html",
							controller: 'ModalInstanceCtrl',
							size: "lg",
							resolve: {
								mObject: function () {
									return {
										title: "Factures",
										templateUrl:"/syra/Resources/views/pdfviewer.html",
										doc: binarydoc
									};
								}
							}
						});

						$scope.modalInstance.result.then(function () {
							$scope.inscriptionOpened = false;
				        }, function () {
				            $scope.inscriptionOpened = false;
				        });	
			    },
			    exporterSuppressColumns: [ 'id','index', 'iu', 'me' ],
			    showGridFooter: true,
			    showColumnFooter: true,
			    rowTemplate: '<div ng-click="grid.appScope.onRowClick(row)" ng-repeat="(colRenderIndex, col) in colContainer.renderedColumns track by col.uid" class="ui-grid-cell" ng-class="col.colIndex()" ui-grid-cell></div>'
		};
		
		$scope.$watch( ResponsiveDetection.getBreakpoint, $scope.toggleMiniList);
		
		$scope.billGridOptions.columnDefs = [];

		$scope.$watch(
			function(scope) {
				return scope.model.demListeItemUpdated().val;
			},
			function(newVal, oldVal, scope) {
				if (newVal>oldVal) {
					scope.billGridApi.grid.notifyDataChange(uiGridConstants.dataChange.ALL);
				}
			}
		);
				
		// pour forcer la sélection dans le ui-grid de la currDemForListe. Nécessaire quand new fact et quand passe de minimalist à normal
		$scope.$watch(
				function(scope) {
					return scope.model.demListeShowCurrentDemForListe().val;
				},
				function(newVal, oldVal, scope) {
					//var nbWatches = scope.$$watchersCount;
					//$log.log(nbWatches + " watches actifs.");
					if (newVal>oldVal) {
						if (angular.isDefined(scope.model.currentDemForListe().dt)) {
							scope.billGridApi.selection.selectRow(that.model.currentDemForListe());
						}
					}
				}
		);
		$scope.$watch(
				function(scope) {
					return scope.model.demListeShowSelected().val;
				},
				function(newVal, oldVal, scope) {
					if (newVal>oldVal && angular.isDefined(scope.model.currentDemForListe().dt)) {
						scope.billGridApi.grid.cellNav.clearFocus();
						scope.billGridApi.selection.clearSelectedRows();
						scope.billGridApi.selection.selectRow(that.model.currentDemForListe());
						scope.billGridApi.core.scrollTo(scope.billGridOptions.data[scope.billGridOptions.data.length - 1], scope.billGridOptions.columnDefs[1]);
						$timeout(scope.billGridApi.cellNav.scrollToFocus(scope.model.currentDemForListe(), null), 100);
					}
				}
		);
		$scope.$watch(
			function(scope) {
				return scope.model.currDemListeUpdated().val;
			},
			function(newVal, oldVal, scope) {
				if (newVal>oldVal && that.colDefDone && angular.isDefined(scope.billGridApi)) {
					MyNamespace.helpers.clearAndAddToArray(scope.billGridOptions.data, that.model.currentDemListe().values());
					if (scope.billGridOptions.data.length>0) {
						that.setCurrBill($scope.billGridOptions.data[$scope.billGridOptions.data.length-1]);
						$timeout(function() {
							$scope.billGridApi.core.scrollTo($scope.model.currentDemForListe(), null);
						}, 100);
					}
				}
			}
		);
		
		var filterWithNot = {
	          condition: function(searchTerm, cellValue) {
	        	  var st = searchTerm.trim().replace(/\\/g, '').toUpperCase();
	        	  var isString = typeof cellValue === 'string' || cellValue instanceof String;
	        	  if (st.startsWith('!')) {
	        		  var nst = st.substr(1);
	        		  if (nst.length==0) return true;
	        		  
        			  return isString ? cellValue.toUpperCase().indexOf(nst)===-1 :  cellValue!=nst;	        			  
	        	  } else {
	        		  return isString ? cellValue.toUpperCase().indexOf(st)!==-1 : cellValue==st;
	        	  }
	        	  return false;
	          }
		};
		var selectionCellTemplate = '<div class="ngCellText ui-grid-cell-contents">' +
        ' <div ng-click="grid.appScope.rowClick(row)">{{COL_FIELD}}</div>' +
        '</div>';
		var selectionCellTemplateCurrRight = '<div class="ngCellText ui-grid-cell-contents">' +
		' <div ng-click="grid.appScope.rowClick(row)" style="text-align: right;">{{COL_FIELD | currency}}</div>' +
		'</div>';
		/*
		 * le code pour prg a du être changé car quand il y a plusieurs items et qu'on scrolle, la valeur des row.entity.prg n'était pas updaté correctement
		 */
		$timeout( function() {
			$scope.billGridOptions.columnDefs.push(
					{field: 'prg', displayName: 'C', allowCellFocus: false, cellClass:$scope.demStatus, pinnedLeft:true, headerTooltip: function(col) {return "État de la communication avec la RAMQ";}, width: 30, enableHiding: true, enableFiltering:false, headerCellClass: $scope.highlightFilteredHeader, 
						cellTemplate: '<div class="ui-grid-cell-contents">'+
						'<div ng-switch="row.entity.prg"> '+
						'<div ng-switch-when="1" style="color: black;" class="fa fa-circle-o-notch fa-spin-infodata fa-fw" aria-hidden="true"></div> '+
						'<div ng-switch-when="2" style="color: green;" class="fa fa-check-circle fa-fw" aria-hidden="true"></div>'+
						'<div ng-switch-when="3" style="color: red;" class="fa fa-exclamation-triangle fa-fw" aria-hidden="true"></div>'+
						'</div></div>'},
					{field: 'no', displayName: 'N', allowCellFocus: true, cellClass:$scope.demStatus, headerTooltip: function(col) {return "Note personnelle";}, width: 30, enableHiding: true, enableFiltering:false, headerCellClass: $scope.highlightFilteredHeader, 
						cellTemplate: '<div class="ui-grid-cell-contents">'+
						'<div ng-switch="row.entity.no"> '+
						'<div ng-switch-when="0" class="fa fa-plus-circle fa-fw" aria-hidden="true" data-ng-click="grid.appScope.editNotePers(row);" title="Ajouter une note personnelle"></div>'+
						'<div ng-switch-when="1" style="color: yellow;" class="fa fa-sticky-note fa-fw" aria-hidden="true" data-ng-click="grid.appScope.editNotePers(row);" title="{{row.entity.np}}"></div>'+
						'</div></div>'},
					{field: 'cdt', displayName: 'Date de création', type:'string',filter: _.cloneDeep(filterWithNot),
						sort: {
							direction: uiGridConstants.ASC,
							ignoreSort: false,
							priority: 0
						},
						cellClass: function(grid, row, col, rowRenderIndex, colRenderIndex) {
							if (row.entity.mdt) {
								return $scope.demStatus(grid, row, col, rowRenderIndex, colRenderIndex) + ' forceItalic';
							}else{
								return $scope.demStatus(grid, row, col, rowRenderIndex, colRenderIndex);
							}
						}, cellTemplate: selectionCellTemplate, 
						headerTooltip: function(col) {return "Date et heure de création";}, width: 160, enableHiding: true, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'pt', displayName: 'Patient',filter: _.cloneDeep(filterWithNot),cellClass:$scope.demStatus, cellTemplate: selectionCellTemplate, width: 250, enableHiding: true, cellTooltip:false, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'ii', displayName: 'No. Prof.',filter: _.cloneDeep(filterWithNot),cellClass:$scope.demStatus, cellTemplate: selectionCellTemplate, headerTooltip: function(col) {return "Numéro du professionnel qui a rendu le service";}, width: 90, enableHiding: true, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'noExt', displayName: 'No local',filter: _.cloneDeep(filterWithNot),cellClass:$scope.demStatus, cellTemplate: selectionCellTemplate, headerTooltip: function(col) {return "Numéro local de la facture";}, width: 60, enableHiding: false, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'noRfp', displayName: 'No RAMQ',filter: _.cloneDeep(filterWithNot),cellClass:$scope.demStatus, cellTemplate: selectionCellTemplate, headerTooltip: function(col) {return "Numéro de la facture de la RAMQ";}, width: 120, enableHiding: false, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'sr', displayName: 'Statut', filter: {
						noTerm: true,
						type: uiGridConstants.filter.SELECT,
						selectOptions: [ { value: '0', label: 'Attente' }, { value: '1', label: 'Acceptée' }, { value: '2', label: 'Refusée' }, { value: '3', label: 'Acceptée en partie' }]
					}, cellFilter: 'mapStatus:grid.appScope', cellClass:$scope.demStatus, headerTooltip: function(col) {return "Status de la demande";}, width: 100, enableHiding: true, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'hon', displayName: 'Honor.',exporterPdfAlign: 'right', cellFilter:'currency', cellClass:$scope.demStatus, cellTemplate: selectionCellTemplateCurrRight, headerTooltip: function(col) {return "Honoraires préliminaires";}, width: 100, type:'number', enableHiding: true, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader, aggregationType: uiGridConstants.aggregationTypes.sum},
					{field: 'sp', displayName: 'Statut Pmt', filter: {
						noTerm: true,
						type: uiGridConstants.filter.SELECT,
						selectOptions: [ { value: '1', label: 'Non conf.' }, { value: '2', label: 'Confirmé' }, { value: '4', label: 'Différent' }, { value: '8', label: 'Modifié' }, { value: '16', label: 'Retenu' }, { value: '32', label: 'En révision' }]
					}, cellFilter: 'mapStatutPmt:grid.appScope', cellClass:$scope.demStatus, headerTooltip: function(col) {return "Statut du paiement";}, width: 100, enableHiding: true, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'mp', displayName: 'Payé', exporterPdfAlign: 'right', cellFilter:'currency', cellClass:$scope.demStatus, cellTemplate: selectionCellTemplateCurrRight, headerTooltip: function(col) {return "Honoraires payés";}, width: 100, type:'number', enableHiding: true, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader, aggregationType: uiGridConstants.aggregationTypes.sum},
					{field: 'dt', displayName: 'Type', type:'string', filter: {
						noTerm: true,
						type: uiGridConstants.filter.SELECT,
						selectOptions: [ { value: '1', label: 'Dem. Paimt' }, { value: '2', label: 'Dem. Modif' }, { value: '3', label: 'Dem. Annul' },
						                 { value: '4', label: 'D.Paimt Reçue' },{ value: '5', label: 'D.Modif Reçue' },{ value: '6', label: 'D.Annul Reçue' }]
					}, cellFilter: 'mapTypDem:grid.appScope', cellClass:$scope.demStatus, headerTooltip: function(col) {return "Type de demande de paiement";},width: 120, enableHiding: true, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'mdt', displayName: 'Date et Hre Mod.', cellClass:$scope.demStatus, cellTemplate: selectionCellTemplate, headerTooltip: function(col) {return "Date et heure de modification";}, width: 170, enableHiding: true, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'me', displayName: 'Message Explicatif',filter: _.cloneDeep(filterWithNot), cellClass:$scope.demStatus, cellTemplate: selectionCellTemplate, width: 300, enableHiding: false, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader},
					{field: 'iu', displayName: 'Util.', filter: {
						noTerm: true,
						type: uiGridConstants.filter.SELECT,
						selectOptions: $scope.currentUserList()
					}, cellFilter: 'userName:grid.appScope', cellClass:$scope.demStatus, headerTooltip: function(col) {return "Créée ou modifiée par";}, width: 120, enableHiding: false, cellTooltip: false, headerCellClass: $scope.highlightFilteredHeader},
					{ name: 'index',  cellTemplate: '<div ng-switch="row.entity.dl"> ' + 
						'<div ng-switch-when="1" class="grid-action-cell">' +
							"<button class='btn-emoji dxDelBtn' title='Retirer le statut <Effacé>' data-ng-click='grid.appScope.restoreBill(row);' ng-bind-html=\"'2714' | exposeEmoji\"></button></div>" +
						'<div ng-switch-when="0" class="grid-action-cell">'+
							"<button class='btn-emoji dxDelBtn' data-ng-if='grid.appScope.showDeleteButton(row.entity)' title='Assigner le statut <Effacé>' data-ng-click='grid.appScope.deleteBill(row);' data-confirm=\"Veuillez confirmer l'effacement de cette facture.\" data-confirm-title='Demande de confirmation' ng-bind-html=\"'274c' | exposeEmoji\"></button></div></div>", displayName: '', enableHiding: false, enableFiltering:false, enableColumnMenu:false, width: "24"}
			);
			$scope.billGridOptions.data = that.model.currentDemListe().values();
			that.colDefDone = true;
		}, 100);

		$scope.billGridOptions.onRegisterApi = function(gridApi){
			//set gridApi on scope
			$scope.billGridApi = gridApi;
			gridApi.selection.on.rowSelectionChanged($scope,function(row){
				if (angular.isDefined($scope.scroll_time_out)) {
					$timeout.cancel($scope.scroll_time_out);
				}
				var obj = row.entity;
				var currDFL = that.model.currentDemForListe();
				if (obj.tag!=currDFL.tag || (obj.mdt!=currDFL.mdt) || $scope.billGridOptions.data.length===1) {
					$scope.scroll_time_out = $timeout(function () {
						that.setCurrBill(obj);
						$scope.billGridApi.core.notifyDataChange(uiGridConstants.dataChange.ALL);
					}, 250);
				}
			});
			gridApi.cellNav.on.navigate($scope,function(newRowCol, oldRowCol){
				$scope.billGridApi.selection.selectRow(newRowCol.row.entity);
			});
		};
		
		that.rowClick = function(row) {
			var obj = row.entity;
			that.setCurrBill(obj);
			$timeout(function(){$scope.billGridApi.core.notifyDataChange(uiGridConstants.dataChange.ALL);}, 1);
		};
		that.restoreBill = function(row) {
			if (arguments.length==0) {
				row = $scope.billGridApi.selection.getSelectedRows()[0];
			}
			that.model.restoreBill(row.entity.tag);
		};
		that.editNotePers = function(row) {
			var actualNp = row.entity.np;
			if (arguments.length==0) {
				row = $scope.billGridApi.selection.getSelectedRows()[0];
			}
			$scope.editNotePersOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modalNoTitle.html",
				controller: 'ModalInstanceCtrl',
				size: "sm",
				resolve: {
					mObject: function () {
						return {
							templateUrl:"/syra/Resources/views/editNotePers.html",
							modalData: row.entity
						};
					}
				}
			});
			$scope.modalInstance.result.then(function (np) {
				// jamais appelé car pas de bouton ok ici.
			}, function () {
				if (actualNp!=row.entity.np) {
					row.entity.no = MyNamespace.helpers.isEmpty(row.entity.np) ? 0 : 1;
					that.model.saveCurrDemForListValue('np', row.entity.np, true);					
				}
				$scope.editNotePersOpened = false;
			});
		};
		that.deleteBill = function(row) {
			if (arguments.length==0) {
				row = $scope.billGridApi.selection.getSelectedRows()[0];
			}
			if (that.showDeleteButton(row.entity)) {
				if (that.model.currentDefault().canDelAnyBill!==true && (row.entity.sr&1)==1) {
					new jBox('Notice', {
						autoClose: 3000,
						color : 'red',
						title:"",
						content: "Effacement non permis, car cette facture a déjà été reçue par la RAMQ"
					});
				} else {
					that.model.deleteBill(row.entity.tag);
				}
			} else {
				that.model.message("Effacement interdit en mode de fonctionnement normal.", "red");
			}
		};
		
		that.showDeleteButton = function(entity) {
			return entity.dl===0 && (that.model.currentDefault().canDelAnyBill===true || MyNamespace.helpers.isEmpty(entity.noRfp) || !that.model.hasDemPaimt());
		};
		$scope.currentUserList = function() {
			var users = that.model.currentUsersList();
			var ul = users.length;
			var usersObj = [];
			for (var i=0;i<ul;i++) {
				var u = users[i];
				usersObj.push({value: u.id, label:u.name});
			}
			return usersObj;
		}
		
		// légende: background: blanc = attente, bleu = ready (terminé), jaune = refusé (partiel ou complet), vert = accepté
		// font: noir = attente ou non terminé, accepté = bleu (partiel ou complet), rouge = refusé, vert s'il s'agit d'une dp d'annulation
		$scope.demStatus = function(grid, row, col, rowRenderIndex, colRenderIndex) {
			if (angular.isUndefined(row.entity)) return "";
			var selected = '';
			if (row.isSelected) {
				selected = '-selected';
			}
			if (row.entity.dl===1) {	// deleted
				return 'demDeleted'+selected;
			} else if (row.entity.sr==1) {
				if (row.entity.dt==3 || row.entity.dt==6) {
					return 'demAnnuAccepte'+selected;
				}
				return 'demAccepte'+selected;
			} else if ((row.entity.sr&2)==2) {
				if (row.entity.sr==2) {
					// entièrement refusé
					return 'demRefuse'+selected;
				}
				// refus slm de une ou ++ lignes
				return 'demRefusePartiel'+selected;
			} else if (row.entity.ready==false || (row.entity.prg!=0 && row.entity.prg!=3)) {
				return 'demNonTermine'+selected;
			} else if (row.entity.sr==0) {
				return 'demAttente'+selected;
			}
		};

		$scope.highlightFilteredHeader = function( row, rowRenderIndex, col, colRenderIndex ) {
			if( col.filters[0].term ){
				return 'header-filtered';
			} else {
				return '';
			}
		};


		$scope.$on("$destroy", function(){
			$timeout.cancel();
		});	

        $timeout(function () {
        	if (angular.isUndefined(that.model.currentGlobalDefault()['show_news']) || that.model.currentGlobalDefault()['show_news']===true) {
				$http({
					method : "GET",
					url : "/syra/buildversionforhelp/get?&u=" + clientUid
				}).then(function mySucces(response) {
					MyNamespace.helpers.versionUrl(response.data);
					$confirm({
						text:"<a href='javascript:void(0)' onclick='MyNamespace.helpers.showNews(" +
							");' class='clickable'>Cliquez pour voir les nouveautés. </a>",
						ok:'Ne plus me le rappeler',
						cancel:'Fermer',
						title:"Nouvelle version Syra-MED!"
					})
					.then(function(res) {
						that.model.setCurrGlobalDefaultValues('show_news', false);
						that.model.saveCurrGlobalDefaultValues('show_news');
					});			
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
        	}		
        }, 5000);
	}]);

	bill.filter('mapStatutPmt', function() {
		var statusHash = {
				1: 'Non conf.',
				2: 'Confirmé',
				4: 'Différent',
				8: 'Modifié',
				16: 'Retenu',
				32: 'En révision'
		};
		return function(input) {
			if (isNaN(input)){
				return '';
			} else {
				return statusHash[input];
			}
		};
	});

	bill.filter('mapStatus', function() {
		var statusHash = {
				0: 'Attente',
				1: 'Acceptée',
				2: 'Refusée',
				3: 'Acceptée en partie'
		};
		return function(input) {
			if (isNaN(input)){
				return '';
			} else {
				return statusHash[input];
			}
		};
	});
	
	bill.filter('userName', function() {
		return function(input, scope) {
			if (angular.isUndefined(input) || input=='' || input==null) {
				return '';
			} else if (isNaN(input)){
				var id = input.split(' ');
				if (isNaN(id[0])){
					return input;
				} else {
					return scope.model.getUser(id[0]-0).name + ' ' + id[1];
				}
			} else {
				if (angular.isDefined(scope.model)) {
					var user = scope.model.getUser(input);
					if (user!==null) {
						return user.name;
					}					
				} else {
					$log.log("model non défini...");
				}
				return '';
			}
		};
	});

	bill.filter('inscription', function() {
		return function(input, scope) {
			if (angular.isUndefined(input) || input=='' || input==null) {
				return '';
			} else if (isNaN(input)){
				var id = input.split(' ');
				if (isNaN(id[0])){
					return input;
				} else {
					return scope.inscriptions[id[0]*1] + ' ' + id[1];
				}
			} else {
				return scope.inscriptions[input*1];
			}
		};
	});
	
	bill.filter('oui_non', function() {
		return function(input, scope) {
			if (angular.isUndefined(input) || input=='' || input==null) {
				return '';
			} else if (isNaN(input)){
				var id = input.split(' ');
				if (isNaN(id[0])){
					return input;
				} else {
					return scope.OuiNon[id[0]*1] + ' ' + id[1];
				}
			} else {
				return scope.OuiNon[input*1];
			}
		};
	});
	
	bill.filter('mapTypDem', function() {
		var typDemHash = {
				1: 'Dem. Paimt',
				2: 'Dem. Modif',
				3: 'Dem. Annul',
				4: 'D.Paimt Reçue',
				5: 'D.Modif Reçue',
				6: 'D.Annul Reçue',
		};
		return function(input) {
			if (isNaN(input)){
				return '';
			} else {
				return typDemHash[input];
			}
		};
	});

	bill.filter('capitalize', function() {
		function capWord(txt) {
			return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
		}
		return function(input, isEveryWord) {
			return (!input) ? '' : (!isEveryWord) ? capWord(input) : input.replace(/([^\W_]+[^\s-]*) */g, capWord);
		};
	});
	
	bill.filter('currencyFilter', function () {
		  return function (value) {
		    return '$' + value.toFixed(2);
		  };
		})	

})();