var MyNamespace = MyNamespace || {};

var versionUrl = "";
MyNamespace.helpers = {
   clearAndAddToArray: function(actual, toAdd) {
	  actual.length = 0;
	  for (var i = 0; i < toAdd.length; i++) {
	    if (toAdd[i]) {
	    	actual.push(toAdd[i]);
	    }
	  }
   },
   cleanArray: function(actual) {
	   var newArray = new Array();
	   for (var i = 0; i < actual.length; i++) {
		   if (actual[i]) {
			   newArray.push(actual[i]);
		   }
	   }
	   return newArray;
   },
   remove: function(item, arr) {
	   var idx = $.inArray(item, arr);
	   if (idx!=-1) {
		   arr.splice(idx,1);
	   }
	  return arr;
   },
   removeWithNoLigne: function(noLigne, arr) {
	   for (var o in arr) {
		   if (arr[o].noLigne==noLigne) {
			   var idx = $.inArray(arr[o], arr);
			   if (idx!=-1) {
				   arr.splice(idx,1);
			   }	   
		   }
	   }
	   return;
   },
   convertDateStringsToDates: function(input) {
	   var regexIso8601 = /^(\d{4}|\+\d{6})(?:-(\d{2})(?:-(\d{2})(?:T(\d{2}):(\d{2}):(\d{2})\.(\d{1,})(Z|([\-+])(\d{2}):(\d{2}))?)?)?)?$/;
	    // Ignore things that aren't objects.
	    if (typeof input !== "object") return input;
	    for (var key in input) {
	        if (!input.hasOwnProperty(key)) continue;
	        var value = input[key]; var match;
	        // Check for string properties which look like dates.
	        if (typeof value === "string" && (match = value.match(regexIso8601))) {
	            var milliseconds = Date.parse(match[0])
	            if (!isNaN(milliseconds)) {
	                input[key] = new Date(milliseconds);
	            }
	        } else if (typeof value === "object") {
	            // Recurse into object
	        	MyNamespace.helpers.convertDateStringsToDates(value);
	        }
	    }
   },
   abbreviate: function(str, max, suffix) {
	   if((str = str.replace(/^\s+|\s+$/g, '').replace(/[\r\n]*\s*[\r\n]+/g, ' ').replace(/[ \t]+/g, ' ')).length <= max) {
		   return str;
	   }
	  var abbr='',str=str.split(' '),suffix=(typeof suffix!=='undefined'?suffix:' ...'),max=(max-suffix.length);
	  for(var len = str.length, i = 0; i < len; i ++){
	    if((abbr + str[i]).length < max){
	      abbr += str[i] + ' ';
	    } else {break;}
	  }
	  return abbr.replace(/[ ]$/g, '') + suffix;
   },
   isEmpty: function(v) {
		return angular.isUndefined(v) || v==null || v=='';
   },
   isNotEmpty: function(v) {
		return angular.isDefined(v) && v!==null && v!=='';
   },
   isObject: function(v) {
		return $.isPlainObject(v);
   },
   compare: function (obj1, obj2) {
		//Loop through properties in object 1
		if ((this.isEmpty(obj1) && this.isNotEmpty(obj2)) || 
				(this.isEmpty(obj2) && this.isNotEmpty(obj1))) {
			return false;
		} else if (this.isEmpty(obj1) && this.isEmpty(obj2)) {
			return true;
		}
		for (var p in obj1) {
			//Check property exists on both objects
			if (obj1.hasOwnProperty(p) !== obj2.hasOwnProperty(p)) {
				return false;
			}
	 
			switch (typeof (obj1[p])) {
				//Deep compare objects
				case 'object':
					if (!this.compare(obj1[p], obj2[p])) {
						return false;
					}
					break;
				//Compare function code
				case 'function':
					if (typeof (obj2[p]) == 'undefined' || (p != 'compare' && obj1[p].toString() != obj2[p].toString())) {
						return false;
					}
					break;
				//Compare values
				default:
					if (obj1[p] != obj2[p]) {
						return false;
					}
			}
		}
	 
		//Check object 2 for any extra properties
		for (var p in obj2) {
			if (typeof (obj1[p]) == 'undefined' && typeof (obj2[p]) !== 'undefined')  {
				return false;
			}
		}
		return true;
	},
	isDate: function(x) {
	  return (null != x) && !isNaN(x) && ("undefined" !== typeof x.getDate);
	},
	versionUrl: function(v) {
		if (arguments.length) {
			versionUrl = v;
		}
		return versionUrl;
	},
	showNews: function() {
		var url = "http://ofys.ca/ofys_aide/fr/syra_news.html";
		if (versionUrl) {
			url = "http://ofys.ca/ofys_aide/fr/syra_news" + versionUrl + ".html";
		}
		if (typeof openHelp === "function") { 
			openHelp(url);
		    // safe to use the function
		} else {
			window.open(url, url);				
		}
	}
 };

// voir http://stackoverflow.com/questions/4343746/is-there-a-data-structure-like-the-java-set-in-javascript 
function StringSet() {
    var setObj = {}, val = {};

    this.add = function(str) {
        setObj[str] = val;
    };

    this.contains = function(str) {
        return setObj[str] === val;
    };

    this.remove = function(str) {
        delete setObj[str];
    };

    this.values = function() {
        var values = [];
        for (var i in setObj) {
            if (setObj[i] === val) {
                values.push(i);
            }
        }
        return values;
    };
}

var myAppGrid={
	vthresh: 5,
	scrollt: 80,
	wheelst: 150,
	exRows: 1		
};
var CONFIG = {
    		'PROF':'prof',
    		'LOCAL':'local',
    		'TYP_LOC_ETAB':'typ_loc_etab',
    		'ETABLISSEMENT':'etab',
    		'SECTEUR':'sect',
    		'DATE_DEFAULT':'dateDefault',
    		'BILL_USER':'billsUser',
    		'BILL_LIST_DATE':'billListDate',
    		'AUTO_SEND':'autoSend',
    		'RECHERCHE_PATIENTS':'recherchePatients',
   			'DEFAUT_SANS_NAM':'defautSansNam',
   			'DEFAUT_ID_PERS_AUTRE':'defautIdPersAutre',
			'COD_PRECI_LIEU':"codPreciLieu",
			'COD_PRECI_SECT_ACTIV':"codPreciSectActiv",
			'TYP_LIEU_GEO':"typLieuGeo",
			'TYP_ID_LIEU_GEO':"typIdLieuGeo",
			'LAST_COD_ROLE':"lastCodRole",
			'DEM_PAIMT_TYPE':"demPaimtType"
    			};

var MSG_TEXT = {
		'MAX_DATA': 2000,
		'TROP_DATA': "Il y a trop de données à exporter. Veuillez faire une sélection pour limiter ce nombre."
};
/*
 * SEE_VALUES - selon SyraSettings
see_dateEntree
see_detailsPatient
see_lieuRef
see_tabStopRole
see_tabStopDate
see_lstMesur
see_dhdElmFact
see_mntPrcuPatnt
see_indFactAssDr
see_refreAutreProf
see_dhdInterAutreMd
see_lstFactContx
see_codPreciSectActiv
see_noAutor
see_localGere
 */

(function(){    
	var syra = angular.module("syra", ['i18n','cfp.hotkeys', 'settings', 'ngCookies', 'widget', 'user', 'mgcrea.ngStrap', 'ngSanitize', 'ngAnimate',
	                                   'billing', 'professional', 'patient', 'billEntry', 'fav', 'sommaire', 'concil', 'ui.grid.exporter', 'angular-notification-icons',
	                                   'etab', 'dateDefaut','editpatient','ui.utils.masks', 'datetimeboot','ui.toggle','angular.bind.notifier',
	                                   'angular-websocket','ui.bootstrap', 'angular-confirm', 'b2b', 'ngRoute','angular-loading-bar', 'ngProgress']);
	
	
	syra.config(function($routeProvider) {
        $routeProvider
            // route for the home page
            .when('/', {
            	redirectTo:'/auth',
            })
            // route for the about page
            .when('/auth', {
                templateUrl : '/syra/Resources/views/auth/authView.html',
                controller: 'AuthController as auth'
            })
            // route for the contact page
            .when('/bill', {
                templateUrl : '/syra/Resources/views/bill.html',
            })
            .otherwise({redirectTo:'/auth'});
    });
	
	//IE seems to cache ajax request and prevent syra from getting certain essential data
	//Defaults(default selections) and Users list are cached and are not updated 
	//(this is to ensure that there is no cache on ajax calls that are always changing)
	syra.config(['$httpProvider', function($httpProvider) {
	    //initialize get if not there
	    if (!$httpProvider.defaults.headers.get) {
	        $httpProvider.defaults.headers.get = {};    
	    }    
	    //disable IE ajax request caching
	    $httpProvider.defaults.headers.get['If-Modified-Since'] = 'Mon, 26 Jul 1997 05:00:00 GMT';
	    // extra
	    $httpProvider.defaults.headers.get['Cache-Control'] = 'no-cache';
	    $httpProvider.defaults.headers.get['Pragma'] = 'no-cache';
	}]);
	
	// la ligne  $compile(domspace)(scope); dans DynaAssist.js n'est pas compatible avec false. 
//	syra.config(['$compileProvider', function ($compileProvider) {
//		  $compileProvider.debugInfoEnabled(false);
//	}]);
	// If you wish to debug an application with this information then you should open up a debug console in the browser then call this method directly in this console:
	// angular.reloadWithDebugInfo();
	
	syra.run(['$rootScope', '$location', 'AuthService',
	          function ($rootScope, $location, AuthService) {
	        $rootScope.$on('$routeChangeStart', function (event) {
	        	var isConnected = AuthService.isAuthenticated().status;
		        if (!isConnected && $location.$$path != "/auth") {
		          console.log('DENY : Redirecting to Login');
		          event.preventDefault();
		          $location.path('/auth');
		        }
		        else {
		          console.log('ALLOW');
		        }
	        });
	}]);
		
	syra.factory('AuthService', ['$cookies','model','$location', function($cookies, model, $location){
		var cookieSyraSharePass = "syra_cookie_infodata_sharePass";
		function getUserPass(){
			var pass = $cookies.get(cookieSyraSharePass);
			if (!angular.isDefined(pass)) {
				return "";
			}else{
				return pass;
			}
		}
		function logIn(sharePswd){
			var pswd = model.currentGlobalDefault()['share_motDePasse'];
			if(!$.isEmptyObject(sharePswd) &&
					pswd === sharePswd){
				$cookies.put(cookieSyraSharePass,sharePswd, {expires:new Date('2099-12-31T12:00:00')}); 
				return true;
			}else{
				return false;
			}
		}
		function logOut(){
			$cookies.remove(cookieSyraSharePass);
		}
		var isLocal = (document.location.hostname == "localhost" ||
				document.location.hostname == "127.0.0.1");
		//returns the auth status payload {status: bool, code: string} 
		//"OK" ==> user is authenticated
		//"SHARECONPASS" ==> user requires a share password
		//"MISSINGCRED" ==> Missing credentials (user is not logged in med-office
		//"" ==> user is authenticated
		function isAuthenticated(){
			if(isLocal){
				return model.hasActiveUser() ? 
						{status:true, code:"OK"}
						:{status:false, code:"MISSINGCRED"};
			}else if(model.hasActiveUser()){
				if(model.currentGlobalDefault()['share_needsPswd']){
					var pswd = model.currentGlobalDefault()['share_motDePasse'];
					var loggedPswd = getUserPass();
					if(!$.isEmptyObject(loggedPswd) &&
							pswd === loggedPswd){
						return {status:true, code:"OK"}
					}else{
						return {status:false, code:"SHARECONPASS"};
					}
				}else{
					return {status:true, code:"OK"}
				}
			}else{
				return {status:false, code:"MISSINGCRED"};
			}
		}
		function checkAuth(){
			var auth = isAuthenticated();
			if(!auth.status){
				$location.path('/auth');
			}
		}
		return {
			isAuthenticated: isAuthenticated,
			checkAuth: checkAuth,
			getUserPass : getUserPass,
			logIn: logIn,
			logOut : logOut,
			isLocal :isLocal
		}
	}]);
	
	syra.controller('AuthController', ['$scope', '$location','SyraWebSocket', 'model', 'clientUid','$cookies', '$http', 'AuthService',
	                 function ($scope, $location,SyraWebSocket, model, clientUid, $cookies, $http, AuthService) {
		// doit être lancé initialement car c'est aussi ce call qui triggers l'envoi des defauts via websocket
		// déménagé ici car on ne doit pas initialiser plus de une fois ce code - ce qui n'était pas le cas lorsque dans user.js
		getUsers();
		
		
		function getUsers() {
			$http({
		        method : "GET",
		        url : "/syra/users?u=" + clientUid
		    }).then(function mySucces(response) {
		    	model.setUsersList(response.data);
		    	getActiveUser();
		    }, function myError(response) {
		        $scope.myWelcome = response.statusText;
		    });
		}
		function getActiveUser() {
			$http({
				method : "GET",
				url : "/syra/activeuser?u=" + clientUid
			}).then(function mySucces(response) {
				if(response.data != null){
					model.setCurrUser(response.data);
				}
				authenticate();
			}, function myError(response) {
				authenticate();
			});
		}
		function authenticate(){
			var auth = AuthService.isAuthenticated();
			if(auth.status){
				$location.path('/bill');
			}else{
				$scope.auth = auth;
				if(angular.isDefined($scope.reloading) && $scope.reloading ){
					new jBox('Notice', {
						autoClose: 1500,
						color : 'red',
						title:"",
						content: "Échec de rechargement"
					});
				}
			}
			$scope.reloading = true;
		}
		
		$scope.login = function(){
			if(AuthService.logIn($scope.shrPswd))
				$location.path('/bill');
			else
				$scope.err = "Mot de passe invalide";
		}
		$scope.reload = function(){
			$scope.reloading = true;
			getUsers();
		}		
//		checkIfAuthenticated();
	}]);
		
//	syra.directive('elementSizeMonitor', [function () {
//	    return {
//	        replace: false,
//	        restrict: 'A',
//	        scope: {
//	            resizeHeight: '=',
//	            resizeWidth: '=',
//	        },
//	        link: function (scope, element, attrs) {
//	            scope.$watch(
//	                function () { return [element[0].clientWidth, element[0].clientHeight].join('x'); },
//	                function (value) {
//	                    scope.resizeHeight = element[0].clientHeight;
//	                    scope.resizeWidth = element[0].clientWidth;
//	                }
//	            );
//	        }
//	    };
//	}]);

	syra.directive('elhtml', [ function () {
		  return {
			    restrict: 'A',
			    link: function (scope, element, attrs) {
			      element.html(attrs.elhtml);
			    }
			  }
			}]);
	
	syra.directive('showFocus', function($timeout) {
		  return function(scope, element, attrs) {
		    scope.$watch(attrs.showFocus, 
		      function (newValue) { 
		        $timeout(function() {
		            newValue && element.focus();
		        });
		      },true);
		  };    
		});
	
	// not to tab in headers of grid
	syra.directive("uiGridHeaderCell", function(){
	      return {
	        restrict: 'C',
	        link: function(scope, element, attrs){
	          element.find('[role="button"]').removeAttr('tabindex');
	        }
	      };
	});

	syra.directive('multiswitchWhen', function () {
		  return {
			    transclude: 'element',
			    priority: 800,
			    require: '^ngSwitch',
			    link: function(scope, element, attrs, ctrl, $transclude) {
			      var selectTransclude = { transclude: $transclude, element: element };
			      angular.forEach(attrs.multiswitchWhen.split('|'), function(switchWhen) {
			        ctrl.cases['!' + switchWhen] = (ctrl.cases['!' + switchWhen] || []);
			        ctrl.cases['!' + switchWhen].push(selectTransclude);
			      });
			    }
			  }
			});
	
	syra.directive('checkPostal', function() {
		return {restrict: 'A',require: 'ngModel',
			link: function(scope, elem, attr, ngModel) {
				ngModel.$validators.postalcode = function(val) {
					var regexp = /^[ABCEFGHJKLMNPRSTVXY][0-9][ABCEFGHJKLMNPRSTVWXYZ][0-9][ABCEFGHJKLMNPRSTVWXYZ][0-9]$/i;
					if (val){return regexp.test(val);
					}else{return true;}
				};
			}
		};
	});
	/*
	 * voir https://github.com/angular/angular.js/issues/1460
	 * Nécessaire pour que le modele soit sync avec les valeurs mises par autocomplete (le menu de texte suggéré par le navigateur)
	 */
	syra.directive('input', ['$timeout',
	                           function ($timeout) {
	                               return {
	                                   restrict: 'E',
	                                   require: '?ngModel',
	                                   link: function ($scope, element, attrs, controller) {
	                                       if (!attrs.type || attrs.type !== "text" || !controller) {
	                                           return;
	                                       }
	                                       element.on('blur', function () {
	                                    	   $timeout(function() {
		                                           $scope.$apply(function () {
		                                               controller.$setViewValue(element.val());
		                                           });
	                                           }, 0)
	                                       });
	                                   }
	                               };
	                           }
	                       ]);

	syra.directive('uppercase', function() {
	    return {
	        require: 'ngModel',
	        link: function(scope, element, attrs, modelCtrl) {
	            modelCtrl.$parsers.push(function(input) {
	                return input ? input.toUpperCase() : "";
	            });
	            element.css("text-transform","uppercase");
	        }
	    };
	});
	
	//console.log("A key and a callback is required.");	
	// une directive pour mettre le focus sur un input, p.ex. après un click. 
	// Voir le input du NAM du patient dans index.html et le input du dx et 
	// de leur bouton + correspondant.
	syra.directive('inputFocusFunction', function () {
        'use strict';
        var lastFocused = Date.now();
        return {
            restrict: 'A',
            link: function (scope, element, attr) {
                scope[attr.inputFocusFunction] = function (b) {
                    var newFocused = Date.now();                	
                	if (arguments.length) {	// setfocus appelé juste pour avoir un lieu de focus lors de certaines tâches
                		element[0].focus();                		
                	} else if (newFocused-lastFocused > 300) {
                		lastFocused = newFocused;
                		element[0].focus();
                	}
                };
            }
        };
    });
	
	syra.factory('clientUid', myClientUid);
	myClientUid.$inject = ['$cookies'];	// pour qu'un reload ne force pas un nouveau backend, mais reprend celui lié au cookie.
	
	function myClientUid($cookies) {
		var cookieSyra = "syra_cookie_infodata";
		var uid = $cookies.get(cookieSyra);
		if (!angular.isDefined(uid)) {
			uid=generateUIDNotMoreThan1million();
			$cookies.put(cookieSyra,uid, {expires:new Date('2099-12-31T12:00:00')}); 
		}
		// 5 ctrs, 4m de possibilités. C'est suffisant pour nos besoins
		function generateUIDNotMoreThan1million() {
		    return ("00000" + (Math.random()*Math.pow(36,5) << 0).toString(36)).slice(-5)
		}
		return uid;
	}
	
	syra.factory('model', ['$log', '$http', '$timeout', 'clientUid', function($log, $http, $timeout, clientUid) {
		var helpers = MyNamespace.helpers;
		var firstFocus = function(){};
		var focusOnCode = function(){};
		
		var currDefault = {};
		currDefault[CONFIG.DATE_DEFAULT] = null;
		currDefault[CONFIG.PROF] = {};
		currDefault[CONFIG.BILL_LIST_DATE] = new Date();
		currDefault[CONFIG.BILL_USER] = {};
		currDefault[CONFIG.TYP_LOC_ETAB] = null;
		currDefault[CONFIG.LOCAL] = {};
		currDefault[CONFIG.ETABLISSEMENT] = {};
		currDefault[CONFIG.SECTEUR] = {};
		currDefault[CONFIG.AUTO_SEND] = true;
		currDefault[CONFIG.RECHERCHE_PATIENTS] = 1;
		currDefault[CONFIG.DEFAUT_SANS_NAM] = 2;
		currDefault[CONFIG.DEFAUT_ID_PERS_AUTRE] = 7;

		var currGlobalDefault = {};
		var updateFichierAideDone = {val:{}}; // a .val = un Status. severity ERROR INFO OK et message Si Ok, pas de message.
		var generIdMachDone = {val:{}};
		var renewIdMachPswdDone = {val:{}};
		var currPatientUpdated = {val:0};
		var ptInscritAndMdFamUpdated = {val:0};
		var inscrB2bUpdated = {val:0};
		var seeHistFilterUpdated = {val:0};
		var typEvenePersUpdated = {val:0};
		var lstElmCxFactFTUpdated = {val:0};
		var lstlstFraisTranpUpdated = {val:0};
		var lstFraisSejUpdated = {val:0};
		var lstTempsDeplaUpdated = {val:0};
		var lstForfaDeplaUpdated = {val:0};
		var currDemPaimtUpdated = {val:0};
		var b2bGetInscrUpdated = {val:0, text:""};
		var b2bGetInscrEndUpdated = {val:0};
		var reglePlafValid = {val:0};
//		b2bGetInscrUpdated.text = "-> 186263<br>Obtention des données de la RAMQ...";
//		b2bGetInscrUpdated.text = "<i>186263</i>: <b>40</b> / 857";
		
		var billQueue = {val:[]};
		var sharingActivated = {val:false};
		
		var savedBillOk = {};
		savedBillOk.val = 0;
		
		var calledAddBill = false;	// si true, le watch sur savebBill will call le doAddBill
		var calledCopyBill = false;	// si true, le watch sur savebBill will call le doAddBill
		
		var currUser = {};
		var currUsersList = []; // aussi var usersList ci-bas
		var currProf = {};
		var currGroup = {};
		setCurrProfNull();
		
		var currLieu = {};
		setCurrLieuNull();
		
		var currLieuDep = getCurrLieuTrspNull();
		var currLieuArr = getCurrLieuTrspNull();
					
		function tagHash(a) {
			return a.tag;
		}
		function cHash(a) {
			return a;
		}
		function ctxcHash(a) {
			return a;
		}
		function noLigneHash(a) {
			return a;
		}
		function onlyUnique(value, index, self) { 
		    return self.indexOf(value) === index;
		}
		
		var userList = new Hashtable({ hashCode: tagHash });
		var lstProfPref = new Hashtable({ hashCode: cHash });
		
		var currPatient;
		var currDx;
		setCurrPatientNull();
		var currPatientData = {};
		currPatientData.prof = {};
		
		var currHistoricBills = [];
		
		var demListeForPrint = [];
		var sumBillForPrint = [];
		var currDemPaimt;
		setCurrDemPaimtNull();
		var activeCriteriaStatusRep = 3;
		var idFactRamqRecev = {}; // val a/a currDemPaimt/.demModif
		var demRecev = {};
		
		var currDemForListe = {};
		var currDemListe = new Hashtable({ hashCode: tagHash }); // la liste des currDemForListe
		var demListeItemUpdated = {val:0};
		var currBillQueueSize = {val:0};
		var lstLigneFactServMdcalDelUpdated = {val:0};	// correspond au no logne updated/deleted
		var lstLigneFactServMdcalModUpdated = {val:0};
		var demListeShowSelected = {val:0};
		var demListeShowCurrentDemForListe = {val:0};
		var fichExplPaimtNew = {val:0};
		var idInscrUpdated = {val:0};
		var filterFromConcil = {val:0};
		var currFichExplPaimt = {};
		var noRfpsFromConcil = [];
		var fichObtenusNew = [];
		
		var currLigneServMdcal = {}; // peut être type omni ou spec - le backend sait lequel selon entente du currProf
		setCurrLigneServMdcalNull();
				
		var initTag = -100000;
		function atomicInt() {
			return initTag--;
		}
		
		function setDirtyStatus(obj, val) {
//			if (angular.isDefined(obj.type) && val) {
//				$log.log("obj.type: " + obj);
//			}
			if (angular.isUndefined(obj.dirtyStatus)) {
				obj.dirtyStatus = {};
				obj.dirtyStatus.val = val;
			} else if (!obj.dirtyStatus.val && val) {
				obj.dirtyStatus.val = val;
			}
		}
		
		function getIdent4Print(p, fn) {
			var typPerson;
			if (p.typePerson<3) {
				typPerson = "Pt: ";
			} else {
				typPerson = "Autre: ";
			}
			return typPerson + getIdent(p, fn);
		}
		
		function getIdent(p, fn) {
			var ident = "...";
			if (!$.isEmptyObject(p)) {
				if (p.typePerson<3) {
					if (angular.isDefined(p.hin) && p.hin!=null && p.hin!='') {
						ident = p.hin;
					} else if (angular.isDefined(p.ln)) {
						var ddnNo = (angular.isDefined(p.bds) && p.bds!='' ? ", " + new moment(p.bds).format("YYYY-MM-DD") + ":" + p.no : "");
						var sexe = angular.isDefined(p.gender) ? "(" + p.gender + ")" : ""; 
						var firstName = angular.isDefined(fn) ? " " + fn : "";
						ident = p.ln + firstName + ddnNo + sexe;
					}					
				} else {
					if (angular.isDefined(p.idPersAutre) && p.idPersAutre!=null && p.idPersAutre!='') {
						ident = p.idPersAutre;
					} else if (angular.isDefined(p.ln)) {
						var firstName = angular.isDefined(fn) ? " " + fn : "";
						ident = p.ln + firstName;
					}
				}
			}
			return ident;
		}
		
		function setCurrPatientNull() {
			currPatient = {};
			currPatient.dirtyStatus = {};
			currPatient.persRepdn = {};
			currPatient.adr = {};
			currPatient.adr.cy = {};
			currPatient.lstDx = new Hashtable({ hashCode: tagHash });
			currDx = {};
		}
		
		function setCurrLieuValEtabNull() {
			currLieu.etab = {};		// CEtab  si codifie = N		
			currLieu.etab.codPreciSectActiv; // 1 Salle d'opération ou 2 Au chevet du patient
			currLieu.etab.noSelectedEtab=null;
			currLieu.etab.valEtab = {}; // "listeNoEtab","nomEtab","catgEtab","typEtab","codRss","nomRss","adresse","municipalite","codPos","calenJourFerie"
			currLieu.etab.valEtab.nomEtab;
			currLieu.etab.valEtab.catgEtab;
			currLieu.etab.valEtab.typEtab;
			currLieu.etab.valSect = {};	// ValSecteur
			currLieu.etab.valSect.noSectActiv = null;
			currLieu.etab.valSect.desSectActiv = null;
			currLieu.etab.valSect.listeCatgEtab = [];			
		}

		function setCurrLieuValCodLocalNull() {
			currLieu.local = {};	// CLocal si codifie = C
			currLieu.local.codePostal=null;
			currLieu.local.codeLocal=null;
			currLieu.local.typIdLieuGeo='3';	// // 2 CP ou 3 Localité
			currLieu.local.typLieuGeo='C';	// C D A I
			currLieu.local.valCodLocal={};	// "codLocal","nomLocal","listeMunic","ddEffecCodLocal","dfEffecCodLocal","codLocalNouv"
			currLieu.local.valCodLocal.codLocal=null;
			currLieu.local.valCodLocal.nomLocal=null;			
		}
		
		function setCurrLieuNull() {
			currLieu = {};
			currLieu.dirtyStatus = {};
			setCurrLieuValEtabNull();
			setCurrLieuValCodLocalNull();
		}
		
		function getCurrLieuTrspNull() {
			var lieu = {};
			lieu.dirtyStatus = {};
			lieu.etab = {};		// CEtab  si codifie = N		
			lieu.etab.valEtab = {}; // "listeNoEtab","nomEtab","catgEtab","typEtab","codRss","nomRss","adresse","municipalite","codPos","calenJourFerie"
			lieu.etab.noSelectedEtab=null;
			lieu.etab.valEtab.nomEtab;
			lieu.etab.valEtab.catgEtab;
			lieu.etab.valEtab.typEtab;
			
			lieu.local = {};	// CLocal si codifie = C
			lieu.local.codePostal=null;
			lieu.local.codeLocal=null;
			lieu.local.typIdLieuGeo='3';	// // 2 CP ou 3 Localité
			lieu.local.valCodLocal={};	// "codLocal","nomLocal","listeMunic","ddEffecCodLocal","dfEffecCodLocal","codLocalNouv"
			lieu.local.valCodLocal.codLocal=null;
			lieu.local.valCodLocal.nomLocal=null;
			return lieu;
		}
		
		function setCurrProfNull() {
			currProf = {};
			currProf.dirtyStatus = {};
			currGroup = {};
			currGroup.dirtyStatus = {};
		}
		function setCurrLigneServMdcalNull() {
			currLigneServMdcal = {};
			currLigneServMdcal.dirtyStatus = {};
			currLigneServMdcal.codRole = 1;
			currLigneServMdcal.codFact = {};
			currLigneServMdcal.lstElmCx = new Hashtable({ hashCode: tagHash });
			currLigneServMdcal.lstMesur = new Hashtable({ hashCode: cHash });
		}
		
		function notObject(o) {
			return  angular.isUndefined(o) || 0===null || typeof o !== 'object';
		}
		
		function validateDemPaimtServMdcal(l) {
			if (notObject(l)) {
				l = {};
			}
			if (notObject(l.serv)) {
				l.serv = {};
			}
			if (notObject(l.serv.lstPatients)) {
				l.serv.lstPatients = new Hashtable({ hashCode: tagHash });
			}
			if (notObject(l.serv.lstElmCx)) {
				l.serv.lstElmCx = new Hashtable({ hashCode: tagHash });
			}
			if (notObject(l.serv.lstLigneFact)) {
				l.serv.lstLigneFact = new Hashtable({ hashCode: noLigneHash });
			}
			return l;
		}
		
		function validateLigneServMdcal(l) {
			if (notObject(l)) {
				l = {};
			}
			if (notObject(l.codFact) ) {
				l.codFact = {};				
			}
			if (notObject(l.lstElmCx) ) {
				l.lstElmCx = new Hashtable({ hashCode: tagHash });
			}
			if (notObject(l.lstLieuEnRef) ) {
				l.lstLieuEnRef = new Hashtable({ hashCode: tagHash });
			}
			if (notObject(l.lstMesur) ) {
				l.lstMesur = new Hashtable({ hashCode: cHash });
			}
			return l;
		}
		
		function isJourFerie(lieu, theDate) {
//			if (helpers.isDate(d)) {
			var d;
			if (MyNamespace.helpers.isEmpty(theDate)) {	// pas une date. donc pas un férié
				return 0;
			} else if (theDate._isAMomentObject===true) {
				d = theDate;
			} else if (typeof theDate==='string' && theDate.length===10) {
				d = moment(theDate, 'YYYY-MM-DD');
			} else {
				d = moment(theDate);
			}
			if (d.day()==0) {
				return 200;
			} else if (d.day()==6) {
				return 100;
			}
			// au moins check si fin de semaine et si 1 jan, 24 juin, 1 juillet, 25 dec, etc.
			if (d.month()==0 && d.date()==1) {
				return 1;
			} else if (d.month()==5 && d.date()==24) {
				return 6;
			} else if (d.month()==6 && d.date()==1) {
				return 7;
			} else if (d.month()==11 && d.date()==25) {
				return 11;
			} else if (d.month()==8 && d.day()==1 && d.date()<8) {
				return 8;	// le 1er lundi de septembre (fête du Travail)
			} else if (d.month()==9 && d.day()==1 && d.date()>7 && d.date()<16) {
				return 9;	// le 2e lundi d’octobre (Action de grâces)
			}
			if (lieu!=null && angular.isDefined(lieu) && lieu.typLocEtab=='C' && angular.isDefined(lieu.etab) && angular.isDefined(lieu.etab.valEtab) && angular.isDefined(lieu.etab.valEtab.calenJourFerie) && angular.isDefined(lieu.etab.valEtab.calenJourFerie.listeJourFerie)) {
				var jrFer = lieu.etab.valEtab.calenJourFerie.listeJourFerie.content;
				var len = jrFer.length;
				var pad = '00';
				for (var i = 0; i < len; i++) {
					var jFer = jrFer[i].dtJrFerie;
					var jFerStr = jFer.year + (pad + jFer.month).slice(-pad.length) + (pad + jFer.day).slice(-pad.length);
					var j = moment(jFerStr);
					if (j.dayOfYear()==d.dayOfYear() && j.year() == d.year()) {
						return jrFer[i].typJrFerie; // voir XML_FRM_infoEtablissement.xsd, ligne 183
					}
				}
			}
			return 0;	// pas de jour férié
		}
		
		function setCurrDemPaimtServNull() {
			currDemPaimt.serv = {};
			currDemPaimt.serv.lstPatients = new Hashtable({ hashCode: tagHash });
			currDemPaimt.serv.lstPatients.dirtyStatus = {};
			currDemPaimt.serv.lstElmCx = new Hashtable({ hashCode: tagHash });
			currDemPaimt.serv.lstElmCx.dirtyStatus = {};
			currDemPaimt.serv.lstLigneFact = new Hashtable({ hashCode: noLigneHash });			
			currDemPaimt.serv.lstLigneFact.dirtyStatus = {};
		}
		function setCurrDemPaimtDeplNull() {
			currDemPaimt.depl = {};
			currDemPaimt.depl.lstElmCx = new Hashtable({ hashCode: tagHash });
			currDemPaimt.depl.lstFraisTranp = new Hashtable({ hashCode: noLigneHash });
			currDemPaimt.depl.lstFraisSej = new Hashtable({ hashCode: noLigneHash });
			currDemPaimt.depl.lstTempsDepla = new Hashtable({ hashCode: noLigneHash });
			currDemPaimt.depl.lstForfaDepla = new Hashtable({ hashCode: noLigneHash });
		}
		function setCurrDemPaimtNull() {
			currDemPaimt = {};
			currDemPaimt.dirtyStatus = {};
			setCurrDemPaimtServNull();
			setCurrDemPaimtDeplNull();
		}

		function setCurrDemPaimt(obj, isNew) {
			// le currDemPaimt est reçu via websocket et tous les currents du backend sont déjà setté.
			// il faut donc les setter ici aussi.
			currDemPaimt=obj;
			obj.dirtyStatus = {};
			setCurrPatientNull();
			setCurrLigneServMdcalNull();
			idFactRamqRecev = {};
			demRecev = {};
			
			// une réponse de la RAMQ. Il faut prendre le idFactRamqRecev si présent et si dt type 4 ou 5 (donc non annu)
			if (currDemForListe.dt===4 && obj.recev) {
				demRecev = _.cloneDeep(obj.recev);
				if (angular.isDefined(demRecev.listeFactRecev) && demRecev.listeFactRecev.length>0) {
					idFactRamqRecev = demRecev.listeFactRecev[0].idFactRamqRecev;
				}
			} else if (currDemForListe.dt===5 && obj.demModif) {
				// entryCtrl.model.currentDemPaimt().lastAcceptedDemModif.recev.statRecev 
				if (obj.lastAcceptedDemModif) {
					demRecev = obj.lastAcceptedDemModif.recev? _.cloneDeep(obj.lastAcceptedDemModif.recev) : {};					
				} else {
					demRecev = obj.demModif.recev ? _.cloneDeep(obj.demModif.recev) : {};;					
				}
				var tookObjRecev = false;
				if (demRecev.factVersiCourn && demRecev.factVersiCourn.idFactRamqRecev) {
					idFactRamqRecev = demRecev.factVersiCourn.idFactRamqRecev;
				} else if (demRecev.factRecev && demRecev.factRecev.idFactRamqRecev) {
					idFactRamqRecev = demRecev.factRecev.idFactRamqRecev;
				} else {
					// pas de factRecev. Dem modif refusé. Je n'ai pas son idFactRamqRecev dans modif.
					if (obj.recev) {
						// demRecev = last good recev
						tookObjRecev = true;
						demRecev = _.cloneDeep(obj.recev);
						if (angular.isDefined(obj.recev.listeFactRecev) && obj.recev.listeFactRecev.length>0) {
							idFactRamqRecev = obj.recev.listeFactRecev[0].idFactRamqRecev;
						}
					}
				}
				if (!tookObjRecev) {
					var listeFactRecev = [1];
					if (angular.isUndefined(demRecev.factRecev)) {
						demRecev.factRecev = {};
					}
					demRecev.factRecev.idFactRamqRecev = idFactRamqRecev;
					listeFactRecev[0] = demRecev.factRecev;
					listeFactRecev[0].noFactExt = demRecev.noDemExt;
					demRecev.listeFactRecev = listeFactRecev;					
				}
			} else if (currDemForListe.dt===6) {
				if (obj.demAnnu && obj.demAnnu.recev) {
					demRecev = _.cloneDeep(obj.demAnnu.recev);
					if (demRecev.listeFactRecev && demRecev.listeFactRecev.length>0) {
						idFactRamqRecev = demRecev.listeFactRecev[0].idFactRamqRecev;				
					}
					if (angular.isUndefined(idFactRamqRecev) || $.isEmptyObject(idFactRamqRecev)) {
						if (obj.demAnnu.idFact) {
							idFactRamqRecev = obj.demAnnu.idFact;
						}						
					}
					var listeFactRecev = [1];
					if (angular.isUndefined(demRecev.factRecev)) {
						demRecev.factRecev = {};
					}
					demRecev.factRecev.idFactRamqRecev = idFactRamqRecev;
					//listeFactRecev[0] = demRecev.factRecev;
					//listeFactRecev[0].noFactExt = demRecev.noDemExt;
					//demRecev.listeFactRecev = listeFactRecev;
				} else {
					demRecev.staRecev = currDemForListe.sr;
				}
			} else {
				demRecev.staRecev = currDemForListe.sr;
			}
			
			if (angular.isDefined(obj.serv) && angular.isDefined(obj.serv.typIdProf)) {
				if (!isNew) {
					setCurrDemPaimtDeplNull();
				}
				var dp = obj.serv;
				dp.dirtyStatus = {};
				
				currLieu = dp.lieu;
				currLieu.dirtyStatus = {};
				dp.lstPatients = new Hashtable({ hashCode: tagHash });
				dp.lstPatients.dirtyStatus = {};
				if (angular.isDefined(dp.mapTempPatients)) {
					Object.keys(dp.mapTempPatients).forEach(function(key) {
					    var pt = dp.mapTempPatients[key];
					    pt.dirtyStatus = {};
					    pt.ident = getIdent(pt);
						pt.lstDx = new Hashtable({ hashCode: tagHash });
						if (!pt.persRepdn) {
							pt.persRepdn = {};
						}
						if (!pt.adr) {
							pt.adr = {};
							pt.adr.cy = {};
						}
						if (pt.lstCTypDiagnMdcal && pt.lstCTypDiagnMdcal.length>0) {
							for (var i = 0; i < pt.lstCTypDiagnMdcal.length; i++) {
								var typDx = pt.lstCTypDiagnMdcal[i];
								var dx = {};
								if (angular.isUndefined(typDx.code)) {
									continue;
								}
								dx.tag = atomicInt();
								dx.c = typDx.code;
								dx.da = typDx.da;
								dx.dl = typDx.dl;
								pt.lstDx.put(dx.tag, dx);
							}
							delete pt.lstCTypDiagnMdcal;
						} else {
							// il faut ajouter un dx vide
							var dx = {};
							dx.tag = -1;	// permet de ne pas l'afficher dans fact readonly
							pt.lstDx.put(dx.tag, dx);
						}
						if (angular.isDefined(obj.patient)) {
							delete obj.patient;
						}
						if (!hasPatient()) {
							currPatient = pt;
						}
						if ($.isEmptyObject(currDx) && pt.lstDx.size()>0) {
							currDx = pt.lstDx.values()[0];
						}
						dp.lstPatients.put(pt.tag, pt);
					});
					delete dp.mapTempPatients;
				}
				
				dp.lstElmCx = new Hashtable({ hashCode: tagHash });
				dp.lstElmCx.dirtyStatus = {};
				if (angular.isDefined(dp.lstTempElmCx)) {
					for (var j = 0; j < dp.lstTempElmCx.length; j++) {
						var ctx = dp.lstTempElmCx[j];
						if (angular.isDefined(ctx.codeCtx) && angular.isDefined(ctx.codeCtx.c) && ctx.codeCtx.c!='') {
							ctx.dirtyStatus = {};
							ctx.tag = atomicInt();
							dp.lstElmCx.put(ctx.tag, ctx);					
						}
					}
					delete dp.lstTempElmCx;
				}
				
				currLigneServMdcal = {};
				dp.lstLigneFact = new Hashtable({ hashCode: noLigneHash });
				dp.lstLigneFact.dirtyStatus = {};
				if (angular.isDefined(dp.mapTempLigneFact)) {
					Object.keys(dp.mapTempLigneFact).forEach(function(key) {
					    var line = dp.mapTempLigneFact[key];
						if (notObject(line.codFact)) {
							line.codFact = {};
						}
						// ajouter mapTempMesur et lstElmCtx
						line.lstMesur = new Hashtable({ hashCode: cHash });
						if (angular.isDefined(line.lstTempMesur)) {
							for (var k = 0; k < line.lstTempMesur.length; k++) {
								var mesure = line.lstTempMesur[k];
								line.lstMesur.put(mesure.code, mesure);
							}
							delete line.lstTempMesur;
						}
						
						line.lstElmCx = new Hashtable({ hashCode: tagHash });
						if (angular.isDefined(line.lstTempElmCx)) {
							for (var l = 0; l < line.lstTempElmCx.length; l++) {
								var cx = line.lstTempElmCx[l];
								cx.tag = atomicInt();
								line.lstElmCx.put(cx.tag, cx);
								if (!angular.isDefined(line.currElmCx)) {
									line.currElmCx = cx;
								}
							}
							delete line.lstTempElmCx;
						}

						line.lstLieuEnRef = new Hashtable({ hashCode: tagHash });
						if (angular.isDefined(line.lstTempLieuEnRef)) {
							for (var l = 0; l < line.lstTempLieuEnRef.length; l++) {
								var ler = line.lstTempLieuEnRef[l];
								ler.tag = atomicInt();
								line.lstLieuEnRef.put(ler.tag, ler);
								if (!angular.isDefined(line.currLieuEnRef)) {
									line.currLieuEnRef = ler;
								}
							}
							delete line.lstTempLieuEnRef;
						}
						if ($.isEmptyObject(currLigneServMdcal)) {
							currLigneServMdcal = line;
						}
						dp.lstLigneFact.put(line.noLigne, line);
					});
					delete dp.mapTempLigneFact;
				}
				if (angular.isDefined(dp.prof)) {
					currProf=dp.prof;
					currProf.dirtyStatus = {};
				} else {
					setCurrProfNull();
				}
			}
			
			if (angular.isDefined(obj.depl) && angular.isDefined(obj.depl.typIdProf)) {
				if (!isNew) {
					setCurrDemPaimtServNull();
				}
				var dp = obj.depl;
				dp.dirtyStatus = {};
				
				dp.lstFraisTranp = new Hashtable({ hashCode: noLigneHash });
				if (angular.isDefined(dp.mapTempFraisTranp)) {
					Object.keys(dp.mapTempFraisTranp).forEach(function(key) {
					    var line = dp.mapTempFraisTranp[key];
					    line.elmCx = {};
						line.lstElmCx = new Hashtable({ hashCode: tagHash });
						if (angular.isDefined(line.lstTempElmCx)) {
							for (var l = 0; l < line.lstTempElmCx.length; l++) {
								var cx = line.lstTempElmCx[l];
								cx.tag = atomicInt();
								line.lstElmCx.put(cx, cx);
							}
							delete line.lstTempElmCx;
						}
						line.lstFrais = new Hashtable({ hashCode: tagHash });
						if (angular.isDefined(line.lstTempFrais)) {
							for (var l = 0; l < line.lstTempFrais.length; l++) {
								var cx = line.lstTempFrais[l];
								cx.tag = atomicInt();
								line.lstFrais.put(cx, cx);
							}
							delete line.lstTempFrais;
						}
						dp.lstFraisTranp.put(line.noLigne, line);
					});
					delete dp.mapTempFraisTranp;
				}
				
				dp.lstTempsDepla = new Hashtable({ hashCode: noLigneHash });
				if (angular.isDefined(dp.mapTempTempsDepla)) {
					Object.keys(dp.mapTempTempsDepla).forEach(function(key) {
					    var line = dp.mapTempTempsDepla[key];
					    line.elmCx = {};
						line.lstElmCx = new Hashtable({ hashCode: tagHash });
						if (angular.isDefined(line.lstTempElmCx)) {
							for (var l = 0; l < line.lstTempElmCx.length; l++) {
								var cx = line.lstTempElmCx[l];
								cx.tag = atomicInt();
								line.lstElmCx.put(cx, cx);
							}
							delete line.lstTempElmCx;
						}
						dp.lstTempsDepla.put(line.noLigne, line);
					});
					delete dp.mapTempTempsDepla;
				}
				
				dp.lstForfaDepla = new Hashtable({ hashCode: noLigneHash });
				if (angular.isDefined(dp.mapTempForfaDepla)) {
					Object.keys(dp.mapTempForfaDepla).forEach(function(key) {
					    var line = dp.mapTempForfaDepla[key];
					    line.elmCx = {};
						line.lstElmCx = new Hashtable({ hashCode: tagHash });
						if (angular.isDefined(line.lstTempElmCx)) {
							for (var l = 0; l < line.lstTempElmCx.length; l++) {
								var cx = line.lstTempElmCx[l];
								cx.tag = atomicInt();
								line.lstElmCx.put(cx, cx);
							}
							delete line.lstTempElmCx;
						}
						dp.lstForfaDepla.put(line.noLigne, line);
					});
					delete dp.mapTempForfaDepla;
				}
				
				dp.lstFraisSej = new Hashtable({ hashCode: noLigneHash });
				if (angular.isDefined(dp.mapTempFraisSej)) {
					Object.keys(dp.mapTempFraisSej).forEach(function(key) {
					    var line = dp.mapTempFraisSej[key];
					    line.elmCx = {};
						line.lstElmCx = new Hashtable({ hashCode: tagHash });
						if (angular.isDefined(line.lstTempElmCx)) {
							for (var l = 0; l < line.lstTempElmCx.length; l++) {
								var cx = line.lstTempElmCx[l];
								cx.tag = atomicInt();
								line.lstElmCx.put(cx, cx);
							}
							delete line.lstTempElmCx;
						}
						dp.lstFraisSej.put(line.noLigne, line);
					});
					delete dp.mapTempFraisSej;
				}
				
				dp.lstElmCx = new Hashtable({ hashCode: tagHash });
				if (angular.isDefined(dp.lstTempElmCx)) {
					Object.keys(dp.lstTempElmCx).forEach(function(key) {
					    var line = dp.lstTempElmCx[key];
						line.tag = atomicInt();
						dp.lstElmCx.put(line, line);
					});
					delete dp.lstTempElmCx;
				}
				dp.lstElmCx.dirtyStatus={};
				dp.lstFraisTranp.dirtyStatus={};
				dp.lstFraisSej.dirtyStatus={};
				dp.lstTempsDepla.dirtyStatus={};
				dp.lstForfaDepla.dirtyStatus={};
				
				if (angular.isDefined(dp.prof)) {
					currProf=dp.prof;
					currProf.dirtyStatus = {};
				} else {
					setCurrProfNull();
				}
				var delay = 10;
				if (lstElmCxFactFTUpdated.val==0) {
					delay = 1000;
					$timeout(function() {
						lstElmCxFactFTUpdated.val++;
						lstlstFraisTranpUpdated.val++;
						lstFraisSejUpdated.val++;
						lstTempsDeplaUpdated.val++;
						lstForfaDeplaUpdated.val++;
					}, 0);
				}
				$timeout(function() {
					lstElmCxFactFTUpdated.val++;
					lstlstFraisTranpUpdated.val++;
					lstFraisSejUpdated.val++;
					lstTempsDeplaUpdated.val++;
					lstForfaDeplaUpdated.val++;
				}, delay);
			}
			
			currGroup=angular.isDefined(obj.cModaPaimt)  && obj.cModaPaimt.groupe ? obj.cModaPaimt.groupe : {};
			currGroup.dirtyStatus = {};
			currDemPaimt=obj;
			if (angular.isDefined(obj.serv) && angular.isDefined(obj.serv.typIdProf)) {
				$timeout(function(){currDemPaimtUpdated.val++;},1);
			}
		}
		
		function info(m) {
			var b = new jBox('Notice', {
				color : 'green',
				content: m
			});
			b.open();
		}
		
		function warning(m) {
			var b = new jBox('Notice', {
				color : 'yellow',
				title:"Avertissement",
				content: m
			});
			b.open();
		}
		var isIE = isMicrosoftBrowser();
		function isMicrosoftBrowser () {
	       var match = navigator.userAgent.search(/(?:Edge|MSIE|Trident\/.*; rv:)/);
	       var isIE = false;

	       if (match !== -1) {
	         isIE = true;
	       }

	       return isIE;
	    }
		
		function error(m) {
			var b = new jBox('Modal', {
				title: "Erreur",
				closeButton: 'title',
				content: m
			});
			b.open();
		}
		
		function saveCurrLieuValEtabNull() {
			httpPost("/syra/etabl/post", {});
		}
		
		function saveCurrLieuValCodLocalNull() {
			httpPost("/syra/local/post", {});
		}
		
		var criteriaActive = false;		
		function getDemListe(c) {
			var criteria = {};
			if (arguments.length && angular.isDefined(c)) {
				if (angular.isDefined(c.dateDebut)) {
					// il y a toujours une date quand filter
					criteriaActive = true;
				} else {
					criteriaActive = false;
				}
				criteria = c;
			} else {
				criteriaActive = false;					
				criteria.statusRep = activeCriteriaStatusRep;
				criteria.user = currDefault[CONFIG.BILL_USER];
//				criteria.dateDebut = currDefault[CONFIG.BILL_LIST_DATE];
			}
			var sObj = JSON.stringify(criteria);
			httpPost('demliste/post', sObj);
		}
				
		function restoreBill(billTag) {
			httpPost("/syra/restore_bill/post", billTag);
			// si succes, retour websocket deleteBillType
		}
		function deleteBill(billTag) {
			httpPost("/syra/delete_bill/post", billTag);
			// si succes, retour websocket deleteBillType
		}
		
		function cancelModifBill(currDFL) {
			resetDirtyStatus();
			if (angular.isDefined(currDFL.id)) {
				var actualTag = currDFL.tag;
				httpPost("/syra/bill/post", actualTag);	// refait un reload de la facture à partir du backend (comme si on selectionait en neuf)				
			} else {
				// veut annuler un ajout. 
				setCurrDemPaimtNull();
				currDemListe.remove(currDFL.tag);
				currDemForListe = {};
				$timeout(function(){currDemListeUpdated.val++;},1);	
			}
		}
		
		function saveBill(currDP) {
			var dp = _.cloneDeep(currDP);
			if (dp.cModaPaimt.type==1) {
				delete dp.cModaPaimt.no;
			}
			if (dp.cModaPaimt.groupe) {
				delete dp.cModaPaimt.groupe;	// pas besoin du groupe au backend
			}
			// pas besoin de ces objets au backend
			if (dp.recev) {
				delete dp.recev;
			}
			if (dp.lastAcceptedDemModif) {
				delete dp.lastAcceptedDemModif;
			}
			delete dp.dirtyStatus;
			if (dp.type==1)  {
				// serv
				delete dp.depl;
				var sv = dp.serv;
				var p;	// patients
				var pArr = "";
				var pIdArr = [];
				var iPt = 0;
				var l;	// lignes de serv
				var c;	// Contextes de fact
				if (angular.isDefined(sv.lstPatients.dirtyStatus) && sv.lstPatients.dirtyStatus.val) {
					// a eu des modif des patients - les inclure dans la sauvegarde
					p = _.cloneDeep(sv.lstPatients.values());
					// TODO il faudrait s'assurer que values retourne uniquement des objets patients. Re probl. Dr Fortier sur Google - était ok sur Safari.
					for (var o in p) {
						if (angular.isDefined(p[o].lstDx)) {
							delete p[o].allDisCodes;
							delete p[o].dirtyStatus;
							delete p[o].properties;
							delete p[o].ldbd;
							delete p[o].bd;	// on a bds qui est yyyy-mm-dd
							if (angular.isDefined(p[o].$$hashKey)) {
								delete p[o].$$hashKey;
							}
							var ptIdent = getIdent(p[o], p[o].fn);
							pArr = pArr.length==0 ? ptIdent : pArr + '; ' + ptIdent;
							var lstDx = _.cloneDeep(p[o].lstDx.values());
							delete lstDx.properties;
							for (var oo in lstDx) {
								if (angular.isDefined(lstDx[oo].$$hashKey)) {
									delete lstDx[oo].$$hashKey;
								}
								delete lstDx[oo].da;
								delete lstDx[oo].dl;
								delete lstDx[oo].tag;
							}
							p[o].lstDx = _.filter(_.uniq(lstDx), function(item) {return angular.isDefined(item.c) && item.c!=null && item.c!=''});							
						}
					}
					// mettre à jour la currDemForListe locale car changement patient
					currDemForListe.pt = pArr;
					$timeout(function(){demListeItemUpdated.val++;},1);	
				}
				if (angular.isDefined(sv.lstLigneFact.dirtyStatus) && sv.lstLigneFact.dirtyStatus.val) {
					// a eu des modif des lignes de facture - les inclure dans la sauvegarde
					l = _.cloneDeep(sv.lstLigneFact.values());
					delete l.properties;
					for (var o in l) {
						var val = l[o];
						if (angular.isDefined(val.codFact)) {
							delete val.dirtyStatus;
							delete val.codFact.d;
							delete val.codFact.mapElmMesur;
							if (angular.isDefined(val.$$hashKey)) {
								delete val.$$hashKey;
							}
							if (angular.isDefined(val.lstMesur)) {
								delete val.lstMesur.properties;
								if (angular.isDefined(val.lstMesur.$$hashKey)) {
									delete val.lstMesur.$$hashKey;
								};
								var lstMesur = _.cloneDeep(val.lstMesur.values());
								delete lstMesur.properties;
								for (var oo in lstMesur) {
									if (angular.isDefined(lstMesur[oo].$$hashKey)) {
										delete lstMesur[oo].$$hashKey;
									}
									delete lstMesur[oo].nom;
									delete lstMesur[oo].unit;
								}
								val.lstMesur = lstMesur;
							}
							
							delete val.lstElmCx.properties;
							if (angular.isDefined(val.lstElmCx.$$hashKey)) {
								delete val.lstElmCx.$$hashKey;
							}
							var lstElmCx = _.cloneDeep(val.lstElmCx.values()).filter(function (el) {
								return el.c !== "";
							});
							if (angular.isDefined(lstElmCx.$$hashKey)) {
								delete lstElmCx.$$hashKey;
							}
							for (var oo in lstElmCx) {
								if (angular.isDefined(lstElmCx[oo].$$hashKey)) {
									delete lstElmCx[oo].$$hashKey;
								}
								delete lstElmCx[oo].d;
								delete lstElmCx[oo].tag;
							}
							val.lstElmCx = lstElmCx;
							if (angular.isDefined(val.currElmCx)) {
								delete val.currElmCx;
							}
							
							var lstLieuEnRef = _.cloneDeep(val.lstLieuEnRef.values()).filter(function (e) {
								if (e.typLocEtab=='C') {
									if (e.etab && MyNamespace.helpers.isNotEmpty(e.etab.noSelectedEtab)) {
										delete e.etab.valEtab;
										if (e.etab.valSect) {
											if (MyNamespace.helpers.isNotEmpty(e.etab.valSect.noSectActiv)) {
												delete e.etab.valSect.desSectActiv;
												delete e.etab.valSect.listeCatgEtab;
											} else {
												delete e.etab.valSect;
											}
										}
										if (e.etab.codPreciSectActiv && e.etab.codPreciSectActiv===0) {
											delete e.etab.codPreciSectActiv;
										}
										if (e.etab.codPreciLieu && e.etab.codPreciLieu==='0') {
											delete e.etab.codPreciLieu;
										}
										return true;
									} else {
										return false;
									}
								} else if (e.typLocEtab=='N') {
									if (e.local && e.local.valCodLocal && MyNamespace.helpers.isNotEmpty(e.local.valCodLocal.codLocal)) {
										var codLocal = e.local.valCodLocal.codLocal;	// je n'ai besoin que de codLocal
										delete e.etab;
										delete e.local.valCodLocal;
										e.local.valCodLocal = {};
										e.local.valCodLocal.codLocal = codLocal
										if (e.local.codPreciLieu && e.local.codPreciLieu==='0') {
											delete e.local.codPreciLieu;
										}
										return true;
									} else {
										return false;
									}
								} else {
									return false;
								}
							});
							if (angular.isDefined(lstLieuEnRef.$$hashKey)) {
								delete lstLieuEnRef.$$hashKey;
							}
							for (var oo in lstLieuEnRef) {
								if (angular.isDefined(lstLieuEnRef[oo].$$hashKey)) {
									delete lstLieuEnRef[oo].$$hashKey;
								}
							}
							val.lstLieuEnRef = lstLieuEnRef;
							if (angular.isDefined(val.currLieuEnRef)) {
								delete val.currLieuEnRef;
							}
							if (val.typProfRef===1) {
								delete val.nomProfRefre;
								delete val.preProfRefre;
							}
							
							delete val.codFact.csst;
							delete val.codFact.noAutor;
							delete val.codFact.needRefMd;
							delete val.codFact.needRefInf;
							delete val.codFact.needRefSagF;
							delete val.codFact.needRefPharm;
							delete val.codFact.needRefInt;
							delete val.codFact.needRefAudio;
							delete val.codFact.needLieuRef;
							delete val.codFact.needDDM;
							delete val.codFact.needDPA;
							if (val.codFact.roles) {
								delete val.codFact.roles;
							}
						}
					}
				}
				
				if (angular.isDefined(sv.lstElmCx.dirtyStatus) && sv.lstElmCx.dirtyStatus.val) {
					c = _.cloneDeep(sv.lstElmCx.values()).filter(function (el) {
						return el.codeCtx.c !== "";
					});
					if (c.length==0) {
						// on supprime cette variable slm si >0, sinon rien ne sera envoyé en json
						c.empty = true;	// jsute pour avoir une variabe 
					} else {
						for (var oo in c) {
							if (angular.isDefined(c[oo].$$hashKey)) {
								delete c[oo].$$hashKey;
							}
							if (angular.isDefined(c[oo].currElmCx)) {
								delete c[oo].currElmCx;
							}
							delete c[oo].codeCtx.d;
							delete c[oo].tag;
							delete c[oo].dirtyStatus;
						}
					}
				}
				delete sv.lieu;
				delete sv.prof;
				delete sv.dirtyStatus;
				sv.lstPatients = p;
				sv.lstLigneFact = l;
				sv.lstElmCx = c;
				
			} else if (dp.type==2)  {
				// depl
				delete dp.serv;
				var sv = dp.depl;
				var ec;	// lstElmCx;
				var ft;	// lstLigneFraisTranp;
				var fs;	// lstLigneFraisSej;
				var td;	// lstLigneTempsDepla;
				var fd;	// lstLigneForfaDepla;
//				if (angular.isDefined(sv.lstElmCx.dirtyStatus) && sv.lstElmCx.dirtyStatus.val) {
					ec = _.cloneDeep(sv.lstElmCx.values()).filter(function (el) {
						return el.c !== "";
					});
					for (var oo in ec) {
						if (angular.isDefined(ec[oo].$$hashKey)) {
							delete ec[oo].$$hashKey;
						}
						delete ec[oo].d;
						delete ec[oo].tag;
						delete ec[oo].dirtyStatus;
					}
//				}
				
//				if (angular.isDefined(sv.lstFraisTranp.dirtyStatus) && sv.lstFraisTranp.dirtyStatus.val) {
					ft = _.cloneDeep(sv.lstFraisTranp.values());
					delete ft.properties;
					for (var o in ft) {
						var val = ft[o];
						delete val.dirtyStatus;
						delete val.elmCx;
						if (angular.isDefined(val.$$hashKey)) {delete val.$$hashKey;}
						if (angular.isDefined(val.properties)) {delete val.properties;}
						delete val.lstFrais.properties;
						if (angular.isDefined(val.lstFrais.$$hashKey)) {delete val.lstFrais.$$hashKey;};
						var lstFrais = _.cloneDeep(val.lstFrais.values());
						delete lstFrais.properties;
						for (var oo in lstFrais) {
							if (angular.isDefined(lstFrais[oo].$$hashKey)) {delete lstFrais[oo].$$hashKey;}
						}
						val.lstFrais = lstFrais;
						
						delete val.lstElmCx.properties;
						if (angular.isDefined(val.lstElmCx.$$hashKey)) {delete val.lstElmCx.$$hashKey;}
						var lstElmCx = _.cloneDeep(val.lstElmCx.values()).filter(function (el) {return el.c !== "";});
						if (angular.isDefined(lstElmCx.$$hashKey)) {delete lstElmCx.$$hashKey;}
						for (var oo in lstElmCx) {
							if (angular.isDefined(lstElmCx[oo].$$hashKey)) {delete lstElmCx[oo].$$hashKey;}
							delete lstElmCx[oo].d;
							delete lstElmCx[oo].tag;
							delete lstElmCx[oo].dirtyStatus;
						}
						val.lstElmCx = lstElmCx;
						if (angular.isDefined(val.currElmCx)) {delete val.currElmCx;}
					}
//				}
				
//				if (angular.isDefined(sv.lstFraisSej.dirtyStatus) && sv.lstFraisSej.dirtyStatus.val) {
					fs = _.cloneDeep(sv.lstFraisSej.values());
					delete fs.properties;
					for (var o in fs) {
						var val = fs[o];
						delete val.dirtyStatus;
						delete val.elmCx;
						if (angular.isDefined(val.$$hashKey)) {delete val.$$hashKey;}
						if (angular.isDefined(val.properties)) {delete val.properties;}
						delete val.lstElmCx.properties;
						if (angular.isDefined(val.lstElmCx.$$hashKey)) {delete val.lstElmCx.$$hashKey;}
						var lstElmCx = _.cloneDeep(val.lstElmCx.values()).filter(function (el) {return el.c !== "";});
						if (angular.isDefined(lstElmCx.$$hashKey)) {delete lstElmCx.$$hashKey;}
						for (var oo in lstElmCx) {
							if (angular.isDefined(lstElmCx[oo].$$hashKey)) {delete lstElmCx[oo].$$hashKey;}
							delete lstElmCx[oo].d;
							delete lstElmCx[oo].tag;
							delete lstElmCx[oo].dirtyStatus;
						}
						val.lstElmCx = lstElmCx;
						if (angular.isDefined(val.currElmCx)) {delete val.currElmCx;}
					}
//				}
				
//				if (angular.isDefined(sv.lstTempsDepla.dirtyStatus) && sv.lstTempsDepla.dirtyStatus.val) {
					td = _.cloneDeep(sv.lstTempsDepla.values());
					delete td.properties;
					for (var o in td) {
						var val = td[o];
						delete val.dirtyStatus;
						delete val.elmCx;
						if (angular.isDefined(val.$$hashKey)) {delete val.$$hashKey;}
						if (angular.isDefined(val.properties)) {delete val.properties;}
						delete val.lstElmCx.properties;
						if (angular.isDefined(val.lstElmCx.$$hashKey)) {delete val.lstElmCx.$$hashKey;}
						var lstElmCx = _.cloneDeep(val.lstElmCx.values()).filter(function (el) {return el.c !== "";});
						if (angular.isDefined(lstElmCx.$$hashKey)) {delete lstElmCx.$$hashKey;}
						for (var oo in lstElmCx) {
							if (angular.isDefined(lstElmCx[oo].$$hashKey)) {delete lstElmCx[oo].$$hashKey;}
							delete lstElmCx[oo].d;
							delete lstElmCx[oo].tag;
							delete lstElmCx[oo].dirtyStatus;
						}
						val.lstElmCx = lstElmCx;
					}
//				}
				
//				if (angular.isDefined(sv.lstForfaDepla.dirtyStatus) && sv.lstForfaDepla.dirtyStatus.val) {
					fd = _.cloneDeep(sv.lstForfaDepla.values());
					delete fd.properties;
					for (var o in fd) {
						var val = fd[o];
						delete val.dirtyStatus;
						delete val.elmCx;
						if (angular.isDefined(val.$$hashKey)) {delete val.$$hashKey;}
						if (angular.isDefined(val.properties)) {delete val.properties;}
						if (angular.isDefined(val.lstElmCx.properties)) {delete val.lstElmCx.properties;}
						if (angular.isDefined(val.lstElmCx.$$hashKey)) {delete val.lstElmCx.$$hashKey;}
						var lstElmCx = _.cloneDeep(val.lstElmCx.values()).filter(function (el) {return el.c !== "";});
						if (angular.isDefined(lstElmCx.$$hashKey)) {delete lstElmCx.$$hashKey;}
						for (var oo in lstElmCx) {
							if (angular.isDefined(lstElmCx[oo].$$hashKey)) {delete lstElmCx[oo].$$hashKey;}
							delete lstElmCx[oo].d;
							delete lstElmCx[oo].tag;
							delete lstElmCx[oo].dirtyStatus;
						}
						val.lstElmCx = lstElmCx;
						if (angular.isDefined(val.currElmCx)) {delete val.currElmCx;}
					}
//				}
				
				if (angular.isDefined(sv.lieuDep)) {
					if (sv.lieuDep.typLocEtab=='C') {
						delete sv.lieuDep.local;
						if (angular.isUndefined(sv.lieuDep.etab.noSelectedEtab) || sv.lieuDep.etab.noSelectedEtab=='') {
							delete sv.lieuDep.etab;
							delete sv.lieuDep.typLocEtab;
						} else {
							// on n'a besoin que du noSelctedEtab
							delete sv.lieuDep.etab.valEtab;
							delete sv.lieuDep.etab.valSect;
						}
					} else {
						delete sv.lieuDep.etab;
						var codLocal = sv.lieuDep.local.valCodLocal.codLocal;	// je n'ai besoin que de codLocal
						if (angular.isUndefined(codLocal) || codLocal=='' || codLocal==null) {
							delete sv.lieuDep.local;
							delete sv.lieuDep.typLocEtab;
						} else {
							delete sv.lieuDep.local.valCodLocal;
							sv.lieuDep.local.valCodLocal = {};
							sv.lieuDep.local.valCodLocal.codLocal = codLocal
						}
					}
				}
				if (angular.isDefined(sv.lieuArr)) {
					if (sv.lieuArr.typLocEtab=='C') {
						delete sv.lieuArr.local;
						if (angular.isUndefined(sv.lieuArr.etab.noSelectedEtab) || sv.lieuArr.etab.noSelectedEtab=='') {
							delete sv.lieuArr.etab;
							delete sv.lieuArr.typLocEtab;
						} else {
							// on n'a besoin que du noSelctedEtab
							delete sv.lieuArr.etab.valEtab;
							delete sv.lieuArr.etab.valSect;
						}
					} else {
						delete sv.lieuArr.etab;
						var codLocal = sv.lieuArr.local.valCodLocal.codLocal;	// je n'ai besoin que de codLocal
						if (angular.isUndefined(codLocal) || codLocal=='' || codLocal==null) {
							delete sv.lieuArr.local;
							delete sv.lieuArr.typLocEtab;
						} else {
							delete sv.lieuArr.local.valCodLocal;
							sv.lieuArr.local.valCodLocal = {};
							sv.lieuArr.local.valCodLocal.codLocal = codLocal
						}
					}
				}
				
				delete sv.prof;	// on prend les données du currentProf = en fait, on ne veut que le noprof.
				delete sv.dirtyStatus;

				sv.lstElmCx = ec;
				sv.lstLigneFraisTranp = ft;
				sv.lstLigneFraisSej = fs;
				sv.lstLigneTempsDepla = td;
				sv.lstLigneForfaDepla = fd;

			}
			delete dp.type;
			//$log.log(JSON.stringify(dp, null, 2));
			var sObj = JSON.stringify(dp);
			if (currGlobalDefault['envoi_tps_reel']) {
				currDemForListe.prg = 0;
				currDemForListe.sr = 0;
				if (currDemForListe.dt>3) {
					currDemForListe.dt = currDemForListe.dt-3;
				}
				delete currDemForListe.em;
				// faire idem au backend
				saveCurrDemForListValue("prg", 0, true, function() {
					httpPost("/syra/save_bill/post", sObj, 'currentDemPaimt');
				});
			} else {
				httpPost("/syra/save_bill/post", sObj, 'currentDemPaimt');
			}
		}

		function saveCurrDefault(obj, v) {
			if(angular.isDefined(obj)){
				var val;
				if (angular.isDefined(v)) {
					val = v;
				} else {
					val = currDefault[obj]
				}
				if (val==undefined) {
					val = '';
				}
				$http({method : "GET",
					url : "/syra/setdefaut/get?k=" + obj + "&v=" + val + "&u=" + clientUid
				}).then(function mySucces(response) {
				}, function myError(response) {
					warning(response.statusText);
				});
			}
		}
		function saveCurrGlobalDefault(obj, v) {
			if(angular.isDefined(obj)){
				var val;
				if (angular.isDefined(v)) {
					val = v;
				} else {
					val = currGlobalDefault[obj];
				}
				if (val==undefined) {
					val = '';
				}
				$http({method : "GET",
					url : "/syra/setglobaldefaut/get?k=" + obj + "&v=" + val + "&u=" + clientUid
				}).then(function mySucces(response) {
				}, function myError(response) {
					warning(response.statusText);
				});
			}
		}
		
		var currDemListeUpdated = {};
		currDemListeUpdated.val = 0;
		function setCurrDemListe(obj) {
			demListeForPrint = [];
			currDemListe.clear();
			setCurrDemPaimtNull();
			for (var i in obj) {
				currDemListe.put(obj[i].tag, obj[i]);
			}
			$timeout(function(){currDemListeUpdated.val++;},1);
			$timeout(function(){currDemPaimtUpdated.val++;},1);			
		}
		
		function setUsersList(obj) {
			currUsersList=obj;
			for (var i in obj) {
				userList.put(obj[i].id, obj[i]);
			}
		}
		
		function getUser(u) {
			return userList.get(u);
		}
		
		function saveCurrDemForListValue(obj, val, modified, methodToDo) {
			// pour setter les valeurs dans la currDemForListe, p.ex. mm, ready, ...
			// ex: that.model.saveCurrDemForListValue("ready", val, true);
			// setDirtyStatus(currDemPaimt, modified); on ne met pas dirty car saved en tant réel.
			$http({
				method : "GET",
				url : "/syra/setCurrentDemForListeVal/" + obj + "?v=" + val + "&u=" + clientUid
			}).then(function mySucces(response) {
				$timeout(function(){demListeItemUpdated.val++;},10);
				if (methodToDo) {
					methodToDo();
				}
			}, function myError(response) {
				warning(response.statusText);
			});
		}
		
		function httpPostCurrent(type, obj) {
			var sObj = JSON.stringify(obj);
			var cUidObject = {'o': sObj, 'u': clientUid, 't' : type};
			$http({method : "POST",
				url : "/syra/currentvalue/post",
				data:  JSON.stringify(cUidObject),
				headers: {'Content-Type': 'application/json; charset=utf-8'}
			}).then(function mySucces(response) {
			}, function myError(response) {
				warning(response.statusText);
			});
		}
		
		function httpPost(path, obj, type, fct) {
			var idClientUid = {'o': obj, 'u': clientUid, 't' : type};
			$http({method : "POST",
				url : path,
				data:  JSON.stringify(idClientUid),
				headers: {'Content-Type': 'application/json; charset=utf-8'}
			}).then(function mySucces(response) {
				if (fct) {
					fct(response);		
				}
			}, function myError(response) {
				warning(response.statusText);
			});
		}
		
		// "has" functions. Les calls à ces fonctions sont classés au début du return
		function hasActiveUser() {return angular.isDefined(currUser) && currUser!=null && angular.isDefined(currUser.id);}
		function hasEtab() {return angular.isDefined(currLieu.etab) && angular.isDefined(currLieu.etab.noSelectedEtab);}
		function hasLocal() {return angular.isDefined(currLieu.local) && angular.isDefined(currLieu.local.valCodLocal) && angular.isDefined(currLieu.local.valCodLocal.codLocal);}
		function hasEtabOrLocal() {return hasEtab() || hasLocal();}
		function hasDemPaimt() {
			return angular.isDefined(currDemPaimt.cDemdr);
		}
		function hasDemModif() {
			return angular.isDefined(currDemPaimt.demModif);
		}
		function hasDemAnnu() {
			return angular.isDefined(currDemPaimt.demAnnu);
		}
		function hasDemRec() {return !$.isEmptyObject(currDemPaimt.recev);}
		function hasProf() {return angular.isDefined(currProf.noProf);}
		function hasProfAndEtab() {return angular.isDefined(currProf.noProf) && hasEtabOrLocal();}
		function hasHin() {return angular.isDefined(currPatient.hin)  && currPatient.hin!=null && currPatient.hin!='';}
		function hasPatient() {return angular.isDefined(currPatient.tag);}
		function hasDatEntree() {return angular.isDefined(currPatient.datEntree) && currPatient.datEntree!=null && currPatient.datEntree!='';}
		function hasServ() {return angular.isDefined(currDemPaimt.serv) && angular.isDefined(currDemPaimt.serv.lstLigneFact) && currDemPaimt.serv.lstLigneFact.size()>0;}
		function hasDepl() {return angular.isDefined(currDemPaimt.depl) && angular.isDefined(currDemPaimt.depl.lstFraisTranp) && currDemPaimt.serv.lstFraisTranp.size()>0;}
		function hasElmMesur() {return angular.isDefined(currLigneServMdcal.lstMesur) && !currLigneServMdcal.lstMesur.isEmpty();}
		function hasElmCtxFact() {return angular.isDefined(currDemPaimt.serv) && angular.isDefined(currDemPaimt.serv.lstElmCx) && currDemPaimt.serv.lstElmCx.size()>0;}
		function hasOrNeedNoAutor() {
			if (angular.isUndefined(currDemPaimt.serv)) {
				return false;
			}
			if (angular.isDefined(currDemPaimt.serv.noAutor) && currDemPaimt.serv.noAutor!='' && currDemPaimt.serv.noAutor!=null) {
				return true;
			}
			var entries = angular.isDefined(currDemPaimt.serv.lstLigneFact) ? currDemPaimt.serv.lstLigneFact.values() : [];
			var arrayLength = entries.length;
			for (var i = 0; i < entries.length; i++) {
			    var ligne = entries[i];
			    if (helpers.isObject(ligne.codFact) && angular.isDefined(ligne.codFact.noAutor) && ligne.codFact.noAutor===true) {
			    	return true;
			    }
			}
			return false;
		}
		function hasCsst(){return angular.isDefined(currPatient) && angular.isDefined(currPatient.datEvenePers) && currPatient.datEvenePers!='' && currPatient.datEvenePers!=null}
		function needsCsst() {
			var entries = angular.isDefined(currDemPaimt.serv) && angular.isDefined(currDemPaimt.serv.lstLigneFact) ? currDemPaimt.serv.lstLigneFact.values() : [];
			var arrayLength = entries.length;
			for (var i = 0; i < entries.length; i++) {
				var ligne = entries[i];
				if (ligne.codFact.csst===true || ligne.codFact.needDDM===true || ligne.codFact.needDPA===true) {
					return true;
				}
			}
			return false;
		}
		
		function isDirty() {
			if (angular.isUndefined(currDemPaimt.type) || (currDemPaimt.type!=1 && currDemPaimt.type!=2)) {
				return false;
			}
			if (currDemPaimt.dirtyStatus.val==true || currProf.dirtyStatus.val==true || currGroup.dirtyStatus.val==true){
//				$log.log("dp:"+currDemPaimt.dirtyStatus.val+", prof:"+currProf.dirtyStatus.val+", group:"+currGroup.dirtyStatus.val);
				return true;
			}
			if (currDemPaimt.type==1 && angular.isDefined(currDemPaimt.serv)) {
				dp = currDemPaimt.serv;
				if (angular.isUndefined(dp.lstPatients) || angular.isUndefined(dp.lstPatients.dirtyStatus) || angular.isUndefined(dp.lstElmCx.dirtyStatus) || angular.isUndefined(dp.lstLigneFact) || angular.isUndefined(dp.lstLigneFact.dirtyStatus)){return false;}	// donc pas de fact sélectionnée
//				$log.log("pts:" + dp.lstPatients.dirtyStatus.val+", lmCx:"+dp.lstElmCx.dirtyStatus.val+", line:"+dp.lstLigneFact.dirtyStatus.val);
				if (dp.lstPatients.dirtyStatus.val ||
						dp.lstElmCx.dirtyStatus.val ||
						dp.lstLigneFact.dirtyStatus.val){return true;}
				
			} else if (currDemPaimt.type==2 && angular.isDefined(currDemPaimt.depl)) {
				dp = currDemPaimt.depl;
				if (angular.isUndefined(dp.lstElmCx.dirtyStatus)){return false;}	// donc pas de fact sélectionnée
				if (
						dp.lstElmCx.dirtyStatus.val ||
						dp.lstFraisTranp.dirtyStatus.val ||
						dp.lstFraisSej.dirtyStatus.val ||
						dp.lstTempsDepla.dirtyStatus.val ||
						dp.lstForfaDepla.dirtyStatus.val){return true;}
			}
			return false;
		}
		
		function resetDirtyStatus() {
			currDemPaimt.dirtyStatus = {};
			currGroup.dirtyStatus = {};
			currProf.dirtyStatus = {};
			currPatient.dirtyStatus = {};
			if (currDemPaimt.type==1) {
				resetDirtyStatusServ();
			} else if (currDemPaimt.type==2) {
				resetDirtyStatusDepl();
			} else {
				resetDirtyStatusServ();
				resetDirtyStatusDepl();				
			}
		}
		
		function resetDirtyStatusServ() {
			dp = currDemPaimt.serv;
			dp.lstPatients.dirtyStatus = {};
			dp.lstElmCx.dirtyStatus = {};
			dp.lstLigneFact.dirtyStatus = {};
		}
				
		function resetDirtyStatusDepl() {
			dp = currDemPaimt.depl;
			dp.lstElmCx.dirtyStatus = {};
			dp.lstFraisTranp.dirtyStatus = {};
			dp.lstFraisSej.dirtyStatus = {};
			dp.lstTempsDepla.dirtyStatus = {};
			dp.lstForfaDepla.dirtyStatus = {};
		}
		
		function jNotice(msg, color, otherTime){
			var autoClose = 1700;
			if (angular.isDefined(otherTime)) {
				autoClose = otherTime;
			}
			new jBox('Notice', {
				color : color,
			    content: msg,
			    autoClose: autoClose,
			    position : {x: 'right', y: 'bottom'},
			    offset: {x: -10, y: -5},
			    reposition : true
			});
		}
		
		return {
			message: function(msg, color, otherTime) {
				return jNotice(msg, color, otherTime);
			},
			atomicInt: function() {
				return atomicInt();
			},
			hasActiveUser: function() {
				return hasActiveUser();
			},
			hasDemPaimt: function() {
				return hasDemPaimt();
			},
			hasDemModif: function() {
				return hasDemModif();
			},
			hasDemAnnu: function() {
				return hasDemAnnu();
			},
			hasDemRec: function() {
				return hasDemRec();
			},
			hasProf: function() {
				return hasProf();
			},
			hasEtab: function() {
				return hasEtab();
			},
			hasLocal: function() {
				return hasLocal();
			},
			hasEtabOrLocal: function() {
				return hasEtabOrLocal();
			},
			hasProfAndEtab: function() {
				return hasProfAndEtab();
			},
			hasProfAndEtabAndPat: function() {
				return hasProfAndEtab() && hasPatient();			
			},
			hasHin : function() {
				return hasHin();
			},
			hasPatient : function() {
				return hasPatient();
			},
			hasDatEntree : function() {
				return hasDatEntree();
			},
			hasServ : function() {
				return hasServ();
			},
			hasDepl : function() {
				return hasDepl();
			},
			hasElmMesur : function() {
				return hasElmMesur();
			},
			hasElmCtxFact : function() {
				return hasElmCtxFact();
			},
			hasOrNeedNoAutor : function() {
				return hasOrNeedNoAutor();
			},
			hasCsst : function() {
				return hasCsst();
			},
			needsCsst : function() {
				return needsCsst();
			},
			isJourFerie : function(lieu, date) {
				return isJourFerie(lieu, date);
			},
			httpPost: function(path, obj, type, fct) {
				httpPost(path, obj, type, fct);
			},
			idFactRamqRecev: function() {
				return idFactRamqRecev;
			},
			demRecev: function(v) {
				if (arguments.length==0) {
					return demRecev;
				}
				demRecev = v;
			},
			currentDefault: function() {
				return currDefault;
			},
			setCurrDefaultValues: function(obj, val) {
				if(angular.isDefined(obj)){
					currDefault[obj] = val;	// voir CONFIG dans app.js, et dans SyraSettings.java
				}
			},
			setCurrDefault: function(val) {
				currDefault = val;
				// default values set - means first call after connexion. Pousser maintenant 
				// la liste des demandes correspondant aux données défauts.
				getDemListe();
			},
			saveCurrDefaultValues: function(obj, v) {
				saveCurrDefault(obj, v);
			},
			currentGlobalDefault: function() {
				return currGlobalDefault;
			},
			setCurrGlobalDefaultValues: function(obj, val) {
				if(angular.isDefined(obj)){
					currGlobalDefault[obj] = val;
				}
			},
			setCurrGlobalDefault: function(val) {
				currGlobalDefault = val;
			},
			saveCurrGlobalDefaultValues: function(obj, v) {
				saveCurrGlobalDefault(obj, v);
			},
			setGenerIdMachDone: function(v) {
				if (angular.isDefined(v.code)) {
					generIdMachDone.val.severity = v.severity;
					generIdMachDone.val.message = v.message;
					generIdMachDone.val.code = v.code;
					generIdMachDone.val.data = v.data;
				}
			},
			getGenerIdMachDone: function() {
				return generIdMachDone;
			},
			setRenewIdMachPswdDone: function(v) {
				if (angular.isDefined(v.code)) {
					renewIdMachPswdDone.val.severity = v.severity;
					renewIdMachPswdDone.val.message = v.message;
					renewIdMachPswdDone.val.code = v.code;
					renewIdMachPswdDone.val.data = v.data;
				}
			},
			getRenewIdMachPswdDone: function() {
				return renewIdMachPswdDone;
			},
			setUpdateFichierAideDone: function(v) {
				if (angular.isDefined(v.code)) {
					updateFichierAideDone.val.severity = v.severity;
					updateFichierAideDone.val.message = v.message;
					updateFichierAideDone.val.code = v.code;
				}
			},
			getUpdateFichierAideDone: function() {
				return updateFichierAideDone;
			},
			currentFichExplPaimt: function(v) {
				// n'ai qu'une methode pour cette var. Avec et sans parametre, pour le set ou le get
				if (arguments.length) {
					currFichExplPaimt = v;
					$timeout(function(){fichExplPaimtNew.val++;},1);
				}
				return currFichExplPaimt;
			},
			idInscrUpdated: function(v) {
				if (arguments.length) {
					$timeout(function(){idInscrUpdated.val++;},1);
				}
				return idInscrUpdated;
			},
			filterFromConcil: function(v) {
				if (arguments.length) {
					$timeout(function(){filterFromConcil.val++;},1);
				}
				return filterFromConcil;
			},
			fichObtenusNew: function(v) {
				if (arguments.length) {
					fichObtenusNew = v;
				}
				return fichObtenusNew;
			},
			noRfpsFromConcil: function(v) {
				if (arguments.length) {
					noRfpsFromConcil = v;
					$timeout(function(){filterFromConcil.val++;},1);
				}
				return noRfpsFromConcil;
			},
			fichExplPaimtNew: function(v) {
				if (arguments.length) {$timeout(function(){fichExplPaimtNew.val++;},1);
				} else {return fichExplPaimtNew;}
			},
			demListeShowSelected: function(v) {
				if (arguments.length) {$timeout(function(){demListeShowSelected.val++;},1);
				} else {return demListeShowSelected;}
			},
			demListeShowCurrentDemForListe: function(v) {
				if (arguments.length) {$timeout(function(){demListeShowCurrentDemForListe.val++;},1);
				} else {return demListeShowCurrentDemForListe;}
			},
			demListeItemUpdated: function(v) {
				// la conclusion d'un timout force un digest()
				if (arguments.length) {$timeout(function(){demListeItemUpdated.val++;},1);
				} else {return demListeItemUpdated;}
			},
			lstLigneFactServMdcalDelUpdated: function(v) {
				// la conclusion d'un timout force un digest()
				if (arguments.length) {$timeout(function(){lstLigneFactServMdcalDelUpdated.val=v;},1);
				} else {return lstLigneFactServMdcalDelUpdated;}
			},
			lstLigneFactServMdcalModUpdated: function(v) {
				// la conclusion d'un timout force un digest()
				if (arguments.length) {$timeout(function(){lstLigneFactServMdcalModUpdated.val=v;},1);
				} else {return lstLigneFactServMdcalModUpdated;}
			},
			currDemListeUpdated: function(v) {
				if (arguments.length) {$timeout(function(){currDemListeUpdated.val++;},1);
				} else {return currDemListeUpdated;}
			},
			currPatientUpdated: function(v) {
				if (arguments.length) {$timeout(function(){currPatientUpdated.val++;},1);
				} else {return currPatientUpdated;}
			},
			ptInscritAndMdFamUpdated: function(v) {
				if (arguments.length) {$timeout(function(){ptInscritAndMdFamUpdated.val++;},10);
				} else {return ptInscritAndMdFamUpdated;}
			},
			inscrB2bUpdated: function(v) {
				if (arguments.length) {$timeout(function(){inscrB2bUpdated.val++;},1);
				} else {return inscrB2bUpdated;}
			},
			seeHistFilterUpdated: function(v) {
				if (arguments.length) {$timeout(function(){seeHistFilterUpdated.val++;},1);
				} else {return seeHistFilterUpdated;}
			},
			typEvenePersUpdated: function(v) {
				if (arguments.length) {$timeout(function(){typEvenePersUpdated.val++;},1);
				} else {return typEvenePersUpdated;}
			},
			lstElmCxFactFTUpdated: function(v) {
				if (arguments.length) {$timeout(function(){lstElmCxFactFTUpdated.val++;},1);
				} else {return lstElmCxFactFTUpdated;}
			},
			lstlstFraisTranpUpdated: function(v) {
				if (arguments.length) {$timeout(function(){lstlstFraisTranpUpdated.val++;},1);
				} else {return lstlstFraisTranpUpdated;}
			},
			lstFraisSejUpdated: function(v) {
				if (arguments.length) {$timeout(function(){lstFraisSejUpdated.val++;},1);
				} else {return lstFraisSejUpdated;}
			},
			lstTempsDeplaUpdated: function(v) {
				if (arguments.length) {$timeout(function(){lstTempsDeplaUpdated.val++;},1);
				} else {return lstTempsDeplaUpdated;}
			},
			lstForfaDeplaUpdated: function(v) {
				if (arguments.length) {$timeout(function(){lstForfaDeplaUpdated.val++;},1);
				} else {return lstForfaDeplaUpdated;}
			},
			currDemPaimtUpdated: function(v) {
				if (arguments.length) {$timeout(function(){currDemPaimtUpdated.val++;},1);
				} else {return currDemPaimtUpdated;}
			},
			b2bGetInscrUpdated: function(v) {
				if (arguments.length) {$timeout(function(){b2bGetInscrUpdated.val++;},1);
				} else {return b2bGetInscrUpdated;}
			},
			b2bGetInscrEndUpdated: function(v) {
				if (arguments.length) {$timeout(function(){b2bGetInscrEndUpdated.val++;},1);
				} else {return b2bGetInscrEndUpdated;}
			},
			reglePlafValid: function(v) {
				if (arguments.length) {$timeout(function(){reglePlafValid.val++;},1);
				} else {return reglePlafValid;}
			},
			currentDemListe: function() {
				return currDemListe;
			},
			setCurrDemListe: function(val) {
				setCurrDemListe(val);
			},
			getDemListe: function(c) {
				getDemListe(c);
			},
			criteriaActive: function() {
				return criteriaActive;
			},
			activeCriteriaStatusRep: function(v) {
				if (arguments.length) {
					activeCriteriaStatusRep = v;
				} else {
					return activeCriteriaStatusRep;					
				}
			},
			isDirty: function() {
				return isDirty();
			},
			dirtyStatus: function(obj) {
				return obj.dirtyStatus;
			},
			resetDirtyStatus: function() {
				resetDirtyStatus();
			},
			setDirtyStatus: function(obj, val) {
				setDirtyStatus(obj, val);
			},
			getUser: function(v) {
				return getUser(v);
			},
			currentUsersList: function() {
				return currUsersList;
			},
			setUsersList: function(obj) {
				setUsersList(obj);
			},
			currentUser: function() {
				return currUser;
			},
			setCurrUser: function(obj, modified) {
				currUser=obj;
				httpPostCurrent('currentBillUser', obj);
			},
			currentProf: function() {
				return currProf;
			},
			setCurrProf: function(obj, modified) {
				currProf=obj;
				httpPostCurrent('currentProf', obj);
				setDirtyStatus(currProf, modified);	// permet de voir ui dirty mais on doit savoir que currProf est sync avec backend
			},
			currentGroup: function() {
				return currGroup;
			},
			setCurrGroup: function(obj, modified) {
				currGroup=obj;
				httpPostCurrent('currentGroupe', obj);
				setDirtyStatus(currGroup, modified);	// permet de voir ui dirty mais on doit savoir que currGroup est sync avec backend
			},
			currentLieu: function() {
				return currLieu;
			},
			setCurrLieuTypLocEtab: function(v, modified) {
				currLieu.typLocEtab = v;
				setDirtyStatus(currDemPaimt, modified);	// permet de voir ui dirty mais on doit savoir que currLieu est sync avec backend
				httpPost("/syra/lieu_typLocEtab/post", v);		
			},
			setCurrLieuTypIdLieuGeo: function(v, modified) {
				currLieu.local.typIdLieuGeo = v;
				setDirtyStatus(currLieu, modified);
				httpPost("/syra/lieu_typIdLieuGeo/post", v);
			},
			setCurrLieuTypLieuGeo: function(v, modified) {
				currLieu.local.typLieuGeo = v;
				setDirtyStatus(currDemPaimt, modified);
				httpPost("/syra/lieu_typLieuGeo/post", v);
			},
			setCurrLieuCodLocal: function(v, modified) {
				if (!angular.isDefined(currLieu.local)) {
					currLieu.local = {};
				}
				if (!angular.isDefined(currLieu.local.valCodLocal)) {
					currLieu.local.valCodLocal = {};
				}
				currLieu.local.valCodLocal.codLocal = v;
				setDirtyStatus(currDemPaimt, modified);
				httpPost("/syra/lieu_codLocal/post", v);
			},
			setCurrLieuNoSelectedEtab: function(v, modified) {
				if (!angular.isDefined(currLieu.etab)) {
					currLieu.etab = {};
				}
				currLieu.etab.noSelectedEtab=v;
				setDirtyStatus(currDemPaimt, modified);
				httpPost("/syra/lieu_noSelectedEtab/post", v);
			},
			setCurrLieuSecC: function(v, modified) {
				if (!angular.isDefined(currLieu.etab)) {
					currLieu.etab={};
				}
				if (!angular.isDefined(currLieu.etab.valSect)) {
					currLieu.etab.valSect={};
				}
				currLieu.etab.valSect.noSectActiv = v;
				setDirtyStatus(currDemPaimt, modified);
				httpPost("/syra/lieu_sect_c/post", v);
			},
			setCurrLieuCodPreciSectActiv: function(v, modified) {
				if (angular.isUndefined(currLieu.etab)) {
					currLieu.etab={};
				}
				currLieu.etab.codPreciSectActiv = v;
				setDirtyStatus(currDemPaimt, modified);
				httpPost("/syra/lieu_codPreciSectActiv/post", v);
			},
			setCurrLieuCodPreciLieu: function(v, modified) {
				setDirtyStatus(currDemPaimt, modified);
				httpPost("/syra/lieu_codPreciLieu/post", v);
			},
			setCurrLieuValEtab: function(obj, modified) {
				currLieu.etab.valEtab=obj;
				setDirtyStatus(currDemPaimt, modified);
			},
			setCurrLieuValCodLocal: function(v, modified) {
				currLieu.local.valCodLocal=v;
				if ($.isEmptyObject(v)) {
					setCurrLieuValCodLocalNull();
				} else {
					httpPost("/syra/etabl/post", v);					
				}
				setDirtyStatus(currDemPaimt, modified);
			},
			setCurrLieuValSect: function(obj, modified) {
				if (obj) {
					currLieu.etab.valSect.desSectActiv=obj.desSectActiv;
					currLieu.etab.valSect.noSectActiv = obj.noSectActiv;
					httpPost("/syra/lieu_sect_c/post", obj.noSectActiv);
				} else {
					if (currLieu.etab.valSect.desSectActiv) delete currLieu.etab.valSect.desSectActiv;
					if (currLieu.etab.valSect.noSectActiv ) delete currLieu.etab.valSect.noSectActiv;
				}
				setDirtyStatus(currDemPaimt, modified);
			},
			currentPatient: function() {
				return currPatient;
			},
			postCurrentPatient: function() {
				var oPt = _.clone(currPatient);
				delete oPt.$$hashKey;
				if (oPt.bds && typeof oPt.bds.getDate=='function') {
					oPt.bds = new moment(oPt.bds).format('YYYY-MM-DD');
				}
				delete oPt.lstDx;
				delete oPt.codeDx;
				delete oPt.dirtyStatus;
				//httpPostCurrent("currentPatient", oPt);
				var sObj = JSON.stringify(oPt);
				var cUidObject = {'o': sObj, 'u': clientUid, 't' : 'currentPatient'};
				$http({method : "POST",
					url : "/syra/currentvalue/post",
					data:  JSON.stringify(cUidObject),
					headers: {'Content-Type': 'application/json; charset=utf-8'}
				}).then(function mySucces(response) {
					$timeout(function(){currPatientUpdated.val++;},1);
				}, function myError(response) {
					warning(response.statusText);
				});
			},
			setDefaultCurrPersAutre: function() {
				setCurrPatientNull();
				currPatient.typePerson=3;
				currDx = {};
				currPatient.tag = atomicInt();
			},
			setDefaultCurrPatient: function() {
				setCurrPatientNull();
				currPatient.typePerson=1;
				currPatient.typSituConsi=1;
				currPatient.typIdPerson=1;
				currPatient.typEvenePers = "0";
				// il faut ajouter un dx vide
				currDx = {};
				currDx.tag = atomicInt();
				currPatient.lstDx.put(currDx.tag, currDx);
				currPatient.tag = atomicInt();
			},
			getIdent: function(pt, fn) {
				if (arguments.length==1) {
					return getIdent(pt);
				} else if (arguments.length==2) {
					return getIdent(pt, fn);
				} else {
					return getIdent(currPatient);
				}
			},
			getIdent4Print: function(pt, fn) {
				if (arguments.length==1) {
					return getIdent4Print(pt);
				} else if (arguments.length==2) {
					return getIdent4Print(pt, fn);
				}
				return "";
			},
			getHinName: function(pt) {
				var name = "";
				if (angular.isDefined(pt)) {
					if (angular.isDefined(pt.hin)) {
						name = pt.hin;
						if (angular.isDefined(pt.ln)) {
							name = name + ": " + pt.ln;
						}
						if (angular.isDefined(pt.fn)) {
							name = name + ", " + pt.fn;
						}
					} else if (angular.isDefined(pt.ln)) {
						name = getIdent(pt, pt.fn);
					} else {
						name = "???";
					}
				} else {
					name = "???";
				}
				return name;
			},
			setCurrPatient: function(obj, modified) {
				if (angular.isUndefined(obj) || obj===null) {
					setCurrPatientNull();
					return;
				}
				currPatient=obj;
				if (modified) {
					// donc a été modifié par le user et non via websocket - on ne peut envoyer une lstDx vide - cause erreur avec le backend quand il essait de mapper sur lstDx ici en raison de propriétés (elles sont retirées dans le save)
					httpPostCurrent("currentPatient", currPatient);
				}
				currPatient.ident = getIdent(currPatient);
				if (!currPatient.lstDx) {
					currPatient.lstDx = new Hashtable({ hashCode: tagHash });
				}
				if (currPatient.lstDx.size()>0) {
					currDx = currPatient.lstDx.values()[0];
				} else {
					currDx = {};
				}
				if (currPatient.datEvenePers) {
					currPatient.datEve = moment(new Date(currPatient.datEvenePers));
				}
				setDirtyStatus(currPatient, modified);
			},
			addPatientToLst: function(obj, modified) {
				if (!$.isEmptyObject(obj) && obj.tag) {
					currDemPaimt.serv.lstPatients.put(obj.tag, obj);
					setDirtyStatus(currDemPaimt.serv.lstPatients, modified);
				}
			},
			httpPostCurrent: function(t, o) {
				httpPostCurrent(t, o);
			},
			clearLstCurrPatients: function(obj, modified) {
				currDemPaimt.serv.lstPatients.clear();
				setDirtyStatus(currDemPaimt.serv.lstPatients, modified);
			},
			removePatientFromLst: function(obj, modified) {
				if (angular.isDefined(obj.tag)) {
					currDemPaimt.serv.lstPatients.remove(obj.tag);
					setDirtyStatus(currDemPaimt.serv.lstPatients, modified);
				}
			},
			currentDx: function() {
				return currDx;
			},
			setCurrDx: function(obj, modified) {
				currDx=obj;
				setDirtyStatus(currPatient, modified);
			},
			currentPatientData: function() {
				return currPatientData;
			},
			setCurrPatientData: function(obj) {
				if (angular.isUndefined(obj.prof)) {
					obj.prof = {};
				}
				currPatientData = obj;
			},
			currentLigneServMdcal: function() {
				return currLigneServMdcal;
			},
			validateDemPaimtServMdcal: function(d) {
				return validateDemPaimtServMdcal(d);
			},
			validateLigneServMdcal: function(ligne) {
				return validateLigneServMdcal(ligne);
			},
			setCurrLigneServMdcal: function(obj, fromGetNew) {
				currLigneServMdcal=obj;
				if (angular.isUndefined(fromGetNew) || !fromGetNew) {
					httpPost("/syra/ligneServMdcal/post", obj.noLigne);
				}
			},
			setCurrLigneServMdcalNull: function() {
				setCurrLigneServMdcalNull();
//				setDirtyStatus(currLigneServMdcal, modified); deja appelé auparavant si pertinent
			},
			saveCurrLigneServMdcalDate: function() {
				setDirtyStatus(currDemPaimt.serv.lstLigneFact, true);
				// le save est séparé du set car le set est appelé aussi via websocket, p.ex. lors de création d'une ligne
				httpPost("/syra/ligneServMdcalDate/post", currLigneServMdcal.dateServ);
			},
			saveCurrLigneServMdcalRole: function() {
				// le save est séparé du set car le set est appelé aussi via websocket, p.ex. lors de création d'une ligne
				httpPost("/syra/ligneServMdcalRole/post", currLigneServMdcal.codRole);
			},
			saveCurrLigneServMdcalCode: function() {
				// le save est séparé du set car le set est appelé aussi via websocket, p.ex. lors de création d'une ligne
				httpPost("/syra/ligneServMdcalCode/post", currLigneServMdcal.codFact);
			},
			addLigneServMdcalToLst: function(obj, modified) {
				if (!$.isEmptyObject(obj)) {
					currDemPaimt.serv.lstLigneFact.put(obj.noLigne, obj);
					currLigneServMdcal = obj;
					setDirtyStatus(currDemPaimt.serv.lstLigneFact, modified);
				}
			},
			removeLigneServMdcalFromLst: function(obj, modified) {
				currDemPaimt.serv.lstLigneFact.remove(obj.noLigne);
				setDirtyStatus(currDemPaimt.serv.lstLigneFact, modified);
				httpPost("/syra/removeLigneServMdcalFromLst/post", obj.noLigne);
			},
			removeLignesByNoServMdcalFromLst: function(obj) {
				for (var i in obj) {
					currDemPaimt.serv.lstLigneFact.remove(obj[i]);
					$timeout(function(){lstLigneFactServMdcalDelUpdated.val=obj[i];},1);	
				}
			},
			modifiyLignesServMdcalOfLst: function(obj) {
				for (var i in obj) {
					//$log.log('i=' + i + ", obj = " + obj[i]);
					currDemPaimt.serv.lstLigneFact.put(obj[i].noLigne, obj[i]);
					$timeout(function(){lstLigneFactServMdcalModUpdated.val=obj[i];},1);
				}				
			},
			setCurrDemPaimtType: function(t) {
				if (t==1) {
					delete currDemPaimt().depl;
					currDemPaimt().serv = {};
				} else if (t==2) {
					delete currDemPaimt().serv;
					currDemPaimt().depl = {};
				}
				saveCurrDefault(CONFIG.DEM_PAIMT_TYPE, t);
			},
			setCurrModaPaimtType: function(t, modified) {
//				saveCurrDefault(CONFIG.PROF_MODA_PAIMT + currProf.noProf, t);
				if ('1'==t) {
					currGroup = {};
				}
				setDirtyStatus(currGroup, modified);
			},
			setDemPaimtType: function(t) {
				currDemPaimt.type = t;	// nécessaire pour savoir si serv ou depl. dans le saveBill
				saveCurrDefault(CONFIG.DEM_PAIMT_TYPE, t);
			},
			currentDemPaimt: function() {
				return currDemPaimt;
			},
			setCurrDemPaimt: function(obj, isNew) {
				setCurrDemPaimt(obj, isNew);
			},
			setCurrBillQueueSize: function(v) {
				$timeout(function(){currBillQueueSize.val = v;},1);
			},
			getCurrBillQueueSize: function() {
				return currBillQueueSize.val;
			},
			currentDemForListe: function() {
				return currDemForListe;
			},
			setCurrDemForListeDeleted: function() {
				setCurrDemPaimtNull();
				currDemListe.remove(currDemForListe.tag);
				currDemForListe = {};
				$timeout(function(){demListeItemUpdated.val++;},1);	
			},
			setCurrDemForListe: function(obj, isNew) {
				currDemForListe=obj;
				$timeout(function(){demListeShowCurrentDemForListe.val++;},1);	
				if (!isNew) {
					httpPost("/syra/bill/post", obj.tag);
				}
			},
			saveCurrDemForListValue: function(obj, val, modified, methodToDo) {
				saveCurrDemForListValue(obj, val, modified, methodToDo);
			},
			canPrintBill: function() {
				var can =  !$.isEmptyObject(currDemForListe);	// il faut une facture active
				return can;
			},
			currentHistoricBills: function(v) {
				return currHistoricBills;
			},
			setCurrHistoricBills: function(v) {
				MyNamespace.helpers.clearAndAddToArray(currHistoricBills, v);
			},
			callForCurrentHistoricBills: function() {
				httpPost("/syra/historic_bill/post", {});
			},
			callForCurrentPlafBills: function() {
				httpPost("/syra/plaf_bill/post", {});
			},
			demListeForPrint: function(v) {
				return arguments.length ? demListeForPrint = v : demListeForPrint;
			},
			sumBillForPrint: function(v) {
				return arguments.length ? sumBillForPrint = v : sumBillForPrint;
			},
			forbidAddBill: function() {
				var tpsReel = currGlobalDefault['envoi_tps_reel'];
				return tpsReel && isDirty();
			},
			forbidAddSharedBill: function() {
				var tpsReel = currGlobalDefault['envoi_tps_reel'];
				var hasNoDataInQueue = billQueue.val.length===0;
				return hasNoDataInQueue || (tpsReel && hasNoDataInQueue && isDirty());
			},
			restoreBill: function(billTag) {
				restoreBill(billTag);
			},
			deleteBill: function(billTag) {
				deleteBill(billTag);
			},
			cancelModifBill: function() {
				cancelModifBill(currDemForListe);		
			},
			calledAddBill: function(v) {
				if (arguments.length) {calledAddBill=v;
				} else {return calledAddBill;}
			},
			calledCopyBill: function(v) {
				if (arguments.length) {calledCopyBill=v;
				} else {return calledCopyBill;}
			},
			canSaveBill: function() {
				var canSave = angular.isUndefined(currDemPaimt.cNoDemExt) || !currDemForListe.ready;	// peut toujours sauver si non terminée
				canSave = canSave || (currDemPaimt.type===1 && hasProfAndEtab() && currDemPaimt.serv.lstLigneFact && currDemPaimt.serv.lstLigneFact.size()>0 && angular.isDefined(currDemPaimt.serv.lstLigneFact.values()[0].codFact.c));	// validate presence of services
				canSave = canSave || (currDemPaimt.type===2 && hasProfAndEtab());	// ds depl, je ne checke pas si des lignes...
				return canSave;
			},
			savedBillOk: function(v) {
				if (arguments.length) {$timeout(function(){savedBillOk.val++;},1);
				} else {return savedBillOk;}
			},
			saveBill: function() {
				saveBill(currDemPaimt);
			},
			showReglePlafValid: function(data) {
				// v = HashMap<Integer, List<ReglePlafonnementReponse>> (code fact, lst<rpr>)
				currDemPaimt.reglePlafMsg = data.message;
				var v = data.data;
				//$log.log(currDemPaimt.reglePlafMsg);
				currDemPaimt.reglePlaf = v;
				// SLM pour montrer les règles.
				for (var code in currDemPaimt.reglePlaf) {
				    if (currDemPaimt.reglePlaf.hasOwnProperty(code)) {
				        // do stuff
				    	var codeData = currDemPaimt.reglePlaf[code];
						for (var i = 0; i < codeData.length; i++) {
							var lf = codeData[i].lf;
							var codePlaf = lf.c;
							var rp = codeData[i].rp;
							//$log.log(rp.d);
							var codeRech = rp.codeRechange;
							var elmCtx = rp.elmCtx;	// array							
							//$log.log("code:"+codePlaf+", cr:"+codeRech+", elmCtx:" + elmCtx.length);
						}
				    }
				}
				reglePlafValid.val++;
			},
			setSavedBill: function(v) {
				//$log.log(v);
				if (v.severity=='OK' || v.severity=='INFO') {
					var tpsReel = currGlobalDefault['envoi_tps_reel'];
					if (angular.isDefined(v.data)) {	// tag et id de currDemForListe
						var ids = v.data;
						var curDl = currDemListe.get(ids[0]);
						if (curDl) {
							curDl.id = ids[1];	// mettre le nouvel id.
							if (tpsReel && curDl.tag===currDemForListe.tag) {
								// il faut recharger la facture
								httpPost("/syra/bill/post", currDemForListe.tag);
							}
						}
					}
					$timeout(function(){demListeItemUpdated.val++;},1);
					if (!tpsReel) {
						resetDirtyStatus();
						$timeout(function(){savedBillOk.val++;},5);	// pour continuer le addBill le cas échéant après un save, via un watch						
					}
					if (v.severity=='INFO') {
						info(v.message);
					}
				} else if (v.severity=='WARNING') {
					warning(v.message);
				} else if (v.severity=='ERROR' || v.severity=='BUG') {
					error(v.message);
				}
			},
			setProfPrefProp: function(idProf, val) {
				// l'envoi au backend (pref/autre) se fait via un ng-change (ex changeInscrit) et le save avec le pgwModal::close
				lstProfPref.put(idProf, val);
			},
			setProfPrefPropValue: function(idProf, prop, val) {
				// l'envoi au backend (pref/autre) se fait via un ng-change (ex changeInscrit) et le save avec le pgwModal::close
				var pp = lstProfPref.get(idProf);
				if (pp==null) {
					pp = {};
					lstProfPref.put(idProf, pp);
				}
				pp[prop] = val;
			},
			profPrefPropValue: function(idProf, prop, def) {
				var pp = lstProfPref.get(idProf);
				if (pp==null) {
					pp = {};
					pp[prop] = def;
					lstProfPref.put(idProf, pp);
				}
				return pp[prop];
			},
			sharingActivated: function(v) {
				if (arguments.length) {
					$timeout(function(){sharingActivated.val = v;},1);	
					return;
				}
				return sharingActivated.val;
			},
			focusOnCode: function(f) {
				if (arguments.length) {
					focusOnCode = f;
					return;
				}
				focusOnCode();
			},
			setFirstFocus: function(f) {
				firstFocus = f;
			},
			firstFocus: function() {
				firstFocus();
			},
			isIE: isIE,
			warning: function(t) {
				warning(t);
			},
			info: function(t) {
				info(t);
			},
			error: function(t) {
				error(t);
			}
		}
	}]);
	
	syra.factory('SyraWebSocket', ['$websocket','$http', '$log', '$timeout', 'clientUid', 'model', '$window', function($websocket, $http, $log, $timeout, clientUid, model, $window) {
	      // Open a WebSocket connection
		var that = this;
		var model = model;
		that.clientUid = clientUid;	// mis dans la var clientUid de SyraSocket - 5ctr, >3m de possibilités
		that.location = 'ws://' + document.location.host + "/syrawebsocket?u=" + that.clientUid;
		
		that.loadConnection = function() {
			that.ws = $websocket(that.location);

			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				var input = res.data;
				MyNamespace.helpers.convertDateStringsToDates(input);
				model.setCurrDefault(input);
			}, {filter: /^{\"t\":\"currDefaultType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				var input = res.data;
				for (var key in input) {
				  if (input.hasOwnProperty(key)) {
						$timeout(function(){model.setCurrDefaultValues(key,input[key]);}, 1);
				  }
				}
			}, {filter: /^{\"t\":\"currDefaultValueType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				var input = res.data;
				for (var key in input) {
					if (input.hasOwnProperty(key)) {
						var isTrue = String(input[key])=='true';
						var isFalse = String(input[key])=='false';
						var v = (isTrue||isFalse) ? isTrue : input[key];
						$timeout(function(){model.setCurrGlobalDefaultValues(key,v);}, 1);
					}
				}
			}, {filter: /^{\"t\":\"currGlobalDefaultValueType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				var input = res.data;
				MyNamespace.helpers.convertDateStringsToDates(input);
				model.setCurrGlobalDefault(input);
			}, {filter: /^{\"t\":\"currGlobalDefaultType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				var currId = model.currentDemForListe() ? model.currentDemForListe().id : undefined;
				if (MyNamespace.helpers.isNotEmpty(currId))  {
					model.setCurrDemPaimt(res.data, false);
				}
			}, {filter: /^{\"t\":\"currDemPaimtType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
					model.setCurrBillQueueSize(res.data, false);
			}, {filter: /^{\"t\":\"billQueueSize/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
					function tagHash(a) {
						return a.tag;
					}
					var pt = res.data;
				    pt.dirtyStatus = {};
					pt.lstDx = new Hashtable({ hashCode: tagHash });
					currDx = {};
					currDx.tag = model.atomicInt();
					pt.lstDx.put(currDx.tag, currDx);
					if (!pt.persRepdn) {
						pt.persRepdn = {};
					}
					if (!pt.adr) {
						pt.adr = {};
						pt.adr.cy = {};
					}
					model.clearLstCurrPatients(null, false);
					pt.ident = model.getIdent(pt);
					model.addPatientToLst(pt, true);
					model.setCurrPatient(pt, false);
				}, {filter: /^{\"t\":\"setCurrentPatient/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				// a besoin de forcer un refresh de la ligne active car est absente au backend. * ne devrait pas être nécessaire...
				var currLigne = {};	// besoin de slm qq info de base. situation exceptionnelle qui ne semble survenir que lorsque pas de code.
				currLigne.dateServ = model.currentLigneServMdcal().dateServ;
				currLigne.codRole = model.currentLigneServMdcal().codRole;
				currLigne.noLigne = model.currentLigneServMdcal().noLigne;
				model.httpPost("/syra/ligneServMdcal/post", JSON.stringify(currLigne));
			}, {filter: /^{\"t\":\"mustSetCurrentCLigneServMdcalType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.removeLignesByNoServMdcalFromLst(res.data);	// un array of int
			}, {filter: /^{\"t\":\"removeLignesByNoServMdcalFromLst/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.modifiyLignesServMdcalOfLst(res.data);	// un Map noligne, CLigneTypeServMdcal
			}, {filter: /^{\"t\":\"modifiyLignesServMdcalOfLst/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.setCurrDefaultValues('autoSend', false);
			}, {filter: /^{\"t\":\"sendAutoSendOffType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				if (angular.isDefined(res.data) && angular.isDefined(res.data.severity) && res.data.severity=='ERROR') {
					showErrorMessage(res.data.message);					
				}
			}, {filter: /^{\"t\":\"sendErreurMessageType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.currentFichExplPaimt(res.data);
			}, {filter: /^{\"t\":\"fichExplPaimtNewType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				//$log.log(res.data);	// afficher progression - arr id, p
				var ids = res.data;
				var cdl;
				if (ids.tag) {
					cdl = model.currentDemListe().get(ids.tag);					
				}
				if (cdl) {
					var tpsReel = model.currentGlobalDefault()['envoi_tps_reel'];
					if (ids.prg) {
						cdl.prg = ids.prg;
						if (!tpsReel && cdl.prg===1 && cdl.tag==model.currentDemForListe().tag) {
							// spin de la facture active. Il faut la désélectionner
				        	model.setCurrDemForListe({}, true);
				        	model.setCurrDemPaimt({}, true);
						}
					}
					if (ids.dt) {
						cdl.dt = ids.dt;						
					}
					if (ids.sr) {
						cdl.sr = ids.sr;
					}
					if (ids.hon) {
						cdl.hon= ids.hon;
					}
					if (ids.mdt) {
						cdl.mdt = ids.mdt;
					}
					if (ids.noRfp) {
						cdl.noRfp = ids.noRfp;
					}
					if (ids.em) {
						cdl.em = ids.em;
					}
					model.demListeItemUpdated(true);
//					if (cdl.prg>1 && tpsReel && model.currentDemForListe() && cdl.tag==model.currentDemForListe().tag) {
//						// il faut recharger la facture
//						model.httpPost("/syra/bill/post", model.currentDemForListe().tag);
//					}
				}
			}, {filter: /^{\"t\":\"sendDemListePrgType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				//$log.log(res.data);	// afficher progression - arr id, prg
				// en pos 0: tag; pos 1: var to update; pos 2 = new value.
				model.idInscrUpdated().rec = res.data;	// je prends cette valeur dans le watch
				model.idInscrUpdated(true);
			}, {filter: /^{\"t\":\"idInscrUpdatedType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				//$log.log(res.data);	// afficher progression - arr id, prg
				var ids = res.data;
				var cdl = model.currentDemListe().get(ids[0]);
				if (cdl) {
					cdl.ii = ids[1];
					model.demListeItemUpdated(true);						
				}
			}, {filter: /^{\"t\":\"sendDemListeIdIntvnType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.setCurrDemListe(res.data);
			}, {filter: /^{\"t\":\"currDemListeType/}
			);
//			that.ws.onMessage(function(event) {
//				var res;
//				try { res = JSON.parse(event.data);
//				} catch(e) {res = {'content': event.data};}
//				$timeout(function(){model.demListeForPrint(res.data);}, 1);
//			}, {filter: /^{\"t\":\"demListeForPrintType/}
//			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.showReglePlafValid(res.data);
			}, {filter: /^{\"t\":\"validReglePlafBillType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.setSavedBill(res.data);
			}, {filter: /^{\"t\":\"saveBillType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				if (angular.isDefined(res.data) && angular.isDefined(res.data.severity) && res.data.severity=='OK') {
					model.currentDemForListe().dl = 0;
					model.demListeItemUpdated(true);
				}
			}, {filter: /^{\"t\":\"restoreBillType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				if (angular.isDefined(res.data) && angular.isDefined(res.data.severity) && res.data.severity=='OK') {
					model.currentDemForListe().dl = 1;
					model.demListeItemUpdated(true);
//					model.setCurrDemForListeDeleted();
				}
			}, {filter: /^{\"t\":\"deleteBillType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.setCurrHistoricBills(res.data);
			}, {filter: /^{\"t\":\"histFacturationType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.setGenerIdMachDone(res.data);	// un status
			}, {filter: /^{\"t\":\"generIdMachType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.setRenewIdMachPswdDone(res.data);	// un status
			}, {filter: /^{\"t\":\"renewIdMachPswdType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.setUpdateFichierAideDone(res.data);	// un status
			}, {filter: /^{\"t\":\"updateFichierAideDoneType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				showInfoMessageB2b(res.data);
			}, {filter: /^{\"t\":\"b2bShowInfoWindowsType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				showErrorMessageB2b(res.data);
			}, {filter: /^{\"t\":\"b2bShowErrorWindowsType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.b2bGetInscrUpdated().text = res.data;
				model.b2bGetInscrUpdated(true);
			}, {filter: /^{\"t\":\"b2bObtenirInscrType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.b2bGetInscrUpdated().text = res.data;
				model.b2bGetInscrUpdated(true);
				model.b2bGetInscrEndUpdated(true);
			}, {filter: /^{\"t\":\"b2bObtenirInscrFinType/}
			);
			that.ws.onMessage(function(event) {
				var res;
				try { res = JSON.parse(event.data);
				} catch(e) {res = {'content': event.data};}
				model.sharingActivated(res.data === "1");
			}, {filter: /^{\"t\":\"shareDmeType/}
			);
			
			that.ws.onError(function(event) {
				console.log('connection Error', event);
			});

			that.ws.onClose(function(event) {
				console.log('connection closed', event);
				showDisconected();
			});

			that.ws.onOpen(function() {
				console.log('connection open, clientUid=' + that.clientUid);
//				that.ws.send({'t': 'msg', 'uid': that.clientIud, 'content': 'Hello World'});
			});

		};

		that.loadConnection();
		
		that.loadDefaults = function(){
			$http({method : "GET",
					url : "/syra/senddefaultsws?u=" + clientUid,
					params: {"cacheiefix": new Date().getTime()}
			});
		}
		
		that.loadDefaults();
		
		function showDisconected(){
			$.pgwModal({
				content: "<p style='text-align: center'>Votre session a été désactivée en raison d'inactivité ou d'arrêt de MED-Office.</p>" +
						"<p style='text-align: center'><b><a style='cursor: pointer;' onclick=\"$.pgwModal('getData').reload()\">Recharger la page</a></b></p>",
			    maxWidth: $( window ).width() * .4,
			    angular: true,
			    closable : false,
			    closeOnEscape : false,
			    closeOnBackgroundClick : false,
			    modalData: {
			    	reload : function(){$window.location.reload();}
			    },
			    title: 'Session fermée'
			});
		}

		function showInfoMessageB2b(m){
			$.pgwModal({
				content: "<p class='info'>" + m + "</p>",
				maxWidth: $( window ).width() * .7,
				angular: true,
				closable : true,
				closeOnEscape : false,
				closeOnBackgroundClick : false,
				title: "Information retournée par le serveur de la RAMQ"
			});
		}
		
		function showErrorMessageB2b(m){
			$.pgwModal({
				content: "<p class='alert alert-danger'>" + m + "</p>",
				maxWidth: $( window ).width() * .7,
				angular: true,
				closable : true,
				closeOnEscape : false,
				closeOnBackgroundClick : false,
				title: "Message retourné par le serveur de la RAMQ"
			});
		}
		
		function showErrorMessage(m){
			$.pgwModal({
				content: "<p class='alert alert-danger'>" + m + "</p>",
				maxWidth: $( window ).width() * .7,
				angular: true,
				closable : true,
				closeOnEscape : false,
				closeOnBackgroundClick : false,
				title: "Erreur retournée par le serveur d'application"
			});
		}
		
		$(document).bind('PgwModal::Close', function() {
			that.loadConnection();
		});
		
		return {
			clientUid: that.clientUid,
			status: function() {
				return that.ws.readyState;
			},
			send: function(message) {
				if (angular.isString(message)) {
					that.ws.send(message);
				}
				else if (angular.isObject(message)) {
					that.ws.send(JSON.stringify(message));
				}
			}
		};

	}]);
	
	syra.factory('ResponsiveDetection', function ($window) {
        return {
            getBreakpoint: function () {
                var w = $window.innerWidth;
                if (w < 800) {
                    return 'xs';
                } else if (w < 992) {
                    return 'sm';
                } else if (w < 1200) {
                    return 'md';
                } else {
                    return 'lg';
                }
            }
        };
    });
	
	syra.controller('MenuController', ['$q', '$filter', '$scope', '$http', '$window', '$timeout', '$interval', '$log', 'hotkeys', 'clientUid', 'model', 'AuthService','$location', '$uibModal', 'ngProgressFactory',
	                                   function ($q, $filter, $scope, $http, $window, $timeout, $interval, $log, hotkeys, clientUid, model,AuthService,$location, $uibModal, ngProgressFactory) {
		this.model = model;
		$scope.model = model;
		var that = this;
		$scope.model = model;
		$scope.isLocal = AuthService.isLocal;
		$scope.pgwModelOpen = {};	// mettre valeur pour la fenêtre ouvert, p.ex. $scope.pgwModelOpen.pref = true .fav, .print ...
		$scope.logout = function(){
			AuthService.logOut();
			$location.path('/auth');
		};
		$scope.isAuthenticated = function() {
			var s = AuthService.isAuthenticated().status;
			//$log.log('isAuthenticated=' + s);
			return s;
		};
		$scope.menuPopover = {
			isOpen:false,
		};
		
		$scope.showConnect = function() {
			var rep = AuthService.isLocal==false && that.model.currentGlobalDefault()['share_needsPswd']==true && that.model.currentGlobalDefault()['share_motDePasse']!='';
			//$log.log('showConnect=' + rep);
			return rep;
		};
		
		$scope.printThis = function() {
			$('#exportthis').addClass("topLeft");
			var target = $('#exportthis');
			html2canvas(target).then(function(canvas) {
                var imgData = canvas.toDataURL();
                // canvas a un width et un height. Je dois calculer pour avoir une hauteur max de 790 avec une largeur max de 580
                // si en diminuant la width a 580, je diminue en % le height et que ce dernier est < 770, on est ok. Sinon, il faut
                // mettre un width < afin que le height proportionnel fit dans une page.
                // devrait très bien fonctionner pour les formulaires. Dans ce dernier cas, on pourrait aussi probablement utilsier .x2
                // afin d'augmenter le nombre de pixels (je ne peux le faire ici en raison des classes col-... - tombe en 1 colonne... 
                var h = canvas.height;
                var w = canvas.width;
                var cW = 580;
                var ratio = cW/w;
                var ratioAdj = 0;
                var cH = ratio * h;
                while (cH >= 770) {	//test: 769.18 passe avec les marges ci-bas.
                	ratioAdj -= 0.01;
                	cH = (ratio+ratioAdj) * h;
                }
                cW =  (ratio+ratioAdj) * w;
                $('#exportthis').removeClass("topLeft");
                var docDef = {
                    content: [{
                    	style: 'allpage',
                        image: imgData,
                        width: cW
                    }],
                    pageSize: 'letter',
                    pageMargins: 10,
                    styles: {
                    	allpage: {
                            margin: [1, 1, 1, 1]
                        }
                    }              
                };
                var name = "Facture " + that.model.currentDemPaimt().cNoDemExt;
        		pdfMake.createPdf(docDef).getDataUrl(function(encodedString){
        			var pdfAsArray = convertDataURIToBinary(encodedString);
        			onPdfExportUnique(pdfAsArray, name);
        		});
			});
		};
		
        function onPdfExportUnique(binarydoc, titre){
        	$scope.pdfExportOpened = true;
        	$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "lg",
				resolve: {
					mObject: function () {
						return {
							title: titre,
							templateUrl:"/syra/Resources/views/pdfviewer.html",
							doc: binarydoc
						};
					}
				}
			});
    		$scope.modalInstance.result.then(function () {
    			$scope.pdfExportOpened = false;
            }, function () {
                $scope.pdfExportOpened = false;
            });	
        }        
				
		//Patient assist input
		$scope.filterPtAssist = {
				hasHeader: false, 
				assistId: "autocomplete_patient",
				getAjaxData: function(query){
					return { url:"/syra/patient/search",
						data: { k: query, u:clientUid }};
				},
				getKey: function(pat) {
					return pat.ln + ", " +pat.fn + ' (' + pat.gender + ':' + pat.bds + ") " + pat.dos;
				},
				actions: [{key: '=', callback: function(){that.commitPt();} },{key: '+', callback: function(){that.commitPt();} }],
				getDescription: function(pat) {
					var adrss = MyNamespace.helpers.cleanArray([pat.adr1,pat.adr2, pat.adr3, pat.cp]).join(', ');
					var adresse = adrss.length==0 ? "" : adrss + "; ";
					var vuln = pat.allDisCodes ? pat.allDisCodes : "";
					var hin = pat.hin ? pat.hin : "";
					var dos = (pat.dos && pat.dos.charAt(0)!='#') ? (', ' + pat.dos + '; ') : '';
					return pat.ln + ", " + pat.fn + ' [' + pat.bds +': ' + pat.gender + '] ' + hin + dos + 
					(typeof pat.isInsc=='undefined' ? '' : pat.isInsc=='0' ? 'NON inscrit; ':'INSCRIT; ') + 
					adresse + vuln;
				},
				selection: function(pat) {
					return pat.hin;
				}
		};
		
		$scope.filterProfAssist = {
				assistId: "autocomplete_prof",
				getAjaxData: function(query){
					delete that.model.currentProf().id;
					return { url:"/syra/professionals/search",
						data: { k: query, u:clientUid }};
				},
				listWidth: 300,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.noProf + "</div><div class='divCellCol2'>" + elem.lastName + ", " + elem.firstName + "</div></div></div>";},
				selection: function(elem) {
					this.lockEntry();
					return elem.noProf;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			};
				
		$scope.statPmtsValues = [{"v":1,"label":"Non conf."},{"v":2,"label":"Confirmée"},{"v":4,"label":"Pmt diff."},{"v":8,"label":"Modifiée"},{"v":16,"label":"Retenue"},{"v":32,"label":"En révision"}];
		$scope.readyToSendValues = [{"v":0,"label":"Non terminée"},{"v":1,"label":"Terminée"}];
		
		$scope.removeNoRfspFromConcil = function() {
			$scope.filterPopover.isFilterActive = false;
			that.model.noRfpsFromConcil([]);
			$scope.filterPopover.filter.statPmts = [1,2,4,8,16,32];	// remet les confirmés (le 2)
			delete $scope.filterPopover.filter.noRfps;
			$scope.filterPopover.removeFilter();
			$scope.filterPopover.close();
		};
		$scope.fromConcil = function() {
			return MyNamespace.helpers.isNotEmpty($scope.filterPopover.filter.noRfps) && $scope.filterPopover.filter.noRfps.length>0;
		};
		$scope.hasOneNo = function() {
			return MyNamespace.helpers.isNotEmpty($scope.filterPopover.filter.noExt) || MyNamespace.helpers.isNotEmpty($scope.filterPopover.filter.noRfp);
		};
		$scope.hasOneNoNotFromConcil = function(){
			return !$scope.fromConcil() && $scope.hasOneNo();
		};
		$scope.hasOneOrConcil = function(){
			return $scope.fromConcil() || $scope.hasOneNo();
		};
		$scope.hasNoExt = function() {
			return MyNamespace.helpers.isNotEmpty($scope.filterPopover.filter.noExt);
		};
		$scope.hasNoRfp = function() {
			return MyNamespace.helpers.isNotEmpty($scope.filterPopover.filter.noRfp);
		};
		$scope.activateNoFilterOnEnter = function(ev, val) {
			if (ev.keyCode==13) {	// enter
				if ($scope.hasOneNo()) {
					$scope.filterPopover.isFilterActive = true;
					$scope.filterPopover.setFilter();
				} else {
					// enter sans no - on désactive le filtre
					if ($scope.filterPopover.isFilterActive) {
						$scope.filterPopover.isFilterActive = false;
						$scope.filterPopover.removeFilter();
					}
				}
				$scope.filterPopover.close();
			} else if (ev.keyCode==27) {	// escape
				$scope.filterPopover.close();				
			}
		};
		$scope.filterPopover = {
			load:function(){
				var startBillListDateAssist = new DynaDate({elem:"startBillListDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, maxDateElm:'endBillListDate'});
				var endBillListDateAssist = new DynaDate({elem:"endBillListDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, minDateElm:'startBillListDate'});
			}, 
			isOpen: false,
			isFilterActive : false,
			filter: {
				readyToSend: null,
				dateDebut: moment().format("YYYY-MM-DD"),
				dateFin: moment().format("YYYY-MM-DD"),
				statusRep: "-1",
				autoAddMissingBill: false,
				andModified: false,
				includeDeleted: false,
				nam: "",
				statPmts: [1,2,4,8,16,32],
				readyToSends: [0,1]
//				noExt:-1,
//				noRfp:-1
//				user: that.model.currentDefault()['billsUser']
			},
	        templateUrl: 'myPopoverTemplate.html',
	        readyToSends: function readyToSends() {
	        	var r = $scope.filterPopover.filter.readyToSends;
	        	if (r.length==2) {
	        		$scope.filterPopover.filter.readyToSend = null;	        		
	        	} else {
	        		$scope.filterPopover.filter.readyToSend = r[0];
	        	}
	        },
	        readyToSend: function readyToSend(n){
	        	if($.isEmptyObject($scope.filterPopover.filter.readyToSend) && 
	        			$scope.filterPopover.filter.readyToSend != n){
	        		$scope.filterPopover.filter.readyToSend = n;
	        	}else{
	        		$scope.filterPopover.filter.readyToSend = null;
	        	}
	        },
	        open: function open() {
	          $scope.filterPopover.isOpen = true;
	        },
	        close: function close() {
	          $scope.filterPopover.isOpen = false;
	        },
	        setFilter: function setFilter(){
	        	if (typeof $scope.filterPopover.filter.user === 'object') {
	        		// le choix tous
	        		delete $scope.filterPopover.filter.user;
	        	}
	        	that.model.setCurrDemForListe({}, true);
	        	that.model.setCurrDemPaimt({}, true);
	        	that.model.getDemListe($scope.filterPopover.filter);
	        },
	        removeFilter: function removeFilter(){
	        	that.model.setCurrDemForListe({}, true);
	        	that.model.setCurrDemPaimt({}, true);
	        	that.model.getDemListe();
	        },
	        showIfActive: function showIfActive(){
	        	if ($scope.filterPopover.isFilterActive) {
	        		$scope.filterPopover.setFilter();
	        	}
	        },
	        activate: function activate(){
	        	$scope.filterPopover.isFilterActive = !$scope.filterPopover.isFilterActive;
	        	if($scope.filterPopover.isFilterActive){
	        		$scope.filterPopover.setFilter();
	        	}else{
	        		$scope.filterPopover.removeFilter();
	        	}
	        },
	        isActive: function isActive(){
	        	return $scope.filterPopover.isFilterActive;
	        }
	      };

		$scope.$watch(
				function (scope) {return scope.model.filterFromConcil().val;},
				function(newVal, oldVal, scope) {
					scope.filterPopover.filter.noRfps = scope.model.noRfpsFromConcil();
					if (MyNamespace.helpers.isNotEmpty(scope.filterPopover.filter.noRfps) && scope.filterPopover.filter.noRfps.length>0) {
						scope.filterPopover.isFilterActive = true;
						scope.filterPopover.filter.statPmts = [1,4,8,16,32];	// retrait des confirmées
						delete scope.filterPopover.filter.noExt;	// si une de ces valeurs est présente, ça empêche le filtre des confirmés.
						delete scope.filterPopover.filter.noRfp;
						scope.filterPopover.setFilter();
					}
				}
			);
		
		var activate_sharing = false;
		// getter setter for def
		$scope.def = {
			activate_sharing: function(newVal) {
				if (arguments.length) {
					activate_sharing = newVal;
					if (activate_sharing===true) {
						model.httpPost('share_dme_activate/post', {});
					} else {
						model.httpPost('share_dme_deactivate/post', {});
					}
					return;
				}
				return activate_sharing;
			},
			see_histTjrs: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_histTjrs', newVal);
					that.model.saveCurrDefaultValues('see_histTjrs');
					return;
				}
				return that.model.currentDefault()['see_histTjrs'];
			},
			see_histFilter: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_histFilter', newVal);
					that.model.saveCurrDefaultValues('see_histFilter');
					that.model.seeHistFilterUpdated(true);
					return;
				}
				return that.model.currentDefault()['see_histFilter'];
			},
			see_detailsPatient: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_detailsPatient', newVal);
					that.model.saveCurrDefaultValues('see_detailsPatient');
					return;
				}
				return that.model.currentDefault()['see_detailsPatient'];
			},
			see_showIMC: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_showIMC', newVal);
					that.model.saveCurrDefaultValues('see_showIMC');
					return;
				}
				return that.model.currentDefault()['see_showIMC'];
			},
			see_doNotShowDx: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_doNotShowDx', newVal);
					that.model.saveCurrDefaultValues('see_doNotShowDx');
					return;
				}
				return that.model.currentDefault()['see_doNotShowDx'];
			},
			see_doNotShowEve: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_doNotShowEve', newVal);
					that.model.saveCurrDefaultValues('see_doNotShowEve');
					return;
				}
				return that.model.currentDefault()['see_doNotShowEve'];
			},
			see_doNotShowES: function(newVal) {
				if (arguments.length) {
					if (newVal===true && that.model.currentDefault()['see_dateEntree']===true) {
						that.model.setCurrDefaultValues('see_dateEntree', false);
						that.model.saveCurrDefaultValues('see_dateEntree');						
					}
					that.model.setCurrDefaultValues('see_doNotShowES', newVal);
					that.model.saveCurrDefaultValues('see_doNotShowES');
					return;
				}
				return that.model.currentDefault()['see_doNotShowES'];
			},
			see_dateEntree: function(newVal) {
				if (arguments.length) {
					if (newVal===true && that.model.currentDefault()['see_doNotShowES']===true) {
						that.model.setCurrDefaultValues('see_doNotShowES', false);
						that.model.saveCurrDefaultValues('see_doNotShowES');						
					}
					that.model.setCurrDefaultValues('see_dateEntree', newVal);
					that.model.saveCurrDefaultValues('see_dateEntree');
					return;
				}
				return that.model.currentDefault()['see_dateEntree'];
			},
			see_lastDx: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_lastDx', newVal);
					that.model.saveCurrDefaultValues('see_lastDx');
					return;
				}
				return that.model.currentDefault()['see_lastDx'];
			},
			autoContexte: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('autoContexte', newVal);
					that.model.saveCurrDefaultValues('autoContexte');
					return;
				}
				return that.model.currentDefault()['autoContexte'];
			},
			codePlusLibre: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('codePlusLibre', newVal);
					that.model.saveCurrDefaultValues('codePlusLibre');
					return;
				}
				return that.model.currentDefault()['codePlusLibre'];
			},
			see_dhdInterAutreMd: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_dhdInterAutreMd', newVal);
					that.model.saveCurrDefaultValues('see_dhdInterAutreMd');
					return;
				}
				return that.model.currentDefault()['see_dhdInterAutreMd'];
			},
			see_dhPerTrav: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_dhPerTrav', newVal);
					that.model.saveCurrDefaultValues('see_dhPerTrav');
					return;
				}
				return that.model.currentDefault()['see_dhPerTrav'];
			},
			see_indFactAssDr: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_indFactAssDr', newVal);
					that.model.saveCurrDefaultValues('see_indFactAssDr');
					return;
				}
				return that.model.currentDefault()['see_indFactAssDr'];
			},
			see_tabStopDate: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_tabStopDate', newVal);
					that.model.saveCurrDefaultValues('see_tabStopDate');
					return;
				}
				return that.model.currentDefault()['see_tabStopDate'];
			},
			see_tabStopRole: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_tabStopRole', newVal);
					that.model.saveCurrDefaultValues('see_tabStopRole');
					return;
				}
				return that.model.currentDefault()['see_tabStopRole'];
			},
			copyDateServNewLineServ: function(newVal) {
				if (arguments.length) {
					if (newVal===true && that.model.currentDefault()['copyDateServPlusNewLineServ']===true) {
						that.model.setCurrDefaultValues('copyDateServPlusNewLineServ', false);
						that.model.saveCurrDefaultValues('copyDateServPlusNewLineServ');						
					}
					that.model.setCurrDefaultValues('copyDateServNewLineServ', newVal);
					that.model.saveCurrDefaultValues('copyDateServNewLineServ');
					return;
				}
				return that.model.currentDefault()['copyDateServNewLineServ'];
			},
			copyDateServPlusNewLineServ: function(newVal) {
				if (arguments.length) {
					if (newVal===true && that.model.currentDefault()['copyDateServNewLineServ']===true) {
						that.model.setCurrDefaultValues('copyDateServNewLineServ', false);
						that.model.saveCurrDefaultValues('copyDateServNewLineServ');						
					}
					that.model.setCurrDefaultValues('copyDateServPlusNewLineServ', newVal);
					that.model.saveCurrDefaultValues('copyDateServPlusNewLineServ');
					return;
				}
				return that.model.currentDefault()['copyDateServPlusNewLineServ'];
			},
			copyCodeNewLineServ: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('copyCodeNewLineServ', newVal);
					that.model.saveCurrDefaultValues('copyCodeNewLineServ');
					return;
				}
				return that.model.currentDefault()['copyCodeNewLineServ'];
			},
			copyRoleNewLineServ: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('copyRoleNewLineServ', newVal);
					that.model.saveCurrDefaultValues('copyRoleNewLineServ');
					return;
				}
				return that.model.currentDefault()['copyRoleNewLineServ'];
			},
			copyDHreNewLineServ: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('copyDHreNewLineServ', newVal);
					that.model.saveCurrDefaultValues('copyDHreNewLineServ');
					return;
				}
				return that.model.currentDefault()['copyDHreNewLineServ'];
			},
			copyElCxNewLineServ: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('copyElCxNewLineServ', newVal);
					that.model.saveCurrDefaultValues('copyElCxNewLineServ');
					return;
				}
				return that.model.currentDefault()['copyElCxNewLineServ'];
			},
			autoInsertCtx1810: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('autoInsertCtx1810', newVal);
					that.model.saveCurrDefaultValues('autoInsertCtx1810');
					return;
				}
				return that.model.currentDefault()['autoInsertCtx1810'];
			},
			copyMdRefNewLineServ: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('copyMdRefNewLineServ', newVal);
					that.model.saveCurrDefaultValues('copyMdRefNewLineServ');
					return;
				}
				return that.model.currentDefault()['copyMdRefNewLineServ'];
			},
			copyMdRefNewFact: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('copyMdRefNewFact', newVal);
					that.model.saveCurrDefaultValues('copyMdRefNewFact');
					return;
				}
				return that.model.currentDefault()['copyMdRefNewFact'];
			},
			canDelAnyBill: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('canDelAnyBill', newVal);
					return;
				}
				return that.model.currentDefault()['canDelAnyBill'];
			},
			allowOfysBilling: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('allowOfysBilling', newVal);
					that.model.saveCurrDefaultValues('allowOfysBilling');
					return;
				}
				return that.model.currentDefault()['allowOfysBilling'];
			},
			see_lstMesur: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_lstMesur', newVal);
					that.model.saveCurrDefaultValues('see_lstMesur');
					return;
				}
				return that.model.currentDefault()['see_lstMesur'];
			},
			see_dhdElmFact: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_dhdElmFact', newVal);
					that.model.saveCurrDefaultValues('see_dhdElmFact');
					return;
				}
				return that.model.currentDefault()['see_dhdElmFact'];
			},
			see_lstFactContx: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_lstFactContx', newVal);
					that.model.saveCurrDefaultValues('see_lstFactContx');
					return;
				}
				return that.model.currentDefault()['see_lstFactContx'];
			},
			see_mntPrcuPatnt: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_mntPrcuPatnt', newVal);
					that.model.saveCurrDefaultValues('see_mntPrcuPatnt');
					return;
				}
				return that.model.currentDefault()['see_mntPrcuPatnt'];
			},
			see_codOmim: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_codOmim', newVal);
					that.model.saveCurrDefaultValues('see_codOmim');
					return;
				}
				return that.model.currentDefault()['see_codOmim'];
			},
			see_lieuRef: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_lieuRef', newVal);
					that.model.saveCurrDefaultValues('see_lieuRef');
					return;
				}
				return that.model.currentDefault()['see_lieuRef'];
			},
			see_refreAutreProf: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_refreAutreProf', newVal);
					that.model.saveCurrDefaultValues('see_refreAutreProf');
					return;
				}
				return that.model.currentDefault()['see_refreAutreProf'];
			},
			see_noAutor: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_noAutor', newVal);
					that.model.saveCurrDefaultValues('see_noAutor');
					return;
				}
				return that.model.currentDefault()['see_noAutor'];
			},
			see_codPreciSectActiv: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_codPreciSectActiv', newVal);
					that.model.saveCurrDefaultValues('see_codPreciSectActiv');
					return;
				}
				return that.model.currentDefault()['see_codPreciSectActiv'];
			},
			see_localGere: function(newVal) {
				if (arguments.length) {
					that.model.setCurrDefaultValues('see_localGere', newVal);
					that.model.saveCurrDefaultValues('see_localGere');
					return;
				}
				return that.model.currentDefault()['see_localGere'];
			},
			is_soir_nuit: function(newVal) {
				if (arguments.length) {
//					if (newVal===true && that.model.currentDefault()['is_nuit']===true) {
//						that.model.setCurrDefaultValues('is_nuit', false);
//						that.model.saveCurrDefaultValues('is_nuit');						
//					}
					that.model.setCurrDefaultValues('is_soir_nuit', newVal);
					that.model.saveCurrDefaultValues('is_soir_nuit');
					return;
				}
				return that.model.currentDefault()['is_soir_nuit'];
			},
//			is_nuit: function(newVal) {
//				if (arguments.length) {
//					if (newVal===true && that.model.currentDefault()['is_soir']===true) {
//						that.model.setCurrDefaultValues('is_soir', false);
//						that.model.saveCurrDefaultValues('is_soir');						
//					}
//					that.model.setCurrDefaultValues('is_nuit', newVal);
//					that.model.saveCurrDefaultValues('is_nuit');
//					return;
//				}
//				return that.model.currentDefault()['is_nuit'];
//			}
		};
		
		that.saveReady = function() {
			var v = that.model.currentDemForListe().ready ? 1 : 0;
			that.model.saveCurrDemForListValue("ready", v, true);
		};
		
		that.saveModeManuel = function() {
			var v = that.model.currentDemForListe().mm ? 1 : 0;
			that.model.saveCurrDemForListValue("mm", v, true);
		};
		
		hotkeys.add({
		    combo: 'alt+n',
		    description: 'Ajouter une facture',
		    allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
		    callback: function(event, hotkey) {
		    	event.preventDefault();
		    	if (!that.model.forbidAddBill()) {
		    		that.addBill();		    		
		    	}
		    }
		  });
		
		hotkeys.add({
			combo: 'alt+m',
			description: 'Ajouter une facture avec les prochaines données DMÉ partagées',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				if (!that.model.forbidAddSharedBill()) {
					that.addSharedBill();		    		
				}
			}
		});
		
		hotkeys.add({
			combo: 'alt+e',
			description: 'Enregistrer la facture',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			action: 'keydown',
			callback: function(event, hotkey) {
				event.preventDefault();
				that.saveBill();
			}
		});
		
		$scope.copyBillWithPtDxDates = 0;
		hotkeys.add({
			combo: 'alt+c',
			description: 'Copier la facture',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
		    	if (!that.model.forbidAddBill()) {
					$scope.copyBillWithPtDxDates = 1;
					that.copyBill();
		    	}
			}
		});
		
		hotkeys.add({
			combo: 'alt+v',
			description: 'Copier la facture sans les informations du patient, du diagnostic, ou des dates liées',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
		    	if (!that.model.forbidAddBill()) {
					$scope.copyBillWithPtDxDates = 0;
					that.copyBill();
		    	}
			}
		});
		
		hotkeys.add({
			combo: 'alt+f',
			description: 'Filtre des factures',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			action: 'keydown',
			callback: function(event, hotkey) {
				event.preventDefault();
				$scope.billListFilter = !$scope.billListFilter;
				$scope.filterPopover.open();
			}
		});
		
		$scope.$watch(
			function (scope) {return scope.model.savedBillOk().val;},
			function(newVal, oldVal, scope) {
				if (that.model.calledAddBill()) {
					that.model.calledAddBill(false);
					doAddBill();
				} else if (that.model.calledCopyBill()) {
					that.model.calledCopyBill(false);
					doCopyBill();
				}
			}
		);
		
		that.addBill = function() {
			$scope.focusOnAddBill(true);
			if (that.model.isDirty()) {
				that.model.calledAddBill(true);
				that.saveBill();
			} else {
				that.model.calledAddBill(false);
				doAddBill();
			}			
		};

		that.addSharedBill = function() {
			$scope.focusOnAddBill(true);
			if (that.model.isDirty()) {
				that.model.calledAddBill(true);
				that.saveBill();
			} else {
				that.model.calledAddBill(false);
				// TODO il faut prendre les données dans la queue au serveur.
				// doAddBill();
			}			
		};
		
		that.copyBill = function() {
			$scope.focusOnCopyBill(true);
			if (that.model.isDirty()) {
				that.model.calledCopyBill(true);
				that.saveBill();
			} else {
				that.model.calledCopyBill(false);
				doCopyBill();
			}			
		};
		
		function doAddBill() {
			that.model.calledAddBill(false);
			if (!that.model.isDirty()) {
	        	that.model.setCurrDemForListe({}, true);
	        	that.model.setCurrDemPaimt({}, true);
				var idClientUid = {'u': clientUid};
				$http({method : "GET",
					url : "/syra/demPaimt/getNew?u=" + clientUid
				}).then(function mySucces(response) {
					var dp = that.model.validateDemPaimtServMdcal(response.data);
					that.model.currentDemListe().put(dp.demForListe.tag, dp.demForListe);
					that.model.setCurrDemForListe(dp.demForListe, true); // true pr dire que new - donc pas besoin de faire un post.
					that.model.setCurrDemPaimt(dp, true);	// pour dire que nouvelle - donc prendra les val def pour serv et depl
					that.model.demRecev(dp.recev);
					delete dp.demForListe;
					that.model.currDemListeUpdated(true);
					that.model.demListeShowSelected(true);
					that.model.setDirtyStatus(dp, true);
					$timeout(function(){that.model.firstFocus();},100);
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
			}
		}

		function doCopyBill() {
			that.model.calledCopyBill(false);
			if (!that.model.isDirty()) {
	        	that.model.setCurrDemForListe({}, true);
	        	that.model.setCurrDemPaimt({}, true);
				var idClientUid = {'u': clientUid};
				// si copyBillWi.. ==1, copy aussi pt dx dates
				$http({method : "GET",
					url : "/syra/demPaimt/getCopy?t=" + $scope.copyBillWithPtDxDates +"&u=" + clientUid
				}).then(function mySucces(response) {
					var dp = that.model.validateDemPaimtServMdcal(response.data);
					if (dp.type==1 && $scope.copyBillWithPtDxDates==1)  {
						var p = [];
						var sv = dp.serv;
						Object.keys(sv.mapTempPatients).forEach(function(key) {
						    p.push(sv.mapTempPatients[key]);
						});
						var pArr = "";
						for (var o in p) {
							var ptIdent = that.model.getIdent(p[o], p[o].fn);
							pArr = pArr.length==0 ? ptIdent : pArr + '; ' + ptIdent;
						}
						dp.demForListe.pt = pArr;
					}
					
					that.model.currentDemListe().put(dp.demForListe.tag, dp.demForListe);
					that.model.setCurrDemForListe(dp.demForListe, true); // true pr dire que new - donc pas besoin de faire un post.
					that.model.setCurrDemPaimt(dp, true);	// pour dire que nouvelle - donc prendra les val def pour serv et depl
					that.model.demRecev(dp.recev);
					delete dp.demForListe;
					that.model.currDemListeUpdated(true);
					that.model.demListeShowSelected(true);
					that.model.setDirtyStatus(dp, true);
					if (that.model.currentDemPaimt().serv && that.model.currentDemPaimt().serv.noFactExt && that.model.currentDemPaimt().serv.lstPatients.size()==0) {
						// pas de patient, il vaut mieux setter focus ailleurs
						$timeout(function(){that.model.focusOnCode();},100);
					} else {
						$timeout(function(){that.model.firstFocus();},100);
					}
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
			}
		}
		
		this.saveBill = function() {
			if (that.model.canSaveBill()) {
				that.model.saveBill();
			}
		};
		
		this.isBillValid = function isBillValid() {
			return that.model.canSaveBill();
		};
		
		this.isBillSelectedAndReceived = function() {
			return !$.isEmptyObject(that.model.currentDemForListe()) && (that.model.demRecev().staRecev&1)!=1;
		};
		
		this.isBillSelected = function() {
			return !$.isEmptyObject(that.model.currentDemForListe());
		};
		
		this.cancelModifBill = function() {
			that.model.cancelModifBill();
		};
		
//		var pgwFav = false;
//		var pgwPref = false;
//		var pgwPrint = false;
		
		that.prefer = function(){
			$scope.inscriptionOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "lg",
				resolve: {
					mObject: function () {
						return {
							title: "Favoris - Listes par professionnel",
							templateUrl:"/syra/preferences?u=' + clientUid"
						};
					}
				}
			});
			$scope.modalInstance.closed.then(function () {
				var msg = {};
				msg.err = 'Problème lors de la sauvegarde des favoris';
				msg.succes = 'Sauvegarde des favoris réussie';
				var action = "/syra/pref/save_all";
				$http({url: action,
				async: true,
				params: {u: clientUid}
				}).then(function successCallback(response) {
					var resp = response.data;
					if ($.isArray(resp)) {
						if (resp[0]) {
							jNotice(resp[0], 'red');							
						} else {
							jNotice(resp, 'red');
						}
					} else if (resp==1) {
						if (msg.succes) {
							jNotice(msg.succes, 'green');
						}
					} else if (resp==0) {
						if (msg.aucun) {
							jNotice(msg.aucun, 'green');
						}
					} else if (resp==2) {
						// err dans la sauvegarde
						jNotice(msg.err, 'red');
					}
				  }, function errorCallback(response) {
				    // called asynchronously if an error occurs
				    // or server returns response with an error status.
				  });
	        });
			$scope.modalInstance.result.then(function () {
				$scope.inscriptionOpened = false;
	        }, function () {
	            $scope.inscriptionOpened = false;
	        });	
		};
		
		this.settings = function(){
			$scope.pgwModelOpen = {};
			$scope.pgwModelOpen.pref = true;
			$.pgwModal({
			    url: '/syra/Resources/views/settings.html',
			    loadingContent: '<span style="text-align:center">Chargement des données</span>',
			    maxWidth: $(window).width() * .8,
			    angular: true,
			    closeOnEscape : false,
			    closeOnBackgroundClick : false,
			    title: 'Préférences'
			});
		};
		
		this.sommaire = function(){
			$scope.inscriptionOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "lg",
				resolve: {
					mObject: function () {
						return {
							title: "Sommaires",
							templateUrl:"/syra/Resources/views/sommaire.html"
						};
					}
				}
			});

			$scope.modalInstance.result.then(function () {
				$scope.inscriptionOpened = false;
	        }, function () {
	            $scope.inscriptionOpened = false;
	        });	
		};
		
		this.concil = function(){
//			that.model.message("Fonctionnalité à venir", 'blue');
//			return;
			$scope.inscriptionOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "lg",
				resolve: {
					mObject: function () {
						return {
							title: "Conciliation des paiements",
							templateUrl:"/syra/Resources/views/concil.html"
						};
					}
				}
			});
			
			$scope.modalInstance.result.then(function () {
				$scope.inscriptionOpened = false;
			}, function () {
				$scope.inscriptionOpened = false;
			});	
		};
		
		this.help = function(u) {
			var url = "http://ofys.ca/ofys_aide/fr/" + u;
			if (typeof openHelp === "function") { 
				openHelp(url);
			    // safe to use the function
			} else {
				$window.open(url, url);				
			}
		};
		
		this.aide_dist = function() {
			that.model.httpPost("/syra/aide_dist/post", JSON.stringify({}), null, null);
		};
		
		this.open_billet = function() {
			var url = "http://medoffice.ca/osticket/open.php?topicId=14";
			if (typeof openHelp === "function") { 
				openHelp(url);
				// safe to use the function
			} else {
				$window.open(url, url);				
			}
		};
		
        var BASE64_MARKER = ';base64,';
        
        function convertDataURIToBinary(dataURI) {
        	var base64Index = dataURI.indexOf(BASE64_MARKER) + BASE64_MARKER.length;
        	var base64 = dataURI.substring(base64Index);
        	var raw = window.atob(base64);
        	var rawLength = raw.length;
        	var array = new Uint8Array(new ArrayBuffer(rawLength));
        	
        	for(var i = 0; i < rawLength; i++) {
        		array[i] = raw.charCodeAt(i);
        	}
        	return array;
        }
        
        $scope.modalInst = {};
        $scope.inscriptionOp = {};
        function onPdfExport(doc, binarydoc, noprof){ 
			$scope.inscriptionOp[noprof] = true;
			that.dataLoading = false;
			$scope.modalInst[noprof] = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "lg",
				resolve: {
					mObject: function () {
						return {
							title: "Professionnel no: " + noprof,
							templateUrl:"/syra/Resources/views/pdfviewer.html",
							doc: binarydoc
						};
					}
				}
			});

			$scope.modalInst[noprof].result.then(function () {
				$scope.inscriptionOp[noprof] = false;
				showProfBill();
	        }, function () {
	            $scope.inscriptionOp[noprof] = false;
	            showProfBill();
	        });
        }
        var pbillIndex = 0;
        var docDefs = [];
        function showProfBill(){
        	if(pbillIndex < docDefs.length ){
        		var docDef = docDefs[pbillIndex];
        		pdfMake.createPdf(docDef).getDataUrl(function(encodedString){
        			var pdfAsArray = convertDataURIToBinary(encodedString);
        			onPdfExport(encodedString, pdfAsArray, docDef.noDocprof);
        			pbillIndex++;
        		});
        	}
        }
        
		this.printSummaryBill = function(){
			var idClientUid = {'u': clientUid};
			$http({method : "GET",
				url : "/syra/demListeSummaryToPrint/get?u=" + clientUid
			}).then(function mySucces(response) {
				//Get the complete list to print
				var data = response.data;
				that.model.sumBillForPrint(data);
				var profs = [];
				$scope.nomProf = {};
				for (var property in data) {
					if (data.hasOwnProperty(property)) {
						profs.push(property);
						// pour setter nomProf
						var row2 = data[property];
						for (var property2 in row2) {
							$scope.nomProf[property] = row2[property2][0].nomp;
							break;
						}
					}
				}	
				pbillIndex = 0;
				docDefs = [];
				profs.forEach(function (noprof) {
					var row = data[noprof];
					$scope.rowMntPrelTotal = 0;
					$scope.rowNbServTotal = 0;
					var docDef = {
							noDocprof: noprof,
							pageSize: 'LETTER',
							pageOrientation: 'portrait',
							pageMargins: [80, 40, 80, 40],
							pageBreakBefore: function(currentNode, followingNodesOnPage, nodesOnNextPage, previousNodesOnPage) {
								if (currentNode.id) {
									return currentNode.id === 'mediaRow' && currentNode.pageNumbers.length > 1;										
								}
								return false;
							},
							content: [
							         {columns: [{text: "Dr " + $scope.nomProf[noprof] + " (" +noprof+")", width: '*', style: 'header', alignment:'left'},
							                    {text: 'Généré le ' + moment().format('YYYY-MM-DD à HH:mm'), width: '*', style: 'header', alignment:'right' }]},
							          sumAllTableBody(row, ['c1', 'c2', 'c3', 'c4']),
							          {columns: [
							                     {text: "Nombre de services: " + $scope.rowNbServTotal, width: '*', style: 'totaux', alignment:'left'},
							                     {text: "Total préliminaire: " + $filter('currency')($scope.rowMntPrelTotal), width: '*', style:'totaux', alignment:'right'}
							                     ]}
							  ],
		                     styles: {
		                    	 titreHeader: {
		                    		 fontSize:12,
		                    		 bold:true,
		                    		 margin:[20, 20, 20, 0]
		                    	 },
		                    	 header: {
		                    		 fontSize:10,
		                    		 bold:true,
		                    		 margin:[0, 0, 0, 10]
		                    	 },
		                    	 subheader: {
		                    		 fontSize:11,
		                    		 bold: true,
		                    		 margin:[0, 10, 0, 5]
		                    	 },
		                    	 totaux: {
		                    		 fontSize:10,
		                    		 bold:true,
		                    		 margin:[0, 2, 0, 5]
		                    	 },
		                    	 rowNo: {
			                    	 fontSize:9,
			                    	 margin:[0, 0, 0, 0]  		
			                     },
		                    	 footer: {
		                    		 fontSize:12,
		                    		 bold: true,
		                    		 margin:[20, 20, 20, 20]
		                    	 },
		                    	 tableHeader: {
		                    		 bold: true,
		                    		 fontSize:10,
		                    		 color:'black'
					    		}
		                     },
		                     defaultStyle: {
		                    	 alignment: 'left',
		                    	 fontSize: 9,
		                    	 margin: [20, 15, 20, 15]						    		
		                     },
		                     footer: function(currentPage, pageCount) { 
		                    	 return {columns: [
		                    	                   {text: currentPage.toString() + ' de ' + pageCount, width: '*', style: 'footer', alignment:'right' }
		                    	                   ]};
		                     },
		                     header: function(currentPage, pageCount) {
		                    	 return {text: "Sommaire des services transmis à la RAMQ", width: '*', style: 'titreHeader', alignment:'center'}
		                     ;
		                     }
					};
					docDefs.push(docDef);
				});
				showProfBill();
			}, function myError(response) {
				$scope.myWelcome = response.statusText;
			});
		};
		
		this.printBill = function(){
			var idClientUid = {'u': clientUid};
			$http({method : "GET",
				url : "/syra/demListeToPrint/get?u=" + clientUid
			}).then(function mySucces(response) {
				//Get the complete list to print
				var data = response.data;
				that.model.demListeForPrint(data);
				var len = 0;
				var profs = [];
				for (var property in data) {
				    if (data.hasOwnProperty(property)) {
				    	profs.push(property);
				    	var item = data[property];
				    	len += item.length;
				    }
				}				
				if (len>0) {
					pbillIndex = 0;
					docDefs = [];
					profs.forEach(function (noprof) {
						var row = data[noprof];
						$scope.rowMntTotal = 0;
						$scope.factureAnnulees = 0;
						$scope.factureTotal = 0;
						$scope.rowGrpAdm = [];
						$scope.rowTotGrpAdm = {};
						var docDef = {
								noDocprof: noprof,
								pageSize: 'LETTER',
								pageOrientation: 'portrait',
								pageMargins: [ 20, 50, 20, 40],
								pageBreakBefore: function(currentNode, followingNodesOnPage, nodesOnNextPage, previousNodesOnPage) {
									if (currentNode.id) {
										return currentNode.id === 'mediaRow' && currentNode.pageNumbers.length > 1;										
									}
									return false;
							    },
								content: [
								        tableBody(row, ['c1', 'c2', 'c3']),
							    	    {columns: [
			    	                      {text: "Nombre de factures: " + $scope.factureTotal + ($scope.factureAnnulees>0 ? " (" + $scope.factureAnnulees + " annulée" + ($scope.factureAnnulees>1 ? "s":"") + ")":""), style: 'totaux', alignment:'left' },
			    	                      {text: "Total préliminaire: " + $filter('currency')($scope.rowMntTotal), style:'totaux', alignment:'right'}
				                      ]},
				                      getTotauxGrpAdm()
								],
						      	styles: {
						    		header: {
						    			fontSize: 14,
						    			bold: true,
						    			margin: [20, 20, 20, 20]
						    		},
						    		subheader: {
						    			fontSize: 12,
						    			bold: true,
						    			margin: [0, 10, 0, 5]
						    		},
						    		totaux: {
						    			fontSize: 12,
						    			bold: true,
						    			margin: [0, 5, 30, 0]
						    		},
						    		rowNo: {
						    			noWrap: true,
						    			fontSize: 8,
						    			margin: [0, 0, 0, 0]
						    		},
						    		footer: {
						    			fontSize: 12,
						    			bold: true,
						    			margin: [20, 20, 20, 30]
						    		},
						    		tableBody: {
						    			fontSize: 8,
						    			margin: [0, 5, 0, 5]
						    		},
						    		tableMedServ: {
							    		alignment: 'left',
						    			fontSize: 8,
						    			margin: [0, 0, 0, 0]
						    		},
						    		tableHeader: {
						    			bold: true,
						    			fontSize: 8,
						    			color: 'black'
						    		}
						    	},
						    	defaultStyle: {
						    		alignment: 'left',
						    		fontSize: 8,
					    			margin: [0, 5, 0, 5]						    		
						    	},
						    	footer: function(currentPage, pageCount) { 
						    	    return {columns: [
						    	                      {text: "No: " + noprof, style: 'footer', alignment:'left' },
								                      {text: currentPage.toString() + ' de ' + pageCount, style: 'footer', alignment:'right' }
								                      ]};
						    	},
						    	header: function(currentPage, pageCount) {
						    	    return {columns: [ 
								                      {text: getProfName(row, noprof), style: 'header', alignment:'left'},
								                      {text: 'Généré le ' + moment().format('YYYY-MM-DD à HH:mm'), style: 'header', alignment:'right' }]};
						    	 }
						};
						docDefs.push(docDef);
					});
					showProfBill();
				}
				
			}, function myError(response) {
				$scope.myWelcome = response.statusText;
			});
		};
		
		function getProfName(row, noprof) {
	      	  var r1 = row[0];	// c'set sur qu'il y a au moins une row
	      	  if (angular.isDefined(r1)) {
		      	  if (angular.isDefined(r1.serv)) {
		      		  if (angular.isDefined(r1.serv.prof)) {
		      			  return r1.serv.prof.lastName + " " + r1.serv.prof.firstName + " (" + r1.serv.prof.noProf +")";
		      		  }
		      	  } else if (angular.isDefined(r1.depl)) {
		      		  if (angular.isDefined(r1.depl.prof)) {
		      			  return r1.depl.prof.lastName + " " + r1.depl.prof.firstName + " (" + r1.depl.prof.noProf +")";
		      		  }
		      	  }
	      	  }
	      	  return 'No du professionnel: ' + noprof;
		}
		
		function getTotauxGrpAdm() {
			var toRet = [];
			if ($scope.rowGrpAdm.length>0) {
				$scope.rowGrpAdm.forEach(function(row) {
					toRet.push({
						columns: [
							{text: "Groupe administratif " + row +": " + $scope.rowTotGrpAdm[row].nb + " facture" + ($scope.rowTotGrpAdm[row].nb>1?"s":""), style: 'totaux', alignment:'left' },
							{text: "Total préliminaire: " + $filter('currency')($scope.rowTotGrpAdm[row].mnt), style:'totaux', alignment:'right'}
					]});
				});
			}
			return {stack: toRet};
		}
		
       function buildTableBody(data, columns) {
           var body = [];
           data.forEach(function(row) {
        	   row.total = 0;	// on va additionner ce champ dans le loop
               var dataRow = [];
               var l1 = 0;
               var l2 = 0;
               var l3 = 0;
               var col1 = [];
               var col2 = [];
               var col3 = [];
			   if (row.cModaPaimt.type===2 && row.cModaPaimt.no) {
				   var idx = _.indexOf($scope.rowGrpAdm, row.cModaPaimt.no);
				   if (idx===-1) {
					   $scope.rowGrpAdm.push(row.cModaPaimt.no);
					   $scope.rowTotGrpAdm[row.cModaPaimt.no] = {}; 
				   }
				   if (angular.isUndefined($scope.rowTotGrpAdm[row.cModaPaimt.no].nb)) {
					   $scope.rowTotGrpAdm[row.cModaPaimt.no].nb = 0; 
					   $scope.rowTotGrpAdm[row.cModaPaimt.no].mnt = 0; 
				   }
				   $scope.rowTotGrpAdm[row.cModaPaimt.no].nb++;      					   
			   }
			   columns.forEach(function(col) {
        		   if (col==='c1') {
        			   $scope.factureTotal++;
        			   var colNo = [];
        			   var grpAdm = "";
        			   if (row.cModaPaimt.type===2 && row.cModaPaimt.no) {
        				   grpAdm = " G:" + row.cModaPaimt.no;
        			   }
        			   colNo.push({text: row.cNoDemExt + grpAdm, width: 'auto', style:'rowNo', alignment:'left'});
        			   if (row.recev && row.recev.listeFactRecev && row.recev.listeFactRecev.length==1 && row.recev.listeFactRecev[0].idFactRamqRecev) {
        				   colNo.push({text:'RQ:' + row.recev.listeFactRecev[0].idFactRamqRecev.noFactRamq, width: '*', style:'rowNo', fontSize:7, alignment:'right'});
        			   }
        			   col1.push({columns: colNo});
        			   l1++;
        			   if (row.serv) {
            			   for (var p in row.serv.mapTempPatients) {
            				   var pt = row.serv.mapTempPatients[p];
            				   
            				   if ((angular.isDefined(pt.hin) && pt.hin!=null && pt.hin!='') || (angular.isDefined(pt.idPersAutre) && pt.idPersAutre!=null && pt.idPersAutre!='')) {
            					   col1.push({text: that.model.getIdent4Print(pt, pt.fn), margin: [0, 0, 0, 0]}); 
            				   } else {
            					   col1.push({text: that.model.getIdent4Print(pt, pt.fn), margin: [0, 0, 0, 0], fontSize:7});            					   
            				   }
                			   l1++;
            				   if (pt.imc) {
            					   col1.push({text: 'IMC: ' + pt.imc, margin: [15, 0, 0, 0]});
                    			   l1++;
            				   }
            				   var dx = listToCSV(pt.lstCTypDiagnMdcal, getDx);
            				   if (pt.datEvenePers) {
            					   col1.push({text: getTypEvenPers(pt.typEvenePers) + ': ' + pt.datEvenePers, margin: [15, 0, 0, 0]});
                    			   l1++;
            				   }
            				   if (pt.datEntree) {
            					   col1.push({text: 'E/S: ' + pt.datEntree + (pt.datSortie ? ' - ' + pt.datSortie : ""), margin: [15, 0, 0, 0]});
                    			   l1++;
            				   }
            				   if (dx.length>1) {
            					   col1.push({text: 'Dx: ' + dx, margin: [15, 0, 0, 0]});
                    			   l1++;
            				   }
            			   }
        			   } else if (row.depl) {
        				   // dep et arr, avec les lieux
            			   if (row.depl.lieuDep.typLocEtab === 'C') {
            				   col1.push({text: "Dép.:" + row.depl.dhDepDeplaDT + ' de ' + row.depl.lieuDep.etab.noSelectedEtab});
            				   l1++;
            			   } else if (row.depl.lieuDep.typLocEtab === 'N') {
            				   col1.push({text: "Dép.:" + row.depl.dhDepDeplaDT + ' de ' + row.depl.lieuDep.local.valCodLocal.codLocal});
            				   l1++;
            			   }
            			   if (row.depl.lieuArr.typLocEtab === 'C') {
            				   col1.push({text: "Arr.:" + row.depl.dhArrDeplaDT + ' à ' + row.depl.lieuArr.etab.noSelectedEtab});
            				   l1++;
            			   } else if (row.depl.lieuArr.typLocEtab === 'N') {
            				   col1.push({text: "Arr.:" + row.depl.dhArrDeplaDT + ' à ' + row.depl.lieuArr.local.valCodLocal.codLocal});
            				   l1++;
            			   }
        			   }
        		   } else  if (col==='c2') {
        			   if (row.demAnnu && row.demAnnu.recev && row.demAnnu.recev.staRecev===1) {
    					   col2.push({text:"* * * Facture annulée * * *"});
    					   $scope.factureAnnulees++;
        				   l2++;
        			   } else {
        				   if (row.serv) {
        					   if (row.serv.lstTempElmCx && row.serv.lstTempElmCx.length>0 && row.serv.lstTempElmCx[0].codeCtx && row.serv.lstTempElmCx[0].codeCtx.c) {
        						   col2.push("Élément(s) de contexte de fact.: " + listToCSV(row.serv.lstTempElmCx, getCxFact));
        						   l2++;
        					   }
        					   var ligneServ;
        					   if (row.serv.mapTempLigneFact && Object.keys(row.serv.mapTempLigneFact).length>0) {
        						   // je passe ici en premier pour faire la somme du mntPatn, mais j'ajoute le tableau à la fin car paraît mieu
        						   ligneServ = tableServiceMedLine(row.serv, ['L','D','R','C','M','EC','DD','DF','MR','LR','CO']);
        						   l2 += Object.keys(row.serv.mapTempLigneFact).length;
        					   }
        					   if (row.serv.mntPrcuPatnt || row.serv.indFactAssDr || row.serv.dhdInterAutreMd || row.serv.dhdPerTravProf) {
        						   col2.push(tableServiceMed(row.serv));
        						   l2 += 2;
        					   }
        					   if (typeof ligneServ !== 'undefined') {
        						   col2.push(ligneServ);
        					   }
        				   } else if (row.depl) {
        					   if (row.depl.mapTempFraisTranp) {
        						   col2.push(tableFraisTrspLine(row.depl));
        						   l2 += Object.keys(row.depl.mapTempFraisTranp).length        					   
        					   }
        					   if (row.depl.mapTempTempsDepla) {
        						   col2.push(tableTpsDeplLine(row.depl));
        						   l2 += Object.keys(row.depl.mapTempTempsDepla).length
        					   }
        					   var nbFs = 0,nbFd = 0,nbCx = 0;
        					   if (row.depl.mapTempFraisSej) {
        						   nbFs+= Object.keys(row.depl.mapTempFraisSej).length;		   
        					   }
        					   if (row.depl.mapTempForfaDepla) {
        						   nbFd+= Object.keys(row.depl.mapTempForfaDepla).length;
        					   }
        					   if (row.depl.lstTempElmCx) {
        						   nbCx+= row.depl.lstTempElmCx.length;
        					   }
        					   var nbFsFdCx = Math.max(nbFs, nbFd, nbCx);
        					   if (nbFsFdCx>0) {
        						   col2.push(tableFsFdCxLine(row.depl));
        						   l2 += nbFsFdCx;       					   
        					   }
        				   }
        				   
        				   var lstFactRecev;
        				   if (row.demModif && row.demModif.recev && row.demModif.recev.factRecev) {
        						var listeFactRecev = [1];
        						listeFactRecev[0] = row.demModif.recev.factRecev;
        					   lstFactRecev = listeFactRecev;
        				   } else if (row.recev && row.recev.listeFactRecev && row.recev.listeFactRecev.length>0) {
        					   lstFactRecev = row.recev.listeFactRecev;
        				   }
        				   if (typeof lstFactRecev!=='undefined') {
        					   row.mntPrel	= 0;	   	// on va additionner les valeurs dans le loop
        					   for (var recev in lstFactRecev) {
        						   if (lstFactRecev[recev].listeLigneFactRecev && lstFactRecev[recev].listeLigneFactRecev.length>0) {
        							   for (var factRecev in lstFactRecev[recev].listeLigneFactRecev) {
        								   row.mntPrel += lstFactRecev[recev].listeLigneFactRecev[factRecev].mntPrel;
        							   }
        						   }
        					   }
        				   }
        				   if (row.mntPrel && row.mntPrel>0) {
        					   $scope.rowMntTotal += row.mntPrel;
        					   if (row.cModaPaimt.type===2 && row.cModaPaimt.no) {
        						   $scope.rowTotGrpAdm[row.cModaPaimt.no].mnt += row.mntPrel; 
        					   }
        					   col2.push(tableDemRecev(row));
        					   l2++;
        				   }
        			   }
        			   if (l2==0){
        				   col2.push({text:' '});
        				   l2++;
        			   }

        		   } else  if (col==='c3') {
        			   if (row.serv) {
            			   if (row.serv.lieu.typLocEtab === 'C') {
            				   col3.push({text: 'Lieu: ' + row.serv.lieu.etab.noSelectedEtab});
            				   l3++;
            				   if (row.serv.lieu.etab.valSect && row.serv.lieu.etab.valSect.noSectActiv) {
            					   col3.push({text: 'Sect: ' + row.serv.lieu.etab.valSect.noSectActiv});
            					   l3++;
            				   }
            				   if (row.serv.lieu.etab.codPreciSectActiv && row.serv.lieu.etab.codPreciSectActiv!=0) {
            					   col3.push({text: $filter('codPreciSectActiv')(row.serv.lieu.etab.codPreciSectActiv)});
            					   l3++;
            				   }
            			   } else if (row.serv.lieu.typLocEtab === 'N') {
            				   col3.push({text: 'Lieu: ' + row.serv.lieu.local.valCodLocal.codLocal});
            				   l3++;
            				   if (row.serv.lieu.local.typLieuGeo) {
            					   col3.push({text: getTypLieuGeo(row.serv.lieu.local.typLieuGeo)});
            					   l3++;
            				   }
            			   }
            			   if (row.serv.lieu.codPreciLieu===true ) {
            				   col3.push({text: $filter('codPreciLieu')(row.serv.lieu.codPreciLieu)});
            				   l3++;
            			   }
        			   } else if (row.depl) {
            			   col3.push(' ');
            			   l3++;
        			   }
        		   }
               });
               var lines = Math.max(l1,l2,l3);
			   while (l1++<lines) {col1.push({text: ' '});}
			   while (l2++<lines) {col2.push({text: ' '});}
			   while (l3++<lines) {col3.push({text: ' '});}
			   dataRow.push({id:'mediaRow', stack: col1});
			   dataRow.push({id:'mediaRow', stack: col2});
			   dataRow.push({id:'mediaRow', stack: col3});
               body.push(dataRow);
           });
           return body;
       }
       
       function buildSumTableBody(data, columns, firstPass) {
    	   var body = [];
			if (firstPass) {
				body.push([{ text: 'Date', width: '*', style: 'tableHeader',alignment:'left'},
			            { text: 'Lieu', width: '*', style: 'tableHeader',alignment:'left'},
			            { text: 'Nombre', width: '*', style: 'tableHeader',alignment:'right'},
			            { text: 'Mnt prél.', width: '*', style: 'tableHeader',alignment:'right'}]);
			}
			data.totalNbServ = 0;	// on va additionner ce champ dans le loop
			data.totalMntPrel = 0;
			data.lieu = "";
    	   data.forEach(function(row) {
    		   var dataRow = [];
    		   data.lieu = row.lieu;
    		   var l1 = 0, l2 = 0, l3 = 0, l4 = 0;
    		   var col1 = [],col2 = [],col3 = [],col4 = [];
           		   columns.forEach(function(col) {
    			   if (col==='c1') {
					   col1.push({text:row.ds, width: '*', style:'rowNo',alignment:'left'});            					   
					   l1++;
    			   } else  if (col==='c2') {
					   col2.push({text:row.lieu, width: '*', style:'rowNo',alignment:'left'});            					   
					   l2++;
    			   } else  if (col==='c3') {
    				   $scope.rowNbServTotal += row.nb;
    				   data.totalNbServ += row.nb;
					   col3.push({text:row.nb+"", width: '*', style:'rowNo',alignment:'right'});            					   
					   l3++;
    			   } else  if (col==='c4') {
    				   if (angular.isDefined(row.mprl)) {
	    				   $scope.rowMntPrelTotal += row.mprl;
	    				   data.totalMntPrel += row.mprl;
						   col4.push({text:$filter('currency')(row.mprl), width: '*', style:'rowNo',alignment:'right'});            					   
						   l4++;
    				   }
    			   }
    		   });
    		   var lines = Math.max(l1,l2,l3,l4);
    		   while (l1++<lines) {col1.push({text: ' '});}
    		   while (l2++<lines) {col2.push({text: ' '});}
    		   while (l3++<lines) {col3.push({text: ' '});}
    		   while (l4++<lines) {col4.push({text: ' '});}
    		   dataRow.push({id:'mediaRow', stack: col1});
    		   dataRow.push({id:'mediaRow', stack: col2});
    		   dataRow.push({id:'mediaRow', stack: col3});
    		   dataRow.push({id:'mediaRow', stack: col4});
    		   body.push(dataRow);
    	   });
    	   var sumRow = [];
    	   sumRow.push({id:'mediaRow', stack: [{text: 'Total :', width: '*', style:'totaux',alignment:'right'}]});
    	   sumRow.push({id:'mediaRow', stack: [{text: data.lieu, width: '*', style:'totaux',alignment:'left'}]});
    	   sumRow.push({id:'mediaRow', stack: [{text: data.totalNbServ + "", width: '*', style:'totaux',alignment:'right'}]});
    	   sumRow.push({id:'mediaRow', stack: [{text: $filter('currency')(data.totalMntPrel), width: '*', style:'totaux',alignment:'right'}]});
    	   body.push(sumRow);
    	   return body;
       }
       
       function buildTableServMedLine(serv, columns) {
		   serv.mntPrcuPatnt = 0;	// on va additionner les valeurs dans le loop
    	   var data = serv.mapTempLigneFact;
    	   var dataServRow = [];
    	   for (var sc2 in data) {
               var dataRow = [];
    		   var ligne = data[sc2];
    		   if (ligne.mntPrcuPatnt && ligne.mntPrcuPatnt>0) {
    			   serv.mntPrcuPatnt += ligne.mntPrcuPatnt;
    		   }
               var col1 = [];
               var col2 = [];
               var col3 = [];
               var col4 = [];
               var col5 = [];
               var col6 = [];
               var col7 = [];
               var col8 = [];
               var col9 = [];
               var col10 = [];
               var col11 = [];
               columns.forEach(function(col) {
        		   if (col==='L') {
        			   col1.push({text: ligne.noLigne+'', fontSize:7});
        		   } else if (col==='D') {
        			   col2.push({text: ligne.dateServ, fontSize:7});
        		   } else if (col==='R') {
        			   col3.push({text: ligne.codRole+'', fontSize:7});
        		   } else if (col==='C') {
        			   col4.push({text: ligne.codFact.c+'', fontSize:7});
        		   } else if (col==='M') {
        			   col5.push({text: listToCSV(ligne.lstTempMesur , getMesure), fontSize:7});
        		   } else if (col==='EC') {
        			   col6.push({text: listToCSV(ligne.lstTempElmCx , getCx), fontSize:7});
        		   } else if (col==='DD') {
        			   if (ligne.dhdElmFact) {
        				   col7.push({text: ligne.dhdElmFact, fontSize:7});
        			   } else {
        				   col7.push(' ');
        			   }
        		   } else if (col==='DF') {
        			   if (ligne.dhfElmFact) {
        				   col8.push({text: ligne.dhfElmFact, fontSize:7});
        			   } else {
        				   col8.push(' ');
        			   }
        		   } else if (col==='MR') {
        			   var dhDem = "";
        			   if (ligne.dhDemConsult) {
        				   dhDem = "\n" + ligne.dhDemConsult.substr(2);
        			   }
        			   if (ligne.typProfRef==1 && ligne.idProfRefConnu) {
        				   col9.push({text: ligne.idProfRefConnu + dhDem, fontSize:7});
        			   } else if (ligne.typProfRef==2 && ligne.nomProfRefre) {
        				   col9.push({text: ligne.nomProfRefre + ' ' + ligne.preProfRefre + dhDem, fontSize:7});
        			   } else {
        				   col9.push(' ');
        			   }
        		   } else if (col==='LR') {
        			   if (angular.isDefined(ligne.lstTempLieuEnRef && ligne.lstTempLieuEnRef.length>0)) {
        				   var complRefreLieu = " ";
        				   if (ligne.typRefreLieu) {
        					   var textLieuEnRef = listToCSV(ligne.lstTempLieuEnRef, getLieuEnRef).trim();
        					   if (MyNamespace.helpers.isNotEmpty(textLieuEnRef)) {
        						   complRefreLieu = ligne.typRefreLieu + ":" + textLieuEnRef;        						   
        					   }
        				   }
            			   col10.push({text: complRefreLieu, fontSize:7});
    				   } else {
    					   col10.push(' ');
        			   }
        		   } else if (col==='CO') {
        			   if (ligne.codOmim) {
        				   col11.push({text: ligne.codOmim+'', fontSize:7});
        			   } else {
        				   col11.push(' ');
        			   }
        		   }
               });
			   dataRow.push(col1);
			   dataRow.push(col2);
			   dataRow.push(col3);
			   dataRow.push(col4);
			   dataRow.push(col5);
			   dataRow.push(col6);
			   dataRow.push(col7);
			   dataRow.push(col8);
			   dataRow.push(col9);
			   dataRow.push(col10);
			   dataRow.push(col11);
			   dataServRow.push(dataRow);
    	   }
	       return dataServRow;
       }
       
       function buildTableServMed(data, columns) {
    	   // il n'y a qu'un enregistrement ici
    	   // ['IA','PT','RP','SR']
    	   // dhdInterAutreMd dhdPerTravProf indFactAssDr mntPrcuPatnt
    	   var dataRow = [];
    	   var dataServRow = [];
		   var col1 = [];
		   var col2 = [];
		   var col3 = [];
		   var col4 = [];
		   columns.forEach(function(col) {
			   if (col==='IA') {
				   if (data.dhdInterAutreMd) {
					   col1.push(data.dhdInterAutreMd);
				   } else {
					   col1.push(' ');					   
				   }
			   } else if (col==='PT') {
				   if (data.dhdPerTravProf) {
					   col2.push(data.dhdPerTravProf);
				   } else {
					   col2.push(' ');					   
				   }
			   } else if (col==='RP') {
				   if (data.indFactAssDr===true) {
					   col3.push("Oui");
				   } else {
					   col3.push(' ');					   
				   }
			   } else if (col==='SR') {
				   if (data.mntPrcuPatnt && data.mntPrcuPatnt>0) {
					   col4.push($filter('currency')(data.mntPrcuPatnt));
				   } else {
					   col4.push(' ');					   
				   }
			   }
		   });
		   dataServRow.push([{ text: 'DH int autre md', style: 'tableHeader' },
		   { text: 'DH per trav.', style: 'tableHeader' },
		   { text: 'a/a dem. remb.', style: 'tableHeader' },
		   { text: 'Somme reçue', style: 'tableHeader' }]);
		   dataRow.push(col1);
		   dataRow.push(col2);
		   dataRow.push(col3);
		   dataRow.push(col4);
		   dataServRow.push(dataRow);
    	   return dataServRow;
       }

       function buildTableDemRecev(data, columns) {
    	   var dataRow = [];
    	   var dataServRow = [];
    	   var col1 = [];
    	   columns.forEach(function(col) {
    		   if (col==='R') {
    			   if (data.mntPrel) {
    				   col1.push({text: "Total préliminaire: " + $filter('currency')(data.mntPrel), width: '*', bold:'true', alignment:'right' });
    			   } else {
    				   col1.push(' ');					   
    			   }
    		   }
    	   });
    	   dataRow.push(col1);
    	   dataServRow.push(dataRow);
    	   return dataServRow;
       }
       
       function tableBody(data, columns) {
           return {
        	   style: 'tableBody',
               table: {
            	   widths: [ '23%', '68%', '9%' ],
                   body: buildTableBody(data, columns)
               },
               layout: {
					hLineWidth: function(i, node) {
						return 0.5;
					},
					vLineWidth: function(i, node) {
							return (i === 0 || i === node.table.widths.length) ? 0 : 0.5;
					},
					hLineColor: function(i, node) {
						return 'gray';
					},
					vLineColor: function(i, node) {
						return 'gray';
					},
					paddingLeft: function(i, node) { return 4; },
					paddingRight: function(i, node) { return 4; },
					paddingTop: function(i, node) { return 2; },
					paddingBottom: function(i, node) { return 2; }
               }
           };
       }
       
       function sumAllTableBody(data, columns) {
           var body = [];
			var profLieus = [];
			var lenProfLieu = 0;
			$scope.rowMntPrelTotal = 0;
			$scope.rowNbServTotal = 0;
			for (var property in data) {
				if (data.hasOwnProperty(property)) {
					profLieus.push(property);
					var item = data[property];
					lenProfLieu += item.length;
				}
			}
			if (lenProfLieu>0) {
				var firstPass = true;
				profLieus.forEach(function (profLieu) {
					var row = data[profLieu];
					body.push(sumTableBody(row, columns, firstPass));
					firstPass = false;
				});
			}
    	   return body;
       }
       
       function sumTableBody(data, columns, firstPass) {
    	   return {
    		   table: {
    			   widths: [ '30%', '20%', '20%', '30%' ],
    			   body: buildSumTableBody(data, columns, firstPass)
    		   },
    		   layout: {
					hLineWidth: function(i, node) {
						// une ligne après le titre puis une ligne de 0.5 avant la dernière ligne de chaque section de lieu.
						return  (i===1 && firstPass) ? 1.0 : i===(node.table.body.length-1) ?0.5:0;
					},
					vLineWidth: function(i, node) {
							return 0;
					},
					hLineColor: function(i, node) {
						return 'gray';
					},
					vLineColor: function(i, node) {
						return 'gray';
					},
    			   paddingLeft: function(i, node) { return 4; },
    			   paddingRight: function(i, node) { return 4; },
    			   paddingTop: function(i, node) { return 2; },
    			   paddingBottom: function(i, node) { return 2; }
    		   }
    	   };
       }
       
       function tableServiceMedLine(data) {
    	   var columns = ['L','D','R','C','M','EC','DD','DF','MR','LR','CO'];
    	   return {
    		   style: 'tableMedServ',
    		   table: {
            	   widths: ['2%','11%','2%','6%','8%','9%','17%','17%','10%','13%','5%'],
    			   body: buildTableServMedLine(data, columns)
    		   },
    		   layout: {
    			   hLineWidth: function(i, node) {return 0;},
    			   vLineWidth: function(i, node) {
    				   return (i === 0 || i === node.table.widths.length) ? 0 : 0.1;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       
       function buildTableFraisTrspLine(depl, columns) {
    	   var data = depl.mapTempFraisTranp;
    	   var dataDeplRow = [];
    	   dataDeplRow.push([{ text: 'L', style: 'tableHeader' },
		          		   { text: 'Date', style: 'tableHeader' },
		          		   { text: 'Code', style: 'tableHeader' },
		          		   { text: 'Moyen', style: 'tableHeader' },
		          		   { text: 'Km', style: 'tableHeader' },
		          		   { text: 'Frais', style: 'tableHeader' },
		          		   { text: 'Contx', style: 'tableHeader' }]);
    	   for (var sc2 in data) {
               var dataRow = [];
    		   var ligne = data[sc2];
               var col1 = [];
               var col2 = [];
               var col3 = [];
               var col4 = [];
               var col5 = [];
               var col6 = [];
               var col7 = [];
               columns.forEach(function(col) {
//            	   var columns = ['L', 'D', 'C', 'M', 'K', 'F', 'CX'];
        		   if (col==='L') {
        			   col1.push(ligne.noLigne+'');
        		   } else if (col==='D') {
        			   col2.push(ligne.dateServ);
        		   } else if (col==='C') {
        			   col3.push(ligne.idElmFact +'');
        		   } else if (col==='M') {
        			   col4.push(getMoyenTrsp(ligne.codMoyen));
        		   } else if (col==='K') {
        			   if (ligne.km) {
        				   col5.push(ligne.km + ' km');
        			   } else {
        				   col5.push(' ');        				   
        			   }
        		   } else if (col==='F') {
        			   col6.push(listToCSV(ligne.lstTempFrais, getFrais));
        		   } else if (col==='CX') {
        			   col7.push(listToCSV(ligne.lstTempElmCx , getCx));
        		   }
               });
			   dataRow.push(col1);
			   dataRow.push(col2);
			   dataRow.push(col3);
			   dataRow.push(col4);
			   dataRow.push(col5);
			   dataRow.push(col6);
			   dataRow.push(col7);
			   dataDeplRow.push(dataRow);
    	   }
	       return dataDeplRow;
       }
       
       function tableFraisTrspLine(data) {
    	   // noligne, date, code, moyen, km, frais, contx
    	   var columns = ['L', 'D', 'C', 'M', 'K', 'F', 'CX'];
    	   return {
    		   style: 'tableMedServ',
    		   table: { 
    			   headerRows:1,
    			   widths: [ '3%', '14%', '8%', '13%', '10%', '40%', '12%' ],
    			   body: buildTableFraisTrspLine(data, columns)
    		   },
    		   layout: {
					hLineWidth: function(i, node) {
						return (i === node.table.body.length) ? 0.1 : 0;
					},
    			   vLineWidth: function(i, node) {
    				   return (i === 0 || i === node.table.widths.length) ? 0 : 0.1;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       
       function buildTableTpsDeplLine(depl, columns) {
    	   var data = depl.mapTempTempsDepla;
    	   var dataDeplRow = [];
    	   // noligne, date, code, moyen, kmAller, kmRetour, HreAttente, HreDepl, contx
    	   dataDeplRow.push([{ text: 'L', style: 'tableHeader' },
			          		 { text: 'Date', style: 'tableHeader' },
			          		 { text: 'Code', style: 'tableHeader' },
			          		 { text: 'Moyen', style: 'tableHeader' },
			          		 { text: 'Km aller', style: 'tableHeader' },
			          		 { text: 'Km retour', style: 'tableHeader' },
			          		 { text: 'H attente', style: 'tableHeader' },
			          		 { text: 'H déplac.', style: 'tableHeader' },
			          		 { text: 'Contx', style: 'tableHeader' }]);
    	   for (var sc2 in data) {
    		   var dataRow = [];
    		   var ligne = data[sc2];
    		   var col1 = [];
    		   var col2 = [];
    		   var col3 = [];
    		   var col4 = [];
    		   var col5 = [];
    		   var col6 = [];
    		   var col7 = [];
    		   var col8 = [];
    		   var col9 = [];
    		   columns.forEach(function(col) {
    	    	   // noligne, date, code, moyen, kmAller, kmRetour, HreAttente, HreDepl, contx
//    	    	   var columns = ['L', 'D', 'C', 'M', 'KA', 'KR', 'HA', 'HD', 'CX'];
    			   if (col==='L') {
    				   col1.push(ligne.noLigne+'');
    			   } else if (col==='D') {
    				   col2.push(ligne.dateServ);
    			   } else if (col==='C') {
    				   col3.push(ligne.idElmFact +'');
    			   } else if (col==='M') {
    				   col4.push(getMoyenTrsp(ligne.codMoyen));
    			   } else if (col==='KA') {
    				   if (ligne.kmAller) {
    					   col5.push(ligne.kmAller + ' km');
    				   } else {
    					   col5.push(' ');        				   
    				   }
    			   } else if (col==='KR') {
    				   if (ligne.kmRetou) {
    					   col6.push(ligne.kmRetou + ' km');
    				   } else {
    					   col6.push(' ');        				   
    				   }
    			   } else if (col==='HA') {
    				   if (ligne.hreAtten) {
    					   col7.push(ligne.hreAtten + ' Hre');
    				   } else {
    					   col7.push(' ');        				   
    				   }
    			   } else if (col==='HD') {
    				   if (ligne.hreDepla) {
    					   col8.push(ligne.hreDepla + ' Hre');
    				   } else {
    					   col8.push(' ');        				   
    				   }
    			   } else if (col==='CX') {
    				   col9.push(listToCSV(ligne.lstTempElmCx , getCx));
    			   }
    		   });
    		   dataRow.push(col1);
    		   dataRow.push(col2);
    		   dataRow.push(col3);
    		   dataRow.push(col4);
    		   dataRow.push(col5);
    		   dataRow.push(col6);
    		   dataRow.push(col7);
    		   dataRow.push(col8);
    		   dataRow.push(col9);
    		   dataDeplRow.push(dataRow);
    	   }
    	   return dataDeplRow;
       }
       
       function tableTpsDeplLine(data) {
    	   // noligne, date, code, moyen, kmAller, kmRetour, HreAttente, HreDepl, contx
    	   var columns = ['L', 'D', 'C', 'M', 'KA', 'KR', 'HA', 'HD', 'CX'];
    	   return {
    		   style: 'tableMedServ',
    		   table: { 
    			   headerRows:1,
    			   widths: [ '3%', '14%', '8%', '13%', '12%', '12%', '12%', '12%', '14%' ],
    			   body: buildTableTpsDeplLine(data, columns)
    		   },
    		   layout: {
					hLineWidth: function(i, node) {
						return (i === node.table.body.length) ? 0.1 : 0;
					},
    			   vLineWidth: function(i, node) {
    				   return (i === 0 || i === node.table.widths.length) ? 0 : 0.1;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       
       // data = row.depl
       function buildTableFsFdCxLine(depl, columns) {
    	   var dataDeplRow = [];
		   var dataRow = [];
		   var col1 = [], col2 = [], col3 = [];
		   columns.forEach(function(col) {
			   if (col==='FS') {
				   if (depl.mapTempFraisSej) {
					   col1.push(tableFraisSejLine(depl));
				   } else {
					   col1.push(' ');					   
				   }
			   } else if (col==='FD') {
				   if (depl.mapTempForfaDepla) {
					   col2.push(tableForfaDeplaLine(depl));
				   } else {
					   col2.push(' ');					   
				   }
			   } else if (col==='CX') {
				   if (depl.lstTempElmCx) {
					   col3.push(tableElmCxLine(depl));
				   } else {
					   col3.push(' ');					   
				   }
			   }
		   });
		   dataRow.push(col1);
		   dataRow.push(col2);
		   dataRow.push(col3);
		   dataDeplRow.push(dataRow);
    	   return dataDeplRow;
       }
       function tableFsFdCxLine(data) {
    	   var columns = ['FS', 'FD', 'CX'];
    	   return {
    		   style: 'tableMedServ',
    		   table: { 
    			   widths: [ '56%', '35%', '9%'],
    			   body: buildTableFsFdCxLine(data, columns)
    		   },
    		   layout: {
    			   hLineWidth: function(i, node) {
    				   return 0;
    			   },
    			   vLineWidth: function(i, node) {
    				   return (i === 0 || i === node.table.widths.length) ? 0 : 1;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       
       function buildTableFraisSejLine(depl, columns) {
    	   var data = depl.mapTempFraisSej;
    	   var dataDeplRow = [];
    	   // noligne, date, code, type, montant, contx
    	   dataDeplRow.push([{ text: 'L', style: 'tableHeader' },
    	                     { text: 'Date', style: 'tableHeader' },
    	                     { text: 'Code', style: 'tableHeader' },
    	                     { text: 'Type', style: 'tableHeader' },
    	                     { text: 'Mnt', style: 'tableHeader' },
    	                     { text: 'Contx', style: 'tableHeader' }]);
    	   for (var sc2 in data) {
    		   var dataRow = [];
    		   var ligne = data[sc2];
    		   var col1 = [];
    		   var col2 = [];
    		   var col3 = [];
    		   var col4 = [];
    		   var col5 = [];
    		   var col6 = [];
    		   columns.forEach(function(col) {
//    	    	   var columns = ['L', 'D', 'C', 'T', 'M' 'CX'];
    			   if (col==='L') {
    				   col1.push(ligne.noLigne+'');
    			   } else if (col==='D') {
    				   col2.push(ligne.dateServ);
    			   } else if (col==='C') {
    				   col3.push(ligne.idElmFact +'');
    			   } else if (col==='T') {
    				   col4.push(getFraisSej(ligne.frais.type));
    			   } else if (col==='M') {
    				   if (ligne.frais.mnt) {
    					   col5.push($filter('currency')(ligne.frais.mnt));
    				   } else {
    					   col5.push(' ');        				   
    				   }
    			   } else if (col==='CX') {
    				   col6.push(listToCSV(ligne.lstTempElmCx , getCx));
    			   }
    		   });
    		   dataRow.push(col1);
    		   dataRow.push(col2);
    		   dataRow.push(col3);
    		   dataRow.push(col4);
    		   dataRow.push(col5);
    		   dataRow.push(col6);
    		   dataDeplRow.push(dataRow);
    	   }
    	   return dataDeplRow;
       }
       function tableFraisSejLine(data) {
    	   // noligne, date, code, type, montant, contx
    	   var columns = ['L', 'D', 'C', 'T', 'M', 'CX'];
    	   return {
    		   style: 'tableMedServ',
    		   table: { 
    			   headerRows:1,
    			   widths: [ '6%', '25%', '16%', '17%', '20%', '16%'],
    			   body: buildTableFraisSejLine(data, columns)
    		   },
    		   layout: {
    			   hLineWidth: function(i, node) {
    				   return 0;
    			   },
    			   vLineWidth: function(i, node) {
    				   return (i === 0 || i === node.table.widths.length) ? 0 : 0.1;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       
       function buildTableForfaDeplaLine(depl, columns) {
    	   var data = depl.mapTempForfaDepla;
    	   var dataDeplRow = [];
    	   // noligne, date, code, type, montant, contx
    	   dataDeplRow.push([{ text: 'L', style: 'tableHeader' },
    	                     { text: 'Date', style: 'tableHeader' },
    	                     { text: 'Code', style: 'tableHeader' },
    	                     { text: 'Contx', style: 'tableHeader' }]);
    	   for (var sc2 in data) {
    		   var dataRow = [];
    		   var ligne = data[sc2];
    		   var col1 = [];
    		   var col2 = [];
    		   var col3 = [];
    		   var col4 = [];
    		   columns.forEach(function(col) {
//    	    	   var columns = ['L', 'D', 'C', 'CX'];
    			   if (col==='L') {
    				   col1.push(ligne.noLigne+'');
    			   } else if (col==='D') {
    				   col2.push(ligne.dateServ);
    			   } else if (col==='C') {
    				   col3.push(ligne.idElmFact +'');
    			   } else if (col==='CX') {
    				   col4.push(listToCSV(ligne.lstTempElmCx , getCx));
    			   }
    		   });
    		   dataRow.push(col1);
    		   dataRow.push(col2);
    		   dataRow.push(col3);
    		   dataRow.push(col4);
    		   dataDeplRow.push(dataRow);
    	   }
    	   return dataDeplRow;
       }
       function tableForfaDeplaLine(data) {
    	   // noligne, date, code, type, montant, contx
    	   var columns = ['L', 'D', 'C', 'CX'];
    	   return {
    		   style: 'tableMedServ',
    		   table: { 
    			   headerRows:1,
    			   widths: [ '10%', '39%', '26%', '25%'],
    			   body: buildTableForfaDeplaLine(data, columns)
    		   },
    		   layout: {
    			   hLineWidth: function(i, node) {
    				   return 0;
    			   },
    			   vLineWidth: function(i, node) {
    				   return (i === 0 || i === node.table.widths.length) ? 0 : 0.1;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       function buildTableElmCxLine(depl, columns) {
    	   var data = depl.lstTempElmCx;
    	   var dataDeplRow = [];
    	   dataDeplRow.push([{ text: 'Cx Fact', style: 'tableHeader' }]);
    	   for (var sc2 in data) {
    		   var dataRow = [];
    		   var ligne = data[sc2];
    		   var col1 = [];
    		   columns.forEach(function(col) {
    			   if (col==='CX') {
    				   col1.push(ligne.c);
    			   }
    		   });
    		   dataRow.push(col1);
    		   dataDeplRow.push(dataRow);
    	   }
    	   return dataDeplRow;
       }
       function tableElmCxLine(data) {
    	   var columns = ['CX'];
    	   return {
    		   style: 'tableMedServ',
    		   table: { 
    			   headerRows:1,
    			   widths: ['100%'],
    			   body: buildTableElmCxLine(data, columns)
    		   },
    		   layout: {
    			   hLineWidth: function(i, node) {
    				   return 0;
    			   },
    			   vLineWidth: function(i, node) {
    				   return (i === 0 || i === node.table.widths.length) ? 0 : 0.1;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       
       function tableServiceMed(data) {
    	   // col : dh interv autre md, dh per trav., a/a dem rembours. bénér., Somme reçue du patient
    	   return {
    		   style: 'tableMedServ',
    		   table: {
    			   headerRows:1,
    			   widths: [ '25%' , '25%' , '25%' , '25%' ],
    			   body: buildTableServMed(data, ['IA','PT','RP','SR'])
    		   },
    		   layout: {
					hLineWidth: function(i, node) {
						return (i === node.table.body.length) ? 0.1 : 0;
					},
    			   vLineWidth: function(i, node) {
    				   return (i === 0 || i === node.table.widths.length) ? 0 : 0.1;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       function tableDemRecev(data) {
    	   // col : dh interv autre md, dh per trav., a/a dem rembours. bénér., Somme reçue du patient
    	   return {
    		   style: 'tableMedServ',
    		   table: {
    			   headerRows:1,
    			   widths: [ '100%' ],
    			   body: buildTableDemRecev(data, ['R'])
    		   },
    		   layout: {
    			   hLineWidth: function(i, node) {
    				   return (i === 0) ? 0.1 : 0;
    			   },
    			   vLineWidth: function(i, node) {
    				   return 0;
    			   },
    			   paddingLeft: function(i, node) {return 1;},
    			   paddingRight: function(i, node) {return 1;},
    			   paddingTop: function(i, node) {return 0;},
    			   paddingBottom: function(i, node) {return 0;}
    		   }
    	   };
       }
       
       function getTypLieuGeo(t) {
    	   if ('C'===t) {
    		   return 'Cabinet';
    	   } else if ('D'===t) {
    		   return 'Domicile';
    	   } else if ('A'===t) {
    		   return 'Autre';
    	   } else if ('I'===t) {
    		   return 'Inconnu';
    	   } else {
    		   return ' ';
    	   }
       }
       function getMoyenTrsp(t) {
    	   if (1===t) {
    		   return "autobus";
    	   } else if (2===t) {
    		   return "covoiturage";
    	   } else if (3===t) {
    		   return "taxi";
    	   } else if (4===t) {
    		   return "train";
    	   } else if (5===t) {
    		   return "traversier";
    	   } else if (6===t) {
    		   return "véh. loué";
    	   } else if (7===t) {
    		   return "véh. pers.";
    	   } else if (8===t) {
    		   return "vol comm.";
    	   } else if (9===t) {
    		   return "vol pers.";
    	   } else if (10===t) {
    		   return "vol nol.";
    	   } else if (99===t) {
    		   return "autre";
    	   } else {
    		   return ' ';
    	   }
       }
       function getFraisType(t) {
   		if ('1'===t) {
    		   return "loc.";
    	   } else if ('2'===t) {
    		   return "ess.";
    	   } else if ('3'===t) {
    		   return "stat.";
    	   } else if ('4'===t) {
    		   return "gén.";
    	   } else if ('99'===t) {
    		   return "autre";
    	   } else {
    		   return ' ';
    	   }
       }
       function getFraisSej(t) {
    	   if ('5'===t) {
    		   return "hôtel";
    	   } else {
    		   return ' ';
    	   }
       }
       
       function getDx(i){return i.code;}
		function getCx(i){return i.c;}
		function getFrais(i){
			var r = " ";
			if (i.type) {
				r = getFraisType(i.type);
			}
			if (i.mnt) {
				r += ':' + $filter('currency')(i.mnt);	
			}
			return r;
		}
		function getMesure(i){
			var r = "";
			if (i.val) {
				r = i.val;
			}
			if (i.unit) {
				r += ' ' + i.unit;	
			}
			return r;
		}
		function getCxFact(i){
			var r = "";
			if (i.codeCtx) {
				r = i.codeCtx.c;
			}
			if (i.codeLie) {
				r += ':' + i.codeLie;	
			}
			return r;
		}
		function getLieuEnRef(i){
			var r = "";
		   if (i.typLocEtab=='C' && i.etab  && i.etab.noSelectedEtab) {
			   var noSect = "";
			   if (i.etab.valSect.noSectActiv) {
				   noSect = "-" + i.etab.valSect.noSectActiv;
			   }
			   var codPresAct = "";
			   if (i.etab.codPreciSectActiv && i.etab.codPreciSectActiv!=0) {
				   codPresAct = " " + i.etab.codPreciSectActiv;
			   }
			   var codPresLieu = "";
			   if (i.etab.codPreciLieu && i.etab.codPreciLieu!='0') {
				   codPresLieu = " " + i.etab.codPreciLieu;
			   }
			   r = i.etab.noSelectedEtab + noSect + codPresAct + codPresLieu;
		   } else if (i.typLocEtab=='N' && i.local  && i.local.valCodLocal && i.local.valCodLocal.codLocal) {
			   var typLieuGeo = "";
			   if (i.local.typLieuGeo) {
				   typLieuGeo = i.local.typLieuGeo + " ";
			   }
			   var typIdLieuGeo = "";
			   if (i.local.typIdLieuGeo) {
				   typLieuGeo = i.local.typIdLieuGeo + " ";
			   }
			   var codPresLieu = "";
			   if (i.local.codPreciLieu && i.local.codPreciLieu!='0') {
				   codPresLieu = " " + i.local.codPreciLieu;
			   }
			   r = typLieuGeo + typIdLieuGeo + i.local.valCodLocal.codLocal + codPresLieu;
		   }
			return r;
		}
		function listToCSV(lst, getVal){
			var res = "";
			if (angular.isDefined(lst)) {
				for(var i = 0; i < lst.length; i++){
					res += getVal(lst[i]) +", ";
				}
				if(res.length >= 2){
					res = res.substring(0, res.length-2);
				}
			}
			if (res.length==0) {
				res = ' ';
			}
			return res;
		};
		
		function getTypEvenPers(input) {
			if(input == 1)return 'CSST';
			if(input == 2)return 'DDM';
			if(input == 3)return 'DPA';
			return '';
		}
		
       
		this.printBillOff = function(){
			$scope.inscriptionOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "lg",
				resolve: {
					mObject: function () {
						return {
							title: "Impression",
							templateUrl:"/syra/Resources/views/print.html"
						};
					}
				}
			});

			$scope.modalInstance.result.then(function () {
				$scope.inscriptionOpened = false;
	        }, function () {
	            $scope.inscriptionOpened = false;
	        });	
		};
		
		this.canDeleteBill = function canDeleteBill() {
			return that.model.currentDemForListe().sr&1 != 1 && that.model.currentDemForListe().sr&2 != 2;
		};
		
		$(document).bind('PgwModal::Close', function() {
			//$log.log("pgwModal close");
			var msg = {};
			var action;
			if ($scope.pgwModelOpen.pref) {
				action = "/syra/pref/save_all";
				msg.succes = 'Sauvegarde des préférences réussie';
//				msg.aucun = 'Aucune modification des préférences';
				msg.err = 'Problème lors de la sauvegarde des préférences';	
			}
			$scope.pgwModelOpen = {};
			if (action) {	// donc on a un call à faire - ici, c'est save_all
				$http({url: action,
					async: true,
					params: {u: clientUid}
					}).then(function successCallback(response) {
						var resp = response.data;
						if ($.isArray(resp)) {
							if (resp[0]) {
								jNotice(resp[0], 'red');							
							} else {
								jNotice(resp, 'red');
							}
						} else if (resp==1) {
							if (msg.succes) {
								jNotice(msg.succes, 'green');
							}
						} else if (resp==0) {
							if (msg.aucun) {
								jNotice(msg.aucun, 'green');
							}
						} else if (resp==2) {
							// err dans la sauvegarde
							jNotice(msg.err, 'red');
						}
					  }, function errorCallback(response) {
					    // called asynchronously if an error occurs
					    // or server returns response with an error status.
					  });
			}
		});
		
		function jNotice(msg, color, otherTime){
			var autoClose = 1700;
			if (angular.isDefined(otherTime)) {
				autoClose = otherTime;
			}
			new jBox('Notice', {
				color : color,
			    content: msg,
			    autoClose: autoClose,
			    position : {x: 'right', y: 'bottom'},
			    offset: {x: -10, y: -5},
			    reposition : true
			});
		}

	}]);

	angular.module('datetimeboot', ['datetimepicker'])
	.config(['datetimepickerProvider',
				function (datetimepickerProvider) {
					datetimepickerProvider.setOptions({
						locale: 'fr',
						format: 'YYYY-MM-DD HH:mm'
					});
				}
			]);
})();
