/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public final class ZipUnzip {
    private static boolean clean = true;

    public static boolean zip(String zipfile, String[] filesToZip) {
        int compressionLevel = 8;
        try {
            String element;
            String zipName = zipfile;
            FileUtils.deleteQuietly((File)new File(zipfile));
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipName));
            zip.setMethod(8);
            zip.setLevel(8);
            String[] stringArray = filesToZip;
            int n = filesToZip.length;
            int n2 = 0;
            while (n2 < n) {
                element = stringArray[n2];
                File file = new File(element);
                FileInputStream in = new FileInputStream(file);
                byte[] bytes = new byte[in.available()];
                in.read(bytes);
                in.close();
                ZipEntry entry = new ZipEntry(file.getName());
                entry.setTime(file.lastModified());
                zip.putNextEntry(entry);
                zip.write(bytes);
                zip.closeEntry();
                ++n2;
            }
            zip.close();
            stringArray = filesToZip;
            n = filesToZip.length;
            n2 = 0;
            while (n2 < n) {
                element = stringArray[n2];
                if (clean) {
                    FileUtils.deleteQuietly((File)new File(element));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static List<String> unZip(String zipFile, String destination, boolean returnOnlyFileName) throws Exception {
        if (!new File(zipFile).exists()) {
            throw new Exception("Can't open " + zipFile);
        }
        ArrayList<String> lstFile = new ArrayList<String>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(zipFile);
        }
        catch (IOException e1) {
            return null;
        }
        try {
            try {
                int BUFFER = 8192;
                BufferedOutputStream dest = null;
                BufferedInputStream is = null;
                String dir = destination;
                if (dir.charAt(dir.length() - 1) != '/') {
                    dir = String.valueOf(dir) + "/";
                }
                Enumeration<? extends ZipEntry> zipEnum = zf.entries();
                while (zipEnum.hasMoreElements()) {
                    int count;
                    File parentFile;
                    ZipEntry item = zipEnum.nextElement();
                    if (item.isDirectory()) {
                        File newdir = new File(String.valueOf(dir) + item.getName());
                        System.out.print("Creating directory " + newdir + "... ");
                        newdir.mkdirs();
                        System.out.println("Done!");
                        continue;
                    }
                    if (item.getSize() == 0L) {
                        System.out.println(String.valueOf(item.getName()) + " = 0 ");
                        continue;
                    }
                    String filename = item.getName();
                    filename = filename.replace('/', File.separatorChar);
                    File destFile = new File(String.valueOf(dir) + filename);
                    if (destFile.exists()) {
                        System.out.println("..overwriting " + dir + filename);
                        destFile.delete();
                    }
                    System.out.println("..writing " + dir + filename);
                    String parent = destFile.getParent();
                    if (parent != null && !(parentFile = new File(parent)).exists()) {
                        parentFile.mkdirs();
                    }
                    String newfile = String.valueOf(dir) + item.getName();
                    System.out.print("Writing " + newfile + "... ");
                    is = new BufferedInputStream(zf.getInputStream(item));
                    int remaining = (int)item.getSize();
                    byte[] data = new byte[8192];
                    FileOutputStream fos = new FileOutputStream(String.valueOf(dir) + item.getName());
                    dest = new BufferedOutputStream(fos, Math.min(8192, remaining));
                    while (remaining > 0 && (count = is.read(data, 0, Math.min(8192, remaining))) != -1) {
                        dest.write(data, 0, count);
                        remaining -= count;
                    }
                    dest.flush();
                    dest.close();
                    is.close();
                    fos.close();
                    lstFile.add(String.valueOf(returnOnlyFileName ? "" : dir) + item.getName());
                    System.out.println("Done!");
                }
                zf.close();
            }
            catch (Exception e) {
                System.err.println("ERREUR: " + zipFile + " -> " + destination);
                System.err.println(e);
                throw e;
            }
        }
        finally {
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        return lstFile;
    }

    public static boolean ZipIt(String zipfile, String[] filesToZip) {
        try {
            Deflater compressor = new Deflater(9, true);
            String[] stringArray = filesToZip;
            int n = filesToZip.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                File file = new File(element);
                FileInputStream in = new FileInputStream(file);
                byte[] bytes = new byte[in.available()];
                in.read(bytes);
                in.close();
                compressor.setInput(bytes);
                compressor.finish();
                ZipEntry entry = new ZipEntry(file.getName());
                entry.setTime(file.lastModified());
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

