/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.syra.handlers.PrefixFileLogHandler;
import ca.infodata.syra.models.CDemAnnuRecev;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CDemForListe;
import ca.infodata.syra.models.CDemModifRecev;
import ca.infodata.syra.models.CDemPaimtRecev;
import ca.infodata.syra.models.IdentSyra;
import ca.infodata.syra.services.ActiverIdMachineCriteria;
import ca.infodata.syra.services.ActiverIdMachineService;
import ca.infodata.syra.services.GenererIdMachineCriteria;
import ca.infodata.syra.services.GenererIdMachineResult;
import ca.infodata.syra.services.GenererIdMachineService;
import ca.infodata.syra.services.GereEchgElctrB2BCriteria;
import ca.infodata.syra.services.GereEchgElctrB2BResult;
import ca.infodata.syra.services.GereEchgElctrB2BService;
import ca.infodata.syra.services.ObtenirFichValidCriteria;
import ca.infodata.syra.services.ObtenirFichValidResult;
import ca.infodata.syra.services.ObtenirFichValidService;
import ca.infodata.syra.services.RequestFault;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.util.JoinList;
import ca.infodata.util1.date.LocalDate;
import ca.qc.gouv.ramq.rfp.DemAnnu;
import ca.qc.gouv.ramq.rfp.DemAnnuRecev;
import ca.qc.gouv.ramq.rfp.DemModif;
import ca.qc.gouv.ramq.rfp.DemModifRecev;
import ca.qc.gouv.ramq.rfp.DemPaimt;
import ca.qc.gouv.ramq.rfp.DemPaimtRecev;
import ca.qc.gouv.ramq.rfp.IdFactRamqRecev;
import ca.qc.gouv.ramq.rfp.TypDemRecev;
import ca.qc.gouv.ramq.rfp.TypFact;
import ca.qc.gouv.ramq.rfp.TypLigneFactRecev;
import ca.qc.gouv.ramq.rfp.TypMsgExplRecev;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.ws.handler.Handler;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Open;
import org.basex.core.parse.Commands;
import org.eclipse.core.runtime.Platform;

public class ValidRamq {
    boolean runTest = false;
    static boolean isDebug = false;
    static boolean isParte = false;
    static boolean showLogs;
    public static boolean isUpdating;
    private ObtenirFichValidService service;
    private static final String dbname = "ramq_valid";
    public static String stopWords;
    private static ValidRamq instance;
    private Context context = null;
    private boolean test = false;
    protected static String[] fileAideToAdd;

    static {
        try {
            isDebug = Platform.inDebugMode();
            isParte = Platform.inDebugMode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        showLogs = true;
        isUpdating = false;
        stopWords = "stop_words.fr";
        fileAideToAdd = new String[]{"codediagnostic", "codefacturation_omnipraticien", "codefacturation_specialiste", "codelocalite", "elementcontexte_omnipraticien", "elementcontexte_specialiste", "infoetablissement", "messageexplicatif_omnipraticien", "messageexplicatif_specialiste", "secteuractivite_omnipraticien", "secteuractivite_specialiste"};
    }

    public static ValidRamq getInstance() throws IOException {
        if (isUpdating) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (instance == null) {
            System.setProperty("javax.net.debug", "none");
            instance = new ValidRamq();
            instance.openRamqValid();
        }
        return instance;
    }

    private ValidRamq() {
        if (this.context == null) {
            this.context = new Context();
        }
    }

    private void openRamqValid() throws IOException {
        this.dbOpen(dbname);
    }

    public Status generIdMach(String userId, String password, String noInterv) throws Exception {
        if (this.test) {
            Thread.sleep(5000L);
            Status status = new Status(IStatus.Severity.OK, "");
            IdentSyra identB2b = new IdentSyra();
            identB2b.syra_idMach = "AGR16147B";
            identB2b.syra_idMachPswd = "01U&zDG4kdS";
            identB2b.syra_idMachPswdDate = String.valueOf(LocalDate.today().formatHyphen()) + "T12:00:00";
            status.setData((Serializable)identB2b);
            SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
            globalSettings.set("syra_idMach", (Object)identB2b.syra_idMach);
            globalSettings.set("syra_idMachPswd", (Object)identB2b.syra_idMachPswd);
            globalSettings.set("syra_idMachPswdDate", (Object)identB2b.syra_idMachPswdDate);
            return status;
        }
        Status status = this.gener(userId, password, noInterv);
        if (status.isOK()) {
            GenererIdMachineResult result = (GenererIdMachineResult)status.getData();
            if (result == null) {
                status = new Status(IStatus.Severity.ERROR, "R\u00e9sultat null retourn\u00e9 sans message d'erreur");
            } else {
                SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
                System.out.println("new idMach " + result.getMachineId() + ", pswd " + result.getMachinePswd());
                String now = String.valueOf(LocalDate.today().formatHyphen()) + "T12:00:00";
                globalSettings.set("syra_idMach", (Object)result.getMachineId());
                globalSettings.set("syra_idMachPswd", (Object)result.getMachinePswd());
                globalSettings.set("syra_idMachPswdDate", (Object)now);
                IdentSyra identB2b = new IdentSyra();
                identB2b.syra_idMach = result.getMachineId();
                identB2b.syra_idMachPswd = result.getMachinePswd();
                identB2b.syra_idMachPswdDate = now;
                status.setData((Serializable)identB2b);
            }
        }
        return status;
    }

    private Status gener(String userId, String password, String noInterv) throws Exception {
        Status status = new Status(IStatus.Severity.OK, "");
        List<Handler> lstHandler = new ArrayList<Handler>();
        if (isParte || showLogs) {
            lstHandler = PrefixFileLogHandler.create(String.valueOf(ObtenirFichValidService.userHomeBaseX) + "/logb2b", "GenererIdMachine", true);
        }
        String endpointAddress = "https://www4.prod.ramq.gouv.qc.ca/TIP/OP/OPY_InscSuspAgenc/OPY1_ServGenerIdMachn_svc/ServGenerIdMachn.svc";
        if (isParte) {
            endpointAddress = "https://www4.parte.ramq.gouv.qc.ca/TIP/OP/OPY_InscSuspAgenc/OPY1_ServGenerIdMachn_svc/ServGenerIdMachn.svc";
        }
        GenererIdMachineService service = new GenererIdMachineService(lstHandler, endpointAddress);
        GenererIdMachineCriteria criteria = new GenererIdMachineCriteria(userId, password, noInterv);
        Transaction<GenererIdMachineCriteria, GenererIdMachineResult> call = service.generer(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        String errMsg = "";
        if (call.getFaults().size() > 0) {
            System.out.println(faults);
            for (RequestFault flts : call.getFaults()) {
                errMsg = String.valueOf(errMsg) + flts.getMessage();
                if (flts.getThrowable() != null && flts.getThrowable().getCause() != null) {
                    errMsg = String.valueOf(errMsg) + ": " + flts.getThrowable().getCause().getMessage();
                }
                errMsg = String.valueOf(errMsg) + "\n";
            }
        }
        if (errMsg.length() > 0) {
            status = new Status(IStatus.Severity.ERROR, errMsg);
        } else {
            status.setData((Serializable)call.getResult());
        }
        return status;
    }

    public Status renewIdMach(String machineId, String password, String noInterv) throws Exception {
        if (this.test) {
            Thread.sleep(5000L);
            Status status = new Status(IStatus.Severity.OK, "");
            IdentSyra identB2b = new IdentSyra();
            identB2b.syra_idMachPswd = "01U&zDG4kdS";
            identB2b.syra_idMachPswdDate = String.valueOf(LocalDate.today().formatHyphen()) + "T12:00:00";
            status.setData((Serializable)identB2b);
            SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
            globalSettings.set("syra_idMachPswd", (Object)identB2b.syra_idMachPswd);
            globalSettings.set("syra_idMachPswdDate", (Object)identB2b.syra_idMachPswdDate);
            return status;
        }
        Status status = this.renew(machineId, password, noInterv);
        if (status.isOK()) {
            String newPswd = (String)((Object)status.getData());
            System.out.println("new password " + newPswd);
            SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
            globalSettings.set("syra_idMachPswd", (Object)newPswd);
            String now = String.valueOf(LocalDate.today().formatHyphen()) + "T12:00:00";
            globalSettings.set("syra_idMachPswdDate", (Object)now);
            IdentSyra identB2b = new IdentSyra();
            identB2b.syra_idMachPswd = newPswd;
            identB2b.syra_idMachPswdDate = now;
            status.setData((Serializable)identB2b);
        }
        return status;
    }

    private Status renew(String machineId, String password, String noInterv) throws Exception {
        Status status = new Status(IStatus.Severity.OK, "");
        List<Handler> lstHandler = new ArrayList<Handler>();
        if (isParte || showLogs) {
            lstHandler = PrefixFileLogHandler.create(String.valueOf(ObtenirFichValidService.userHomeBaseX) + "/logb2b", "ActiverIdMachine", true);
        }
        String endpointAddress = "https://www4.prod.ramq.gouv.qc.ca/TIP/OP/OPY_InscSuspAgenc/OPY1_ServActivIdMachn_svc/ServActivIdMachn.svc";
        if (isParte) {
            endpointAddress = "https://www4.parte.ramq.gouv.qc.ca/TIP/OP/OPY_InscSuspAgenc/OPY1_ServActivIdMachn_svc/ServActivIdMachn.svc";
        }
        ActiverIdMachineService service = new ActiverIdMachineService(lstHandler, endpointAddress);
        ActiverIdMachineCriteria criteria = new ActiverIdMachineCriteria(machineId, password, noInterv);
        Transaction<ActiverIdMachineCriteria, String> call = service.renew(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        String errMsg = "";
        if (call.getFaults().size() > 0) {
            System.out.println(faults);
            for (RequestFault flts : call.getFaults()) {
                errMsg = String.valueOf(errMsg) + flts.getMessage();
                if (flts.getThrowable() != null && flts.getThrowable().getCause() != null) {
                    errMsg = String.valueOf(errMsg) + ": " + flts.getThrowable().getCause().getMessage();
                }
                errMsg = String.valueOf(errMsg) + "\n";
            }
        }
        if (errMsg.length() > 0) {
            status = new Status(IStatus.Severity.ERROR, errMsg);
        } else {
            status.setData((Serializable)((Object)call.getResult()));
        }
        return status;
    }

    public Status sendDemModi(String userId, String password, CDemForListe dfl, DemModif pmt) throws Exception {
        if (this.test) {
            Thread.sleep(5000L);
            Status status = new Status(IStatus.Severity.OK, "");
            return status;
        }
        Status status = this.sendDP(userId, password, dfl, pmt);
        if (status.isOK() && status.getData() == null) {
            status = new Status(IStatus.Severity.ERROR, "R\u00e9sultat null retourn\u00e9 sans message d'erreur");
        }
        return status;
    }

    public Status sendDemAnnu(String userId, String password, CDemForListe dfl, DemAnnu pmt) throws Exception {
        if (this.test) {
            Thread.sleep(5000L);
            Status status = new Status(IStatus.Severity.OK, "");
            return status;
        }
        Status status = this.sendDP(userId, password, dfl, pmt);
        if (status.isOK() && status.getData() == null) {
            status = new Status(IStatus.Severity.ERROR, "R\u00e9sultat null retourn\u00e9 sans message d'erreur");
        }
        return status;
    }

    public Status sendDemPaimt(String userId, String password, CDemForListe dfl, DemPaimt pmt) throws Exception {
        if (this.test) {
            Thread.sleep(5000L);
            Status status = new Status(IStatus.Severity.OK, "");
            return status;
        }
        Status status = this.sendDP(userId, password, dfl, pmt);
        if (status.isOK() && status.getData() == null) {
            status = new Status(IStatus.Severity.ERROR, "R\u00e9sultat null retourn\u00e9 sans message d'erreur");
        }
        return status;
    }

    private Status sendDP(String userId, String password, CDemForListe dfl, DemModif pmt) throws Exception {
        Status status = new Status(IStatus.Severity.OK, "");
        ArrayList<Handler> lstHandler = new ArrayList<Handler>();
        if (!isParte) {
            // empty if block
        }
        String endpointAddress = "https://www4.prod.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NM/NMA_RecvrDem/NMA5_GereEchgElctrB2B_svc/ServGereEchgElctrB2B.svc";
        if (isParte) {
            endpointAddress = "https://www4.parte.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NM/NMA_RecvrDem/NMA5_GereEchgElctrB2B_svc/ServGereEchgElctrB2B.svc";
        }
        GereEchgElctrB2BService service = new GereEchgElctrB2BService(lstHandler, endpointAddress);
        GereEchgElctrB2BCriteria criteria = new GereEchgElctrB2BCriteria(userId, password, (long)dfl.getTag().intValue(), pmt);
        Transaction<GereEchgElctrB2BCriteria, GereEchgElctrB2BResult> call = service.envoyer(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        String errMsg = "";
        if (call.getFaults().size() > 0) {
            System.out.println(faults);
            for (RequestFault flts : call.getFaults()) {
                String causeMsg;
                errMsg = String.valueOf(errMsg) + flts.getMessage();
                if (flts.getThrowable() != null && flts.getThrowable().getCause() != null && (causeMsg = flts.getThrowable().getCause().getMessage()).indexOf(errMsg) == -1) {
                    errMsg = String.valueOf(errMsg) + ": " + causeMsg;
                }
                errMsg = String.valueOf(errMsg) + "\n";
            }
        }
        if (errMsg.length() > 0) {
            status = new Status(IStatus.Severity.ERROR, errMsg);
        } else {
            status.setMessage(call.getResult().getDemSorti().getResulRecev());
            URL xsdValid = Thread.currentThread().getContextClassLoader().getResource(service.pathRecevabiliteXsd);
            SchemaFactory sf1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf1.newSchema(xsdValid);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DemModifRecev.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(schema);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(call.getResult().getDemSorti().getResulRecev().getBytes(StandardCharsets.UTF_8));
            XMLStreamReader reader = inputFactory.createXMLStreamReader(inputStream);
            DemModifRecev demRecev = null;
            JAXBElement unmarshal = unmarshaller.unmarshal(reader, DemModifRecev.class);
            demRecev = (DemModifRecev)unmarshal.getValue();
            String arrayString = null;
            CDemModifRecev cDpr = null;
            if (demRecev != null) {
                arrayString = ConvertJavaToFromArray.ConvertDemModifRecev.toArrayString(demRecev);
                List<String> list = dfl.addOrSetDemModifRecev(arrayString);
                dfl.getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType.DEM_MODIF_RECEV, list, null, null);
                cDpr = new CDemModifRecev(demRecev);
                status.setData((Serializable)cDpr);
            }
            if (this.test) {
                DemModifRecev.FactRecev.ListeLigneFactRecev listeLigneFactRecev;
                DemModifRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecevLigne;
                System.out.println(arrayString);
                DemModifRecev demPaimtRecev2 = ConvertJavaToFromArray.ConvertDemModifRecev.fromArrayString(arrayString, ConvertJavaToFromArray.of.createDemModifRecev(), null);
                CDemModifRecev cDpr2 = new CDemModifRecev(demPaimtRecev2);
                String arrayString2 = ConvertJavaToFromArray.ConvertDemModifRecev.toArrayString(demPaimtRecev2);
                System.out.println(arrayString2);
                System.out.println("comparaison des arrays 1 et 2: " + arrayString.equals(arrayString2));
                if (!cDpr.equals(cDpr2)) {
                    System.out.println("comparaison des cDpr 1 et 2: " + cDpr.equals(cDpr2));
                    System.out.println("cDpr1:" + cDpr.toString());
                    System.out.println("cDpr2:" + cDpr2.toString());
                }
                String noDemExt = demRecev.getNoDemExt();
                TypDemRecev.ListeMsgExplRecev listeMsgExplRecev = demRecev.getListeMsgExplRecev();
                System.out.println("Statno=" + demRecev.getStaRecev() + ", noDemExt=" + noDemExt);
                if (listeMsgExplRecev != null && listeMsgExplRecev.getMsgExplRecev() != null) {
                    for (TypMsgExplRecev msgExpl : listeMsgExplRecev.getMsgExplRecev()) {
                        System.out.println("msgExpl:" + msgExpl.getCodMsgExplRecev() + ":" + msgExpl.getTxtMsgExplRecev());
                    }
                }
                System.out.println("* * * factRecev * * *");
                if (demRecev.getFactVersiCourn() != null) {
                    DemModifRecev.FactVersiCourn factVersiCourn = (DemModifRecev.FactVersiCourn)demRecev.getFactVersiCourn().getValue();
                    IdFactRamqRecev idFactRamqRecev = factVersiCourn.getIdFactRamqRecev();
                    if (idFactRamqRecev != null) {
                        System.out.println("NoFactRamq:" + idFactRamqRecev.getNoFactRamq() + ", idJeton:" + idFactRamqRecev.getJetonComm());
                    }
                    if (factVersiCourn.getFactBase() != null) {
                        TypFact typFact = (TypFact)factVersiCourn.getFactBase().getValue();
                        System.out.println("typFact : " + typFact.getClass().getName());
                    }
                }
                DemModifRecev.FactRecev factRecev = demRecev.getFactRecev();
                System.out.println("Statno=" + factRecev.getStaRecev());
                if (factRecev.getIdFactRamqRecev() != null) {
                    System.out.println("IdFactRamq:" + factRecev.getIdFactRamqRecev().getNoFactRamq() + ", idJeton:" + factRecev.getIdFactRamqRecev().getJetonComm());
                }
                if ((listeMsgExplRecevLigne = factRecev.getListeMsgExplRecev()) != null && listeMsgExplRecevLigne.getMsgExplRecev() != null) {
                    List<TypMsgExplRecev> msgExplRecev = listeMsgExplRecevLigne.getMsgExplRecev();
                    System.out.println("   *** listeMsgExplRecevLigne");
                    for (TypMsgExplRecev typMsgExplRecev : msgExplRecev) {
                        System.out.println(typMsgExplRecev.getCodMsgExplRecev() + ":" + typMsgExplRecev.getTxtMsgExplRecev());
                    }
                }
                if ((listeLigneFactRecev = factRecev.getListeLigneFactRecev()) != null && listeLigneFactRecev.getLigneFactRecev() != null) {
                    List<TypLigneFactRecev> lstLigneFactRecev = listeLigneFactRecev.getLigneFactRecev();
                    System.out.println("   *** typLigneFactRecev");
                    for (TypLigneFactRecev ligneRactRev : lstLigneFactRecev) {
                        System.out.println(String.valueOf(ligneRactRev.getNoLigneFact()) + ":" + ligneRactRev.getFormuExpl() + ", " + ligneRactRev.getMntPrel());
                    }
                }
            }
        }
        return status;
    }

    private Status sendDP(String userId, String password, CDemForListe dfl, DemAnnu pmt) throws Exception {
        Status status = new Status(IStatus.Severity.OK, "");
        ArrayList<Handler> lstHandler = new ArrayList<Handler>();
        if (!isParte) {
            // empty if block
        }
        String endpointAddress = "https://www4.prod.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NM/NMA_RecvrDem/NMA5_GereEchgElctrB2B_svc/ServGereEchgElctrB2B.svc";
        if (isParte) {
            endpointAddress = "https://www4.parte.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NM/NMA_RecvrDem/NMA5_GereEchgElctrB2B_svc/ServGereEchgElctrB2B.svc";
        }
        GereEchgElctrB2BService service = new GereEchgElctrB2BService(lstHandler, endpointAddress);
        GereEchgElctrB2BCriteria criteria = new GereEchgElctrB2BCriteria(userId, password, (long)dfl.getTag().intValue(), pmt);
        Transaction<GereEchgElctrB2BCriteria, GereEchgElctrB2BResult> call = service.envoyer(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        String errMsg = "";
        if (call.getFaults().size() > 0) {
            System.out.println(faults);
            for (RequestFault flts : call.getFaults()) {
                String causeMsg;
                errMsg = String.valueOf(errMsg) + flts.getMessage();
                if (flts.getThrowable() != null && flts.getThrowable().getCause() != null && (causeMsg = flts.getThrowable().getCause().getMessage()).indexOf(errMsg) == -1) {
                    errMsg = String.valueOf(errMsg) + " \n" + causeMsg;
                }
                errMsg = String.valueOf(errMsg) + "\n";
            }
        }
        if (errMsg.length() > 0) {
            status = new Status(IStatus.Severity.ERROR, errMsg);
        } else {
            URL xsdValid = Thread.currentThread().getContextClassLoader().getResource(service.pathRecevabiliteXsd);
            SchemaFactory sf1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf1.newSchema(xsdValid);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DemAnnuRecev.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(schema);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(call.getResult().getDemSorti().getResulRecev().getBytes(StandardCharsets.UTF_8));
            XMLStreamReader reader = inputFactory.createXMLStreamReader(inputStream);
            DemAnnuRecev demRecev = (DemAnnuRecev)unmarshaller.unmarshal(reader, DemAnnuRecev.class).getValue();
            String arrayString = ConvertJavaToFromArray.ConvertDemAnnuRecev.toArrayString(demRecev);
            List<String> list = dfl.addOrSetDemAnnuRecev(arrayString);
            dfl.getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType.DEM_ANNU_RECEV, list, null, null);
            CDemAnnuRecev cDpr = new CDemAnnuRecev(demRecev);
            status.setData((Serializable)cDpr);
            if (this.test) {
                System.out.println(arrayString);
                DemAnnuRecev demPaimtRecev2 = ConvertJavaToFromArray.ConvertDemAnnuRecev.fromArrayString(arrayString, ConvertJavaToFromArray.of.createDemAnnuRecev());
                CDemAnnuRecev cDpr2 = new CDemAnnuRecev(demPaimtRecev2);
                String arrayString2 = ConvertJavaToFromArray.ConvertDemAnnuRecev.toArrayString(demPaimtRecev2);
                System.out.println(arrayString2);
                System.out.println("comparaison des arrays 1 et 2: " + arrayString.equals(arrayString2));
                if (!cDpr.equals(cDpr2)) {
                    System.out.println("comparaison des cDpr 1 et 2: " + cDpr.equals(cDpr2));
                    System.out.println("cDpr1:" + cDpr.toString());
                    System.out.println("cDpr2:" + cDpr2.toString());
                }
                String noDemExt = demRecev.getNoDemExt();
                int staRecev = demRecev.getStaRecev();
                TypDemRecev.ListeMsgExplRecev listeMsgExplRecev = demRecev.getListeMsgExplRecev();
                System.out.println("Statno=" + demRecev.getStaRecev() + ", noDemExt=" + noDemExt);
                if (listeMsgExplRecev != null && listeMsgExplRecev.getMsgExplRecev() != null) {
                    for (TypMsgExplRecev msgExpl : listeMsgExplRecev.getMsgExplRecev()) {
                        System.out.println("msgExpl:" + msgExpl.getCodMsgExplRecev() + ":" + msgExpl.getTxtMsgExplRecev());
                    }
                }
                DemAnnuRecev.ListeFactRecev listeFactRecev = demRecev.getListeFactRecev();
                System.out.println("* * * factRecev * * *");
                if (listeFactRecev != null && listeFactRecev.getFactRecev() != null) {
                    for (DemAnnuRecev.ListeFactRecev.FactRecev factRecev : listeFactRecev.getFactRecev()) {
                        DemAnnuRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecevLigne = factRecev.getListeMsgExplRecev();
                        if (listeMsgExplRecevLigne != null && listeMsgExplRecevLigne.getMsgExplRecev() != null) {
                            List<TypMsgExplRecev> msgExplRecev = listeMsgExplRecevLigne.getMsgExplRecev();
                            System.out.println("   *** listeMsgExplRecevLigne");
                            for (TypMsgExplRecev typMsgExplRecev : msgExplRecev) {
                                System.out.println(typMsgExplRecev.getCodMsgExplRecev() + ":" + typMsgExplRecev.getTxtMsgExplRecev());
                            }
                        }
                        IdFactRamqRecev listeLigneFactRecev = factRecev.getIdFactRamqRecev();
                        int n = factRecev.getCodEtaTraitFact();
                    }
                }
            }
        }
        return status;
    }

    private Status sendDP(String userId, String password, CDemForListe dfl, DemPaimt pmt) throws Exception {
        Status status = new Status(IStatus.Severity.OK, "");
        ArrayList<Handler> lstHandler = new ArrayList<Handler>();
        if (!isParte) {
            // empty if block
        }
        String endpointAddress = "https://www4.prod.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NM/NMA_RecvrDem/NMA5_GereEchgElctrB2B_svc/ServGereEchgElctrB2B.svc";
        if (isParte) {
            endpointAddress = "https://www4.parte.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NM/NMA_RecvrDem/NMA5_GereEchgElctrB2B_svc/ServGereEchgElctrB2B.svc";
        }
        GereEchgElctrB2BService service = new GereEchgElctrB2BService(lstHandler, endpointAddress);
        GereEchgElctrB2BCriteria criteria = new GereEchgElctrB2BCriteria(userId, password, (long)dfl.getTag().intValue(), pmt);
        Transaction<GereEchgElctrB2BCriteria, GereEchgElctrB2BResult> call = service.envoyer(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        String errMsg = "";
        Throwable t = null;
        if (call.getFaults().size() > 0) {
            System.out.println(faults);
            int compteur = 0;
            block0: for (RequestFault flts : call.getFaults()) {
                if (t == null) {
                    t = flts.getThrowable();
                }
                errMsg = String.valueOf(errMsg) + flts.getMessage();
                Throwable th = flts.getThrowable();
                while (th != null) {
                    if (th.getCause() != null) {
                        errMsg = String.valueOf(errMsg) + th.getCause() + "\n";
                    }
                    th = th.getCause();
                    if (compteur++ > 5) continue block0;
                }
            }
        }
        if (errMsg.length() > 0) {
            status = new Status(IStatus.Severity.ERROR, errMsg, t);
        } else {
            URL xsdValid = Thread.currentThread().getContextClassLoader().getResource(service.pathRecevabiliteXsd);
            SchemaFactory sf1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf1.newSchema(xsdValid);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DemPaimtRecev.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(schema);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(call.getResult().getDemSorti().getResulRecev().getBytes(StandardCharsets.UTF_8));
            XMLStreamReader reader = inputFactory.createXMLStreamReader(inputStream);
            DemPaimtRecev demPaimtRecev = (DemPaimtRecev)unmarshaller.unmarshal(reader, DemPaimtRecev.class).getValue();
            String arrayString = ConvertJavaToFromArray.ConvertDemPaimtRecev.toArrayString(demPaimtRecev);
            List<String> list = dfl.addOrSetDemPaimtRecev(arrayString);
            dfl.getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT_RECEV, list, null, null);
            CDemPaimtRecev cDpr = new CDemPaimtRecev(demPaimtRecev);
            status.setData((Serializable)cDpr);
            if (this.test) {
                System.out.println(arrayString);
                DemPaimtRecev demPaimtRecev2 = ConvertJavaToFromArray.ConvertDemPaimtRecev.fromArrayString(arrayString, ConvertJavaToFromArray.of.createDemPaimtRecev());
                CDemPaimtRecev cDpr2 = new CDemPaimtRecev(demPaimtRecev2);
                String arrayString2 = ConvertJavaToFromArray.ConvertDemPaimtRecev.toArrayString(demPaimtRecev2);
                System.out.println(arrayString2);
                System.out.println("comparaison des arrays 1 et 2: " + arrayString.equals(arrayString2));
                if (!cDpr.equals(cDpr2)) {
                    System.out.println("comparaison des cDpr 1 et 2: " + cDpr.equals(cDpr2));
                    System.out.println("cDpr1:" + cDpr.toString());
                    System.out.println("cDpr2:" + cDpr2.toString());
                }
                String noDemExt = demPaimtRecev.getNoDemExt();
                TypDemRecev.ListeMsgExplRecev listeMsgExplRecev = demPaimtRecev.getListeMsgExplRecev();
                System.out.println("Statno=" + demPaimtRecev.getStaRecev() + ", noDemExt=" + noDemExt);
                if (listeMsgExplRecev != null && listeMsgExplRecev.getMsgExplRecev() != null) {
                    for (TypMsgExplRecev msgExpl : listeMsgExplRecev.getMsgExplRecev()) {
                        System.out.println("msgExpl:" + msgExpl.getCodMsgExplRecev() + ":" + msgExpl.getTxtMsgExplRecev());
                    }
                }
                DemPaimtRecev.ListeFactRecev listeFactRecev = demPaimtRecev.getListeFactRecev();
                System.out.println("* * * factRecev * * *");
                if (listeFactRecev != null && listeFactRecev.getFactRecev() != null) {
                    for (DemPaimtRecev.ListeFactRecev.FactRecev factRecev : listeFactRecev.getFactRecev()) {
                        DemPaimtRecev.ListeFactRecev.FactRecev.ListeLigneFactRecev listeLigneFactRecev;
                        DemPaimtRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecevLigne;
                        System.out.println("Statno=" + factRecev.getStaRecev() + ", noFactExt=" + factRecev.getNoFactExt());
                        if (factRecev.getIdFactRamqRecev() != null) {
                            System.out.println("IdFactRamq:" + factRecev.getIdFactRamqRecev().getNoFactRamq() + ", idJeton:" + factRecev.getIdFactRamqRecev().getJetonComm());
                        }
                        if ((listeMsgExplRecevLigne = factRecev.getListeMsgExplRecev()) != null && listeMsgExplRecevLigne.getMsgExplRecev() != null) {
                            List<TypMsgExplRecev> msgExplRecev = listeMsgExplRecevLigne.getMsgExplRecev();
                            System.out.println("   *** listeMsgExplRecevLigne");
                            for (TypMsgExplRecev typMsgExplRecev : msgExplRecev) {
                                System.out.println(typMsgExplRecev.getCodMsgExplRecev() + ":" + typMsgExplRecev.getTxtMsgExplRecev());
                            }
                        }
                        if ((listeLigneFactRecev = factRecev.getListeLigneFactRecev()) == null || listeLigneFactRecev.getLigneFactRecev() == null) continue;
                        List<TypLigneFactRecev> lstLigneFactRecev = listeLigneFactRecev.getLigneFactRecev();
                        System.out.println("   *** typLigneFactRecev");
                        for (TypLigneFactRecev ligneRactRev : lstLigneFactRecev) {
                            System.out.println(String.valueOf(ligneRactRev.getNoLigneFact()) + ":" + ligneRactRev.getFormuExpl() + ", " + ligneRactRev.getMntPrel());
                        }
                    }
                }
            }
        }
        return status;
    }

    public Status updateFichierAideSaisie(String userId, String userPswd, String noInterv) throws Exception {
        Status status = this.runTest ? new Status(IStatus.Severity.OK, "") : this.obtenir(userId, userPswd, noInterv);
        if (status.isOK()) {
            ObtenirFichValidResult result = null;
            ArrayList<String> lstFiles = new ArrayList<String>();
            if (this.runTest) {
                String[] files;
                String dir = "/Users/pdrolet/BaseXData/valid_xml/";
                File xmlDir = new File(dir);
                String[] stringArray = files = xmlDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String[] stringArray = fileAideToAdd;
                        int n = fileAideToAdd.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (name.toLowerCase().startsWith(s)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                });
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    lstFiles.add(String.valueOf(dir) + file);
                    ++n2;
                }
            } else {
                result = (ObtenirFichValidResult)status.getData();
                if (result != null && result.getFiles() != null && result.getFiles().size() > 0) {
                    List<String> list = result.getFiles();
                    for (String l : list) {
                        String[] stringArray = fileAideToAdd;
                        int n = fileAideToAdd.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String s = stringArray[n3];
                            if (l.toLowerCase().contains(s)) {
                                lstFiles.add(l);
                            }
                            ++n3;
                        }
                    }
                }
            }
            if (lstFiles.size() > 0) {
                String cause;
                if (result != null) {
                    System.out.println("Version des fichiers:" + result.getVersion() + "\nNom du fichier:" + result.getNomFichier());
                }
                try {
                    this.deleteDatabase();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    cause = e.getMessage();
                    if (e.getCause() != null && e.getCause().getMessage() != null) {
                        cause = String.valueOf(cause) + ". Cause: " + e.getCause().getMessage();
                    }
                    status = new Status(IStatus.Severity.ERROR, "Erreur lors de la suppression de la base de donn\u00e9es p\u00e9rim\u00e9es [" + ObtenirFichValidService.userHomeBaseX + "]. " + cause);
                    return status;
                }
                try {
                    this.createDb(dbname, lstFiles);
                    status = new Status(IStatus.Severity.OK, "");
                }
                catch (BaseXException e) {
                    e.printStackTrace();
                    cause = e.getMessage();
                    if (e.getCause() != null && e.getCause().getMessage() != null) {
                        cause = String.valueOf(cause) + ". Cause: " + e.getCause().getMessage();
                    }
                    status = new Status(IStatus.Severity.ERROR, "Erreur lors de la cr\u00e9ation de la nouvelle base de donn\u00e9es [" + ObtenirFichValidService.userHomeBaseX + "]. " + cause);
                    return status;
                }
            }
        }
        return status;
    }

    private Status obtenir(String userId, String uPswd, String noInterv) throws Exception {
        Status status = new Status(IStatus.Severity.OK, "");
        List<Handler> lstHandler = new ArrayList<Handler>();
        if (isParte || showLogs) {
            lstHandler = PrefixFileLogHandler.create(String.valueOf(ObtenirFichValidService.userHomeBaseX) + "/logb2b", "ObtenirFichierValid", true);
        }
        String endpointAddress = "https://www4.prod.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NP/NPB_GereEchgOrga/NPB4_ObtnFichValidB2B_svc/ServObtnFichValidB2B.svc";
        if (isParte) {
            endpointAddress = "https://www4.parte.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NP/NPB_GereEchgOrga/NPB4_ObtnFichValidB2B_svc/ServObtnFichValidB2B.svc";
        }
        this.service = new ObtenirFichValidService(lstHandler, endpointAddress);
        ObtenirFichValidCriteria criteria = new ObtenirFichValidCriteria(userId, uPswd, noInterv);
        Transaction<ObtenirFichValidCriteria, ObtenirFichValidResult> call = this.service.obtenir(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        String errMsg = "";
        if (call.getFaults().size() > 0) {
            System.out.println(faults);
            for (RequestFault flts : call.getFaults()) {
                errMsg = String.valueOf(errMsg) + flts.getMessage();
                if (flts.getThrowable() != null && flts.getThrowable().getCause() != null) {
                    errMsg = String.valueOf(errMsg) + ": " + flts.getThrowable().getCause().getMessage();
                }
                errMsg = String.valueOf(errMsg) + "\n";
            }
        }
        if (errMsg.length() > 0) {
            status = new Status(IStatus.Severity.ERROR, errMsg);
        } else {
            status.setData((Serializable)call.getResult());
        }
        return status;
    }

    private void dbOpen(String string) throws IOException {
        this.setContextOptions();
        System.out.print("Will try to open database " + string);
        new Open(string).execute(this.context);
        System.out.println(" -> opened");
    }

    private void dbClose(String string) throws IOException {
        System.out.print("Will try to close database " + string);
        new Close().execute(this.context);
        System.out.println(" -> closed");
    }

    public void setContextOptions() throws BaseXException {
        this.context.options.assign("STEMMING", "true");
        this.context.options.assign("FTINDEX", "true");
        this.context.options.assign("LANGUAGE", "fr");
        URL urlStopWords = Thread.currentThread().getContextClassLoader().getResource(stopWords);
        if (urlStopWords != null) {
            this.context.options.assign("STOPWORDS", urlStopWords.toExternalForm());
        }
        this.context.options.assign("INTPARSE", "true");
        this.context.options.assign("XINCLUDE", "true");
        this.context.options.assign("STRIPNS", "true");
        this.context.options.assign("CHOP", "true");
        this.context.options.assign("QUERYINFO", "false");
        this.context.options.assign("AUTOOPTIMIZE", "true");
    }

    private boolean createDb(String dbname, List<String> lstFiles) throws BaseXException {
        File dir;
        boolean ok = false;
        if ((lstFiles == null || lstFiles.isEmpty()) && (dir = new File(ObtenirFichValidService.userHomeBaseXValidXml)).exists()) {
            String[] files = dir.list();
            lstFiles = new ArrayList<String>(files.length);
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String ff = stringArray[n2];
                lstFiles.add(String.valueOf(ObtenirFichValidService.userHomeBaseXValidXml) + ff);
                ++n2;
            }
        }
        if (lstFiles != null && lstFiles.size() > 0) {
            new CreateDB(dbname).execute(this.context);
            for (String dataFile : lstFiles) {
                new Add("", dataFile).execute(this.context);
            }
            new CreateIndex((Object)Commands.CmdIndex.TEXT).execute(this.context);
            new CreateIndex((Object)Commands.CmdIndex.ATTRIBUTE).execute(this.context);
            new CreateIndex((Object)Commands.CmdIndex.TOKEN).execute(this.context);
            try {
                new CreateIndex((Object)Commands.CmdIndex.FULLTEXT).execute(this.context);
            }
            catch (BaseXException e) {
                e.printStackTrace();
                System.out.println("Continue quand m\u00eame car peut \u00eatre est MAINMEM");
            }
            ok = true;
            System.out.print(new InfoDB().execute(this.context));
        }
        return ok;
    }

    public void deleteDatabase() throws IOException {
        this.deleteDb(dbname);
    }

    private void deleteDb(String dbname2) throws IOException {
        try {
            this.dbClose(dbname2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new DropDB(dbname2).execute(this.context);
    }

    public final Context getContext() {
        return this.context;
    }

    public String getDbLocation() {
        return "";
    }
}

