/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.InfoDB;
import org.basex.core.parse.Commands;

public class OpenXmlDb {
    private final String dbname;
    private final Context context = new Context();
    private final String uid;
    private static Map<String, OpenXmlDb> instances = new HashMap<String, OpenXmlDb>();
    private final List<String> xmlFiles = new ArrayList<String>();

    public static OpenXmlDb getInstance(String uid, List<String> files) {
        OpenXmlDb oxd;
        if (instances.containsKey(uid)) {
            OpenXmlDb openXmlDb = instances.get(uid);
            Collections.sort(files, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            ListComparator<String> compare = new ListComparator<String>();
            Boolean okCompare = compare.compare(files, openXmlDb.xmlFiles);
            if (okCompare.booleanValue()) {
                return openXmlDb;
            }
            try {
                openXmlDb.dbClose();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(oxd = new OpenXmlDb(uid, files)).dbOpen()) {
            return null;
        }
        instances.put(uid, oxd);
        return oxd;
    }

    private OpenXmlDb(String uid, List<String> files) {
        this.uid = uid;
        this.xmlFiles.addAll(files);
        this.dbname = "expl_valid_" + uid;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean dbOpen() {
        try {
            this.setContextOptions();
            try {
                this.dbClose();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            try {
                new DropDB(this.dbname).execute(this.context);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            this.createDb(this.dbname, this.xmlFiles);
            return true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    private void createDb(String dbname, List<String> lstFiles) {
        if (lstFiles != null && lstFiles.size() > 0) {
            try {
                new CreateDB(dbname).execute(this.context);
                for (String dataFile : lstFiles) {
                    new Add("", dataFile).execute(this.context);
                }
                new CreateIndex((Object)Commands.CmdIndex.TEXT).execute(this.context);
                System.out.print(new InfoDB().execute(this.context));
            }
            catch (BaseXException e) {
                e.printStackTrace();
            }
        }
    }

    public void setContextOptions() throws BaseXException {
        this.context.options.assign("STEMMING", "false");
        this.context.options.assign("LANGUAGE", "fr");
        this.context.options.assign("INTPARSE", "true");
        this.context.options.assign("XINCLUDE", "true");
        this.context.options.assign("STRIPNS", "true");
        this.context.options.assign("CHOP", "true");
        this.context.options.assign("QUERYINFO", "true");
    }

    private void dbClose() throws IOException {
        System.out.print("Will try to close database " + this.dbname);
        String execute = new Close().execute(this.context);
        System.out.println(String.valueOf(execute) + " -> closed");
    }

    public String getUid() {
        return this.uid;
    }

    public static class ListComparator<T> {
        public Boolean compare(List<T> a, List<T> b) {
            if (a.size() != b.size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            while (i < a.size()) {
                if (!a.get(i).equals(b.get(i))) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }
    }
}

