/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import ca.infodata.controls.DateUtil;
import ca.infodata.ofys.util.date.LocalDate;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.commons.lang.math.NumberUtils;

public class GsonAdapters {

    public static class EmptyStringToBigDecimalTypeAdapter
    extends TypeAdapter<BigDecimal> {
        public void write(JsonWriter jsonWriter, BigDecimal number) throws IOException {
            if (number == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value((Number)number);
        }

        public BigDecimal read(JsonReader jsonReader) throws IOException {
            String value;
            block4: {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    value = jsonReader.nextString();
                    if (!"".equals(value)) break block4;
                    return null;
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException((Throwable)e);
                }
            }
            return NumberUtils.createBigDecimal((String)value);
        }
    }

    public static class EmptyStringToNumberTypeAdapter
    extends TypeAdapter<Number> {
        public void write(JsonWriter jsonWriter, Number number) throws IOException {
            if (number == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(number);
        }

        public Number read(JsonReader jsonReader) throws IOException {
            String value;
            block4: {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    value = jsonReader.nextString();
                    if (!"".equals(value)) break block4;
                    return null;
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException((Throwable)e);
                }
            }
            return NumberUtils.createNumber((String)value);
        }
    }

    public static class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        public void write(JsonWriter jsonWriter, LocalDate src) throws IOException {
            if (src == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(src.formatHyphen());
        }

        public LocalDate read(JsonReader jsonReader) throws IOException {
            String value;
            block4: {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    value = jsonReader.nextString();
                    if (!"".equals(value)) break block4;
                    return null;
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException((Throwable)e);
                }
            }
            Calendar cal = DateUtil.ctod((String)value);
            return LocalDate.fromCalendar((Calendar)cal);
        }
    }
}

