/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import ca.infodata.syra.util.JoinList;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.tempuri.erreurs_ds.ErreursDS;

public class DsMessageParser {
    private final JAXBContext jaxbContext;
    private static /* synthetic */ int[] $SWITCH_TABLE$ca$infodata$syra$util$DsMessageParser$TYPE;

    public DsMessageParser(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public String parse(String s, TYPE type) {
        try {
            ErreursDS message = this.getMessage(s);
            if (message != null) {
                return this.getMessageContent(message, type);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return s;
    }

    private String getMessageContent(ErreursDS dsMessage, TYPE type) {
        JoinList msg = new JoinList(type == TYPE.NO ? ", " : "\n");
        List<ErreursDS.ErreursDT> list = dsMessage.getErreursDT();
        for (ErreursDS.ErreursDT m : list) {
            switch (type) {
                case TEXT: {
                    msg.add(m.getErreur());
                    break;
                }
                case NO: {
                    msg.add(m.getCodeErreur());
                    break;
                }
                case NOM_FICHIER: {
                    msg.add(m.getNomFichier());
                    break;
                }
                case NO_AND_TEXT_FICHIER: {
                    String nf = m.getNomFichier() != null && m.getNomFichier().length() > 0 ? " (" + m.getNomFichier() + ")" : "";
                    msg.add(String.valueOf(m.getCodeErreur()) + nf + ": " + m.getErreur());
                }
            }
        }
        return msg.toString();
    }

    private ErreursDS getMessage(String s) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        return (ErreursDS)unmarshaller.unmarshal((Reader)new StringReader(s));
    }

    public static enum TYPE {
        NO,
        TEXT,
        NOM_FICHIER,
        NO_AND_TEXT_FICHIER;

    }
}

